/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.convert;

import com.xdja.pki.ca.certmanager.dao.models.ArchiveCertDO;
import com.xdja.pki.ca.certmanager.dao.models.OutdateCertDO;
import com.xdja.pki.ca.certmanager.service.archivecert.bean.ArchiveCertListVO;
import com.xdja.pki.ca.certmanager.service.archivecert.bean.ArchiveCertQueryDTO;
import com.xdja.pki.ca.core.util.time.DateTimeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CertConverter {
    public static ArchiveCertDO outToArchiveCert(OutdateCertDO outDateCertDO, long current) {
        ArchiveCertDO archiveCertDO = new ArchiveCertDO();
        archiveCertDO.setId(outDateCertDO.getId());
        archiveCertDO.setCaCertId(outDateCertDO.getCaCertId());
        archiveCertDO.setSn(outDateCertDO.getSn());
        archiveCertDO.setSubject(outDateCertDO.getSubject());
        archiveCertDO.setIssuer(outDateCertDO.getIssuer());
        archiveCertDO.setPublicKeyAlg(outDateCertDO.getPublicKeyAlg());
        archiveCertDO.setPrivateKeySize(outDateCertDO.getPrivateKeySize());
        archiveCertDO.setBeforeTime(outDateCertDO.getBeforeTime());
        archiveCertDO.setAfterTime(outDateCertDO.getAfterTime());
        archiveCertDO.setSignAlg(outDateCertDO.getSignAlg());
        archiveCertDO.setType(outDateCertDO.getType());
        archiveCertDO.setIsRevokeKey(outDateCertDO.getIsRevokeKey());
        archiveCertDO.setTemplateId(outDateCertDO.getTemplateId());
        archiveCertDO.setPairCertId(outDateCertDO.getPairCertId());
        archiveCertDO.setPairCertSn(outDateCertDO.getPairCertSn());
        archiveCertDO.setStatus(outDateCertDO.getStatus());
        archiveCertDO.setOldCertId(outDateCertDO.getOldCertId());
        archiveCertDO.setKeyRevokedStatus(outDateCertDO.getKeyRevokedStatus());
        archiveCertDO.setKeyNotAfterTime(outDateCertDO.getKeyNotAfterTime());
        archiveCertDO.setKeyNotBeforeTime(outDateCertDO.getKeyNotBeforeTime());
        archiveCertDO.setRevokeReason(outDateCertDO.getRevokeReason());
        archiveCertDO.setRevokeNote(outDateCertDO.getRevokeNote());
        archiveCertDO.setFrozenNum(outDateCertDO.getFrozenNum());
        archiveCertDO.setConfirmationStatus(outDateCertDO.getConfirmationStatus());
        Date date = new Date(current);
        archiveCertDO.setGmtCreate(date);
        archiveCertDO.setGmtModified(date);
        return archiveCertDO;
    }

    public static OutdateCertDO archiveToOutCert(ArchiveCertDO archiveCertDO, long current) {
        OutdateCertDO outDateCertDO = new OutdateCertDO();
        outDateCertDO.setId(archiveCertDO.getId());
        outDateCertDO.setCaCertId(archiveCertDO.getCaCertId());
        outDateCertDO.setSn(archiveCertDO.getSn());
        outDateCertDO.setSubject(archiveCertDO.getSubject());
        outDateCertDO.setIssuer(archiveCertDO.getIssuer());
        outDateCertDO.setPublicKeyAlg(archiveCertDO.getPublicKeyAlg());
        outDateCertDO.setPrivateKeySize(archiveCertDO.getPrivateKeySize());
        outDateCertDO.setBeforeTime(archiveCertDO.getBeforeTime());
        outDateCertDO.setAfterTime(archiveCertDO.getAfterTime());
        outDateCertDO.setSignAlg(archiveCertDO.getSignAlg());
        outDateCertDO.setType(archiveCertDO.getType());
        outDateCertDO.setIsRevokeKey(archiveCertDO.getIsRevokeKey());
        outDateCertDO.setTemplateId(archiveCertDO.getTemplateId());
        outDateCertDO.setPairCertId(archiveCertDO.getPairCertId());
        outDateCertDO.setPairCertSn(archiveCertDO.getPairCertSn());
        outDateCertDO.setStatus(archiveCertDO.getStatus());
        outDateCertDO.setOldCertId(archiveCertDO.getOldCertId());
        outDateCertDO.setKeyRevokedStatus(archiveCertDO.getKeyRevokedStatus());
        outDateCertDO.setKeyNotAfterTime(archiveCertDO.getKeyNotAfterTime());
        outDateCertDO.setKeyNotBeforeTime(archiveCertDO.getKeyNotBeforeTime());
        outDateCertDO.setRevokeReason(archiveCertDO.getRevokeReason());
        outDateCertDO.setRevokeNote(archiveCertDO.getRevokeNote());
        outDateCertDO.setFrozenNum(archiveCertDO.getFrozenNum());
        outDateCertDO.setConfirmationStatus(archiveCertDO.getConfirmationStatus());
        Date date = new Date(current);
        outDateCertDO.setGmtCreate(date);
        outDateCertDO.setGmtModified(date);
        return outDateCertDO;
    }

    public static List<ArchiveCertDO> outToArchiveCertList(List<OutdateCertDO> outDateCertList, long current) {
        ArrayList<ArchiveCertDO> archiveCertList = new ArrayList<ArchiveCertDO>(outDateCertList.size());
        for (OutdateCertDO certDO : outDateCertList) {
            archiveCertList.add(CertConverter.outToArchiveCert(certDO, current));
        }
        return archiveCertList;
    }

    public static ArchiveCertDO queryToArchiveDO(ArchiveCertQueryDTO query) {
        ArchiveCertDO archiveCertDO = new ArchiveCertDO();
        if (StringUtils.isNotBlank((CharSequence)query.getSubject())) {
            archiveCertDO.setSubject(query.getSubject());
        }
        if (StringUtils.isNotBlank((CharSequence)query.getSn())) {
            archiveCertDO.setSn(query.getSn());
        }
        return archiveCertDO;
    }

    public static ArchiveCertListVO dataToArchiveVO(ArchiveCertDO certDO) {
        ArchiveCertListVO archiveVO = new ArchiveCertListVO();
        archiveVO.setId(certDO.getId());
        archiveVO.setSubject(certDO.getSubject());
        switch (certDO.getType()) {
            case 2: {
                archiveVO.setSignSn(certDO.getSn());
                if (!StringUtils.isNotBlank((CharSequence)certDO.getPairCertSn())) break;
                archiveVO.setEncSn(certDO.getPairCertSn());
                break;
            }
            case 3: {
                archiveVO.setEncSn(certDO.getSn());
                if (!StringUtils.isNotBlank((CharSequence)certDO.getPairCertSn())) break;
                archiveVO.setSignSn(certDO.getPairCertSn());
                break;
            }
            default: {
                archiveVO.setSignSn(certDO.getSn());
            }
        }
        archiveVO.setType(certDO.getType());
        archiveVO.setKeyAlg(certDO.getPublicKeyAlg());
        archiveVO.setNotBeforeTime(DateTimeUtil.dateToStr((Date)certDO.getBeforeTime()));
        archiveVO.setNotAfterTime(DateTimeUtil.dateToStr((Date)certDO.getAfterTime()));
        archiveVO.setGmtCreate(DateTimeUtil.dateToStr((Date)certDO.getGmtCreate()));
        return archiveVO;
    }

    public static List<ArchiveCertListVO> dataListToArchiveVOList(List<ArchiveCertDO> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ArchiveCertListVO> list = new ArrayList<ArchiveCertListVO>(dataList.size());
        for (ArchiveCertDO certDO : dataList) {
            list.add(CertConverter.dataToArchiveVO(certDO));
        }
        return list;
    }
}

