/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.crltemplate;

import com.xdja.pki.ca.certcrl.service.impl.CrlService;
import com.xdja.pki.ca.certmanager.dao.CrlTemplateDao;
import com.xdja.pki.ca.certmanager.dao.models.CrlTemplateDO;
import com.xdja.pki.ca.certmanager.dao.models.CrlTemplateExtensionDO;
import com.xdja.pki.ca.certmanager.service.crltemplate.CrlTemplateService;
import com.xdja.pki.ca.certmanager.service.crltemplate.bean.CrlExtensionVO;
import com.xdja.pki.ca.certmanager.service.crltemplate.bean.CrlTemplateExtensionVO;
import com.xdja.pki.ca.certmanager.service.crltemplate.bean.CrlTemplateListVO;
import com.xdja.pki.ca.certmanager.service.crltemplate.bean.CrlTemplateQueryVO;
import com.xdja.pki.ca.certmanager.service.crltemplate.bean.CrlTemplateVO;
import com.xdja.pki.ca.certmanager.service.crltemplate.thread.CrlPublishThread;
import com.xdja.pki.ca.certmanager.service.crltemplate.thread.DrlPublishThread;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.CrlConstants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.configBasic.bean.DirServerConfigBean;
import com.xdja.pki.ca.core.enums.CrlPublishEnum;
import com.xdja.pki.ca.core.enums.CrlTemplateStatusEnum;
import com.xdja.pki.ca.core.enums.KeyAlgEnum;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.CrlUtil;
import com.xdja.pki.ca.core.util.time.DateTimeUtil;
import com.xdja.pki.ca.core.util.time.IssueTimeUtil;
import com.xdja.pki.ca.ldap.service.vo.LdapOcspUrlVO;
import com.xdja.pki.ca.securitymanager.dao.DicDao;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.SignAlgTypeEnum;
import com.xdja.pki.core.utils.DateUtils;
import com.xdja.pki.ldap.sdk.ca.LDAPUrlUtils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.naming.InvalidNameException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CrlTemplateServiceImpl
implements CrlTemplateService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DicDao dicDao;
    @Autowired
    private CrlTemplateDao crlTemplateDao;
    @Autowired
    private CrlService crlService;
    public static final String CRL_FORMAT = ".crl";
    public static final String CRL_NAME_HEAD = "crl";
    public static final String ARL_NAME_HEAD = "arl";
    public static final String DRL_NAME_HEAD = "drl";
    public static final String ISSUER_DRL_NAME_HEAD = "adrl";

    public Result saveCrlTemplate(CrlTemplateExtensionVO crlTemplateExtensionVO) {
        StringBuffer auditLog = new StringBuffer("");
        try {
            if (this.crlTemplateDao.checkCrlTemplateNameExist(crlTemplateExtensionVO.getCrlTempName())) {
                this.logger.error("\u4fdd\u5b58\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728 [name={}]", (Object)crlTemplateExtensionVO.getCrlTempName());
                auditLog.append("\u4fdd\u5b58\u8bc1\u4e66\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c").append("\u6a21\u677f\u540d\u79f0=").append(crlTemplateExtensionVO.getCrlTempName());
                return Result.failure((ErrorEnum)ErrorEnum.CRL_TEMPLATE_NAME_EXISTD).setAuditContent(auditLog.toString());
            }
            Integer drlPeriod = crlTemplateExtensionVO.getCrlConfig().getDrlPeriod();
            Integer crlPeriod = crlTemplateExtensionVO.getCrlConfig().getCrlPeriod();
            if (drlPeriod != null && drlPeriod > 0 && crlPeriod < drlPeriod) {
                this.logger.error("\u4fdd\u5b58crl\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u589e\u91cf\u5468\u671f\u5927\u4e8e\u5168\u91cf\u5468\u671f [name={}]", (Object)crlTemplateExtensionVO.getCrlTempName());
                auditLog.append("\u4fdd\u5b58crl\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u589e\u91cf\u5468\u671f\u5927\u4e8e\u5168\u91cf\u5468\u671f\uff0c").append("\u6a21\u677f\u540d\u79f0=").append(crlTemplateExtensionVO.getCrlTempName());
                return Result.failure((ErrorEnum)ErrorEnum.CRL_TEMPLATE_DRLPEROID_ERROR).setAuditContent(auditLog.toString());
            }
            ArrayList<String> oids = new ArrayList<String>();
            if (!CollectionUtils.isEmpty((Collection)crlTemplateExtensionVO.getCrlExtension()) && !this.checkCrlExtension(crlTemplateExtensionVO.getCrlExtension(), oids)) {
                this.logger.error("\u4fdd\u5b58crl\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u7c7b\u578b\u4e0e\u6269\u5c55\u9879\u4e0d\u5339\u914d [name={}]", (Object)crlTemplateExtensionVO.getCrlTempName());
                auditLog.append("\u4fdd\u5b58crl\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u7c7b\u578b\u4e0e\u6269\u5c55\u9879\u4e0d\u5339\u914d\uff0c").append("\u6a21\u677f\u540d\u79f0=").append(crlTemplateExtensionVO.getCrlTempName());
                return Result.failure((ErrorEnum)ErrorEnum.CRL_TEMPLATE_TYPE_AND_EXTENSION_MISMATCH).setAuditContent(auditLog.toString());
            }
            CrlTemplateDO crlTemplateDO = new CrlTemplateDO();
            BeanUtils.copyProperties((Object)crlTemplateExtensionVO.getCrlConfig(), (Object)crlTemplateDO);
            crlTemplateDO.setCrlTempName(crlTemplateExtensionVO.getCrlTempName());
            crlTemplateDO.setCrlTempDesc(crlTemplateExtensionVO.getCrlTempDesc());
            crlTemplateDO.setCertCount(Integer.valueOf(0));
            crlTemplateDO.setCrlStatus(Integer.valueOf(CrlTemplateStatusEnum.NOT_RELATION.value));
            crlTemplateDO.setGmtCreate(new Date());
            crlTemplateDO.setGmtModified(crlTemplateDO.getGmtCreate());
            this.crlTemplateDao.saveCrlTemplate(crlTemplateDO);
            Map crlExtensions = this.crlTemplateDao.getExtensionIdByOID(oids);
            ArrayList crlExtensionDOList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)crlTemplateExtensionVO.getCrlExtension())) {
                crlTemplateExtensionVO.getCrlExtension().forEach(item -> {
                    CrlTemplateExtensionDO ce = new CrlTemplateExtensionDO();
                    ce.setCrlExtenId((Long)crlExtensions.get(item.getExtenOid()));
                    ce.setCrlTempId(crlTemplateDO.getId());
                    ce.setExtenValue(item.getExtenValue());
                    ce.setIsCritical(item.getIsCritical());
                    ce.setGmtCreate(crlTemplateDO.getGmtCreate());
                    crlExtensionDOList.add(ce);
                });
                this.crlTemplateDao.saveCrlTemplateExtensions(crlExtensionDOList);
            }
            auditLog.append("\u4fdd\u5b58crl\u6a21\u677f\u6210\u529f").append("\uff0c\u6a21\u677f\u540d\u79f0=").append(crlTemplateExtensionVO.getCrlTempName());
            this.logger.info(auditLog.toString());
            return Result.success((String)auditLog.toString());
        }
        catch (Exception e) {
            throw new ServiceException("\u4fdd\u5b58crl\u6a21\u677f\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private boolean checkCrlExtension(List<CrlExtensionVO> crlExtension, List<String> oids) {
        ArrayList extensionList = new ArrayList();
        extensionList.addAll(Constants.CRL_TEMPLATE_EXTENSIONS);
        for (CrlExtensionVO item : crlExtension) {
            if (!extensionList.contains(item.getExtenOid())) {
                return false;
            }
            oids.add(item.getExtenOid());
        }
        return true;
    }

    public Result updateCrlTemplate(CrlTemplateExtensionVO crlTemplateExtensionVO) {
        StringBuffer auditLog = new StringBuffer("");
        try {
            Long id = crlTemplateExtensionVO.getCrlConfig().getId();
            StringBuilder tempAuditLog = new StringBuilder();
            tempAuditLog.append("\u6a21\u677fID=").append(id).append("\uff0c\u6a21\u677f\u540d\u79f0=").append(crlTemplateExtensionVO.getCrlTempName());
            CrlTemplateDO crlTemplateDO = this.crlTemplateDao.getCrlTemplateById(id);
            if (crlTemplateDO == null) {
                this.logger.error("\u66f4\u65b0crl\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u4e0d\u5b58\u5728 [id={}]", (Object)id);
                auditLog.append("\u66f4\u65b0crl\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u4e0d\u5b58\u5728\uff0c").append((CharSequence)tempAuditLog);
                return Result.failure((ErrorEnum)ErrorEnum.CRL_TEMPLATE_NOT_EXIST).setAuditContent(auditLog.toString());
            }
            if (!crlTemplateDO.getCrlTempName().equalsIgnoreCase(crlTemplateExtensionVO.getCrlTempName()) && this.crlTemplateDao.checkCrlTemplateNameExist(crlTemplateExtensionVO.getCrlTempName())) {
                this.logger.error("\u66f4\u65b0crl\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728 [name={}]", (Object)crlTemplateDO.getCrlTempName());
                auditLog.append("\u4fdd\u5b58crl\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c").append("\u6a21\u677f\u540d\u79f0=").append(crlTemplateDO.getCrlTempName());
                return Result.failure((ErrorEnum)ErrorEnum.CRL_TEMPLATE_NAME_EXISTD).setAuditContent(auditLog.toString());
            }
            Integer drlPeriod = crlTemplateExtensionVO.getCrlConfig().getDrlPeriod();
            Integer crlPeriod = crlTemplateExtensionVO.getCrlConfig().getCrlPeriod();
            if (drlPeriod != null && drlPeriod > 0 && crlPeriod < drlPeriod) {
                this.logger.error("\u4fdd\u5b58\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u589e\u91cf\u5468\u671f\u5927\u4e8e\u5168\u91cf\u5468\u671f [name={}]", (Object)crlTemplateDO.getCrlTempName());
                auditLog.append("\u4fdd\u5b58crl\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u589e\u91cf\u5468\u671f\u5927\u4e8e\u5168\u91cf\u5468\u671f\uff0c").append("\u6a21\u677f\u540d\u79f0=").append(crlTemplateDO.getCrlTempName());
                return Result.failure((ErrorEnum)ErrorEnum.CRL_TEMPLATE_DRLPEROID_ERROR).setAuditContent(auditLog.toString());
            }
            crlTemplateDO.setDrlPeriod(drlPeriod);
            crlTemplateDO.setCrlPeriod(crlPeriod);
            crlTemplateDO.setCrlTempName(crlTemplateExtensionVO.getCrlTempName());
            crlTemplateDO.setCrlTempDesc(crlTemplateExtensionVO.getCrlTempDesc());
            crlTemplateDO.setGmtModified(new Date());
            if (crlTemplateDO.getCrlStatus() == CrlTemplateStatusEnum.NOT_RELATION.value) {
                crlTemplateDO.setIssuerDn(crlTemplateExtensionVO.getCrlConfig().getIssuerDn());
                crlTemplateDO.setCrlMaxCertNumber(crlTemplateExtensionVO.getCrlConfig().getCrlMaxCertNumber());
                crlTemplateDO.setCrlSignAlg(crlTemplateExtensionVO.getCrlConfig().getCrlSignAlg());
                crlTemplateDO.setQueryType(crlTemplateExtensionVO.getCrlConfig().getQueryType());
                crlTemplateDO.setQueryType(crlTemplateExtensionVO.getCrlConfig().getQueryType());
                ArrayList<String> oids = new ArrayList<String>();
                if (!CollectionUtils.isEmpty((Collection)crlTemplateExtensionVO.getCrlExtension()) && !this.checkCrlExtension(crlTemplateExtensionVO.getCrlExtension(), oids)) {
                    this.logger.error("\u66f4\u65b0crl\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u7c7b\u578b\u4e0e\u6269\u5c55\u9879\u4e0d\u5339\u914d [name={}]", (Object)crlTemplateDO.getCrlTempName());
                    auditLog.append("\u66f4\u65b0crl\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u7c7b\u578b\u4e0e\u6269\u5c55\u9879\u4e0d\u5339\u914d\uff0c").append("\u6a21\u677f\u540d\u79f0=").append(crlTemplateDO.getCrlTempName());
                    return Result.failure((ErrorEnum)ErrorEnum.CRL_TEMPLATE_TYPE_AND_EXTENSION_MISMATCH).setAuditContent(auditLog.toString());
                }
                this.crlTemplateDao.deleteExtensionByCrlTempId(id);
                Map crlExtensions = this.crlTemplateDao.getExtensionIdByOID(oids);
                ArrayList crlExtensionDOList = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)crlTemplateExtensionVO.getCrlExtension())) {
                    crlTemplateExtensionVO.getCrlExtension().forEach(item -> {
                        CrlTemplateExtensionDO ce = new CrlTemplateExtensionDO();
                        ce.setCrlExtenId((Long)crlExtensions.get(item.getExtenOid()));
                        ce.setCrlTempId(crlTemplateDO.getId());
                        ce.setExtenValue(item.getExtenValue());
                        ce.setIsCritical(item.getIsCritical());
                        ce.setGmtCreate(crlTemplateDO.getGmtCreate());
                        crlExtensionDOList.add(ce);
                    });
                    this.crlTemplateDao.saveCrlTemplateExtensions(crlExtensionDOList);
                }
            } else {
                this.doCrlPublish(id);
                this.doDrlPublish(id);
            }
            this.crlTemplateDao.update((Object)crlTemplateDO);
            auditLog.append("\u66f4\u65b0crl\u6a21\u677f\u6210\u529f").append("\uff0c\u6a21\u677fid=").append(id).append("\uff0c\u6a21\u677f\u540d\u79f0=").append(crlTemplateExtensionVO.getCrlTempName());
            this.logger.info(auditLog.toString());
            return Result.success((String)auditLog.toString());
        }
        catch (Exception e) {
            throw new ServiceException("\u66f4\u65b0crl\u6a21\u677f\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result updateCrlTemplateStatus(Long id) {
        try {
            CrlTemplateDO crlTemplateDO = this.crlTemplateDao.getCrlTemplateById(id);
            if (crlTemplateDO == null) {
                this.logger.info("\u4fee\u6539crl\u6a21\u677f\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\uff1acrl\u6a21\u677f\u4e0d\u5b58\u5728 [id={}]", (Object)id);
                return Result.failure((ErrorEnum)ErrorEnum.CRL_TEMPLATE_NOT_EXIST);
            }
            String string = (id + "").intern();
            synchronized (string) {
                if (crlTemplateDO.getCrlStatus() == CrlTemplateStatusEnum.RELATION.value) {
                    this.logger.info("\u4fee\u6539crl\u6a21\u677f\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\uff1acrl\u6a21\u677f\u5df2\u88ab\u5173\u8054 [id={}]", (Object)id);
                    return Result.failure((ErrorEnum)ErrorEnum.CRL_TEMPLATE_RELATION_CANNOT_UPDATE_STATUS);
                }
                crlTemplateDO.setGmtModified(new Date());
                crlTemplateDO.setCrlStatus(Integer.valueOf(CrlTemplateStatusEnum.RELATION.value));
                this.crlTemplateDao.update((Object)crlTemplateDO);
                this.doCrlPublish(id);
                this.doDrlPublish(id);
            }
            return Result.success();
        }
        catch (Exception e) {
            throw new ServiceException("\u66f4\u65b0crl\u6a21\u677f\u72b6\u6001\u5931\u8d25", (Throwable)e);
        }
    }

    public Result deleteCrlTemplate(Long id) {
        try {
            StringBuilder auditLog = new StringBuilder();
            CrlTemplateDO crlTemplateDO = this.crlTemplateDao.getCrlTemplateById(id);
            if (crlTemplateDO == null) {
                this.logger.info("\u5220\u9664crl\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1acrl\u6a21\u677f\u4e0d\u5b58\u5728 [id={}]", (Object)id);
                auditLog.append("\u5220\u9664crl\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1acrl\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u6a21\u677fid=").append(id);
                return Result.failure((ErrorEnum)ErrorEnum.CRL_TEMPLATE_NOT_EXIST).setAuditContent(auditLog.toString());
            }
            if (crlTemplateDO.getCrlStatus() == CrlTemplateStatusEnum.RELATION.value) {
                this.logger.info("\u5220\u9664crl\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5df2\u5173\u8054\u7684crl\u6a21\u677f\u4e0d\u80fd\u5220\u9664[id={}]", (Object)id);
                auditLog.append("\u5220\u9664crl\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5df2\u5173\u8054\u7684crl\u6a21\u677f\u4e0d\u80fd\u5220\u9664").append("\uff0c\u6a21\u677fid=").append(id).append("\uff0c\u6a21\u677f\u540d\u79f0=").append(crlTemplateDO.getCrlTempName());
                return Result.failure((ErrorEnum)ErrorEnum.CRL_TEMPLATE_RELATION_CANNOT_DELETE).setAuditContent(auditLog.toString());
            }
            this.crlTemplateDao.deleteExtensionByCrlTempId(id);
            this.crlTemplateDao.deleteCrlTemplate(id);
            auditLog.append("\u5220\u9664crl\u6a21\u677f\u6210\u529f").append("\uff0c\u6a21\u677fid=").append(id).append("\uff0c\u6a21\u677f\u540d\u79f0=").append(crlTemplateDO.getCrlTempName());
            this.logger.info(auditLog.toString());
            return Result.success((String)auditLog.toString());
        }
        catch (Exception e) {
            throw new ServiceException("\u5220\u9664crl\u6a21\u677f\u5931\u8d25", (Throwable)e);
        }
    }

    public PageInfo queryCrlTemplates(CrlTemplateQueryVO crlTemplateVO) {
        try {
            CrlTemplateDO search = new CrlTemplateDO();
            BeanUtils.copyProperties((Object)crlTemplateVO, (Object)search);
            PageInfo pageInfo = this.crlTemplateDao.queryCrlTemplates(search, crlTemplateVO.getPageNo(), crlTemplateVO.getPageSize());
            if (!pageInfo.getDatas().isEmpty()) {
                Map<String, String> dics = this.getSignAlgDicByKeyAlg();
                ArrayList<CrlTemplateListVO> list = new ArrayList<CrlTemplateListVO>();
                CrlTemplateListVO ctlv = null;
                String signAlgName = "";
                for (Object item : pageInfo.getDatas()) {
                    ctlv = new CrlTemplateListVO();
                    BeanUtils.copyProperties(item, (Object)ctlv);
                    signAlgName = dics.get(ctlv.getCrlSignAlg());
                    if (signAlgName.equals(SignAlgTypeEnum.SHA1_WITH_RSA.algName)) {
                        signAlgName = SignAlgTypeEnum.SHA1_WITH_RSA.viewAlgNsme;
                    }
                    ctlv.setCrlSignAlgName(signAlgName);
                    if (ctlv.getGmtCreate() != null) {
                        ctlv.setGmtCreateStr(DateUtils.longToStr((long)ctlv.getGmtCreate().getTime(), (String)""));
                    }
                    if (ctlv.getGmtModified() != null) {
                        ctlv.setGmtModifiedStr(DateUtils.longToStr((long)ctlv.getGmtModified().getTime(), (String)""));
                    }
                    list.add(ctlv);
                }
                pageInfo.setDatas(list);
            }
            return pageInfo;
        }
        catch (Exception e) {
            throw new ServiceException("\u5206\u9875crl\u67e5\u8be2\u6a21\u677f\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
    }

    private Map<String, String> getSignAlgDicByKeyAlg() {
        HashMap<String, String> dics = new HashMap<String, String>();
        if (Constants.BASE_ALG_TYPE == KeyAlgEnum.SM2.value) {
            dics.putAll(this.dicDao.getDicsByParentCode("signAlg"));
        } else if (Constants.BASE_ALG_TYPE == KeyAlgEnum.RSA.value) {
            dics.putAll(this.dicDao.getDicsByParentCode("signAlgRsa"));
        } else {
            dics.putAll(this.dicDao.getDicsByParentCode("signAlgNist"));
        }
        return dics;
    }

    public Result getCrlTemplateById(Long id) {
        CrlTemplateExtensionVO crlTemplateExtensionVO = new CrlTemplateExtensionVO();
        CrlTemplateVO crlTemplateVO = new CrlTemplateVO();
        try {
            CrlTemplateDO crlTemplateDO = this.crlTemplateDao.getCrlTemplateById(id);
            if (crlTemplateDO == null) {
                this.logger.info("\u5220\u9664crl\u8bc1\u4e66\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1acrl\u6a21\u677f\u4e0d\u5b58\u5728 [id={}]", (Object)id);
                return Result.failure((ErrorEnum)ErrorEnum.CRL_TEMPLATE_NOT_EXIST);
            }
            BeanUtils.copyProperties((Object)crlTemplateDO, (Object)crlTemplateVO);
            Map<String, String> dics = this.getSignAlgDicByKeyAlg();
            String signAlgName = dics.get(crlTemplateVO.getCrlSignAlg());
            if (signAlgName.equals(SignAlgTypeEnum.SHA1_WITH_RSA.algName)) {
                signAlgName = SignAlgTypeEnum.SHA1_WITH_RSA.viewAlgNsme;
            }
            crlTemplateVO.setCrlSignAlgName(signAlgName);
            crlTemplateExtensionVO.setCrlTempName(crlTemplateDO.getCrlTempName());
            crlTemplateExtensionVO.setCrlTempDesc(crlTemplateDO.getCrlTempDesc());
            crlTemplateExtensionVO.setCrlConfig(crlTemplateVO);
            List crlTemplateExtensionDOS = this.crlTemplateDao.queryTemplateExtensionByCrlTemplateId(id);
            if (!CollectionUtils.isEmpty((Collection)crlTemplateExtensionDOS)) {
                ArrayList ids = new ArrayList();
                crlTemplateExtensionDOS.forEach(item -> ids.add(item.getCrlExtenId()));
                Map oids2id = this.crlTemplateDao.getExtensionOIDByID(ids);
                ArrayList crlExtensionVOS = new ArrayList();
                crlTemplateExtensionDOS.forEach(item -> crlExtensionVOS.add(new CrlExtensionVO((String)oids2id.get(item.getCrlExtenId()), item.getExtenValue(), item.getIsCritical())));
                crlTemplateExtensionVO.setCrlExtension(crlExtensionVOS);
            }
            return Result.success((Object)crlTemplateExtensionVO);
        }
        catch (Exception e) {
            throw new ServiceException("\u6839\u636ecrl\u6a21\u677fid\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result increamCertCount(Long id) {
        try {
            CrlTemplateDO crlTemplateDO = this.crlTemplateDao.getCrlTemplateById(id);
            if (crlTemplateDO == null) {
                this.logger.info("\u4fee\u6539crl\u6a21\u677f\u5173\u8054\u8bc1\u4e66\u6570\u91cf\u5931\u8d25\uff0c\u539f\u56e0\uff1acrl\u6a21\u677f\u4e0d\u5b58\u5728 [id={}]", (Object)id);
                return Result.failure((ErrorEnum)ErrorEnum.CRL_TEMPLATE_NOT_EXIST);
            }
            String string = (id + "").intern();
            synchronized (string) {
                if (crlTemplateDO.getCrlStatus() == CrlTemplateStatusEnum.NOT_RELATION.value) {
                    this.logger.info("\u4fee\u6539crl\u6a21\u677f\u5173\u8054\u8bc1\u4e66\u6570\u91cf\u5931\u8d25\uff0c\u539f\u56e0\uff1acrl\u6a21\u677f\u672a\u88ab\u5173\u8054 [id={}]", (Object)id);
                    return Result.failure((ErrorEnum)ErrorEnum.CRL_TEMPLATE_NOT_RELATION_CANNOT_UPDATE_CERTCOUNT);
                }
                crlTemplateDO.setGmtModified(new Date());
                crlTemplateDO.setCertCount(Integer.valueOf(crlTemplateDO.getCertCount() == null ? 0 : crlTemplateDO.getCertCount() + 1));
                this.crlTemplateDao.update((Object)crlTemplateDO);
                return Result.success();
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u66f4\u65b0crl\u6a21\u677f\u72b6\u6001\u5931\u8d25", (Throwable)e);
        }
    }

    public Integer getCrlTemplateStatus(Long id) {
        try {
            CrlTemplateDO crlTemplateDO = this.crlTemplateDao.getCrlTemplateById(id);
            if (crlTemplateDO == null) {
                throw new ServiceException("crl\u6a21\u677f\u4e0d\u5b58\u5728 [id={" + id + "}]");
            }
            return this.crlTemplateDao.getCrlTemplateStatus(id);
        }
        catch (Exception e) {
            throw new ServiceException("\u6839\u636ecrl\u6a21\u677fid\u83b7\u53d6\u6a21\u677f\u72b6\u6001\u5931\u8d25", (Throwable)e);
        }
    }

    public Integer getCrlTemplateCertCount(Long id) {
        try {
            CrlTemplateDO crlTemplateDO = this.crlTemplateDao.getCrlTemplateById(id);
            if (crlTemplateDO == null) {
                throw new ServiceException("crl\u6a21\u677f\u4e0d\u5b58\u5728 [id={" + id + "}]");
            }
            return this.crlTemplateDao.getCrlTemplateCertCount(id);
        }
        catch (Exception e) {
            throw new ServiceException("\u6839\u636ecrl\u6a21\u677fid\u83b7\u53d6\u6a21\u677f\u72b6\u6001\u5931\u8d25", (Throwable)e);
        }
    }

    public LdapOcspUrlVO getLdapOcspUrl(BigInteger sn, String subject, CaInfoVO caInfo, boolean isCA, Long templateId, Long crlTempId) throws Exception {
        LdapOcspUrlVO ldapOcspUrlVO = new LdapOcspUrlVO();
        if (StringUtils.isNotBlank((CharSequence)caInfo.getCertPolicy())) {
            ldapOcspUrlVO.setCertPolicy(caInfo.getCertPolicy());
        }
        if (null != caInfo.getRootCert()) {
            ldapOcspUrlVO.setRootCert(caInfo.getRootCert());
        }
        if (caInfo.isOcsp() && null != caInfo.getOcspConfig() && StringUtils.isNotBlank((CharSequence)caInfo.getOcspConfig().getNetworkURL())) {
            ldapOcspUrlVO.setNetworkUrl(caInfo.getOcspConfig().getNetworkURL());
        }
        if (caInfo.isLadp() && null != caInfo.getDirServerConfigBean() && crlTempId != null && crlTempId != -1L) {
            String rootCertUrl;
            String userCertUrl;
            String drlUrl;
            int segmentNo;
            CrlTemplateDO crlTemplateDO = this.crlTemplateDao.getCrlTemplateById(crlTempId);
            if (crlTempId == 0L) {
                int n = CrlUtil.computeSnFragmentantation((BigInteger)sn, (Long)crlTemplateDO.getCrlMaxCertNumber());
                segmentNo = null == templateId ? CrlConstants.COMMON_CRL_TEMPLATE_ID * CrlConstants.TRANSLATION_17 + n : templateId.intValue() * CrlConstants.TRANSLATION_17 + n;
            } else {
                segmentNo = crlTemplateDO.getCertCount() / crlTemplateDO.getCrlMaxCertNumber().intValue();
            }
            String crlUrl = this.getCrl(caInfo, crlTempId, segmentNo, isCA, crlTemplateDO.getQueryType());
            if (StringUtils.isNotBlank((CharSequence)crlUrl)) {
                ldapOcspUrlVO.setCrlLdapUrl(crlUrl);
            }
            if (crlTemplateDO.getDrlPeriod() != null && StringUtils.isNotBlank((CharSequence)(drlUrl = this.getDrl(caInfo, crlTempId, segmentNo, isCA, crlTemplateDO.getQueryType())))) {
                ldapOcspUrlVO.setDrlLdapUrl(drlUrl);
            }
            if (StringUtils.isNotBlank((CharSequence)(userCertUrl = this.getCertDownloadUrl(caInfo, subject, isCA, crlTemplateDO.getQueryType())))) {
                ldapOcspUrlVO.setCertLdapUrl(userCertUrl);
            }
            if (StringUtils.isNotBlank((CharSequence)(rootCertUrl = this.getRootCertDownloadUrl(caInfo, crlTemplateDO.getQueryType())))) {
                ldapOcspUrlVO.setRootCertLdapUrl(rootCertUrl);
            }
        }
        return ldapOcspUrlVO;
    }

    public String getCrl(CaInfoVO caInfoVO, Long crlTempId, int segmentNo, boolean isCa, int dirQueryType) throws InvalidNameException {
        String extranetHttpURL;
        DirServerConfigBean dirServerConfigBean = caInfoVO.getDirServerConfigBean();
        if (dirServerConfigBean == null) {
            return "";
        }
        if (isCa) {
            String extranetHttpURL2;
            if (dirQueryType == 1) {
                String slaveURL = dirServerConfigBean.getSlaveURL();
                if (StringUtils.isNotBlank((CharSequence)slaveURL)) {
                    return LDAPUrlUtils.genCertArlLdapUri((String)slaveURL, (String)caInfoVO.getSubject(), (int)crlTempId.intValue(), (int)segmentNo, (String)caInfoVO.getBaseDn());
                }
            } else if (dirQueryType == 2 && StringUtils.isNotBlank((CharSequence)(extranetHttpURL2 = dirServerConfigBean.getExtranetHttpURL()))) {
                return "http://" + extranetHttpURL2 + "/" + (crlTempId == 0L ? "" : crlTempId) + ARL_NAME_HEAD + segmentNo + CRL_FORMAT;
            }
        } else if (dirQueryType == 1) {
            String slaveURL = dirServerConfigBean.getSlaveURL();
            if (StringUtils.isNotBlank((CharSequence)slaveURL)) {
                String s = LDAPUrlUtils.genCertCrlLdapUri((String)slaveURL, (String)caInfoVO.getSubject(), (int)crlTempId.intValue(), (int)segmentNo, (String)caInfoVO.getBaseDn());
                return s;
            }
        } else if (dirQueryType == 2 && StringUtils.isNotBlank((CharSequence)(extranetHttpURL = dirServerConfigBean.getExtranetHttpURL()))) {
            return "http://" + extranetHttpURL + "/" + (crlTempId == 0L ? "" : crlTempId) + CRL_NAME_HEAD + segmentNo + CRL_FORMAT;
        }
        return "";
    }

    public String getDrl(CaInfoVO caInfoVO, Long crlTempId, int segmentNo, boolean isCa, int dirQueryType) throws InvalidNameException {
        String extranetHttpURL;
        DirServerConfigBean dirServerConfigBean = caInfoVO.getDirServerConfigBean();
        if (dirServerConfigBean == null) {
            return "";
        }
        if (isCa) {
            String extranetHttpURL2;
            if (dirQueryType == 1) {
                String slaveURL = dirServerConfigBean.getSlaveURL();
                if (StringUtils.isNotBlank((CharSequence)slaveURL)) {
                    return LDAPUrlUtils.genCertArlDrlLdapUri((String)slaveURL, (String)caInfoVO.getSubject(), (int)crlTempId.intValue(), (int)segmentNo, (String)caInfoVO.getBaseDn());
                }
            } else if (dirQueryType == 2 && StringUtils.isNotBlank((CharSequence)(extranetHttpURL2 = dirServerConfigBean.getExtranetHttpURL()))) {
                return "http://" + extranetHttpURL2 + "/" + (crlTempId == 0L ? "" : crlTempId) + ISSUER_DRL_NAME_HEAD + segmentNo + CRL_FORMAT;
            }
        } else if (dirQueryType == 1) {
            String slaveURL = dirServerConfigBean.getSlaveURL();
            if (StringUtils.isNotBlank((CharSequence)slaveURL)) {
                return LDAPUrlUtils.genCertCrlDrlLdapUri((String)slaveURL, (String)caInfoVO.getSubject(), (int)crlTempId.intValue(), (int)segmentNo, (String)caInfoVO.getBaseDn());
            }
        } else if (dirQueryType == 2 && StringUtils.isNotBlank((CharSequence)(extranetHttpURL = dirServerConfigBean.getExtranetHttpURL()))) {
            return "http://" + extranetHttpURL + "/" + (crlTempId == 0L ? "" : crlTempId) + DRL_NAME_HEAD + segmentNo + CRL_FORMAT;
        }
        return "";
    }

    private String getCertDownloadUrl(CaInfoVO caInfoVO, String subject, boolean isCA, int dirQueryType) {
        String extranetHttpURL;
        DirServerConfigBean dirServerConfigBean = caInfoVO.getDirServerConfigBean();
        if (dirQueryType == 1) {
            if (caInfoVO.isLadp() && null != dirServerConfigBean && StringUtils.isNotBlank((CharSequence)dirServerConfigBean.getSlaveURL())) {
                if (isCA) {
                    return LDAPUrlUtils.genCACertSubjectLdapUri((String)dirServerConfigBean.getSlaveURL(), (String)subject, (String)caInfoVO.getBaseDn());
                }
                return LDAPUrlUtils.genUserCertSubjectLdapUri((String)dirServerConfigBean.getSlaveURL(), (String)subject, (String)caInfoVO.getBaseDn());
            }
        } else if (dirQueryType == 2 && null != dirServerConfigBean && StringUtils.isNotBlank((CharSequence)dirServerConfigBean.getExtranetHttpURL()) && StringUtils.isNotBlank((CharSequence)(extranetHttpURL = dirServerConfigBean.getExtranetHttpURL()))) {
            return "http://" + extranetHttpURL + "/" + subject;
        }
        return "";
    }

    private String getRootCertDownloadUrl(CaInfoVO caInfoVO, int dirQueryType) throws Exception {
        String extranetHttpURL;
        DirServerConfigBean dirServerConfigBean = caInfoVO.getDirServerConfigBean();
        if (dirQueryType == 1) {
            if (caInfoVO.isLadp() && null != dirServerConfigBean && StringUtils.isNotBlank((CharSequence)dirServerConfigBean.getSlaveURL()) && null != caInfoVO.getRootCert()) {
                return LDAPUrlUtils.genCertAuthorityLdapUri((String)dirServerConfigBean.getSlaveURL(), (String)CertUtil.getSubjectByX509Cert((X509Certificate)caInfoVO.getRootCert()), (String)caInfoVO.getBaseDn());
            }
        } else if (dirQueryType == 2 && null != dirServerConfigBean && StringUtils.isNotBlank((CharSequence)dirServerConfigBean.getExtranetHttpURL()) && StringUtils.isNotBlank((CharSequence)(extranetHttpURL = dirServerConfigBean.getExtranetHttpURL()))) {
            return "http://" + extranetHttpURL + "/" + CertUtil.getSubjectByX509Cert((X509Certificate)caInfoVO.getRootCert());
        }
        return "";
    }

    public void doDrlPublish(Long crlTempId) {
        this.logger.info("\u4e3acrl\u6a21\u677f[{}]\u542f\u52a8drl\u7ebf\u7a0b", (Object)crlTempId);
        try {
            Result result = this.getCrlTemplateById(crlTempId);
            Long nowTime = System.currentTimeMillis();
            String key = DRL_NAME_HEAD + crlTempId;
            if (result != null && result.isSuccess()) {
                CrlTemplateExtensionVO crlTemplateExtensionVO = (CrlTemplateExtensionVO)result.getInfo();
                Integer releaseCycle = crlTemplateExtensionVO.getCrlConfig().getDrlPeriod();
                if (releaseCycle == null || releaseCycle <= 0) {
                    this.logger.info("\u6a21\u677f[{}]\u672a\u5f00\u542fDRL\u53d1\u5e03\u7ebf\u7a0b", (Object)crlTempId);
                    if (CrlConstants.CRL_THREAD_COLLECTION.containsKey(key)) {
                        this.logger.info("\u6a21\u677f[{}]\u505c\u6b62\u5df2\u5b58\u5728\u7684drl\u4efb\u52a1", (Object)crlTempId);
                        ((Future)CrlConstants.CRL_THREAD_COLLECTION.get(key)).cancel(true);
                    }
                    return;
                }
                Date nextUpdateTime = this.crlService.getDrlLastNextUpdatTimeByCrlTemplateId(crlTempId);
                nextUpdateTime = null == nextUpdateTime ? DateTimeUtil.longToDate((long)(nowTime + (long)(releaseCycle * 60 * 1000))) : IssueTimeUtil.computeCrlPublishTime((Date)nextUpdateTime, (Long)nowTime, (Integer)releaseCycle);
                long sleepTime = nextUpdateTime.getTime() - System.currentTimeMillis();
                sleepTime = sleepTime > 0L ? sleepTime : 0L;
                CrlConstants.CRL_THREAD_NEXT_UPDATE_TIME.put(key, nextUpdateTime);
                DrlPublishThread drlPublishThread = new DrlPublishThread(crlTempId);
                if (CrlConstants.CRL_THREAD_COLLECTION.containsKey(key)) {
                    ((Future)CrlConstants.CRL_THREAD_COLLECTION.get(key)).cancel(true);
                }
                CrlConstants.CRL_THREAD_COLLECTION.put(key, CrlConstants.CRL_THREAD_POOL_EXECUTOR.scheduleAtFixedRate((Runnable)drlPublishThread, sleepTime / 1000L, releaseCycle * 60, TimeUnit.SECONDS));
                this.logger.info("\u6a21\u677f[{}]\u542f\u52a8DRL\u53d1\u5e03\u7ebf\u7a0b\u6210\u529f", (Object)crlTempId);
            } else {
                this.logger.error("\u83b7\u53d6crl\u6a21\u677f\u8be6\u60c5\u5931\u8d25,\u539f\u56e0\u4e3a\uff1a{}", (Object)result.getError().desc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u5f00\u542fdrl\u7ebf\u7a0b\u5931\u8d25,\u539f\u56e0\u4e3a\uff1a{}", (Object)e.getMessage());
            throw new ServiceException("\u5f00\u542fdrl\u7ebf\u7a0b\u5931\u8d25", (Throwable)e);
        }
    }

    public void doCrlPublish(Long crlItemId) {
        this.logger.info("\u4e3acrl\u6a21\u677f[{}]\u542f\u52a8crl\u7ebf\u7a0b", (Object)crlItemId);
        try {
            Result result = this.getCrlTemplateById(crlItemId);
            Long nowTime = System.currentTimeMillis();
            String key = CRL_NAME_HEAD + crlItemId;
            if (result != null && result.isSuccess()) {
                CrlTemplateExtensionVO crlTemplateExtensionVO = (CrlTemplateExtensionVO)result.getInfo();
                Date nextUpdateTime = this.crlService.getCrlLastNextUpdatTimeByCrlTemplateId(crlItemId);
                Integer releaseCycle = crlTemplateExtensionVO.getCrlConfig().getCrlPeriod();
                if (releaseCycle == null || releaseCycle <= 0) {
                    this.logger.info("\u6a21\u677f[{}]\u672a\u5f00\u542fCRL\u53d1\u5e03\u7ebf\u7a0b", (Object)crlItemId);
                    if (CrlConstants.CRL_THREAD_COLLECTION.containsKey(key)) {
                        ((Future)CrlConstants.CRL_THREAD_COLLECTION.get(key)).cancel(true);
                    }
                    return;
                }
                nextUpdateTime = null == nextUpdateTime ? DateTimeUtil.longToDate((long)nowTime) : IssueTimeUtil.computeCrlPublishTime((Date)nextUpdateTime, (Long)nowTime, (Integer)releaseCycle);
                long sleepTime = nextUpdateTime.getTime() - System.currentTimeMillis();
                sleepTime = sleepTime > 0L ? sleepTime : 0L;
                CrlConstants.CRL_THREAD_NEXT_UPDATE_TIME.put(key, nextUpdateTime);
                CrlPublishThread crlPublishThread = new CrlPublishThread(crlItemId);
                if (CrlConstants.CRL_THREAD_COLLECTION.containsKey(key)) {
                    ((Future)CrlConstants.CRL_THREAD_COLLECTION.get(key)).cancel(true);
                }
                CrlConstants.CRL_THREAD_COLLECTION.put(key, CrlConstants.CRL_THREAD_POOL_EXECUTOR.scheduleAtFixedRate((Runnable)crlPublishThread, sleepTime / 1000L, releaseCycle * 60, TimeUnit.SECONDS));
                this.logger.info("\u6a21\u677f[{}]\u542f\u52a8CRL\u53d1\u5e03\u7ebf\u7a0b\u6210\u529f", (Object)crlItemId);
            } else {
                this.logger.error("\u83b7\u53d6crl\u6a21\u677f\u8be6\u60c5\u5931\u8d25,\u539f\u56e0\u4e3a\uff1a{}", (Object)result.getError().desc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("\u5f00\u542fcrl\u7ebf\u7a0b\u5931\u8d25,\u539f\u56e0\u4e3a\uff1a{}", (Object)e.getMessage());
            throw new ServiceException("\u5f00\u542fcrl\u7ebf\u7a0b\u5931\u8d25", (Throwable)e);
        }
    }

    public Boolean verifyQueryType(Integer queryType) {
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
        if (caInfoVO.getDirServerConfigBean() == null) {
            return false;
        }
        if (CrlPublishEnum.isHttpCRL((Integer)queryType)) {
            return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{caInfoVO.getDirServerConfigBean().getLocalURL()}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{caInfoVO.getDirServerConfigBean().getExtranetHttpURL()});
        }
        if (CrlPublishEnum.isLDAPCRL((Integer)queryType)) {
            return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{caInfoVO.getDirServerConfigBean().getMasterURL()}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{caInfoVO.getDirServerConfigBean().getSlaveURL()});
        }
        return false;
    }
}

