/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.crosscert;

import com.xdja.pki.ca.certmanager.dao.CrossCertDao;
import com.xdja.pki.ca.certmanager.dao.OuterCrossCertDao;
import com.xdja.pki.ca.certmanager.dao.models.CrossCertDO;
import com.xdja.pki.ca.certmanager.dao.models.OuterCrossCertDO;
import com.xdja.pki.ca.certmanager.service.crltemplate.CrlTemplateService;
import com.xdja.pki.ca.certmanager.service.crosscert.ICrossCertManageService;
import com.xdja.pki.ca.certmanager.service.crosscert.bean.CrossCertApplyVO;
import com.xdja.pki.ca.certmanager.service.crosscert.bean.CrossCertQueryVO;
import com.xdja.pki.ca.certmanager.service.crosscert.bean.CrossCertTypeEnum;
import com.xdja.pki.ca.certmanager.service.crosscert.bean.CrossCertVO;
import com.xdja.pki.ca.certmanager.service.task.TaskDataService;
import com.xdja.pki.ca.certmanager.service.template.TemplateService;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateInfoVO;
import com.xdja.pki.ca.certmanager.service.util.DicDataConverUtil;
import com.xdja.pki.ca.certmanager.service.util.ExtensionUtil;
import com.xdja.pki.ca.certmanager.service.util.TemplateParamsUtil;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.ca.util.gm.cert.SM2PublicKey;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.enums.P10typeEnum;
import com.xdja.pki.ca.core.enums.TemplateStatusEnum;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.CertUtils;
import com.xdja.pki.ca.core.util.DnUtil;
import com.xdja.pki.ca.core.util.time.DateTimeUtil;
import com.xdja.pki.ca.core.util.time.IssueTimeUtil;
import com.xdja.pki.ca.hsm.manager.HsmManager;
import com.xdja.pki.ca.ldap.service.vo.LdapOcspUrlVO;
import com.xdja.pki.ca.securitymanager.dao.CaCertDao;
import com.xdja.pki.ca.securitymanager.dao.CertSnDao;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.CreateP10VO;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.nutz.dao.pager.Pager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CrossCertManageServiceImpl
implements ICrossCertManageService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private HsmManager hsmService;
    @Autowired
    private CaCertDao caCertDao;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private CrlTemplateService crlTemplateService;
    @Resource
    private CertSnDao certSnDao;
    @Resource
    private CrossCertDao crossCertDao;
    @Resource
    private OuterCrossCertDao outerCrossCertDao;
    @Autowired
    private TaskDataService taskDataService;
    @Autowired
    private DicDataConverUtil dicDataConverUtil;
    @Value(value="${config.path}")
    private String configPath;

    public Result createCrossCertApplyP10() {
        if (!this.caCertDao.currentIsRootCa().booleanValue()) {
            this.logger.info("\u672c\u7ea7CA\u4e0d\u662f\u6839CA,\u6ca1\u6709\u6743\u9650\u7b7e\u53d1\u4ea4\u53c9\u8bc1\u4e66");
            return Result.failure((ErrorEnum)ErrorEnum.PERMISSION_ACCESS_ERROR);
        }
        try {
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
            X509Certificate rootCert = caInfoVO.getRootCert();
            String subject = CertUtil.getSubjectByX509Cert((X509Certificate)rootCert);
            Integer privateKeySize = caInfoVO.getPrivateKeySize();
            Integer keyIndex = caInfoVO.getCaPwdBean().getKeyIndex();
            String privateKeyPin = caInfoVO.getCaPwdBean().getPrivateKeyPin();
            CreateP10VO createP10VO = new CreateP10VO();
            createP10VO.setDn(subject);
            createP10VO.setAlg(Constants.BASE_ALG_TYPE);
            createP10VO.setAlgLength(privateKeySize);
            if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue()) {
                createP10VO.setPublicKey(caInfoVO.getRootCert().getPublicKey());
                createP10VO.setPrivateKey(caInfoVO.getRootPrivateKey());
            } else {
                createP10VO.setKeyIndex(keyIndex);
                createP10VO.setPrivateKeyPin(privateKeyPin);
            }
            PKCS10CertificationRequest p10 = this.hsmService.genP10(createP10VO, Integer.valueOf(P10typeEnum.Cross.value));
            String p10Name = "CertReq_" + DateTimeUtil.dateToZipStr((Date)new Date()) + ".p10";
            CertUtil.writeObjToFile((Object)p10, (String)(this.configPath + "p10/" + p10Name));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("p10Name", p10Name);
            return Result.success(map, (String)p10Name);
        }
        catch (Exception e) {
            throw new ServiceException("\u751f\u6210\u4ea4\u53c9\u8bc1\u4e66p10\u7533\u8bf7\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public Result doIssueCrossCert(CrossCertApplyVO crossCertApplyVO) {
        String tempCode = crossCertApplyVO.getTempCode();
        Map templateByCodesMap = null;
        try {
            templateByCodesMap = this.templateService.getTemplatesByCodes(new String[]{tempCode});
        }
        catch (ServiceException e) {
            this.logger.error("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u5f02\u5e38");
            throw e;
        }
        TemplateInfoVO templateInfoVO = (TemplateInfoVO)templateByCodesMap.get(tempCode);
        if (null == templateInfoVO) {
            this.logger.debug("\u7b7e\u53d1\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728");
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
        }
        if (TemplateStatusEnum.NORMAL.value != templateInfoVO.getStatus()) {
            this.logger.info("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u7ed3\u679c\uff1a\u6a21\u677f\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u6a21\u677f\u72b6\u6001\u4e3a[{}]", (Object)templateInfoVO.getStatus());
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
        }
        Result result = TemplateParamsUtil.validity((TemplateInfoVO)templateInfoVO, (String)crossCertApplyVO.getTempParas());
        if (!result.isSuccess()) {
            this.logger.info("\u7b7e\u53d1\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25\uff1a\u7f3a\u5c11\u6a21\u677f\u9700\u8981\u53c2\u6570");
            return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(templateInfoVO.getKeyAlg());
        X509Certificate rootCert = caInfoVO.getRootCert();
        if (null == caInfoVO || StringUtils.isBlank((CharSequence)caInfoVO.getBaseDn()) || null == caInfoVO.getRootCert()) {
            this.logger.debug("\u7b7e\u53d1\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u5230CA\u57fa\u672c\u4fe1\u606f[{}]", (Object)crossCertApplyVO.toString());
            return Result.failure((ErrorEnum)ErrorEnum.CA_BASEINFO_GET_FAIL);
        }
        if (caInfoVO.getRootCert().getNotAfter().before(new Date())) {
            this.logger.debug("\u7b7e\u53d1\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25\uff1aCA\u6839\u8bc1\u4e66\u5df2\u8fc7\u671f[{}]", (Object)crossCertApplyVO.toString());
            return Result.failure((ErrorEnum)ErrorEnum.CA_ROOT_CERT_EXPIRED);
        }
        try {
            X500Name x500Name = DnUtil.getRFC4519X500Name((String)crossCertApplyVO.getCertDn());
        }
        catch (Exception e) {
            this.logger.debug("\u7b7e\u53d1\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e0d\u7b26\u5408X500\u89c4\u8303[{}]", (Object)crossCertApplyVO.toString());
            return Result.failure((ErrorEnum)ErrorEnum.DN_FORMAT_FAIL);
        }
        PublicKey signPublicKey = CertUtil.getPublicKeyFromP10((String)crossCertApplyVO.getP10());
        if (null == signPublicKey) {
            this.logger.debug("\u7b7e\u53d1\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25\uff1ap10\u683c\u5f0f\u4e0d\u6b63\u786e[{}]", (Object)crossCertApplyVO.toString());
            return Result.failure((ErrorEnum)ErrorEnum.P10_FORMAT_ERROR);
        }
        try {
            Date nowTime = new Date();
            Date endTime = IssueTimeUtil.getCorrectTime((Long)crossCertApplyVO.getValidity(), (Integer)templateInfoVO.getMaxValidity(), (Date)rootCert.getNotAfter(), (Date)nowTime);
            BigInteger signSn = this.certSnDao.getMaxSn(nowTime);
            LdapOcspUrlVO signLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(signSn, crossCertApplyVO.getCertDn(), caInfoVO, true, null, null);
            List signExtensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), (Map)((Map)result.getInfo()), (PublicKey)signPublicKey, (String)crossCertApplyVO.getCertDn(), (LdapOcspUrlVO)signLdapOcspUrlVO, (boolean)true);
            X509Certificate signCert = this.hsmService.genX509Certificate(crossCertApplyVO.getCertDn(), signSn, nowTime, endTime, caInfoVO, signPublicKey, signExtensions, templateInfoVO.getSignAlg());
            try {
                CrossCertDO crossCertDO = this.saveCrossCert(caInfoVO.getCertId(), signCert, crossCertApplyVO, templateInfoVO);
                this.taskDataService.savePublishCert(crossCertDO.getId(), null, Integer.valueOf(4));
            }
            catch (DAOException e) {
                throw new ServiceException("\u4fdd\u5b58\u4ea4\u53c9\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25\uff0c", (Throwable)e);
            }
            this.logger.info("\u7b7e\u53d1\u4ea4\u53c9\u8bc1\u4e66\u6210\u529f\uff1adn= " + crossCertApplyVO.getCertDn() + ",signCert=" + CertUtil.writeObject((Object)signCert));
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("certName", "CrossCA_" + DateTimeUtil.dateToZipStr((Date)nowTime) + ".p7b");
            resultMap.put("sn", signSn.toString(16));
            resultMap.put("keyAlg", templateInfoVO.getKeyAlg());
            return Result.success(resultMap, (String)signSn.toString(16));
        }
        catch (Exception e) {
            throw new ServiceException("\u7b7e\u53d1\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    private CrossCertDO saveCrossCert(Long caCertId, X509Certificate signCert, CrossCertApplyVO crossCertApplyVO, TemplateInfoVO templateInfoVO) throws Exception {
        CrossCertDO crossCertDO = new CrossCertDO();
        crossCertDO.setCaCertId(caCertId);
        crossCertDO.setSn(signCert.getSerialNumber().toString(16));
        crossCertDO.setIssuer(CertUtil.getIssuerByX509Cert((X509Certificate)signCert));
        crossCertDO.setSubject(CertUtil.getSubjectByX509Cert((X509Certificate)signCert));
        crossCertDO.setPrivateKeySize(templateInfoVO.getKeySize());
        crossCertDO.setPublicKeyAlg(templateInfoVO.getKeyAlg());
        crossCertDO.setBeforeTime(signCert.getNotBefore());
        crossCertDO.setAfterTime(signCert.getNotAfter());
        crossCertDO.setSignAlg(templateInfoVO.getSignAlg());
        crossCertDO.setStatus(Integer.valueOf(1));
        crossCertDO.setTemplateId(templateInfoVO.getId());
        crossCertDO.setGmtCreate(signCert.getNotBefore());
        crossCertDO.setData(CertUtil.writeObject((Object)signCert));
        return this.crossCertDao.save(crossCertDO);
    }

    public Result getCrossCertList(CrossCertQueryVO crossCertQueryVO) {
        Pager pager = new Pager(crossCertQueryVO.getPageNo(), crossCertQueryVO.getPageSize());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("certDn", crossCertQueryVO.getCertDn());
        PageInfo pageInfo = null;
        try {
            pageInfo = this.crossCertDao.getCrossCertList(param, pager);
            Collection datas = pageInfo.getDatas();
            if (!datas.isEmpty()) {
                ArrayList<CrossCertVO> subCaInfoVOList = new ArrayList<CrossCertVO>();
                for (Object item : datas) {
                    CrossCertDO crossCertDO = (CrossCertDO)item;
                    CrossCertVO crossCertVO = new CrossCertVO();
                    this.handleCrossCertDO(crossCertDO);
                    Integer status = crossCertDO.getStatus();
                    crossCertVO.setStatus(status);
                    crossCertVO.setStatusStr(this.dicDataConverUtil.ConverStatusToStr(status));
                    crossCertVO.setCertDn(crossCertDO.getSubject());
                    crossCertVO.setIssuer(crossCertDO.getIssuer());
                    crossCertVO.setSn(crossCertDO.getSn());
                    crossCertVO.setNotBeforeTime(DateTimeUtil.dateToWebStr((Date)crossCertDO.getBeforeTime()));
                    crossCertVO.setNotAfterTime(DateTimeUtil.dateToWebStr((Date)crossCertDO.getAfterTime()));
                    subCaInfoVOList.add(crossCertVO);
                }
                pageInfo.setDatas(subCaInfoVOList);
            }
        }
        catch (DAOException e) {
            throw new ServiceException("\u67e5\u8be2\u4ea4\u53c9\u8bc1\u4e66\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
        }
        return Result.success((Object)pageInfo);
    }

    public Result getOutCrossCertList(CrossCertQueryVO crossCertQueryVO) {
        Pager pager = new Pager(crossCertQueryVO.getPageNo(), crossCertQueryVO.getPageSize());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("certDn", crossCertQueryVO.getCertDn());
        PageInfo pageInfo = null;
        try {
            pageInfo = this.outerCrossCertDao.getOutCrossCertList(param, pager);
            Collection datas = pageInfo.getDatas();
            if (!datas.isEmpty()) {
                ArrayList<CrossCertVO> subCaInfoVOList = new ArrayList<CrossCertVO>();
                for (Object item : datas) {
                    OuterCrossCertDO outerCrossCertDO = (OuterCrossCertDO)item;
                    CrossCertVO crossCertVO = new CrossCertVO();
                    this.handleOutCrossCertDO(outerCrossCertDO, crossCertVO);
                    crossCertVO.setCertDn(outerCrossCertDO.getSubject());
                    crossCertVO.setIssuer(outerCrossCertDO.getIssuer());
                    crossCertVO.setSn(outerCrossCertDO.getSn());
                    crossCertVO.setNotBeforeTime(DateTimeUtil.dateToWebStr((Date)outerCrossCertDO.getBeforeTime()));
                    crossCertVO.setNotAfterTime(DateTimeUtil.dateToWebStr((Date)outerCrossCertDO.getAfterTime()));
                    subCaInfoVOList.add(crossCertVO);
                }
                pageInfo.setDatas(subCaInfoVOList);
            }
        }
        catch (DAOException e) {
            throw new ServiceException("\u67e5\u8be2\u4ea4\u53c9\u8bc1\u4e66\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
        }
        return Result.success((Object)pageInfo);
    }

    public Result uploadOutCrossCertChain(byte[] bytes) {
        try {
            List certList = null;
            try {
                certList = CertUtils.getCertListFromB64((byte[])bytes);
            }
            catch (Exception e) {
                this.logger.error("\u8bc1\u4e66\u94fe\u683c\u5f0f\u9519\u8bef", (Throwable)e);
                return Result.failure((ErrorEnum)ErrorEnum.HSM_CA_CHAIN_FORMAT_ERROR);
            }
            X509Certificate[] certArray = CertUtil.sortCertChain((List)certList);
            boolean flag = CertUtil.verifyCertChainSign((X509Certificate[])certArray);
            if (!flag) {
                this.logger.error("\u5916\u90e8\u4ea4\u53c9\u8bc1\u4e66\u9a8c\u7b7e\u5931\u8d25");
                return Result.failure((ErrorEnum)ErrorEnum.CA_CHAIN_VERIFY_FAIL);
            }
            X509Certificate outCrossCert = certArray[certArray.length - 1];
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
            X509Certificate rootCert = caInfoVO.getRootCert();
            if (!outCrossCert.getPublicKey().equals(rootCert.getPublicKey()) || !outCrossCert.getSubjectDN().equals(rootCert.getSubjectDN())) {
                this.logger.error("\u5916\u90e8\u4ea4\u53c9\u8bc1\u4e66\u5bfc\u5165\u683c\u5f0f\u9519\u8bef,\u8bf7\u68c0\u67e5\u5bfc\u5165\u8bc1\u4e66\u7684\u4e3b\u4f53\u548c\u516c\u94a5\u662f\u5426\u6b63\u786e");
                return Result.failure((ErrorEnum)ErrorEnum.HSM_CA_CHAIN_FORMAT_ERROR);
            }
            String serialNumber = outCrossCert.getSerialNumber().toString(16);
            String subjectname = CertUtil.getSubjectByX509Cert((X509Certificate)outCrossCert);
            String issuerDN = CertUtil.getIssuerByX509Cert((X509Certificate)outCrossCert);
            String sigAlgName = outCrossCert.getSigAlgName();
            PublicKey publicKey = outCrossCert.getPublicKey();
            SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            AlgorithmIdentifier algorithm = subPubKeyInfo.getAlgorithm();
            OuterCrossCertDO outerCrossCertDO = new OuterCrossCertDO();
            outerCrossCertDO.setCaCertId(caInfoVO.getCaId());
            outerCrossCertDO.setSn(serialNumber);
            outerCrossCertDO.setSubject(subjectname);
            outerCrossCertDO.setIssuer(issuerDN);
            outerCrossCertDO.setSignAlg(sigAlgName);
            if (SM2PublicKey.ID_SM2_PUBKEY_PARAM.equals((Object)algorithm.getParameters())) {
                outerCrossCertDO.setPublicKeyAlg(Constants.BASE_ALG_TYPE);
            } else {
                outerCrossCertDO.setPublicKeyAlg(Constants.BASE_ALG_TYPE);
            }
            outerCrossCertDO.setPrivateKeySize(caInfoVO.getPrivateKeySize());
            outerCrossCertDO.setBeforeTime(outCrossCert.getNotBefore());
            outerCrossCertDO.setAfterTime(outCrossCert.getNotAfter());
            outerCrossCertDO.setData(CertUtil.writeObject((Object)outCrossCert));
            outerCrossCertDO.setCertChain(new String(bytes));
            outerCrossCertDO.setGmtCreate(new Date());
            OuterCrossCertDO saveOuterCrossCertDO = this.outerCrossCertDao.save(outerCrossCertDO);
            this.taskDataService.savePublishCert(saveOuterCrossCertDO.getId(), null, Integer.valueOf(5));
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u5165\u5916\u90e8\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u5bfc\u5165\u5916\u90e8\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
        }
        return Result.success();
    }

    private void handleCrossCertDO(CrossCertDO crossCertDO) {
        if (CrossCertTypeEnum.CROSSCERT_STATUS_REVOKED.value == crossCertDO.getStatus()) {
            crossCertDO.setStatus(Integer.valueOf(3));
        }
        if (crossCertDO.getAfterTime().before(new Date())) {
            crossCertDO.setStatus(Integer.valueOf(4));
        }
    }

    private void handleOutCrossCertDO(OuterCrossCertDO outerCrossCertDO, CrossCertVO crossCertVO) {
        if (outerCrossCertDO.getAfterTime().before(new Date())) {
            crossCertVO.setStatus(Integer.valueOf(4));
            crossCertVO.setStatusStr(this.dicDataConverUtil.ConverStatusToStr(4));
        }
    }
}

