/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.customizeExten;

import com.xdja.pki.ca.certmanager.dao.CustomizeExtenDao;
import com.xdja.pki.ca.certmanager.dao.models.CustomizeExtensionDO;
import com.xdja.pki.ca.certmanager.dao.models.TemplateCustomizeExtensionDO;
import com.xdja.pki.ca.certmanager.service.customizeExten.CustomizeExtenService;
import com.xdja.pki.ca.certmanager.service.customizeExten.bean.CustomizeExtenQueryVO;
import com.xdja.pki.ca.certmanager.service.customizeExten.bean.CustomizeExtenVO;
import com.xdja.pki.ca.certmanager.service.customizeExten.bean.TemplateCustomizeExtensionVO;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.verify.VerifyOidUtil;
import com.xdja.pki.ca.securitymanager.service.vo.TemplateCustomizeExtensionDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomizeExtenImpl
implements CustomizeExtenService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    CustomizeExtenDao customizeExtenDao;

    public PageInfo getCustomizeExtenList(CustomizeExtenQueryVO query) {
        this.logger.debug("\u5206\u9875\u67e5\u8be2\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u5217\u8868\u5f00\u59cb\uff01");
        try {
            CustomizeExtensionDO customizeExtensionDO = new CustomizeExtensionDO();
            BeanUtils.copyProperties((Object)query, (Object)customizeExtensionDO);
            PageInfo pageInfo = this.customizeExtenDao.queryCustomizeExten(customizeExtensionDO, query.getPageNo(), query.getPageSize());
            if (!pageInfo.getDatas().isEmpty()) {
                ArrayList<CustomizeExtenVO> list = new ArrayList<CustomizeExtenVO>();
                CustomizeExtenVO customizeExten = null;
                for (Object item : pageInfo.getDatas()) {
                    customizeExten = new CustomizeExtenVO();
                    BeanUtils.copyProperties(item, (Object)customizeExten);
                    list.add(customizeExten);
                }
                pageInfo.setDatas(list);
            }
            return pageInfo;
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u5217\u8868\u5931\u8d25");
            throw new ServiceException("\u5206\u9875\u67e5\u8be2\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
    }

    public Result getCustomizeExtenInfo(long id) {
        this.logger.debug("\u67e5\u8be2\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u8be6\u60c5\u5f00\u59cb\uff01");
        CustomizeExtenVO customizeExtensionVO = new CustomizeExtenVO();
        try {
            CustomizeExtensionDO customizeExtensionDO = this.customizeExtenDao.getCustomizeExtenInfo(id);
            if (null == customizeExtensionDO) {
                return Result.failure((ErrorEnum)ErrorEnum.CUSTOMIZE_EXTENSION_INFO_NOT_EXIST);
            }
            BeanUtils.copyProperties((Object)customizeExtensionDO, (Object)customizeExtensionVO);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u8be6\u60c5\u5931\u8d25");
            throw new ServiceException("\u67e5\u8be2\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u8be6\u60c5\u5931\u8d25", (Throwable)e);
        }
        return Result.success((Object)customizeExtensionVO);
    }

    public Result saveCustomizeExtenInfo(CustomizeExtenVO customizeExtenVO) {
        this.logger.debug("\u4fdd\u5b58\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u4fe1\u606f\u5f00\u59cb\uff01");
        try {
            String customizeExtenOid = customizeExtenVO.getCustomizeExtenOid();
            Boolean verify = VerifyOidUtil.verifyOid((String)customizeExtenOid);
            if (!verify.booleanValue()) {
                return Result.failure((ErrorEnum)ErrorEnum.CUSTOMIZE_EXTENSION_OID_IS_ERROR);
            }
            int oidSize = this.customizeExtenDao.verifyOidUnique(customizeExtenOid, null);
            int oidSizeExtension = this.customizeExtenDao.verifyOidExtension(customizeExtenOid);
            if (oidSize != 0 || oidSizeExtension != 0) {
                return Result.failure((ErrorEnum)ErrorEnum.CUSTOMIZE_EXTENSION_OID_IS_EXIST);
            }
            CustomizeExtensionDO customizeExtensionDO = new CustomizeExtensionDO();
            BeanUtils.copyProperties((Object)customizeExtenVO, (Object)customizeExtensionDO);
            customizeExtensionDO.setGmtCreate(new Date());
            customizeExtensionDO.setGmtModified(new Date());
            customizeExtensionDO.setUseStatus(Integer.valueOf(0));
            this.customizeExtenDao.saveCustomizeExtenInfo(customizeExtensionDO);
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u4fe1\u606f\u5931\u8d25");
            throw new ServiceException("\u4fdd\u5b58\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u4fe1\u606f\u5931\u8d25,", (Throwable)e);
        }
        return Result.success();
    }

    public Result updateCustomizeExtenInfo(int id, CustomizeExtenVO customizeExtenVO) {
        this.logger.debug("\u66f4\u65b0\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u4fe1\u606f\u5f00\u59cb\uff01");
        try {
            String customizeExtenOid = customizeExtenVO.getCustomizeExtenOid();
            Boolean verify = VerifyOidUtil.verifyOid((String)customizeExtenOid);
            if (!verify.booleanValue()) {
                return Result.failure((ErrorEnum)ErrorEnum.CUSTOMIZE_EXTENSION_OID_IS_ERROR);
            }
            int oidSize = this.customizeExtenDao.verifyOidUnique(customizeExtenOid, Integer.valueOf(id));
            int oidSizeExtension = this.customizeExtenDao.verifyOidExtension(customizeExtenOid);
            if (oidSize != 0 || oidSizeExtension != 0) {
                return Result.failure((ErrorEnum)ErrorEnum.CUSTOMIZE_EXTENSION_OID_IS_EXIST);
            }
            CustomizeExtensionDO customizeExtensionDO = new CustomizeExtensionDO();
            BeanUtils.copyProperties((Object)customizeExtenVO, (Object)customizeExtensionDO);
            customizeExtensionDO.setId(Long.valueOf(id));
            customizeExtensionDO.setGmtModified(new Date());
            this.customizeExtenDao.updateCustomizeExtenInfo(customizeExtensionDO);
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u4fe1\u606f\u5931\u8d25");
            throw new ServiceException("\u66f4\u65b0\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u4fe1\u606f\u5931\u8d25,", (Throwable)e);
        }
        return Result.success();
    }

    public Result updateCustomizeExtenStatusLog(long id, int useStatus) {
        StringBuffer content = new StringBuffer();
        try {
            Result customizeExtenInfo = this.getCustomizeExtenInfo(id);
            if (!customizeExtenInfo.isSuccess()) {
                return customizeExtenInfo;
            }
            this.updateCustomizeExtenStatus(id, useStatus);
            CustomizeExtenVO customizeExtenVO = (CustomizeExtenVO)customizeExtenInfo.getInfo();
            content.append(",\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u540d\u79f0=").append(customizeExtenVO.getCustomizeExtenName()).append(",OID=").append(customizeExtenVO.getCustomizeExtenOid());
        }
        catch (Exception e) {
            this.logger.error("\u6ce8\u9500\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u4fe1\u606f\u5931\u8d25");
            throw new ServiceException("\u6ce8\u9500\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u4fe1\u606f\u5931\u8d25,", (Throwable)e);
        }
        return Result.success(null, (String)content.toString());
    }

    public Result updateCustomizeExtenStatus(long id, int useStatus) {
        this.logger.debug("\u4fee\u6539\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u4f7f\u7528\u72b6\u6001\u5f00\u59cb\uff01");
        if (2 != useStatus && 1 != useStatus && 0 != useStatus) {
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        try {
            this.customizeExtenDao.updateCustomizeExtenStatus(id, useStatus);
        }
        catch (Exception e) {
            this.logger.error("\u4fee\u6539\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u4f7f\u7528\u72b6\u6001\u5931\u8d25");
            throw new ServiceException("\u4fee\u6539\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u4f7f\u7528\u72b6\u6001\u5931\u8d25,", (Throwable)e);
        }
        return Result.success();
    }

    public Result deleteCustomizeExtenInfo(long id) {
        this.logger.debug("\u5220\u9664\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u5f00\u59cb\uff01");
        StringBuffer content = new StringBuffer();
        try {
            Result customizeExtenInfo = this.getCustomizeExtenInfo(id);
            if (!customizeExtenInfo.isSuccess()) {
                return customizeExtenInfo;
            }
            this.customizeExtenDao.deleteCustomizeExtenInfo(id);
            CustomizeExtenVO customizeExtenVO = (CustomizeExtenVO)customizeExtenInfo.getInfo();
            content.append(",\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u540d\u79f0=").append(customizeExtenVO.getCustomizeExtenName()).append(",OID=").append(customizeExtenVO.getCustomizeExtenOid());
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u5931\u8d25");
            throw new ServiceException("\u5220\u9664\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u5931\u8d25,", (Throwable)e);
        }
        return Result.success(null, (String)content.toString());
    }

    public Result getCustomizeExtenStatusByExtenId(long custonizeExtenId) {
        int status;
        this.logger.debug("\u83b7\u53d6\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u7684\u72b6\u6001\u5f00\u59cb\uff01");
        try {
            status = this.customizeExtenDao.getCustomizeExtenStatusByExtenId(custonizeExtenId);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u7684\u72b6\u6001\u5931\u8d25");
            throw new ServiceException("\u83b7\u53d6\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u7684\u72b6\u6001\u5931\u8d25,", (Throwable)e);
        }
        return Result.success((Object)status);
    }

    public Result queryCustomizeExten() {
        this.logger.debug("\u83b7\u53d6\u6240\u6709\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u4fe1\u606f\u4e0d\u5206\u9875\u5f00\u59cb\uff01");
        ArrayList<CustomizeExtenVO> customizeExtenVOS = new ArrayList<CustomizeExtenVO>();
        try {
            List customizeExtensionDOs = this.customizeExtenDao.queryCustonizeExten();
            for (CustomizeExtensionDO item : customizeExtensionDOs) {
                CustomizeExtenVO customizeExtenVO = new CustomizeExtenVO();
                BeanUtils.copyProperties((Object)item, (Object)customizeExtenVO);
                customizeExtenVOS.add(customizeExtenVO);
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6240\u6709\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u4fe1\u606f\u4e0d\u5206\u9875\u5931\u8d25");
            throw new ServiceException("\u83b7\u53d6\u6240\u6709\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u4fe1\u606f\u4e0d\u5206\u9875\u5931\u8d25,", (Throwable)e);
        }
        return Result.success(customizeExtenVOS);
    }

    public Result saveTempAndCustomizeExten(long templateId, List<TemplateCustomizeExtensionVO> templateCustomizeExtensionVOs) {
        this.logger.debug("\u4fdd\u5b58\u6a21\u677f\u548c\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u5173\u7cfb\u5f00\u59cb\uff01");
        TemplateCustomizeExtensionVO templateCustomizeExtensionVO = templateCustomizeExtensionVOs.get(0);
        if (null == templateCustomizeExtensionVO) {
            return Result.success();
        }
        ArrayList<TemplateCustomizeExtensionDO> templateCustomizeExtensionDOS = new ArrayList<TemplateCustomizeExtensionDO>();
        try {
            Result result = this.getCertCustomizeExtenInfo(templateId);
            if (null != result.getInfo()) {
                this.deleteCertCustomizeExtenInfo(templateId);
            }
            for (TemplateCustomizeExtensionVO item : templateCustomizeExtensionVOs) {
                TemplateCustomizeExtensionDO templateCustomizeExtensionDO = new TemplateCustomizeExtensionDO();
                BeanUtils.copyProperties((Object)item, (Object)templateCustomizeExtensionDO);
                templateCustomizeExtensionDO.setTemplateId(Long.valueOf(templateId));
                templateCustomizeExtensionDO.setGmtCreate(new Date());
                templateCustomizeExtensionDO.setGmtModified(new Date());
                templateCustomizeExtensionDOS.add(templateCustomizeExtensionDO);
            }
            this.customizeExtenDao.saveTempAndCustomizeExten(templateCustomizeExtensionDOS);
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u6a21\u677f\u548c\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u5173\u7cfb\u5931\u8d25");
            throw new ServiceException("\u4fdd\u5b58\u6a21\u677f\u548c\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u5173\u7cfb\u5931\u8d25,", (Throwable)e);
        }
        return Result.success();
    }

    public Result getCertCustomizeExtenInfo(long tempId) {
        ArrayList<TemplateCustomizeExtensionVO> templateCustomizeExtensionVOS = new ArrayList<TemplateCustomizeExtensionVO>();
        try {
            List list = this.customizeExtenDao.getCertCustomizeExtenInfo(tempId);
            if (null == list) {
                return Result.success();
            }
            for (TemplateCustomizeExtensionDTO item : list) {
                TemplateCustomizeExtensionVO templateCustomizeExtensionVO = new TemplateCustomizeExtensionVO();
                BeanUtils.copyProperties((Object)item, (Object)templateCustomizeExtensionVO);
                templateCustomizeExtensionVOS.add(templateCustomizeExtensionVO);
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6a21\u677f\u5bf9\u5e94\u6240\u6709\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u5931\u8d25,");
            throw new ServiceException("\u83b7\u53d6\u6a21\u677f\u5bf9\u5e94\u6240\u6709\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u5931\u8d25,", (Throwable)e);
        }
        return Result.success(templateCustomizeExtensionVOS);
    }

    public Result deleteCertCustomizeExtenInfo(long tempId) {
        try {
            this.customizeExtenDao.deleteCertCustomizeExtenInfo(tempId);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u6a21\u677f\u548c\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u5173\u7cfb\u5931\u8d25");
            throw new ServiceException("\u5220\u9664\u6a21\u677f\u548c\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u5173\u7cfb\u5931\u8d25,", (Throwable)e);
        }
        return Result.success();
    }
}

