/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.outdatecert;

import com.xdja.pki.ca.certmanager.dao.ArchiveCertDao;
import com.xdja.pki.ca.certmanager.dao.OutdateCertDao;
import com.xdja.pki.ca.certmanager.dao.models.ArchiveCertDO;
import com.xdja.pki.ca.certmanager.dao.models.OutdateCertDO;
import com.xdja.pki.ca.certmanager.service.convert.CertConverter;
import com.xdja.pki.ca.certmanager.service.outdatecert.OutDateCertService;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.exception.ServiceException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutDateCertServiceImpl
implements OutDateCertService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    OutdateCertDao outdateCertDao;
    @Autowired
    ArchiveCertDao archiveCertDao;

    public Result deleteOutDateCertBetweenDate(String archiveTime) {
        this.logger.info("\u5220\u9664\u9700\u8981\u5f52\u6863\u7684\u8bc1\u4e66============" + archiveTime);
        try {
            this.outdateCertDao.deleteOutDateCert(archiveTime);
            return Result.success();
        }
        catch (Exception e) {
            throw new ServiceException("\u5220\u9664\u9700\u8981\u5f52\u6863\u7684\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result queryOutDateCertToArchive(String archiveTime) {
        this.logger.info("\u67e5\u8be2\u5f85\u5f52\u6863\u7684\u8bc1\u4e66============" + archiveTime);
        Result result = new Result();
        try {
            List outdateCertList = this.outdateCertDao.queryOutDateCertToArchive(archiveTime);
            result.setInfo((Object)outdateCertList);
            return result;
        }
        catch (Exception e) {
            throw new ServiceException("\u67e5\u8be2\u5f85\u5f52\u6863\u7684\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result doRecoveryArchivedCertToOutDateCert(String certSn, Integer keyAlg, long current) {
        this.logger.info("|{}|\u6062\u590d\u5df2\u5f52\u6863\u7684\u8fc7\u671f\u8bc1\u4e66 ============ [certSn={}&keyAlg={}] ", new Object[]{current, certSn, keyAlg});
        try {
            ArchiveCertDO archiveCertDO = this.archiveCertDao.getArchiveCertBySn(certSn, keyAlg);
            if (archiveCertDO == null) {
                this.logger.info("|{}|\u5f52\u6863\u8bc1\u4e66\u5df2\u6062\u590d\u8fc7\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c ============ [certSn={}&keyAlg={}] ", new Object[]{current, certSn, keyAlg});
                return Result.success();
            }
            OutdateCertDO outdateCertDO = CertConverter.archiveToOutCert(archiveCertDO, System.currentTimeMillis());
            this.outdateCertDao.insertOutDateCert(outdateCertDO);
            this.archiveCertDao.deleteArchiveCertById(archiveCertDO.getId());
            this.logger.info("|{}|\u5f52\u6863\u8bc1\u4e66\u6062\u590d delete archive cert [sn={}]", (Object)current, (Object)certSn);
            return Result.success();
        }
        catch (Exception e) {
            throw new ServiceException("\u6062\u590d\u5df2\u5f52\u6863\u7684\u8fc7\u671f\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
        }
    }
}

