/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.ra;

import com.xdja.pki.ca.certmanager.dao.models.TemplateDO;
import com.xdja.pki.ca.certmanager.dao.models.ra.TRA;
import com.xdja.pki.ca.certmanager.dao.models.ra.TRATemplate;
import com.xdja.pki.ca.certmanager.dao.ra.RAlistQueryResult;
import com.xdja.pki.ca.certmanager.dao.ra.RAmanagerDao;
import com.xdja.pki.ca.certmanager.service.ra.IRAmanagerService;
import com.xdja.pki.ca.certmanager.service.ra.bean.RAListsReqBean;
import com.xdja.pki.ca.certmanager.service.ra.bean.RATemplateRep;
import com.xdja.pki.ca.certmanager.service.ra.bean.RATemplateSaveReq;
import com.xdja.pki.ca.certmanager.service.ra.bean.RAinfoListsRep;
import com.xdja.pki.ca.certmanager.service.ra.bean.RAinfoSaveReq;
import com.xdja.pki.ca.certmanager.service.ra.bean.RAinfoShowRep;
import com.xdja.pki.ca.certmanager.service.ra.bean.RAinfoUpdateReq;
import com.xdja.pki.ca.certmanager.service.ra.bean.UniqueReq;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.enums.TemplateTypeEnum;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.DnUtil;
import com.xdja.pki.ca.core.util.verify.ParmsCommonVerifyUtil;
import com.xdja.pki.ca.core.util.verify.VerifyCertDnUtil;
import com.xdja.pki.ca.securitymanager.dao.CaDao;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.naming.NamingException;
import org.bouncycastle.asn1.x500.X500Name;
import org.nutz.dao.pager.Pager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class RAmanagerServiceImpl
implements IRAmanagerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RAmanagerDao raManagerDao;
    @Autowired
    private CaDao caDao;
    @Value(value="${dn.length}")
    private String DNLength;

    public Result getRAlistsByName(RAListsReqBean RAListsReqBean2) {
        Pager pager = new Pager(RAListsReqBean2.getPageNo(), RAListsReqBean2.getPageSize());
        RAlistQueryResult ralistQueryResult = null;
        try {
            ralistQueryResult = this.raManagerDao.getRAlistsByName(RAListsReqBean2.getName(), pager);
        }
        catch (DAOException e) {
            this.logger.error("\u67e5\u8be2RA\u5217\u8868\u5f02\u5e38\uff0c");
            throw new ServiceException("\u67e5\u8be2RA\u5217\u8868\u670d\u52a1\u8d39\u5f02\u5e38,", (Throwable)e);
        }
        List rAlists = ralistQueryResult.getRAlists();
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNo(ralistQueryResult.getPager().getPageNumber());
        pageInfo.setPageSize(ralistQueryResult.getPager().getPageSize());
        pageInfo.setRecordCount(ralistQueryResult.getPager().getRecordCount());
        ArrayList<RAinfoListsRep> datalist = new ArrayList<RAinfoListsRep>();
        for (TRA rainfo : rAlists) {
            RAinfoListsRep rainfoRep = new RAinfoListsRep();
            BeanUtils.copyProperties((Object)rainfo, (Object)rainfoRep);
            datalist.add(rainfoRep);
        }
        pageInfo.setDatas(datalist);
        return Result.success((Object)pageInfo);
    }

    public Result getCAbaseDN() {
        CaInfoVO caInfo = null;
        try {
            caInfo = (CaInfoVO)Constants.CA_INFO.get(this.caDao.getCaInfo().getKeyAlg());
        }
        catch (Exception e) {
            throw new ServiceException("\u67e5\u8be2CA\u7684BaseDn\u5f02\u5e38,", (Throwable)e);
        }
        String baseDnStr = null;
        if (caInfo != null) {
            baseDnStr = caInfo.getBaseDn();
        }
        HashMap<String, String> baseDnMap = new HashMap<String, String>();
        if (!StringUtils.isEmpty((Object)baseDnStr)) {
            baseDnMap.put("baseDn", baseDnStr);
            return Result.success(baseDnMap);
        }
        return Result.failure((ErrorEnum)ErrorEnum.BASEDN_NOT_EXIST);
    }

    public Result saveRAinfo(RAinfoSaveReq RAinfo) {
        boolean isIpv4 = ParmsCommonVerifyUtil.isIpv4((String)RAinfo.getIp());
        if (!isIpv4) {
            this.logger.error("IP\u5730\u5740\u683c\u5f0f\u9519\u8bef\uff01");
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        String raBaseDn = RAinfo.getRaBaseDn();
        Result result = this.verifyRaBaseDn(raBaseDn);
        if (!result.isSuccess()) {
            this.logger.error("BaseDn\u683c\u5f0f\u9519\u8bef\uff01");
            return result;
        }
        try {
            RAinfo.setRaBaseDn(DnUtil.getRFC4519X500Name((String)raBaseDn).toString());
            TRA ra = new TRA();
            ra.setGmt_create(new Date(System.currentTimeMillis()));
            BeanUtils.copyProperties((Object)RAinfo, (Object)ra);
            this.raManagerDao.saveRA(ra);
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58RA\u5b9e\u4f53\u4fe1\u606f\u5931\u8d25,");
            throw new ServiceException("\u4fdd\u5b58RA\u5b9e\u4f53\u4fe1\u606f\u670d\u52a1\u5931\u8d25,", (Throwable)e);
        }
        return Result.success();
    }

    public Result getRAinfo(long id) {
        TRA ra = null;
        try {
            ra = this.raManagerDao.getRA(id);
        }
        catch (DAOException e) {
            this.logger.error("\u67e5\u8be2RA\u8be6\u60c5\u5931\u8d25");
            throw new ServiceException("\u67e5\u8be2RA\u8be6\u60c5\u670d\u52a1\u5931\u8d25,", (Throwable)e);
        }
        RAinfoShowRep rainfoShowRep = null;
        if (ra == null) {
            return Result.failure((ErrorEnum)ErrorEnum.RA_INFO_NOT_EXIST);
        }
        rainfoShowRep = new RAinfoShowRep();
        BeanUtils.copyProperties((Object)ra, (Object)rainfoShowRep);
        CaInfoVO caInfo = (CaInfoVO)Constants.CA_INFO.get(this.caDao.getCaInfo().getKeyAlg());
        String raDn = ra.getRaBaseDn().substring(0, ra.getRaBaseDn().length() - caInfo.getBaseDn().length() - 1);
        rainfoShowRep.setRaDn(raDn);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        rainfoShowRep.setCreateTime(sdf.format(ra.getGmt_create()));
        return Result.success((Object)rainfoShowRep);
    }

    public Result updateRAinfo(RAinfoUpdateReq rainfoUpdateReq) {
        boolean isIpv4 = ParmsCommonVerifyUtil.isIpv4((String)rainfoUpdateReq.getIp());
        if (!isIpv4) {
            this.logger.error("IP\u5730\u5740\u683c\u5f0f\u9519\u8bef\uff01");
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        String raBaseDn = rainfoUpdateReq.getRaBaseDn();
        Result result = this.verifyRaBaseDn(raBaseDn);
        if (!result.isSuccess()) {
            this.logger.error("BaseDn\u683c\u5f0f\u9519\u8bef\uff01");
            return result;
        }
        try {
            TRA ra = new TRA();
            rainfoUpdateReq.setRaBaseDn(DnUtil.getRFC4519X500Name((String)raBaseDn).toString());
            ra.setGmt_modified(new Date(System.currentTimeMillis()));
            BeanUtils.copyProperties((Object)rainfoUpdateReq, (Object)ra);
            this.raManagerDao.updateRA(ra);
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0RA\u5b9e\u4f53\u4fe1\u606f\u670d\u52a1\u5931\u8d25");
            throw new ServiceException("\u66f4\u65b0RA\u5b9e\u4f53\u4fe1\u606f\u670d\u52a1\u5931\u8d25,", (Throwable)e);
        }
        return Result.success();
    }

    public Result getRATemplateById(long id) {
        ArrayList<RATemplateRep> RATemplateRepList = new ArrayList<RATemplateRep>();
        List templates = null;
        List raTemplates = null;
        try {
            templates = this.raManagerDao.getUserTemplates(Integer.valueOf(TemplateTypeEnum.USER.value));
            raTemplates = this.raManagerDao.getRATemplateById(id);
        }
        catch (DAOException e) {
            this.logger.error("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u5f02\u5e38");
            throw new ServiceException("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u5f02\u5e38,", (Throwable)e);
        }
        if (templates != null && !templates.isEmpty()) {
            for (TemplateDO template : templates) {
                RATemplateRep RATemplateRep2 = new RATemplateRep();
                BeanUtils.copyProperties((Object)template, (Object)RATemplateRep2);
                int status = template.getStatus();
                boolean isNotCancel = true;
                if (status == 3) {
                    isNotCancel = false;
                }
                if (raTemplates != null && !raTemplates.isEmpty()) {
                    for (TRATemplate raTemplate : raTemplates) {
                        if (raTemplate.getTemplateId() != template.getId().longValue()) continue;
                        RATemplateRep2.setBound(true);
                        isNotCancel = true;
                    }
                }
                if (!isNotCancel) continue;
                RATemplateRepList.add(RATemplateRep2);
            }
        }
        return Result.success(RATemplateRepList);
    }

    public Result saveRATemplates(RATemplateSaveReq raTemplateSaveReq) {
        long raId = raTemplateSaveReq.getId();
        String templateIds = raTemplateSaveReq.getTemplateIds();
        Object[] raTemplateIds = null;
        String raTemplateStr = "";
        try {
            if (!StringUtils.isEmpty((Object)templateIds) && (raTemplateIds = templateIds.split("#")).length > 0) {
                raTemplateStr = Arrays.toString(raTemplateIds);
                List templates = this.raManagerDao.getUserTemplates(Integer.valueOf(TemplateTypeEnum.USER.value));
                for (Object raTemplateId : raTemplateIds) {
                    boolean isRaTemplateExist = false;
                    long templateId = Long.parseLong((String)raTemplateId);
                    for (TemplateDO template : templates) {
                        if (templateId != template.getId()) continue;
                        isRaTemplateExist = true;
                        break;
                    }
                    if (isRaTemplateExist) continue;
                    return Result.failure((ErrorEnum)ErrorEnum.TEMPLATEID_NOT_EXIST);
                }
            }
            List raTemplateStopIds = this.raManagerDao.getRATemplateByStatus(raId, 3);
            for (Long raTemplateStopId : raTemplateStopIds) {
                String raTemplateStopIdStr = String.valueOf(raTemplateStopId);
                boolean ishasTemplateStop = raTemplateStr.contains(raTemplateStopIdStr);
                if (ishasTemplateStop) continue;
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_STOPED_CANNOT_CANCEL);
            }
            this.raManagerDao.resetRATemplate(raId);
            if (null != raTemplateIds && raTemplateIds.length > 0) {
                TRATemplate TRATemplate2 = new TRATemplate();
                TRATemplate2.setRaId(Long.valueOf(raId));
                Arrays.asList(raTemplateIds).forEach(tempId -> {
                    TRATemplate2.setTemplateId(Long.valueOf(Long.parseLong(tempId)));
                    TRATemplate2.setStatus(Integer.valueOf(1));
                    TRATemplate2.setGmt_create(new Date(System.currentTimeMillis()));
                    this.raManagerDao.saveRATemplate(TRATemplate2);
                });
            }
        }
        catch (DAOException e) {
            this.logger.error("\u4fdd\u5b58RA\u6388\u6743\u6a21\u677f\u670d\u52a1\u5931\u8d25\uff0c");
            throw new ServiceException("\u4fdd\u5b58RA\u6388\u6743\u6a21\u677f\u670d\u52a1\u5931\u8d25\uff0c", (Throwable)e);
        }
        return Result.success();
    }

    public Result verifyRaBaseDn(String raBaseDn) {
        X500Name x500Name = null;
        try {
            x500Name = DnUtil.getRFC4519X500Name((String)raBaseDn);
        }
        catch (Exception e) {
            this.logger.info("raBaseDn\u683c\u5f0f\u4e0d\u6b63\u786e{}", (Object)e.getMessage());
            return Result.failure((ErrorEnum)ErrorEnum.DN_FORMAT_FAIL);
        }
        Result checkResult = null;
        try {
            checkResult = VerifyCertDnUtil.checkDn((String)raBaseDn, (Integer)Integer.parseInt(this.DNLength));
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        checkResult = VerifyCertDnUtil.checkCertDnSymbol((String)raBaseDn);
        if (!checkResult.isSuccess()) {
            this.logger.info("\u8bc1\u4e66\u7684DN\u7684\u7279\u6b8a\u7b26\u53f7\u6821\u9a8c\u6709\u8bef\u3010{}\u3011", (Object)raBaseDn);
            return checkResult;
        }
        checkResult = VerifyCertDnUtil.checkCertDnSort((X500Name)x500Name);
        if (!checkResult.isSuccess()) {
            this.logger.info("\u8bc1\u4e66\u7684DN\u7684\u7c7b\u578b\u5148\u540e\u987a\u5e8f\u6709\u8bef\u3010{}\u3011", (Object)raBaseDn);
            return checkResult;
        }
        return Result.success();
    }

    public Result verifyRaBaseDn(String raBaseDn, Integer id) {
        Result result = this.verifyRaBaseDn(raBaseDn);
        if (!result.isSuccess()) {
            return result;
        }
        try {
            int size = this.raManagerDao.getRaBaseDnUnique(raBaseDn, id);
            UniqueReq uniqueReq = new UniqueReq();
            if (size == 0) {
                uniqueReq.setUnique(true);
            }
            return Result.success((Object)uniqueReq);
        }
        catch (DAOException e) {
            this.logger.error("\u6821\u9a8craBaseDn\u683c\u5f0f\u548c\u552f\u4e00\u6027\u5931\u8d25");
            throw new ServiceException("\u6821\u9a8craBaseDn\u683c\u5f0f\u548c\u552f\u4e00\u6027\u5931\u8d25,", (Throwable)e);
        }
    }

    public Result verifyRaName(String raName, Integer id) {
        try {
            int size = this.raManagerDao.getRaNameUnique(raName, id);
            UniqueReq uniqueReq = new UniqueReq();
            if (size == 0) {
                uniqueReq.setUnique(true);
            }
            return Result.success((Object)uniqueReq);
        }
        catch (DAOException e) {
            this.logger.error("\u6821\u9a8craName\u552f\u4e00\u6027\u5931\u8d25");
            throw new ServiceException("\u6821\u9a8craName\u552f\u4e00\u6027\u5931\u8d25,", (Throwable)e);
        }
    }

    public Result verifyRaIp(String raIp, Integer id) {
        boolean isIpv4 = ParmsCommonVerifyUtil.isIpv4((String)raIp);
        if (!isIpv4) {
            this.logger.error("IP\u5730\u5740\u683c\u5f0f\u9519\u8bef\uff01");
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        try {
            int size = this.raManagerDao.getRaIpUnique(raIp, id);
            UniqueReq uniqueReq = new UniqueReq();
            if (size == 0) {
                uniqueReq.setUnique(true);
            }
            return Result.success((Object)uniqueReq);
        }
        catch (DAOException e) {
            this.logger.error("\u6821\u9a8craIp\u552f\u4e00\u6027\u5931\u8d25");
            throw new ServiceException("\u6821\u9a8craIp\u552f\u4e00\u6027\u5931\u8d25,", (Throwable)e);
        }
    }
}

