/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.racert;

import com.xdja.pki.ca.certmanager.dao.RaTemplateDao;
import com.xdja.pki.ca.certmanager.dao.models.RaDO;
import com.xdja.pki.ca.certmanager.service.crltemplate.CrlTemplateService;
import com.xdja.pki.ca.certmanager.service.racert.OpenApiCMPManagerService;
import com.xdja.pki.ca.certmanager.service.racert.RaManagerCertService;
import com.xdja.pki.ca.certmanager.service.racert.bean.CMPReqCacheVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.IssueRaCertVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.RACertResponseVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.RARoleEnum;
import com.xdja.pki.ca.certmanager.service.racert.bean.RevokeCertVO;
import com.xdja.pki.ca.certmanager.service.task.TaskDataService;
import com.xdja.pki.ca.certmanager.service.template.TemplateService;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateInfoVO;
import com.xdja.pki.ca.certmanager.service.util.ExtensionUtil;
import com.xdja.pki.ca.certmanager.service.util.TemplateParamsUtil;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.ca.util.gm.cert.RsaAlgUtils;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.enums.TemplateStatusEnum;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.time.IssueTimeUtil;
import com.xdja.pki.ca.hsm.manager.HsmManager;
import com.xdja.pki.ca.ldap.service.vo.LdapOcspUrlVO;
import com.xdja.pki.ca.securitymanager.dao.CertSnDao;
import com.xdja.pki.ca.securitymanager.service.init.InitService;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.x500.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OpenApiCMPManagerServiceImpl
implements OpenApiCMPManagerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TemplateService templateService;
    @Autowired
    private RaManagerCertService raManagerCertService;
    @Autowired
    private HsmManager hsmService;
    @Autowired
    private CrlTemplateService crlTemplateService;
    @Autowired
    private CertSnDao certSnDao;
    @Autowired
    private TaskDataService taskDataService;
    @Autowired
    private InitService initService;
    @Autowired
    private RaTemplateDao raTemplateDao;

    public Result doIssueManagerCert(PublicKey signPublicKey, PublicKey encPublicKey, X500Name dn, String tempNo, String tempParas, CertTemplate certTemplate, Long raId, String reqId) {
        try {
            this.logger.info("\u6536\u5230CMP\u7ba1\u7406\u5458\u8bc1\u4e66\u7b7e\u53d1\u8bf7\u6c42\uff1areqId=" + reqId + ",dn=" + dn.toString() + ",tempNo=" + tempNo + ",tempParas=" + tempParas);
            TemplateInfoVO templateInfoVO = this.templateService.getInnerTemplateByCode(tempNo);
            List extensionVO = templateInfoVO.getExtensions();
            CaInfoVO caInfoVO = this.initService.getCaInfo(Constants.BASE_ALG_TYPE);
            Result result = this.checkIssueCertParams(templateInfoVO, signPublicKey, caInfoVO, raId, tempParas, dn);
            if (!result.isSuccess()) {
                return result;
            }
            Date nowTime = new Date();
            Date beginTime = certTemplate.getValidity().getNotBefore().getDate();
            X509Certificate rootCert = caInfoVO.getRootCert();
            Date endTime = IssueTimeUtil.getUserIssueAfterTime((Date)certTemplate.getValidity().getNotAfter().getDate(), (Integer)templateInfoVO.getMaxValidity(), (Date)rootCert.getNotAfter(), (Date)beginTime);
            BigInteger signSn = this.certSnDao.getMaxSn(beginTime);
            LdapOcspUrlVO signLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(signSn, dn.toString(), caInfoVO, false, null, null);
            List signExtensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), null, (PublicKey)signPublicKey, (String)dn.toString(), (LdapOcspUrlVO)signLdapOcspUrlVO, (boolean)true);
            X509Certificate signCert = this.hsmService.genX509Certificate(dn.toString(), signSn, beginTime, endTime, caInfoVO, signPublicKey, signExtensions, templateInfoVO.getSignAlg());
            BigInteger encSn = this.certSnDao.getMaxSn(beginTime);
            LdapOcspUrlVO encLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(encSn, dn.toString(), caInfoVO, false, null, null);
            List encExtensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), null, (PublicKey)encPublicKey, (String)dn.toString(), (LdapOcspUrlVO)encLdapOcspUrlVO, (boolean)false);
            X509Certificate encCert = this.hsmService.genX509Certificate(dn.toString(), encSn, beginTime, endTime, caInfoVO, encPublicKey, encExtensions, templateInfoVO.getSignAlg());
            this.saveRaAdminCert(caInfoVO.getCertId(), signCert, encCert, raId, templateInfoVO);
            CMPReqCacheVO cmpReqCacheVO = new CMPReqCacheVO(signSn.toString(16), encSn.toString(16), templateInfoVO.getKeyAlg(), false);
            Constants.CMP_REQ_INFO.put(reqId, cmpReqCacheVO);
            this.logger.debug("cmp\u8bf7\u6c42id\u4fe1\u606f\u5199\u5165\u7f13\u5b58\u6210\u529f\uff0creqId=" + reqId + ",signSn=" + signSn.toString(16) + ",encSn=" + encSn.toString(16));
            this.logger.info("CMP\u7ba1\u7406\u5458\u8bc1\u4e66\u7b7e\u53d1\u6210\u529f\uff0creqId=" + reqId + ",signCert=" + CertUtil.writeObject((Object)signCert) + ",encCert=" + CertUtil.writeObject((Object)encCert));
            return Result.success((Object)new RACertResponseVO(signCert, encCert, templateInfoVO.getKeyAlg()));
        }
        catch (Exception e) {
            this.logger.error("CMP\u7ba1\u7406\u5458\u8bc1\u4e66\u7b7e\u53d1\u5931\u8d25\uff1areqId=" + reqId + ",dn=" + dn.toString() + ",tempNo=" + tempNo + ",tempParas=" + tempParas, (Throwable)e);
            throw new ServiceException("CMP\u7b7e\u53d1\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    private Result checkIssueCertParams(TemplateInfoVO templateInfoVO, PublicKey publicKey, CaInfoVO caInfoVO, Long raId, String tempParas, X500Name dn) {
        if (null == templateInfoVO) {
            this.logger.debug("cmp\u7b7e\u53d1\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u6a21\u677f\u4fe1\u606f[{}]", (Object)dn.toString());
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
        }
        if (TemplateStatusEnum.NORMAL.value != templateInfoVO.getStatus()) {
            this.logger.info("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u7ed3\u679c\uff1a\u6a21\u677f\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u6a21\u677f\u72b6\u6001\u4e3a[{}]", (Object)templateInfoVO.getStatus());
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
        }
        RaDO raDO = this.raTemplateDao.getRaDoById(raId);
        if (null == raDO || !dn.toString().toLowerCase().endsWith(raDO.getBaseDn().toLowerCase())) {
            this.logger.info("CMP\u7b7e\u53d1\u53cc\u8bc1\u4e66\u5931\u8d25: \u7528\u6237\u7684baseDN[{}]\u548cRA\u7684BaseDn[{}]\u4e0d\u4e00\u81f4", (Object)dn.toString(), (Object)raDO.getBaseDn());
            return Result.failure((ErrorEnum)ErrorEnum.USER_DN_NOT_SAME_RA_BASEDN);
        }
        Result result = TemplateParamsUtil.validity((TemplateInfoVO)templateInfoVO, (String)tempParas);
        if (!result.isSuccess()) {
            this.logger.info("CMP\u7b7e\u53d1\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1a\u7f3a\u5c11\u6a21\u677f\u9700\u8981\u53c2\u6570");
            return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        if (null == caInfoVO || StringUtils.isBlank((CharSequence)caInfoVO.getBaseDn()) || null == caInfoVO.getRootCert()) {
            this.logger.debug("cmp\u7b7e\u53d1\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u5230CA\u57fa\u672c\u4fe1\u606f[{}]", (Object)dn.toString());
            return Result.failure((ErrorEnum)ErrorEnum.CA_BASEINFO_GET_FAIL);
        }
        if (!dn.toString().toLowerCase().endsWith(caInfoVO.getBaseDn().toLowerCase())) {
            this.logger.debug("cmp\u7b7e\u53d1\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e2d\u7684baseDn\u4e0d\u6b63\u786e[{}]", (Object)dn.toString());
            return Result.failure((ErrorEnum)ErrorEnum.BASEDN_ERROR);
        }
        result = RsaAlgUtils.checkPublicParams((PublicKey)publicKey, (Integer)templateInfoVO.getKeyAlg(), (Integer)templateInfoVO.getKeySize());
        return result;
    }

    private void saveRaAdminCert(Long caCertId, X509Certificate signCert, X509Certificate encCert, Long raId, TemplateInfoVO templateInfoVO) throws Exception {
        IssueRaCertVO issueRaCertVO = new IssueRaCertVO();
        issueRaCertVO.setCertType(Integer.valueOf(RARoleEnum.BUSINESS_OPERATER.value));
        issueRaCertVO.setId(raId);
        this.raManagerCertService.saveRaAdminCert(caCertId, signCert, encCert, issueRaCertVO, templateInfoVO);
    }

    public Result doUpdateManagerCert(String signSn, Integer alg, CertTemplate certTemplate, PublicKey signPublicKey, PublicKey encPublicKey, X500Name dn, Long raId, String reqId) {
        try {
            IssueRaCertVO issueRaCertVO = this.buildIssueRaCertData(raId, dn, signPublicKey, encPublicKey, signSn);
            Result result = this.raManagerCertService.doUpdateRaManagerCert(issueRaCertVO, certTemplate, raId);
            if (result.isSuccess()) {
                Map map = (Map)result.getInfo();
                String newSignSn = map.get("signSn").toString();
                String newEncSn = map.get("encSn").toString();
                CMPReqCacheVO cmpReqCacheVO = new CMPReqCacheVO(newSignSn, newEncSn, alg, false);
                Constants.CMP_REQ_INFO.put(reqId, cmpReqCacheVO);
                this.logger.debug("cmp\u8bf7\u6c42id\u4fe1\u606f\u5199\u5165\u7f13\u5b58\u6210\u529f\uff0creqId=" + reqId + ",signSn=" + newSignSn + ",encSn=" + newEncSn);
                this.logger.info("CMP\u7ba1\u7406\u5458\u8bc1\u4e66\u66f4\u65b0\u6210\u529f\uff0creqId=");
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("CMP\u66f4\u65b0RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("CMP\u7ba1\u7406\u5458\u8bc1\u4e66\u66f4\u65b0\u5f02\u5e38", (Throwable)e);
        }
    }

    private IssueRaCertVO buildIssueRaCertData(Long raId, X500Name dn, PublicKey signPublicKey, PublicKey encPublicKey, String signSn) {
        IssueRaCertVO issueRaCertVO = new IssueRaCertVO();
        issueRaCertVO.setId(raId);
        issueRaCertVO.setCertType(Integer.valueOf(RARoleEnum.BUSINESS_OPERATER.value));
        issueRaCertVO.setCertDn(dn.toString());
        issueRaCertVO.setDnUpdate(true);
        if (null != signPublicKey) {
            issueRaCertVO.setKeyUpdate(true);
            issueRaCertVO.setSignPublicKey(signPublicKey);
            issueRaCertVO.setEncPublicKey(encPublicKey);
        }
        issueRaCertVO.setSn(signSn);
        return issueRaCertVO;
    }

    public Result doAckManagerCertStatus(String reqId) {
        this.logger.info("CMP\u6536\u5230\u8bc1\u4e66\u72b6\u6001\u786e\u8ba4\u6d88\u606f\u5904\u7406\u8bf7\u6c42\uff0ctranID=" + reqId);
        try {
            CMPReqCacheVO cmpReqCacheVO = (CMPReqCacheVO)Constants.CMP_REQ_INFO.get(reqId);
            if (null != cmpReqCacheVO) {
                return this.raManagerCertService.doVerifyPriCertStatus(cmpReqCacheVO.getSignSn(), cmpReqCacheVO.getEncSn());
            }
            return Result.failure((ErrorEnum)ErrorEnum.ADMIN_CERT_ACK_ERROR);
        }
        catch (Exception e) {
            this.logger.debug("\u786e\u8ba4cmp\u8bc1\u4e66\u5199\u5361\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u786e\u8ba4cmp\u8bc1\u4e66\u5199\u5361\u72b6\u6001\u5931\u8d25\u5f02", (Throwable)e);
        }
    }

    public Result doErrAckManagerCertStatus(String reqId, ErrorMsgContent errorMsgContent) {
        try {
            CMPReqCacheVO cmpReqCacheVO = (CMPReqCacheVO)Constants.CMP_REQ_INFO.get(reqId);
            if (null != cmpReqCacheVO) {
                this.logger.error("CMP\u534f\u8bae\u8fd4\u56de\u5f02\u5e38\u786e\u8ba4\u6d88\u606f[{}]", (Object)("[ErrorMsgContent:errorCode=" + errorMsgContent.getErrorCode() + ",errorMsg=" + errorMsgContent.getErrorDetails().getStringAt(0).toString()));
                RevokeCertVO revokeCertVO = new RevokeCertVO();
                revokeCertVO.setSn(cmpReqCacheVO.getSignSn());
                revokeCertVO.setAlg(cmpReqCacheVO.getKeyAlg());
                revokeCertVO.setRevokeReason(Integer.valueOf(0));
                revokeCertVO.setRevokeNote("\u8bc1\u4e66\u5199\u5361\u5931\u8d25");
                Result result = this.raManagerCertService.deleteNotAckManagerCert(revokeCertVO);
                if (result.isSuccess()) {
                    Constants.CMP_REQ_INFO.remove(reqId);
                    return Result.success();
                }
            }
            return Result.failure((ErrorEnum)ErrorEnum.ADMIN_CERT_ACK_ERROR);
        }
        catch (Exception e) {
            this.logger.error("\u786e\u8ba4cmp\u8bc1\u4e66\u5199\u5361\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u786e\u8ba4cmp\u8bc1\u4e66\u5199\u5361\u72b6\u6001\u5931\u8d25\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result doRevokeManagerCert(String signSn, Integer alg, int revokeReason, String revokeNote) {
        try {
            return this.raManagerCertService.doRevokeManageDoubleCert(signSn, alg, revokeReason, revokeNote);
        }
        catch (Exception e) {
            this.logger.error("cmp\u64a4\u9500RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            throw new ServiceException("cmp\u64a4\u9500RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
        }
    }
}

