/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.racert;

import com.alibaba.fastjson.JSON;
import com.xdja.pki.ca.certcrl.service.impl.CrlService;
import com.xdja.pki.ca.certmanager.dao.CertDao;
import com.xdja.pki.ca.certmanager.dao.CertDataDao;
import com.xdja.pki.ca.certmanager.dao.CrlTemplateDao;
import com.xdja.pki.ca.certmanager.dao.DeltaRevokeCertDao;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.OutDateManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.OutdateCertDao;
import com.xdja.pki.ca.certmanager.dao.RaCertDao;
import com.xdja.pki.ca.certmanager.dao.RaTemplateDao;
import com.xdja.pki.ca.certmanager.dao.RevokeCertDao;
import com.xdja.pki.ca.certmanager.dao.RevokeManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.TemplateDao;
import com.xdja.pki.ca.certmanager.dao.TemplateUserCertDao;
import com.xdja.pki.ca.certmanager.dao.models.CertDO;
import com.xdja.pki.ca.certmanager.dao.models.CertDataDO;
import com.xdja.pki.ca.certmanager.dao.models.CrlTemplateDO;
import com.xdja.pki.ca.certmanager.dao.models.DeltaRevokedCertDO;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.OutdateCertDO;
import com.xdja.pki.ca.certmanager.dao.models.OutdateManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.RaCertDO;
import com.xdja.pki.ca.certmanager.dao.models.RaDO;
import com.xdja.pki.ca.certmanager.dao.models.RevokedCertDO;
import com.xdja.pki.ca.certmanager.dao.models.RevokedManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.TemplateDO;
import com.xdja.pki.ca.certmanager.dao.models.TemplateUserCertDO;
import com.xdja.pki.ca.certmanager.service.crltemplate.CrlTemplateService;
import com.xdja.pki.ca.certmanager.service.crltemplate.bean.CrlTemplateExtensionVO;
import com.xdja.pki.ca.certmanager.service.kms.KmsService;
import com.xdja.pki.ca.certmanager.service.kms.bean.ResponseBean;
import com.xdja.pki.ca.certmanager.service.racert.OpenApiCMPService;
import com.xdja.pki.ca.certmanager.service.racert.bean.CMPReqCacheVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.RACertResponseVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.RAServerCertVO;
import com.xdja.pki.ca.certmanager.service.task.TaskDataService;
import com.xdja.pki.ca.certmanager.service.template.TemplateService;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateInfoVO;
import com.xdja.pki.ca.certmanager.service.usercert.bean.UserCertSnVO;
import com.xdja.pki.ca.certmanager.service.util.ExtensionUtil;
import com.xdja.pki.ca.certmanager.service.util.TemplateParamsUtil;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.ca.util.gm.cert.RsaAlgUtils;
import com.xdja.pki.ca.core.common.Config;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.enums.CertPattermEnum;
import com.xdja.pki.ca.core.enums.CertStatusEnum;
import com.xdja.pki.ca.core.enums.TemplateStatusEnum;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.km.KmSoft;
import com.xdja.pki.ca.core.km.RetKeyRespond;
import com.xdja.pki.ca.core.util.CertUtils;
import com.xdja.pki.ca.core.util.SpringBeanUtil;
import com.xdja.pki.ca.core.util.json.JsonUtils;
import com.xdja.pki.ca.core.util.time.IssueTimeUtil;
import com.xdja.pki.ca.extension.util.ExtensionAttr;
import com.xdja.pki.ca.hsm.manager.HsmManager;
import com.xdja.pki.ca.ldap.service.vo.LdapOcspUrlVO;
import com.xdja.pki.ca.securitymanager.dao.CertIdDao;
import com.xdja.pki.ca.securitymanager.dao.CertSnDao;
import com.xdja.pki.ca.securitymanager.service.configfile.ConfigFileService;
import com.xdja.pki.ca.securitymanager.service.init.InitService;
import com.xdja.pki.ca.securitymanager.service.init.LicenseService;
import com.xdja.pki.ca.securitymanager.service.vo.AlgTypeEnum;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.UserCertTypeEnum;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OpenApiCMPServiceImpl
implements OpenApiCMPService {
    public static final String RSA_OID = "1.2.840.113549.1.1.1";
    public static final String ECC_SM2_OID = "1.2.156.10197.1.301.1";
    public static final String ECC_DSA_OID = "1.2.840.10045.3.1.7";
    public static final Integer DOUBLE_CERT = 2;
    public static final Integer KEY_LENGTH = 256;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CertDao certDao;
    @Autowired
    private RaCertDao raCertDao;
    @Autowired
    private RevokeCertDao revokeCertDao;
    @Autowired
    private CertDataDao certDataDao;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private CrlService crlService;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private OutdateCertDao outdateCertDao;
    @Autowired
    private ManagerCertDao managerCertDao;
    @Autowired
    private RevokeManagerCertDao revokeManagerCertDao;
    @Autowired
    private OutDateManagerCertDao outDateManagerCertDao;
    @Autowired
    private RaTemplateDao raTemplateDao;
    @Autowired
    private HsmManager hsmService;
    @Autowired
    private TaskDataService taskDataService;
    @Autowired
    private CertSnDao certSnDao;
    @Autowired
    private DeltaRevokeCertDao deltaRevokeCertDao;
    @Autowired
    private InitService initService;
    @Autowired
    private CertIdDao certIdDao;
    @Autowired
    private Environment env;
    @Autowired
    private TemplateUserCertDao templateUserCertDao;
    @Autowired
    CrlTemplateService crlTemplateService;
    @Autowired
    CrlTemplateDao crlTemplateDao;
    @Autowired
    LicenseService licenseService;
    @Autowired
    private ConfigFileService configFileService;
    private static volatile KmSoft kmSoft = new KmSoft();

    public Map<String, CaInfoVO> getCaInfo() {
        try {
            HashMap<String, CaInfoVO> map = new HashMap<String, CaInfoVO>();
            CaInfoVO rsaCaInfo = this.initService.getCaInfo(Integer.valueOf(AlgTypeEnum.RSA.value));
            map.put(RSA_OID, rsaCaInfo);
            CaInfoVO sm2CaInfo = this.initService.getCaInfo(Integer.valueOf(AlgTypeEnum.SM2.value));
            map.put(ECC_SM2_OID, sm2CaInfo);
            CaInfoVO nistCaInfo = this.initService.getCaInfo(Integer.valueOf(AlgTypeEnum.NISTP256.value));
            map.put(ECC_DSA_OID, nistCaInfo);
            if (null != sm2CaInfo) {
                this.logger.debug("\u6839\u8bc1\u4e66DN\uff1a" + CertUtil.getSubjectByX509Cert((X509Certificate)sm2CaInfo.getRootCert()));
            } else if (null != rsaCaInfo) {
                this.logger.debug("\u6839\u8bc1\u4e66DN\uff1a" + CertUtil.getSubjectByX509Cert((X509Certificate)rsaCaInfo.getRootCert()));
            } else {
                this.logger.debug("\u6839\u8bc1\u4e66DN\uff1a" + CertUtil.getSubjectByX509Cert((X509Certificate)nistCaInfo.getRootCert()));
            }
            return map;
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6CA\u57fa\u672c\u4fe1\u606f\u65f6\u5f02\u5e38", (Throwable)e);
        }
    }

    public UserCertSnVO getUserCertSn() {
        Date snTime = new Date();
        BigInteger signSn = this.certSnDao.getMaxSn(snTime);
        BigInteger encSn = this.certSnDao.getMaxSn(snTime);
        return new UserCertSnVO(signSn, encSn);
    }

    public Result issueUserCert(PublicKey publicKey, X500Name dn, String tempNo, String tempParas, CertTemplate certTemplate, Long raId, String reqId) {
        try {
            UserCertSnVO userCertSnVO = this.getUserCertSn();
            return this.doIssueUserDoubleCert(userCertSnVO.getSignSn(), userCertSnVO.getEncSn(), publicKey, dn, tempNo, tempParas, certTemplate, raId, reqId);
        }
        catch (Exception e) {
            this.logger.error("CMP\u7528\u6237\u8bc1\u4e66\u7b7e\u53d1\u5931\u8d25\uff1areqId=" + reqId + ",dn=" + dn.toString() + ",tempNo=" + tempNo + ",tempParas=" + tempParas, (Throwable)e);
            throw new ServiceException("CMP\u7b7e\u53d1\u7528\u6237\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public Result doIssueUserDoubleCert(BigInteger signSn, BigInteger encSn, PublicKey publicKey, X500Name dn, String tempNo, String tempParas, CertTemplate certTemplate, Long raId, String reqId) {
        try {
            CMPReqCacheVO cmpReqCacheVO;
            Map extensionAttrs;
            this.logger.info("\u6536\u5230CMP\u7528\u6237\u8bc1\u4e66\u7b7e\u53d1\u8bf7\u6c42\uff1areqId=" + reqId + ",dn=" + dn.toString() + ",tempNo=" + tempNo + ",tempParas=" + tempParas);
            Map templatesMap = this.templateService.getTemplatesByCodes(new String[]{tempNo});
            TemplateInfoVO templateInfoVO = (TemplateInfoVO)templatesMap.get(tempNo);
            if (null == templateInfoVO) {
                this.logger.debug("cmp\u7b7e\u53d1\u53cc\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u6a21\u677f\u4fe1\u606f[{}]", (Object)dn.toString());
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
            }
            CaInfoVO caInfoVO = this.initService.getCaInfo(templateInfoVO.getKeyAlg());
            Result result = this.checkIssueCertParams(templateInfoVO, publicKey, caInfoVO, raId, tempParas, dn);
            if (!result.isSuccess()) {
                return result;
            }
            Date beginTime = certTemplate.getValidity().getNotBefore().getDate();
            X509Certificate rootCert = caInfoVO.getRootCert();
            Date endTime = IssueTimeUtil.getUserIssueAfterTime((Date)certTemplate.getValidity().getNotAfter().getDate(), (Integer)templateInfoVO.getMaxValidity(), (Date)rootCert.getNotAfter(), (Date)beginTime);
            Result signCertResult = this.genX509Certificate(dn, beginTime, endTime, signSn, caInfoVO, templateInfoVO, publicKey, extensionAttrs = (Map)result.getInfo(), true);
            if (!signCertResult.isSuccess()) {
                return signCertResult;
            }
            X509Certificate signCert = (X509Certificate)signCertResult.getInfo();
            String signAndEvlopedDataBase64 = null;
            X509Certificate encCert = null;
            if (templateInfoVO.getCertPatterm() == CertPattermEnum.DOUBLE_CERT.id) {
                PublicKey encPublicKey = null;
                if (Constants.IS_KM) {
                    KmsService kmsService = null;
                    Config config = this.configFileService.getConfigInfo();
                    int kmSystemType = config.getKmSystemType();
                    if (kmSystemType == 1) {
                        kmsService = (KmsService)SpringBeanUtil.getBean((String)"kmsSansecService");
                    } else if (kmSystemType == 2) {
                        kmsService = (KmsService)SpringBeanUtil.getBean((String)"kmsXdjaHttpService");
                    }
                    this.logger.debug("\u5f00\u59cb\u5bc6\u7ba1\u7cfb\u7edf\u7533\u8bf7\u516c\u79c1\u94a5");
                    ResponseBean kmcKey = kmsService.applyEncKey(caInfoVO, encSn, publicKey, beginTime, caInfoVO.getRootCert().getNotAfter(), dn.toString(), null, null, templateInfoVO.getKeySize().intValue(), "SM4", "SM3");
                    String publicKeyStr = kmcKey.getPublicKeyStr();
                    if (StringUtils.isNotBlank((CharSequence)publicKeyStr)) {
                        encPublicKey = CertUtils.getPublicKeyBySubjectPublicInfo((String)kmcKey.getPublicKeyStr());
                        this.logger.debug("\u5bc6\u7ba1\u7cfb\u7edf\u8fd4\u56de\u4fe1\u606f\uff0c\u516c\u94a5\uff1a" + kmcKey.getPublicKeyStr() + "\uff0c\u79c1\u94a5:" + kmcKey.getPrivateKeyStr());
                    } else {
                        encPublicKey = kmcKey.getEncPublicKey();
                        this.logger.debug("\u5bc6\u7ba1\u7cfb\u7edf\u8fd4\u56de\u4fe1\u606f,\u79c1\u94a5:" + kmcKey.getPrivateKeyStr());
                    }
                    signAndEvlopedDataBase64 = kmcKey.getPrivateKeyStr();
                    this.logger.debug("\u5411\u5bc6\u7ba1\u7cfb\u7edf\u7533\u8bf7\u516c\u79c1\u94a5\u7ed3\u675f");
                } else {
                    this.logger.debug("\u5f00\u59cb\u5411KmSoft\u7533\u8bf7\u516c\u79c1\u94a5");
                    RetKeyRespond retKeyRespond = kmSoft.applyKey(templateInfoVO.getKeyAlg(), templateInfoVO.getKeySize().intValue(), dn.toString(), signSn, publicKey);
                    encPublicKey = retKeyRespond.getPublicKey();
                    signAndEvlopedDataBase64 = Base64.toBase64String((byte[])retKeyRespond.getEncryptedPrivateKey().getDEREncoded());
                    this.logger.info("\u5411KM\u7533\u8bf7\u52a0\u5bc6\u516c\u79c1\u94a5\u6210\u529f\uff0cencPrivate:" + Base64.toBase64String((byte[])retKeyRespond.getEncryptedPrivateKey().getDEREncoded()) + ",public=" + new String(Base64.encode((byte[])retKeyRespond.getPublicKey().getEncoded())));
                }
                Result encCertResult = this.genX509Certificate(dn, beginTime, endTime, encSn, caInfoVO, templateInfoVO, encPublicKey, extensionAttrs, false);
                if (!encCertResult.isSuccess()) {
                    return encCertResult;
                }
                encCert = (X509Certificate)encCertResult.getInfo();
                this.saveRaUserCert(caInfoVO, signCert, encCert, templateInfoVO, raId, null, null);
                cmpReqCacheVO = new CMPReqCacheVO(signSn.toString(16), encSn.toString(16), templateInfoVO.getKeyAlg(), false);
            } else {
                this.saveRaUserCert(caInfoVO, signCert, templateInfoVO, raId, null);
                cmpReqCacheVO = new CMPReqCacheVO(signSn.toString(16), null, templateInfoVO.getKeyAlg(), false);
            }
            Constants.CMP_REQ_INFO.put(reqId, cmpReqCacheVO);
            this.logger.debug("cmp\u8bf7\u6c42id\u4fe1\u606f\u5199\u5165\u7f13\u5b58\u6210\u529f\uff0creqId=" + reqId + ",signSn=" + signSn.toString(16));
            this.logger.info("CMP\u7528\u6237\u8bc1\u4e66\u7b7e\u53d1\u6210\u529f\uff0creqId=" + reqId + ",signCert=" + CertUtil.writeObject((Object)signCert) + ",encCert=" + CertUtil.writeObject(encCert) + ",encPriKey=" + signAndEvlopedDataBase64);
            return Result.success((Object)new RACertResponseVO(signCert, encCert, signAndEvlopedDataBase64));
        }
        catch (Exception e) {
            this.logger.error("CMP\u7528\u6237\u8bc1\u4e66\u7b7e\u53d1\u5931\u8d25\uff1areqId=" + reqId + ",dn=" + dn.toString() + ",tempNo=" + tempNo + ",tempParas=" + tempParas, (Throwable)e);
            throw new ServiceException("CMP\u7b7e\u53d1\u7528\u6237\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    private Result checkIssueCertParams(TemplateInfoVO templateInfoVO, PublicKey publicKey, CaInfoVO caInfoVO, Long raId, String tempParas, X500Name dn) {
        if (TemplateStatusEnum.NORMAL.value != templateInfoVO.getStatus()) {
            this.logger.info("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u7ed3\u679c\uff1a\u6a21\u677f\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u6a21\u677f\u72b6\u6001\u4e3a[{}]", (Object)templateInfoVO.getStatus());
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
        }
        Result result = RsaAlgUtils.checkPublicParams((PublicKey)publicKey, (Integer)templateInfoVO.getKeyAlg(), (Integer)templateInfoVO.getKeySize());
        if (!result.isSuccess()) {
            return result;
        }
        if (!this.raTemplateDao.verifyRATemplateRelate(raId, templateInfoVO.getId())) {
            this.logger.info("CMP\u7b7e\u53d1\u53cc\u8bc1\u4e66\u5931\u8d25\uff1a\u6a21\u677f\u5df2\u7ecf\u53d6\u6d88\u6388\u6743raId=[{}],tempId=[{}]", (Object)raId, (Object)templateInfoVO.getId());
            return Result.failure((ErrorEnum)ErrorEnum.RA_TEMPLATE_RELATE_DELETE);
        }
        RaDO raDO = this.raTemplateDao.getRaDoById(raId);
        if (null == templateInfoVO.getBaseDn() || !dn.toString().toLowerCase().endsWith(templateInfoVO.getBaseDn().toLowerCase())) {
            this.logger.info("CMP\u7b7e\u53d1\u53cc\u8bc1\u4e66: \u7528\u6237\u7684baseDN[{}]\u548c\u6a21\u677f\u7684BaseDn[{}]\u4e0d\u4e00\u81f4,\u8fdb\u884c\u4e0eRA\u7684BaseDn\u662f\u5426\u4e00\u81f4\u6821\u9a8c", (Object)dn.toString(), (Object)templateInfoVO.getBaseDn());
            if (null == raDO || !dn.toString().toLowerCase().endsWith(raDO.getBaseDn().toLowerCase())) {
                this.logger.info("CMP\u7b7e\u53d1\u53cc\u8bc1\u4e66: \u7528\u6237\u7684baseDN[{}]\u548cRA\u7684BaseDn[{}]\u4e0d\u4e00\u81f4", (Object)dn.toString(), (Object)raDO.getBaseDn());
                return Result.failure((ErrorEnum)ErrorEnum.USER_DN_NOT_SAME_RA_BASEDN);
            }
            if (null == caInfoVO || StringUtils.isBlank((CharSequence)caInfoVO.getBaseDn()) || null == caInfoVO.getRootCert()) {
                this.logger.debug("cmp\u7b7e\u53d1\u53cc\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u5230CA\u57fa\u672c\u4fe1\u606f[{}]", (Object)dn.toString());
                return Result.failure((ErrorEnum)ErrorEnum.CA_BASEINFO_GET_FAIL);
            }
            if (!dn.toString().toLowerCase().endsWith(caInfoVO.getBaseDn().toLowerCase())) {
                this.logger.debug("cmp\u7b7e\u53d1\u53cc\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e2d\u7684baseDn\u4e0d\u6b63\u786e[{}]", (Object)dn.toString());
                return Result.failure((ErrorEnum)ErrorEnum.BASEDN_ERROR);
            }
        }
        if (!(result = TemplateParamsUtil.validity((TemplateInfoVO)templateInfoVO, (String)tempParas)).isSuccess()) {
            this.logger.info("CMP\u7b7e\u53d1\u8bc1\u4e66\u5931\u8d25\uff1a\u7f3a\u5c11\u6a21\u677f\u9700\u8981\u53c2\u6570");
            return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        return result;
    }

    private Result genX509Certificate(X500Name dn, Date beginTime, Date endTime, BigInteger sn, CaInfoVO caInfoVO, TemplateInfoVO templateInfoVO, PublicKey publicKey, Map<String, ExtensionAttr> extensionAttrs, boolean isSignCert) throws Exception {
        Result result;
        Long templateId = null;
        if (templateInfoVO.getOpenCrl().booleanValue()) {
            templateId = templateInfoVO.getId();
        }
        if (!(result = this.licenseService.verifyLicense()).isSuccess()) {
            return result;
        }
        LdapOcspUrlVO signLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(sn, dn.toString(), caInfoVO, false, templateId, templateInfoVO.getCrlTempId());
        this.logger.info("\u5f53\u524d\u5f85\u751f\u6210\u8bc1\u4e66\u6240\u9700\u76ee\u5f55\u670d\u52a1\u7684\u57fa\u672c\u4fe1\u606f ================== " + signLdapOcspUrlVO.toString());
        List extensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), extensionAttrs, (PublicKey)publicKey, (String)dn.toString(), (LdapOcspUrlVO)signLdapOcspUrlVO, (boolean)isSignCert);
        List templateCustomizeExtensions = templateInfoVO.getCustomizeExtens();
        List customizeExtensions = ExtensionUtil.buildTemplateCustomizeExtensions((List)templateCustomizeExtensions, extensionAttrs);
        extensions.addAll(customizeExtensions);
        X509Certificate certificate = this.hsmService.genX509Certificate(dn.toString(), sn, beginTime, endTime, caInfoVO, publicKey, extensions, templateInfoVO.getSignAlg());
        this.licenseService.increamCurrentCertCount();
        return Result.success((Object)certificate);
    }

    public Result doRevokeUserCert(String signSn, Integer alg, boolean keyRevokedStatus, int revokeRease, String revokeNote, boolean isRecovery) {
        try {
            this.logger.info("\u6536\u5230\u8bc1\u4e66\u64a4\u9500\u8bf7\u6c42\uff0csignSn=" + signSn + ",keyRevokedStatus=" + keyRevokedStatus + ",revokeRease=" + revokeRease + ",revokeNote=" + revokeNote);
            if (revokeRease < 0 || revokeRease > 10) {
                this.logger.info("\u64a4\u9500\u8bc1\u4e66\u5931\u8d25\uff0c\u64a4\u9500\u7406\u7531\u4e0d\u6b63\u786e,reason:" + revokeRease);
                return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
            }
            Result result = this.checkCertStatus(signSn);
            if (!result.isSuccess() && result.getError().code != ErrorEnum.CERT_ISSUE_STATUE_FREEZE.code) {
                return result;
            }
            List<CertDO> revokeCerts = new ArrayList();
            if (result.isSuccess() && !isRecovery) {
                revokeCerts = (List)result.getInfo();
            } else if (result.isSuccess() && isRecovery) {
                CertDO revokeCert = this.certDao.getCertBySn(signSn, alg);
                revokeCerts.add(revokeCert);
            } else {
                revokeCerts = this.certDao.getCertsBySignSn(signSn, alg);
            }
            ArrayList<RevokedCertDO> revokedCertDOS = new ArrayList<RevokedCertDO>();
            Date revokeDate = new Date();
            this.buildRevokeData(revokeCerts, revokedCertDOS, keyRevokedStatus, revokeRease, revokeNote, revokeDate);
            this.revokeCertDao.saveCerts(revokedCertDOS);
            this.certDao.deleteBatch(revokeCerts);
            this.syncDrlAndOcsp(revokedCertDOS, revokeRease, revokeDate);
            this.logger.info("\u8bc1\u4e66\u64a4\u9500\u8bf7\u6c42\u5904\u7406\u6210\u529f\uff0csignSn=" + signSn + ",keyRevokedStatus=" + keyRevokedStatus + ",revokeRease=" + revokeRease + ",revokeNote=" + revokeNote);
            result = Result.success((String)revokeCerts.get(0).getSubject());
            return result;
        }
        catch (Exception e) {
            this.logger.debug("\u8bc1\u4e66\u64a4\u9500\u5904\u7406\u5931\u8d25\uff0csignSn=" + signSn + ",keyRevokedStatus=" + keyRevokedStatus + ",revokeRease=" + revokeRease + ",revokeNote=" + revokeNote);
            throw new ServiceException("\u64a4\u9500\u7528\u6237\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public void syncDrlAndOcsp(List<RevokedCertDO> revokeCerts, Integer revokeReason, Date date) throws Exception {
        RevokedCertDO revokedDO = revokeCerts.get(0);
        this.syncOcsp(revokedDO, revokeReason, date);
        long crlTempIdByCertTempId = this.templateDao.getCrlTempIdByCertTempId(revokedDO.getTemplateId().longValue());
        if (crlTempIdByCertTempId == -1L) {
            return;
        }
        Result result = this.crlTemplateService.getCrlTemplateById(Long.valueOf(crlTempIdByCertTempId));
        if (!result.isSuccess()) {
            this.logger.info("\u67e5\u627eCRL\u6a21\u677f\u4fe1\u606f\u5931\u8d25:" + JsonUtils.object2Json((Object)result));
            return;
        }
        CrlTemplateExtensionVO crlTemplate = (CrlTemplateExtensionVO)result.getInfo();
        Integer drlPeriod = crlTemplate.getCrlConfig().getDrlPeriod();
        if (drlPeriod != null && drlPeriod != 0) {
            if (revokeCerts.size() == CertPattermEnum.DOUBLE_CERT.id) {
                this.crlService.saveDeltaCrlInfo(revokedDO.getSn(), revokedDO.getPairCertSn(), revokedDO.getPublicKeyAlg(), revokeReason, revokedDO.getGmtCreate(), revokedDO.getCrlTempId().longValue(), revokedDO.getSegmentNo());
                this.logger.debug("\u5f00\u542f\u4e86\u589e\u91cfCRL\uff0c\u4fdd\u5b58\u589e\u91cfCRL\u4fe1\u606f\u6210\u529f\uff0csn1=" + revokedDO.getSn() + ",sn2=" + revokedDO.getPairCertSn());
            } else {
                this.crlService.saveDeltaCrlInfo(revokedDO.getSn(), revokedDO.getPairCertSn(), revokedDO.getPublicKeyAlg(), revokeReason, revokedDO.getGmtCreate(), revokedDO.getCrlTempId().longValue(), revokedDO.getSegmentNo());
                this.logger.debug("\u5f00\u542f\u4e86\u589e\u91cfCRL\uff0c\u4fdd\u5b58\u589e\u91cfCRL\u4fe1\u606f\u6210\u529f\uff0csn1=" + revokedDO.getSn());
            }
        }
    }

    public void syncDrlAndOcspFreezen(List<CertDO> revokeCerts, Integer revokeReason, Date date) throws Exception {
        CertDO revokedDO = revokeCerts.get(0);
        this.syncOcsp(revokedDO, revokeReason, date);
        long crlTempIdByCertTempId = this.templateDao.getCrlTempIdByCertTempId(revokedDO.getTemplateId().longValue());
        if (crlTempIdByCertTempId == -1L) {
            return;
        }
        Result result = this.crlTemplateService.getCrlTemplateById(Long.valueOf(crlTempIdByCertTempId));
        if (!result.isSuccess()) {
            this.logger.info("\u67e5\u627eCRL\u6a21\u677f\u4fe1\u606f\u5931\u8d25:" + JsonUtils.object2Json((Object)result));
            return;
        }
        CrlTemplateExtensionVO crlTemplate = (CrlTemplateExtensionVO)result.getInfo();
        Integer drlPeriod = crlTemplate.getCrlConfig().getDrlPeriod();
        if (drlPeriod != null && drlPeriod != 0) {
            if (revokeCerts.size() == CertPattermEnum.DOUBLE_CERT.id) {
                this.crlService.saveDeltaCrlInfo(revokedDO.getSn(), revokedDO.getPairCertSn(), revokedDO.getPublicKeyAlg(), revokeReason, revokedDO.getGmtCreate(), revokedDO.getCrlTempId().longValue(), revokedDO.getSegmentNo());
                this.logger.debug("\u5f00\u542f\u4e86\u589e\u91cfCRL\uff0c\u4fdd\u5b58\u589e\u91cfCRL\u4fe1\u606f\u6210\u529f\uff0csn1=" + revokedDO.getSn() + ",sn2=" + revokedDO.getPairCertSn());
            } else {
                this.crlService.saveDeltaCrlInfo(revokedDO.getSn(), revokedDO.getPairCertSn(), revokedDO.getPublicKeyAlg(), revokeReason, revokedDO.getGmtCreate(), revokedDO.getCrlTempId().longValue(), revokedDO.getSegmentNo());
                this.logger.debug("\u5f00\u542f\u4e86\u589e\u91cfCRL\uff0c\u4fdd\u5b58\u589e\u91cfCRL\u4fe1\u606f\u6210\u529f\uff0csn1=" + revokedDO.getSn());
            }
        }
    }

    public void syncOcsp(RevokedCertDO revokedDO, Integer revokeReason, Date date) {
        Integer certStatus = CertStatusEnum.REVOKE.value;
        if (6 == revokeReason) {
            certStatus = CertStatusEnum.FROZEN.value;
        } else if (8 == revokeReason) {
            certStatus = CertStatusEnum.NORMAL.value;
        }
        if (revokedDO.getType() == UserCertTypeEnum.SIGNCERT.value) {
            this.taskDataService.saveSyncStatusCert(revokedDO.getId(), revokedDO.getPairCertId(), Integer.valueOf(1), certStatus, revokeReason, date);
        } else if (revokedDO.getType() == UserCertTypeEnum.ENCCERT.value) {
            this.taskDataService.saveSyncStatusCert(revokedDO.getPairCertId(), revokedDO.getId(), Integer.valueOf(1), certStatus, revokeReason, date);
        } else {
            this.taskDataService.saveSyncStatusCert(revokedDO.getId(), null, Integer.valueOf(1), certStatus, revokeReason, date);
        }
    }

    public void syncOcsp(CertDO revokedDO, Integer revokeReason, Date date) {
        Integer certStatus = CertStatusEnum.REVOKE.value;
        if (6 == revokeReason) {
            certStatus = CertStatusEnum.FROZEN.value;
        } else if (8 == revokeReason) {
            certStatus = CertStatusEnum.NORMAL.value;
        }
        if (revokedDO.getType() == UserCertTypeEnum.SIGNCERT.value) {
            this.taskDataService.saveSyncStatusCert(revokedDO.getId(), revokedDO.getPairCertId(), Integer.valueOf(1), certStatus, revokeReason, date);
        } else if (revokedDO.getType() == UserCertTypeEnum.ENCCERT.value) {
            this.taskDataService.saveSyncStatusCert(revokedDO.getPairCertId(), revokedDO.getId(), Integer.valueOf(1), certStatus, revokeReason, date);
        } else {
            this.taskDataService.saveSyncStatusCert(revokedDO.getId(), null, Integer.valueOf(1), certStatus, revokeReason, date);
        }
    }

    public Result checkCertStatus(String signSn) {
        List certDOS = this.certDao.getCertsBySignSn(signSn, Constants.BASE_ALG_TYPE);
        if (null == certDOS || certDOS.size() == 0) {
            RevokedCertDO revokedCertDO = this.revokeCertDao.getRevokeCertBySn(signSn, Constants.BASE_ALG_TYPE);
            if (null != revokedCertDO) {
                this.logger.debug("\u8bc1\u4e66\u5df2\u7ecf\u88ab\u64a4\u9500\uff0csignSn=[{}]", (Object)signSn);
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_REVOKED);
            }
            OutdateCertDO outdateCertDO = this.outdateCertDao.getOutDateCertBySn(signSn, Constants.BASE_ALG_TYPE);
            if (null != outdateCertDO) {
                this.logger.debug("\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671f\uff0csignSn=[{}]", (Object)signSn);
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
            }
            this.logger.debug("CMP\u64a4\u9500\u8bc1\u4e66\u5931\u8d25\uff1a\u6ca1\u6709\u627e\u5230\u6b63\u5e38\u72b6\u6001\u7684\u8bc1\u4e66(\u8fd8\u9700\u8981\u8bc1\u4e66\u6b63\u786e\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4)\uff0csignSN=[{}]", (Object)signSn);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXCEPTION);
        }
        if (((CertDO)certDOS.get(0)).getNotAfterTime().before(new Date())) {
            this.logger.debug("\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671f\uff0csignSn=[{}]", (Object)signSn);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
        }
        if (((CertDO)certDOS.get(0)).getStatus() == 2) {
            this.logger.debug("\u8bc1\u4e66\u5df2\u7ecf\u88ab\u51bb\u7ed3,signSN=[{}]", (Object)signSn);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_FREEZE);
        }
        return Result.success((Object)certDOS);
    }

    public Result doFreezeUserCert(String signSn, String freezeNote) {
        this.logger.info("\u6536\u5230\u8bc1\u4e66\u51bb\u7ed3\u8bf7\u6c42\uff0csignSn=" + signSn + "freezeNote=" + freezeNote);
        try {
            Result result = this.checkCertStatus(signSn);
            if (!result.isSuccess()) {
                return result;
            }
            Date date = new Date();
            List freezeCerts = (List)result.getInfo();
            this.certDao.updateCertStatus(((CertDO)freezeCerts.get(0)).getSn(), CertStatusEnum.FROZEN.value);
            ArrayList<RevokedCertDO> revokedCertDOList = new ArrayList<RevokedCertDO>();
            for (CertDO freezeCert : freezeCerts) {
                RevokedCertDO revokedCertDO = new RevokedCertDO();
                BeanUtils.copyProperties((Object)freezeCert, (Object)revokedCertDO);
                revokedCertDO.setBeforeTime(freezeCert.getNotBeforeTime());
                revokedCertDO.setAfterTime(freezeCert.getKeyNotAfterTime());
                revokedCertDO.setKeyRevokedStatus(Integer.valueOf(RevokedCertDO.KEY_REVOKE_STATUS.NO_KEY_REVOKE.value));
                revokedCertDO.setIsRevokeKey(Integer.valueOf(RevokedCertDO.IS_REVOKE_KEY.NO_REVOKE_KEY.value));
                revokedCertDO.setRevokeReason(Integer.valueOf(CertStatusEnum.FROZEN.value));
                revokedCertDO.setFrozenNum(Integer.valueOf(freezeCert.getFrozenNum() + 1));
                revokedCertDO.setCrlTempId(freezeCert.getCrlTempId());
                revokedCertDOList.add(revokedCertDO);
            }
            this.revokeCertDao.saveCerts(revokedCertDOList);
            ArrayList<DeltaRevokedCertDO> deltaRevokedCertDOList = new ArrayList<DeltaRevokedCertDO>();
            for (CertDO freezeCert : freezeCerts) {
                long crlTempIdByCertTempId = this.templateDao.getCrlTempIdByCertTempId(freezeCert.getTemplateId().longValue());
                if (crlTempIdByCertTempId == -1L) continue;
                Result crlTemplateByIdResult = this.crlTemplateService.getCrlTemplateById(Long.valueOf(crlTempIdByCertTempId));
                if (!crlTemplateByIdResult.isSuccess()) {
                    this.logger.info("\u67e5\u627eCRL\u6a21\u677f\u4fe1\u606f\u5931\u8d25:" + JsonUtils.object2Json((Object)crlTemplateByIdResult));
                    continue;
                }
                CrlTemplateExtensionVO crlTemplate = (CrlTemplateExtensionVO)crlTemplateByIdResult.getInfo();
                Integer drlPeriod = crlTemplate.getCrlConfig().getDrlPeriod();
                if (drlPeriod == null || drlPeriod == 0) continue;
                DeltaRevokedCertDO deltaRevokedCertDO = new DeltaRevokedCertDO();
                BeanUtils.copyProperties((Object)freezeCert, (Object)deltaRevokedCertDO);
                deltaRevokedCertDO.setKeyAlg(freezeCert.getPublicKeyAlg());
                deltaRevokedCertDO.setRevokeReason(Integer.valueOf(CertStatusEnum.FROZEN.value));
                deltaRevokedCertDOList.add(deltaRevokedCertDO);
            }
            if (!CollectionUtils.isEmpty(deltaRevokedCertDOList)) {
                this.deltaRevokeCertDao.saveBatch(deltaRevokedCertDOList);
            }
            this.logger.info("\u8bc1\u4e66\u51bb\u7ed3\u8bf7\u6c42\u5904\u7406\u6210\u529f\uff0csignSn=" + signSn + ",freezeNote=" + freezeNote);
            this.syncDrlAndOcspFreezen(freezeCerts, 6, date);
            result.setAuditContent(((CertDO)freezeCerts.get(0)).getSubject());
            return result;
        }
        catch (Exception e) {
            this.logger.debug("\u8bc1\u4e66\u51bb\u7ed3\u5904\u7406\u5931\u8d25\uff0csignSn=" + signSn + ",freezeNote=" + freezeNote);
            throw new ServiceException("\u51bb\u7ed3\u7528\u6237\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public Result doUnFreezeUserCert(String signSn, String unFreezeNote) {
        try {
            this.logger.info("\u6536\u5230\u8bc1\u4e66\u89e3\u51bb\u8bf7\u6c42\uff0csignSn=" + signSn + "unFreezeNote=" + unFreezeNote);
            Result result = this.checkCertStatus(signSn);
            if (result.isSuccess()) {
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_NORMAL);
            }
            if (result.getError().code != ErrorEnum.CERT_ISSUE_STATUE_FREEZE.code) {
                return result;
            }
            Date date = new Date();
            List unFreezeCerts = this.certDao.getCertsBySignSn(signSn, Constants.BASE_ALG_TYPE);
            CertDO certDo = (CertDO)unFreezeCerts.get(0);
            this.certDao.updateCertStatus(certDo.getSn(), CertStatusEnum.NORMAL.value);
            RevokedCertDO revokedCertDO = new RevokedCertDO();
            BeanUtils.copyProperties((Object)certDo, (Object)revokedCertDO);
            this.revokeCertDao.delete(certDo.getSn(), certDo.getPairCertSn());
            this.deltaRevokeCertDao.delete(certDo.getSn(), certDo.getPairCertSn());
            this.syncOcsp(revokedCertDO, (Integer)8, date);
            this.logger.info("\u8bc1\u4e66\u89e3\u51bb\u8bf7\u6c42\u5904\u7406\u6210\u529f\uff0csignSn=" + signSn + ",unFreezeNote=" + unFreezeNote);
            return Result.success((String)certDo.getSubject());
        }
        catch (Exception e) {
            throw new ServiceException("\u8bc1\u4e66\u89e3\u51bb\u5f02\u5e38", (Throwable)e);
        }
    }

    private void buildRevokeData(List<CertDO> certDOS, List<RevokedCertDO> revokedCertDOS, boolean keyRevokedStatus, int revokeReason, String revokeNote, Date date) {
        for (CertDO certDO : certDOS) {
            RevokedCertDO revokedCertDO = new RevokedCertDO();
            BeanUtils.copyProperties((Object)certDO, (Object)revokedCertDO);
            revokedCertDO.setKeyNotBeforeTime(certDO.getNotBeforeTime());
            revokedCertDO.setKeyNotAfterTime(certDO.getNotAfterTime());
            revokedCertDO.setAfterTime(certDO.getNotAfterTime());
            revokedCertDO.setBeforeTime(certDO.getNotBeforeTime());
            revokeNote = StringUtils.isBlank((CharSequence)revokeNote) ? "" : revokeNote;
            revokedCertDO.setRevokeReason(Integer.valueOf(revokeReason));
            revokedCertDO.setRevokeNote(revokeNote);
            revokedCertDO.setGmtCreate(date);
            revokedCertDO.setCrlTempId(certDO.getCrlTempId());
            if (keyRevokedStatus) {
                revokedCertDO.setIsRevokeKey(Integer.valueOf(RevokedCertDO.IS_REVOKE_KEY.YES_REGOKE_KEY.value));
            } else {
                revokedCertDO.setIsRevokeKey(Integer.valueOf(RevokedCertDO.IS_REVOKE_KEY.NO_REVOKE_KEY.value));
            }
            revokedCertDO.setKeyRevokedStatus(Integer.valueOf(RevokedCertDO.KEY_REVOKE_STATUS.NO_KEY_REVOKE.value));
            revokedCertDOS.add(revokedCertDO);
        }
    }

    public Result userCertUpdate(String signSn, Integer alg, CertTemplate certTemplate, PublicKey publicKey, X500Name dn, Long raId, String reqId) {
        try {
            UserCertSnVO userCertSnVO = this.getUserCertSn();
            return this.doUpdateUserCert(userCertSnVO, signSn, alg, certTemplate, publicKey, dn, raId, reqId);
        }
        catch (Exception e) {
            this.logger.debug("CMP\u66f4\u65b0\u7528\u6237\u8bc1\u4e66\u5931\u8d25\uff1areqId=" + reqId + ",dn=" + dn.toString(), (Throwable)e);
            throw new ServiceException("\u66f4\u65b0\u7528\u6237\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public Result doUpdateUserCert(UserCertSnVO userCertSnVO, String signSn, Integer alg, CertTemplate certTemplate, PublicKey publicKey, X500Name dn, Long raId, String reqId) {
        this.logger.info("CMP\u6536\u5230\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42\uff0creqID=" + reqId + ",signSn" + signSn + ",dn=" + dn + ",raId=" + raId);
        try {
            List revokeCerts = this.certDao.getCertsBySignSn(signSn, alg);
            Result result = new Result();
            if (null == revokeCerts || revokeCerts.size() == 0) {
                RevokedCertDO revokedCertDO = this.revokeCertDao.getRevokeCertBySn(signSn, alg);
                if (null != revokedCertDO) {
                    this.logger.debug("CMP\u66f4\u65b0\u8bc1\u4e66\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u7ecf\u88ab\u64a4\u9500\uff0csignSn=[{}]", (Object)signSn);
                    return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_REVOKED);
                }
                OutdateCertDO outdateCertDO = this.outdateCertDao.getOutDateCertBySn(signSn, alg);
                if (null != outdateCertDO) {
                    this.logger.debug("CMP\u66f4\u65b0\u8bc1\u4e66\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671f\uff0csignSn=[{}]", (Object)signSn);
                    return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
                }
                this.logger.debug("CMP\u66f4\u65b0\u8bc1\u4e66\u5931\u8d25\uff1a\u6ca1\u6709\u627e\u5230\u6b63\u5e38\u72b6\u6001\u7684\u8bc1\u4e66(\u8fd8\u9700\u8981\u8bc1\u4e66\u6b63\u786e\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4)\uff0csignSN=[{}]", (Object)signSn);
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXCEPTION);
            }
            CaInfoVO caInfoVO = this.initService.getCaInfo(Integer.valueOf(alg));
            if (null == caInfoVO || StringUtils.isBlank((CharSequence)caInfoVO.getBaseDn())) {
                this.logger.debug("CMP\u66f4\u65b0\u53cc\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u5230CA\u57fa\u672c\u4fe1\u606f[{}]", (Object)dn.toString());
                return Result.failure((ErrorEnum)ErrorEnum.CA_BASEINFO_GET_FAIL);
            }
            if (caInfoVO.getRootCert().getNotAfter().before(new Date())) {
                this.logger.debug("CMP\u66f4\u65b0\u8bc1\u4e66\u5931\u8d25\uff1aCA\u6839\u8bc1\u4e66\u5df2\u8fc7\u671f,rootCertAfterTime=[{}]", (Object)caInfoVO.getRootCert().getNotAfter());
                return Result.failure((ErrorEnum)ErrorEnum.CA_ROOT_CERT_EXPIRED);
            }
            CertDO certDO = (CertDO)revokeCerts.get(0);
            TemplateDO templateDO = this.templateDao.getTemplateById(certDO.getTemplateId());
            if (null == templateDO) {
                this.logger.debug("cmp\u7b7e\u53d1\u53cc\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u6a21\u677f\u4fe1\u606f[{}]", (Object)dn.toString());
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
            }
            if (TemplateStatusEnum.NORMAL.value != templateDO.getStatus()) {
                this.logger.info("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u7ed3\u679c\uff1a\u6a21\u677f\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u6a21\u677f\u72b6\u6001\u4e3a[{}]", (Object)templateDO.getStatus());
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
            }
            if (!(null == dn || null != templateDO.getCustomizeDn() && dn.toString().toLowerCase().endsWith(templateDO.getCustomizeDn().toLowerCase()))) {
                this.logger.debug("CMP\u66f4\u65b0\u8bc1\u4e66\uff1aDN\u4e2d\u7684baseDn\u548c\u6a21\u677f\u4e0d\u4e00\u81f4dn=[{}]", (Object)dn);
                if (!dn.toString().toLowerCase().endsWith(caInfoVO.getBaseDn().toLowerCase())) {
                    this.logger.debug("CMP\u66f4\u65b0\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e2d\u7684baseDn\u4e0d\u6b63\u786edn=[{}]", (Object)dn);
                    return Result.failure((ErrorEnum)ErrorEnum.BASEDN_ERROR);
                }
                RaDO raDO = this.raTemplateDao.getRaDoById(raId);
                if (null == raDO || !dn.toString().toLowerCase().endsWith(raDO.getBaseDn().toLowerCase())) {
                    this.logger.info("CMP\u66f4\u65b0\u53cc\u8bc1\u4e66\u5931\u8d25: \u7528\u6237\u7684baseDN[{}]\u548cRA\u7684BaseDn[{}]\u4e0d\u4e00\u81f4", (Object)dn.toString(), (Object)raDO.getBaseDn());
                    return Result.failure((ErrorEnum)ErrorEnum.USER_DN_NOT_SAME_RA_BASEDN);
                }
            }
            if (certDO.getNotAfterTime().before(new Date())) {
                this.logger.info("CMP\u66f4\u65b0\u8bc1\u4e66\u5931\u8d25\uff1a\u8bc1\u4e66\u8fc7\u671fsignSn=" + signSn + ",afterTime=" + certDO.getNotAfterTime());
                result = Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
            } else if (certDO.getStatus() == 2) {
                this.logger.debug("CMP\u66f4\u65b0\u8bc1\u4e66\u5931\u8d25\uff1a\u8bc1\u4e66\u88ab\u51bb\u7ed3signSN=[{}]", (Object)signSn);
                result = Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_FREEZE);
            } else {
                try {
                    CertDataDO certDataDO1 = this.certDataDao.queryCertDataById(certDO.getId());
                    CertDataDO certDataDO2 = this.certDataDao.queryCertDataById(certDO.getPairCertId());
                    RACertResponseVO raCertResponseVO = new RACertResponseVO();
                    Date beginTime = new Date();
                    Date endTime = certDO.getNotAfterTime();
                    if (null != certTemplate.getValidity()) {
                        beginTime = certTemplate.getValidity().getNotBefore().getDate();
                        X509Certificate rootCert = caInfoVO.getRootCert();
                        endTime = IssueTimeUtil.getUserIssueAfterTime((Date)certTemplate.getValidity().getNotAfter().getDate(), (Integer)templateDO.getMaxValidity(), (Date)rootCert.getNotAfter(), (Date)beginTime);
                    }
                    boolean isRevokePwd = false;
                    if (null == publicKey) {
                        this.logger.debug("\u5f00\u59cb\u5904\u7406\u8bc1\u4e66\u5ef6\u671f\u6216DN\u66f4\u65b0\u8bf7\u6c42\uff0cdn=" + dn);
                        raCertResponseVO = this.updateUserCertInfo(caInfoVO, dn, certDataDO1, certDataDO2, beginTime, endTime, certDO, raId, templateDO, userCertSnVO);
                        this.logger.debug("\u8bc1\u4e66\u5ef6\u671f\u6216DN\u66f4\u65b0\u8bf7\u6c42\u5904\u7406\u5b8c\u6210\uff0cdn=" + dn);
                    } else {
                        this.logger.debug("\u5f00\u59cb\u5904\u7406\u8bc1\u4e66\u5bc6\u94a5\u66f4\u65b0\u8bf7\u6c42\uff0cdn=" + dn);
                        raCertResponseVO = this.updateUserCertPwd(caInfoVO, publicKey, dn, certDO, certDataDO1, certDataDO2, beginTime, endTime, raId, templateDO, userCertSnVO);
                        isRevokePwd = true;
                        this.logger.debug("\u8bc1\u4e66\u5bc6\u94a5\u66f4\u65b0\u8bf7\u6c42\u5904\u7406\u5b8c\u6210\uff0cdn=" + dn);
                    }
                    CMPReqCacheVO cmpReqCacheVO = templateDO.getCertPatterm() == CertPattermEnum.DOUBLE_CERT.id ? new CMPReqCacheVO(CertUtil.getSNByCertStr((String)raCertResponseVO.getSignCert()), CertUtil.getSNByCertStr((String)raCertResponseVO.getEncCert()), alg, isRevokePwd) : new CMPReqCacheVO(CertUtil.getSNByCertStr((String)raCertResponseVO.getSignCert()), null, alg, isRevokePwd);
                    Constants.CMP_REQ_INFO.put(reqId, cmpReqCacheVO);
                    this.logger.debug("cmp\u8bf7\u6c42id\u4fe1\u606f\u5199\u5165\u7f13\u5b58\u6210\u529f\uff0creqId=" + reqId + ",signSn=" + CertUtil.getSNByCertStr((String)raCertResponseVO.getSignCert()) + ",isRevokePwd=" + isRevokePwd);
                    this.logger.info("CMP\u7528\u6237\u8bc1\u4e66\u66f4\u65b0\u6210\u529f\uff0creqId=" + reqId + ",signCert=" + raCertResponseVO.getSignCert());
                    this.logger.info("\u66f4\u65b0\u7528\u6237\u8bc1\u4e66\u6210\u529f\uff1asignCert=" + raCertResponseVO.getSignCert() + ",encCert=" + raCertResponseVO.getEncCert() + ",encPriKey=" + raCertResponseVO.getEncPriKey());
                    return Result.success((Object)raCertResponseVO);
                }
                catch (Exception e) {
                    this.logger.debug("CMP\u66f4\u65b0\u7528\u6237\u8bc1\u4e66\u5931\u8d25\uff1areqId=" + reqId + ",dn=" + dn.toString(), (Throwable)e);
                    throw new ServiceException("\u66f4\u65b0\u7528\u6237\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
                }
            }
            return result;
        }
        catch (Exception e) {
            this.logger.debug("CMP\u66f4\u65b0\u7528\u6237\u8bc1\u4e66\u5931\u8d25\uff1areqId=" + reqId + ",dn=" + dn.toString(), (Throwable)e);
            throw new ServiceException("\u66f4\u65b0\u7528\u6237\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    public Result doRecoveryUserDoubleCert(String signSn, Integer alg, PublicKey newSignCertPubKey, X500Name dn, Long raId, String reqId) {
        TemplateDO templateDO;
        CaInfoVO caInfoVO;
        CertDO revokeSignCert;
        block16: {
            this.logger.info("CMP\u6536\u5230\u8bc1\u4e66\u6062\u590d\u8bf7\u6c42\uff0creqID=" + reqId + " ,alg=" + alg + " ,signSn=" + signSn + ",dn=" + dn + ",raId=" + raId);
            revokeSignCert = this.certDao.getCertBySn(signSn, alg);
            Result result = new Result();
            if (null == revokeSignCert) {
                RevokedCertDO revokedCertDO = this.revokeCertDao.getRevokeCertBySn(signSn, alg);
                if (null != revokedCertDO) {
                    this.logger.debug("CMP\u6062\u590d\u8bc1\u4e66\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u7ecf\u88ab\u64a4\u9500\uff0csignSn=[{}]", (Object)signSn);
                    return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_REVOKED);
                }
                OutdateCertDO outdateCertDO = this.outdateCertDao.getOutDateCertBySn(signSn, alg);
                if (null != outdateCertDO) {
                    this.logger.debug("CMP\u6062\u590d\u8bc1\u4e66\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671f\uff0csignSn=[{}]", (Object)signSn);
                    return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
                }
                this.logger.debug("CMP\u6062\u590d\u8bc1\u4e66\u5931\u8d25\uff1a\u6ca1\u6709\u627e\u5230\u6b63\u5e38\u72b6\u6001\u7684\u8bc1\u4e66(\u8fd8\u9700\u8981\u8bc1\u4e66\u6b63\u786e\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4)\uff0csignSN=[{}]", (Object)signSn);
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXCEPTION);
            }
            caInfoVO = this.initService.getCaInfo(alg);
            if (null == caInfoVO || StringUtils.isBlank((CharSequence)caInfoVO.getBaseDn())) {
                this.logger.debug("CMP\u6062\u590d\u53cc\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u5230CA\u57fa\u672c\u4fe1\u606f[{}]", (Object)dn.toString());
                return Result.failure((ErrorEnum)ErrorEnum.CA_BASEINFO_GET_FAIL);
            }
            if (caInfoVO.getRootCert().getNotAfter().before(new Date())) {
                this.logger.debug("CMP\u6062\u590d\u8bc1\u4e66\u5931\u8d25\uff1aCA\u6839\u8bc1\u4e66\u5df2\u8fc7\u671f,rootCertAfterTime=[{}]", (Object)caInfoVO.getRootCert().getNotAfter());
                return Result.failure((ErrorEnum)ErrorEnum.CA_ROOT_CERT_EXPIRED);
            }
            templateDO = this.templateDao.getTemplateById(revokeSignCert.getTemplateId());
            if (null == templateDO) {
                this.logger.debug("cmp\u6062\u590d\u53cc\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u6a21\u677f\u4fe1\u606f[{}]", (Object)dn.toString());
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
            }
            if (TemplateStatusEnum.NORMAL.value != templateDO.getStatus()) {
                this.logger.info("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u7ed3\u679c\uff1a\u6a21\u677f\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u6a21\u677f\u72b6\u6001\u4e3a[{}]", (Object)templateDO.getStatus());
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
            }
            if (!(null == dn || null != templateDO.getCustomizeDn() && dn.toString().toLowerCase().endsWith(templateDO.getCustomizeDn().toLowerCase()))) {
                this.logger.debug("CMP\u6062\u590d\u8bc1\u4e66\uff1aDN\u4e2d\u7684baseDn\u548c\u6a21\u677f\u4e0d\u4e00\u81f4dn=[{}]", (Object)dn);
                if (!dn.toString().toLowerCase().endsWith(caInfoVO.getBaseDn().toLowerCase())) {
                    this.logger.debug("CMP\u6062\u590d\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e2d\u7684baseDn\u4e0d\u6b63\u786edn=[{}]", (Object)dn);
                    return Result.failure((ErrorEnum)ErrorEnum.BASEDN_ERROR);
                }
                RaDO raDO = this.raTemplateDao.getRaDoById(raId);
                if (null == raDO || !dn.toString().toLowerCase().endsWith(raDO.getBaseDn().toLowerCase())) {
                    this.logger.info("CMP\u6062\u590d\u53cc\u8bc1\u4e66\u5931\u8d25: \u7528\u6237\u7684baseDN[{}]\u548cRA\u7684BaseDn[{}]\u4e0d\u4e00\u81f4", (Object)dn.toString(), (Object)raDO.getBaseDn());
                    return Result.failure((ErrorEnum)ErrorEnum.USER_DN_NOT_SAME_RA_BASEDN);
                }
            }
            if (revokeSignCert.getNotAfterTime().before(new Date())) {
                this.logger.info("CMP\u6062\u590d\u8bc1\u4e66\u5931\u8d25\uff1a\u8bc1\u4e66\u8fc7\u671fsignSn=" + signSn + ",afterTime=" + revokeSignCert.getNotAfterTime());
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
            }
            if (revokeSignCert.getStatus() != 2) break block16;
            this.logger.debug("CMP\u6062\u590d\u8bc1\u4e66\u5931\u8d25\uff1a\u8bc1\u4e66\u88ab\u51bb\u7ed3signSN=[{}]", (Object)signSn);
            result = Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_FREEZE);
            return result;
            {
                catch (Exception e) {
                    this.logger.debug("CMP\u6062\u590d\u7528\u6237\u8bc1\u4e66\u5931\u8d25\uff1areqId=" + reqId + ",dn=" + dn.toString(), (Throwable)e);
                    throw new ServiceException("\u6062\u590d\u7528\u6237\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
                }
            }
        }
        try {
            CertDataDO revokeSignCertData = this.certDataDao.queryCertDataById(revokeSignCert.getId());
            CertDataDO encCertData = this.certDataDao.queryCertDataById(revokeSignCert.getPairCertId());
            Date beginTime = new Date();
            Date endTime = CertUtils.getCertFromStr((String)encCertData.getData()).getNotAfter();
            this.logger.debug("\u5f00\u59cb\u5904\u7406\u8bc1\u4e66\u5bc6\u94a5\u6062\u590d\u8bf7\u6c42\uff0cdn=" + dn);
            RACertResponseVO raCertResponseVO = this.recoveryUserCert(caInfoVO, newSignCertPubKey, dn, revokeSignCert, revokeSignCertData, encCertData, beginTime, endTime, raId, templateDO.getSignAlg());
            this.logger.debug("\u8bc1\u4e66\u5bc6\u94a5\u6062\u590d\u8bf7\u6c42\u5904\u7406\u5b8c\u6210\uff0cdn=" + dn);
            CMPReqCacheVO cmpReqCacheVO = new CMPReqCacheVO(CertUtil.getSNByCertStr((String)raCertResponseVO.getSignCert()), null, alg, false);
            cmpReqCacheVO.setRecoveryKey(true);
            Constants.CMP_REQ_INFO.put(reqId, cmpReqCacheVO);
            this.logger.debug("cmp\u8bf7\u6c42id\u4fe1\u606f\u5199\u5165\u7f13\u5b58\u6210\u529f\uff0creqId=" + reqId + ",signSn=" + CertUtil.getSNByCertStr((String)raCertResponseVO.getSignCert()) + ",encSn=" + CertUtil.getSNByCertStr((String)raCertResponseVO.getEncCert()));
            this.logger.info("CMP\u7528\u6237\u8bc1\u4e66\u6062\u590d\u6210\u529f\uff0creqId=" + reqId + ",signCert=" + raCertResponseVO.getSignCert() + ",encCert=" + raCertResponseVO.getEncCert() + ",encPriKey=" + raCertResponseVO.getEncPriKey());
            this.logger.info("\u6062\u590d\u7528\u6237\u8bc1\u4e66\u6210\u529f\uff1asignCert=" + raCertResponseVO.getSignCert() + ",encCert=" + raCertResponseVO.getEncCert() + ",encPriKey=" + raCertResponseVO.getEncPriKey());
            return Result.success((Object)raCertResponseVO);
        }
        catch (Exception e) {
            this.logger.debug("CMP\u6062\u590d\u7528\u6237\u8bc1\u4e66\u5931\u8d25\uff1areqId=" + reqId + ",dn=" + dn.toString(), (Throwable)e);
            throw new ServiceException("\u6062\u590d\u7528\u6237\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    private String getApplyKeySn(String sn) {
        RevokedCertDO revokedCertDO = this.revokeCertDao.getCertBySn(sn);
        if (null == revokedCertDO.getOldCertId()) {
            if (RevokedCertDO.IS_REVOKE_KEY.YES_REGOKE_KEY.value == revokedCertDO.getIsRevokeKey()) {
                return "";
            }
            return revokedCertDO.getSn();
        }
        RevokedCertDO oldCert = this.revokeCertDao.getCertById(revokedCertDO.getOldCertId().longValue());
        if (null == oldCert || RevokedCertDO.IS_REVOKE_KEY.YES_REGOKE_KEY.value == oldCert.getIsRevokeKey()) {
            return revokedCertDO.getSn();
        }
        return this.getApplyKeySn(oldCert.getSn());
    }

    public Result getServerCertInfoBySignSn(String signSn, Integer alg) {
        try {
            this.logger.debug("\u6536\u5230RA\u83b7\u53d6\u670d\u52a1\u5668\u8bc1\u4e66\u4fe1\u606f\u8bf7\u6c42\uff0csignSn=" + signSn);
            alg = null == alg ? AlgTypeEnum.SM2.value : alg;
            Map map = this.raCertDao.queryServerCertInfoBySignSn(signSn, alg);
            if (null != map) {
                RAServerCertVO raServerCertVO = new RAServerCertVO();
                raServerCertVO.setRaId(Long.valueOf(map.get("raId").toString()));
                raServerCertVO.setStatus(Integer.valueOf(map.get("status").toString()));
                raServerCertVO.setServerCert(map.get("certData").toString());
                this.logger.debug("RA\u83b7\u53d6\u670d\u52a1\u5668\u8bc1\u4e66\u4fe1\u606f\u8bf7\u6c42\u5904\u7406\u6210\u529f\uff1a" + raServerCertVO);
                return Result.success((Object)raServerCertVO);
            }
            RevokedManageCertDO revokedCertDO = this.revokeManagerCertDao.getRevokManagerCertsBySn(signSn, alg);
            if (null != revokedCertDO) {
                this.logger.debug("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u7ecf\u88ab\u64a4\u9500\uff0csignSn=[{}]", (Object)signSn);
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_REVOKED);
            }
            OutdateManageCertDO outdateCertDO = this.outDateManagerCertDao.getOutDateManagerCertsBySn(signSn, alg);
            if (null != outdateCertDO) {
                this.logger.debug("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671f\uff0csignSn=[{}]", (Object)signSn);
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
            }
            this.logger.debug("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25\uff1a\u6ca1\u6709\u627e\u5230\u8bc1\u4e66\u4fe1\u606f\uff0csignSN=[{}]", (Object)signSn);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXCEPTION);
        }
        catch (Exception e) {
            throw new ServiceException("\u6839\u636eRA\u670d\u52a1\u5668\u8bc1\u4e66SN\u548c\u7b97\u6cd5\u83b7\u53d6\u8bc1\u4e66\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result doAckCertIssueStatus(String reqId) {
        this.logger.info("CMP\u6536\u5230\u8bc1\u4e66\u5199\u5361\u6210\u529f\u72b6\u6001\u786e\u8ba4\u6d88\u606f\u5904\u7406\u8bf7\u6c42\uff0creqID=" + reqId);
        try {
            CMPReqCacheVO cmpReqCacheVO = (CMPReqCacheVO)Constants.CMP_REQ_INFO.get(reqId);
            boolean n = false;
            if (null == cmpReqCacheVO) {
                return Result.failure((ErrorEnum)ErrorEnum.ADMIN_CERT_ACK_ERROR);
            }
            this.logger.info("CMP\u6536\u5230\u8bc1\u4e66\u72b6\u6001\u786e\u8ba4\u6d88\u606f\u5f00\u59cb\uff1areqID=" + reqId + ",signSn=" + cmpReqCacheVO.getSignSn());
            if (cmpReqCacheVO.isRecoveryKey()) {
                CertDO oldCertDo;
                Result result;
                this.certDao.updateRecoverySignCertStatus(cmpReqCacheVO.getSignSn());
                Constants.CMP_REQ_INFO.remove(reqId);
                CertDO newSignCertDO = this.certDao.getCertBySn(cmpReqCacheVO.getSignSn(), cmpReqCacheVO.getKeyAlg());
                if (null == newSignCertDO) {
                    this.logger.error("\u672a\u83b7\u53d6\u5230\u5f85\u786e\u8ba4\u7684\u8bc1\u4e66\u4fe1\u606f");
                    return Result.failure((ErrorEnum)ErrorEnum.DO_NOT_GET_NOT_CONFIRMED_CERT);
                }
                this.taskDataService.savePublishCert(newSignCertDO.getId(), newSignCertDO.getPairCertId(), Integer.valueOf(1));
                CertDO oldSignCert = this.certDao.getCertByPairCertId(newSignCertDO.getPairCertId());
                CertDO oldEncCert = this.certDao.getCertById(oldSignCert.getPairCertId());
                this.certDao.updateOldCertPairInfo(oldSignCert.getSn(), null, null);
                this.certDao.updateOldCertPairInfo(oldEncCert.getSn(), newSignCertDO.getId(), newSignCertDO.getSn());
                if (null != newSignCertDO.getOldCertId() && !(result = this.doRevokeUserCert((oldCertDo = this.certDao.getCertById(newSignCertDO.getOldCertId())).getSn(), cmpReqCacheVO.getKeyAlg(), false, 4, "\u5bc6\u94a5\u6062\u590d", true)).isSuccess()) {
                    this.logger.info("\u64a4\u9500\u6062\u590d\u5bc6\u94a5\u524d\u7684\u7b7e\u540d\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25");
                    Result.failure((ErrorEnum)ErrorEnum.ADMIN_CERT_ACK_ERROR);
                }
                this.taskDataService.deleteNoConfirmCertSync(newSignCertDO.getId(), null);
                return Result.success();
            }
            this.certDao.updatePriCertStatus(cmpReqCacheVO.getSignSn(), cmpReqCacheVO.getEncSn());
            Constants.CMP_REQ_INFO.remove(reqId);
            this.logger.info("CMP\u6536\u5230\u8bc1\u4e66\u72b6\u6001\u786e\u8ba4\u6d88\u606f\u5904\u7406\u6210\u529f\uff1areqID=" + reqId + ",signSn=" + cmpReqCacheVO.getSignSn() + ",encSn=" + cmpReqCacheVO.getEncSn());
            CertDO certDO = this.certDao.getCertBySignSn(cmpReqCacheVO.getSignSn(), cmpReqCacheVO.getKeyAlg());
            if (null == certDO) {
                this.logger.error("\u672a\u83b7\u53d6\u5230\u5f85\u786e\u8ba4\u7684\u8bc1\u4e66\u4fe1\u606f");
                return Result.failure((ErrorEnum)ErrorEnum.DO_NOT_GET_NOT_CONFIRMED_CERT);
            }
            this.taskDataService.savePublishCert(certDO.getId(), certDO.getPairCertId(), Integer.valueOf(1));
            if (null != certDO.getOldCertId()) {
                this.logger.debug("\u8bc1\u4e66\u66f4\u65b0\u53d1\u8d77\u7b7e\u53d1\u786e\u8ba4\uff0c\u8001\u8bc1\u4e66id=" + certDO.getOldCertId());
                CertDO oldCertDo = this.certDao.getCertById(certDO.getOldCertId());
                this.doRevokeUserCert(oldCertDo.getSn(), cmpReqCacheVO.getKeyAlg(), cmpReqCacheVO.isRevokePwd(), 4, "\u8bc1\u4e66\u66f4\u65b0", false);
            }
            this.logger.debug("\u8bc1\u4e66\u786e\u8ba4\u7684\u8bc1\u4e66\u7c7b\u578b:[{}]", (Object)certDO.getType());
            if (CertDO.CertTypeEnum.ENC.value != certDO.getType()) {
                this.taskDataService.deleteNoConfirmCertSync(certDO.getId(), null);
            } else {
                this.taskDataService.deleteNoConfirmCertSync(certDO.getPairCertId(), null);
            }
            return Result.success();
        }
        catch (Exception e) {
            this.logger.debug("\u786e\u8ba4cmp\u8bc1\u4e66\u5199\u5361\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u786e\u8ba4cmp\u8bc1\u4e66\u5199\u5361\u72b6\u6001\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result doErrorAckCertIssueStatus(String reqId, ErrorMsgContent errorMsgContent) {
        this.logger.info("CMP\u6536\u5230\u8bc1\u4e66\u5199\u5361\u5931\u8d25\u72b6\u6001\u786e\u8ba4\u6d88\u606f\u5904\u7406\u8bf7\u6c42\uff0creqID=" + reqId);
        try {
            CMPReqCacheVO cmpReqCacheVO = (CMPReqCacheVO)Constants.CMP_REQ_INFO.get(reqId);
            if (null != cmpReqCacheVO) {
                this.logger.error("CMP\u534f\u8bae\u8fd4\u56de\u5f02\u5e38\u786e\u8ba4\u6d88\u606f[{}]", (Object)("[ErrorMsgContent:errorCode=" + errorMsgContent.getErrorCode() + ",errorMsg=" + errorMsgContent.getErrorDetails().getStringAt(0).getString()));
                this.certDao.updatePriCertStatus(cmpReqCacheVO.getSignSn(), cmpReqCacheVO.getEncSn());
                CertDO certDO = this.certDao.getCertBySn(cmpReqCacheVO.getSignSn(), Constants.BASE_ALG_TYPE);
                this.taskDataService.savePublishCert(certDO.getId(), certDO.getPairCertId(), Integer.valueOf(1));
                if (CertDO.CertTypeEnum.ENC.value != certDO.getType()) {
                    this.taskDataService.deleteNoConfirmCertSync(certDO.getId(), null);
                } else {
                    this.taskDataService.deleteNoConfirmCertSync(certDO.getPairCertId(), null);
                }
                Result result = new Result();
                result = cmpReqCacheVO.isRecoveryKey() ? this.doRevokeUserCert(cmpReqCacheVO.getSignSn(), AlgTypeEnum.SM2.value, false, 0, "\u8bc1\u4e66\u5199\u5361\u5931\u8d25", true) : this.doRevokeUserCert(cmpReqCacheVO.getSignSn(), AlgTypeEnum.SM2.value, false, 0, "\u8bc1\u4e66\u5199\u5361\u5931\u8d25", false);
                if (result.isSuccess()) {
                    Constants.CMP_REQ_INFO.remove(reqId);
                    return Result.success();
                }
                this.logger.error("\u5904\u7406\u8bc1\u4e66\u5199\u5361\u5931\u8d25\u72b6\u6001\u4e0a\u62a5\u65f6\uff0c\u64a4\u9500\u8bc1\u4e66\u5931\u8d25\uff0creqId=[{}],signSn=[{}]", (Object)reqId, (Object)cmpReqCacheVO.getSignSn());
            }
        }
        catch (Exception e) {
            this.logger.error("\u786e\u8ba4cmp\u8bc1\u4e66\u5199\u5361\u72b6\u6001\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u786e\u8ba4cmp\u8bc1\u4e66\u5199\u5361\u72b6\u6001\u5931\u8d25", (Throwable)e);
        }
        return Result.failure((ErrorEnum)ErrorEnum.ADMIN_CERT_ACK_ERROR);
    }

    public Result getCertLastUpdateTime(String signSn, Integer alg, Integer type) {
        try {
            CaInfoVO caInfoVO = this.initService.getCaInfo(alg);
            X509Certificate rootCert = caInfoVO.getRootCert();
            Integer maxTime = 0;
            if (Constants.RA_USER_CERT_TYPE.intValue() == type.intValue()) {
                CertDO certDO = this.certDao.getCertBySn(signSn, alg);
                Result result = new Result();
                if (null == certDO) {
                    RevokedCertDO revokedCertDO = this.revokeCertDao.getRevokeCertBySn(signSn, alg);
                    if (null != revokedCertDO) {
                        this.logger.debug("CMP\u66f4\u65b0\u8bc1\u4e66\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u7ecf\u88ab\u64a4\u9500\uff0csignSn=[{}]", (Object)signSn);
                        return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_REVOKED);
                    }
                    OutdateCertDO outdateCertDO = this.outdateCertDao.getOutDateCertBySn(signSn, alg);
                    if (null != outdateCertDO) {
                        this.logger.debug("CMP\u66f4\u65b0\u8bc1\u4e66\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671f\uff0csignSn=[{}]", (Object)signSn);
                        return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
                    }
                    this.logger.debug("CMP\u66f4\u65b0\u8bc1\u4e66\u5931\u8d25\uff1a\u6ca1\u6709\u627e\u5230\u6b63\u5e38\u72b6\u6001\u7684\u8bc1\u4e66(\u8fd8\u9700\u8981\u8bc1\u4e66\u6b63\u786e\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4)\uff0csignSN=[{}]", (Object)signSn);
                    return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXCEPTION);
                }
                TemplateDO templateDO = this.templateDao.getTemplateById(certDO.getTemplateId());
                Date keyLastTime = certDO.getKeyNotAfterTime();
                maxTime = IssueTimeUtil.getMaxIssueTime((Integer)templateDO.getMaxValidity(), (Date)rootCert.getNotAfter(), (Date)keyLastTime).intValue();
            } else if (Constants.RA_MANAGER_CERT_TYPE.intValue() == type.intValue()) {
                ManageCertDO manageCertDO = this.managerCertDao.getManagerCertsBySn(signSn, alg.intValue());
                if (null == manageCertDO) {
                    RevokedManageCertDO revokedCertDO = this.revokeManagerCertDao.getRevokManagerCertsBySn(signSn, alg);
                    if (null != revokedCertDO) {
                        this.logger.debug("\u83b7\u53d6RA\u7ba1\u7406\u5458\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u7ecf\u88ab\u64a4\u9500\uff0csignSn=[{}]", (Object)signSn);
                        return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_REVOKED);
                    }
                    OutdateManageCertDO outdateCertDO = this.outDateManagerCertDao.getOutDateManagerCertsBySn(signSn, alg);
                    if (null != outdateCertDO) {
                        this.logger.debug("\u83b7\u53d6RA\u7ba1\u7406\u5458\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671f\uff0csignSn=[{}]", (Object)signSn);
                        return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
                    }
                    this.logger.debug("\u83b7\u53d6RA\u7ba1\u7406\u5458\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25\uff1a\u6ca1\u6709\u627e\u5230\u6b63\u5e38\u72b6\u6001\u7684\u8bc1\u4e66(\u7ba1\u7406\u5458\u8bc1\u4e66\u8fd8\u9700\u8981\u8bc1\u4e66\u6b63\u786e\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4)\uff0csignSN=[{}]", (Object)signSn);
                    return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXCEPTION);
                }
                TemplateDO templateDO = this.templateDao.getTemplateById(manageCertDO.getTemplateId());
                maxTime = IssueTimeUtil.getMaxIssueTime((Integer)templateDO.getMaxValidity(), (Date)rootCert.getNotAfter());
            }
            HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
            resultMap.put("maxIssueTime", maxTime);
            return Result.success(resultMap);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u7b7e\u53d1\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u83b7\u53d6\u8bc1\u4e66\u7b7e\u53d1\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
        }
    }

    private RACertResponseVO updateUserCertInfo(CaInfoVO caInfoVO, X500Name dn, CertDataDO certDataDO1, CertDataDO certDataDO2, Date nowTime, Date endTime, CertDO certDO, Long raId, TemplateDO templateDO, UserCertSnVO userCertSnVO) throws Exception {
        X509Certificate newSignCert;
        X509Certificate oldCert1 = CertUtil.getCertFromStr((String)certDataDO1.getData());
        List extensions = CertUtil.genExtensions((X509Certificate)oldCert1);
        BigInteger signSn = userCertSnVO.getSignSn();
        Long templateId = null;
        if (this.certDao.isOpenCrl(certDO.getSn())) {
            templateId = certDO.getTemplateId();
        }
        LdapOcspUrlVO user1LdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(signSn, dn.toString(), caInfoVO, false, templateId, certDO.getCrlTempId());
        extensions = ExtensionUtil.updateExtension((List)extensions, (LdapOcspUrlVO)user1LdapOcspUrlVO, (String)dn.toString(), (PublicKey)oldCert1.getPublicKey());
        X509Certificate userCert1 = this.hsmService.genX509Certificate(dn.toString(), signSn, nowTime, endTime, caInfoVO, oldCert1.getPublicKey(), extensions, templateDO.getSignAlg());
        X509Certificate userCert2 = null;
        if (null != certDataDO2) {
            BigInteger encSn = userCertSnVO.getEncSn();
            X509Certificate oldCert2 = CertUtil.getCertFromStr((String)certDataDO2.getData());
            List extensions2 = CertUtil.genExtensions((X509Certificate)oldCert2);
            LdapOcspUrlVO user2LdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(encSn, dn.toString(), caInfoVO, false, templateId, certDO.getCrlTempId());
            extensions2 = ExtensionUtil.updateExtension((List)extensions2, (LdapOcspUrlVO)user2LdapOcspUrlVO, (String)dn.toString(), (PublicKey)oldCert2.getPublicKey());
            userCert2 = this.hsmService.genX509Certificate(dn.toString(), encSn, nowTime, endTime, caInfoVO, oldCert2.getPublicKey(), extensions2, templateDO.getSignAlg());
        }
        TemplateInfoVO templateInfoVO = new TemplateInfoVO();
        templateInfoVO.setKeyAlg(certDO.getPublicKeyAlg());
        templateInfoVO.setKeySize(certDO.getPrivateKeySize());
        templateInfoVO.setSignAlg(certDO.getSignAlg());
        templateInfoVO.setId(certDO.getTemplateId());
        TemplateUserCertDO templateUserCertDO = this.templateUserCertDao.queryBySn(certDO.getSn());
        templateInfoVO.setOpenCrl(Boolean.valueOf(templateUserCertDO.isOpenCrl()));
        X509Certificate newEncCert = null;
        Long oldSignCertId = null;
        Long oldEncCertId = null;
        if (certDO.getType() == UserCertTypeEnum.SIGNCERT.value) {
            newSignCert = userCert1;
            newEncCert = userCert2;
            oldSignCertId = certDO.getId();
            oldEncCertId = certDO.getPairCertId();
        } else if (certDO.getType() == UserCertTypeEnum.ENCCERT.value) {
            newSignCert = userCert2;
            newEncCert = userCert1;
            oldEncCertId = certDO.getId();
            oldSignCertId = certDO.getPairCertId();
        } else {
            newSignCert = userCert1;
            oldSignCertId = certDO.getId();
        }
        if (certDO.getType() == UserCertTypeEnum.SINGLECERT.value) {
            this.saveRaUserCert(caInfoVO, newSignCert, templateInfoVO, raId, oldSignCertId);
        } else {
            this.saveRaUserCert(caInfoVO, newSignCert, newEncCert, templateInfoVO, raId, oldSignCertId, oldEncCertId);
        }
        return new RACertResponseVO(newSignCert, newEncCert, "");
    }

    private RACertResponseVO updateUserCertPwd(CaInfoVO caInfoVO, PublicKey publicKey, X500Name dn, CertDO certDO, CertDataDO certDataDO1, CertDataDO certDataDO2, Date nowTime, Date endTime, Long raId, TemplateDO templateDO, UserCertSnVO userCertSnVO) {
        try {
            X509Certificate userCert1 = CertUtil.getCertFromStr((String)certDataDO1.getData());
            X509Certificate userCert2 = null;
            if (null != certDataDO2) {
                userCert2 = CertUtil.getCertFromStr((String)certDataDO2.getData());
            }
            X509Certificate newSignCert = null;
            X509Certificate newEncCert = null;
            Long oldSignId = null;
            Long oldEncId = null;
            if (certDO.getType() == UserCertTypeEnum.SIGNCERT.value) {
                newSignCert = userCert1;
                newEncCert = userCert2;
                oldSignId = certDO.getId();
                oldEncId = certDO.getPairCertId();
            } else if (certDO.getType() == UserCertTypeEnum.ENCCERT.value) {
                newSignCert = userCert2;
                newEncCert = userCert1;
                oldEncId = certDO.getId();
                oldSignId = certDO.getPairCertId();
            } else {
                newSignCert = userCert1;
                oldSignId = certDO.getId();
            }
            TemplateInfoVO templateInfoVO = new TemplateInfoVO();
            templateInfoVO.setKeyAlg(certDO.getPublicKeyAlg());
            templateInfoVO.setKeySize(certDO.getPrivateKeySize());
            templateInfoVO.setSignAlg(certDO.getSignAlg());
            templateInfoVO.setId(certDO.getTemplateId());
            TemplateUserCertDO templateUserCertDO = this.templateUserCertDao.queryBySn(certDO.getSn());
            templateInfoVO.setOpenCrl(Boolean.valueOf(templateUserCertDO.isOpenCrl()));
            List extensions = CertUtil.genExtensions((X509Certificate)newSignCert);
            BigInteger signSn = userCertSnVO.getSignSn();
            Long templateId = null;
            if (templateDO.getOpenCrl().booleanValue()) {
                templateId = templateDO.getId();
            }
            LdapOcspUrlVO signLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(signSn, dn.toString(), caInfoVO, false, templateId, certDO.getCrlTempId());
            extensions = ExtensionUtil.updateExtension((List)extensions, (LdapOcspUrlVO)signLdapOcspUrlVO, (String)dn.toString(), (PublicKey)publicKey);
            newSignCert = this.hsmService.genX509Certificate(dn.toString(), signSn, nowTime, endTime, caInfoVO, publicKey, extensions, templateDO.getSignAlg());
            PublicKey encPublicKey = null;
            String signAndEvlopedDataBase64 = "";
            BigInteger encSn = userCertSnVO.getEncSn();
            if (templateDO.getCertPatterm() == CertPattermEnum.DOUBLE_CERT.id) {
                if (Constants.IS_KM) {
                    KmsService kmsService = null;
                    Config config = this.configFileService.getConfigInfo();
                    int kmSystemType = config.getKmSystemType();
                    if (kmSystemType == 1) {
                        kmsService = (KmsService)SpringBeanUtil.getBean((String)"kmsSansecService");
                    } else if (kmSystemType == 2) {
                        kmsService = (KmsService)SpringBeanUtil.getBean((String)"kmsXdjaHttpService");
                    }
                    this.logger.debug("\u5f00\u59cb\u5bc6\u7ba1\u7cfb\u7edf\u7533\u8bf7\u516c\u79c1\u94a5");
                    ResponseBean kmcKey = kmsService.applyEncKey(caInfoVO, encSn, publicKey, nowTime, caInfoVO.getRootCert().getNotAfter(), dn.toString(), null, null, templateDO.getKeySize().intValue(), "SM4", "SM3");
                    String publicKeyStr = kmcKey.getPublicKeyStr();
                    encPublicKey = StringUtils.isNotBlank((CharSequence)publicKeyStr) ? CertUtils.getPublicKeyBySubjectPublicInfo((String)kmcKey.getPublicKeyStr()) : kmcKey.getEncPublicKey();
                    signAndEvlopedDataBase64 = kmcKey.getPrivateKeyStr();
                    this.logger.debug("\u5411\u5bc6\u7ba1\u7cfb\u7edf\u7533\u8bf7\u516c\u79c1\u94a5\u7ed3\u675f");
                } else {
                    this.logger.debug("\u5f00\u59cb\u5411KmSoft\u7533\u8bf7\u516c\u79c1\u94a5");
                    RetKeyRespond retKeyRespond = kmSoft.applyKey(templateDO.getKeyAlg(), templateDO.getKeySize().intValue(), dn.toString(), signSn, publicKey);
                    encPublicKey = retKeyRespond.getPublicKey();
                    signAndEvlopedDataBase64 = Base64.toBase64String((byte[])retKeyRespond.getEncryptedPrivateKey().getDEREncoded());
                    this.logger.info("\u5411KM\u7533\u8bf7\u52a0\u5bc6\u516c\u79c1\u94a5\u6210\u529f\uff0cencPrivate" + Base64.toBase64String((byte[])retKeyRespond.getEncryptedPrivateKey().getDEREncoded()) + ",public=" + new String(Base64.encode((byte[])retKeyRespond.getPublicKey().getEncoded())));
                }
                List encExtensions = CertUtil.genExtensions((X509Certificate)newEncCert);
                LdapOcspUrlVO encLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(encSn, dn.toString(), caInfoVO, false, templateId, certDO.getCrlTempId());
                encExtensions = ExtensionUtil.updateExtension((List)encExtensions, (LdapOcspUrlVO)encLdapOcspUrlVO, (String)dn.toString(), (PublicKey)encPublicKey);
                newEncCert = this.hsmService.genX509Certificate(dn.toString(), encSn, nowTime, endTime, caInfoVO, encPublicKey, encExtensions, templateDO.getSignAlg());
                this.saveRaUserCert(caInfoVO, newSignCert, newEncCert, templateInfoVO, raId, oldSignId, oldEncId);
            } else {
                this.saveRaUserCert(caInfoVO, newSignCert, templateInfoVO, raId, oldSignId);
            }
            RACertResponseVO raCertResponseVO = new RACertResponseVO(newSignCert, newEncCert, signAndEvlopedDataBase64);
            return raCertResponseVO;
        }
        catch (Exception e) {
            throw new ServiceException("\u66f4\u65b0\u7528\u6237\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveRaUserCert(CaInfoVO caInfoVO, X509Certificate signCert, X509Certificate encCert, TemplateInfoVO templateInfoVO, Long raId, Long oldSignId, Long oldEncId) throws Exception {
        CrlTemplateDO crlTemplateDO;
        CertDO certDO = new CertDO();
        CertDataDO signCertDataDO = new CertDataDO();
        CertDataDO encCertDataDO = new CertDataDO();
        X509Certificate rootCert = caInfoVO.getRootCert();
        signCertDataDO.setData(CertUtil.writeObject((Object)signCert));
        signCertDataDO.setGmtCreate(signCert.getNotBefore());
        Date date = new Date();
        certDO.setId(Long.valueOf(this.certIdDao.getMaxId(date)));
        certDO.setFrozenNum(Integer.valueOf(0));
        certDO.setCaCertId(caInfoVO.getCertId());
        certDO.setConfirmationStatus(Constants.ISSUE_CERT_NO_ACK);
        certDO.setSn(signCert.getSerialNumber().toString(16));
        certDO.setSubject(CertUtil.getSubjectByX509Cert((X509Certificate)signCert));
        certDO.setIssuer(CertUtil.getIssuerByX509Cert((X509Certificate)signCert));
        certDO.setPublicKeyAlg(templateInfoVO.getKeyAlg());
        certDO.setPrivateKeySize(templateInfoVO.getKeySize());
        certDO.setNotBeforeTime(signCert.getNotBefore());
        certDO.setNotAfterTime(signCert.getNotAfter());
        certDO.setKeyNotAfterTime(rootCert.getNotAfter());
        certDO.setKeyNotBeforeTime(signCert.getNotBefore());
        certDO.setSignAlg(templateInfoVO.getSignAlg());
        certDO.setType(Integer.valueOf(UserCertTypeEnum.SIGNCERT.value));
        if (null != oldSignId) {
            certDO.setOldCertId(oldSignId);
        }
        certDO.setStatus(Integer.valueOf(1));
        certDO.setTemplateId(templateInfoVO.getId());
        certDO.setPairCertSn(encCert.getSerialNumber().toString(16));
        certDO.setConfirmationStatus(Constants.ISSUE_CERT_NO_ACK);
        certDO.setGmtCreate(signCert.getNotBefore());
        encCertDataDO.setData(CertUtil.writeObject((Object)encCert));
        encCertDataDO.setGmtCreate(signCert.getNotBefore());
        long crlTempIdByCertTempId = this.templateDao.getCrlTempIdByCertTempId(templateInfoVO.getId().longValue());
        if (crlTempIdByCertTempId != -1L) {
            this.crlTemplateService.increamCertCount(Long.valueOf(crlTempIdByCertTempId));
            crlTemplateDO = this.crlTemplateDao.getCrlTemplateById(Long.valueOf(crlTempIdByCertTempId));
            certDO.setCrlTempId(Long.valueOf(crlTempIdByCertTempId));
            certDO.setSegmentNo(String.valueOf(crlTemplateDO.getCertCount() / crlTemplateDO.getCrlMaxCertNumber().intValue()));
        }
        certDO = this.certDao.save(certDO);
        signCertDataDO.setId(certDO.getId());
        certDO.setSn(encCert.getSerialNumber().toString(16));
        certDO.setPairCertId(certDO.getId());
        certDO.setType(Integer.valueOf(UserCertTypeEnum.ENCCERT.value));
        if (null != oldEncId) {
            certDO.setOldCertId(oldEncId);
        }
        certDO.setPairCertSn(signCert.getSerialNumber().toString(16));
        certDO.setId(Long.valueOf(this.certIdDao.getMaxId(date)));
        certDO = this.certDao.save(certDO);
        if (crlTempIdByCertTempId != -1L) {
            this.crlTemplateService.increamCertCount(Long.valueOf(crlTempIdByCertTempId));
            certDO.setCrlTempId(Long.valueOf(crlTempIdByCertTempId));
            crlTemplateDO = this.crlTemplateDao.getCrlTemplateById(Long.valueOf(crlTempIdByCertTempId));
            certDO.setSegmentNo(String.valueOf(crlTemplateDO.getCertCount() / crlTemplateDO.getCrlMaxCertNumber().intValue()));
        }
        encCertDataDO.setId(certDO.getId());
        this.certDao.updatePairCertId(certDO.getPairCertId(), certDO.getId());
        ArrayList<CertDataDO> certDataDOList = new ArrayList<CertDataDO>();
        certDataDOList.add(encCertDataDO);
        certDataDOList.add(signCertDataDO);
        this.certDataDao.saveBatch(certDataDOList);
        RaCertDO signRaCertDO = new RaCertDO();
        RaCertDO encRaCertDO = new RaCertDO();
        signRaCertDO.setRaId(raId);
        signRaCertDO.setCertId(certDO.getId());
        signRaCertDO.setGmtCreate(encCert.getNotBefore());
        encRaCertDO.setCertId(certDO.getPairCertId());
        encRaCertDO.setRaId(raId);
        encRaCertDO.setGmtCreate(encCert.getNotBefore());
        TemplateUserCertDO templateUserCertDO = new TemplateUserCertDO();
        templateUserCertDO.setOpenCrl(templateInfoVO.getOpenCrl().booleanValue());
        templateUserCertDO.setTemplateId(templateInfoVO.getId());
        templateUserCertDO.setId(null);
        templateUserCertDO.setSn(signCert.getSerialNumber().toString(16));
        this.templateUserCertDao.insert(templateUserCertDO);
        templateUserCertDO.setId(null);
        templateUserCertDO.setSn(encCert.getSerialNumber().toString(16));
        this.templateUserCertDao.insert(templateUserCertDO);
        ArrayList<RaCertDO> raCertDOList = new ArrayList<RaCertDO>();
        raCertDOList.add(signRaCertDO);
        raCertDOList.add(encRaCertDO);
        this.raCertDao.saveBatch(raCertDOList);
        this.taskDataService.saveCertConfirmStatus(signCertDataDO.getId(), null);
    }

    public void saveRaUserCert(CaInfoVO caInfoVO, X509Certificate signCert, TemplateInfoVO templateInfoVO, Long raId, Long oldSignId) throws Exception {
        CertDO certDO = new CertDO();
        CertDataDO signCertDataDO = new CertDataDO();
        X509Certificate rootCert = caInfoVO.getRootCert();
        signCertDataDO.setData(CertUtil.writeObject((Object)signCert));
        signCertDataDO.setGmtCreate(signCert.getNotBefore());
        Date date = new Date();
        certDO.setFrozenNum(Integer.valueOf(0));
        certDO.setId(Long.valueOf(this.certIdDao.getMaxId(date)));
        certDO.setCaCertId(caInfoVO.getCertId());
        certDO.setConfirmationStatus(Constants.ISSUE_CERT_NO_ACK);
        certDO.setSn(signCert.getSerialNumber().toString(16));
        certDO.setSubject(CertUtil.getSubjectByX509Cert((X509Certificate)signCert));
        certDO.setIssuer(CertUtil.getIssuerByX509Cert((X509Certificate)signCert));
        certDO.setPublicKeyAlg(templateInfoVO.getKeyAlg());
        certDO.setPrivateKeySize(templateInfoVO.getKeySize());
        certDO.setNotBeforeTime(signCert.getNotBefore());
        certDO.setNotAfterTime(signCert.getNotAfter());
        certDO.setKeyNotAfterTime(rootCert.getNotAfter());
        certDO.setKeyNotBeforeTime(signCert.getNotBefore());
        certDO.setSignAlg(templateInfoVO.getSignAlg());
        certDO.setType(Integer.valueOf(UserCertTypeEnum.SINGLECERT.value));
        if (null != oldSignId) {
            certDO.setOldCertId(oldSignId);
        }
        certDO.setStatus(Integer.valueOf(1));
        certDO.setTemplateId(templateInfoVO.getId());
        certDO.setPairCertSn(null);
        certDO.setConfirmationStatus(Constants.ISSUE_CERT_NO_ACK);
        certDO.setGmtCreate(signCert.getNotBefore());
        long crlTempIdByCertTempId = this.templateDao.getCrlTempIdByCertTempId(templateInfoVO.getId().longValue());
        if (crlTempIdByCertTempId != -1L) {
            this.crlTemplateService.increamCertCount(Long.valueOf(crlTempIdByCertTempId));
            certDO.setCrlTempId(Long.valueOf(crlTempIdByCertTempId));
            CrlTemplateDO crlTemplateDO = this.crlTemplateDao.getCrlTemplateById(Long.valueOf(crlTempIdByCertTempId));
            certDO.setSegmentNo(String.valueOf(crlTemplateDO.getCertCount() / crlTemplateDO.getCrlMaxCertNumber().intValue()));
        }
        this.certDao.save(certDO);
        signCertDataDO.setId(certDO.getId());
        ArrayList<CertDataDO> certDataDOList = new ArrayList<CertDataDO>();
        certDataDOList.add(signCertDataDO);
        this.certDataDao.saveBatch(certDataDOList);
        RaCertDO signRaCertDO = new RaCertDO();
        signRaCertDO.setRaId(raId);
        signRaCertDO.setCertId(certDO.getId());
        signRaCertDO.setGmtCreate(signCert.getNotBefore());
        TemplateUserCertDO templateUserCertDO = new TemplateUserCertDO();
        templateUserCertDO.setOpenCrl(templateInfoVO.getOpenCrl().booleanValue());
        templateUserCertDO.setTemplateId(templateInfoVO.getId());
        templateUserCertDO.setId(null);
        templateUserCertDO.setSn(signCert.getSerialNumber().toString(16));
        TemplateUserCertDO insert = this.templateUserCertDao.insert(templateUserCertDO);
        this.logger.info("========================" + JsonUtils.object2Json((Object)insert));
        ArrayList<RaCertDO> raCertDOList = new ArrayList<RaCertDO>();
        raCertDOList.add(signRaCertDO);
        this.raCertDao.saveBatch(raCertDOList);
        this.taskDataService.saveCertConfirmStatus(signCertDataDO.getId(), null);
    }

    private RACertResponseVO recoveryUserCert(CaInfoVO caInfoVO, PublicKey publicKey, X500Name dn, CertDO revokeSignCert, CertDataDO revokeSignCertData, CertDataDO encCertData, Date nowTime, Date endTime, Long raId, String alg) {
        try {
            X509Certificate revokeOldSignUserCert = CertUtil.getCertFromStr((String)revokeSignCertData.getData());
            X509Certificate oldEncUserCert = CertUtil.getCertFromStr((String)encCertData.getData());
            Long oldSignId = revokeSignCert.getId();
            Long oldSignPairCertId = revokeSignCert.getPairCertId();
            CertDO oldSignPairCertDo = this.certDao.getCertById(oldSignPairCertId);
            List extensions = CertUtil.genExtensions((X509Certificate)revokeOldSignUserCert);
            BigInteger signSn = this.certSnDao.getMaxSn(nowTime);
            LdapOcspUrlVO signLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(signSn, dn.toString(), caInfoVO, false, revokeSignCert.getTemplateId(), revokeSignCert.getCrlTempId());
            extensions = ExtensionUtil.updateExtension((List)extensions, (LdapOcspUrlVO)signLdapOcspUrlVO, (String)dn.toString(), (PublicKey)publicKey);
            X509Certificate newSignCert = this.hsmService.genX509Certificate(dn.toString(), signSn, nowTime, endTime, caInfoVO, publicKey, extensions, alg);
            this.logger.info("\u5f00\u59cb\u5411KM\u7533\u8bf7\u52a0\u5bc6\u516c\u79c1\u94a5\uff0cdn=" + dn.toString() + ",signSn=" + signSn);
            String signAndEvlopedDataBase64 = "";
            Object obj = Constants.ENC_PRIVATE_MAP.get(oldEncUserCert.getSerialNumber().toString(16));
            this.logger.info("\u6062\u590d\u5bc6\u94a5\u7684\u52a0\u5bc6\u8bc1\u4e66sn\u4e3a\uff1a" + oldEncUserCert.getSerialNumber().toString(16));
            this.logger.info("\u6062\u590d\u5bc6\u94a5\u5bf9\u5e94\u7684\u5bc6\u94a5\u4e3a\uff1a" + obj);
            KmsService kmsService = null;
            if (Constants.IS_KM) {
                Config config = this.configFileService.getConfigInfo();
                int kmSystemType = config.getKmSystemType();
                if (kmSystemType == 1) {
                    kmsService = (KmsService)SpringBeanUtil.getBean((String)"kmsSansecService");
                } else if (kmSystemType == 2) {
                    kmsService = (KmsService)SpringBeanUtil.getBean((String)"kmsXdjaHttpService");
                }
                this.logger.info("\u5f00\u59cb\u5bc6\u7ba1\u7cfb\u7edf\u6062\u590d\u516c\u79c1\u94a5");
                BigInteger actRestoreSn = oldEncUserCert.getSerialNumber();
                if (null != oldSignPairCertDo.getOldCertId()) {
                    RevokedCertDO oldOldEncCertDo = this.revokeCertDao.getCertById(oldSignPairCertDo.getOldCertId().longValue());
                    this.logger.debug("\u8001\u7684\u8bc1\u4e66id\uff1a" + oldSignPairCertDo.getOldCertId());
                    this.logger.debug("\u8001\u7684\u8001\u7684\u52a0\u5bc6\u8bc1\u4e66sn:" + oldOldEncCertDo.getSn());
                    String queryRestoreSn = this.getApplyKeySn(oldOldEncCertDo.getSn());
                    if (StringUtils.isNotBlank((CharSequence)queryRestoreSn)) {
                        actRestoreSn = new BigInteger(queryRestoreSn, 16);
                    }
                }
                this.logger.debug("\u5411KM\u8fdb\u884c\u6062\u590d\u5bc6\u94a5\u5b9e\u9645\u4f7f\u7528\u7684\u8bc1\u4e66sn\u4e3a\uff1a" + actRestoreSn.toString(16));
                ResponseBean retKeyRespond = kmsService.restoreEncKey(caInfoVO, actRestoreSn, publicKey);
                signAndEvlopedDataBase64 = new String(retKeyRespond.getPrivateKeyStr().getBytes());
                this.logger.debug("\u5411\u5bc6\u7ba1\u7cfb\u7edf\u6062\u590d\u516c\u79c1\u94a5\u7ed3\u675f");
            } else {
                RetKeyRespond retKeyRespond;
                this.logger.debug("revokeSignCert[{}]", (Object)JSON.toJSONString((Object)revokeSignCert));
                if (null != obj) {
                    this.logger.debug("\u6062\u590d\u5bc6\u94a5\u65f6\u4e34\u65f6\u516c\u94a5:publickey=[{}]", (Object)publicKey);
                    retKeyRespond = kmSoft.restoreKey(revokeSignCert.getPublicKeyAlg(), revokeSignCert.getPrivateKeySize().intValue(), dn.toString(), signSn, publicKey, (PrivateKey)obj);
                    signAndEvlopedDataBase64 = Base64.toBase64String((byte[])retKeyRespond.getEncryptedPrivateKey().getDEREncoded());
                    this.logger.debug("\u5411\u5bc6\u7ba1\u7cfb\u7edf\u6062\u590d\u516c\u79c1\u94a5\u7ed3\u675f:map\u3002 signAndEvlopedDataBase64=" + signAndEvlopedDataBase64);
                } else {
                    this.logger.debug("\u5f00\u59cb\u5411KmSoft\u6062\u590d\u516c\u79c1\u94a5");
                    retKeyRespond = kmSoft.applyKey(revokeSignCert.getPublicKeyAlg(), revokeSignCert.getPrivateKeySize().intValue(), dn.toString(), signSn, publicKey);
                    PublicKey encPublicKey = retKeyRespond.getPublicKey();
                    signAndEvlopedDataBase64 = Base64.toBase64String((byte[])retKeyRespond.getEncryptedPrivateKey().getDEREncoded());
                    this.logger.debug("\u5411\u5bc6\u7ba1\u7cfb\u7edf\u6062\u590d\u516c\u79c1\u94a5\u7ed3\u675f:hard\u3002signAndEvlopedDataBase64=" + signAndEvlopedDataBase64);
                }
            }
            TemplateInfoVO templateInfoVO = new TemplateInfoVO();
            templateInfoVO.setKeyAlg(revokeSignCert.getPublicKeyAlg());
            templateInfoVO.setKeySize(revokeSignCert.getPrivateKeySize());
            templateInfoVO.setSignAlg(revokeSignCert.getSignAlg());
            templateInfoVO.setId(revokeSignCert.getTemplateId());
            TemplateUserCertDO templateUserCertDO = this.templateUserCertDao.queryBySn(revokeOldSignUserCert.getSerialNumber().toString(16));
            templateInfoVO.setOpenCrl(Boolean.valueOf(templateUserCertDO.isOpenCrl()));
            RACertResponseVO raCertResponseVO = new RACertResponseVO(newSignCert, oldEncUserCert, signAndEvlopedDataBase64);
            this.saveRaSignUserCert(caInfoVO, newSignCert, oldEncUserCert, templateInfoVO, raId, oldSignId, oldSignPairCertId);
            return raCertResponseVO;
        }
        catch (Exception e) {
            throw new ServiceException("\u6062\u590d\u7528\u6237\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveRaSignUserCert(CaInfoVO caInfoVO, X509Certificate signCert, X509Certificate encCert, TemplateInfoVO templateInfoVO, Long raId, Long oldSignId, Long oldSignPairCertId) throws Exception {
        CertDO certDO = new CertDO();
        X509Certificate rootCert = caInfoVO.getRootCert();
        Date date = new Date();
        certDO.setId(Long.valueOf(this.certIdDao.getMaxId(date)));
        certDO.setCaCertId(caInfoVO.getCertId());
        certDO.setConfirmationStatus(Constants.ISSUE_CERT_NO_ACK);
        certDO.setSn(signCert.getSerialNumber().toString(16));
        certDO.setSubject(CertUtil.getSubjectByX509Cert((X509Certificate)signCert));
        certDO.setIssuer(CertUtil.getIssuerByX509Cert((X509Certificate)signCert));
        certDO.setPublicKeyAlg(templateInfoVO.getKeyAlg());
        certDO.setPrivateKeySize(templateInfoVO.getKeySize());
        certDO.setNotBeforeTime(signCert.getNotBefore());
        certDO.setNotAfterTime(signCert.getNotAfter());
        certDO.setFrozenNum(Integer.valueOf(0));
        certDO.setKeyNotAfterTime(rootCert.getNotAfter());
        certDO.setKeyNotBeforeTime(signCert.getNotBefore());
        certDO.setSignAlg(templateInfoVO.getSignAlg());
        certDO.setType(Integer.valueOf(UserCertTypeEnum.SIGNCERT.value));
        if (null != oldSignId) {
            certDO.setOldCertId(oldSignId);
        }
        certDO.setStatus(Integer.valueOf(1));
        certDO.setTemplateId(templateInfoVO.getId());
        certDO.setPairCertId(oldSignPairCertId);
        certDO.setPairCertSn(encCert.getSerialNumber().toString(16));
        certDO.setConfirmationStatus(Constants.ISSUE_CERT_NO_ACK);
        certDO.setGmtCreate(signCert.getNotBefore());
        certDO = this.certDao.save(certDO);
        long crlTempIdByCertTempId = this.templateDao.getCrlTempIdByCertTempId(templateInfoVO.getId().longValue());
        if (crlTempIdByCertTempId != -1L) {
            this.crlTemplateService.increamCertCount(Long.valueOf(crlTempIdByCertTempId));
            certDO.setCrlTempId(Long.valueOf(crlTempIdByCertTempId));
            CrlTemplateDO crlTemplateDO = this.crlTemplateDao.getCrlTemplateById(Long.valueOf(crlTempIdByCertTempId));
            certDO.setSegmentNo(String.valueOf(crlTemplateDO.getCertCount() / crlTemplateDO.getCrlMaxCertNumber().intValue()));
        }
        CertDataDO signCertDataDO = new CertDataDO();
        signCertDataDO.setData(CertUtil.writeObject((Object)signCert));
        signCertDataDO.setGmtCreate(signCert.getNotBefore());
        signCertDataDO.setId(certDO.getId());
        ArrayList<CertDataDO> certDataDOList = new ArrayList<CertDataDO>();
        certDataDOList.add(signCertDataDO);
        this.certDataDao.saveBatch(certDataDOList);
        TemplateUserCertDO templateUserCertDO = new TemplateUserCertDO();
        templateUserCertDO.setOpenCrl(templateInfoVO.getOpenCrl().booleanValue());
        templateUserCertDO.setTemplateId(templateInfoVO.getId());
        templateUserCertDO.setId(null);
        templateUserCertDO.setSn(signCert.getSerialNumber().toString(16));
        this.templateUserCertDao.insert(templateUserCertDO);
        templateUserCertDO.setId(null);
        templateUserCertDO.setSn(encCert.getSerialNumber().toString(16));
        this.templateUserCertDao.insert(templateUserCertDO);
        RaCertDO signRaCertDO = new RaCertDO();
        signRaCertDO.setRaId(raId);
        signRaCertDO.setCertId(certDO.getId());
        signRaCertDO.setGmtCreate(encCert.getNotBefore());
        ArrayList<RaCertDO> raCertDOList = new ArrayList<RaCertDO>();
        raCertDOList.add(signRaCertDO);
        this.raCertDao.saveBatch(raCertDOList);
        this.taskDataService.saveCertConfirmStatus(signCertDataDO.getId(), null);
    }
}

