/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.racert;

import com.xdja.pki.ca.certcrl.service.impl.CrlService;
import com.xdja.pki.ca.certmanager.dao.CertDataDao;
import com.xdja.pki.ca.certmanager.dao.CrossCertDao;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDataDao;
import com.xdja.pki.ca.certmanager.dao.OutDateManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.OuterCrossCertDao;
import com.xdja.pki.ca.certmanager.dao.RaAdminCertDao;
import com.xdja.pki.ca.certmanager.dao.RaServerCertDao;
import com.xdja.pki.ca.certmanager.dao.RaTemplateDao;
import com.xdja.pki.ca.certmanager.dao.RevokeManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.SubCaCertDao;
import com.xdja.pki.ca.certmanager.dao.TemplateDao;
import com.xdja.pki.ca.certmanager.dao.models.CertUpdateBaseInfoDO;
import com.xdja.pki.ca.certmanager.dao.models.CrossCertDO;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDataDO;
import com.xdja.pki.ca.certmanager.dao.models.OutdateManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.OuterCrossCertDO;
import com.xdja.pki.ca.certmanager.dao.models.RaAdminCertDO;
import com.xdja.pki.ca.certmanager.dao.models.RaDO;
import com.xdja.pki.ca.certmanager.dao.models.RaServerCertDO;
import com.xdja.pki.ca.certmanager.dao.models.RevokedManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.SubCaCertDO;
import com.xdja.pki.ca.certmanager.dao.models.TemplateDO;
import com.xdja.pki.ca.certmanager.service.crltemplate.CrlTemplateService;
import com.xdja.pki.ca.certmanager.service.racert.OpenApiCMPService;
import com.xdja.pki.ca.certmanager.service.racert.RaManagerCertService;
import com.xdja.pki.ca.certmanager.service.racert.bean.CertFileInfo;
import com.xdja.pki.ca.certmanager.service.racert.bean.CertTypeEnum;
import com.xdja.pki.ca.certmanager.service.racert.bean.CertUpdateBaseInfoVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.DownloadCertVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.FreezeCertVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.IssueRaCertVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.RACertListVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.RACertQueryVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.RACertTypeEnum;
import com.xdja.pki.ca.certmanager.service.racert.bean.RARoleEnum;
import com.xdja.pki.ca.certmanager.service.racert.bean.RevokeCertVO;
import com.xdja.pki.ca.certmanager.service.task.TaskDataService;
import com.xdja.pki.ca.certmanager.service.template.TemplateService;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateInfoVO;
import com.xdja.pki.ca.certmanager.service.util.CertDetailQueryHandle;
import com.xdja.pki.ca.certmanager.service.util.DicDataConverUtil;
import com.xdja.pki.ca.certmanager.service.util.ExtensionUtil;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.enums.CertStatusEnum;
import com.xdja.pki.ca.core.enums.TemplateStatusEnum;
import com.xdja.pki.ca.core.enums.TemplateTypeEnum;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.pkcs7.EnvelopedDataUtil;
import com.xdja.pki.ca.core.pkcs7.P7bUtils;
import com.xdja.pki.ca.core.pkcs7.SM2EnvelopedData;
import com.xdja.pki.ca.core.util.DnUtil;
import com.xdja.pki.ca.core.util.FileUtils;
import com.xdja.pki.ca.core.util.time.DateTimeUtil;
import com.xdja.pki.ca.core.util.time.IssueTimeUtil;
import com.xdja.pki.ca.hsm.manager.HsmManager;
import com.xdja.pki.ca.ldap.service.vo.LdapOcspUrlVO;
import com.xdja.pki.ca.securitymanager.dao.CaCertDao;
import com.xdja.pki.ca.securitymanager.dao.CaDao;
import com.xdja.pki.ca.securitymanager.dao.CertSnDao;
import com.xdja.pki.ca.securitymanager.dao.DicDao;
import com.xdja.pki.ca.securitymanager.dao.ManagerCertIdDao;
import com.xdja.pki.ca.securitymanager.dao.model.CaCertDo;
import com.xdja.pki.ca.securitymanager.dao.model.CaDO;
import com.xdja.pki.ca.securitymanager.service.init.InitService;
import com.xdja.pki.ca.securitymanager.service.vo.AlgTypeEnum;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.SignAlgTypeEnum;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.catalina.util.ParameterMap;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.util.encoders.Base64;
import org.nutz.dao.pager.Pager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RaManagerCertServiceImpl
implements RaManagerCertService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ManagerCertDao managereCertDao;
    @Autowired
    private ManagerCertDataDao managerCertDataDao;
    @Autowired
    private RaAdminCertDao raAdminCertDao;
    @Autowired
    private RaServerCertDao raServerCertDao;
    @Autowired
    private RevokeManagerCertDao revokeManagerCertDao;
    @Autowired
    private ManagerCertDao managerCertDao;
    @Autowired
    private TemplateDao templateDao;
    @Autowired
    private TemplateService templateService;
    @Resource
    private CertDataDao certDataDao;
    @Resource
    private CaDao caDao;
    @Resource
    private CaCertDao caCertDao;
    @Resource
    private SubCaCertDao subCaCertDao;
    @Resource
    private CrossCertDao crossCertDao;
    @Resource
    private OuterCrossCertDao outerCrossCertDao;
    @Autowired
    private OutDateManagerCertDao outDateManagerCertDao;
    @Autowired
    private DicDao dicDao;
    @Autowired
    private HsmManager hsmService;
    @Autowired
    private CrlTemplateService crlTemplateService;
    @Autowired
    private OpenApiCMPService openApiCMPService;
    @Autowired
    private CrlService crlService;
    @Autowired
    private TaskDataService taskDataService;
    @Autowired
    private CertDetailQueryHandle certDetailQueryHandle;
    @Autowired
    private DicDataConverUtil dicDataConverUtil;
    @Autowired
    private CertSnDao certSnDao;
    @Autowired
    private InitService initService;
    @Autowired
    private RaTemplateDao raTemplateDao;
    @Autowired
    private ManagerCertIdDao managerCertIdDao;

    public Result doIssueRaManagerCert(IssueRaCertVO issueRaCertVO) {
        String raRoleName = RARoleEnum.getDeviceType((int)issueRaCertVO.getCertType());
        if (StringUtils.isBlank((CharSequence)raRoleName)) {
            this.logger.debug("\u7b7e\u53d1RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25,RA\u7ba1\u7406\u5458\u8bc1\u4e66\u7c7b\u578b\u9519\u8bef[{}]", (Object)issueRaCertVO);
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        TemplateInfoVO templateInfoVO = this.templateService.getInnerTemplateByType(TemplateTypeEnum.MANAGER.value);
        if (null == templateInfoVO) {
            this.logger.debug("\u7b7e\u53d1RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728");
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
        }
        if (TemplateStatusEnum.NORMAL.value != templateInfoVO.getStatus()) {
            this.logger.info("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u7ed3\u679c\uff1a\u6a21\u677f\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u6a21\u677f\u72b6\u6001\u4e3a[{}]", (Object)templateInfoVO.getStatus());
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
        }
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(templateInfoVO.getKeyAlg());
        if (null == caInfoVO || StringUtils.isBlank((CharSequence)caInfoVO.getBaseDn()) || null == caInfoVO.getRootCert()) {
            this.logger.debug("\u7b7e\u53d1RA\u7ba1\u7406\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u5230CA\u57fa\u672c\u4fe1\u606f[{}]", (Object)issueRaCertVO);
            return Result.failure((ErrorEnum)ErrorEnum.CA_BASEINFO_GET_FAIL);
        }
        if (caInfoVO.getRootCert().getNotAfter().before(new Date())) {
            this.logger.debug("\u7b7e\u53d1RA\u7ba1\u7406\u8bc1\u4e66\u5931\u8d25\uff1aCA\u6839\u8bc1\u4e66\u5df2\u8fc7\u671f[{}]", (Object)issueRaCertVO);
            return Result.failure((ErrorEnum)ErrorEnum.CA_ROOT_CERT_EXPIRED);
        }
        if (!issueRaCertVO.getCertDn().toLowerCase().endsWith(caInfoVO.getBaseDn().toLowerCase())) {
            this.logger.debug("\u7b7e\u53d1RA\u7ba1\u7406\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e2d\u7684baseDn\u4e0d\u6b63\u786e[{}]", (Object)issueRaCertVO);
            return Result.failure((ErrorEnum)ErrorEnum.BASEDN_ERROR);
        }
        try {
            X500Name x500Name = DnUtil.getRFC4519X500Name((String)issueRaCertVO.getCertDn());
            issueRaCertVO.setCertDn(x500Name.toString());
        }
        catch (Exception e) {
            this.logger.debug("\u521d\u59cb\u5316CA\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e0d\u7b26\u5408X500\u89c4\u8303[{}]", (Object)issueRaCertVO);
            return Result.failure((ErrorEnum)ErrorEnum.DN_FORMAT_FAIL);
        }
        PublicKey signPublicKey = CertUtil.getPublicKeyFromP10((String)issueRaCertVO.getP10());
        if (null == signPublicKey) {
            this.logger.debug("\u7b7e\u53d1RA\u7ba1\u7406\u8bc1\u4e66\u5931\u8d25\uff1ap10\u683c\u5f0f\u4e0d\u6b63\u786e[{}]", (Object)issueRaCertVO);
            return Result.failure((ErrorEnum)ErrorEnum.P10_FORMAT_ERROR);
        }
        PublicKey encPublicKey = null;
        try {
            encPublicKey = CertUtil.convertPublicKey((PublicKey)signPublicKey, (String)issueRaCertVO.getSubjectPublicKeyInfo());
        }
        catch (Exception e) {
            this.logger.debug(String.format("\u7b7e\u53d1RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1a\u52a0\u5bc6\u516c\u94a5\u683c\u5f0f\u9519\u8bef:%s", issueRaCertVO.getSubjectPublicKeyInfo()), (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.PEM_FORMAT_ERROR);
        }
        try {
            Date nowTime = new Date();
            BigInteger encSn = this.certSnDao.getMaxSn(nowTime);
            X509Certificate rootCert = caInfoVO.getRootCert();
            Date endTime = IssueTimeUtil.getCorrectTime((Long)issueRaCertVO.getValidity(), (Integer)templateInfoVO.getMaxValidity(), (Date)rootCert.getNotAfter(), (Date)nowTime);
            LdapOcspUrlVO encLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(encSn, issueRaCertVO.getCertDn(), caInfoVO, false, null, null);
            List encExtensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), null, (PublicKey)encPublicKey, (String)issueRaCertVO.getCertDn(), (LdapOcspUrlVO)encLdapOcspUrlVO, (boolean)false);
            X509Certificate encCert = this.hsmService.genX509Certificate(issueRaCertVO.getCertDn(), encSn, nowTime, endTime, caInfoVO, encPublicKey, encExtensions, templateInfoVO.getSignAlg());
            BigInteger signSn = this.certSnDao.getMaxSn(nowTime);
            LdapOcspUrlVO signLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(signSn, issueRaCertVO.getCertDn(), caInfoVO, false, null, null);
            List signExtensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), null, (PublicKey)signPublicKey, (String)issueRaCertVO.getCertDn(), (LdapOcspUrlVO)signLdapOcspUrlVO, (boolean)true);
            X509Certificate signCert = this.hsmService.genX509Certificate(issueRaCertVO.getCertDn(), signSn, nowTime, endTime, caInfoVO, signPublicKey, signExtensions, templateInfoVO.getSignAlg());
            this.saveRaAdminCert(caInfoVO.getCertId(), signCert, encCert, issueRaCertVO, templateInfoVO);
            this.logger.info("\u7b7e\u53d1RA\u7ba1\u7406\u5458\u8bc1\u4e66\u6210\u529f\uff1adn= " + issueRaCertVO.getCertDn() + ",signCert=" + CertUtil.writeObject((Object)signCert) + ",encCert=" + CertUtil.writeObject((Object)encCert));
            return Result.success((Object)CertUtil.enPEncCert((X509Certificate)signCert, (X509Certificate)encCert, (Integer)templateInfoVO.getKeyAlg()), (String)signSn.toString(16));
        }
        catch (Exception e) {
            throw new ServiceException("\u7b7e\u53d1RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public Result doIssueRaServerCert(IssueRaCertVO issueRaCertVO) {
        TemplateInfoVO templateInfoVO = this.templateService.getInnerTemplateByType(TemplateTypeEnum.SERVER.value);
        if (null == templateInfoVO) {
            this.logger.debug("\u7b7e\u53d1RA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728");
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
        }
        if (TemplateStatusEnum.NORMAL.value != templateInfoVO.getStatus()) {
            this.logger.info("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u7ed3\u679c\uff1a\u6a21\u677f\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u6a21\u677f\u72b6\u6001\u4e3a[{}]", (Object)templateInfoVO.getStatus());
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_STATUS_NOT_NORMAL);
        }
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(templateInfoVO.getKeyAlg());
        if (null == caInfoVO || StringUtils.isBlank((CharSequence)caInfoVO.getBaseDn()) || null == caInfoVO.getRootCert()) {
            this.logger.debug("\u7b7e\u53d1RA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u5230CA\u57fa\u672c\u4fe1\u606f[{}]", (Object)issueRaCertVO);
            return Result.failure((ErrorEnum)ErrorEnum.CA_BASEINFO_GET_FAIL);
        }
        if (caInfoVO.getRootCert().getNotAfter().before(new Date())) {
            this.logger.debug("\u7b7e\u53d1RA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25\uff1aCA\u6839\u8bc1\u4e66\u5df2\u8fc7\u671f[{}]", (Object)issueRaCertVO);
            return Result.failure((ErrorEnum)ErrorEnum.CA_ROOT_CERT_EXPIRED);
        }
        if (!issueRaCertVO.getCertDn().toLowerCase().endsWith(caInfoVO.getBaseDn().toLowerCase())) {
            this.logger.debug("\u7b7e\u53d1RA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e2d\u7684baseDn\u4e0d\u6b63\u786e[{}]", (Object)issueRaCertVO);
            return Result.failure((ErrorEnum)ErrorEnum.BASEDN_ERROR);
        }
        try {
            X500Name x500Name = DnUtil.getRFC4519X500Name((String)issueRaCertVO.getCertDn());
            issueRaCertVO.setCertDn(x500Name.toString());
        }
        catch (Exception e) {
            this.logger.debug("\u521d\u59cb\u5316CA\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e0d\u7b26\u5408X500\u89c4\u8303[{}]", (Object)issueRaCertVO.getCertDn());
            return Result.failure((ErrorEnum)ErrorEnum.DN_FORMAT_FAIL);
        }
        PublicKey signPublicKey = CertUtil.getPublicKeyFromP10((String)issueRaCertVO.getP10());
        if (null == signPublicKey) {
            this.logger.debug("p10\u683c\u5f0f\u9519\u8bef\uff0c\u83b7\u53d6\u516c\u94a5\u5931\u8d25[{}]", (Object)issueRaCertVO.getP10());
            return Result.failure((ErrorEnum)ErrorEnum.P10_FORMAT_ERROR);
        }
        PublicKey encPublicKey = null;
        try {
            encPublicKey = CertUtil.getPublicKeyBySubjectKeyInfo((Integer)Constants.BASE_ALG_TYPE, (String)issueRaCertVO.getSubjectPublicKeyInfo());
        }
        catch (Exception e) {
            this.logger.debug("\u52a0\u5bc6\u516c\u94a5\u683c\u5f0f\u9519\u8bef:[{}]", (Object)issueRaCertVO.getSubjectPublicKeyInfo(), (Object)e);
            return Result.failure((ErrorEnum)ErrorEnum.PEM_FORMAT_ERROR);
        }
        ParameterMap params = new ParameterMap();
        if (null != issueRaCertVO.getSubjectAlternativeName()) {
            params.put(Extension.subjectAlternativeName.getId(), issueRaCertVO.getSubjectAlternativeName());
        }
        try {
            Date nowTime = new Date();
            BigInteger encSn = this.certSnDao.getMaxSn(nowTime);
            X509Certificate rootCert = caInfoVO.getRootCert();
            Date endTime = IssueTimeUtil.getCorrectTime((Long)issueRaCertVO.getValidity(), (Integer)templateInfoVO.getMaxValidity(), (Date)rootCert.getNotAfter(), (Date)nowTime);
            LdapOcspUrlVO encLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(encSn, issueRaCertVO.getCertDn(), caInfoVO, false, null, null);
            List encExtensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), (Map)params, (PublicKey)encPublicKey, (String)issueRaCertVO.getCertDn(), (LdapOcspUrlVO)encLdapOcspUrlVO, (boolean)false);
            X509Certificate encCert = this.hsmService.genX509Certificate(issueRaCertVO.getCertDn(), encSn, nowTime, endTime, caInfoVO, encPublicKey, encExtensions, templateInfoVO.getSignAlg());
            BigInteger signSn = this.certSnDao.getMaxSn(nowTime);
            LdapOcspUrlVO signLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(signSn, issueRaCertVO.getCertDn(), caInfoVO, false, null, null);
            List signExtensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), (Map)params, (PublicKey)signPublicKey, (String)issueRaCertVO.getCertDn(), (LdapOcspUrlVO)signLdapOcspUrlVO, (boolean)true);
            X509Certificate signCert = this.hsmService.genX509Certificate(issueRaCertVO.getCertDn(), signSn, nowTime, endTime, caInfoVO, signPublicKey, signExtensions, templateInfoVO.getSignAlg());
            this.logger.info("RA\u670d\u52a1\u5668\u8bc1\u4e66\u7b7e\u53d1\u5b8c\u6210\uff0csignCert=" + CertUtil.writeObject((Object)signCert) + ",encCert=" + CertUtil.writeObject((Object)encCert));
            this.saveRaServerCert(caInfoVO.getCertId(), signCert, encCert, issueRaCertVO, templateInfoVO);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("certName", "ServerCert_" + DateTimeUtil.dateToZipStr((Date)nowTime) + ".zip");
            resultMap.put("sn", signSn.toString(16));
            resultMap.put("keyAlg", templateInfoVO.getKeyAlg());
            return Result.success(resultMap, (String)signSn.toString(16));
        }
        catch (Exception e) {
            throw new ServiceException("\u7b7e\u53d1ra\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public Result doVerifyPriCertStatus(String signSn, String encSn) {
        try {
            this.logger.debug("signSn:[{}],encSn:[{}]", (Object)signSn, (Object)encSn);
            int n = this.raAdminCertDao.updatePriCertStatus(signSn, encSn);
            if (n == 2) {
                this.logger.debug("\u8bc1\u4e66\u5199\u5361\u6210\u529f\u72b6\u6001\u66f4\u65b0\u6210\u529f");
                CaInfoVO caInfoVO = this.initService.getCaInfo(Constants.BASE_ALG_TYPE);
                Integer keyAlg = caInfoVO.getPublicKeyAlg();
                ManageCertDO managerCertSign = this.managereCertDao.getManagerCertsBySn(signSn, keyAlg.intValue());
                if (null == managerCertSign) {
                    this.logger.debug("\u8bc1\u4e66\u5199\u5361\u6210\u529f\u786e\u8ba4\u6d88\u606f\u5904\u7406\u5931\u8d25\uff1a\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u8bc1\u4e66");
                    return Result.failure((ErrorEnum)ErrorEnum.DOWNLOAD_CERT_NOT_EXIST);
                }
                this.taskDataService.savePublishCert(managerCertSign.getId(), managerCertSign.getPairCertId(), Integer.valueOf(2));
                Result result = Result.success();
                if (null != managerCertSign.getOldCertId()) {
                    ManageCertDO manageCertDO = this.managerCertDao.getManagerCertById(managerCertSign.getOldCertId());
                    RevokeCertVO revokeCertVO = new RevokeCertVO();
                    revokeCertVO.setAlg(Constants.BASE_ALG_TYPE);
                    revokeCertVO.setRevokeNote("\u8bc1\u4e66\u66f4\u65b0");
                    revokeCertVO.setRevokeReason(Integer.valueOf(4));
                    revokeCertVO.setSn(manageCertDO.getSn());
                    result = this.deleteRaManagerCert(revokeCertVO);
                }
                if (result.isSuccess()) {
                    this.taskDataService.deleteNoConfirmCertSync(null, managerCertSign.getId());
                } else {
                    result.setError(ErrorEnum.WRITE_CARD_ACK_TIME_OUT);
                }
                return result;
            }
            this.logger.debug("\u8bc1\u4e66\u5199\u5361\u6210\u529f\u786e\u8ba4\u6d88\u606f\u5904\u7406\u5931\u8d25:\u66f4\u65b0\u5199\u5361\u72b6\u6001\u65f6\u5019\u8bc1\u4e66\u6570\u91cf\u4e0d\u4e3a2");
            return Result.failure((ErrorEnum)ErrorEnum.ADMIN_CERT_ACK_ERROR);
        }
        catch (Exception e) {
            throw new ServiceException("\u8bc1\u4e66\u5199\u5361\u6210\u529f\u4e0a\u62a5\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result doUpdateRaManagerCert(IssueRaCertVO issueRaCertVO, CertTemplate certTemplate, Long raId) {
        try {
            String oldSignSn = issueRaCertVO.getSn();
            List oldCerts = this.managereCertDao.getCertsBySignSn(oldSignSn, Constants.BASE_ALG_TYPE);
            if (null == oldCerts || oldCerts.size() == 0) {
                RevokedManageCertDO revokedCertDO = this.revokeManagerCertDao.getRevokManagerCertsBySn(oldSignSn, Constants.BASE_ALG_TYPE);
                if (null != revokedCertDO) {
                    this.logger.debug("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u7ecf\u88ab\u64a4\u9500\uff0csignSn=[{}]", (Object)oldSignSn);
                    return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_REVOKED);
                }
                OutdateManageCertDO outdateCertDO = this.outDateManagerCertDao.getOutDateManagerCertsBySn(oldSignSn, Constants.BASE_ALG_TYPE);
                if (null != outdateCertDO) {
                    this.logger.debug("\u83b7\u53d6RA\u670d\u52a1\u5668\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671f\uff0csignSn=[{}]", (Object)oldSignSn);
                    return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
                }
                this.logger.debug("\u66f4\u65b0\u7ba1\u7406\u7c7b\u8bc1\u4e66\uff1a\u6ca1\u6709\u627e\u5230\u6b63\u5e38\u72b6\u6001\u7684\u8bc1\u4e66(\u7ba1\u7406\u5458\u8bc1\u4e66\u8fd8\u9700\u8981\u8bc1\u4e66\u6b63\u786e\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4)\uff0csignSN=[{}]", (Object)issueRaCertVO.getSn());
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXCEPTION);
            }
            ManageCertDO certDO = (ManageCertDO)oldCerts.get(0);
            if (certDO.getAfterTime().before(new Date())) {
                this.logger.debug("\u66f4\u65b0\u7ba1\u7406\u7c7b\u8bc1\u4e66\uff1a\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671fsignSN=[{}]", (Object)issueRaCertVO.getSn());
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
            }
            if (certDO.getStatus() == 2) {
                this.logger.debug("\u66f4\u65b0\u7ba1\u7406\u7c7b\u8bc1\u4e66\uff1a\u8bc1\u4e66\u88ab\u51bb\u7ed3signSN=[{}]", (Object)issueRaCertVO.getSn());
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_FREEZE);
            }
            TemplateDO templateDO = this.templateDao.getTemplateById(certDO.getTemplateId());
            if (null == templateDO) {
                this.logger.debug("\u66f4\u65b0RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728");
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
            }
            if (TemplateStatusEnum.NORMAL.value != templateDO.getStatus()) {
                this.logger.info("\u66f4\u65b0RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1a\u6a21\u677f\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u6a21\u677f\u72b6\u6001\u4e3a[{}]", (Object)templateDO.getStatus());
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_STATUS_NOT_NORMAL);
            }
            CaInfoVO caInfoVO = this.initService.getCaInfo(templateDO.getKeyAlg());
            if (null == caInfoVO || StringUtils.isBlank((CharSequence)caInfoVO.getBaseDn()) || null == caInfoVO.getRootCert()) {
                this.logger.debug("\u66f4\u65b0RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u5230CA\u57fa\u672c\u4fe1\u606f[{}]", (Object)issueRaCertVO);
                return Result.failure((ErrorEnum)ErrorEnum.CA_BASEINFO_GET_FAIL);
            }
            if (caInfoVO.getRootCert().getNotAfter().before(new Date())) {
                this.logger.debug("\u66f4\u65b0RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1aCA\u6839\u8bc1\u4e66\u5df2\u8fc7\u671f[{}]", (Object)issueRaCertVO);
                return Result.failure((ErrorEnum)ErrorEnum.CA_ROOT_CERT_EXPIRED);
            }
            if (issueRaCertVO.isDnUpdate()) {
                if (!issueRaCertVO.getCertDn().toLowerCase().endsWith(caInfoVO.getBaseDn().toLowerCase())) {
                    this.logger.debug("\u66f4\u65b0RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e2d\u7684baseDn\u4e0d\u6b63\u786e[{}]", (Object)issueRaCertVO);
                    return Result.failure((ErrorEnum)ErrorEnum.BASEDN_ERROR);
                }
                try {
                    X500Name x500Name = DnUtil.getRFC4519X500Name((String)issueRaCertVO.getCertDn());
                    issueRaCertVO.setCertDn(x500Name.toString());
                }
                catch (Exception e) {
                    this.logger.debug("\u66f4\u65b0RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e0d\u7b26\u5408X500\u89c4\u8303[{}]", (Object)issueRaCertVO.getCertDn());
                    return Result.failure((ErrorEnum)ErrorEnum.DN_FORMAT_FAIL);
                }
            }
            PublicKey newEncPublicKey = null;
            PublicKey newSignPublicKey = null;
            if (issueRaCertVO.isKeyUpdate()) {
                if (StringUtils.isNotBlank((CharSequence)issueRaCertVO.getP10())) {
                    newSignPublicKey = CertUtil.getPublicKeyFromP10((String)issueRaCertVO.getP10());
                    if (null == newSignPublicKey) {
                        this.logger.debug("\u66f4\u65b0RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1ap10\u683c\u5f0f\u4e0d\u6b63\u786e[{}]", (Object)issueRaCertVO);
                        return Result.failure((ErrorEnum)ErrorEnum.P10_FORMAT_ERROR);
                    }
                    try {
                        newEncPublicKey = CertUtil.convertPublicKey((PublicKey)newSignPublicKey, (String)issueRaCertVO.getSubjectPublicKeyInfo());
                    }
                    catch (Exception e) {
                        this.logger.debug(String.format("\u66f4\u65b0RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1a\u52a0\u5bc6\u516c\u94a5\u683c\u5f0f\u9519\u8bef:%s", issueRaCertVO.getSubjectPublicKeyInfo()), (Throwable)e);
                        return Result.failure((ErrorEnum)ErrorEnum.PEM_FORMAT_ERROR);
                    }
                } else {
                    newEncPublicKey = issueRaCertVO.getEncPublicKey();
                    newSignPublicKey = issueRaCertVO.getSignPublicKey();
                }
            }
            ManageCertDataDO certDataDO1 = this.managereCertDao.queryCertDataNoById(certDO.getId());
            ManageCertDataDO certDataDO2 = this.managereCertDao.queryCertDataNoById(certDO.getPairCertId());
            Long oldSignCertId = certDO.getType().intValue() == Constants.SIGN_CERT.intValue() ? certDataDO1.getId() : certDataDO2.getId();
            Long oldEncCertId = certDO.getType().intValue() != Constants.SIGN_CERT.intValue() ? certDataDO1.getId() : certDataDO2.getId();
            X509Certificate oldSignCert = certDO.getType().intValue() == Constants.SIGN_CERT.intValue() ? CertUtil.getCertFromStr((String)certDataDO1.getData()) : CertUtil.getCertFromStr((String)certDataDO2.getData());
            X509Certificate oldEncCert = certDO.getType().intValue() != Constants.SIGN_CERT.intValue() ? CertUtil.getCertFromStr((String)certDataDO1.getData()) : CertUtil.getCertFromStr((String)certDataDO2.getData());
            PublicKey signPublicKey = issueRaCertVO.isKeyUpdate() ? newSignPublicKey : oldSignCert.getPublicKey();
            PublicKey encPublicKey = issueRaCertVO.isKeyUpdate() ? newEncPublicKey : oldEncCert.getPublicKey();
            String dn = issueRaCertVO.isDnUpdate() ? issueRaCertVO.getCertDn() : CertUtil.getSubjectByX509Cert((X509Certificate)oldSignCert);
            Date beginTime = null;
            Date afterTime = null;
            X509Certificate rootCert = caInfoVO.getRootCert();
            if (null != certTemplate) {
                RaDO raDO = this.raTemplateDao.getRaDoById(raId);
                if (null == raDO || !dn.toLowerCase().endsWith(raDO.getBaseDn().toLowerCase())) {
                    this.logger.info("CMP\u7b7e\u53d1\u53cc\u8bc1\u4e66\u5931\u8d25: \u7528\u6237\u7684baseDN[{}]\u548cRA\u7684BaseDn[{}]\u4e0d\u4e00\u81f4", (Object)dn, (Object)raDO.getBaseDn());
                    return Result.failure((ErrorEnum)ErrorEnum.USER_DN_NOT_SAME_RA_BASEDN);
                }
                beginTime = certTemplate.getValidity().getNotBefore().getDate();
                afterTime = IssueTimeUtil.getUserIssueAfterTime((Date)certTemplate.getValidity().getNotAfter().getDate(), (Integer)templateDO.getMaxValidity(), (Date)rootCert.getNotAfter(), (Date)beginTime);
            } else {
                beginTime = new Date();
                afterTime = issueRaCertVO.isValidityUpdate() ? IssueTimeUtil.getCertUpdateTime((Long)issueRaCertVO.getValidity(), (Integer)templateDO.getMaxValidity(), (Date)rootCert.getNotAfter(), (Date)oldSignCert.getNotAfter(), (Date)beginTime) : oldSignCert.getNotAfter();
            }
            List signExtensions = CertUtil.genExtensions((X509Certificate)oldSignCert);
            List encExtensions = CertUtil.genExtensions((X509Certificate)oldEncCert);
            BigInteger signSn = this.certSnDao.getMaxSn(beginTime);
            LdapOcspUrlVO signLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(signSn, issueRaCertVO.getCertDn(), caInfoVO, false, null, null);
            signExtensions = ExtensionUtil.updateExtension((List)signExtensions, (LdapOcspUrlVO)signLdapOcspUrlVO, (String)issueRaCertVO.getCertDn(), (PublicKey)signPublicKey);
            X509Certificate newSignCert = this.hsmService.genX509Certificate(issueRaCertVO.getCertDn(), signSn, beginTime, afterTime, caInfoVO, signPublicKey, signExtensions, templateDO.getSignAlg());
            BigInteger encSn = this.certSnDao.getMaxSn(beginTime);
            LdapOcspUrlVO encLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(encSn, issueRaCertVO.getCertDn(), caInfoVO, false, null, null);
            encExtensions = ExtensionUtil.updateExtension((List)encExtensions, (LdapOcspUrlVO)encLdapOcspUrlVO, (String)issueRaCertVO.getCertDn(), (PublicKey)encPublicKey);
            X509Certificate newEncCert = this.hsmService.genX509Certificate(dn, encSn, beginTime, afterTime, caInfoVO, encPublicKey, encExtensions, templateDO.getSignAlg());
            ManageCertDataDO signManageCertDataDo = new ManageCertDataDO();
            ManageCertDataDO encManageCertDataDo = new ManageCertDataDO();
            RaAdminCertDO raAdminCertDO = this.raAdminCertDao.getRaAdminCertByManageId(oldSignCertId);
            this.buildManagerCertData(newSignCert, newEncCert, certDO, signManageCertDataDo, encManageCertDataDo);
            this.updateRaAdminCert(caInfoVO.getCertId(), newSignCert, newEncCert, templateDO, oldSignCertId, oldEncCertId, signManageCertDataDo, encManageCertDataDo, raAdminCertDO);
            this.logger.info("\u66f4\u65b0RA\u7ba1\u7406\u5458\u8bc1\u4e66\u6210\u529f\uff0cnewSignCert=" + CertUtil.writeObject((Object)newSignCert) + ",newEncCert=" + CertUtil.writeObject((Object)newEncCert));
            return Result.success((Object)CertUtil.enPEncCert((X509Certificate)newSignCert, (X509Certificate)newEncCert, (Integer)templateDO.getKeyAlg()), (String)certDO.getSubject());
        }
        catch (Exception e) {
            throw new ServiceException("\u66f4\u65b0\u7ba1\u7406\u7c7b\u8bc1\u4e66\u5931\u8d25\u5931\u8d25", (Throwable)e);
        }
    }

    public Result deleteRaManagerCert(RevokeCertVO revokeCertVO) {
        return this.doRevokeManageDoubleCert(revokeCertVO.getSn(), revokeCertVO.getAlg(), revokeCertVO.getRevokeReason(), revokeCertVO.getRevokeNote());
    }

    private void updateRaAdminCert(Long caCertId, X509Certificate signCert, X509Certificate encCert, TemplateDO templateDO, Long oldSignCertId, Long oldEncCertId, ManageCertDataDO signManageCertDataDo, ManageCertDataDO encManageCertDataDo, RaAdminCertDO raAdminCertDO) throws Exception {
        ArrayList<ManageCertDataDO> manageCertDataDOList = new ArrayList<ManageCertDataDO>();
        Date date = new Date();
        ManageCertDO manageCertDO = new ManageCertDO();
        manageCertDO.setId(Long.valueOf(this.managerCertIdDao.getMaxId(date)));
        manageCertDO.setCaCertId(caCertId);
        manageCertDO.setSn(encCert.getSerialNumber().toString(16));
        manageCertDO.setIssuer(CertUtil.getIssuerByX509Cert((X509Certificate)encCert));
        manageCertDO.setSubject(CertUtil.getSubjectByX509Cert((X509Certificate)encCert));
        manageCertDO.setPublicKeyAlg(templateDO.getKeyAlg());
        manageCertDO.setPrivateKeySize(templateDO.getKeySize());
        manageCertDO.setBeforeTime(encCert.getNotBefore());
        manageCertDO.setAfterTime(encCert.getNotAfter());
        manageCertDO.setSignAlg(templateDO.getSignAlg());
        manageCertDO.setType(Constants.ENC_CERT);
        manageCertDO.setStatus(Integer.valueOf(1));
        manageCertDO.setTemplateId(templateDO.getId());
        manageCertDO.setPairCertSn(signCert.getSerialNumber().toString(16));
        manageCertDO.setConfirmationStatus(Constants.ISSUE_CERT_NO_ACK);
        manageCertDO.setGmtCreate(signCert.getNotBefore());
        manageCertDO.setOldCertId(oldEncCertId);
        manageCertDO = this.managereCertDao.save(manageCertDO);
        encManageCertDataDo.setId(manageCertDO.getId());
        manageCertDataDOList.add(encManageCertDataDo);
        manageCertDO.setSn(signCert.getSerialNumber().toString(16));
        manageCertDO.setPairCertSn(encCert.getSerialNumber().toString(16));
        manageCertDO.setPairCertId(manageCertDO.getId());
        manageCertDO.setType(Constants.SIGN_CERT);
        manageCertDO.setId(Long.valueOf(this.managerCertIdDao.getMaxId(date)));
        manageCertDO.setOldCertId(oldSignCertId);
        manageCertDO = this.managereCertDao.save(manageCertDO);
        signManageCertDataDo.setId(manageCertDO.getId());
        manageCertDataDOList.add(signManageCertDataDo);
        raAdminCertDO.setGmtCreate(signCert.getNotBefore());
        raAdminCertDO.setManageCertId(manageCertDO.getId());
        raAdminCertDO.setGmtModified(null);
        raAdminCertDO.setId(null);
        this.raAdminCertDao.save(raAdminCertDO);
        this.managereCertDao.updatePairCertId(manageCertDO.getPairCertId(), manageCertDO.getId());
        this.managerCertDataDao.batchSave(manageCertDataDOList);
        this.taskDataService.saveCertConfirmStatus(null, signManageCertDataDo.getId());
    }

    private void buildManagerCertData(X509Certificate newSignCert, X509Certificate newEncCert, ManageCertDO certDO, ManageCertDataDO signManageCertDataDo, ManageCertDataDO encManageCertDataDo) throws Exception {
        signManageCertDataDo.setGmtCreate(newSignCert.getNotBefore());
        signManageCertDataDo.setData(CertUtil.writeObject((Object)newSignCert));
        encManageCertDataDo.setGmtCreate(newSignCert.getNotBefore());
        encManageCertDataDo.setData(CertUtil.writeObject((Object)newEncCert));
    }

    private Result revokeNotAckManagerCert(String signSn, String alg, int revokeRease, String revokeNote) {
        try {
            List revokeCerts = this.managereCertDao.getCertsByNotAclSignSn(signSn, alg);
            ArrayList<RevokedManageCertDO> revokedCertDOS = new ArrayList<RevokedManageCertDO>();
            ManageCertDO certDO = new ManageCertDO();
            Result result = Result.failure((ErrorEnum)ErrorEnum.SERVER_INTERNAL_EXCEPTION);
            if (null == revokeCerts || revokeCerts.size() == 0) {
                this.logger.debug("\u64a4\u9500\u7ba1\u7406\u7c7b\u8bc1\u4e66\uff1a\u6ca1\u6709\u627e\u5230\u6b63\u5e38\u72b6\u6001\u7684\u8bc1\u4e66\uff0csignSN=[{}]", (Object)signSn);
                result = Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXCEPTION);
            } else {
                for (int i = 0; i < revokeCerts.size(); ++i) {
                    certDO = (ManageCertDO)revokeCerts.get(i);
                    Date revokeTime = new Date();
                    this.bulidRevokeData(certDO, revokedCertDOS, revokeRease, revokeNote, revokeTime);
                }
                if (revokedCertDOS.size() == 2) {
                    this.revokeManagerCertDao.saveBatch(revokedCertDOS);
                    this.managerCertDao.deleteBatch(revokeCerts);
                    this.logger.debug("\u64a4\u9500\u7ba1\u7406\u7c7b\u8bc1\u4e66\u6210\u529f\uff1asignSN=[{}]", (Object)signSn);
                    result = Constants.SIGN_CERT.intValue() == certDO.getType().intValue() ? Result.success((Object)certDO.getSubject(), (String)String.valueOf(certDO.getId())) : Result.success((Object)certDO.getSubject(), (String)String.valueOf(certDO.getPairCertId()));
                } else {
                    this.logger.debug("\u64a4\u9500\u7ba1\u7406\u7c7b\u8bc1\u4e66\u5931\u8d25\uff1a\u6ca1\u6709\u627e\u5230\u53cc\u8bc1\u4fe1\u606fsignSN=[{}]", (Object)signSn);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new ServiceException("\u64a4\u9500\u7ba1\u7406\u7c7b\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public Result doRevokeManageDoubleCert(String signSn, Integer alg, int revokeRease, String revokeNote) {
        try {
            if (revokeRease < 0 || revokeRease > 10) {
                this.logger.info("\u64a4\u9500\u8bc1\u4e66\u5931\u8d25\uff0c\u64a4\u9500\u7406\u7531\u4e0d\u6b63\u786e,reason:" + revokeRease);
                return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
            }
            List revokeCerts = this.managereCertDao.getCertsBySignSn(signSn, alg);
            ArrayList<RevokedManageCertDO> revokedCertDOS = new ArrayList<RevokedManageCertDO>();
            ManageCertDO certDO = new ManageCertDO();
            Result result = Result.failure((ErrorEnum)ErrorEnum.SERVER_INTERNAL_EXCEPTION);
            Date revokeTime = new Date();
            if (null == revokeCerts || revokeCerts.size() == 0) {
                this.logger.debug("\u64a4\u9500\u7ba1\u7406\u7c7b\u8bc1\u4e66\uff1a\u6ca1\u6709\u627e\u5230\u6b63\u5e38\u72b6\u6001\u7684\u8bc1\u4e66(\u7ba1\u7406\u5458\u8bc1\u4e66\u8fd8\u9700\u8981\u8bc1\u4e66\u6b63\u786e\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4)\uff0csignSN=[{}]", (Object)signSn);
                result = Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXCEPTION);
            } else {
                for (int i = 0; i < revokeCerts.size(); ++i) {
                    certDO = (ManageCertDO)revokeCerts.get(i);
                    if (certDO.getAfterTime().before(new Date())) {
                        this.logger.debug("\u64a4\u9500\u7ba1\u7406\u7c7b\u8bc1\u4e66\uff1a\u8bc1\u4e66\u5df2\u7ecf\u8fc7\u671fsignSN=" + signSn + ",afterTime=" + certDO.getAfterTime());
                        result = Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
                        continue;
                    }
                    if (certDO.getStatus() == 2) {
                        this.logger.debug("\u64a4\u9500\u7ba1\u7406\u7c7b\u8bc1\u4e66\uff1a\u8bc1\u4e66\u88ab\u51bb\u7ed3signSN=[{}]", (Object)signSn);
                        result = Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_FREEZE);
                        continue;
                    }
                    this.bulidRevokeData(certDO, revokedCertDOS, revokeRease, revokeNote, revokeTime);
                }
                if (revokedCertDOS.size() == 2) {
                    this.revokeManagerCertDao.saveBatch(revokedCertDOS);
                    this.managerCertDao.deleteBatch(revokeCerts);
                    this.logger.debug("\u64a4\u9500\u7ba1\u7406\u7c7b\u8bc1\u4e66\u6210\u529f\uff1asignSN=[{}]", (Object)signSn);
                    CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get((int)alg);
                    RevokedManageCertDO revokedManagerCertDO = (RevokedManageCertDO)revokedCertDOS.get(0);
                    if (Constants.SIGN_CERT.intValue() == revokedManagerCertDO.getType().intValue()) {
                        this.taskDataService.saveSyncStatusCert(revokedManagerCertDO.getId(), revokedManagerCertDO.getPairCertId(), Integer.valueOf(2), Integer.valueOf(CertStatusEnum.REVOKE.value), Integer.valueOf(revokeRease), revokeTime);
                    } else {
                        this.taskDataService.saveSyncStatusCert(revokedManagerCertDO.getPairCertId(), revokedManagerCertDO.getId(), Integer.valueOf(2), Integer.valueOf(CertStatusEnum.REVOKE.value), Integer.valueOf(revokeRease), revokeTime);
                    }
                    result = Result.success((String)certDO.getSubject());
                } else {
                    this.logger.debug("\u64a4\u9500\u7ba1\u7406\u7c7b\u8bc1\u4e66\u5931\u8d25\uff1a\u6ca1\u6709\u627e\u5230\u53cc\u8bc1\u4fe1\u606fsignSN=[{}]", (Object)signSn);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new ServiceException("\u64a4\u9500\u7ba1\u7406\u7c7b\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public Result doRevokeCert(RevokeCertVO revokeCertVO) {
        int type = revokeCertVO.getType();
        switch (type) {
            case 1: {
                return this.deleteRaManagerCert(revokeCertVO);
            }
            case 2: {
                return this.deleteSubCaCert(revokeCertVO);
            }
            case 3: {
                return this.deleteCorssCert(revokeCertVO);
            }
            case 4: {
                return this.openApiCMPService.doRevokeUserCert(revokeCertVO.getSn(), revokeCertVO.getAlg(), true, revokeCertVO.getRevokeReason().intValue(), revokeCertVO.getRevokeNote(), false);
            }
            case 5: {
                return this.openApiCMPService.doRevokeUserCert(revokeCertVO.getSn(), revokeCertVO.getAlg(), true, revokeCertVO.getRevokeReason().intValue(), revokeCertVO.getRevokeNote(), true);
            }
        }
        return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
    }

    public Result doFreezeCert(FreezeCertVO freezeCertVO) {
        int type = freezeCertVO.getType();
        switch (type) {
            case 4: {
                return this.openApiCMPService.doFreezeUserCert(freezeCertVO.getSn(), freezeCertVO.getFreezeNote());
            }
        }
        return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
    }

    public Result doUnFreezeCert(FreezeCertVO freezeCertVO) {
        int type = freezeCertVO.getType();
        switch (type) {
            case 4: {
                return this.openApiCMPService.doUnFreezeUserCert(freezeCertVO.getSn(), freezeCertVO.getFreezeNote());
            }
        }
        return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
    }

    private Result deleteSubCaCert(RevokeCertVO revokeCertVO) {
        try {
            if (revokeCertVO.getRevokeReason() < 0 || revokeCertVO.getRevokeReason() > 10) {
                this.logger.info("\u64a4\u9500\u8bc1\u4e66\u5931\u8d25\uff0c\u64a4\u9500\u7406\u7531\u4e0d\u6b63\u786e,reason:" + revokeCertVO.getRevokeReason());
                return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
            }
            Date revokeTime = new Date();
            SubCaCertDO subCaCertDO = this.subCaCertDao.getSubCaCert(revokeCertVO.getSn(), revokeCertVO.getAlg().intValue());
            if (null == subCaCertDO) {
                this.logger.debug("\u64a4\u9500\u5b50CA\u8bc1\u4e66\u5931\u8d25\uff1a\u6ca1\u6709\u627e\u5230\u5b50CA\u8bc1\u4e66\uff0csn=[{}]", (Object)revokeCertVO.getSn());
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXCEPTION);
            }
            if (subCaCertDO.getStatus() == 2) {
                this.logger.debug("\u64a4\u9500\u5b50CA\u8bc1\u4e66\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u7ecf\u88ab\u64a4\u9500\uff0csn=[{}]", (Object)revokeCertVO.getSn());
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_REVOKED);
            }
            if (subCaCertDO.getAfterTime().before(revokeTime)) {
                this.logger.debug("\u64a4\u9500\u5b50CA\u8bc1\u4e66\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u8fc7\u671f\uff0csn=[{}]", (Object)revokeCertVO.getSn());
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
            }
            subCaCertDO.setStatus(Integer.valueOf(2));
            subCaCertDO.setRevokeReason(revokeCertVO.getRevokeReason());
            if (StringUtils.isNotBlank((CharSequence)revokeCertVO.getRevokeNote())) {
                subCaCertDO.setRevokeNote(revokeCertVO.getRevokeNote());
            } else {
                subCaCertDO.setRevokeNote("");
            }
            subCaCertDO.setGmtModified(revokeTime);
            this.subCaCertDao.updateSubCaCert(subCaCertDO);
            this.taskDataService.saveSyncStatusCert(subCaCertDO.getId(), null, Integer.valueOf(4), Integer.valueOf(CertStatusEnum.REVOKE.value), revokeCertVO.getRevokeReason(), revokeTime);
            this.logger.info("\u64a4\u9500\u5b50CA\u8bc1\u4e66\u6210\u529f");
            return Result.success((String)subCaCertDO.getSubject());
        }
        catch (Exception e) {
            throw new ServiceException("\u64a4\u9500\u5b50CA\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    private Result deleteCorssCert(RevokeCertVO revokeCertVO) {
        try {
            if (revokeCertVO.getRevokeReason() < 0 || revokeCertVO.getRevokeReason() > 10) {
                this.logger.info("\u64a4\u9500\u8bc1\u4e66\u5931\u8d25\uff0c\u64a4\u9500\u7406\u7531\u4e0d\u6b63\u786e,reason:" + revokeCertVO.getRevokeReason());
                return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
            }
            Date revokeTime = new Date();
            CrossCertDO crossCertDO = this.crossCertDao.getCrossCert(revokeCertVO.getSn(), revokeCertVO.getAlg().intValue());
            if (null == crossCertDO) {
                this.logger.debug("\u64a4\u9500\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25\uff1a\u6ca1\u6709\u627e\u5230\u4ea4\u53c9\u8bc1\u4e66\uff0csn=[{}]", (Object)revokeCertVO.getSn());
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXCEPTION);
            }
            if (crossCertDO.getStatus() == 2) {
                this.logger.debug("\u64a4\u9500\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u7ecf\u88ab\u64a4\u9500\uff0csn=[{}]", (Object)revokeCertVO.getSn());
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_REVOKED);
            }
            if (crossCertDO.getAfterTime().before(revokeTime)) {
                this.logger.debug("\u64a4\u9500\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25\uff1a\u8bc1\u4e66\u5df2\u8fc7\u671f\uff0csn=[{}]", (Object)revokeCertVO.getSn());
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
            }
            crossCertDO.setStatus(Integer.valueOf(2));
            crossCertDO.setRevokeReason(revokeCertVO.getRevokeReason());
            if (StringUtils.isNotBlank((CharSequence)revokeCertVO.getRevokeNote())) {
                crossCertDO.setRevokeNote(revokeCertVO.getRevokeNote());
            } else {
                crossCertDO.setRevokeNote("");
            }
            crossCertDO.setGmtModified(revokeTime);
            this.crossCertDao.updateCrossCert(crossCertDO);
            this.taskDataService.saveSyncStatusCert(crossCertDO.getId(), null, Integer.valueOf(3), Integer.valueOf(CertStatusEnum.REVOKE.value), revokeCertVO.getRevokeReason(), revokeTime);
            this.logger.info("\u64a4\u9500\u4ea4\u53c9\u8bc1\u4e66\u6210\u529f");
            return Result.success((String)crossCertDO.getSubject());
        }
        catch (Exception e) {
            throw new ServiceException("\u64a4\u9500\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    private void bulidRevokeData(ManageCertDO certDO, List<RevokedManageCertDO> revokedCertDOS, int revokeRease, String revokeNote, Date revokeTime) {
        RevokedManageCertDO revokedCertDO = new RevokedManageCertDO();
        BeanUtils.copyProperties((Object)certDO, (Object)revokedCertDO);
        revokedCertDO.setAfterTime(certDO.getAfterTime());
        revokedCertDO.setBeforeTime(certDO.getBeforeTime());
        revokedCertDO.setRevokeReason(Integer.valueOf(revokeRease));
        revokedCertDO.setGmtCreate(revokeTime);
        revokedCertDO.setGmtModified(null);
        if (StringUtils.isBlank((CharSequence)revokeNote)) {
            revokeNote = "";
        }
        revokedCertDO.setRevokeNote(revokeNote);
        revokedCertDO.setGmtCreate(new Date());
        revokedCertDOS.add(revokedCertDO);
    }

    private void saveRaServerCert(Long caCertId, X509Certificate signCert, X509Certificate encCert, IssueRaCertVO issueRaCertVO, TemplateInfoVO templateInfoVO) throws Exception {
        ArrayList<ManageCertDataDO> manageCertDataDOList = new ArrayList<ManageCertDataDO>();
        ManageCertDataDO signManageCertDataDO = new ManageCertDataDO();
        ManageCertDataDO encManageCertDataDO = new ManageCertDataDO();
        encManageCertDataDO.setData(CertUtil.writeObject((Object)encCert));
        encManageCertDataDO.setGmtCreate(encCert.getNotBefore());
        signManageCertDataDO.setData(CertUtil.writeObject((Object)signCert));
        signManageCertDataDO.setGmtCreate(signCert.getNotBefore());
        Date date = new Date();
        ManageCertDO manageCertDO = new ManageCertDO();
        manageCertDO.setId(Long.valueOf(this.managerCertIdDao.getMaxId(date)));
        manageCertDO.setCaCertId(caCertId);
        manageCertDO.setSn(encCert.getSerialNumber().toString(16));
        manageCertDO.setIssuer(CertUtil.getIssuerByX509Cert((X509Certificate)encCert));
        manageCertDO.setSubject(CertUtil.getSubjectByX509Cert((X509Certificate)encCert));
        manageCertDO.setPublicKeyAlg(templateInfoVO.getKeyAlg());
        manageCertDO.setPrivateKeySize(templateInfoVO.getKeySize());
        manageCertDO.setBeforeTime(encCert.getNotBefore());
        manageCertDO.setAfterTime(encCert.getNotAfter());
        manageCertDO.setSignAlg(templateInfoVO.getSignAlg());
        manageCertDO.setType(Constants.ENC_CERT);
        manageCertDO.setStatus(Integer.valueOf(1));
        manageCertDO.setTemplateId(templateInfoVO.getId());
        manageCertDO.setPairCertSn(signCert.getSerialNumber().toString(16));
        manageCertDO.setConfirmationStatus(Constants.ISSUE_CERT_OK_ACK);
        manageCertDO.setGmtCreate(encCert.getNotBefore());
        manageCertDO = this.managereCertDao.save(manageCertDO);
        encManageCertDataDO.setId(manageCertDO.getId());
        manageCertDataDOList.add(encManageCertDataDO);
        manageCertDO.setSn(signCert.getSerialNumber().toString(16));
        manageCertDO.setPairCertSn(encCert.getSerialNumber().toString(16));
        manageCertDO.setPairCertId(manageCertDO.getId());
        manageCertDO.setType(Constants.SIGN_CERT);
        manageCertDO.setId(Long.valueOf(this.managerCertIdDao.getMaxId(date)));
        manageCertDO = this.managereCertDao.save(manageCertDO);
        signManageCertDataDO.setId(manageCertDO.getId());
        manageCertDataDOList.add(signManageCertDataDO);
        RaServerCertDO raServerCertDO = new RaServerCertDO();
        raServerCertDO.setRaId(issueRaCertVO.getId());
        raServerCertDO.setManageCertId(manageCertDO.getId());
        raServerCertDO.setGmtCreate(signCert.getNotBefore());
        this.raServerCertDao.save(raServerCertDO);
        this.managereCertDao.updatePairCertId(manageCertDO.getPairCertId(), manageCertDO.getId());
        this.managerCertDataDao.batchSave(manageCertDataDOList);
        this.taskDataService.savePublishCert(manageCertDO.getId(), manageCertDO.getPairCertId(), Integer.valueOf(2));
    }

    public void saveRaAdminCert(Long caCertId, X509Certificate signCert, X509Certificate encCert, IssueRaCertVO issueRaCertVO, TemplateInfoVO templateInfoVO) throws Exception {
        ArrayList<ManageCertDataDO> manageCertDataDOList = new ArrayList<ManageCertDataDO>();
        ManageCertDataDO signManageCertDataDO = new ManageCertDataDO();
        ManageCertDataDO encManageCertDataDO = new ManageCertDataDO();
        encManageCertDataDO.setData(CertUtil.writeObject((Object)encCert));
        encManageCertDataDO.setGmtCreate(encCert.getNotBefore());
        signManageCertDataDO.setData(CertUtil.writeObject((Object)signCert));
        signManageCertDataDO.setGmtCreate(signCert.getNotBefore());
        Date date = new Date();
        ManageCertDO manageCertDO = new ManageCertDO();
        manageCertDO.setId(Long.valueOf(this.managerCertIdDao.getMaxId(date)));
        manageCertDO.setCaCertId(caCertId);
        manageCertDO.setSn(encCert.getSerialNumber().toString(16));
        manageCertDO.setIssuer(CertUtil.getIssuerByX509Cert((X509Certificate)encCert));
        manageCertDO.setSubject(CertUtil.getSubjectByX509Cert((X509Certificate)encCert));
        manageCertDO.setPublicKeyAlg(templateInfoVO.getKeyAlg());
        manageCertDO.setPrivateKeySize(templateInfoVO.getKeySize());
        manageCertDO.setBeforeTime(encCert.getNotBefore());
        manageCertDO.setAfterTime(encCert.getNotAfter());
        manageCertDO.setSignAlg(templateInfoVO.getSignAlg());
        manageCertDO.setType(Constants.ENC_CERT);
        manageCertDO.setStatus(Integer.valueOf(1));
        manageCertDO.setTemplateId(templateInfoVO.getId());
        manageCertDO.setPairCertSn(signCert.getSerialNumber().toString(16));
        manageCertDO.setConfirmationStatus(Constants.ISSUE_CERT_NO_ACK);
        manageCertDO.setGmtCreate(encCert.getNotBefore());
        manageCertDO = this.managereCertDao.save(manageCertDO);
        encManageCertDataDO.setId(manageCertDO.getId());
        manageCertDataDOList.add(encManageCertDataDO);
        manageCertDO.setSn(signCert.getSerialNumber().toString(16));
        manageCertDO.setPairCertSn(encCert.getSerialNumber().toString(16));
        manageCertDO.setPairCertId(manageCertDO.getId());
        manageCertDO.setType(Constants.SIGN_CERT);
        manageCertDO.setId(Long.valueOf(this.managerCertIdDao.getMaxId(date)));
        manageCertDO = this.managereCertDao.save(manageCertDO);
        signManageCertDataDO.setId(manageCertDO.getId());
        manageCertDataDOList.add(signManageCertDataDO);
        RaAdminCertDO raAdminCertDO = new RaAdminCertDO();
        raAdminCertDO.setRaId(issueRaCertVO.getId());
        raAdminCertDO.setGmtCreate(signCert.getNotBefore());
        raAdminCertDO.setRoleType(issueRaCertVO.getCertType());
        raAdminCertDO.setManageCertId(manageCertDO.getId());
        this.raAdminCertDao.save(raAdminCertDO);
        this.managereCertDao.updatePairCertId(manageCertDO.getPairCertId(), manageCertDO.getId());
        this.managerCertDataDao.batchSave(manageCertDataDOList);
        this.taskDataService.saveCertConfirmStatus(null, signManageCertDataDO.getId());
    }

    public Result downloadCert(DownloadCertVO req) {
        try {
            StringBuilder auditLog = new StringBuilder();
            String nowTime = DateTimeUtil.dateToStr((Date)new Date(), (String)"yyyyMMddHHmmss");
            CaCertDo caCert = null;
            switch (CertTypeEnum.convert((int)req.getType())) {
                case ADMIN_CERT: 
                case SERVER_CERT: {
                    String typeDesc;
                    Object[] result = this.buildManageCertFile(req);
                    String string = typeDesc = req.getType() == CertTypeEnum.ADMIN_CERT.value ? "\u7ba1\u7406\u5458\u8bc1\u4e66" : "\u670d\u52a1\u5668\u8bc1\u4e66";
                    if (null == result) {
                        this.logger.info("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}\u4e0d\u5b58\u5728[{}]", (Object)typeDesc, (Object)req);
                        auditLog.append("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25\uff0c\u539f\u56e0\uff1a").append(typeDesc).append("\u4e0d\u5b58\u5728\uff0c\u8bc1\u4e66SN=").append(req.getSn());
                        return Result.failure((ErrorEnum)ErrorEnum.DOWNLOAD_CERT_NOT_EXIST).setAuditContent(auditLog.toString());
                    }
                    auditLog.append("\u4e0b\u8f7d\u8bc1\u4e66\u6210\u529f\uff0c\u8bc1\u4e66\u89d2\u8272=").append(typeDesc).append("\uff0c\u8bc1\u4e66DN=").append(result[1]).append("\uff0c\u8bc1\u4e66SN=").append(req.getSn());
                    return Result.success((Object)this.buildCertFileInfo(this.getFileName(nowTime, req), (byte[])result[0])).setAuditContent(auditLog.toString());
                }
                case USER_CERT: {
                    List certs = this.certDataDao.getUserCert(req.getSn(), req.getKeyAlg());
                    if (certs.size() < 3 || StringUtils.isBlank((CharSequence)((CharSequence)certs.get(0))) || StringUtils.isBlank((CharSequence)((CharSequence)certs.get(1))) || StringUtils.isBlank((CharSequence)((CharSequence)certs.get(2))) || certs.size() == 4 && StringUtils.isBlank((CharSequence)((CharSequence)certs.get(3)))) {
                        this.logger.info("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u7528\u6237\u8bc1\u4e66\u4e0d\u5b58\u5728[{}]", (Object)req);
                        auditLog.append("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u7528\u6237\u8bc1\u4e66\u4e0d\u5b58\u5728\uff0c\u8bc1\u4e66SN=").append(req.getSn());
                        return Result.failure((ErrorEnum)ErrorEnum.DOWNLOAD_CERT_NOT_EXIST).setAuditContent(auditLog.toString());
                    }
                    caCert = this.caCertDao.getCaCert(Long.parseLong((String)certs.get(0)));
                    String signCert = this.addCertToCertChain(caCert.getCertChain(), (String)certs.get(2));
                    if (certs.size() == 3) {
                        String fileName = StringUtils.isBlank((CharSequence)req.getFileName()) ? "SignCert_" + nowTime + ".p7b" : req.getFileName();
                        auditLog.append("\u4e0b\u8f7d\u8bc1\u4e66\u6210\u529f\uff0c\u8bc1\u4e66\u89d2\u8272=\u7528\u6237\u8bc1\u4e66\uff0c\u8bc1\u4e66DN=").append((String)certs.get(1)).append("\uff0c\u8bc1\u4e66SN=").append(req.getSn());
                        return Result.success((Object)this.buildCertFileInfo(fileName, signCert.getBytes())).setAuditContent(auditLog.toString());
                    }
                    String encCert = this.addCertToCertChain(caCert.getCertChain(), (String)certs.get(3));
                    byte[] userCertFile = this.buildZipFile(signCert.getBytes(), encCert.getBytes(), false);
                    auditLog.append("\u4e0b\u8f7d\u8bc1\u4e66\u6210\u529f\uff0c\u8bc1\u4e66\u89d2\u8272=\u7528\u6237\u8bc1\u4e66\uff0c\u8bc1\u4e66DN=").append((String)certs.get(1)).append("\uff0c\u8bc1\u4e66SN=").append(req.getSn());
                    return Result.success((Object)this.buildCertFileInfo(this.getFileName(nowTime, req), userCertFile)).setAuditContent(auditLog.toString());
                }
                case CA_CERT: {
                    caCert = this.caCertDao.getCaCert(req.getSn(), req.getKeyAlg());
                    if (null == caCert) {
                        this.logger.info("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25\uff0c\u539f\u56e0\uff1aCA\u8bc1\u4e66\u4e0d\u5b58\u5728[{}]", (Object)req);
                        auditLog.append("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25\uff0c\u539f\u56e0\uff1aCA\u8bc1\u4e66\u4e0d\u5b58\u5728\uff0c\u8bc1\u4e66SN=").append(req.getSn());
                        return Result.failure((ErrorEnum)ErrorEnum.DOWNLOAD_CERT_NOT_EXIST).setAuditContent(auditLog.toString());
                    }
                    CaDO caInfo = this.caDao.getCaById(caCert.getCaId().longValue());
                    String fileName = this.getFileName(nowTime, req);
                    if (caInfo.getType() == CaDO.CaTypeEnum.ROOT_CA.value && StringUtils.isBlank((CharSequence)req.getFileName())) {
                        fileName = "RootCA_" + nowTime + ".p7b";
                    }
                    auditLog.append("\u4e0b\u8f7d\u8bc1\u4e66\u6210\u529f\uff0c\u8bc1\u4e66\u89d2\u8272=CA\u8bc1\u4e66\uff0c\u8bc1\u4e66DN=").append(caCert.getSubject()).append("\uff0c\u8bc1\u4e66SN=").append(req.getSn());
                    return Result.success((Object)this.buildCertFileInfo(fileName, caCert.getCertChain().getBytes())).setAuditContent(auditLog.toString());
                }
                case SUB_CA_CERT: {
                    SubCaCertDO subCaCert = this.subCaCertDao.getSubCaCert(req.getSn(), req.getKeyAlg());
                    if (null == subCaCert) {
                        this.logger.info("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5b50CA\u8bc1\u4e66\u4e0d\u5b58\u5728[{}]", (Object)req);
                        auditLog.append("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5b50CA\u8bc1\u4e66\u4e0d\u5b58\u5728\uff0c\u8bc1\u4e66SN=").append(req.getSn());
                        return Result.failure((ErrorEnum)ErrorEnum.DOWNLOAD_CERT_NOT_EXIST).setAuditContent(auditLog.toString());
                    }
                    caCert = this.caCertDao.getCaCert(subCaCert.getCaCertId().longValue());
                    String subCaCertP7b = this.addCertToCertChain(caCert.getCertChain(), subCaCert.getData());
                    auditLog.append("\u4e0b\u8f7d\u8bc1\u4e66\u6210\u529f\uff0c\u8bc1\u4e66\u89d2\u8272=\u5b50CA\u8bc1\u4e66\uff0c\u8bc1\u4e66DN=").append(subCaCert.getSubject()).append("\uff0c\u8bc1\u4e66SN=").append(req.getSn());
                    return Result.success((Object)this.buildCertFileInfo(this.getFileName(nowTime, req), subCaCertP7b.getBytes())).setAuditContent(auditLog.toString());
                }
                case CROSS_CERT: {
                    CrossCertDO crossCert = this.crossCertDao.getCrossCert(req.getSn(), req.getKeyAlg());
                    if (null == crossCert) {
                        this.logger.info("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4ea4\u53c9\u8bc1\u4e66\u4e0d\u5b58\u5728[{}]", (Object)req);
                        auditLog.append("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4ea4\u53c9\u8bc1\u4e66\u4e0d\u5b58\u5728\uff0c\u8bc1\u4e66SN=").append(req.getSn());
                        return Result.failure((ErrorEnum)ErrorEnum.DOWNLOAD_CERT_NOT_EXIST).setAuditContent(auditLog.toString());
                    }
                    caCert = this.caCertDao.getCaCert(crossCert.getCaCertId().longValue());
                    String crossCertP7b = this.addCertToCertChain(caCert.getCertChain(), crossCert.getData());
                    auditLog.append("\u4e0b\u8f7d\u8bc1\u4e66\u6210\u529f\uff0c\u8bc1\u4e66\u89d2\u8272=\u4ea4\u53c9\u8bc1\u4e66\uff0c\u8bc1\u4e66DN=").append(crossCert.getSubject()).append("\uff0c\u8bc1\u4e66SN=").append(req.getSn());
                    return Result.success((Object)this.buildCertFileInfo(this.getFileName(nowTime, req), crossCertP7b.getBytes())).setAuditContent(auditLog.toString());
                }
                case OUT_CROSS_CERT: {
                    OuterCrossCertDO outerCrossCert = this.outerCrossCertDao.getOuterCrossCert(req.getSn(), req.getKeyAlg());
                    if (null == outerCrossCert) {
                        this.logger.info("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5916\u90e8\u4ea4\u53c9\u8bc1\u4e66\u4e0d\u5b58\u5728[{}]", (Object)req);
                        auditLog.append("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5916\u90e8\u4ea4\u53c9\u8bc1\u4e66\u4e0d\u5b58\u5728\uff0c\u8bc1\u4e66SN=").append(req.getSn());
                        return Result.failure((ErrorEnum)ErrorEnum.DOWNLOAD_CERT_NOT_EXIST).setAuditContent(auditLog.toString());
                    }
                    auditLog.append("\u4e0b\u8f7d\u8bc1\u4e66\u6210\u529f\uff0c\u8bc1\u4e66\u89d2\u8272=\u5916\u90e8\u4ea4\u53c9\u8bc1\u4e66\uff0c\u8bc1\u4e66DN=").append(outerCrossCert.getSubject()).append("\uff0c\u8bc1\u4e66SN=").append(req.getSn());
                    return Result.success((Object)this.buildCertFileInfo(this.getFileName(nowTime, req), outerCrossCert.getCertChain().getBytes())).setAuditContent(auditLog.toString());
                }
            }
            auditLog.append("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u77e5\u8bc1\u4e66\u7c7b\u578b\uff0c\u8bc1\u4e66SN=").append(req.getSn());
            return Result.failure((ErrorEnum)ErrorEnum.DOWNLOAD_CERT_NOT_EXIST).setAuditContent(auditLog.toString());
        }
        catch (Exception e) {
            throw new ServiceException("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public Result getRootCaCertSn(int keyAlg) {
        try {
            Result result = new Result();
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(keyAlg);
            String certSn = caInfoVO.getSn();
            result.setInfo((Object)certSn);
            return result;
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u6839\u8bc1\u4e66SN\u5931\u8d25", (Throwable)e);
        }
    }

    private CertFileInfo buildCertFileInfo(String fileName, byte[] data) {
        CertFileInfo certFile = new CertFileInfo();
        certFile.setFileName(fileName);
        certFile.setData(data);
        return certFile;
    }

    public Object[] buildManageCertFile(DownloadCertVO req) throws Exception {
        List certs = this.managerCertDataDao.getManageCert(req.getSn(), req.getKeyAlg());
        if (certs.size() != 4 || StringUtils.isBlank((CharSequence)((CharSequence)certs.get(0))) || StringUtils.isBlank((CharSequence)((CharSequence)certs.get(1))) || StringUtils.isBlank((CharSequence)((CharSequence)certs.get(2))) || StringUtils.isBlank((CharSequence)((CharSequence)certs.get(3)))) {
            return null;
        }
        CaCertDo caCert = this.caCertDao.getCaCert(Long.valueOf((String)certs.get(0)).longValue());
        String signCertChain = this.addCertToCertChain(caCert.getCertChain(), (String)certs.get(1));
        boolean isPemSuffix = false;
        byte[] encCertChain = null;
        this.logger.info("type=================[{}]", (Object)req.getType());
        if (req.getType() == CertTypeEnum.ADMIN_CERT.value || req.isNotEncData()) {
            encCertChain = this.addCertToCertChain(caCert.getCertChain(), (String)certs.get(2)).getBytes();
        } else {
            SM2EnvelopedData data = EnvelopedDataUtil.getEnvelopedData((X509Certificate)CertUtil.getCertFromStr((String)((String)certs.get(2))));
            encCertChain = Base64.encode((byte[])data.getEncoded("DER"));
            isPemSuffix = true;
        }
        return new Object[]{this.buildZipFile(signCertChain.getBytes(), encCertChain, isPemSuffix), certs.get(3)};
    }

    private byte[] buildZipFile(byte[] signCert, byte[] encCert, boolean isPemSuffix) throws Exception {
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        files.put("SignCert.p7b", signCert);
        String encFileName = isPemSuffix ? "EncCert.pem" : "EncCert.p7b";
        files.put(encFileName, encCert);
        return FileUtils.buildZip(files);
    }

    private String addCertToCertChain(String certChain, String cert) throws Exception {
        List certList = P7bUtils.resolveCertChain((String)certChain);
        certList.add(CertUtil.getCertFromStr((String)cert));
        return P7bUtils.createCertChainByCerts((List)certList);
    }

    public String getFileName(String time, DownloadCertVO req) {
        if (StringUtils.isNotBlank((CharSequence)req.getFileName())) {
            return req.getFileName();
        }
        switch (CertTypeEnum.convert((int)req.getType())) {
            case ADMIN_CERT: {
                return "ManagerCert_" + time + ".zip";
            }
            case SERVER_CERT: {
                return "ServerCert_" + time + ".zip";
            }
            case USER_CERT: {
                return "UserCert_" + time + ".zip";
            }
            case CA_CERT: {
                return "SubCA_" + time + ".p7b";
            }
            case SUB_CA_CERT: {
                return "SubCA_" + time + ".p7b";
            }
            case CROSS_CERT: {
                return "CrossCA_" + time + ".p7b";
            }
            case OUT_CROSS_CERT: {
                return "CrossCA_" + time + ".p7b";
            }
        }
        return "unknown";
    }

    public Result getCertUpdateBaseInfo(String signSn, String alg) {
        try {
            CertUpdateBaseInfoVO certUpdateBaseInfoVO = new CertUpdateBaseInfoVO();
            CertUpdateBaseInfoDO certUpdateBaseInfoDO = this.managereCertDao.getCertUpdateBaseInfo(signSn, alg);
            if (null == certUpdateBaseInfoDO) {
                return Result.success((Object)certUpdateBaseInfoVO);
            }
            Date nowDate = new Date();
            if (certUpdateBaseInfoDO.getAfterTime().before(nowDate)) {
                this.logger.info("\u83b7\u53d6\u8bc1\u4e66\u66f4\u65b0\u57fa\u672c\u4fe1\u606f\u5931\u8d25\uff0c\u8bc1\u4e66\u8fc7\u671fsignSn=[{}]", (Object)signSn);
                return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED);
            }
            BeanUtils.copyProperties((Object)certUpdateBaseInfoDO, (Object)certUpdateBaseInfoVO);
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(certUpdateBaseInfoDO.getKeyAlg());
            if (null != caInfoVO && StringUtils.isNotBlank((CharSequence)caInfoVO.getBaseDn()) && null != certUpdateBaseInfoDO && null != caInfoVO.getRootCert()) {
                certUpdateBaseInfoVO.setBaseDn(caInfoVO.getBaseDn());
                certUpdateBaseInfoVO.setSignAlgStr(SignAlgTypeEnum.getViewAlgName((int)Integer.valueOf(certUpdateBaseInfoVO.getSignAlg())));
                certUpdateBaseInfoVO.setKeyAlgStr(AlgTypeEnum.getAlgStr((int)certUpdateBaseInfoVO.getKeyAlg()));
                Long nowTime = nowDate.getTime();
                Long remainingTime = IssueTimeUtil.getCertRemainTime((Date)certUpdateBaseInfoVO.getAfterTime(), (Long)nowTime);
                certUpdateBaseInfoVO.setRemainingTime(remainingTime);
                X509Certificate rootCert = caInfoVO.getRootCert();
                Long maxTime = IssueTimeUtil.getCertUpdateMaxValidity((Date)rootCert.getNotAfter(), (Long)certUpdateBaseInfoVO.getMaxValidity(), (Date)certUpdateBaseInfoVO.getAfterTime(), (Long)nowTime);
                certUpdateBaseInfoVO.setMaxValidity(maxTime);
            }
            this.logger.info("\u83b7\u53d6\u8bc1\u4e66\u66f4\u65b0\u65f6\u57fa\u672c\u4fe1\u606f[{}]", (Object)certUpdateBaseInfoVO);
            return Result.success((Object)certUpdateBaseInfoVO);
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u8bc1\u4e66\u66f4\u65b0\u65f6\u7684\u57fa\u672c\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public Result deleteNotAckManagerCert(RevokeCertVO revokeCertVO) {
        try {
            Result result;
            int n;
            ManageCertDO managerCertSign = this.managereCertDao.getManagerCertsBySnNotAck(revokeCertVO.getSn(), Constants.BASE_ALG_TYPE.intValue());
            if (null != managerCertSign && 2 == (n = this.raAdminCertDao.updatePriCertStatus(managerCertSign.getSn(), managerCertSign.getPairCertSn())) && (result = this.deleteRaManagerCert(revokeCertVO)).isSuccess()) {
                this.taskDataService.savePublishCert(managerCertSign.getId(), managerCertSign.getPairCertId(), Integer.valueOf(2));
                this.taskDataService.deleteNoConfirmCertSync(null, managerCertSign.getId());
                return result;
            }
            return Result.failure((ErrorEnum)ErrorEnum.WRITE_CARD_ACK_TIME_OUT);
        }
        catch (Exception e) {
            throw new ServiceException("\u4e0a\u62a5\u5199\u5361\u5931\u8d25\u8bc1\u4e66\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result getCertDetail(String sn, Integer type) {
        Integer keyAlg = Constants.BASE_ALG_TYPE;
        switch (CertTypeEnum.convert((int)type)) {
            case ADMIN_CERT: 
            case SERVER_CERT: {
                return this.certDetailQueryHandle.getManangeCertDetail(sn, keyAlg);
            }
            case USER_CERT: {
                return this.certDetailQueryHandle.getUserCertDetail(sn, keyAlg);
            }
            case CA_CERT: {
                return this.certDetailQueryHandle.getCaCertDetail(sn, keyAlg);
            }
            case SUB_CA_CERT: {
                return this.certDetailQueryHandle.getSubCaCertDetail(sn, keyAlg);
            }
            case CROSS_CERT: {
                return this.certDetailQueryHandle.getCrossCertDetail(sn, keyAlg);
            }
            case OUT_CROSS_CERT: {
                return this.certDetailQueryHandle.getOutCrossCertDetail(sn, keyAlg);
            }
        }
        return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
    }

    public Result getRACertList(RACertQueryVO raCertQueryCnd) {
        Pager pager = new Pager(raCertQueryCnd.getPageNo(), raCertQueryCnd.getPageSize());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("name", raCertQueryCnd.getName());
        param.put("certDN", raCertQueryCnd.getCertDN());
        param.put("certType", raCertQueryCnd.getCertType());
        param.put("status", raCertQueryCnd.getStatus());
        PageInfo pageInfo = null;
        ArrayList<RACertListVO> raCertList = new ArrayList<RACertListVO>();
        try {
            pageInfo = this.raAdminCertDao.getRACertLists(param, pager);
            Collection datas = pageInfo.getDatas();
            if (!datas.isEmpty()) {
                for (Object item : datas) {
                    Map dataMap = (Map)item;
                    RACertListVO raCertListVO = new RACertListVO();
                    Integer status = Integer.valueOf(String.valueOf(dataMap.get("status")));
                    raCertListVO.setId((Long)dataMap.get("id"));
                    raCertListVO.setName((String)dataMap.get("name"));
                    raCertListVO.setCertDn((String)dataMap.get("subject"));
                    raCertListVO.setSignSn((String)dataMap.get("sn"));
                    raCertListVO.setEncSn((String)dataMap.get("pair_cert_sn"));
                    raCertListVO.setStatus(status);
                    raCertListVO.setStatusStr(this.dicDataConverUtil.ConverStatusToStr(status));
                    raCertListVO.setCertType(Integer.valueOf(((Long)dataMap.get("role_type")).intValue()));
                    raCertListVO.setCertTypeStr(this.ConverCertTypeToStr(((Long)dataMap.get("role_type")).intValue()));
                    raCertListVO.setNotBeforeTime(DateTimeUtil.dateToWebStr((Date)((Date)dataMap.get("before_time"))));
                    raCertListVO.setNotAfterTime(DateTimeUtil.dateToWebStr((Date)((Date)dataMap.get("after_time"))));
                    raCertList.add(raCertListVO);
                }
                pageInfo.setDatas(raCertList);
            }
        }
        catch (DAOException e) {
            this.logger.error("\u67e5\u8be2RA\u5217\u8868\u5f02\u5e38\uff0c");
            throw new ServiceException("\u67e5\u8be2RA\u5217\u8868\u670d\u52a1\u5f02\u5e38,", (Throwable)e);
        }
        return Result.success((Object)pageInfo);
    }

    private String ConverCertTypeToStr(Integer certType) {
        return RACertTypeEnum.convert((int)certType.intValue()).desc;
    }
}

