/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.subca;

import com.xdja.pki.ca.certmanager.dao.SubCaCertDao;
import com.xdja.pki.ca.certmanager.dao.SubCaManageDao;
import com.xdja.pki.ca.certmanager.dao.models.SubCaCertDO;
import com.xdja.pki.ca.certmanager.dao.models.SubCaDO;
import com.xdja.pki.ca.certmanager.service.crltemplate.CrlTemplateService;
import com.xdja.pki.ca.certmanager.service.ra.bean.UniqueReq;
import com.xdja.pki.ca.certmanager.service.subca.ISubCaManageService;
import com.xdja.pki.ca.certmanager.service.subca.bean.InnerTemplateVO;
import com.xdja.pki.ca.certmanager.service.subca.bean.IssueSubCaCertVO;
import com.xdja.pki.ca.certmanager.service.subca.bean.SubCaCertQueryVO;
import com.xdja.pki.ca.certmanager.service.subca.bean.SubCaCertTypeEnum;
import com.xdja.pki.ca.certmanager.service.subca.bean.SubCaCertVO;
import com.xdja.pki.ca.certmanager.service.subca.bean.SubCaInfoVO;
import com.xdja.pki.ca.certmanager.service.subca.bean.SubCaManageQueryVO;
import com.xdja.pki.ca.certmanager.service.task.TaskDataService;
import com.xdja.pki.ca.certmanager.service.template.TemplateService;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateInfoVO;
import com.xdja.pki.ca.certmanager.service.util.DicDataConverUtil;
import com.xdja.pki.ca.certmanager.service.util.ExtensionUtil;
import com.xdja.pki.ca.certmanager.service.util.TemplateParamsUtil;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.enums.KeyAlgEnum;
import com.xdja.pki.ca.core.enums.TemplateStatusEnum;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.DnUtil;
import com.xdja.pki.ca.core.util.time.DateTimeUtil;
import com.xdja.pki.ca.core.util.time.IssueTimeUtil;
import com.xdja.pki.ca.core.util.verify.ParmsCommonVerifyUtil;
import com.xdja.pki.ca.hsm.manager.HsmManager;
import com.xdja.pki.ca.ldap.service.vo.LdapOcspUrlVO;
import com.xdja.pki.ca.securitymanager.dao.CertSnDao;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.ExtensionVO;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.nutz.dao.pager.Pager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubCaManageServiceImpl
implements ISubCaManageService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private SubCaManageDao subCaManageDao;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private DicDataConverUtil dicDataConverUtil;
    @Autowired
    private CrlTemplateService crlTemplateService;
    @Autowired
    private TaskDataService taskDataService;
    @Autowired
    private CertSnDao certSnDao;
    @Autowired
    private HsmManager hsmService;
    @Autowired
    private SubCaCertDao subCaCertDao;

    public Result getSubCaManageList(SubCaManageQueryVO subCaManageQueryVO) {
        Pager pager = new Pager(subCaManageQueryVO.getPageNo(), subCaManageQueryVO.getPageSize());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("name", subCaManageQueryVO.getName());
        PageInfo pageInfo = null;
        try {
            pageInfo = this.subCaManageDao.getSubCaManageList(param, pager);
            Collection datas = pageInfo.getDatas();
            if (!datas.isEmpty()) {
                ArrayList<SubCaInfoVO> subCaInfoVOList = new ArrayList<SubCaInfoVO>();
                for (Object item : datas) {
                    SubCaDO subCaDO = (SubCaDO)item;
                    SubCaInfoVO subCaInfoVO = new SubCaInfoVO();
                    subCaInfoVO.setId(subCaDO.getId());
                    subCaInfoVO.setName(subCaDO.getName());
                    subCaInfoVO.setOrgName(subCaDO.getOrganizationName());
                    subCaInfoVO.setContacts(subCaDO.getLinkMain());
                    subCaInfoVO.setEmail(subCaDO.getEmail());
                    subCaInfoVO.setMobile(subCaDO.getMobile());
                    subCaInfoVO.setRegisterTime(DateTimeUtil.dateToWebStr((Date)subCaDO.getGmtCreate()));
                    subCaInfoVOList.add(subCaInfoVO);
                }
                pageInfo.setDatas(subCaInfoVOList);
            }
        }
        catch (DAOException e) {
            this.logger.error("\u67e5\u8be2CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5217\u8868\u5f02\u5e38");
            throw new ServiceException("\u67e5\u8be2CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
        }
        return Result.success((Object)pageInfo);
    }

    public Result saveSubCaInfo(SubCaInfoVO subCaInfoVO) {
        boolean verifyResult = this.subCaParamVerify(subCaInfoVO);
        if (!verifyResult) {
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        SubCaDO subCaDO = new SubCaDO();
        BeanUtils.copyProperties((Object)subCaInfoVO, (Object)subCaDO);
        subCaDO.setLinkMain(subCaInfoVO.getContacts());
        subCaDO.setOrganizationName(subCaInfoVO.getOrgName());
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
        subCaDO.setCaId(caInfoVO.getCaId());
        subCaDO.setGmtCreate(new Date(System.currentTimeMillis()));
        try {
            this.subCaManageDao.saveSubCa(subCaDO);
        }
        catch (DAOException e) {
            throw new ServiceException("\u4fdd\u5b58\u4e0b\u7ea7CA\u673a\u6784\u4fe1\u606f\u5f02\u5e38\uff0c", (Throwable)e);
        }
        return Result.success();
    }

    public Result updateSubCaInfo(SubCaInfoVO subCaInfoVO) {
        boolean verifyResult = this.subCaParamVerify(subCaInfoVO);
        if (!verifyResult) {
            return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        SubCaDO subCaDO = new SubCaDO();
        BeanUtils.copyProperties((Object)subCaInfoVO, (Object)subCaDO);
        subCaDO.setLinkMain(subCaInfoVO.getContacts());
        subCaDO.setOrganizationName(subCaInfoVO.getOrgName());
        subCaDO.setGmtModified(new Date(System.currentTimeMillis()));
        try {
            this.subCaManageDao.updateSubCa(subCaDO);
        }
        catch (DAOException e) {
            throw new ServiceException("\u4fdd\u5b58\u4e0b\u7ea7CA\u673a\u6784\u4fe1\u606f\u5f02\u5e38\uff0c", (Throwable)e);
        }
        return Result.success();
    }

    public Result getSubCaInfo(Long id) {
        SubCaDO subCa = null;
        try {
            subCa = this.subCaManageDao.getSubCa(id.longValue());
        }
        catch (DAOException e) {
            throw new ServiceException("\u67e5\u8be2\u4e0b\u7ea7CA\u8be6\u60c5\u670d\u52a1\u5931\u8d25,", (Throwable)e);
        }
        SubCaInfoVO subCaInfoVO = null;
        if (subCa == null) {
            return Result.failure((ErrorEnum)ErrorEnum.SUBCA_INFO_NOT_EXIST);
        }
        subCaInfoVO = new SubCaInfoVO();
        BeanUtils.copyProperties((Object)subCa, (Object)subCaInfoVO);
        subCaInfoVO.setContacts(subCa.getLinkMain());
        subCaInfoVO.setOrgName(subCa.getOrganizationName());
        subCaInfoVO.setRegisterTime(DateTimeUtil.dateToWebStr((Date)subCa.getGmtCreate()));
        return Result.success((Object)subCaInfoVO);
    }

    private boolean subCaParamVerify(SubCaInfoVO subCaInfoVO) {
        String mobile = subCaInfoVO.getMobile();
        String email = subCaInfoVO.getEmail();
        boolean isMobile = ParmsCommonVerifyUtil.isMobile((String)mobile);
        if (!isMobile) {
            this.logger.error("\u7535\u8bdd\u683c\u5f0f\u9519\u8bef\uff01mobile=\u3010{}\u3011", (Object)mobile);
            return false;
        }
        boolean isEmail = ParmsCommonVerifyUtil.isEmail((String)email);
        if (!isEmail) {
            this.logger.error("\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef\uff01email=\u3010{}\u3011", (Object)email);
            return false;
        }
        return true;
    }

    public Result getTemplateInfo(String code) {
        Map templateByCodesMap = null;
        try {
            templateByCodesMap = this.templateService.getTemplatesByCodes(new String[]{code});
        }
        catch (ServiceException e) {
            this.logger.error("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u5f02\u5e38");
            throw e;
        }
        TemplateInfoVO templateInfoVO = (TemplateInfoVO)templateByCodesMap.get(code);
        if (null != templateInfoVO) {
            InnerTemplateVO innerTemplateVO = new InnerTemplateVO();
            BeanUtils.copyProperties((Object)templateInfoVO, (Object)innerTemplateVO);
            innerTemplateVO.setKeyAlgStr(templateInfoVO.getKeyAlg() == KeyAlgEnum.RSA.value ? KeyAlgEnum.RSA.name() : KeyAlgEnum.SM2.name());
            String signAlgStr = this.dicDataConverUtil.coneverSingAlgToStr(innerTemplateVO.getSignAlg());
            innerTemplateVO.setSignAlgStr(signAlgStr);
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(templateInfoVO.getKeyAlg());
            if (null == caInfoVO.getRootCert()) {
                innerTemplateVO.setMaxValidity(templateInfoVO.getMaxValidity());
            } else {
                innerTemplateVO.setMaxValidity(IssueTimeUtil.getMaxIssueTime((Integer)templateInfoVO.getMaxValidity(), (Date)caInfoVO.getRootCert().getNotAfter()));
            }
            List extensions = templateInfoVO.getExtensions();
            ArrayList temParas = new ArrayList();
            if (null != extensions && !extensions.isEmpty()) {
                for (ExtensionVO extension : extensions) {
                    HashMap<String, String> extPara = new HashMap<String, String>();
                    if (extension.getIsInput() == 1) {
                        extPara.put("attrName", extension.getName());
                        extPara.put("attrOid", extension.getExtnId());
                        extPara.put("attrType", extension.getValue() == null ? "" : extension.getValue());
                        extPara.put("attrValue", "");
                    }
                    if (extPara.isEmpty()) continue;
                    temParas.add(extPara);
                }
            }
            innerTemplateVO.setTemParas(temParas);
            return Result.success((Object)innerTemplateVO);
        }
        return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
    }

    public Result doIssueSubCaCert(IssueSubCaCertVO issueSubCaCertVO) {
        String tempCode = issueSubCaCertVO.getTempCode();
        Map templateByCodesMap = null;
        try {
            templateByCodesMap = this.templateService.getTemplatesByCodes(new String[]{tempCode});
        }
        catch (ServiceException e) {
            this.logger.error("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u5f02\u5e38");
            throw e;
        }
        TemplateInfoVO templateInfoVO = (TemplateInfoVO)templateByCodesMap.get(tempCode);
        if (null == templateInfoVO) {
            this.logger.debug("\u7b7e\u53d1\u4e0b\u7ea7CA\u8bc1\u4e66\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728");
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
        }
        if (TemplateStatusEnum.NORMAL.value != templateInfoVO.getStatus()) {
            this.logger.info("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u7ed3\u679c\uff1a\u6a21\u677f\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u6a21\u677f\u72b6\u6001\u4e3a[{}]", (Object)templateInfoVO.getStatus());
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
        }
        Result result = TemplateParamsUtil.validity((TemplateInfoVO)templateInfoVO, (String)issueSubCaCertVO.getTempParas());
        if (!result.isSuccess()) {
            this.logger.info("\u7b7e\u53d1\u4e0b\u7ea7CA\u8bc1\u4e66\u5931\u8d25\uff1a\u7f3a\u5c11\u6a21\u677f\u9700\u8981\u53c2\u6570");
            return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(templateInfoVO.getKeyAlg());
        if (null == caInfoVO || StringUtils.isBlank((CharSequence)caInfoVO.getBaseDn()) || null == caInfoVO.getRootCert()) {
            this.logger.debug("\u7b7e\u53d1\u4e0b\u7ea7CA\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u5230CA\u57fa\u672c\u4fe1\u606f[{}]", (Object)issueSubCaCertVO);
            return Result.failure((ErrorEnum)ErrorEnum.CA_BASEINFO_GET_FAIL);
        }
        if (caInfoVO.getRootCert().getNotAfter().before(new Date())) {
            this.logger.debug("\u7b7e\u53d1\u4e0b\u7ea7CA\u8bc1\u4e66\u5931\u8d25\uff1aCA\u6839\u8bc1\u4e66\u5df2\u8fc7\u671f[{}]", (Object)issueSubCaCertVO);
            return Result.failure((ErrorEnum)ErrorEnum.CA_ROOT_CERT_EXPIRED);
        }
        X509Certificate rootCert = caInfoVO.getRootCert();
        int basicConstraintsLength = rootCert.getBasicConstraints();
        if (basicConstraintsLength <= 0) {
            this.logger.debug("\u672cCA\u65e0\u6743\u7b7e\u53d1\u4e0b\u7ea7CA");
            return Result.failure((ErrorEnum)ErrorEnum.NOPERMISSION_SIGN_SUBCA);
        }
        try {
            X500Name x500Name = DnUtil.getRFC4519X500Name((String)issueSubCaCertVO.getCertDn());
            this.logger.debug("\u6536\u5230\u5b50CA\u8bc1\u4e66\u8bf7\u6c42\uff1a" + x500Name.toString());
            issueSubCaCertVO.setCertDn(x500Name.toString());
        }
        catch (Exception e) {
            this.logger.debug("\u7b7e\u53d1\u4e0b\u7ea7CA\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e0d\u7b26\u5408X500\u89c4\u8303[{}]", (Object)issueSubCaCertVO);
            return Result.failure((ErrorEnum)ErrorEnum.DN_FORMAT_FAIL);
        }
        PublicKey signPublicKey = CertUtil.getPublicKeyFromP10((String)issueSubCaCertVO.getP10());
        if (null == signPublicKey) {
            this.logger.debug("\u7b7e\u53d1\u4e0b\u7ea7CA\u8bc1\u4e66\u5931\u8d25\uff1ap10\u683c\u5f0f\u4e0d\u6b63\u786e[{}]", (Object)issueSubCaCertVO);
            return Result.failure((ErrorEnum)ErrorEnum.P10_FORMAT_ERROR);
        }
        try {
            Date nowTime = new Date();
            Date endTime = IssueTimeUtil.getCorrectTime((Long)issueSubCaCertVO.getValidity(), (Integer)templateInfoVO.getMaxValidity(), (Date)rootCert.getNotAfter(), (Date)nowTime);
            BigInteger signSn = this.certSnDao.getMaxSn(nowTime);
            LdapOcspUrlVO signLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(signSn, issueSubCaCertVO.getCertDn(), caInfoVO, true, null, null);
            List extensionVOs = templateInfoVO.getExtensions();
            List signExtensions = ExtensionUtil.changeExtensionFormat((List)extensionVOs, (Map)((Map)result.getInfo()), (PublicKey)signPublicKey, (String)issueSubCaCertVO.getCertDn(), (LdapOcspUrlVO)signLdapOcspUrlVO, (boolean)true);
            X509Certificate signCert = this.hsmService.genX509Certificate(issueSubCaCertVO.getCertDn(), signSn, nowTime, endTime, caInfoVO, signPublicKey, signExtensions, templateInfoVO.getSignAlg());
            try {
                SubCaCertDO subCaCertDO = this.saveSubCaCert(caInfoVO.getCertId(), signCert, issueSubCaCertVO, templateInfoVO);
                this.taskDataService.savePublishCert(subCaCertDO.getId(), null, Integer.valueOf(6));
            }
            catch (DAOException e) {
                throw new ServiceException("\u4fdd\u5b58\u4e0b\u7ea7CA\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25\uff0c", (Throwable)e);
            }
            this.logger.info("\u7b7e\u53d1\u4e0b\u7ea7CA\u8bc1\u4e66\u6210\u529f\uff1adn= " + issueSubCaCertVO.getCertDn() + ",signCert=" + CertUtil.writeObject((Object)signCert));
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("certName", "SubCA_" + DateTimeUtil.dateToZipStr((Date)nowTime) + ".p7b");
            resultMap.put("sn", signSn.toString(16));
            resultMap.put("keyAlg", templateInfoVO.getKeyAlg());
            return Result.success(resultMap, (String)signSn.toString(16));
        }
        catch (Exception e) {
            throw new ServiceException("\u7b7e\u53d1\u4e0b\u7ea7CA\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    private SubCaCertDO saveSubCaCert(Long caCertId, X509Certificate signCert, IssueSubCaCertVO issueSubCaCertVO, TemplateInfoVO templateInfoVO) throws Exception {
        SubCaCertDO subCaCertDO = new SubCaCertDO();
        subCaCertDO.setCaCertId(caCertId);
        subCaCertDO.setSubCaId(issueSubCaCertVO.getId());
        subCaCertDO.setSn(signCert.getSerialNumber().toString(16));
        subCaCertDO.setIssuer(CertUtil.getIssuerByX509Cert((X509Certificate)signCert));
        subCaCertDO.setSubject(CertUtil.getSubjectByX509Cert((X509Certificate)signCert));
        subCaCertDO.setPrivateKeySize(templateInfoVO.getKeySize());
        subCaCertDO.setPublicKeyAlg(templateInfoVO.getKeyAlg());
        subCaCertDO.setBeforeTime(signCert.getNotBefore());
        subCaCertDO.setAfterTime(signCert.getNotAfter());
        subCaCertDO.setSignAlg(templateInfoVO.getSignAlg());
        subCaCertDO.setStatus(Integer.valueOf(1));
        subCaCertDO.setTemplateId(templateInfoVO.getId());
        subCaCertDO.setGmtCreate(signCert.getNotBefore());
        subCaCertDO.setData(CertUtil.writeObject((Object)signCert));
        return this.subCaCertDao.save(subCaCertDO);
    }

    public Result getSubCaCertList(SubCaCertQueryVO subCaCertQueryVO) {
        Pager pager = new Pager(subCaCertQueryVO.getPageNo(), subCaCertQueryVO.getPageSize());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("certDn", subCaCertQueryVO.getCertDn());
        Integer status = subCaCertQueryVO.getStatus();
        if (3 == status) {
            status = SubCaCertTypeEnum.SUBCACERT_STATUS_REVOKED.value;
        }
        param.put("status", status);
        PageInfo pageInfo = null;
        try {
            pageInfo = this.subCaCertDao.getSubCaCertList(param, pager);
            Collection datas = pageInfo.getDatas();
            if (!datas.isEmpty()) {
                ArrayList<SubCaCertVO> subCaInfoVOList = new ArrayList<SubCaCertVO>();
                for (Object item : datas) {
                    SubCaCertDO subCertCaDO = (SubCaCertDO)item;
                    SubCaCertVO subCertCaInfoVO = new SubCaCertVO();
                    this.handleSubCaCertDO(subCertCaDO);
                    Integer certStatus = subCertCaDO.getStatus();
                    subCertCaInfoVO.setStatus(certStatus);
                    subCertCaInfoVO.setStatusStr(this.dicDataConverUtil.ConverStatusToStr(certStatus));
                    SubCaDO subCa = this.subCaManageDao.getSubCa(subCertCaDO.getSubCaId().longValue());
                    subCertCaInfoVO.setName(subCa.getName());
                    subCertCaInfoVO.setCertDn(subCertCaDO.getSubject());
                    subCertCaInfoVO.setSn(subCertCaDO.getSn());
                    subCertCaInfoVO.setNotBeforeTime(DateTimeUtil.dateToWebStr((Date)subCertCaDO.getBeforeTime()));
                    subCertCaInfoVO.setNotAfterTime(DateTimeUtil.dateToWebStr((Date)subCertCaDO.getAfterTime()));
                    subCaInfoVOList.add(subCertCaInfoVO);
                }
                pageInfo.setDatas(subCaInfoVOList);
            }
        }
        catch (DAOException e) {
            this.logger.error("\u67e5\u8be2\u4e0b\u7ea7CA\u8bc1\u4e66\u5217\u8868\u5f02\u5e38");
            throw new ServiceException("\u67e5\u8be2\u4e0b\u7ea7CA\u8bc1\u4e66\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
        }
        return Result.success((Object)pageInfo);
    }

    public Result verifyCaName(String caName, Integer id) {
        try {
            int size = this.subCaManageDao.getCaNameUnique(caName, id);
            UniqueReq uniqueReq = new UniqueReq();
            if (size == 0) {
                uniqueReq.setUnique(true);
            }
            return Result.success((Object)uniqueReq);
        }
        catch (DAOException e) {
            this.logger.error("\u6821\u9a8ccaName\u552f\u4e00\u6027\u5931\u8d25");
            throw new ServiceException("\u6821\u9a8ccaName\u552f\u4e00\u6027\u5931\u8d25,", (Throwable)e);
        }
    }

    private void handleSubCaCertDO(SubCaCertDO subCertCaDO) {
        if (SubCaCertTypeEnum.SUBCACERT_STATUS_REVOKED.value == subCertCaDO.getStatus()) {
            subCertCaDO.setStatus(Integer.valueOf(3));
        }
        if (subCertCaDO.getAfterTime().before(new Date())) {
            subCertCaDO.setStatus(Integer.valueOf(4));
        }
    }
}

