/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.subsystem;

import com.xdja.pki.ca.certmanager.dao.CaSubServerCertDao;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDataDao;
import com.xdja.pki.ca.certmanager.dao.SubSystemDao;
import com.xdja.pki.ca.certmanager.dao.models.CaSubServerCertDO;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDataDO;
import com.xdja.pki.ca.certmanager.dao.models.SubSystemListDO;
import com.xdja.pki.ca.certmanager.dao.models.SubSystemQueryDO;
import com.xdja.pki.ca.certmanager.service.crltemplate.CrlTemplateService;
import com.xdja.pki.ca.certmanager.service.racert.RaManagerCertService;
import com.xdja.pki.ca.certmanager.service.racert.bean.DeviceTypeToTemplateTypeEnum;
import com.xdja.pki.ca.certmanager.service.subsystem.SubSystemService;
import com.xdja.pki.ca.certmanager.service.subsystem.bean.SubSystemCertVO;
import com.xdja.pki.ca.certmanager.service.subsystem.bean.SubSystemListVO;
import com.xdja.pki.ca.certmanager.service.subsystem.bean.SubSystemVO;
import com.xdja.pki.ca.certmanager.service.task.TaskDataService;
import com.xdja.pki.ca.certmanager.service.template.TemplateService;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateInfoVO;
import com.xdja.pki.ca.certmanager.service.util.ExtensionUtil;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.enums.DeviceTypeEnum;
import com.xdja.pki.ca.core.enums.TemplateStatusEnum;
import com.xdja.pki.ca.core.enums.TemplateTypeEnum;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.pkcs7.EnvelopedDataUtil;
import com.xdja.pki.ca.core.pkcs7.SM2EnvelopedData;
import com.xdja.pki.ca.core.util.DnUtil;
import com.xdja.pki.ca.core.util.time.DateTimeUtil;
import com.xdja.pki.ca.core.util.time.IssueTimeUtil;
import com.xdja.pki.ca.extension.util.ExtensionAttr;
import com.xdja.pki.ca.hsm.manager.HsmManager;
import com.xdja.pki.ca.ldap.service.vo.LdapOcspUrlVO;
import com.xdja.pki.ca.securitymanager.dao.CertSnDao;
import com.xdja.pki.ca.securitymanager.dao.DicDao;
import com.xdja.pki.ca.securitymanager.dao.ManagerCertIdDao;
import com.xdja.pki.ca.securitymanager.service.vo.AlgTypeEnum;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.InitAlgInfoVO;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubSystemServiceImpl
implements SubSystemService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SubSystemDao subSystemDao;
    @Autowired
    private DicDao dicDao;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private ManagerCertDao managereCertDao;
    @Autowired
    private CaSubServerCertDao caSubServerCertDao;
    @Autowired
    private ManagerCertDataDao managerCertDataDao;
    @Autowired
    private HsmManager hsmService;
    @Autowired
    private CrlTemplateService crlTemplateService;
    @Autowired
    private TaskDataService taskDataService;
    @Autowired
    private CertSnDao certSnDao;
    @Autowired
    private ManagerCertIdDao managerCertIdDao;
    @Autowired
    private RaManagerCertService raManagerCertService;

    public Object getSubSystemList(SubSystemVO subSystemVO) {
        SubSystemQueryDO subSystemQueryDO = new SubSystemQueryDO();
        BeanUtils.copyProperties((Object)subSystemVO, (Object)subSystemQueryDO);
        PageInfo pageInfo = this.subSystemDao.querySubSystemList(subSystemQueryDO);
        try {
            if (!pageInfo.getDatas().isEmpty()) {
                SubSystemListVO subSystemListVO = null;
                Map deviceTypeDics = this.dicDao.getDicsByParentCode("deviceType");
                Map certStatusDics = this.dicDao.getDicsByParentCode("certStatus");
                ArrayList<SubSystemListVO> subSystemListVOList = new ArrayList<SubSystemListVO>();
                List dataList = (List)pageInfo.getDatas();
                for (int i = 0; i < pageInfo.getDatas().size(); ++i) {
                    SubSystemListDO item = (SubSystemListDO)dataList.get(i);
                    int status = null == subSystemVO.getStatus() ? 1 : subSystemVO.getStatus();
                    item.setStatus(Integer.valueOf(status));
                    subSystemListVO = new SubSystemListVO();
                    BeanUtils.copyProperties((Object)item, (Object)subSystemListVO);
                    subSystemListVO.setDeviceTypeStr((String)deviceTypeDics.get(String.valueOf(item.getDeviceType())));
                    subSystemListVO.setStatusStr((String)certStatusDics.get(String.valueOf(item.getStatus())));
                    subSystemListVO.setNotBeforeTime(DateTimeUtil.dateToWebStr((Date)item.getNotBefore()));
                    subSystemListVO.setNotAfterTime(DateTimeUtil.dateToWebStr((Date)item.getNotAfter()));
                    subSystemListVOList.add(subSystemListVO);
                }
                pageInfo.setDatas(subSystemListVOList);
            }
            return pageInfo;
        }
        catch (Exception e) {
            throw new DAOException("\u5206\u9875\u67e5\u8be2CA\u5b50\u7cfb\u7edf\u5217\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public Object doIssueSubSystemCert(SubSystemCertVO subSystemCertVO) {
        CaInfoVO caInfoVO;
        TemplateInfoVO templateInfoVO = this.templateService.getInnerTemplateByType(DeviceTypeToTemplateTypeEnum.getTemplateTypeByDeviceType((int)subSystemCertVO.getDeviceType()));
        Result result = this.checkIssueCertParams(templateInfoVO, caInfoVO = (CaInfoVO)Constants.CA_INFO.get(templateInfoVO.getKeyAlg()), subSystemCertVO.getDn());
        if (!result.isSuccess()) {
            return result;
        }
        PublicKey signPublicKey = CertUtil.getPublicKeyFromP10((String)subSystemCertVO.getP10());
        if (null == signPublicKey) {
            this.logger.debug("p10\u683c\u5f0f\u9519\u8bef\uff0c\u83b7\u53d6\u516c\u94a5\u5931\u8d25[{}]", (Object)subSystemCertVO.getP10());
            return Result.failure((ErrorEnum)ErrorEnum.P10_FORMAT_ERROR);
        }
        PublicKey encPublicKey = null;
        try {
            encPublicKey = subSystemCertVO.getDeviceType() != DeviceTypeEnum.KM_MANAGER.value ? CertUtil.getPublicKeyBySubjectKeyInfo((Integer)Constants.BASE_ALG_TYPE, (String)subSystemCertVO.getSubjectPublicKeyInfo()) : CertUtil.convertPublicKey((PublicKey)signPublicKey, (String)subSystemCertVO.getSubjectPublicKeyInfo());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug("\u52a0\u5bc6\u516c\u94a5\u683c\u5f0f\u9519\u8bef:[{}]", (Object)subSystemCertVO.getSubjectPublicKeyInfo());
            return Result.failure((ErrorEnum)ErrorEnum.PEM_FORMAT_ERROR);
        }
        HashMap<String, ExtensionAttr> params = null;
        if (null != subSystemCertVO.getSubjectAlternativeName()) {
            params = new HashMap<String, ExtensionAttr>();
            params.put(Extension.subjectAlternativeName.getId(), subSystemCertVO.getSubjectAlternativeName());
        }
        try {
            Date nowTime = new Date();
            X509Certificate rootCert = caInfoVO.getRootCert();
            Date endTime = IssueTimeUtil.getCorrectTime((Long)subSystemCertVO.getMaxValidity(), (Integer)templateInfoVO.getMaxValidity(), (Date)rootCert.getNotAfter(), (Date)nowTime);
            BigInteger encSn = this.certSnDao.getMaxSn(nowTime);
            LdapOcspUrlVO encLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(encSn, subSystemCertVO.getDn(), caInfoVO, false, null, null);
            List encExtensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), params, (PublicKey)encPublicKey, (String)subSystemCertVO.getDn(), (LdapOcspUrlVO)encLdapOcspUrlVO, (boolean)false);
            X509Certificate encCert = this.hsmService.genX509Certificate(subSystemCertVO.getDn(), encSn, nowTime, endTime, caInfoVO, encPublicKey, encExtensions, templateInfoVO.getSignAlg());
            BigInteger signSn = this.certSnDao.getMaxSn(nowTime);
            LdapOcspUrlVO signLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(signSn, subSystemCertVO.getDn(), caInfoVO, false, null, null);
            List signExtensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), params, (PublicKey)signPublicKey, (String)subSystemCertVO.getDn(), (LdapOcspUrlVO)signLdapOcspUrlVO, (boolean)true);
            X509Certificate signCert = this.hsmService.genX509Certificate(subSystemCertVO.getDn(), signSn, nowTime, endTime, caInfoVO, signPublicKey, signExtensions, templateInfoVO.getSignAlg());
            this.saveSubSystemCert(caInfoVO, signCert, encCert, subSystemCertVO, templateInfoVO);
            this.logger.info("CA\u5b50\u7cfb\u7edf\u8bc1\u4e66\u7b7e\u53d1\u6210\u529f\uff0csignCert=" + CertUtil.writeObject((Object)signCert) + ",encCert=" + CertUtil.writeObject((Object)encCert));
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            SM2EnvelopedData sm2EnvelopedData = EnvelopedDataUtil.getEnvelopedData((Integer)Constants.BASE_ALG_TYPE, (X509Certificate)encCert);
            this.logger.debug("\u52a0\u5bc6\u8bc1\u4e66>>>>>>>>>>>>>>>" + new String(Base64.toBase64String((byte[])sm2EnvelopedData.getEncoded("DER"))));
            resultMap.put("certName", "ServerCert_" + DateTimeUtil.dateToZipStr((Date)nowTime) + ".zip");
            resultMap.put("sn", signSn.toString(16));
            resultMap.put("keyAlg", templateInfoVO.getKeyAlg());
            resultMap.put("signCert", CertUtil.writeObject((Object)signCert));
            resultMap.put("encCert", CertUtil.formatEncCert((X509Certificate)encCert, (Integer)Constants.BASE_ALG_TYPE));
            return Result.success(resultMap, (String)signSn.toString(16));
        }
        catch (Exception e) {
            throw new ServiceException("\u7b7e\u53d1CA\u5b50\u7cfb\u7edf\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    private Result checkIssueCertParams(TemplateInfoVO templateInfoVO, CaInfoVO caInfoVO, String dn) {
        if (null == templateInfoVO) {
            this.logger.debug("\u7b7e\u53d1RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728");
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
        }
        if (TemplateStatusEnum.NORMAL.value != templateInfoVO.getStatus()) {
            this.logger.info("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u7ed3\u679c\uff1a\u6a21\u677f\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u6a21\u677f\u72b6\u6001\u4e3a[{}]", (Object)templateInfoVO.getStatus());
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
        }
        if (null == caInfoVO || StringUtils.isBlank((CharSequence)caInfoVO.getBaseDn()) || null == caInfoVO.getRootCert()) {
            this.logger.debug("\u521d\u59cb\u5316CA\u5b50\u7cfb\u7edf\u670d\u52a1\u5668\u5931\u8d25\uff1a\u672a\u67e5\u5230CA\u57fa\u672c\u4fe1\u606f[{}]", (Object)dn);
            return Result.failure((ErrorEnum)ErrorEnum.CA_BASEINFO_GET_FAIL);
        }
        if (caInfoVO.getRootCert().getNotAfter().before(new Date())) {
            this.logger.debug("\u521d\u59cb\u5316CA\u5b50\u7cfb\u7edf\u670d\u52a1\u5668\u5931\u8d25\uff1aCA\u6839\u8bc1\u4e66\u5df2\u8fc7\u671f[{}]", (Object)dn);
            return Result.failure((ErrorEnum)ErrorEnum.CA_ROOT_CERT_EXPIRED);
        }
        if (!dn.toLowerCase().endsWith(caInfoVO.getBaseDn().toLowerCase())) {
            this.logger.debug("\u521d\u59cb\u5316CA\u5b50\u7cfb\u7edf\u670d\u52a1\u5668\u5931\u8d25\uff1aDN\u4e2d\u7684baseDn\u4e0d\u6b63\u786e[{}]", (Object)dn);
            return Result.failure((ErrorEnum)ErrorEnum.BASEDN_ERROR);
        }
        try {
            X500Name x500Name = DnUtil.getRFC4519X500Name((String)dn);
        }
        catch (Exception e) {
            this.logger.debug("\u521d\u59cb\u5316CA\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e0d\u7b26\u5408X500\u89c4\u8303[{}]", (Object)dn);
            return Result.failure((ErrorEnum)ErrorEnum.DN_FORMAT_FAIL);
        }
        return Result.success();
    }

    public InitAlgInfoVO getCertIssueAlgInfo(Integer type) {
        try {
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
            InitAlgInfoVO initAlgInfoVO = new InitAlgInfoVO();
            if (null != caInfoVO && StringUtils.isNotBlank((CharSequence)caInfoVO.getBaseDn())) {
                initAlgInfoVO.setBaseDn(DnUtil.getRFC4519X500Name((String)caInfoVO.getBaseDn()).toString());
            }
            if (AlgTypeEnum.RSA.value == Constants.BASE_ALG_TYPE && type == TemplateTypeEnum.CA.value) {
                initAlgInfoVO.setKeyAlg(Constants.RSA_ALG);
            } else {
                TemplateInfoVO templateInfoVO = this.templateService.getInnerTemplateByType(type.intValue());
                initAlgInfoVO.setExtensions(templateInfoVO.getExtensions());
                if (null != templateInfoVO && null != caInfoVO && StringUtils.isNotBlank((CharSequence)caInfoVO.getBaseDn())) {
                    initAlgInfoVO.setKeyAlg(templateInfoVO.getKeyAlg());
                    Map signAlgDics = new HashMap();
                    if (AlgTypeEnum.SM2.value == templateInfoVO.getKeyAlg()) {
                        signAlgDics = this.dicDao.getDicsByParentCode("signAlg");
                    } else if (AlgTypeEnum.RSA.value == templateInfoVO.getKeyAlg()) {
                        signAlgDics = this.dicDao.getDicsByParentCode("signAlgRsa");
                    } else if (AlgTypeEnum.NISTP256.value == templateInfoVO.getKeyAlg()) {
                        signAlgDics = this.dicDao.getDicsByParentCode("signAlgNist");
                    }
                    initAlgInfoVO.setKeyAlgStr(AlgTypeEnum.getAlgStr((int)templateInfoVO.getKeyAlg()));
                    initAlgInfoVO.setSignAlg(templateInfoVO.getSignAlg());
                    initAlgInfoVO.setSignAlgStr((String)signAlgDics.get(templateInfoVO.getSignAlg()));
                    initAlgInfoVO.setKeyAlgLength(templateInfoVO.getKeySize());
                    if (null == caInfoVO.getRootCert()) {
                        initAlgInfoVO.setMaxValidity(templateInfoVO.getMaxValidity());
                    } else {
                        initAlgInfoVO.setMaxValidity(IssueTimeUtil.getMaxIssueTime((Integer)templateInfoVO.getMaxValidity(), (Date)caInfoVO.getRootCert().getNotAfter()));
                    }
                }
            }
            return initAlgInfoVO;
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u8bc1\u4e66\u7b7e\u53d1\u65f6\u7b97\u6cd5\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<X509Certificate> getAllLdapServerCerts() {
        List list = this.subSystemDao.getAllLdapServerSignCerts();
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        for (String str : list) {
            X509Certificate x509Certificate = CertUtil.getCertFromStr((String)str);
            this.logger.info("ldap\u7b7e\u540d\u8bc1\u4e66SN\uff1a" + x509Certificate.getSerialNumber().toString(16));
            certList.add(x509Certificate);
        }
        return certList;
    }

    public void saveSubSystemCert(CaInfoVO caInfoVO, X509Certificate signCert, X509Certificate encCert, SubSystemCertVO subSystemCertVO, TemplateInfoVO templateInfoVO) throws Exception {
        ArrayList<ManageCertDataDO> manageCertDataDOList = new ArrayList<ManageCertDataDO>();
        ManageCertDataDO signManageCertDataDO = new ManageCertDataDO();
        ManageCertDataDO encManageCertDataDO = new ManageCertDataDO();
        encManageCertDataDO.setData(CertUtil.writeObject((Object)encCert));
        encManageCertDataDO.setGmtCreate(encCert.getNotBefore());
        signManageCertDataDO.setData(CertUtil.writeObject((Object)signCert));
        signManageCertDataDO.setGmtCreate(signCert.getNotBefore());
        Date date = new Date();
        ManageCertDO manageCertDO = new ManageCertDO();
        manageCertDO.setId(Long.valueOf(this.managerCertIdDao.getMaxId(date)));
        manageCertDO.setCaCertId(caInfoVO.getCertId());
        manageCertDO.setSn(encCert.getSerialNumber().toString(16));
        manageCertDO.setIssuer(CertUtil.getIssuerByX509Cert((X509Certificate)encCert));
        manageCertDO.setSubject(CertUtil.getSubjectByX509Cert((X509Certificate)encCert));
        manageCertDO.setPublicKeyAlg(templateInfoVO.getKeyAlg());
        manageCertDO.setPrivateKeySize(templateInfoVO.getKeySize());
        manageCertDO.setBeforeTime(encCert.getNotBefore());
        manageCertDO.setAfterTime(encCert.getNotAfter());
        manageCertDO.setSignAlg(templateInfoVO.getSignAlg());
        manageCertDO.setType(Constants.ENC_CERT);
        manageCertDO.setStatus(Integer.valueOf(1));
        manageCertDO.setTemplateId(templateInfoVO.getId());
        manageCertDO.setPairCertSn(signCert.getSerialNumber().toString(16));
        manageCertDO.setConfirmationStatus(subSystemCertVO.getDeviceType() == DeviceTypeEnum.KM_MANAGER.value ? Constants.ISSUE_CERT_NO_ACK : Constants.ISSUE_CERT_OK_ACK);
        manageCertDO.setGmtCreate(signCert.getNotBefore());
        manageCertDO = this.managereCertDao.save(manageCertDO);
        encManageCertDataDO.setId(manageCertDO.getId());
        manageCertDataDOList.add(encManageCertDataDO);
        CaSubServerCertDO caSubServerCertDO = new CaSubServerCertDO();
        caSubServerCertDO.setDeviceType(subSystemCertVO.getDeviceType());
        caSubServerCertDO.setGmtCreate(encCert.getNotAfter());
        manageCertDO.setSn(signCert.getSerialNumber().toString(16));
        manageCertDO.setPairCertSn(encCert.getSerialNumber().toString(16));
        manageCertDO.setPairCertId(manageCertDO.getId());
        manageCertDO.setType(Constants.SIGN_CERT);
        manageCertDO.setId(Long.valueOf(this.managerCertIdDao.getMaxId(date)));
        manageCertDO = this.managereCertDao.save(manageCertDO);
        signManageCertDataDO.setId(manageCertDO.getId());
        manageCertDataDOList.add(signManageCertDataDO);
        caSubServerCertDO.setManageCertId(manageCertDO.getId());
        this.caSubServerCertDao.save(caSubServerCertDO);
        this.managereCertDao.updatePairCertId(manageCertDO.getPairCertId(), manageCertDO.getId());
        this.managerCertDataDao.batchSave(manageCertDataDOList);
        if (subSystemCertVO.getDeviceType() != DeviceTypeEnum.KM_MANAGER.value) {
            this.taskDataService.savePublishCert(manageCertDO.getId(), manageCertDO.getPairCertId(), Integer.valueOf(2));
        } else {
            this.taskDataService.saveCertConfirmStatus(null, signManageCertDataDO.getId());
        }
    }
}

