/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.task;

import com.xdja.pki.ca.certmanager.dao.CertConfirmDao;
import com.xdja.pki.ca.certmanager.dao.CertDao;
import com.xdja.pki.ca.certmanager.dao.CertStatusSyncDao;
import com.xdja.pki.ca.certmanager.dao.DeltaRevokeCertDao;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.PublishCertSyncDao;
import com.xdja.pki.ca.certmanager.dao.RevokeCertDao;
import com.xdja.pki.ca.certmanager.dao.RevokeManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.TemplateDao;
import com.xdja.pki.ca.certmanager.dao.models.CertDO;
import com.xdja.pki.ca.certmanager.dao.models.CertStatusSyncDO;
import com.xdja.pki.ca.certmanager.dao.models.DeltaRevokedCertDO;
import com.xdja.pki.ca.certmanager.dao.models.NotConfirmCertSyncDO;
import com.xdja.pki.ca.certmanager.dao.models.PublishCertSyncDO;
import com.xdja.pki.ca.certmanager.dao.models.RevokedCertDO;
import com.xdja.pki.ca.certmanager.dao.models.RevokedManageCertDO;
import com.xdja.pki.ca.certmanager.service.crltemplate.CrlTemplateService;
import com.xdja.pki.ca.certmanager.service.crltemplate.bean.CrlTemplateExtensionVO;
import com.xdja.pki.ca.certmanager.service.task.CertConfirmService;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.json.JsonUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CertConfirmServiceImpl
implements CertConfirmService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private CertConfirmDao certConfirmDao;
    @Resource
    private CertDao certDao;
    @Resource
    private ManagerCertDao managerCertDao;
    @Resource
    private RevokeCertDao revokeCertDao;
    @Resource
    private RevokeManagerCertDao revokeManagerCertDao;
    @Resource
    private CertStatusSyncDao certStatusSyncDao;
    @Resource
    private PublishCertSyncDao publishCertSyncDao;
    @Resource
    private DeltaRevokeCertDao deltaRevokeCertDao;
    @Resource
    TemplateDao templateDao;
    @Resource
    CrlTemplateService crlTemplateService;
    @Value(value="${cert.confirm.overtime}")
    private long certConfirmOvertime;

    public void doExecute() {
        try {
            RevokedCertDO revokeCert;
            ArrayList<RevokedCertDO> revokeCerts;
            List userCerts;
            long overtime;
            List overtimeCerts;
            long nowTime = System.currentTimeMillis();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("==>\u5f00\u59cb\u6267\u884c\u8bc1\u4e66\u786e\u8ba4\u8c03\u5ea6\u4efb\u52a1\uff0c\u65f6\u95f4\u6233\uff1a{}", (Object)nowTime);
            }
            if ((overtimeCerts = this.certConfirmDao.queryTimeOutData(overtime = nowTime - this.certConfirmOvertime * 1000L)).isEmpty()) {
                this.logger.debug("==>\u8bc1\u4e66\u786e\u8ba4\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u5b8c\u6210\uff0c\u6ca1\u6709\u786e\u8ba4\u8d85\u65f6\u8bc1\u4e66\uff0c\u65f6\u95f4\u6233\uff1a{}", (Object)nowTime);
                return;
            }
            ArrayList<Long> userCertIds = new ArrayList<Long>();
            ArrayList<Long> manageCertIds = new ArrayList<Long>();
            for (NotConfirmCertSyncDO item : overtimeCerts) {
                if (null != item.getCertId()) {
                    userCertIds.add(item.getCertId());
                }
                if (null == item.getManageId()) continue;
                manageCertIds.add(item.getManageId());
            }
            ArrayList<DeltaRevokedCertDO> deltaRevokedCerts = new ArrayList<DeltaRevokedCertDO>();
            ArrayList<CertStatusSyncDO> certStatusSyncList = new ArrayList<CertStatusSyncDO>();
            ArrayList<PublishCertSyncDO> publishCertList = new ArrayList<PublishCertSyncDO>();
            DeltaRevokedCertDO deltaRevokedCert = null;
            CertStatusSyncDO certStatus = null;
            PublishCertSyncDO publishCert = null;
            if (!userCertIds.isEmpty() && !(userCerts = this.certDao.queryCertByIds(userCertIds)).isEmpty()) {
                revokeCerts = new ArrayList<RevokedCertDO>();
                revokeCert = null;
                for (CertDO cert : userCerts) {
                    revokeCert = new RevokedCertDO();
                    BeanUtils.copyProperties((Object)cert, (Object)revokeCert);
                    revokeCert.setBeforeTime(cert.getNotBeforeTime());
                    revokeCert.setAfterTime(cert.getNotAfterTime());
                    revokeCert.setIsRevokeKey(Integer.valueOf(RevokedCertDO.IS_REVOKE_KEY.YES_REGOKE_KEY.value));
                    revokeCert.setKeyRevokedStatus(Integer.valueOf(RevokedCertDO.KEY_REVOKE_STATUS.NO_KEY_REVOKE.value));
                    revokeCert.setRevokeReason(Integer.valueOf(9));
                    revokeCert.setGmtCreate(new Date(nowTime));
                    revokeCerts.add(revokeCert);
                    long crlTempIdByCertTempId = this.templateDao.getCrlTempIdByCertTempId(cert.getTemplateId().longValue());
                    if (crlTempIdByCertTempId != -1L) {
                        Result result = this.crlTemplateService.getCrlTemplateById(Long.valueOf(crlTempIdByCertTempId));
                        if (!result.isSuccess()) {
                            this.logger.info("\u67e5\u627eCRL\u6a21\u677f\u4fe1\u606f\u5931\u8d25:" + JsonUtils.object2Json((Object)result));
                            continue;
                        }
                        CrlTemplateExtensionVO crlTemplate = (CrlTemplateExtensionVO)result.getInfo();
                        Integer drlPeriod = crlTemplate.getCrlConfig().getDrlPeriod();
                        if (drlPeriod != null && drlPeriod != 0) {
                            deltaRevokedCert = new DeltaRevokedCertDO();
                            deltaRevokedCert.setSn(cert.getSn());
                            deltaRevokedCert.setKeyAlg(cert.getPublicKeyAlg());
                            deltaRevokedCert.setRevokeReason(revokeCert.getRevokeReason());
                            deltaRevokedCert.setGmtCreate(revokeCert.getGmtCreate());
                            deltaRevokedCert.setCrlTempId(cert.getCrlTempId());
                            deltaRevokedCert.setSegmentNo(cert.getSegmentNo());
                            deltaRevokedCerts.add(deltaRevokedCert);
                        }
                    }
                    certStatus = new CertStatusSyncDO();
                    certStatus.setCertId(cert.getId());
                    certStatus.setStatus(Integer.valueOf(CertStatusSyncDO.CertStatusEnum.REVOKE.value));
                    certStatus.setRevokeReason(Integer.valueOf(9));
                    certStatus.setGmtCreate(revokeCert.getGmtCreate());
                    certStatusSyncList.add(certStatus);
                    publishCert = new PublishCertSyncDO();
                    publishCert.setCertId(cert.getId());
                    publishCert.setGmtCreate(revokeCert.getGmtCreate());
                    publishCertList.add(publishCert);
                }
                this.certDao.deleteBatch(userCerts);
                this.revokeCertDao.saveCerts(revokeCerts);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("==>\u8bc1\u4e66\u786e\u8ba4\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u672c\u6b21\u64a4\u9500{}\u4e2a\u7528\u6237\u8bc1\u4e66\uff0c\u65f6\u95f4\u6233\uff1a{}", (Object)userCerts.size(), (Object)nowTime);
                }
            }
            if (!manageCertIds.isEmpty()) {
                List manageCerts = this.managerCertDao.queryCertByIds(manageCertIds);
                if (!manageCertIds.isEmpty()) {
                    revokeCerts = new ArrayList();
                    revokeCert = null;
                    for (CertDO cert : manageCerts) {
                        revokeCert = new RevokedManageCertDO();
                        BeanUtils.copyProperties((Object)cert, (Object)revokeCert);
                        revokeCert.setRevokeReason(Integer.valueOf(9));
                        revokeCert.setGmtCreate(new Date(nowTime));
                        revokeCerts.add(revokeCert);
                        certStatus = new CertStatusSyncDO();
                        certStatus.setManageCertId(cert.getId());
                        certStatus.setStatus(Integer.valueOf(CertStatusSyncDO.CertStatusEnum.REVOKE.value));
                        certStatus.setRevokeReason(Integer.valueOf(9));
                        certStatus.setGmtCreate(revokeCert.getGmtCreate());
                        certStatusSyncList.add(certStatus);
                        publishCert = new PublishCertSyncDO();
                        publishCert.setManageCertId(cert.getId());
                        publishCert.setGmtCreate(revokeCert.getGmtCreate());
                        publishCertList.add(publishCert);
                    }
                    this.managerCertDao.deleteBatch(manageCerts);
                    this.revokeManagerCertDao.saveBatch(revokeCerts);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("==>\u8bc1\u4e66\u786e\u8ba4\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u672c\u6b21\u64a4\u9500{}\u4e2a\u7ba1\u7406\u8bc1\u4e66\uff0c\u65f6\u95f4\u6233\uff1a{}", (Object)manageCerts.size(), (Object)nowTime);
                    }
                }
            }
            this.logger.info("=============certConfirmDao.deleteBatch===============");
            this.certConfirmDao.deleteBatch(overtimeCerts);
            this.certStatusSyncDao.saveBatchCertStatus(certStatusSyncList);
            this.publishCertSyncDao.saveBatchPublishCert(publishCertList);
            if (!CollectionUtils.isEmpty(deltaRevokedCerts)) {
                this.deltaRevokeCertDao.saveBatch(deltaRevokedCerts);
            }
            this.logger.info("==>\u8bc1\u4e66\u786e\u8ba4\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u5b8c\u6210\uff0c\u672c\u6b21\u5171\u6e05\u7406{}\u6761\u8d85\u65f6\u672a\u786e\u8ba4\u8bc1\u4e66\u6570\u636e\uff0c\u65f6\u95f4\u6233\uff1a{}", (Object)overtimeCerts.size(), (Object)nowTime);
        }
        catch (Exception e) {
            throw new ServiceException("\u6267\u884c\u8bc1\u4e66\u786e\u8ba4\u8c03\u5ea6\u4e1a\u52a1\u5931\u8d25", (Throwable)e);
        }
    }
}

