/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.task;

import com.xdja.pki.ca.certmanager.dao.CertDataDao;
import com.xdja.pki.ca.certmanager.dao.CrossCertDao;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDataDao;
import com.xdja.pki.ca.certmanager.dao.OuterCrossCertDao;
import com.xdja.pki.ca.certmanager.dao.PublishCertSyncDao;
import com.xdja.pki.ca.certmanager.dao.SubCaCertDao;
import com.xdja.pki.ca.certmanager.service.task.ICertPublishService;
import com.xdja.pki.ca.certmanager.service.util.LdapCASDKUtil;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.configBasic.bean.DirServerConfigBean;
import com.xdja.pki.ca.core.util.FileUtils;
import com.xdja.pki.ca.core.util.json.JsonUtils;
import com.xdja.pki.ca.securitymanager.dao.CaCertDao;
import com.xdja.pki.ca.securitymanager.dao.CaDao;
import com.xdja.pki.ca.securitymanager.dao.model.CaCertDo;
import com.xdja.pki.ca.securitymanager.dao.model.CaDO;
import com.xdja.pki.ca.securitymanager.service.configfile.ConfigFileService;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ldap.sdk.ca.LDAPCASDK;
import com.xdja.pki.ldap.sdk.ca.LDAPResponse;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CertPublishServiceImpl
implements ICertPublishService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String DIGESTALGORITHMNAME = "SM3";
    public static final String PUBLISH_CERT_TYPE_CERT = "cert_id";
    public static final String PUBLISH_CERT_TYPE_MANAGECERT = "manage_cert_id";
    public static final String PUBLISH_CERT_TYPE_SUBCACERT = "sub_ca_id";
    public static final String PUBLISH_CERT_TYPE_CACERT = "ca_cert_id";
    public static final String PUBLISH_CERT_TYPE_CROSSCERT = "cross_cert_id";
    public static final String PUBLISH_CERT_TYPE_OUTERCROSSCERT = "outer_cross_cert_id";
    @Resource
    private PublishCertSyncDao publishCertSyncDao;
    @Resource
    private CertDataDao certDataDao;
    @Resource
    private ManagerCertDataDao managerCertDataDao;
    @Resource
    private CrossCertDao crossCertDao;
    @Resource
    private OuterCrossCertDao outerCrossCertDao;
    @Resource
    private SubCaCertDao subCaCertDao;
    @Resource
    private CaCertDao caCertDao;
    @Resource
    private CaDao caDao;
    @Autowired
    private LdapCASDKUtil ldapCASDKUtil;
    @Autowired
    private ConfigFileService configFileService;
    @Value(value="${ldapsdk.response.overtime}")
    public int ldapsdkOutTime;

    public void publishCertSync() {
        if (!this.configFileService.verifySystemInitIsOK()) {
            this.logger.debug("====CA\u6682\u65e0\u521d\u59cb\u5316\uff01");
            return;
        }
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
        if (null == caInfoVO || !caInfoVO.isLadp()) {
            this.logger.debug("===CA\u7cfb\u7edf\u672a\u542f\u7528LDAP\u670d\u52a1\uff01");
            return;
        }
        Map queryPublishCertForList = this.publishCertSyncDao.queryPublishCertForList();
        if (queryPublishCertForList != null && !queryPublishCertForList.isEmpty()) {
            ArrayList<X509Certificate> certificates;
            List<Long> userCertIds = this.getPublishCertIds(queryPublishCertForList.get("certId"));
            List<Long> manageCertIds = this.getPublishCertIds(queryPublishCertForList.get("manageCertId"));
            List<Long> caCertIds = this.getPublishCertIds(queryPublishCertForList.get("caCertId"));
            List<Long> crossCertIds = this.getPublishCertIds(queryPublishCertForList.get("crossCertId"));
            List<Long> outCrossCertIds = this.getPublishCertIds(queryPublishCertForList.get("outCrossCertId"));
            List<Long> subCaCertIds = this.getPublishCertIds(queryPublishCertForList.get("subCaCertId"));
            if (CollectionUtils.isNotEmpty(caCertIds)) {
                ArrayList<Long> publishCaCerts = new ArrayList<Long>();
                for (Long caCertId : caCertIds) {
                    CaCertDo caCert = this.caCertDao.getCaCert(caCertId.longValue());
                    X509Certificate newWithNewCert = null != caCert.getCert() ? CertUtil.getCertFromStr((String)caCert.getCert()) : null;
                    ArrayList<X509Certificate> x509Certificates = new ArrayList<X509Certificate>();
                    x509Certificates.add(newWithNewCert);
                    boolean isSuccess = this.sendCertificates(x509Certificates, caCert, 1);
                    if (!isSuccess) {
                        this.logger.info("============== \u53d1\u5e03CA\u8bc1\u4e66\u9519\u8bef ========== ");
                        return;
                    }
                    publishCaCerts.add(caCertId);
                    if (publishCaCerts.isEmpty()) continue;
                    this.publishCertSyncDao.deletePublishCertSyncByCertType(PUBLISH_CERT_TYPE_CACERT, publishCaCerts);
                }
            }
            if (CollectionUtils.isNotEmpty(userCertIds)) {
                ArrayList<Long> publishUserCerts = new ArrayList<Long>();
                certificates = new ArrayList<X509Certificate>();
                Map userCertData = this.certDataDao.getUserCertData(userCertIds);
                certificates.addAll(this.getCertificateFormMaps(userCertData));
                if (CollectionUtils.isNotEmpty(certificates)) {
                    boolean isSuccess = this.sendCertificates(certificates, null, 0);
                    if (isSuccess) {
                        publishUserCerts.addAll(userCertIds);
                        if (!publishUserCerts.isEmpty()) {
                            this.publishCertSyncDao.deletePublishCertSyncByCertType(PUBLISH_CERT_TYPE_CERT, publishUserCerts);
                        }
                    } else {
                        this.logger.info("========== \u53d1\u5e03\u7528\u6237\u8bc1\u4e66\u9519\u8bef ========== ");
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(manageCertIds)) {
                ArrayList<Long> publishManageCerts = new ArrayList<Long>();
                certificates = new ArrayList();
                Map manageCertDatas = this.managerCertDataDao.getManageCertData(manageCertIds);
                certificates.addAll(this.getCertificateFormMaps(manageCertDatas));
                if (CollectionUtils.isNotEmpty(certificates)) {
                    boolean isSuccess = this.sendCertificates(certificates, null, 0);
                    if (isSuccess) {
                        publishManageCerts.addAll(manageCertIds);
                        if (!publishManageCerts.isEmpty()) {
                            this.publishCertSyncDao.deletePublishCertSyncByCertType(PUBLISH_CERT_TYPE_MANAGECERT, publishManageCerts);
                        }
                    } else {
                        this.logger.info(" ========== \u53d1\u5e03\u7ba1\u7406\u7c7b\u8bc1\u4e66\u9519\u8bef ========== ");
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(subCaCertIds)) {
                ArrayList<Long> publishSubCaCerts = new ArrayList<Long>();
                certificates = new ArrayList();
                Map subCaCertDatas = this.subCaCertDao.getSubCaCertData(subCaCertIds);
                certificates.addAll(this.getCertificateFormMaps(subCaCertDatas));
                if (CollectionUtils.isNotEmpty(certificates)) {
                    boolean isSuccess = this.sendCertificates(certificates, null, 0);
                    if (isSuccess) {
                        publishSubCaCerts.addAll(subCaCertIds);
                        if (!publishSubCaCerts.isEmpty()) {
                            this.publishCertSyncDao.deletePublishCertSyncByCertType(PUBLISH_CERT_TYPE_SUBCACERT, publishSubCaCerts);
                        }
                    } else {
                        this.logger.info(" ========== \u53d1\u5e03\u5b50CA\u8bc1\u4e66\u9519\u8bef ========== ");
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(crossCertIds)) {
                ArrayList<Long> publishCrossCerts = new ArrayList<Long>();
                Map crossCertDatas = this.crossCertDao.getCrossCertData(crossCertIds);
                List<X509Certificate> crossCerts = this.getCertificateFormMaps(crossCertDatas);
                if (CollectionUtils.isNotEmpty(crossCerts)) {
                    boolean isSuccess = this.sendCertificates(crossCerts, null, 3);
                    if (isSuccess) {
                        publishCrossCerts.addAll(crossCertIds);
                        if (!publishCrossCerts.isEmpty()) {
                            this.publishCertSyncDao.deletePublishCertSyncByCertType(PUBLISH_CERT_TYPE_CROSSCERT, publishCrossCerts);
                        }
                    } else {
                        this.logger.info(" ========== \u53d1\u5e03\u4ea4\u53c9\u8bc1\u4e66\u9519\u8bef ========== ");
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(outCrossCertIds)) {
                ArrayList<Long> publishOuterCrossCerts = new ArrayList<Long>();
                Map outCrossCertDatas = this.outerCrossCertDao.getOuterCrossCertData(outCrossCertIds);
                List<X509Certificate> outCrossCerts = this.getCertificateFormMaps(outCrossCertDatas);
                if (CollectionUtils.isNotEmpty(outCrossCerts)) {
                    boolean isSuccess = this.sendCertificates(outCrossCerts, null, 2);
                    if (isSuccess) {
                        publishOuterCrossCerts.addAll(outCrossCertIds);
                        if (!publishOuterCrossCerts.isEmpty()) {
                            this.publishCertSyncDao.deletePublishCertSyncByCertType(PUBLISH_CERT_TYPE_OUTERCROSSCERT, publishOuterCrossCerts);
                        }
                    } else {
                        this.logger.info(" ========== \u53d1\u5e03\u5916\u90e8\u5bfc\u5165\u4ea4\u53c9\u8bc1\u4e66\u9519\u8bef ========== ");
                    }
                }
            }
        }
    }

    private boolean sendRootCACertificateToLDAP(X509Certificate oldWithNewCert, X509Certificate newWithOldCert, X509Certificate newWithNewCert, LDAPCASDK ldapcasdk, LDAPResponse pkixIssueResp) {
        boolean isSuccess = true;
        pkixIssueResp = ldapcasdk.updateRootCACertificateToLDAP(oldWithNewCert, newWithOldCert, newWithNewCert);
        isSuccess = pkixIssueResp.isFlag();
        if (!isSuccess) {
            this.logger.error("\u6839\u8bc1\u4e66\u66f4\u65b0LDAP\u53d1\u5e03\u5931\u8d25\uff0creason:[{}]", (Object)pkixIssueResp.getReason());
        }
        return isSuccess;
    }

    private boolean sendRootCACertificateToOCSP(X509Certificate oldWithNewCert, X509Certificate newWithOldCert, X509Certificate newWithNewCert, LDAPCASDK ldapcasdk, LDAPResponse pkixIssueResp) {
        boolean isSuccess = true;
        pkixIssueResp = ldapcasdk.updateRootCACertificateToOCSP(oldWithNewCert, newWithOldCert, newWithNewCert);
        isSuccess = pkixIssueResp.isFlag();
        if (!isSuccess) {
            this.logger.error("\u6839\u8bc1\u4e66\u66f4\u65b0OCSP\u53d1\u5e03\u5931\u8d25\uff0creason:[{}]", (Object)pkixIssueResp.getReason());
        }
        return isSuccess;
    }

    private boolean sendCertificates(List<X509Certificate> certs, CaCertDo caCert, int certType) {
        boolean isSuccess = true;
        LDAPResponse pkixIssueResp = null;
        LDAPCASDK pkixIssueSdk = this.ldapCASDKUtil.getPkixIssueSDKInstance();
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
        DirServerConfigBean dirServerConfigBean = caInfoVO.getDirServerConfigBean();
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dirServerConfigBean.getSlaveURL(), dirServerConfigBean.getMasterURL()})) {
            this.logger.info("====================\u7cfb\u7edf\u5c06\u8bc1\u4e66\u53d1\u5e03\u5230LDAP\u670d\u52a1\u5668\u4e0a==================== certType == " + certType);
            if (1 == certType) {
                X509Certificate newWithOldCert;
                Long caId = caCert.getCaId();
                CaDO caById = this.caDao.getCaById(caId.longValue());
                X509Certificate newWithNewCert = null != caCert.getCert() ? CertUtil.getCertFromStr((String)caCert.getCert()) : null;
                X509Certificate oldWithNewCert = null != caCert.getOldWithNewCert() ? CertUtil.getCertFromStr((String)caCert.getOldWithNewCert()) : null;
                X509Certificate x509Certificate = newWithOldCert = null != caCert.getNewWithOldCert() ? CertUtil.getCertFromStr((String)caCert.getNewWithOldCert()) : null;
                if (null != oldWithNewCert && null != newWithOldCert && CaDO.CaTypeEnum.ROOT_CA.value == caById.getType()) {
                    this.logger.info("\u7cfb\u7edf\u914d\u7f6e\u4e86LDAP\u670d\u52a1\uff0c\u53d1\u5e03\u7ebf\u7a0b\u5411LDA\u670d\u52a1\u53d1\u5e03CA\u8bc1\u4e66");
                    LDAPResponse ldapResponse = pkixIssueSdk.updateRootCACertificateToLDAP(oldWithNewCert, newWithOldCert, newWithNewCert);
                    if (!ldapResponse.isFlag()) {
                        this.logger.error("\u5411LDAP\u53d1\u5e03\u66f4\u65b0CA\u8bc1\u4e66\u9519\u8bef ========== " + JsonUtils.object2Json((Object)pkixIssueResp));
                        return false;
                    }
                }
            } else if (2 == certType) {
                for (X509Certificate outCrossCert : certs) {
                    pkixIssueResp = pkixIssueSdk.sendCrossCertificateIssueToThisCA(outCrossCert);
                    if (pkixIssueResp.isFlag()) continue;
                    this.logger.error("\u5916\u90e8\u4ea4\u53c9\u8bc1\u4e66\u53d1\u5e03\u5931\u8d25\uff0creason:[{}]", (Object)pkixIssueResp.getReason());
                    return false;
                }
            } else if (3 == certType) {
                for (X509Certificate outCrossCert : certs) {
                    pkixIssueResp = pkixIssueSdk.sendCrossCertificateIssueByThisCA(outCrossCert);
                    if (pkixIssueResp.isFlag()) continue;
                    this.logger.error("\u4ea4\u53c9\u8bc1\u4e66\u53d1\u5e03\u5931\u8d25\uff0creason:[{}]", (Object)pkixIssueResp.getReason());
                    return false;
                }
            } else if (CollectionUtils.isNotEmpty(certs) && !(pkixIssueResp = pkixIssueSdk.sendCertificate(certs)).isFlag()) {
                this.logger.error("LDAP\u65b9\u5f0f\u53d1\u5e03\u8bc1\u4e66\u5931\u8d25\uff0creason:[{}]", (Object)JsonUtils.object2Json((Object)pkixIssueResp));
                return false;
            }
        }
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dirServerConfigBean.getLocalURL(), dirServerConfigBean.getExtranetHttpURL()})) {
            for (X509Certificate cert : certs) {
                try {
                    String cerDn = CertUtil.getSubjectByX509Cert((X509Certificate)cert);
                    this.logger.info("====================\u7cfb\u7edf\u5c06\u8bc1\u4e66\u53d1\u5e03\u5230HTTP\u670d\u52a1\u5668\u4e0aDN:" + cerDn + "====================");
                    FileUtils.saveFile((byte[])cert.getEncoded(), (String)(dirServerConfigBean.getLocalURL() + "/" + cerDn + ".cer"));
                }
                catch (Exception e) {
                    this.logger.error("\u7cfb\u7edf\u5c06\u8bc1\u4e66\u53d1\u5e03\u5230HTTP\u670d\u52a1\u5668\u4e0a\u9519\u8bef ======== ", (Throwable)e);
                    return false;
                }
            }
        }
        return isSuccess;
    }

    private List<Long> getPublishCertIds(Object certIdObj) {
        String certIdObjstr;
        String[] certIdstrsplit;
        ArrayList<Long> publishCertIds = null;
        if (certIdObj != null && (certIdstrsplit = (certIdObjstr = (String)certIdObj).split(",")).length > 0) {
            publishCertIds = new ArrayList<Long>();
            for (int i = 0; i < certIdstrsplit.length; ++i) {
                String certIdstr = certIdstrsplit[i];
                publishCertIds.add(Long.parseLong(certIdstr));
            }
        }
        return publishCertIds;
    }

    private List<X509Certificate> getCertificateFormMaps(Map<Long, String> certDataMap) {
        ArrayList<X509Certificate> certLists = null;
        if (certDataMap != null && !certDataMap.isEmpty()) {
            certLists = new ArrayList<X509Certificate>();
            for (Long key : certDataMap.keySet()) {
                String data = certDataMap.get(key);
                X509Certificate cert = CertUtil.getCertFromStr((String)data);
                certLists.add(cert);
            }
        }
        return certLists;
    }
}

