/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.task;

import com.xdja.pki.ca.certmanager.dao.CertDataDao;
import com.xdja.pki.ca.certmanager.dao.CertStatusSyncDao;
import com.xdja.pki.ca.certmanager.dao.CrossCertDao;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDataDao;
import com.xdja.pki.ca.certmanager.dao.SubCaCertDao;
import com.xdja.pki.ca.certmanager.dao.models.CertStatusSyncDO;
import com.xdja.pki.ca.certmanager.service.task.ICertStatusSyncService;
import com.xdja.pki.ca.certmanager.service.task.bean.IssueCertStatusVO;
import com.xdja.pki.ca.certmanager.service.util.LdapCASDKUtil;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.enums.CaOcspCertStatusEnum;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.securitymanager.dao.CaCertDao;
import com.xdja.pki.ca.securitymanager.dao.CaDao;
import com.xdja.pki.ca.securitymanager.dao.model.CaCertDo;
import com.xdja.pki.ca.securitymanager.dao.model.CaDO;
import com.xdja.pki.ca.securitymanager.service.configfile.ConfigFileService;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.issue.PkixIssueCertStatus;
import com.xdja.pki.issue.TBSIssueCRLReason;
import com.xdja.pki.ldap.sdk.ca.LDAPCASDK;
import com.xdja.pki.ldap.sdk.ca.LDAPResponse;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.bouncycastle.asn1.ASN1Integer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class CertStatusSyncServiceImpl
implements ICertStatusSyncService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static int CERTSTATUSSYNC_TYPE_CERT = 1;
    public static int CERTSTATUSSYNC_TYPE_MANAGECERT = 2;
    public static int CERTSTATUSSYNC_TYPE_CROSSCERT = 3;
    public static int CERTSTATUSSYNC_TYPE_SUBCACERT = 4;
    @Resource
    private CertStatusSyncDao certStatusSyncDao;
    @Resource
    private CertDataDao certDataDao;
    @Resource
    private ManagerCertDataDao managerCertDataDao;
    @Resource
    private CrossCertDao crossCertDao;
    @Resource
    private SubCaCertDao subCaCertDao;
    @Autowired
    private LdapCASDKUtil ldapCASDKUtil;
    @Autowired
    private Environment env;
    @Autowired
    private CaCertDao caCertDao;
    @Autowired
    private CaDao caDao;
    @Autowired
    private ConfigFileService configFileService;
    @Value(value="${ldapsdk.response.overtime}")
    public int ldapsdkOutTime;

    public void execCertStatSync() {
        if (!this.configFileService.verifySystemInitIsOK()) {
            this.logger.info("====CA\u6682\u65e0\u521d\u59cb\u5316\uff01");
            return;
        }
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
        if (null == caInfoVO || !caInfoVO.isOcsp()) {
            this.logger.debug("===CA\u7cfb\u7edf\u672a\u542f\u7528OCSP\u670d\u52a1\uff01");
            return;
        }
        List certStatusSyncs = null;
        try {
            certStatusSyncs = this.certStatusSyncDao.queryCACertUpdateForList(CertStatusSyncDO.CertStatusEnum.NORMAL.value);
        }
        catch (Exception e) {
            throw new ServiceException("CertStatusSyncServiceImpl\u67e5\u8be2\u8bc1\u4e66\u53d1\u5e03\u72b6\u6001\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
        }
        if (certStatusSyncs != null && !certStatusSyncs.isEmpty()) {
            for (CertStatusSyncDO certStatusData : certStatusSyncs) {
                X509Certificate newWithOldCert;
                Long caCertId = certStatusData.getRootCertId();
                if (null == caCertId) continue;
                CaCertDo caCert = this.caCertDao.getCaCert(caCertId.longValue());
                Long caId = caCert.getCaId();
                CaDO caById = this.caDao.getCaById(caId.longValue());
                X509Certificate newWithNewCert = null != caCert.getCert() ? CertUtil.getCertFromStr((String)caCert.getCert()) : null;
                Iterator oldWithNewCert = null != caCert.getOldWithNewCert() ? CertUtil.getCertFromStr((String)caCert.getOldWithNewCert()) : null;
                X509Certificate x509Certificate = newWithOldCert = null != caCert.getNewWithOldCert() ? CertUtil.getCertFromStr((String)caCert.getNewWithOldCert()) : null;
                if (null == oldWithNewCert || null == newWithOldCert || CaDO.CaTypeEnum.ROOT_CA.value != caById.getType()) continue;
                if (!caInfoVO.isOcsp()) {
                    this.logger.error("===CA\u7cfb\u7edf\u672a\u542f\u7528OCSP\u670d\u52a1\uff01");
                    break;
                }
                LDAPCASDK ldapcasdk = this.ldapCASDKUtil.getPkixIssueSDKInstance();
                LDAPResponse ldapResponse = ldapcasdk.updateRootCACertificateToOCSP(oldWithNewCert, newWithOldCert, newWithNewCert);
                if (!ldapResponse.isFlag()) {
                    this.logger.error("\u540c\u6b65CA\u66f4\u65b0\u6839\u8bc1\u4e66\u5230ocsp\u5931\u8d25");
                    return;
                }
                this.certStatusSyncDao.deleteDataByRootCertId(caCertId);
                this.logger.info("\u540c\u6b65CA\u66f4\u65b0\u6839\u8bc1\u4e66\u5230ocsp\u6210\u529f");
            }
        }
        try {
            certStatusSyncs = this.certStatusSyncDao.queryPublishCert();
        }
        catch (DAOException e) {
            throw new ServiceException("CertStatusSyncServiceImpl\u67e5\u8be2\u8bc1\u4e66\u53d1\u5e03\u72b6\u6001\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
        }
        if (certStatusSyncs != null && !certStatusSyncs.isEmpty()) {
            ArrayList<IssueCertStatusVO> issueCertStatusVOList = new ArrayList<IssueCertStatusVO>();
            HashMap<Long, Integer> certDataIdMaps = new HashMap<Long, Integer>();
            HashMap manageCertDataIdMaps = new HashMap();
            HashMap crossCertDataIdMaps = new HashMap();
            HashMap subCaCertDataIdMaps = new HashMap();
            HashMap<Long, Date> revokeDate = new HashMap<Long, Date>();
            HashMap<Long, Integer> certStatusMaps = new HashMap<Long, Integer>();
            for (CertStatusSyncDO certStatusSync : certStatusSyncs) {
                Long certId = certStatusSync.getCertId();
                Long manageCertId = certStatusSync.getManageCertId();
                Long crossCertId = certStatusSync.getCrossCertId();
                Long subCertId = certStatusSync.getSubCertId();
                Integer revokeReason = certStatusSync.getRevokeReason();
                if (certId == null) continue;
                certDataIdMaps.put(certId, revokeReason);
                revokeDate.put(certId, certStatusSync.getGmtCreate());
                certStatusMaps.put(certId, certStatusSync.getStatus());
            }
            if (!certDataIdMaps.isEmpty()) {
                issueCertStatusVOList.addAll(this.getCertStatSyncData(certDataIdMaps, certStatusMaps, revokeDate, CERTSTATUSSYNC_TYPE_CERT));
            }
            if (!issueCertStatusVOList.isEmpty()) {
                LDAPCASDK ldapcasdk = this.ldapCASDKUtil.getPkixIssueSDKInstance();
                List<X509Certificate> ocspSignCerts = this.ldapCASDKUtil.getOcspSignCerts();
                if (null == ocspSignCerts || ocspSignCerts.isEmpty()) {
                    this.logger.info("CA\u7cfb\u7edf\u672a\u7b7e\u53d1OCSP\u670d\u52a1\u5668\u8bc1\u4e66\uff0c\u6682\u4e0d\u80fd\u540c\u6b65\u8bc1\u4e66\u72b6\u6001\uff01");
                    return;
                }
                ArrayList<PkixIssueCertStatus> list = new ArrayList<PkixIssueCertStatus>();
                for (IssueCertStatusVO issueCertStatusVO : issueCertStatusVOList) {
                    try {
                        int status = CaOcspCertStatusEnum.getOcspCertStatus((int)issueCertStatusVO.getStatus());
                        list.add(new PkixIssueCertStatus(TBSIssueCRLReason.decode((ASN1Integer)new ASN1Integer((long)issueCertStatusVO.getReason().intValue())), CertUtil.getCertFromStr((String)issueCertStatusVO.getData()), issueCertStatusVO.getRevokeDate(), Integer.valueOf(status)));
                    }
                    catch (Exception e) {
                        throw new ServiceException("PkixIssueReq\u6784\u9020\u5f02\u5e38\uff0c", (Throwable)e);
                    }
                }
                LDAPResponse pkixIssueResp = ldapcasdk.sendCertStatus(list);
                boolean flag = pkixIssueResp.isFlag();
                if (flag) {
                    this.logger.info("===\u8bc1\u4e66\u72b6\u6001\u540c\u6b65\u6210\u529f");
                    this.certStatusSyncDao.deleteBatch(certStatusSyncs);
                } else {
                    this.logger.error("===\u8bc1\u4e66\u72b6\u6001\u540c\u6b65\u5931\u8d25\uff0creason:{}", (Object)pkixIssueResp.getReason());
                }
            }
        } else {
            this.logger.debug("====\u672c\u6b21\u6ca1\u6709\u8981\u540c\u6b65\u7684\u8bc1\u4e66\u72b6\u6001\u4fe1\u606f\uff0c\u5f53\u524d\u65f6\u95f4:{}", (Object)System.currentTimeMillis());
        }
    }

    private List<IssueCertStatusVO> getCertStatSyncData(Map<Long, Integer> certDataIdMaps, Map<Long, Integer> certStatusMaps, Map<Long, Date> revokeDate, int type) {
        ArrayList<Long> certDataIds = new ArrayList<Long>();
        Set<Long> keySet = certDataIdMaps.keySet();
        for (Long key : keySet) {
            certDataIds.add(key);
        }
        Map certData = null;
        try {
            if (type == CERTSTATUSSYNC_TYPE_CERT) {
                certData = this.certDataDao.getUserCertData(certDataIds);
            } else if (type == CERTSTATUSSYNC_TYPE_MANAGECERT) {
                certData = this.managerCertDataDao.getManageCertData(certDataIds);
            } else if (type == CERTSTATUSSYNC_TYPE_CROSSCERT) {
                certData = this.crossCertDao.getCrossCertData(certDataIds);
            } else if (type == CERTSTATUSSYNC_TYPE_SUBCACERT) {
                certData = this.subCaCertDao.getSubCaCertData(certDataIds);
            }
        }
        catch (DAOException e) {
            throw new ServiceException("\u67e5\u8be2\u8bc1\u4e66\u5185\u5bb9\u5f02\u5e38", (Throwable)e);
        }
        ArrayList<IssueCertStatusVO> issueCertStatusVOList = new ArrayList<IssueCertStatusVO>();
        IssueCertStatusVO issueCertStatusVO = null;
        if (certData != null && !certData.isEmpty()) {
            Set certDataKeySet = certData.keySet();
            for (Long key : certDataKeySet) {
                issueCertStatusVO = new IssueCertStatusVO();
                String data = (String)certData.get(key);
                Integer reason = certDataIdMaps.get(key);
                issueCertStatusVO.setData(data);
                issueCertStatusVO.setReason(reason);
                issueCertStatusVO.setRevokeDate(revokeDate.get(key));
                issueCertStatusVO.setStatus(certStatusMaps.get(key));
                issueCertStatusVOList.add(issueCertStatusVO);
            }
        }
        return issueCertStatusVOList;
    }
}

