/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.task;

import com.xdja.pki.ca.certmanager.dao.RevokeCertDao;
import com.xdja.pki.ca.certmanager.dao.models.RevokedCertDO;
import com.xdja.pki.ca.certmanager.service.kms.KmsService;
import com.xdja.pki.ca.certmanager.service.task.IPubKeyRevokedNotifyService;
import com.xdja.pki.ca.certmanager.service.task.bean.PubKeyRevokeNotifyVO;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.common.Config;
import com.xdja.pki.ca.core.util.SpringBeanUtil;
import com.xdja.pki.ca.securitymanager.service.configfile.ConfigFileService;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import java.math.BigInteger;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class PubKeyRevokedNotifyServiceImpl
implements IPubKeyRevokedNotifyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private RevokeCertDao revokeCertDao;
    @Autowired
    private Environment env;
    @Autowired
    private ConfigFileService configFileService;

    public void execPubKeyRevokeNotify() {
        List pubKeyRevokeCerts = this.revokeCertDao.getPubKeyRevokeCerts();
        if (pubKeyRevokeCerts != null && !pubKeyRevokeCerts.isEmpty()) {
            for (RevokedCertDO pubKeyRevokeCert : pubKeyRevokeCerts) {
                PubKeyRevokeNotifyVO pubKeyRevokeNotifyVO = new PubKeyRevokeNotifyVO();
                BeanUtils.copyProperties((Object)pubKeyRevokeCert, (Object)pubKeyRevokeNotifyVO);
                try {
                    CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
                    this.logger.debug("\u67e5\u8be2\u5230\u64a4\u9500\u8bc1\u4e66\u7684SN:" + pubKeyRevokeCert.getSn());
                    String correctSn = this.getApplyKeySn(pubKeyRevokeCert.getSn());
                    this.logger.debug("\u7533\u8bf7\u5bc6\u94a5\u7684\u8bc1\u4e66SN:" + correctSn);
                    BigInteger sn = new BigInteger(correctSn, 16);
                    this.logger.debug("\u5411\u5bc6\u7ba1\u7cfb\u7edf\u7533\u8bf7\u64a4\u9500\u5bc6\u94a5sn=" + sn + "---" + pubKeyRevokeCert.getSn());
                    KmsService kmsService = null;
                    Config config = this.configFileService.getConfigInfo();
                    int kmSystemType = config.getKmSystemType();
                    if (kmSystemType == 1) {
                        kmsService = (KmsService)SpringBeanUtil.getBean((String)"kmsSansecService");
                    } else if (kmSystemType == 2) {
                        kmsService = (KmsService)SpringBeanUtil.getBean((String)"kmsXdjaHttpService");
                    }
                    kmsService.revokeEncKey(caInfoVO, sn);
                    this.logger.debug("\u5bc6\u7ba1\u7cfb\u7edf\u64a4\u9500\u5bc6\u94a5\u6210\u529fsn=" + sn + "---" + pubKeyRevokeCert.getSn());
                    this.logger.debug("\u5f00\u59cb\u66f4\u65b0\u5bc6\u94a5\u64a4\u9500\u72b6\u6001");
                    this.revokeCertDao.updatePubKeyRevokeStatus(pubKeyRevokeCert);
                    this.logger.debug("\u66f4\u65b0\u5bc6\u94a5\u64a4\u9500\u72b6\u6001\u7ed3\u675f");
                }
                catch (Exception e) {
                    this.logger.error("\u5bc6\u94a5\u64a4\u9500\u5931\u8d25\uff0cpubKeyRevokeNotifyVO=" + pubKeyRevokeNotifyVO.toString(), (Throwable)e);
                }
            }
        }
    }

    public String getApplyKeySn(String sn) {
        RevokedCertDO revokedCertDO = this.revokeCertDao.getCertBySn(sn);
        if (null == revokedCertDO.getOldCertId()) {
            return revokedCertDO.getSn();
        }
        RevokedCertDO oldCert = this.revokeCertDao.getCertById(revokedCertDO.getOldCertId().longValue());
        if (null == oldCert || oldCert.getIsRevokeKey() == 1) {
            return revokedCertDO.getSn();
        }
        return this.getApplyKeySn(oldCert.getSn());
    }
}

