/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.task;

import com.xdja.pki.ca.certmanager.dao.CertConfirmDao;
import com.xdja.pki.ca.certmanager.dao.CertStatusSyncDao;
import com.xdja.pki.ca.certmanager.dao.PublishCertSyncDao;
import com.xdja.pki.ca.certmanager.dao.models.CertStatusSyncDO;
import com.xdja.pki.ca.certmanager.dao.models.NotConfirmCertSyncDO;
import com.xdja.pki.ca.certmanager.dao.models.PublishCertSyncDO;
import com.xdja.pki.ca.certmanager.service.task.TaskDataService;
import com.xdja.pki.ca.certmanager.service.task.bean.TaskNormalCertTypeEnum;
import com.xdja.pki.ca.certmanager.service.task.bean.TaskRevokeCertTypeEnum;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.exception.ServiceException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskDataServiceImpl
implements TaskDataService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PublishCertSyncDao publishCertSyncDao;
    @Autowired
    private CertStatusSyncDao certStatusSyncDao;
    @Autowired
    private CertConfirmDao certConfirmDao;

    public Result savePublishCert(Long signCertId, Long encCertId, Integer type) {
        try {
            if (!TaskNormalCertTypeEnum.verifyType((int)type)) {
                this.logger.debug("\u5411LDAP\u540c\u6b65\u6570\u636e\u8868\u4fdd\u5b58\u6570\u636e\u65f6type\u9519\u8bef\uff0ctype=[{}]", (Object)type);
                return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
            }
            List<PublishCertSyncDO> dbList = this.buildPublishCertList(signCertId, encCertId, type);
            this.publishCertSyncDao.saveBatchPublishCert(dbList);
            return Result.success();
        }
        catch (Exception e) {
            throw new ServiceException("\u5411LDAP\u540c\u6b65\u6570\u636e\u8868\u4fdd\u5b58\u6570\u636e\u65f6\u5f02\u5e38", (Throwable)e);
        }
    }

    private List<PublishCertSyncDO> buildPublishCertList(Long signCertId, Long encCertId, Integer type) {
        PublishCertSyncDO signPublishCertSyncDO = new PublishCertSyncDO();
        PublishCertSyncDO encPublishCertSyncDO = new PublishCertSyncDO();
        Date nowTime = new Date();
        signPublishCertSyncDO.setGmtCreate(nowTime);
        switch (type) {
            case 1: {
                signPublishCertSyncDO.setCertId(signCertId);
                if (null == encCertId) break;
                encPublishCertSyncDO.setCertId(encCertId);
                break;
            }
            case 2: {
                signPublishCertSyncDO.setManageCertId(signCertId);
                if (null == encCertId) break;
                encPublishCertSyncDO.setManageCertId(encCertId);
                break;
            }
            case 3: {
                signPublishCertSyncDO.setCaCertId(signCertId);
                break;
            }
            case 4: {
                signPublishCertSyncDO.setCrossCertId(signCertId);
                break;
            }
            case 5: {
                signPublishCertSyncDO.setOuterCrossCertId(signCertId);
                break;
            }
            case 6: {
                signPublishCertSyncDO.setSubCaId(signCertId);
                break;
            }
            default: {
                this.logger.error("\u5411LDAP\u540c\u6b65\u6570\u636e\u8868\u4fdd\u5b58\u6570\u636e\u65f6type\u9519\u8bef");
            }
        }
        ArrayList<PublishCertSyncDO> list = new ArrayList<PublishCertSyncDO>();
        list.add(signPublishCertSyncDO);
        if (null != encCertId) {
            encPublishCertSyncDO.setGmtCreate(nowTime);
            list.add(encPublishCertSyncDO);
        }
        return list;
    }

    public Result saveSyncStatusCert(Long signCertId, Long encCertId, Integer type, Integer status, Integer revokeReason, Date revokeDate) {
        try {
            if (!TaskRevokeCertTypeEnum.verifyType((int)type)) {
                this.logger.debug("\u5411OCSP\u540c\u6b65\u6570\u636e\u8868\u4fdd\u5b58\u6570\u636e\u65f6type\u9519\u8bef\uff0ctype=[{}]", (Object)type);
                return Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
            }
            List<CertStatusSyncDO> dbList = this.buildSyncStatusCertList(signCertId, encCertId, status, type, revokeReason, revokeDate);
            this.certStatusSyncDao.saveBatchCertStatus(dbList);
            return Result.success();
        }
        catch (Exception e) {
            throw new ServiceException("\u5411OCSP\u540c\u6b65\u6570\u636e\u8868\u4fdd\u5b58\u6570\u636e\u65f6\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result saveCertConfirmStatus(Long certId, Long managerId) {
        try {
            NotConfirmCertSyncDO notConfirmCertSyncDO = new NotConfirmCertSyncDO();
            notConfirmCertSyncDO.setCertId(certId);
            notConfirmCertSyncDO.setManageId(managerId);
            notConfirmCertSyncDO.setGmtCreate(new Date());
            this.certConfirmDao.insert(notConfirmCertSyncDO);
            return Result.success();
        }
        catch (Exception e) {
            throw new ServiceException("\u5411\u8c03\u5ea6\u4efb\u52a1\u540c\u6b65");
        }
    }

    public int deleteNoConfirmCertSync(Long userSignCertId, Long manageSignCertId) {
        try {
            return this.certStatusSyncDao.deleteNotConfirmCertSync(userSignCertId, manageSignCertId);
        }
        catch (Exception e) {
            throw new ServiceException("\u4ece30s\u8d85\u65f6\u65f6\u95f4\u8868\u4e2d\u5220\u9664\u6570\u636e\u65f6\u5f02\u5e38", (Throwable)e);
        }
    }

    private List<CertStatusSyncDO> buildSyncStatusCertList(Long signCertId, Long encCertId, Integer status, Integer type, Integer revokeReason, Date revokeDate) {
        CertStatusSyncDO signCertStatusSyncDo = new CertStatusSyncDO();
        CertStatusSyncDO encCertStatusSyncDo = new CertStatusSyncDO();
        Date nowTime = new Date();
        signCertStatusSyncDo.setStatus(status);
        signCertStatusSyncDo.setGmtCreate(revokeDate);
        signCertStatusSyncDo.setRevokeReason(revokeReason);
        switch (type) {
            case 1: {
                signCertStatusSyncDo.setCertId(signCertId);
                if (null == encCertId) break;
                encCertStatusSyncDo.setCertId(encCertId);
                break;
            }
            case 2: {
                signCertStatusSyncDo.setManageCertId(signCertId);
                if (null == encCertId) break;
                encCertStatusSyncDo.setManageCertId(encCertId);
                break;
            }
            case 3: {
                signCertStatusSyncDo.setCrossCertId(signCertId);
                break;
            }
            case 4: {
                signCertStatusSyncDo.setSubCertId(signCertId);
                break;
            }
            case 5: {
                signCertStatusSyncDo.setRootCertId(signCertId);
            }
            default: {
                this.logger.error("\u5411OCSP\u540c\u6b65\u6570\u636e\u8868\u4fdd\u5b58\u6570\u636e\u65f6type\u9519\u8bef");
            }
        }
        ArrayList<CertStatusSyncDO> list = new ArrayList<CertStatusSyncDO>();
        list.add(signCertStatusSyncDo);
        if (null != encCertId) {
            encCertStatusSyncDo.setStatus(status);
            encCertStatusSyncDo.setGmtCreate(nowTime);
            encCertStatusSyncDo.setRevokeReason(revokeReason);
            list.add(encCertStatusSyncDo);
        }
        return list;
    }
}

