/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.template;

import com.xdja.pki.ca.certmanager.dao.CertDao;
import com.xdja.pki.ca.certmanager.dao.RevokeCertDao;
import com.xdja.pki.ca.certmanager.dao.TemplateDao;
import com.xdja.pki.ca.certmanager.dao.models.CertDO;
import com.xdja.pki.ca.certmanager.dao.models.ExtensionDO;
import com.xdja.pki.ca.certmanager.dao.models.RevokedCertDO;
import com.xdja.pki.ca.certmanager.dao.models.TemplateDO;
import com.xdja.pki.ca.certmanager.dao.models.TemplateExtensionDO;
import com.xdja.pki.ca.certmanager.service.crltemplate.CrlTemplateService;
import com.xdja.pki.ca.certmanager.service.crltemplate.bean.CrlTemplateExtensionVO;
import com.xdja.pki.ca.certmanager.service.customizeExten.CustomizeExtenService;
import com.xdja.pki.ca.certmanager.service.customizeExten.bean.TemplateCustomizeExtensionVO;
import com.xdja.pki.ca.certmanager.service.template.TemplateService;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateCodeInfoVO;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateInfoVO;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateListVO;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateQueryVO;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.enums.KeyAlgEnum;
import com.xdja.pki.ca.core.enums.TemplateStatusEnum;
import com.xdja.pki.ca.core.enums.TemplateTypeEnum;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.DnUtil;
import com.xdja.pki.ca.core.util.TemplateCodeUtil;
import com.xdja.pki.ca.core.util.json.JsonUtils;
import com.xdja.pki.ca.securitymanager.dao.CaDao;
import com.xdja.pki.ca.securitymanager.dao.DicDao;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.ExtensionVO;
import com.xdja.pki.ca.securitymanager.service.vo.SignAlgTypeEnum;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TemplateServiceImpl
implements TemplateService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private TemplateDao templateDao;
    @Resource
    private DicDao dicDao;
    @Resource
    private CaDao caDao;
    @Resource
    CustomizeExtenService customizeExtenService;
    @Resource
    CrlTemplateService crlTemplateService;
    @Autowired
    RevokeCertDao revokeCertDao;
    @Autowired
    CertDao certDao;
    @Value(value="${template.user.validity}")
    private int userValidity;
    @Value(value="${template.ca.validity}")
    private int caValidity;
    @Value(value="${template.cross.validity}")
    private int crossValidity;

    public PageInfo queryTemplates(TemplateQueryVO query) {
        try {
            TemplateDO search = new TemplateDO();
            search.setKeyAlg(this.caDao.getCaInfo().getKeyAlg());
            BeanUtils.copyProperties((Object)query, (Object)search);
            PageInfo pageInfo = this.templateDao.queryTemplates(search, query.getPageNo(), query.getPageSize());
            if (!pageInfo.getDatas().isEmpty()) {
                Map<String, String> dics = this.getSignAlgDicByKeyAlg();
                ArrayList<TemplateListVO> list = new ArrayList<TemplateListVO>();
                TemplateListVO template = null;
                String signAlg = "";
                for (Object item : pageInfo.getDatas()) {
                    template = (TemplateListVO)item;
                    signAlg = dics.get(template.getSignAlg());
                    if (signAlg.equals(SignAlgTypeEnum.SHA1_WITH_RSA.algName)) {
                        signAlg = SignAlgTypeEnum.SHA1_WITH_RSA.viewAlgNsme;
                    }
                    template.setSignAlg(signAlg);
                    list.add(template);
                }
                pageInfo.setDatas(list);
            }
            return pageInfo;
        }
        catch (Exception e) {
            throw new ServiceException("\u5206\u9875\u67e5\u8be2\u6a21\u677f\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
    }

    public TemplateInfoVO getInnerTemplateByType(int type) {
        TemplateInfoVO info = null;
        try {
            int keyAlg = this.caDao.getCaInfo().getKeyAlg();
            TemplateDO template = this.templateDao.getTemplateByType(type, keyAlg);
            if (null != template) {
                Map extensions = this.templateDao.getExtensionsByCodes(TemplateDO.InnerTypeEnum.YES.value, new String[]{template.getCode()});
                info = new TemplateInfoVO();
                BeanUtils.copyProperties((Object)template, (Object)info);
                Map extension = (Map)extensions.get(template.getCode());
                if (null != extension) {
                    ArrayList<ExtensionVO> extensionList = new ArrayList<ExtensionVO>();
                    ExtensionVO extensionVO = null;
                    for (Map.Entry item : extension.entrySet()) {
                        extensionVO = new ExtensionVO();
                        extensionVO.setExtnId(((ExtensionDO)item.getKey()).getExtnId());
                        extensionVO.setName(((ExtensionDO)item.getKey()).getName());
                        extensionVO.setIsCritical(((TemplateExtensionDO)item.getValue()).getIsCritical());
                        extensionVO.setValue(((TemplateExtensionDO)item.getValue()).getValue());
                        extensionVO.setIsInput(((ExtensionDO)item.getKey()).getIsInput());
                        extensionList.add(extensionVO);
                    }
                    info.setExtensions(extensionList);
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u6839\u636e\u6a21\u677f\u7c7b\u578b\u83b7\u53d6\u5185\u7f6e\u6a21\u677f\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return info;
    }

    public TemplateInfoVO getInnerTemplateByCode(String code) {
        TemplateInfoVO info = null;
        try {
            List templates = this.templateDao.getTemplatesByCodes(true, new String[]{code});
            TemplateDO template = null;
            if (!templates.isEmpty() && null != (template = (TemplateDO)templates.get(0))) {
                Map extensions = this.templateDao.getExtensionsByCodes(TemplateDO.InnerTypeEnum.YES.value, new String[]{template.getCode()});
                info = new TemplateInfoVO();
                BeanUtils.copyProperties((Object)template, (Object)info);
                Map extension = (Map)extensions.get(template.getCode());
                if (null != extension) {
                    ArrayList<ExtensionVO> extensionList = new ArrayList<ExtensionVO>();
                    ExtensionVO extensionVO = null;
                    for (Map.Entry item : extension.entrySet()) {
                        extensionVO = new ExtensionVO();
                        extensionVO.setExtnId(((ExtensionDO)item.getKey()).getExtnId());
                        extensionVO.setName(((ExtensionDO)item.getKey()).getName());
                        extensionVO.setIsCritical(((TemplateExtensionDO)item.getValue()).getIsCritical());
                        extensionVO.setValue(((TemplateExtensionDO)item.getValue()).getValue());
                        extensionVO.setIsInput(((ExtensionDO)item.getKey()).getIsInput());
                        extensionList.add(extensionVO);
                    }
                    info.setExtensions(extensionList);
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u6839\u636e\u6a21\u677f\u7f16\u53f7\u83b7\u53d6\u5185\u7f6e\u6a21\u677f\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return info;
    }

    public List<Map<String, String>> getTemplatesByType(int type) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try {
            int keyAlg = this.caDao.getCaInfo().getKeyAlg();
            List templates = this.templateDao.getTemplatesByType(type, keyAlg);
            HashMap<String, String> templateInfo = null;
            for (TemplateDO item : templates) {
                templateInfo = new HashMap<String, String>();
                templateInfo.put("code", item.getCode());
                templateInfo.put("name", item.getName());
                result.add(templateInfo);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u6839\u636e\u6a21\u677f\u7c7b\u578b\u83b7\u53d6\u6a21\u677f\u4e0b\u62c9\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    public Map<String, TemplateInfoVO> getTemplatesByCodes(String ... codes) {
        HashMap<String, TemplateInfoVO> result = new HashMap<String, TemplateInfoVO>();
        try {
            ArrayList<ExtensionVO> extensionList = null;
            List templateList = this.templateDao.getTemplatesByCodes(codes);
            if (templateList.isEmpty()) {
                this.logger.info("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6a21\u677f\u4fe1\u606f====");
                return result;
            }
            Map extensions = this.templateDao.getExtensionsByCodes(TemplateDO.InnerTypeEnum.NO.value, codes);
            Map extension = null;
            TemplateInfoVO templateInfoVO = null;
            for (TemplateDO templateDO : templateList) {
                Result certCustomizeExtenInfoResult;
                templateInfoVO = new TemplateInfoVO();
                BeanUtils.copyProperties((Object)templateDO, (Object)templateInfoVO);
                templateInfoVO.setBaseDn(templateDO.getCustomizeDn());
                extensionList = new ArrayList<ExtensionVO>();
                ExtensionVO extensionVO = null;
                extension = (Map)extensions.get(templateDO.getCode());
                if (null != extension) {
                    for (Map.Entry entry : extension.entrySet()) {
                        extensionVO = new ExtensionVO();
                        extensionVO.setExtnId(((ExtensionDO)entry.getKey()).getExtnId());
                        extensionVO.setName(((ExtensionDO)entry.getKey()).getName());
                        extensionVO.setIsCritical(((TemplateExtensionDO)entry.getValue()).getIsCritical());
                        extensionVO.setValue(((TemplateExtensionDO)entry.getValue()).getValue());
                        extensionVO.setIsInput(((ExtensionDO)entry.getKey()).getIsInput());
                        extensionList.add(extensionVO);
                    }
                    templateInfoVO.setExtensions(extensionList);
                }
                if (!(certCustomizeExtenInfoResult = this.customizeExtenService.getCertCustomizeExtenInfo(templateDO.getId().longValue())).isSuccess()) {
                    this.logger.info("\u81ea\u5b9a\u4e49\u6269\u5c55\u9879\u83b7\u53d6\u5931\u8d25 === " + JsonUtils.object2Json((Object)certCustomizeExtenInfoResult));
                    continue;
                }
                List custonizeExtenInfoResultInfo = (List)certCustomizeExtenInfoResult.getInfo();
                templateInfoVO.setCustomizeExtens(custonizeExtenInfoResultInfo);
                result.put(templateInfoVO.getCode(), templateInfoVO);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u6839\u636e\u6a21\u677f\u7f16\u53f7\u6279\u91cf\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    public Result getTemplateByCode(String code) {
        try {
            TemplateInfoVO templateInfo = this.getTemplatesByCodes(code).get(code);
            if (null == templateInfo) {
                this.logger.error("\u6839\u636e\u6a21\u677f\u7f16\u53f7\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u4e0d\u5b58\u5728 [code={}]", (Object)code);
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
            }
            Map<String, String> dics = this.getSignAlgDicByKeyAlg();
            templateInfo.setSignAlg(templateInfo.getSignAlg());
            templateInfo.setSignAlgStr(dics.get(templateInfo.getSignAlg()));
            CaInfoVO caInfo = (CaInfoVO)Constants.CA_INFO.get(this.caDao.getCaInfo().getKeyAlg());
            templateInfo.setCaSignAlg(dics.get(caInfo.getSignAlg()));
            templateInfo.setCaSubject(CertUtil.getIssuerByX509Cert((X509Certificate)caInfo.getRootCert()));
            templateInfo.setShowOcsp(Boolean.valueOf(caInfo.isOcsp()));
            templateInfo.setShowLdap(Boolean.valueOf(caInfo.isLadp()));
            int pathLength = caInfo.getRootCert().getBasicConstraints();
            templateInfo.setCaPathLength(Integer.valueOf(pathLength == Integer.MAX_VALUE ? -2 : pathLength - 1));
            templateInfo.setUserValidity(Integer.valueOf(this.userValidity));
            templateInfo.setCaValidity(Integer.valueOf(this.caValidity));
            templateInfo.setCrossValidity(Integer.valueOf(this.crossValidity));
            templateInfo.setCertPatterm(templateInfo.getCertPatterm());
            return Result.success((Object)templateInfo);
        }
        catch (Exception e) {
            throw new ServiceException("\u6839\u636e\u6a21\u677f\u7f16\u53f7\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private Map<String, String> getSignAlgDicByKeyAlg() {
        HashMap<String, String> dics = new HashMap<String, String>();
        if (Constants.BASE_ALG_TYPE == KeyAlgEnum.SM2.value) {
            dics.putAll(this.dicDao.getDicsByParentCode("signAlg"));
        } else if (Constants.BASE_ALG_TYPE == KeyAlgEnum.RSA.value) {
            dics.putAll(this.dicDao.getDicsByParentCode("signAlgRsa"));
        } else {
            dics.putAll(this.dicDao.getDicsByParentCode("signAlgNist"));
        }
        return dics;
    }

    public Result saveTemplate(TemplateInfoVO info) {
        try {
            StringBuilder auditLog = new StringBuilder();
            String templateTypeDesc = TemplateTypeEnum.convert((int)info.getType().intValue()).desc;
            if (this.templateDao.checkTemplateNameExist(info.getName())) {
                this.logger.error("\u4fdd\u5b58\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728 [name={}]", (Object)info.getName());
                auditLog.append("\u4fdd\u5b58\u8bc1\u4e66\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u6a21\u677f\u7c7b\u578b=").append(templateTypeDesc).append("\uff0c\u6a21\u677f\u540d\u79f0=").append(info.getName());
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NAME_EXISTED).setAuditContent(auditLog.toString());
            }
            ArrayList<String> oids = new ArrayList<String>();
            if (!this.checkExtension(info.getType(), info.getExtensions(), oids)) {
                this.logger.error("\u4fdd\u5b58\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u7c7b\u578b\u4e0e\u6269\u5c55\u9879\u4e0d\u5339\u914d [{}]", (Object)info);
                auditLog.append("\u4fdd\u5b58\u8bc1\u4e66\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u7c7b\u578b\u4e0e\u6269\u5c55\u9879\u4e0d\u5339\u914d\uff0c\u6a21\u677f\u7c7b\u578b=").append(templateTypeDesc).append("\uff0c\u6a21\u677f\u540d\u79f0=").append(info.getName());
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_TYPE_AND_EXTENSION_MISMATCH).setAuditContent(auditLog.toString());
            }
            TemplateDO template = new TemplateDO();
            BeanUtils.copyProperties((Object)info, (Object)template);
            template.setCustomizeDn(DnUtil.getRFC4519X500Name((String)info.getBaseDn()).toString());
            template.setCode(TemplateCodeUtil.generate((long)this.templateDao.incrTemplateCode()));
            template.setCertPatterm(info.getCertPatterm());
            template.setIsInner(Integer.valueOf(TemplateDO.InnerTypeEnum.NO.value));
            template.setStatus(Integer.valueOf(TemplateStatusEnum.NOT_ENABLED.value));
            template.setGmtCreate(new Date());
            template.setCrlTempId(Long.valueOf(-1L));
            template.setIssuerDn(info.getCaSubject());
            template.setOpenCrl(Boolean.valueOf(false));
            TemplateDO templateDO = this.templateDao.saveTemplate(template);
            Map extensionIds = this.templateDao.getExtensionIdByOID(oids);
            ArrayList<TemplateExtensionDO> templateExtensions = new ArrayList<TemplateExtensionDO>();
            TemplateExtensionDO templateExtension = null;
            for (ExtensionVO item : info.getExtensions()) {
                templateExtension = new TemplateExtensionDO();
                templateExtension.setTemplateId(template.getId());
                templateExtension.setExtensionId((Long)extensionIds.get(item.getExtnId()));
                templateExtension.setIsCritical(item.getIsCritical());
                templateExtension.setValue(item.getValue());
                templateExtension.setGmtCreate(template.getGmtCreate());
                templateExtensions.add(templateExtension);
            }
            this.templateDao.saveTemplateExtensions(templateExtensions);
            List templateCustomizeExtensionVOList = info.getCustomizeExtens();
            if (templateCustomizeExtensionVOList != null && templateCustomizeExtensionVOList.size() != 0) {
                Result result = this.customizeExtenService.saveTempAndCustomizeExten(templateDO.getId().longValue(), templateCustomizeExtensionVOList);
                if (!result.isSuccess()) {
                    return Result.failure((ErrorEnum)result.getError());
                }
                for (TemplateCustomizeExtensionVO templateCustomizeExtensionVO : templateCustomizeExtensionVOList) {
                    Result custonizeExtenStatusByExtenId = this.customizeExtenService.getCustomizeExtenStatusByExtenId(templateCustomizeExtensionVO.getCustomizeExtenId().longValue());
                    if (!custonizeExtenStatusByExtenId.isSuccess() || (Integer)custonizeExtenStatusByExtenId.getInfo() != 0) continue;
                    this.customizeExtenService.updateCustomizeExtenStatus(templateCustomizeExtensionVO.getCustomizeExtenId().longValue(), 1);
                }
            }
            auditLog.append("\u4fdd\u5b58\u8bc1\u4e66\u6a21\u677f\u6210\u529f\uff0c\u6a21\u677f\u7c7b\u578b=").append(templateTypeDesc).append("\uff0c\u6a21\u677f\u7f16\u53f7=").append(template.getCode()).append("\uff0c\u6a21\u677f\u540d\u79f0=").append(info.getName());
            this.logger.info(auditLog.toString());
            return Result.success((String)auditLog.toString());
        }
        catch (Exception e) {
            throw new ServiceException("\u4fdd\u5b58\u6a21\u677f\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private boolean checkExtension(int type, List<ExtensionVO> extensions, List<String> oids) {
        ArrayList extensionList = new ArrayList();
        if (type == TemplateTypeEnum.USER.value) {
            extensionList.addAll(Constants.USER_TEMPLATE_EXTENSIONS);
        } else if (type == TemplateTypeEnum.CA.value) {
            extensionList.addAll(Constants.CA_TEMPLATE_EXTENSIONS);
        } else {
            extensionList.addAll(Constants.CROSS_TEMPLATE_EXTENSIONS);
        }
        for (ExtensionVO item : extensions) {
            if (!extensionList.contains(item.getExtnId())) {
                return false;
            }
            oids.add(item.getExtnId());
        }
        return true;
    }

    public Result updateTemplate(TemplateInfoVO info) {
        try {
            StringBuilder auditLog = new StringBuilder();
            List templates = this.templateDao.getTemplatesByCodes(new String[]{info.getCode()});
            String templateTypeDesc = TemplateTypeEnum.convert((int)info.getType().intValue()).desc;
            StringBuilder tempAuditLog = new StringBuilder();
            tempAuditLog.append("\u6a21\u677f\u7c7b\u578b=").append(templateTypeDesc).append("\uff0c\u6a21\u677f\u7f16\u53f7=").append(info.getCode()).append("\uff0c\u6a21\u677f\u540d\u79f0=").append(info.getName());
            if (templates.isEmpty()) {
                this.logger.error("\u66f4\u65b0\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u4e0d\u5b58\u5728 [code={}]", (Object)info.getCode());
                auditLog.append("\u66f4\u65b0\u8bc1\u4e66\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u4e0d\u5b58\u5728\uff0c").append((CharSequence)tempAuditLog);
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST).setAuditContent(auditLog.toString());
            }
            TemplateDO templateInfo = (TemplateDO)templates.get(0);
            if (!templateInfo.getName().equals(info.getName()) && this.templateDao.checkTemplateNameExist(info.getName())) {
                this.logger.error("\u66f4\u65b0\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728 [name={}]", (Object)info.getName());
                auditLog.append("\u66f4\u65b0\u8bc1\u4e66\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728\uff0c").append((CharSequence)tempAuditLog);
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NAME_EXISTED).setAuditContent(auditLog.toString());
            }
            if (templateInfo.getStatus() != TemplateStatusEnum.NOT_ENABLED.value) {
                this.logger.error("\u66f4\u65b0\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u975e\u672a\u542f\u7528\u6a21\u677f\u4e0d\u80fd\u4fee\u6539 [code={}]", (Object)info.getCode());
                auditLog.append("\u66f4\u65b0\u8bc1\u4e66\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u53ea\u5141\u8bb8\u4fee\u6539\u672a\u542f\u7528\u72b6\u6001\u7684\u6a21\u677f\uff0c").append((CharSequence)tempAuditLog);
                return Result.failure((ErrorEnum)ErrorEnum.NON_NOT_ENABLED_TEMPLATE_CANNOT_MODIFY).setAuditContent(auditLog.toString());
            }
            ArrayList<String> oids = new ArrayList<String>();
            if (!this.checkExtension(info.getType(), info.getExtensions(), oids)) {
                this.logger.error("\u66f4\u65b0\u6a21\u677f\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u7c7b\u578b\u4e0e\u6269\u5c55\u9879\u4e0d\u5339\u914d [{}]", (Object)info);
                auditLog.append("\u66f4\u65b0\u8bc1\u4e66\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u7c7b\u578b\u4e0e\u6269\u5c55\u9879\u4e0d\u5339\u914d\uff0c").append((CharSequence)tempAuditLog);
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_TYPE_AND_EXTENSION_MISMATCH).setAuditContent(auditLog.toString());
            }
            TemplateDO template = new TemplateDO();
            BeanUtils.copyProperties((Object)info, (Object)template);
            template.setId(templateInfo.getId());
            template.setIsInner(null);
            template.setStatus(null);
            template.setGmtCreate(null);
            template.setGmtModified(new Date());
            this.templateDao.updateTemplate(template);
            this.templateDao.deleteTemplateExtensionByTemplateId(template.getId().longValue());
            Map extensionIds = this.templateDao.getExtensionIdByOID(oids);
            ArrayList<TemplateExtensionDO> templateExtensions = new ArrayList<TemplateExtensionDO>();
            TemplateExtensionDO templateExtension = null;
            for (ExtensionVO item : info.getExtensions()) {
                templateExtension = new TemplateExtensionDO();
                templateExtension.setTemplateId(template.getId());
                templateExtension.setExtensionId((Long)extensionIds.get(item.getExtnId()));
                templateExtension.setIsCritical(item.getIsCritical());
                templateExtension.setValue(item.getValue());
                templateExtension.setGmtCreate(template.getGmtModified());
                templateExtensions.add(templateExtension);
            }
            this.templateDao.saveTemplateExtensions(templateExtensions);
            Result result = this.customizeExtenService.saveTempAndCustomizeExten(templateInfo.getId().longValue(), info.getCustomizeExtens());
            if (!result.isSuccess()) {
                return Result.failure((ErrorEnum)result.getError());
            }
            auditLog.append("\u66f4\u65b0\u8bc1\u4e66\u6a21\u677f\u6210\u529f\uff0c").append((CharSequence)tempAuditLog);
            this.logger.info(auditLog.toString());
            return Result.success((String)auditLog.toString());
        }
        catch (Exception e) {
            throw new ServiceException("\u66f4\u65b0\u6a21\u677f\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public Result updateTemplateStatus(String code, int status) {
        try {
            StringBuilder auditLog = new StringBuilder();
            List templates = this.templateDao.getTemplatesByCodes(new String[]{code});
            if (templates.isEmpty()) {
                this.logger.info("\u66f4\u65b0\u6a21\u677f\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u4e0d\u5b58\u5728 [code={},status={}]", (Object)code, (Object)status);
                auditLog.append("\u66f4\u65b0\u6a21\u677f\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u6a21\u677f\u7f16\u53f7=").append(code);
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST).setAuditContent(auditLog.toString());
            }
            TemplateDO tempTemplate = (TemplateDO)templates.get(0);
            String templateTypeDesc = TemplateTypeEnum.convert((int)tempTemplate.getType().intValue()).desc;
            StringBuilder tempLog = new StringBuilder();
            tempLog.append("\u6a21\u677f\u7c7b\u578b=").append(templateTypeDesc).append("\uff0c\u6a21\u677f\u7f16\u53f7=").append(code).append("\uff0c\u6a21\u677f\u540d\u79f0=").append(tempTemplate.getName());
            if (tempTemplate.getStatus() == TemplateStatusEnum.NOT_ENABLED.value && status == TemplateStatusEnum.DISABLED.value) {
                this.logger.info("\u66f4\u65b0\u6a21\u677f\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\uff1a \u672a\u542f\u7528\u6a21\u677f\u4e0d\u80fd\u505c\u7528[code={},status={}]", (Object)code, (Object)status);
                auditLog.append("\u66f4\u65b0\u6a21\u677f\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u542f\u7528\u6a21\u677f\u4e0d\u80fd\u505c\u7528\uff0c").append((CharSequence)tempLog);
                return Result.failure((ErrorEnum)ErrorEnum.NOT_ENABLED_TEMPLATE_CANNOT_DISABLE).setAuditContent(auditLog.toString());
            }
            if (tempTemplate.getStatus() == TemplateStatusEnum.DISABLED.value && status == TemplateStatusEnum.NORMAL.value) {
                this.logger.info("\u66f4\u65b0\u6a21\u677f\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\uff1a \u5df2\u505c\u7528\u6a21\u677f\u4e0d\u80fd\u542f\u7528[code={},status={}]", (Object)code, (Object)status);
                auditLog.append("\u66f4\u65b0\u6a21\u677f\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5df2\u505c\u7528\u6a21\u677f\u4e0d\u80fd\u542f\u7528\uff0c").append((CharSequence)tempLog);
                return Result.failure((ErrorEnum)ErrorEnum.DISABLED_TEMPLATE_NOT_ENABLE).setAuditContent(auditLog.toString());
            }
            if (status == tempTemplate.getStatus()) {
                this.logger.info("\u66f4\u65b0\u6a21\u677f\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\uff1a \u91cd\u590d\u66f4\u65b0\u6a21\u677f\u72b6\u6001[code={},status={}]", (Object)code, (Object)status);
                auditLog.append("\u66f4\u65b0\u6a21\u677f\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u91cd\u590d\u66f4\u65b0\u6a21\u677f\u72b6\u6001\uff0c").append((CharSequence)tempLog);
                return Result.failure((ErrorEnum)ErrorEnum.REPEATED_UPDATE_TEMPLATE_STATUS).setAuditContent(auditLog.toString());
            }
            TemplateDO template = new TemplateDO();
            template.setId(((TemplateDO)templates.get(0)).getId());
            template.setStatus(Integer.valueOf(status));
            template.setIsInner(Integer.valueOf(TemplateDO.InnerTypeEnum.NO.value));
            template.setGmtModified(new Date());
            template.setOpenCrl(((TemplateDO)templates.get(0)).getOpenCrl());
            this.templateDao.updateTemplate(template);
            auditLog.append("\u66f4\u65b0\u6a21\u677f\u72b6\u6001\u6210\u529f\uff0c").append((CharSequence)tempLog);
            this.logger.info(auditLog.toString());
            return Result.success((String)auditLog.toString());
        }
        catch (Exception e) {
            throw new ServiceException("\u66f4\u65b0\u6a21\u677f\u72b6\u6001\u5931\u8d25", (Throwable)e);
        }
    }

    public Result deleteTemplate(String code) {
        try {
            StringBuilder auditLog = new StringBuilder();
            List templates = this.templateDao.getTemplatesByCodes(new String[]{code});
            if (templates.isEmpty()) {
                this.logger.info("\u5220\u9664\u8bc1\u4e66\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u4e0d\u5b58\u5728 [code={}]", (Object)code);
                auditLog.append("\u5220\u9664\u8bc1\u4e66\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u6a21\u677f\u7f16\u53f7=").append(code);
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST).setAuditContent(auditLog.toString());
            }
            TemplateDO template = (TemplateDO)templates.get(0);
            String templateTypeDesc = TemplateTypeEnum.convert((int)template.getType().intValue()).desc;
            if (template.getStatus() != TemplateStatusEnum.NOT_ENABLED.value) {
                this.logger.info("\u5220\u9664\u8bc1\u4e66\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u975e\u672a\u542f\u7528\u6a21\u677f\u4e0d\u80fd\u5220\u9664[code={}]", (Object)code);
                auditLog.append("\u5220\u9664\u8bc1\u4e66\u6a21\u677f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u975e\u672a\u542f\u7528\u6a21\u677f\u4e0d\u80fd\u5220\u9664\uff0c\u6a21\u677f\u7c7b\u578b=").append(templateTypeDesc).append("\uff0c\u6a21\u677f\u7f16\u53f7=").append(code).append("\uff0c\u6a21\u677f\u540d\u79f0=").append(template.getName());
                return Result.failure((ErrorEnum)ErrorEnum.NON_NOT_ENABLED_TEMPLATE_CANNOT_DELETE).setAuditContent(auditLog.toString());
            }
            this.templateDao.deleteTemplate(template.getId().longValue());
            this.customizeExtenService.deleteCertCustomizeExtenInfo(template.getId().longValue());
            auditLog.append("\u5220\u9664\u8bc1\u4e66\u6a21\u677f\u6210\u529f\uff0c\u6a21\u677f\u7c7b\u578b=").append(templateTypeDesc).append("\uff0c\u6a21\u677f\u7f16\u53f7=").append(code).append("\uff0c\u6a21\u677f\u540d\u79f0=").append(template.getName());
            this.logger.info(auditLog.toString());
            return Result.success((String)auditLog.toString());
        }
        catch (Exception e) {
            throw new ServiceException("\u5220\u9664\u8bc1\u4e66\u6a21\u677f\u5931\u8d25", (Throwable)e);
        }
    }

    public TemplateCodeInfoVO generateTemplateCode() {
        try {
            Map<String, String> dics = this.getSignAlgDicByKeyAlg();
            CaInfoVO caInfo = (CaInfoVO)Constants.CA_INFO.get(this.caDao.getCaInfo().getKeyAlg());
            TemplateCodeInfoVO templateCodeInfoVO = new TemplateCodeInfoVO();
            templateCodeInfoVO.setUserValidity(Integer.valueOf(this.userValidity));
            templateCodeInfoVO.setCaValidity(Integer.valueOf(this.caValidity));
            templateCodeInfoVO.setCrossValidity(Integer.valueOf(this.crossValidity));
            templateCodeInfoVO.setCaSignAlg(dics.get(caInfo.getSignAlg()));
            templateCodeInfoVO.setCaSubject(CertUtil.getIssuerByX509Cert((X509Certificate)caInfo.getRootCert()));
            templateCodeInfoVO.setShowOcsp(Boolean.valueOf(caInfo.isOcsp()));
            templateCodeInfoVO.setShowLdap(Boolean.valueOf(caInfo.isLadp()));
            int pathLength = caInfo.getRootCert().getBasicConstraints();
            templateCodeInfoVO.setCaPathLength(Integer.valueOf(pathLength == Integer.MAX_VALUE ? -2 : pathLength - 1));
            Result custonizeExtenResult = this.customizeExtenService.queryCustomizeExten();
            if (custonizeExtenResult.isSuccess()) {
                templateCodeInfoVO.setCustomizeExtenVOList((List)custonizeExtenResult.getInfo());
            }
            return templateCodeInfoVO;
        }
        catch (Exception e) {
            throw new ServiceException("\u751f\u6210\u6a21\u677f\u7f16\u53f7\u5931\u8d25", (Throwable)e);
        }
    }

    public Result linkCrlTemplate(long certTempId, long crlTempId) {
        Result result = new Result();
        StringBuilder auditLog = new StringBuilder();
        Integer crlTemplateStatus = this.crlTemplateService.getCrlTemplateStatus(Long.valueOf(crlTempId));
        if (crlTemplateStatus == 0 && !(result = this.crlTemplateService.updateCrlTemplateStatus(Long.valueOf(crlTempId))).isSuccess()) {
            auditLog.append("\u8bc1\u4e66\u6a21\u677f\u5173\u8054CRL\u6a21\u677f\u5931\u8d25\uff0c\u8bc1\u4e66\u6a21\u677fId=").append(certTempId).append(", CRL\u6a21\u677fId=").append(crlTempId).append(",\u5931\u8d25\u539f\u56e0=").append(result.getError().desc);
            result.setAuditContent(auditLog.toString());
            return result;
        }
        int isOk = this.templateDao.updateLinkCrlTemplate(certTempId, crlTempId);
        if (isOk != 1) {
            this.logger.info("\u8bc1\u4e66\u6a21\u677f\u5173\u8054CRL\u6a21\u677f\u5931\u8d25");
            result.setError(ErrorEnum.LINK_CRL_TEMP_ERROR);
            auditLog.append("\u8bc1\u4e66\u6a21\u677f\u5173\u8054CRL\u6a21\u677f\u5931\u8d25\uff0c\u8bc1\u4e66\u6a21\u677fId=").append(certTempId).append(", CRL\u6a21\u677fId=").append(crlTempId).append(",\u5931\u8d25\u539f\u56e0=").append(ErrorEnum.LINK_CRL_TEMP_ERROR.desc);
            result.setAuditContent(auditLog.toString());
            return result;
        }
        Result crlTemplateByIdResult = this.crlTemplateService.getCrlTemplateById(Long.valueOf(crlTempId));
        if (!crlTemplateByIdResult.isSuccess()) {
            auditLog.append("\u8bc1\u4e66\u6a21\u677f\u5173\u8054CRL\u6a21\u677f\u5931\u8d25\uff0c\u8bc1\u4e66\u6a21\u677fId=").append(certTempId).append(", CRL\u6a21\u677fId=").append(crlTempId).append(",\u5931\u8d25\u539f\u56e0=").append(crlTemplateByIdResult.getError().desc);
            result.setAuditContent(auditLog.toString());
            return crlTemplateByIdResult;
        }
        CrlTemplateExtensionVO crlTemplate = (CrlTemplateExtensionVO)crlTemplateByIdResult.getInfo();
        List certDOS = this.certDao.getCertsByTemplateId(certTempId);
        for (CertDO certDO : certDOS) {
            this.logger.info("=======certDO>>>>crlTemplate.getCrlConfig().getCertCount()===========" + crlTemplate.getCrlConfig().getCertCount() + " ========== " + crlTemplate.getCrlConfig().getCrlMaxCertNumber().intValue());
            int segmentNo = crlTemplate.getCrlConfig().getCertCount() / crlTemplate.getCrlConfig().getCrlMaxCertNumber().intValue();
            this.certDao.updateCertCrlTempIdAndSegmentNo(certDO.getId().longValue(), crlTempId, segmentNo);
            this.crlTemplateService.increamCertCount(Long.valueOf(crlTempId));
        }
        List revokedCertDOS = this.revokeCertDao.getCertsByTemplateId(certTempId);
        for (RevokedCertDO revokedCertDO : revokedCertDOS) {
            this.logger.info("=======revokedCertDO>>>> crlTemplate.getCrlConfig().getCertCount()===========" + crlTemplate.getCrlConfig().getCertCount() + " ========== " + crlTemplate.getCrlConfig().getCrlMaxCertNumber().intValue());
            int segmentNo = crlTemplate.getCrlConfig().getCertCount() / crlTemplate.getCrlConfig().getCrlMaxCertNumber().intValue();
            this.revokeCertDao.updateCertCrlTempIdAndSegmentNo(revokedCertDO.getId().longValue(), crlTempId, segmentNo);
            this.crlTemplateService.increamCertCount(Long.valueOf(crlTempId));
        }
        auditLog.append("\u8bc1\u4e66\u6a21\u677f\u5173\u8054CRL\u6a21\u677f\u6210\u529f\uff0c\u8bc1\u4e66\u6a21\u677fId=").append(certTempId).append(", CRL\u6a21\u677fId=").append(crlTempId);
        result.setAuditContent(auditLog.toString());
        return result;
    }
}

