/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.usercert;

import com.xdja.pki.ca.certmanager.dao.CertDao;
import com.xdja.pki.ca.certmanager.service.usercert.IUserCertManageService;
import com.xdja.pki.ca.certmanager.service.usercert.bean.UserCaCertVO;
import com.xdja.pki.ca.certmanager.service.usercert.bean.UserCertQueryVO;
import com.xdja.pki.ca.certmanager.service.util.DicDataConverUtil;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.time.DateTimeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.nutz.dao.pager.Pager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserCertManageServiceImpl
implements IUserCertManageService {
    @Resource
    private CertDao certDao;
    @Autowired
    private DicDataConverUtil dicDataConverUtil;

    public Result getUserCertList(UserCertQueryVO userCertQueryVO) {
        Pager pager = new Pager(userCertQueryVO.getPageNo(), userCertQueryVO.getPageSize());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("raName", userCertQueryVO.getRaName());
        param.put("certDn", userCertQueryVO.getCertDn());
        param.put("sn", userCertQueryVO.getSn());
        param.put("status", userCertQueryVO.getStatus());
        PageInfo pageInfo = null;
        ArrayList<UserCaCertVO> userCertList = new ArrayList<UserCaCertVO>();
        try {
            pageInfo = this.certDao.getUserCertLists(param, pager);
            Collection datas = pageInfo.getDatas();
            if (!datas.isEmpty()) {
                for (Object item : datas) {
                    Map dataMap = (Map)item;
                    UserCaCertVO userCaCertVO = new UserCaCertVO();
                    Integer status = Integer.valueOf(String.valueOf(dataMap.get("status")));
                    userCaCertVO.setRaName((String)dataMap.get("raname"));
                    userCaCertVO.setCertDn((String)dataMap.get("subject"));
                    userCaCertVO.setTemplateName((String)dataMap.get("tempname"));
                    userCaCertVO.setSignSn((String)dataMap.get("sn"));
                    userCaCertVO.setEncSn((String)dataMap.get("pair_cert_sn"));
                    userCaCertVO.setStatus(status);
                    userCaCertVO.setStatusStr(this.dicDataConverUtil.ConverStatusToStr(status));
                    userCaCertVO.setNotBeforeTime(DateTimeUtil.dateToWebStr((Date)((Date)dataMap.get("before_time"))));
                    userCaCertVO.setNotAfterTime(DateTimeUtil.dateToWebStr((Date)((Date)dataMap.get("after_time"))));
                    if (null == dataMap.get("gmt_modified")) {
                        userCaCertVO.setOperatorTime(DateTimeUtil.dateToWebStr((Date)((Date)dataMap.get("gmt_create"))));
                    } else {
                        userCaCertVO.setOperatorTime(DateTimeUtil.dateToWebStr((Date)((Date)dataMap.get("gmt_modified"))));
                    }
                    userCaCertVO.setType((Integer)dataMap.get("type"));
                    userCertList.add(userCaCertVO);
                }
                pageInfo.setDatas(userCertList);
            }
        }
        catch (DAOException e) {
            throw new ServiceException("\u67e5\u8be2RA\u5217\u8868\u670d\u52a1\u5f02\u67e5\u8be2\u7528\u6237\u8bc1\u4e66\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
        }
        return Result.success((Object)pageInfo);
    }
}

