/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.util;

import com.xdja.pki.ca.certmanager.dao.models.CustomizeExtensionDO;
import com.xdja.pki.ca.certmanager.service.util.CertExtendNameFinder;
import com.xdja.pki.ca.certmanager.service.util.GeneralNameFinder;
import com.xdja.pki.ca.certmanager.service.util.IdentifyCodeEnum;
import com.xdja.pki.ca.core.ca.util.gm.IdentifyCode;
import com.xdja.pki.ca.core.ca.util.gm.SM2Extensions;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.util.DnUtil;
import com.xdja.pki.ca.core.util.time.DateTimeUtil;
import com.xdja.pki.ca.securitymanager.service.vo.SignAlgTypeEnum;
import com.xdja.pki.gmssl.asn1.x509.SubjectInformationAccess;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.PKIXNameConstraintValidator;
import org.bouncycastle.asn1.x509.PolicyConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyMappings;
import org.bouncycastle.asn1.x509.PolicyQualifierId;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.bouncycastle.asn1.x509.PrivateKeyUsagePeriod;
import org.bouncycastle.asn1.x509.SubjectDirectoryAttributes;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class CertContentInfoUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SIGN_ALG_NAME_SM3WITHSM2 = "SM3WithSM2";
    @Autowired
    private Environment env;

    public Map<String, Object> getCertContentInfo(X509Certificate certificate, List<CustomizeExtensionDO> allUsedCustomizeExten) throws Exception {
        JcaX509CertificateHolder certificateHoder;
        Extensions extensions;
        boolean[] subjectUniqueID;
        HashMap<String, Object> certContentInfo = new HashMap<String, Object>();
        HashMap<String, Object> extendsInfo = new HashMap<String, Object>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int version = certificate.getVersion();
        certContentInfo.put("version", "V" + String.valueOf(version));
        String serialNumber = certificate.getSerialNumber().toString(16);
        certContentInfo.put("sn", serialNumber);
        String sigAlgName = certificate.getSigAlgName();
        String sigAlgOID = certificate.getSigAlgOID();
        String sm3withsm2OID = GMObjectIdentifiers.sm2sign_with_sm3.getId();
        sigAlgName = sigAlgOID.equals(sm3withsm2OID) ? SIGN_ALG_NAME_SM3WITHSM2 : SignAlgTypeEnum.getViewAlgValue((String)certificate.getSigAlgName());
        certContentInfo.put("sigAlgName", sigAlgName);
        String issuerDN = CertUtil.getIssuerByX509Cert((X509Certificate)certificate);
        certContentInfo.put("issuer", issuerDN);
        String subjectname = CertUtil.getSubjectByX509Cert((X509Certificate)certificate);
        certContentInfo.put("subject", subjectname);
        String notBefore = simpleDateFormat.format(certificate.getNotBefore());
        certContentInfo.put("notbefore", notBefore);
        String notAfter = simpleDateFormat.format(certificate.getNotAfter());
        certContentInfo.put("notafter", notAfter);
        SubjectPublicKeyInfo subPubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)certificate.getPublicKey().getEncoded());
        certContentInfo.put("subjectPublicKeyInfo", Strings.fromByteArray((byte[])Hex.encode((byte[])subPubKeyInfo.getEncoded())));
        boolean[] issuerUniqueID = certificate.getIssuerUniqueID();
        if (null != issuerUniqueID) {
            certContentInfo.put("issueUniqueId", this.booleanToBitString(issuerUniqueID).toString());
        }
        if (null != (subjectUniqueID = certificate.getSubjectUniqueID())) {
            certContentInfo.put("subjectUniqueId", this.booleanToBitString(subjectUniqueID).toString());
        }
        if (null != (extensions = (certificateHoder = new JcaX509CertificateHolder(certificate)).getExtensions())) {
            List<String> extendedKeyUsages;
            this.getAuthorityKeyIdentifier(extendsInfo, extensions);
            this.getSubjectKeyIdentifier(extendsInfo, extensions);
            List<String> usages = this.getKeyUsage(certificate.getKeyUsage());
            if (null != usages) {
                extendsInfo.put("keyUsage", usages.toString());
            }
            if (null != (extendedKeyUsages = this.getExtendedKeyUsages(certificate.getExtendedKeyUsage()))) {
                extendsInfo.put("extendedKeyUsage", extendedKeyUsages.toString());
            }
            this.getPrivateKeyUsagePeriod(extendsInfo, extensions);
            this.getcertificatePolicies(extendsInfo, extensions);
            this.getPolicyMapping(extendsInfo, extensions);
            this.getSubjectAltName(extendsInfo, certificate);
            this.getSubjectDirectoryAttributes(extendsInfo, extensions);
            this.getIssuerAltName(extendsInfo, certificate);
            this.getBasicConstraints(extendsInfo, extensions);
            this.getNameConstraints(extendsInfo, extensions);
            this.getPolicyConstraints(extendsInfo, extensions);
            this.getInhibitAnyPolicy(extendsInfo, extensions);
            this.getCRLDistPoint(extendsInfo, extensions);
            this.getFreshestCRL(extendsInfo, extensions);
            this.getAuthorityInfoAccess(extendsInfo, extensions);
            this.getSubjectInformationAccess(extendsInfo, extensions);
            this.getIdentifyCode(extendsInfo, extensions);
            this.getInsuranceNumber(extendsInfo, extensions);
            this.getICRegistrationNumber(extendsInfo, extensions);
            this.getOrganizationCode(extendsInfo, extensions);
            this.getTaxationNumber(extendsInfo, extensions);
        }
        certContentInfo.put("extendsInfo", extendsInfo);
        if (allUsedCustomizeExten != null && allUsedCustomizeExten.size() != 0) {
            HashMap<String, String> customizeExtendsInfo = new HashMap<String, String>();
            Enumeration oids = extensions.oids();
            while (oids.hasMoreElements()) {
                String oid = ((ASN1ObjectIdentifier)oids.nextElement()).getId();
                for (CustomizeExtensionDO customizeExtensionDO : allUsedCustomizeExten) {
                    if (!oid.equalsIgnoreCase(customizeExtensionDO.getCustomizeExtenOid())) continue;
                    byte[] octets = extensions.getExtension(new ASN1ObjectIdentifier(oid)).getExtnValue().getOctets();
                    String extenValue = CertContentInfoUtil.convertExtenValueByEncodeType(customizeExtensionDO.getEncodeType(), octets);
                    customizeExtendsInfo.put(customizeExtensionDO.getCustomizeExtenName(), extenValue);
                }
            }
            certContentInfo.put("customizeExtendsInfo", customizeExtendsInfo);
        }
        return certContentInfo;
    }

    private static String convertExtenValueByEncodeType(int encodeType, byte[] parsedValue) {
        String encodeValue = null;
        switch (encodeType) {
            case 1: {
                encodeValue = new DERPrintableString(new String(parsedValue)).toString().trim();
                break;
            }
            case 2: {
                encodeValue = new DERIA5String(new String(parsedValue)).toString().trim();
                break;
            }
            case 3: {
                encodeValue = new DERBoolean(new String(parsedValue).equalsIgnoreCase("true")).toString().trim();
                break;
            }
            case 4: {
                Long aLong = Long.valueOf(new String(parsedValue).trim());
                encodeValue = new DERInteger(aLong.longValue()).toString();
                break;
            }
            case 5: 
            case 6: {
                encodeValue = new DERUTF8String(new String(parsedValue)).getString().trim();
                break;
            }
        }
        return encodeValue;
    }

    private void getAuthorityKeyIdentifier(Map<String, Object> extendsInfo, Extensions extensions) {
        AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.fromExtensions((Extensions)extensions);
        if (null != authorityKeyIdentifier) {
            GeneralNames authorityCertIssuer;
            ArrayList<String> authorityKeyIdentifierList = new ArrayList<String>();
            String extendName = CertExtendNameFinder.getExtendName(Extension.authorityKeyIdentifier);
            if (null != authorityKeyIdentifier.getKeyIdentifier()) {
                authorityKeyIdentifierList.add("KeyID=" + Strings.fromByteArray((byte[])Hex.encode((byte[])authorityKeyIdentifier.getKeyIdentifier())));
            }
            if (null != (authorityCertIssuer = authorityKeyIdentifier.getAuthorityCertIssuer())) {
                GeneralName[] names = authorityCertIssuer.getNames();
                StringBuffer stringbuffer = new StringBuffer();
                for (GeneralName gneralname : names) {
                    Integer tag = gneralname.getTagNo();
                    ASN1Encodable name = gneralname.getName();
                    X500Name x500Name = DnUtil.getRFC4519X500Name((ASN1Encodable)name);
                    X500Principal x500Principal = null;
                    try {
                        x500Principal = new X500Principal(x500Name.getEncoded());
                    }
                    catch (IOException e) {
                        this.logger.error("x500Principal\u8f6c\u6362\u5f02\u5e38\uff0c", (Throwable)e);
                    }
                    String generalName = GeneralNameFinder.getGeneralName(tag);
                    stringbuffer.append(generalName + "=" + x500Principal.getName() + ",");
                }
                authorityKeyIdentifierList.add("Certificate Issuer:" + DnUtil.deCodeDn((String)stringbuffer.deleteCharAt(stringbuffer.length() - 1).toString()));
            }
            if (null != authorityKeyIdentifier.getAuthorityCertSerialNumber()) {
                BigInteger authorityCertSerialNumber = authorityKeyIdentifier.getAuthorityCertSerialNumber();
                authorityKeyIdentifierList.add("Certificate SerialNumber=" + authorityCertSerialNumber.toString(16));
            }
            extendsInfo.put(extendName, ((Object)authorityKeyIdentifierList).toString());
        }
    }

    private void getSubjectKeyIdentifier(Map<String, Object> extendsInfo, Extensions extensions) {
        SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.fromExtensions((Extensions)extensions);
        if (null != subjectKeyIdentifier) {
            String extendName = CertExtendNameFinder.getExtendName(Extension.subjectKeyIdentifier);
            System.out.println("subjectKeyIdentifier" + Strings.fromByteArray((byte[])Hex.encode((byte[])subjectKeyIdentifier.getKeyIdentifier())));
            extendsInfo.put(extendName, Strings.fromByteArray((byte[])Hex.encode((byte[])subjectKeyIdentifier.getKeyIdentifier())));
        }
    }

    private void getPrivateKeyUsagePeriod(Map<String, Object> extendsInfo, Extensions extensions) {
        String extendName = CertExtendNameFinder.getExtendName(Extension.privateKeyUsagePeriod);
        ASN1Encodable extvalue = extensions.getExtensionParsedValue(Extension.privateKeyUsagePeriod);
        PrivateKeyUsagePeriod privateKeyUsagePeriod = null;
        if (extvalue != null) {
            privateKeyUsagePeriod = PrivateKeyUsagePeriod.getInstance((Object)extvalue);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
            try {
                String notBefore = simpleDateFormat.format(privateKeyUsagePeriod.getNotBefore().getDate());
                String notAfter = simpleDateFormat.format(privateKeyUsagePeriod.getNotAfter().getDate());
                String privkeyPeriod = "\u79c1\u94a5\u4f7f\u7528\u5468\u671f\u4ece  " + notBefore + "\u5230 " + notAfter;
                System.out.println(privkeyPeriod);
                extendsInfo.put(extendName, privkeyPeriod);
            }
            catch (ParseException e) {
                this.logger.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff0c", (Throwable)e);
            }
        }
    }

    private void getcertificatePolicies(Map<String, Object> extendsInfo, Extensions extensions) {
        CertificatePolicies certificatePolicies = CertificatePolicies.fromExtensions((Extensions)extensions);
        if (null != certificatePolicies) {
            PolicyInformation[] policyInformations;
            StringBuffer stbuf = new StringBuffer();
            String extendName = CertExtendNameFinder.getExtendName(Extension.certificatePolicies);
            for (PolicyInformation policyInformation : policyInformations = certificatePolicies.getPolicyInformation()) {
                stbuf.append("Policy Identifier=");
                ASN1ObjectIdentifier policyIdentifier = policyInformation.getPolicyIdentifier();
                stbuf.append(policyIdentifier.toString());
                ASN1Sequence policyQualifiers = policyInformation.getPolicyQualifiers();
                if (null == policyQualifiers) continue;
                stbuf.append("\r\n [");
                String prefix = ", ";
                for (int i = 0; i < policyQualifiers.size(); ++i) {
                    stbuf.append("Policy Qualifier Info:");
                    ASN1Encodable policyQualifier = policyQualifiers.getObjectAt(i);
                    PolicyQualifierInfo policyQualifierInfo = PolicyQualifierInfo.getInstance((Object)policyQualifier);
                    ASN1ObjectIdentifier policyQualifierId = policyQualifierInfo.getPolicyQualifierId();
                    ASN1Encodable qualifier = policyQualifierInfo.getQualifier();
                    if (null != policyQualifierId) {
                        if (PolicyQualifierId.id_qt_cps.equals((Object)policyQualifierId)) {
                            stbuf.append("Policy Qualifier Id=CPS");
                            if (null != qualifier) {
                                stbuf.append(",Qualifier:");
                                stbuf.append(qualifier.toString());
                            }
                        } else if (PolicyQualifierId.id_qt_unotice.equals((Object)policyQualifierId)) {
                            stbuf.append("Policy Qualifier Id=UNOTICE");
                            if (null != qualifier) {
                                stbuf.append(",Qualifier:Notice Text=");
                                stbuf.append(qualifier.toString());
                            }
                        }
                    }
                    stbuf.append(prefix);
                }
                stbuf.deleteCharAt(stbuf.length() - prefix.length());
                stbuf.append("]");
                stbuf.append(" \r\n");
            }
            extendsInfo.put(extendName, stbuf.toString());
        }
    }

    private void getPolicyMapping(Map<String, Object> extendsInfo, Extensions extensions) {
        ASN1Sequence asn1Sequence;
        ASN1Primitive policyMappingsPrimitive;
        ASN1Encodable extensionParsedValue = extensions.getExtensionParsedValue(Extension.policyMappings);
        PolicyMappings policyMappings = PolicyMappings.getInstance((Object)extensionParsedValue);
        if (null != policyMappings && (policyMappingsPrimitive = policyMappings.toASN1Primitive()) instanceof ASN1Sequence && null != (asn1Sequence = (ASN1Sequence)policyMappingsPrimitive)) {
            String extendName = CertExtendNameFinder.getExtendName(Extension.policyMappings);
            ArrayList policyMappList = new ArrayList();
            for (int i = 0; i < asn1Sequence.size(); ++i) {
                ASN1Encodable asn1enable = asn1Sequence.getObjectAt(i);
                ASN1Primitive asn1Primitive = asn1enable.toASN1Primitive();
                if (!(asn1Primitive instanceof DLSequence)) continue;
                HashMap<String, String> parm = new HashMap<String, String>();
                ASN1Sequence policyMappingsSequence = (ASN1Sequence)asn1Primitive;
                parm.put("Issuer Domain", policyMappingsSequence.getObjectAt(0).toASN1Primitive().toString());
                parm.put("Subject Domain", policyMappingsSequence.getObjectAt(1).toASN1Primitive().toString());
                policyMappList.add(parm);
            }
            extendsInfo.put(extendName, ((Object)policyMappList).toString());
        }
    }

    private void getSubjectAltName(Map<String, Object> extendsInfo, X509Certificate certificate) throws CertificateParsingException {
        Collection<List<?>> subjectAlternativeNames = certificate.getSubjectAlternativeNames();
        if (null != subjectAlternativeNames && !subjectAlternativeNames.isEmpty()) {
            String extendName = CertExtendNameFinder.getExtendName(Extension.subjectAlternativeName);
            List<String> subjectAltNameList = this.getGeneralNameList(subjectAlternativeNames);
            extendsInfo.put(extendName, subjectAltNameList.toString());
        }
    }

    private void getSubjectDirectoryAttributes(Map<String, Object> extendsInfo, Extensions extensions) throws UnsupportedEncodingException {
        Vector attributes;
        ASN1Encodable extensionParsedValue = extensions.getExtensionParsedValue(Extension.subjectDirectoryAttributes);
        SubjectDirectoryAttributes subjectDirectoryAttributes = SubjectDirectoryAttributes.getInstance((Object)extensionParsedValue);
        if (null != subjectDirectoryAttributes && !(attributes = subjectDirectoryAttributes.getAttributes()).isEmpty()) {
            String extendName = CertExtendNameFinder.getExtendName(Extension.subjectDirectoryAttributes);
            StringBuffer strbf = new StringBuffer();
            String prefix = ", ";
            strbf.append("[");
            for (int i = 0; i < attributes.size(); ++i) {
                DERPrintableString dERPrintableString;
                ASN1OctetString octeString;
                ASN1Encodable aSN1Encodable;
                Attribute attribute = (Attribute)attributes.get(i);
                ASN1Set set = attribute.getAttrValues();
                String attributeId = attribute.getAttrType().getId();
                if (attributeId.equals(BCStyle.DATE_OF_BIRTH.getId())) {
                    ASN1GeneralizedTime time = ASN1GeneralizedTime.getInstance((Object)set.getObjectAt(0));
                    Date date = null;
                    try {
                        date = time.getDate();
                    }
                    catch (ParseException e) {
                        this.logger.error("gmt\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff0c", (Throwable)e);
                        continue;
                    }
                    String dateStr = DateTimeUtil.dateToWebStr((Date)date);
                    strbf.append("dateOfBirth=" + dateStr + prefix);
                    continue;
                }
                if (attributeId.equals(BCStyle.T.getId())) {
                    aSN1Encodable = set.getObjectAt(0);
                    octeString = null;
                    String tile = null;
                    if (aSN1Encodable instanceof DEROctetString) {
                        octeString = DEROctetString.getInstance((Object)aSN1Encodable);
                        tile = new String(octeString.getOctets(), "UTF-8");
                    } else if (aSN1Encodable instanceof DERPrintableString) {
                        dERPrintableString = DERPrintableString.getInstance((Object)aSN1Encodable);
                        tile = dERPrintableString.toString();
                    }
                    strbf.append("Title=" + tile + prefix);
                    continue;
                }
                aSN1Encodable = set.getObjectAt(0);
                octeString = null;
                String value = null;
                if (aSN1Encodable instanceof DEROctetString) {
                    octeString = DEROctetString.getInstance((Object)aSN1Encodable);
                    value = new String(octeString.getOctets(), "UTF-8");
                } else if (aSN1Encodable instanceof DERPrintableString) {
                    dERPrintableString = DERPrintableString.getInstance((Object)aSN1Encodable);
                    value = dERPrintableString.toString();
                }
                String oidToDisplayName = BCStyle.INSTANCE.oidToDisplayName(attribute.getAttrType());
                strbf.append(oidToDisplayName + "=" + value + prefix);
            }
            strbf.deleteCharAt(strbf.length() - prefix.length());
            strbf.append("]");
            extendsInfo.put(extendName, strbf.toString());
        }
    }

    private void getIssuerAltName(Map<String, Object> extendsInfo, X509Certificate certificate) throws CertificateParsingException {
        Collection<List<?>> issuerAlternativeNames = certificate.getIssuerAlternativeNames();
        if (null != issuerAlternativeNames && !issuerAlternativeNames.isEmpty()) {
            String extendName = CertExtendNameFinder.getExtendName(Extension.issuerAlternativeName);
            List<String> issuerAltNameList = this.getGeneralNameList(issuerAlternativeNames);
            extendsInfo.put(extendName, issuerAltNameList.toString());
        }
    }

    private void getBasicConstraints(Map<String, Object> extendsInfo, Extensions extensions) {
        BasicConstraints basicConstraints = BasicConstraints.fromExtensions((Extensions)extensions);
        if (null != basicConstraints) {
            String extendName = CertExtendNameFinder.getExtendName(Extension.basicConstraints);
            boolean isCa = basicConstraints.isCA();
            StringBuffer strbuf = new StringBuffer();
            strbuf.append("Subject Type=" + (isCa ? "CA" : "End Entity") + ", ");
            strbuf.append("Path Length Constraint=" + (null != basicConstraints.getPathLenConstraint() ? basicConstraints.getPathLenConstraint().toString(16) : "None"));
            System.out.println("basicConstraints: " + strbuf.toString());
            extendsInfo.put(extendName, strbuf.toString());
        }
    }

    private void getCRLDistPoint(Map<String, Object> extendsInfo, Extensions extensions) throws UnsupportedEncodingException {
        ASN1Encodable extvalue = extensions.getExtensionParsedValue(Extension.cRLDistributionPoints);
        CRLDistPoint cRLDistPoint = CRLDistPoint.getInstance((Object)extvalue);
        String extendName = CertExtendNameFinder.getExtendName(Extension.cRLDistributionPoints);
        if (null != cRLDistPoint) {
            DistributionPoint[] distributionPoints = cRLDistPoint.getDistributionPoints();
            if (null != distributionPoints && distributionPoints.length > 0) {
                ArrayList<String> CRLDistPointList = new ArrayList<String>();
                for (DistributionPoint distributionPoint : distributionPoints) {
                    StringBuffer parmap = new StringBuffer();
                    String CRLDistPointKey = "";
                    String CRLDistPointValue = "";
                    DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
                    int type = distributionPointName.getType();
                    ASN1Encodable distributionPointNameEncodable = distributionPointName.getName();
                    if (distributionPointNameEncodable instanceof GeneralNames) {
                        GeneralName[] names;
                        GeneralNames generalNames = (GeneralNames)distributionPointNameEncodable;
                        for (GeneralName name : names = generalNames.getNames()) {
                            String generalName = GeneralNameFinder.getGeneralName(name.getTagNo());
                            DERIA5String dERIA5String = (DERIA5String)name.getName();
                            CRLDistPointValue = generalName + "=" + new String(dERIA5String.getOctets(), "UTF-8");
                        }
                    }
                    if (type == 0) {
                        CRLDistPointKey = "Full Name";
                    } else if (type == 1) {
                        CRLDistPointKey = "nameRelativeToCRLIssuer";
                    }
                    parmap.append(CRLDistPointKey).append(":").append(CRLDistPointValue);
                    CRLDistPointList.add(parmap.toString());
                }
                extendsInfo.put(extendName, ((Object)CRLDistPointList).toString());
            }
        } else {
            extendsInfo.put(extendName, "");
        }
    }

    private void getFreshestCRL(Map<String, Object> extendsInfo, Extensions extensions) throws UnsupportedEncodingException {
        ASN1Encodable extvalue = extensions.getExtensionParsedValue(Extension.freshestCRL);
        String extendName = CertExtendNameFinder.getExtendName(Extension.freshestCRL);
        CRLDistPoint cRLDistPoint = CRLDistPoint.getInstance((Object)extvalue);
        if (null != cRLDistPoint) {
            DistributionPoint[] distributionPoints = cRLDistPoint.getDistributionPoints();
            if (null != distributionPoints && distributionPoints.length > 0) {
                ArrayList<String> CRLDistPointList = new ArrayList<String>();
                for (DistributionPoint distributionPoint : distributionPoints) {
                    StringBuffer parmap = new StringBuffer();
                    String CRLDistPointKey = "";
                    String CRLDistPointValue = "";
                    DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
                    int type = distributionPointName.getType();
                    ASN1Encodable distributionPointNameEncodable = distributionPointName.getName();
                    if (distributionPointNameEncodable instanceof GeneralNames) {
                        GeneralName[] names;
                        GeneralNames generalNames = (GeneralNames)distributionPointNameEncodable;
                        for (GeneralName name : names = generalNames.getNames()) {
                            String generalName = GeneralNameFinder.getGeneralName(name.getTagNo());
                            DERIA5String dERIA5String = (DERIA5String)name.getName();
                            CRLDistPointValue = generalName + "=" + new String(dERIA5String.getOctets(), "UTF-8");
                        }
                    }
                    if (type == 0) {
                        CRLDistPointKey = "Full Name";
                    } else if (type == 1) {
                        CRLDistPointKey = "nameRelativeToCRLIssuer";
                    }
                    parmap.append(CRLDistPointKey).append(":").append(CRLDistPointValue);
                    CRLDistPointList.add(parmap.toString());
                }
                extendsInfo.put(extendName, ((Object)CRLDistPointList).toString());
            }
        } else {
            extendsInfo.put(extendName, "");
        }
    }

    private void getAuthorityInfoAccess(Map<String, Object> extendsInfo, Extensions extensions) throws UnsupportedEncodingException {
        AccessDescription[] accessDescriptions;
        AuthorityInformationAccess authorityInformationAccess = AuthorityInformationAccess.fromExtensions((Extensions)extensions);
        if (null != authorityInformationAccess && null != (accessDescriptions = authorityInformationAccess.getAccessDescriptions()) && accessDescriptions.length > 0) {
            String extendName = CertExtendNameFinder.getExtendName(Extension.authorityInfoAccess);
            ArrayList authorityInfoAccessList = new ArrayList();
            for (AccessDescription accessDescription : accessDescriptions) {
                HashMap<String, String> authorityInfoMap = new HashMap<String, String>();
                ASN1ObjectIdentifier accessMethod = accessDescription.getAccessMethod();
                authorityInfoMap.put("Access Method", accessMethod.toString());
                GeneralName accessLocation = accessDescription.getAccessLocation();
                DERIA5String dERIA5String = (DERIA5String)accessLocation.getName();
                authorityInfoMap.put("Access Location", new String(dERIA5String.getOctets(), "UTF-8"));
                authorityInfoAccessList.add(authorityInfoMap);
            }
            extendsInfo.put(extendName, ((Object)authorityInfoAccessList).toString());
        }
    }

    private void getSubjectInformationAccess(Map<String, Object> extendsInfo, Extensions extensions) throws UnsupportedEncodingException {
        AccessDescription[] accessDescriptions;
        SubjectInformationAccess subjectInformationAccess = SubjectInformationAccess.fromExtensions((Extensions)extensions);
        if (null != subjectInformationAccess && null != (accessDescriptions = subjectInformationAccess.getAccessDescriptions()) && accessDescriptions.length > 0) {
            String extendName = CertExtendNameFinder.getExtendName(Extension.subjectInfoAccess);
            ArrayList authorityInfoAccessList = new ArrayList();
            for (AccessDescription accessDescription : accessDescriptions) {
                HashMap<String, String> authorityInfoMap = new HashMap<String, String>();
                ASN1ObjectIdentifier accessMethod = accessDescription.getAccessMethod();
                authorityInfoMap.put("Access Method", accessMethod.toString());
                GeneralName accessLocation = accessDescription.getAccessLocation();
                String generalName = GeneralNameFinder.getGeneralName(accessLocation.getTagNo());
                DERIA5String dERIA5String = (DERIA5String)accessLocation.getName();
                authorityInfoMap.put("Access Location", generalName + "=" + new String(dERIA5String.getOctets(), "UTF-8"));
                authorityInfoAccessList.add(authorityInfoMap);
            }
            extendsInfo.put(extendName, ((Object)authorityInfoAccessList).toString());
        }
    }

    private void getNameConstraints(Map<String, Object> extendsInfo, Extensions extensions) {
        ASN1Encodable extvalue = extensions.getExtensionParsedValue(Extension.nameConstraints);
        NameConstraints nameConstraints = NameConstraints.getInstance((Object)extvalue);
        if (null != nameConstraints) {
            String extendName = CertExtendNameFinder.getExtendName(Extension.nameConstraints);
            PKIXNameConstraintValidator validator = new PKIXNameConstraintValidator();
            GeneralSubtree[] excludedSubtrees = nameConstraints.getExcludedSubtrees();
            GeneralSubtree[] permittedSubtrees = nameConstraints.getPermittedSubtrees();
            if (permittedSubtrees != null) {
                validator.intersectPermittedSubtree(permittedSubtrees);
            }
            if (excludedSubtrees != null) {
                for (GeneralSubtree subtree : excludedSubtrees) {
                    validator.addExcludedSubtree(subtree);
                }
            }
            extendsInfo.put(extendName, validator.toString());
        }
    }

    private void getPolicyConstraints(Map<String, Object> extendsInfo, Extensions extensions) {
        PolicyConstraints policyConstraints = PolicyConstraints.fromExtensions((Extensions)extensions);
        if (null != policyConstraints) {
            String extendName = CertExtendNameFinder.getExtendName(Extension.policyConstraints);
            ArrayList<String> policyConstraintStr = new ArrayList<String>();
            BigInteger inhibitPolicyMapping = policyConstraints.getInhibitPolicyMapping();
            BigInteger requireExplicitPolicyMapping = policyConstraints.getRequireExplicitPolicyMapping();
            if (null != inhibitPolicyMapping) {
                policyConstraintStr.add("inhibitPolicyMapping=" + inhibitPolicyMapping.toString(16));
            }
            if (null != requireExplicitPolicyMapping) {
                policyConstraintStr.add("requireExplicitPolicy=" + requireExplicitPolicyMapping.toString(16));
            }
            extendsInfo.put(extendName, ((Object)policyConstraintStr).toString());
        }
    }

    private void getInhibitAnyPolicy(Map<String, Object> extendsInfo, Extensions extensions) {
        Extension inhibitAnyPolicyExtens = extensions.getExtension(Extension.inhibitAnyPolicy);
        if (null != inhibitAnyPolicyExtens) {
            String extendName = CertExtendNameFinder.getExtendName(Extension.inhibitAnyPolicy);
            int extValue = ASN1Integer.getInstance((Object)inhibitAnyPolicyExtens.getParsedValue()).getValue().intValue();
            extendsInfo.put(extendName, extValue < 0 ? "0" : String.valueOf(extValue));
        }
    }

    private void getIdentifyCode(Map<String, Object> extendsInfo, Extensions extensions) {
        Extension extvalue = extensions.getExtension(SM2Extensions.identifyCode);
        if (null != extvalue) {
            String extendName = CertExtendNameFinder.getExtendName(SM2Extensions.identifyCode);
            ASN1Encodable parsedValue = extvalue.getParsedValue();
            IdentifyCode identifyCode = IdentifyCode.getInstance((Object)parsedValue);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(IdentifyCodeEnum.convert((int)identifyCode.getType()).desc, identifyCode.getIdentifyCode().toString());
            ArrayList<HashMap<String, String>> identifyCodeList = new ArrayList<HashMap<String, String>>();
            identifyCodeList.add(map);
            extendsInfo.put(extendName, ((Object)identifyCodeList).toString());
        }
    }

    private void getInsuranceNumber(Map<String, Object> extendsInfo, Extensions extensions) {
        Extension extvalue = extensions.getExtension(SM2Extensions.insuranceNumber);
        if (null != extvalue) {
            String extendName = CertExtendNameFinder.getExtendName(SM2Extensions.insuranceNumber);
            ASN1Primitive asn1Primitive = extvalue.toASN1Primitive();
            if (asn1Primitive instanceof DERSequence) {
                ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Primitive;
                DEROctetString derOctetString = (DEROctetString)asn1Sequence.getObjectAt(asn1Sequence.size() - 1);
                System.out.println("InsuranceNumber:" + Strings.fromByteArray((byte[])derOctetString.getOctets()));
                extendsInfo.put(extendName, Strings.fromByteArray((byte[])derOctetString.getOctets()));
            }
        }
    }

    private void getICRegistrationNumber(Map<String, Object> extendsInfo, Extensions extensions) {
        Extension extvalue = extensions.getExtension(SM2Extensions.iCRegistrationNumber);
        if (null != extvalue) {
            String extendName = CertExtendNameFinder.getExtendName(SM2Extensions.iCRegistrationNumber);
            ASN1Primitive asn1Primitive = extvalue.toASN1Primitive();
            if (asn1Primitive instanceof DERSequence) {
                ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Primitive;
                DEROctetString derOctetString = (DEROctetString)asn1Sequence.getObjectAt(asn1Sequence.size() - 1);
                System.out.println("ICRegistrationNumber:" + Strings.fromByteArray((byte[])derOctetString.getOctets()));
                extendsInfo.put(extendName, Strings.fromByteArray((byte[])derOctetString.getOctets()));
            }
        }
    }

    private void getOrganizationCode(Map<String, Object> extendsInfo, Extensions extensions) {
        Extension extvalue = extensions.getExtension(SM2Extensions.organizationCode);
        if (null != extvalue) {
            String extendName = CertExtendNameFinder.getExtendName(SM2Extensions.organizationCode);
            ASN1Primitive asn1Primitive = extvalue.toASN1Primitive();
            if (asn1Primitive instanceof DERSequence) {
                ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Primitive;
                DEROctetString derOctetString = (DEROctetString)asn1Sequence.getObjectAt(asn1Sequence.size() - 1);
                System.out.println("OrganizationCode:" + Strings.fromByteArray((byte[])derOctetString.getOctets()));
                extendsInfo.put(extendName, Strings.fromByteArray((byte[])derOctetString.getOctets()));
            }
        }
    }

    private void getTaxationNumber(Map<String, Object> extendsInfo, Extensions extensions) {
        Extension extvalue = extensions.getExtension(SM2Extensions.taxationNumber);
        if (null != extvalue) {
            String extendName = CertExtendNameFinder.getExtendName(SM2Extensions.taxationNumber);
            ASN1Primitive asn1Primitive = extvalue.toASN1Primitive();
            if (asn1Primitive instanceof DERSequence) {
                ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Primitive;
                DEROctetString derOctetString = (DEROctetString)asn1Sequence.getObjectAt(asn1Sequence.size() - 1);
                System.out.println("TaxationNumber:" + Strings.fromByteArray((byte[])derOctetString.getOctets()));
                extendsInfo.put(extendName, Strings.fromByteArray((byte[])derOctetString.getOctets()));
            }
        }
    }

    private List<String> getGeneralNameList(Collection<List<?>> alternativeNames) {
        ArrayList<String> altNameList = new ArrayList<String>();
        for (List<?> alternativeName : alternativeNames) {
            Integer tag = (Integer)alternativeName.get(0);
            String generalName = GeneralNameFinder.getGeneralName(tag);
            Object value = alternativeName.get(1);
            value = DnUtil.deCodeDn((String)value.toString());
            altNameList.add(generalName + "=" + value);
        }
        return altNameList;
    }

    private List<String> getKeyUsage(boolean[] keyUsages) {
        if (null == keyUsages) {
            return null;
        }
        ArrayList<String> usages = new ArrayList<String>();
        if (keyUsages[0]) {
            usages.add("digitalSignature");
        }
        if (keyUsages[1]) {
            usages.add("nonRepudiation");
        }
        if (keyUsages[2]) {
            usages.add("keyEncipherment");
        }
        if (keyUsages[3]) {
            usages.add("dataEncipherment");
        }
        if (keyUsages[4]) {
            usages.add("keyAgreement");
        }
        if (keyUsages[5]) {
            usages.add("keyCertSign");
        }
        if (keyUsages[6]) {
            usages.add("cRLSign");
        }
        if (keyUsages[7]) {
            usages.add("encipherOnly");
        }
        if (keyUsages[8]) {
            usages.add("decipherOnly");
        }
        return usages;
    }

    private List<String> getExtendedKeyUsages(List<String> extendedKeyUsage) {
        if (null == extendedKeyUsage) {
            return null;
        }
        ArrayList<String> extendUsagesList = new ArrayList<String>();
        for (String extendKeyUsage : extendedKeyUsage) {
            String property = "extendedkeyusage_" + extendKeyUsage;
            String extendUsage = this.env.getProperty(property);
            extendUsagesList.add(extendUsage == null ? extendKeyUsage : extendUsage);
        }
        return extendUsagesList;
    }

    private DERBitString booleanToBitString(boolean[] id) {
        byte[] bytes = new byte[(id.length + 7) / 8];
        for (int i = 0; i != id.length; ++i) {
            int n = i / 8;
            bytes[n] = (byte)(bytes[n] | (id[i] ? 1 << 7 - i % 8 : 0));
        }
        int pad = id.length % 8;
        if (pad == 0) {
            return new DERBitString(bytes);
        }
        return new DERBitString(bytes, 8 - pad);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

