/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.util;

import com.xdja.pki.ca.certmanager.dao.ArchiveCertDao;
import com.xdja.pki.ca.certmanager.dao.CertDao;
import com.xdja.pki.ca.certmanager.dao.CertDataDao;
import com.xdja.pki.ca.certmanager.dao.CrossCertDao;
import com.xdja.pki.ca.certmanager.dao.CustomizeExtenDao;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDataDao;
import com.xdja.pki.ca.certmanager.dao.OutDateManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.OutdateCertDao;
import com.xdja.pki.ca.certmanager.dao.OuterCrossCertDao;
import com.xdja.pki.ca.certmanager.dao.RevokeCertDao;
import com.xdja.pki.ca.certmanager.dao.RevokeManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.SubCaCertDao;
import com.xdja.pki.ca.certmanager.dao.TemplateDao;
import com.xdja.pki.ca.certmanager.dao.models.ArchiveCertDO;
import com.xdja.pki.ca.certmanager.dao.models.CertDO;
import com.xdja.pki.ca.certmanager.dao.models.CertDataDO;
import com.xdja.pki.ca.certmanager.dao.models.CrossCertDO;
import com.xdja.pki.ca.certmanager.dao.models.CustomizeExtensionDO;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDataDO;
import com.xdja.pki.ca.certmanager.dao.models.OutdateCertDO;
import com.xdja.pki.ca.certmanager.dao.models.OutdateManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.OuterCrossCertDO;
import com.xdja.pki.ca.certmanager.dao.models.RevokedCertDO;
import com.xdja.pki.ca.certmanager.dao.models.RevokedManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.SubCaCertDO;
import com.xdja.pki.ca.certmanager.dao.models.TemplateDO;
import com.xdja.pki.ca.certmanager.service.crosscert.bean.CrossCertTypeEnum;
import com.xdja.pki.ca.certmanager.service.util.CertContentInfoUtil;
import com.xdja.pki.ca.certmanager.service.util.DicDataConverUtil;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.enums.CertStatusEnum;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.time.DateTimeUtil;
import com.xdja.pki.ca.securitymanager.dao.CaCertDao;
import com.xdja.pki.ca.securitymanager.dao.CaDao;
import com.xdja.pki.ca.securitymanager.dao.model.CaCertDo;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CertDetailQueryHandle {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CertDao certDao;
    @Resource
    private CertDataDao certDataDao;
    @Resource
    private CaDao caDao;
    @Resource
    private ManagerCertDao managereCertDao;
    @Resource
    private ManagerCertDataDao managerCertDataDao;
    @Resource
    private RevokeManagerCertDao revokeManagerCertDao;
    @Resource
    private CaCertDao caCertDao;
    @Resource
    private SubCaCertDao subCaCertDao;
    @Resource
    private CrossCertDao crossCertDao;
    @Resource
    private OuterCrossCertDao outerCrossCertDao;
    @Resource
    OutDateManagerCertDao outDateManagerCertDao;
    @Autowired
    CustomizeExtenDao customizeExtenDao;
    @Resource
    private RevokeCertDao revokeCertDao;
    @Resource
    private OutdateCertDao outdateCertDao;
    @Resource
    private ArchiveCertDao archiveCertDao;
    @Resource
    private TemplateDao templateDao;
    @Autowired
    private CertContentInfoUtil certContentInfoUtil;
    @Autowired
    private DicDataConverUtil dicDataConverUtil;

    public Result getManangeCertDetail(String sn, Integer keyAlg) {
        ManageCertDO certDO = null;
        RevokedManageCertDO revokCertDO = null;
        OutdateManageCertDO outdateManageCertDO = null;
        Integer status = 0;
        ManageCertDataDO managerCertData = null;
        try {
            Date afterTime;
            certDO = this.managereCertDao.getManagerCertsBySn(sn, keyAlg.intValue());
            if (null != certDO) {
                afterTime = certDO.getAfterTime();
                status = DateTimeUtil.compare((Date)afterTime, (Date)new Date()) == -1 ? Integer.valueOf(4) : certDO.getStatus();
                managerCertData = this.getManageCertDataById(certDO.getId());
            } else {
                revokCertDO = this.revokeManagerCertDao.getRevokManagerCertsBySn(sn, keyAlg);
                if (null != revokCertDO) {
                    afterTime = revokCertDO.getAfterTime();
                    status = DateTimeUtil.compare((Date)afterTime, (Date)new Date()) == -1 ? Integer.valueOf(4) : Integer.valueOf(3);
                    managerCertData = this.getManageCertDataById(revokCertDO.getId());
                } else {
                    outdateManageCertDO = this.outDateManagerCertDao.getOutDateManagerCertsBySn(sn, keyAlg);
                    if (null != outdateManageCertDO) {
                        status = 4;
                        managerCertData = this.getManageCertDataById(outdateManageCertDO.getId());
                    }
                }
            }
        }
        catch (DAOException e) {
            this.logger.error("\u6839\u636esn\u67e5\u8be2\u7ba1\u7406\u5b9e\u4f53\u8bc1\u4e66\u5931\u8d25\uff0csn=[{}],alg=[{}]", (Object)sn, (Object)keyAlg);
            throw new ServiceException("\u67e5\u8be2\u7ba1\u7406\u5b9e\u4f53\u8bc1\u4e66\u8be6\u60c5\u5f02\u5e38", (Throwable)e);
        }
        if (null == certDO && null == revokCertDO && null == outdateManageCertDO) {
            this.logger.info("\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5b58\u5728,sn=[{}]", (Object)sn);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_NOT_EXIST);
        }
        if (null == managerCertData) {
            this.logger.info("\u8bc1\u4e66\u5185\u5bb9\u4e0d\u5b58\u5728,sn=[{}]", (Object)sn);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_DATA_NOT_EXIST);
        }
        String certDataDetail = managerCertData.getData();
        Map<String, Object> certContentInfo = null;
        try {
            certContentInfo = this.getCertContenInfo(certDataDetail, null);
        }
        catch (Exception e) {
            this.logger.info("\u8bc1\u4e66\u8be6\u60c5\u683c\u5f0f\u8bfb\u53d6\u5f02\u5e38", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_DETAIL_FORMAT_ERROR);
        }
        this.appendCertContentInfo(certContentInfo, status, null);
        return Result.success(certContentInfo);
    }

    public Result getUserCertDetail(String sn, Integer keyAlg) {
        CertDO cert = null;
        RevokedCertDO revokedCert = null;
        OutdateCertDO outdateCert = null;
        ArchiveCertDO archiveCert = null;
        Integer status = 0;
        Long templateId = null;
        CertDataDO certData = null;
        try {
            Date afterTime;
            cert = this.certDao.getCertBySn(sn, keyAlg);
            if (null != cert) {
                afterTime = cert.getNotAfterTime();
                status = DateTimeUtil.compare((Date)afterTime, (Date)new Date()) == -1 ? Integer.valueOf(CertStatusEnum.EXPIRE.value) : cert.getStatus();
                templateId = cert.getTemplateId();
                certData = this.getCertDataById(cert.getId());
            } else {
                revokedCert = this.revokeCertDao.getRevokeCertBySn(sn, keyAlg);
                if (null != revokedCert) {
                    afterTime = revokedCert.getAfterTime();
                    status = DateTimeUtil.compare((Date)afterTime, (Date)new Date()) == -1 ? Integer.valueOf(CertStatusEnum.EXPIRE.value) : Integer.valueOf(CertStatusEnum.REVOKE.value);
                    templateId = revokedCert.getTemplateId();
                    certData = this.getCertDataById(revokedCert.getId());
                } else {
                    outdateCert = this.outdateCertDao.getOutDateCertBySn(sn, keyAlg);
                    if (null != outdateCert) {
                        status = 4;
                        templateId = outdateCert.getTemplateId();
                        certData = this.getCertDataById(outdateCert.getId());
                    } else {
                        archiveCert = this.archiveCertDao.getArchiveCertBySn(sn, keyAlg);
                        if (null != archiveCert) {
                            status = 4;
                            templateId = archiveCert.getTemplateId();
                            certData = this.getCertDataById(archiveCert.getId());
                        }
                    }
                }
            }
        }
        catch (DAOException e) {
            this.logger.error("\u6839\u636esn\u67e5\u8be2\u7528\u6237\u8bc1\u4e66\u8bc1\u4e66\u5931\u8d25\uff0csn=[{}],alg=[{}]", (Object)sn, (Object)keyAlg);
            throw new ServiceException("\u67e5\u8be2\u7528\u6237\u8bc1\u4e66\u8be6\u60c5\u5f02\u5e38", (Throwable)e);
        }
        if (null == cert && null == revokedCert && null == outdateCert && null == archiveCert) {
            this.logger.info("\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5b58\u5728,sn={}", (Object)sn);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_NOT_EXIST);
        }
        if (null == certData) {
            this.logger.info("\u8bc1\u4e66\u5185\u5bb9\u4e0d\u5b58\u5728,sn={}", (Object)sn);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_DATA_NOT_EXIST);
        }
        String certDataDetail = certData.getData();
        List allUsedCustomizeExten = this.customizeExtenDao.getAllUsedCustomizeExten();
        Map<String, Object> certContentInfo = null;
        try {
            certContentInfo = this.getCertContenInfo(certDataDetail, allUsedCustomizeExten);
        }
        catch (Exception e) {
            this.logger.info("\u8bc1\u4e66\u8be6\u60c5\u683c\u5f0f\u8bfb\u53d6\u5f02\u5e38", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_DETAIL_FORMAT_ERROR);
        }
        TemplateDO templateById = null;
        try {
            templateById = this.templateDao.getTemplateById(templateId);
        }
        catch (DAOException e) {
            throw new ServiceException("\u6a21\u677f\u4fe1\u606f\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
        this.appendCertContentInfo(certContentInfo, status, templateId);
        return Result.success(certContentInfo);
    }

    public Result getCaCertDetail(String sn, Integer keyAlg) {
        CaCertDo caCert = null;
        try {
            caCert = this.caCertDao.getCaCert(sn, keyAlg.intValue());
        }
        catch (DAOException e) {
            this.logger.error("\u6839\u636esn\u67e5\u8be2CA\u8bc1\u4e66\u5931\u8d25\uff0csn=[{}],alg=[{}]", (Object)sn, (Object)keyAlg);
            throw new ServiceException("\u6839\u636esn\u67e5\u8be2CA\u8bc1\u4e66\u8be6\u60c5\u5931\u8d25", (Throwable)e);
        }
        if (caCert == null) {
            return Result.failure((ErrorEnum)ErrorEnum.CERT_NOT_EXIST);
        }
        String caCertData = caCert.getCert();
        if (StringUtils.isBlank((CharSequence)caCertData)) {
            return Result.failure((ErrorEnum)ErrorEnum.CERT_DATA_NOT_EXIST);
        }
        Map<String, Object> certContentInfo = null;
        try {
            certContentInfo = this.getCertContenInfo(caCertData, null);
        }
        catch (Exception e) {
            this.logger.info("\u8bc1\u4e66\u8be6\u60c5\u683c\u5f0f\u8bfb\u53d6\u5f02\u5e38", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_DETAIL_FORMAT_ERROR);
        }
        Integer status = caCert.getStatus();
        this.appendCertContentInfo(certContentInfo, status, null);
        return Result.success(certContentInfo);
    }

    public Result getSubCaCertDetail(String sn, Integer keyAlg) {
        SubCaCertDO subCaCert = null;
        try {
            subCaCert = this.subCaCertDao.getSubCaCert(sn, keyAlg.intValue());
        }
        catch (DAOException e) {
            this.logger.error("\u6839\u636esn\u67e5\u8be2\u5b50CA\u8bc1\u4e66\u5931\u8d25\uff0csn=[{}],alg=[{}]", (Object)sn, (Object)keyAlg);
            throw new ServiceException("\u6839\u636esn\u67e5\u8be2\u5b50CA\u8bc1\u4e66\u8be6\u60c5\u5931\u8d25", (Throwable)e);
        }
        if (subCaCert == null) {
            return Result.failure((ErrorEnum)ErrorEnum.CERT_NOT_EXIST);
        }
        String subCaCertData = subCaCert.getData();
        if (StringUtils.isBlank((CharSequence)subCaCertData)) {
            return Result.failure((ErrorEnum)ErrorEnum.CERT_DATA_NOT_EXIST);
        }
        Map<String, Object> certContentInfo = null;
        try {
            certContentInfo = this.getCertContenInfo(subCaCertData, null);
        }
        catch (Exception e) {
            this.logger.info("\u8bc1\u4e66\u8be6\u60c5\u683c\u5f0f\u8bfb\u53d6\u5f02\u5e38", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_DETAIL_FORMAT_ERROR);
        }
        Long templateId = subCaCert.getTemplateId();
        Integer status = subCaCert.getStatus();
        this.appendCertContentInfo(certContentInfo, status, templateId);
        return Result.success(certContentInfo);
    }

    public Result getCrossCertDetail(String sn, Integer keyAlg) {
        CrossCertDO crossCert = null;
        try {
            crossCert = this.crossCertDao.getCrossCert(sn, keyAlg.intValue());
        }
        catch (DAOException e) {
            this.logger.error("\u6839\u636esn\u67e5\u8be2\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25\uff0csn=[{}],alg=[{}]", (Object)sn, (Object)keyAlg);
            throw new ServiceException("\u6839\u636esn\u67e5\u8be2\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
        if (crossCert == null) {
            return Result.failure((ErrorEnum)ErrorEnum.CERT_NOT_EXIST);
        }
        String crossCertData = crossCert.getData();
        if (StringUtils.isBlank((CharSequence)crossCertData)) {
            return Result.failure((ErrorEnum)ErrorEnum.CERT_DATA_NOT_EXIST);
        }
        Map<String, Object> certContentInfo = null;
        try {
            certContentInfo = this.getCertContenInfo(crossCertData, null);
        }
        catch (Exception e) {
            this.logger.info("\u8bc1\u4e66\u8be6\u60c5\u683c\u5f0f\u8bfb\u53d6\u5f02\u5e38", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_DETAIL_FORMAT_ERROR);
        }
        this.handleCrossCertDO(crossCert);
        Long templateId = crossCert.getTemplateId();
        Integer status = crossCert.getStatus();
        this.appendCertContentInfo(certContentInfo, status, templateId);
        return Result.success(certContentInfo);
    }

    public Result getOutCrossCertDetail(String sn, Integer keyAlg) {
        OuterCrossCertDO outCrossCert = null;
        try {
            outCrossCert = this.outerCrossCertDao.getOutCrossCert(sn, keyAlg.intValue());
        }
        catch (DAOException e) {
            this.logger.error("\u6839\u636esn\u67e5\u8be2\u5916\u90e8\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25\uff0csn=[{}],alg=[{}]", (Object)sn, (Object)keyAlg);
            throw new ServiceException("\u6839\u636esn\u67e5\u8be2\u5916\u90e8\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
        if (outCrossCert == null) {
            return Result.failure((ErrorEnum)ErrorEnum.CERT_NOT_EXIST);
        }
        String outCrossCertData = outCrossCert.getData();
        if (StringUtils.isBlank((CharSequence)outCrossCertData)) {
            return Result.failure((ErrorEnum)ErrorEnum.CERT_DATA_NOT_EXIST);
        }
        Map<String, Object> certContentInfo = null;
        try {
            certContentInfo = this.getCertContenInfo(outCrossCertData, null);
        }
        catch (Exception e) {
            this.logger.info("\u8bc1\u4e66\u8be6\u60c5\u683c\u5f0f\u8bfb\u53d6\u5f02\u5e38", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_DETAIL_FORMAT_ERROR);
        }
        return Result.success(certContentInfo);
    }

    private void appendCertContentInfo(Map<String, Object> certContentInfo, Integer status, Long templateId) {
        if (templateId != null) {
            TemplateDO templateById = null;
            try {
                templateById = this.templateDao.getTemplateById(templateId);
            }
            catch (DAOException e) {
                this.logger.error("\u6a21\u677f\u4fe1\u606f\u67e5\u8be2\u5931\u8d25", (Throwable)e);
                throw new ServiceException("\u6a21\u677f\u4fe1\u606f\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            }
            certContentInfo.put("templateName", templateById != null ? templateById.getName() : null);
        }
        if (status != null) {
            certContentInfo.put("status", status);
            String statusStr = this.dicDataConverUtil.ConverStatusToStr(status);
            certContentInfo.put("statusStr", statusStr);
        }
    }

    private void handleCrossCertDO(CrossCertDO crossCertDO) {
        if (CrossCertTypeEnum.CROSSCERT_STATUS_REVOKED.value == crossCertDO.getStatus()) {
            crossCertDO.setStatus(Integer.valueOf(3));
        }
        if (crossCertDO.getAfterTime().before(new Date())) {
            crossCertDO.setStatus(Integer.valueOf(4));
        }
    }

    private Map<String, Object> getCertContenInfo(String certDataStr, List<CustomizeExtensionDO> allUsedCustomizeExten) throws Exception {
        X509Certificate certificate = CertUtil.getCertFromStr((String)certDataStr);
        return this.certContentInfoUtil.getCertContentInfo(certificate, allUsedCustomizeExten);
    }

    private CertDataDO getCertDataById(Long id) {
        CertDataDO certDataById = null;
        try {
            certDataById = this.certDataDao.queryCertDataById(id);
        }
        catch (DAOException e) {
            this.logger.info("\u67e5\u8be2\u7528\u6237\u8bc1\u4e66\u5185\u5bb9\u5f02\u5e38,certId=[{}]", (Object)id);
            throw new ServiceException("service\u67e5\u8be2\u7528\u6237\u8bc1\u4e66\u5185\u5bb9\u5f02\u5e38", (Throwable)e);
        }
        return certDataById;
    }

    private ManageCertDataDO getManageCertDataById(Long id) {
        ManageCertDataDO manageCertDataById = null;
        try {
            manageCertDataById = this.managerCertDataDao.queryManagerCertDataById(id);
        }
        catch (DAOException e) {
            this.logger.info("\u67e5\u8be2\u7ba1\u7406\u5b9e\u4f53\u8bc1\u4e66\u5185\u5bb9\u5f02\u5e38,certId={}", (Object)id);
            throw new ServiceException("service\u67e5\u8be2\u7ba1\u7406\u5b9e\u4f53\u8bc1\u4e66\u5185\u5bb9\u5f02\u5e38", (Throwable)e);
        }
        return manageCertDataById;
    }
}

