/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.service.util;

import com.xdja.pki.ca.certmanager.dao.ManagerCertDataDao;
import com.xdja.pki.ca.certmanager.dao.SubSystemDao;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.enums.DeviceTypeEnum;
import com.xdja.pki.ca.securitymanager.dao.CaCertDao;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.ldap.sdk.ca.LDAPCASDK;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class LdapCASDKUtil {
    public static final String DIGESTALGORITHMNAME = "SM3";
    @Value(value="${ldapsdk.response.overtime}")
    public int ldapsdkOutTime;
    @Resource
    private SubSystemDao subSystemDao;
    @Resource
    private ManagerCertDataDao managerCertDataDao;
    @Resource
    private CaCertDao caCertDao;
    private List<X509Certificate> ldapSignCerts;
    private List<X509Certificate> ocspSignCerts;

    public LDAPCASDK getPkixIssueSDKInstance() {
        List caSubSystemOcspCertIds = this.subSystemDao.getCaSubSystemCertIdsByDevType(DeviceTypeEnum.OCSP.value);
        List caSubSystemLdapCertIds = this.subSystemDao.getCaSubSystemCertIdsByDevType(DeviceTypeEnum.LDAP.value);
        Map ocspCertData = this.managerCertDataDao.getManageCertData(caSubSystemOcspCertIds);
        Map ldapCertData = this.managerCertDataDao.getManageCertData(caSubSystemLdapCertIds);
        this.ocspSignCerts = this.getCaSubSystemX509Certs(ocspCertData);
        this.ldapSignCerts = this.getCaSubSystemX509Certs(ldapCertData);
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
        List caCerts = this.caCertDao.getCaCertsByCaId(caInfoVO.getCaId());
        String masterLdapUrl = null;
        String interOcspUrl = null;
        if (caInfoVO.isLadp() && null != caInfoVO.getDirServerConfigBean()) {
            masterLdapUrl = caInfoVO.getDirServerConfigBean().getMasterURL();
        }
        if (caInfoVO.isOcsp() && null != caInfoVO.getOcspConfig()) {
            interOcspUrl = caInfoVO.getOcspConfig().getInterURL();
        }
        LDAPCASDK pkixIssueSdk = null;
        pkixIssueSdk = Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC) ? new LDAPCASDK(caCerts, caInfoVO.getKeyPair(), masterLdapUrl, interOcspUrl, this.ldapSignCerts, this.ocspSignCerts) : new LDAPCASDK(caCerts, caInfoVO.getCaPwdBean().getKeyIndex().intValue(), caInfoVO.getCaPwdBean().getPrivateKeyPin(), SdfCryptoType.YUNHSM, masterLdapUrl, interOcspUrl, this.ldapSignCerts, this.ocspSignCerts);
        pkixIssueSdk.setTime(this.ldapsdkOutTime);
        return pkixIssueSdk;
    }

    private List<X509Certificate> getCaSubSystemX509Certs(Map<Long, String> certDataMap) {
        ArrayList<X509Certificate> x509CertList = null;
        if (certDataMap != null && !certDataMap.isEmpty()) {
            x509CertList = new ArrayList<X509Certificate>();
            Set<Long> certDataKeySet = certDataMap.keySet();
            for (Long key : certDataKeySet) {
                String data = certDataMap.get(key);
                X509Certificate cert = CertUtil.getCertFromStr((String)data);
                if (null == cert) continue;
                x509CertList.add(cert);
            }
        }
        return x509CertList;
    }

    public List<X509Certificate> getLdapSignCerts() {
        return this.ldapSignCerts;
    }

    public void setLdapSignCerts(List<X509Certificate> ldapSignCerts) {
        this.ldapSignCerts = ldapSignCerts;
    }

    public List<X509Certificate> getOcspSignCerts() {
        return this.ocspSignCerts;
    }

    public void setOcspSignCerts(List<X509Certificate> ocspSignCerts) {
        this.ocspSignCerts = ocspSignCerts;
    }
}

