/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.openapi.service.impl.v1;

import com.alibaba.fastjson.JSONObject;
import com.xdja.pki.ca.certmanager.dao.CertDataDao;
import com.xdja.pki.ca.certmanager.dao.CustomizeExtenDao;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDataDao;
import com.xdja.pki.ca.certmanager.dao.OutDateManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.RaAdminCertDao;
import com.xdja.pki.ca.certmanager.dao.RaServerCertDao;
import com.xdja.pki.ca.certmanager.dao.RevokeManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.models.CertDO;
import com.xdja.pki.ca.certmanager.dao.models.CertDataDO;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDataDO;
import com.xdja.pki.ca.certmanager.dao.models.OutdateCertDO;
import com.xdja.pki.ca.certmanager.dao.models.OutdateManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.RaAdminCertDO;
import com.xdja.pki.ca.certmanager.dao.models.RevokedCertDO;
import com.xdja.pki.ca.certmanager.dao.models.RevokedManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.TemplateDO;
import com.xdja.pki.ca.certmanager.dao.models.ra.TRA;
import com.xdja.pki.ca.certmanager.dao.openapi.RAOpenApiDao;
import com.xdja.pki.ca.certmanager.service.customizeExten.bean.TemplateCustomizeExtensionVO;
import com.xdja.pki.ca.certmanager.service.template.TemplateService;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateInfoVO;
import com.xdja.pki.ca.certmanager.service.userca.UserCaService;
import com.xdja.pki.ca.certmanager.service.util.CertContentInfoUtil;
import com.xdja.pki.ca.certmanager.service.util.DicDataConverUtil;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.enums.DigestAlgEnum;
import com.xdja.pki.ca.core.enums.KeyAlgEnum;
import com.xdja.pki.ca.core.enums.TemplateTypeEnum;
import com.xdja.pki.ca.core.exception.DAOException;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.pkcs7.P7bUtils;
import com.xdja.pki.ca.core.util.CertUtils;
import com.xdja.pki.ca.hsm.manager.HsmManager;
import com.xdja.pki.ca.openapi.service.impl.v1.util.JsonUtils;
import com.xdja.pki.ca.openapi.service.v1.IRAOpenApiService;
import com.xdja.pki.ca.openapi.service.v1.bean.CertDownloadRep;
import com.xdja.pki.ca.openapi.service.v1.bean.CertStatusRep;
import com.xdja.pki.ca.openapi.service.v1.bean.RALoginResp;
import com.xdja.pki.ca.openapi.service.v1.bean.RATemplateRep;
import com.xdja.pki.ca.openapi.service.v1.bean.RAinfoRep;
import com.xdja.pki.ca.openapi.service.v1.bean.RAmanageTemplVO;
import com.xdja.pki.ca.securitymanager.dao.CaDao;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.ExtensionVO;
import com.xdja.pki.ca.securitymanager.service.vo.SignAlgTypeEnum;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.bouncycastle.asn1.DEROctetString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RAOpenApiServiceImpl
implements IRAOpenApiService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RAOpenApiDao raOpenApiDao;
    @Autowired
    private CertDataDao certDataDao;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private CertContentInfoUtil certContentInfoUtil;
    @Autowired
    private DicDataConverUtil dicDataConverUtil;
    @Autowired
    private ManagerCertDao managereCertDao;
    @Autowired
    private RevokeManagerCertDao revokeManagerCertDao;
    @Autowired
    private OutDateManagerCertDao outDateManagerCertDao;
    @Autowired
    private RaAdminCertDao raAdminCertDao;
    @Autowired
    private ManagerCertDataDao managerCertDataDao;
    @Autowired
    CustomizeExtenDao customizeExtenDao;
    @Resource
    private CaDao caDao;
    @Autowired
    private HsmManager hsmManager;
    @Autowired
    RaServerCertDao raServerCertDao;
    @Autowired
    UserCaService userCaService;
    private Random rand = new Random();

    public Result getCertConfirmStatusBySN(Long raId, String sn) {
        CertStatusRep certStatusRep = new CertStatusRep();
        Integer certStatus = null;
        try {
            certStatus = this.raOpenApiDao.getCertConfirmStatusBySN(raId, sn);
        }
        catch (DAOException e) {
            this.logger.error("service\u67e5\u8be2\u8bc1\u4e66\u4fe1\u606f\u5f02\u5e38");
            throw new ServiceException((Throwable)e);
        }
        if (null == certStatus) {
            this.logger.info("\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5b58\u5728");
            return Result.failure((ErrorEnum)ErrorEnum.CERT_NOT_EXIST);
        }
        certStatusRep.setStatus(certStatus);
        return Result.success((Object)certStatusRep);
    }

    public Result getDownloadCerts(Long raId, String sn) {
        CertDownloadRep certDownloadRep = new CertDownloadRep();
        CertDO cert = null;
        RevokedCertDO revokedCert = null;
        OutdateCertDO outdateCert = null;
        CertDataDO certData = null;
        Long pairCertId = null;
        Integer certType = null;
        Long caCertId = null;
        try {
            cert = this.raOpenApiDao.getCertDetailBySn(raId, sn);
            certData = this.getCertDataById(cert.getId());
            certType = cert.getType();
            pairCertId = cert.getPairCertId();
            caCertId = cert.getCaCertId();
        }
        catch (DAOException e) {
            try {
                revokedCert = this.raOpenApiDao.getRevokedCertDetailBySn(raId, sn);
                certData = this.getCertDataById(revokedCert.getId());
                certType = revokedCert.getType();
                pairCertId = revokedCert.getPairCertId();
                caCertId = revokedCert.getCaCertId();
            }
            catch (DAOException e1) {
                try {
                    outdateCert = this.raOpenApiDao.getOutdateCertDetailBySn(raId, sn);
                    certData = this.getCertDataById(outdateCert.getId());
                    certType = outdateCert.getType();
                    pairCertId = outdateCert.getPairCertId();
                    caCertId = outdateCert.getCaCertId();
                }
                catch (DAOException e2) {
                    this.logger.info("\u6839\u636esn\u67e5\u8be2\u8bc1\u4e66\u8be6\u60c5\u65e0\u6570\u636e\u8fd4\u56desn={}", (Object)sn);
                }
            }
        }
        if (null == cert && null == revokedCert && null == outdateCert) {
            this.logger.info("\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5b58\u5728");
            return Result.failure((ErrorEnum)ErrorEnum.CERT_NOT_EXIST);
        }
        if (null == certData) {
            this.logger.info("\u8bc1\u4e66\u5185\u5bb9\u4e0d\u5b58\u5728");
            return Result.failure((ErrorEnum)ErrorEnum.CERT_DATA_NOT_EXIST);
        }
        Result result = this.userCaService.downloadUserCaCert(caCertId);
        if (!result.isSuccess()) {
            return result;
        }
        String certChain = (String)result.getInfo();
        List caTrust = null;
        try {
            caTrust = P7bUtils.resolveCertChain((String)certChain);
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.GET_USER_CA_CERT_P7B_EXCEPTION);
        }
        certDownloadRep.setUserCACert(certChain);
        if (certType == 1 || pairCertId == 0L) {
            String signCertString = certData.getData();
            X509Certificate signCert = CertUtils.getCertFromStr((String)signCertString);
            caTrust.add(signCert);
            String signTrustCert = CertUtils.createCertChainByCerts((List)caTrust);
            certDownloadRep.setSignCert(signCertString);
            certDownloadRep.setSignCertP7b(signTrustCert);
        } else {
            String signCertString;
            String encCertString;
            CertDataDO pairCertData = this.getCertDataById(pairCertId);
            if (null == pairCertData) {
                this.logger.info("\u8bc1\u4e66\u5185\u5bb9\u4e0d\u5b58\u5728");
                return Result.failure((ErrorEnum)ErrorEnum.CERT_DATA_NOT_EXIST);
            }
            if (certType == 3) {
                encCertString = certData.getData();
                signCertString = pairCertData.getData();
            } else {
                signCertString = certData.getData();
                encCertString = pairCertData.getData();
            }
            X509Certificate signCert = CertUtils.getCertFromStr((String)signCertString);
            caTrust.add(signCert);
            String signTrustCert = CertUtils.createCertChainByCerts((List)caTrust);
            certDownloadRep.setSignCert(signCertString);
            certDownloadRep.setSignCertP7b(signTrustCert);
            caTrust.remove(signCert);
            X509Certificate encCert = CertUtils.getCertFromStr((String)encCertString);
            caTrust.add(encCert);
            String encTrustCert = CertUtils.createCertChainByCerts((List)caTrust);
            certDownloadRep.setEncCert(encCertString);
            certDownloadRep.setEncCertP7b(encTrustCert);
        }
        return Result.success((Object)certDownloadRep);
    }

    public Result getCertDetailBySN(Long raId, String sn) {
        CertDO cert = null;
        RevokedCertDO revokedCert = null;
        OutdateCertDO outdateCert = null;
        Integer status = 0;
        Long templateId = null;
        CertDataDO certData = null;
        Integer type = 2;
        try {
            cert = this.raOpenApiDao.getCertDetailBySn(raId, sn);
            type = cert.getType();
            CertDO normalCheck = this.raOpenApiDao.checkNormalCert(raId, sn);
            status = null != normalCheck ? Integer.valueOf(4) : cert.getStatus();
            templateId = cert.getTemplateId();
            certData = this.getCertDataById(cert.getId());
        }
        catch (DAOException e) {
            try {
                revokedCert = this.raOpenApiDao.getRevokedCertDetailBySn(raId, sn);
                type = revokedCert.getType();
                RevokedCertDO revokeCheck = this.raOpenApiDao.checkRevokeCert(raId, sn);
                status = null != revokeCheck ? Integer.valueOf(4) : Integer.valueOf(3);
                templateId = revokedCert.getTemplateId();
                certData = this.getCertDataById(revokedCert.getId());
            }
            catch (DAOException e1) {
                try {
                    outdateCert = this.raOpenApiDao.getOutdateCertDetailBySn(raId, sn);
                    type = outdateCert.getType();
                    status = 4;
                    templateId = outdateCert.getTemplateId();
                    certData = this.getCertDataById(outdateCert.getId());
                }
                catch (DAOException e2) {
                    this.logger.info("\u6839\u636esn\u67e5\u8be2\u8bc1\u4e66\u8be6\u60c5\u65e0\u6570\u636e\u8fd4\u56desn={}", (Object)sn);
                }
            }
        }
        if (null == cert && null == revokedCert && null == outdateCert) {
            this.logger.info("\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5b58\u5728,sn={}", (Object)sn);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_NOT_EXIST);
        }
        if (null == certData) {
            this.logger.info("\u8bc1\u4e66\u5185\u5bb9\u4e0d\u5b58\u5728,sn={}", (Object)sn);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_DATA_NOT_EXIST);
        }
        List allUsedCustomizeExten = this.customizeExtenDao.getAllUsedCustomizeExten();
        String certDataDetail = certData.getData();
        Map certContentInfo = null;
        try {
            X509Certificate certificate = CertUtil.getCertFromStr((String)certDataDetail);
            certContentInfo = this.certContentInfoUtil.getCertContentInfo(certificate, allUsedCustomizeExten);
        }
        catch (Exception e) {
            this.logger.error("\u8bc1\u4e66\u8be6\u60c5\u683c\u5f0f\u8bfb\u53d6\u5f02\u5e38", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_DETAIL_FORMAT_ERROR);
        }
        TemplateDO templateById = null;
        try {
            templateById = this.raOpenApiDao.getTemplateById(templateId);
        }
        catch (DAOException e) {
            this.logger.error("\u6a21\u677f\u4fe1\u606f\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u6a21\u677f\u4fe1\u606f\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
        certContentInfo.put("status", status);
        String statusStr = this.dicDataConverUtil.ConverStatusToStr(status);
        certContentInfo.put("statusStr", statusStr);
        certContentInfo.put("templateName", templateById != null ? templateById.getName() : null);
        certContentInfo.put("type", type);
        return Result.success((Object)certContentInfo);
    }

    public Result getRATemplateById(Long id) {
        ArrayList<RATemplateRep> raTemplateRepList = new ArrayList<RATemplateRep>();
        try {
            List raTemplateCodes = this.raOpenApiDao.getRaTemplateCodes(id, Integer.valueOf(TemplateTypeEnum.USER.getValue()));
            String[] codes = new String[raTemplateCodes.size()];
            for (int i = 0; i < raTemplateCodes.size(); ++i) {
                codes[i] = ((TemplateDO)raTemplateCodes.get(i)).getCode();
            }
            Map templatesByCodes = this.templateService.getTemplatesByCodes(codes);
            for (TemplateDO raTemplateCode : raTemplateCodes) {
                String keyAlgStr = KeyAlgEnum.convert((int)raTemplateCode.getKeyAlg()).getDesc();
                RATemplateRep raTemplateRep = new RATemplateRep();
                BeanUtils.copyProperties((Object)raTemplateCode, (Object)raTemplateRep);
                raTemplateRep.setBaseDn(raTemplateCode.getCustomizeDn());
                raTemplateRep.setUserCA(this.caDao.getCaById(raTemplateCode.getCaId().longValue()).getName());
                raTemplateRep.setKeyAlg(keyAlgStr);
                String signAlgStr = SignAlgTypeEnum.getViewAlgName((int)Integer.valueOf(raTemplateCode.getSignAlg()));
                raTemplateRep.setSignAlg(signAlgStr);
                String code = raTemplateCode.getCode();
                TemplateInfoVO templateInfoVO = (TemplateInfoVO)templatesByCodes.get(code);
                if (null != templateInfoVO) {
                    List templateCustomizeExtensions;
                    List extensions = templateInfoVO.getExtensions();
                    ArrayList temParas = new ArrayList();
                    if (CollectionUtils.isNotEmpty((Collection)extensions)) {
                        for (ExtensionVO extension : extensions) {
                            HashMap<String, String> extPara = new HashMap<String, String>();
                            if (extension.getIsInput() == 1) {
                                extPara.put("attrName", extension.getName());
                                extPara.put("attrOid", extension.getExtnId());
                                extPara.put("attrType", extension.getValue() == null ? "" : extension.getValue());
                                extPara.put("attrValue", "");
                                extPara.put("attrCustomize", "0");
                                extPara.put("attrRequired", "1");
                            }
                            if (extPara.isEmpty()) continue;
                            temParas.add(extPara);
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)(templateCustomizeExtensions = templateInfoVO.getCustomizeExtens()))) {
                        for (TemplateCustomizeExtensionVO templateCustomizeExtensionVO : templateCustomizeExtensions) {
                            if (templateCustomizeExtensionVO.getIsClient() != 1) continue;
                            HashMap<String, String> extPara = new HashMap<String, String>();
                            extPara.put("attrName", templateCustomizeExtensionVO.getCustomizeExtenName());
                            extPara.put("attrOid", templateCustomizeExtensionVO.getCustomizeExtenOid());
                            extPara.put("attrType", templateCustomizeExtensionVO.getEncodeType().toString());
                            extPara.put("attrValue", "");
                            extPara.put("attrCustomize", "1");
                            extPara.put("attrRequired", templateCustomizeExtensionVO.getIsRequest().toString());
                            if (extPara.isEmpty()) continue;
                            temParas.add(extPara);
                        }
                    }
                    raTemplateRep.setTemParas(temParas);
                    raTemplateRep.setCertPatterm(templateInfoVO.getCertPatterm());
                }
                raTemplateRepList.add(raTemplateRep);
            }
        }
        catch (DAOException e) {
            this.logger.info("service\u67e5\u8be2RA\u6388\u6743\u6a21\u677f\u5217\u8868\u5f02\u5e38");
            throw new ServiceException("service\u67e5\u8be2RA\u6388\u6743\u6a21\u677f\u5217\u8868", (Throwable)e);
        }
        return Result.success(raTemplateRepList);
    }

    public Result getTemplateDetail(Long id, String templateCode) {
        Result templateByCodeResult = null;
        try {
            List raTemplateList = this.raOpenApiDao.getRaTemplateCodes(id, Integer.valueOf(TemplateTypeEnum.USER.getValue()));
            boolean isNotBound = true;
            if (null != raTemplateList && !raTemplateList.isEmpty()) {
                for (TemplateDO raTemplate : raTemplateList) {
                    String raTempCode = raTemplate.getCode();
                    if (!raTempCode.equals(templateCode)) continue;
                    isNotBound = false;
                    break;
                }
            }
            if (isNotBound) {
                return Result.failure((ErrorEnum)ErrorEnum.UNAUTHORIZED_REQUEST);
            }
            templateByCodeResult = this.templateService.getTemplateByCode(templateCode);
        }
        catch (ServiceException e) {
            throw new ServiceException("\u6839\u636e\u6a21\u677f\u7f16\u53f7\u83b7\u53d6\u6a21\u677f\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
        if (!templateByCodeResult.isSuccess()) {
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
        }
        Object info = templateByCodeResult.getInfo();
        JSONObject parseObject = null;
        if (info != null) {
            String object2Json = JsonUtils.object2Json(info);
            parseObject = JSONObject.parseObject((String)object2Json);
            Integer keyAlg = (Integer)parseObject.get((Object)"keyAlg");
            String keyAlgStr = KeyAlgEnum.convert((int)keyAlg).getDesc();
            parseObject.put("keyAlg", (Object)keyAlgStr);
        }
        return Result.success(parseObject);
    }

    private CertDataDO getCertDataById(Long id) {
        CertDataDO certDataById = null;
        try {
            certDataById = this.certDataDao.queryCertDataById(id);
        }
        catch (DAOException e) {
            this.logger.info("\u67e5\u8be2\u8bc1\u4e66\u5185\u5bb9\u5f02\u5e38,certId={}", (Object)id);
            throw new ServiceException("service\u67e5\u8be2\u8bc1\u4e66\u5185\u5bb9\u5f02\u5e38", (Throwable)e);
        }
        return certDataById;
    }

    private ManageCertDataDO getManageCertDataById(Long id) {
        ManageCertDataDO manageCertDataById = null;
        try {
            manageCertDataById = this.managerCertDataDao.queryManagerCertDataById(id);
        }
        catch (DAOException e) {
            this.logger.info("\u67e5\u8be2\u7ba1\u7406\u8bc1\u4e66\u5185\u5bb9\u5f02\u5e38,certId={}", (Object)id);
            throw new ServiceException("service\u67e5\u8be2\u7ba1\u7406\u8bc1\u4e66\u5185\u5bb9\u5f02\u5e38", (Throwable)e);
        }
        return manageCertDataById;
    }

    public RAinfoRep getRAInfoBySN(String sn) {
        TRA ra = null;
        RAinfoRep rAinfoRep = null;
        try {
            ra = this.raOpenApiDao.getRAInfoBySN(sn);
            rAinfoRep = new RAinfoRep();
            BeanUtils.copyProperties((Object)ra, (Object)rAinfoRep);
        }
        catch (DAOException e) {
            throw new ServiceException("service\u67e5\u8be2RA\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        return rAinfoRep;
    }

    public Result getChallenge() {
        HashMap<String, String> challengeParam = new HashMap<String, String>();
        byte[] sampleNonce = new byte[16];
        this.rand.nextBytes(sampleNonce);
        DEROctetString derOctetString = new DEROctetString(sampleNonce);
        challengeParam.put("challenge", derOctetString.toString());
        return Result.success(challengeParam);
    }

    public Result RALoginVerify(Map<String, Object> parMap, long raId) {
        RaAdminCertDO raAdminCertByManageId;
        String sn = (String)parMap.get("sn");
        Integer alg = (Integer)parMap.get("alg");
        ManageCertDO certDO = null;
        RevokedManageCertDO revokCertDO = null;
        OutdateManageCertDO outdateManageCertDO = null;
        ManageCertDataDO certData = null;
        Long pairCertId = null;
        Integer certType = null;
        Integer certStatus = RALoginResp.DEFULT_CERTSTATUS;
        Integer adminType = RALoginResp.DEFULT_ADMINTYPE;
        Long managerCertId = null;
        try {
            certDO = this.managereCertDao.getManagerCertsBySn(sn);
            if (null != certDO) {
                certStatus = certDO.getStatus();
                managerCertId = certDO.getId();
                certType = certDO.getType();
                pairCertId = certDO.getPairCertId();
                certData = this.getManageCertDataById(certDO.getId());
            } else {
                revokCertDO = this.revokeManagerCertDao.getRevokManagerCertsBySn(sn);
                if (null != revokCertDO) {
                    certStatus = 3;
                    managerCertId = revokCertDO.getId();
                    certType = revokCertDO.getType();
                    pairCertId = revokCertDO.getPairCertId();
                    certData = this.getManageCertDataById(revokCertDO.getId());
                } else {
                    outdateManageCertDO = this.outDateManagerCertDao.getOutDateManagerCertsBySn(sn);
                    if (null != outdateManageCertDO) {
                        certStatus = 4;
                        managerCertId = outdateManageCertDO.getId();
                        certType = outdateManageCertDO.getType();
                        pairCertId = outdateManageCertDO.getPairCertId();
                        certData = this.getManageCertDataById(outdateManageCertDO.getId());
                    }
                }
            }
        }
        catch (DAOException e) {
            this.logger.info("\u6839\u636esn\u67e5\u8be2RA\u8bc1\u4e66\u8be6\u60c5\u65e0\u6570\u636e\u8fd4\u56desn={}", (Object)sn);
            throw new ServiceException("service\u6839\u636esn\u67e5\u8be2RA\u8bc1\u4e66\u8be6\u60c5", (Throwable)e);
        }
        if (null == certDO && null == revokCertDO && null == outdateManageCertDO) {
            this.logger.info("\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5b58\u5728,sn={}", (Object)sn);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_NOT_EXIST);
        }
        RaAdminCertDO raAdminCertDO = this.raAdminCertDao.getRaAdminCertByManageId(managerCertId);
        if (raAdminCertDO.getRaId() == null || raAdminCertDO.getRaId() != raId) {
            this.logger.info("\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5b58\u5728,sn={}", (Object)sn);
            return Result.failure((ErrorEnum)ErrorEnum.CERT_NOT_EXIST);
        }
        ManageCertDataDO pairCertData = this.getManageCertDataById(pairCertId);
        if (null == certData || null == pairCertData) {
            this.logger.info("\u8bc1\u4e66\u5185\u5bb9\u4e0d\u5b58\u5728");
            return Result.failure((ErrorEnum)ErrorEnum.CERT_DATA_NOT_EXIST);
        }
        RALoginResp raLoginResp = new RALoginResp();
        if (certType == 1) {
            raLoginResp.setSignCertData(certData.getData());
            raLoginResp.setEncCertData(pairCertData.getData());
        } else {
            raLoginResp.setSignCertData(pairCertData.getData());
            raLoginResp.setEncCertData(certData.getData());
        }
        if (null != managerCertId && null != (raAdminCertByManageId = this.raAdminCertDao.getRaAdminCertByManageId(managerCertId))) {
            adminType = raAdminCertByManageId.getRoleType();
        }
        raLoginResp.setAdminType(adminType);
        raLoginResp.setSignCertStatus(certStatus);
        return Result.success((Object)raLoginResp);
    }

    public Result getRAmanageTemplateInfo() {
        TemplateInfoVO innerTemplateByType = null;
        try {
            innerTemplateByType = this.templateService.getInnerTemplateByType(null, TemplateTypeEnum.MANAGER.getValue());
        }
        catch (ServiceException e) {
            this.logger.error("ca-openapi-service\u67e5\u8be2RA\u7ba1\u7406\u6a21\u677f\u4fe1\u606f\u5f02\u5e38");
            throw e;
        }
        if (null != innerTemplateByType) {
            RAmanageTemplVO raManageTemplVO = new RAmanageTemplVO();
            BeanUtils.copyProperties((Object)innerTemplateByType, (Object)raManageTemplVO);
            raManageTemplVO.setKeyAlgStr(raManageTemplVO.getKeyAlg().intValue() == KeyAlgEnum.RSA.getValue() ? KeyAlgEnum.RSA.name() : KeyAlgEnum.SM2.name());
            String signAlgStr = SignAlgTypeEnum.getViewAlgName((int)Integer.valueOf(raManageTemplVO.getSignAlg()));
            raManageTemplVO.setSignAlgStr(signAlgStr);
            raManageTemplVO.setKeyAlg(innerTemplateByType.getKeyAlg());
            List extensions = innerTemplateByType.getExtensions();
            ArrayList temParas = new ArrayList();
            if (null != extensions && !extensions.isEmpty()) {
                for (ExtensionVO extension : extensions) {
                    HashMap<String, String> extPara = new HashMap<String, String>();
                    if (extension.getIsInput() == 1) {
                        extPara.put("attrName", extension.getName());
                        extPara.put("attrOid", extension.getExtnId());
                        extPara.put("attrType", extension.getValue() == null ? "" : extension.getValue());
                        extPara.put("attrValue", "");
                    }
                    if (extPara.isEmpty()) continue;
                    temParas.add(extPara);
                }
            }
            raManageTemplVO.setTemParas(temParas);
            return Result.success((Object)raManageTemplVO);
        }
        return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
    }

    public boolean verifySign(String signAlgName, PublicKey publicKey, byte[] sourceData, byte[] signData) {
        try {
            int digest;
            if (signAlgName.equals(GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName())) {
                digest = DigestAlgEnum.SHA1.getValue();
            } else if (signAlgName.equals(GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName())) {
                digest = DigestAlgEnum.SHA256.getValue();
            } else if (signAlgName.equals(GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName())) {
                digest = DigestAlgEnum.SM3.getValue();
            } else if (signAlgName.equals(GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName())) {
                digest = DigestAlgEnum.SHA256.getValue();
            } else {
                this.logger.info("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5\uff1a" + signAlgName);
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
            }
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.ADMIN_CA_ID);
            return this.hsmManager.verifySign(caInfoVO.getKeyAlg().intValue(), digest, publicKey, sourceData, signData);
        }
        catch (Exception e) {
            throw new ServiceException("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25", (Throwable)e);
        }
    }

    public Result getRaServerCertByRaId(String sn) {
        ManageCertDataDO queryManagerCertDataById = null;
        try {
            ManageCertDO managerCertsBySn = this.managereCertDao.getManagerCertsBySn(sn);
            if (null != managerCertsBySn) {
                queryManagerCertDataById = this.managerCertDataDao.queryManagerCertDataById(managerCertsBySn.getId());
            }
        }
        catch (DAOException e) {
            throw new ServiceException("\u67e5\u8be2RA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25\uff0c", (Throwable)e);
        }
        return Result.success(queryManagerCertDataById);
    }
}

