/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.service.util;

import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.common.ConfigUtil;
import com.xdja.pki.ca.core.configBasic.bean.CaPwdBean;
import com.xdja.pki.ca.core.configBasic.bean.CaSoftServerPwdBean;
import com.xdja.pki.ca.core.util.CertUtils;
import com.xdja.pki.ca.securitymanager.service.vo.AlgTypeEnum;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.springframework.core.env.Environment;

public class CaServerPwdUtil {
    public static void saveCaServerPwdCache(Environment environment, Integer alg, Integer keyIndex, String privateKeyPin) throws Exception {
        if (alg == AlgTypeEnum.NISTP256.value || alg == AlgTypeEnum.RSA.value || Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC)) {
            CaSoftServerPwdBean caSoftServerPwdBean = new CaSoftServerPwdBean();
            caSoftServerPwdBean.setSignPrivateKeyPath(Constants.CA_ROOT_PRIVATE_PATH + "caServerSignCert.key");
            caSoftServerPwdBean.setEncPrivateKeyPath(Constants.CA_ROOT_PRIVATE_PATH + "caServerENCCert.key");
            ConfigUtil.saveCaRSAServerPwdConfig((Environment)environment, (CaSoftServerPwdBean)caSoftServerPwdBean);
        } else if (null != keyIndex) {
            CaPwdBean caPwdBean = new CaPwdBean(keyIndex, privateKeyPin);
            ConfigUtil.saveCaServerPwdConfig((Environment)environment, (CaPwdBean)caPwdBean);
        }
    }

    public static CaSoftServerPwdBean getCaRSAServerPwdCache(Environment environment, X509Certificate signCert, X509Certificate encCert) throws Exception {
        PrivateKey encPrivateKey;
        PrivateKey signPrivateKey;
        CaSoftServerPwdBean caSoftServerPwdBean = ConfigUtil.getCaRSAServerPwdConfig((Environment)environment);
        if (null != caSoftServerPwdBean) {
            caSoftServerPwdBean.setSignCert(signCert);
            caSoftServerPwdBean.setEncCert(encCert);
            CertUtils.readPrivateKeyByPath((String)caSoftServerPwdBean.getSignPrivateKeyPath());
            signPrivateKey = CertUtils.readPrivateKeyByPath((String)caSoftServerPwdBean.getSignPrivateKeyPath());
            encPrivateKey = CertUtils.readPrivateKeyByPath((String)caSoftServerPwdBean.getEncPrivateKeyPath());
        } else {
            caSoftServerPwdBean = new CaSoftServerPwdBean();
            signPrivateKey = CertUtils.readPrivateKeyByPath((String)(Constants.CA_ROOT_PRIVATE_PATH + "caServerSignCert.key"));
            encPrivateKey = CertUtils.readPrivateKeyByPath((String)(Constants.CA_ROOT_PRIVATE_PATH + "caServerENCCert.key"));
        }
        caSoftServerPwdBean.setSignPrivateKey(signPrivateKey);
        caSoftServerPwdBean.setEncPrivateKey(encPrivateKey);
        return caSoftServerPwdBean;
    }
}

