/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.service.util;

import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.pkcs7.P7bUtils;
import com.xdja.pki.ca.core.util.CertUtils;
import com.xdja.pki.ca.securitymanager.service.vo.AlgTypeEnum;
import com.xdja.pki.gmssl.tomcat.utils.GMSSLTomcatUtils;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;

public class TomcatHttpsUtil {
    public static void setTomcatHttpsPort(Integer alg, String rootCaChain, X509Certificate signCert, X509Certificate encCert, Integer keyIndex, String privateKeyPin, Integer httpsPort) {
        String tomcatPath = System.getProperty("catalina.home");
        try {
            if (Constants.BASE_ALG_TYPE == AlgTypeEnum.SM2.value) {
                if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_HSM.intValue()) {
                    GMSSLTomcatUtils.openHttpsPortByYunHsm((List)P7bUtils.resolveCertChain((String)rootCaChain), (X509Certificate)signCert, (X509Certificate)encCert, (int)keyIndex, (String)privateKeyPin, (String)tomcatPath, (int)httpsPort);
                } else {
                    PrivateKey signPrivateKey = CertUtils.readPrivateKeyByPath((String)(Constants.CA_ROOT_PRIVATE_PATH + "caServerSignCert.key"));
                    PrivateKey encPrivateKey = CertUtils.readPrivateKeyByPath((String)(Constants.CA_ROOT_PRIVATE_PATH + "caServerENCCert.key"));
                    GMSSLTomcatUtils.openHttpsPortByBC((List)P7bUtils.resolveCertChain((String)rootCaChain), (X509Certificate)signCert, (X509Certificate)encCert, (PrivateKey)signPrivateKey, (PrivateKey)encPrivateKey, (String)tomcatPath, (int)httpsPort);
                }
            } else {
                PrivateKey signPrivateKey = CertUtils.readPrivateKeyByPath((String)(Constants.CA_ROOT_PRIVATE_PATH + "caServerSignCert.key"));
                PrivateKey encPrivateKey = CertUtils.readPrivateKeyByPath((String)(Constants.CA_ROOT_PRIVATE_PATH + "caServerENCCert.key"));
                GMSSLTomcatUtils.openHttpsPortByJKSWithRSA((List)P7bUtils.resolveCertChain((String)rootCaChain), (X509Certificate)signCert, (X509Certificate)encCert, (PrivateKey)signPrivateKey, (PrivateKey)encPrivateKey, (String)tomcatPath, (int)httpsPort);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u5f00\u542ftomcat https\u7aef\u53e3\u5931\u8d25", (Throwable)e);
        }
    }
}

