/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.service.vo;

public enum SignAlgTypeEnum {
    SM3_WITH_SM2(1, "SM3WithSM2", "SM3WithSM2"),
    SHA1_WITH_RSA(2, "SHA1WithRSA", "sha-1WithRSA"),
    SH256_WITH_RSA(3, "SHA256WithRSA", "sha256WithRSA"),
    SHA256_WITH_ECDSA(4, "SHA256WithECDSA", "sha256WithECDSA");

    public int value;
    public String algName;
    public String viewAlgNsme;

    private SignAlgTypeEnum(int value, String algName, String viewAlgNsme) {
        this.value = value;
        this.algName = algName;
        this.viewAlgNsme = viewAlgNsme;
    }

    public static String getAlgName(int value) {
        for (SignAlgTypeEnum type : SignAlgTypeEnum.values()) {
            if (type.value != value) continue;
            return type.algName;
        }
        throw new IllegalArgumentException(String.format("\u503c\"%d\"\u5bf9\u5e94\u7684\u679a\u4e3e\u503c\u4e0d\u5b58\u5728", value));
    }

    public static String getViewAlgName(int value) {
        for (SignAlgTypeEnum type : SignAlgTypeEnum.values()) {
            if (type.value != value) continue;
            return type.viewAlgNsme;
        }
        throw new IllegalArgumentException(String.format("\u503c\"%d\"\u5bf9\u5e94\u7684\u679a\u4e3e\u503c\u4e0d\u5b58\u5728", value));
    }

    public static Integer getAlgValue(String algName) {
        for (SignAlgTypeEnum type : SignAlgTypeEnum.values()) {
            if (!type.algName.equalsIgnoreCase(algName)) continue;
            return type.value;
        }
        throw new IllegalArgumentException(String.format("\u503c\"%d\"\u5bf9\u5e94\u7684\u679a\u4e3e\u503c\u4e0d\u5b58\u5728", algName));
    }

    public static String getViewAlgValue(String algName) {
        for (SignAlgTypeEnum type : SignAlgTypeEnum.values()) {
            if (!type.algName.equalsIgnoreCase(algName)) continue;
            return type.viewAlgNsme;
        }
        throw new IllegalArgumentException(String.format("\u503c\"%d\"\u5bf9\u5e94\u7684\u679a\u4e3e\u503c\u4e0d\u5b58\u5728", algName));
    }
}

