/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.service.auth;

import com.xdja.pki.auth.service.AuditSignService;
import com.xdja.pki.auth.service.bean.CertInfoDTO;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDataDao;
import com.xdja.pki.ca.certmanager.dao.OutDateManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.RevokeManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.OutdateManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.RevokedManageCertDO;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.enums.CertStatusEnum;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.hsm.manager.HsmManager;
import java.security.PublicKey;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AuditSignServiceImpl
implements AuditSignService {
    @Resource
    private ManagerCertDao managerCertDao;
    @Resource
    private RevokeManagerCertDao revokeManagerCertDao;
    @Resource
    private OutDateManagerCertDao outDateManagerCertDao;
    @Resource
    private ManagerCertDataDao managerCertDataDao;
    @Resource
    private HsmManager hsmManager;
    @Value(value="${client.offset.time}")
    private int offsetTime;

    public int getSystemKeyAlg() {
        return Constants.BASE_ALG_TYPE;
    }

    public CertInfoDTO getCertBySn(String sn, int keyAlg) {
        try {
            int status;
            String subject;
            long certId;
            CertInfoDTO certInfo = null;
            Object manageCert = this.getManagerCert(sn, keyAlg);
            if (null == manageCert) {
                return certInfo;
            }
            long nowTime = System.currentTimeMillis();
            if (manageCert instanceof ManageCertDO) {
                ManageCertDO normalCert = (ManageCertDO)manageCert;
                certId = normalCert.getId();
                subject = normalCert.getSubject();
                status = normalCert.getAfterTime().getTime() < nowTime ? CertStatusEnum.EXPIRE.value : normalCert.getStatus();
            } else if (manageCert instanceof RevokedManageCertDO) {
                RevokedManageCertDO revokedCert = (RevokedManageCertDO)manageCert;
                certId = revokedCert.getId();
                subject = revokedCert.getSubject();
                status = revokedCert.getAfterTime().getTime() < nowTime ? CertStatusEnum.EXPIRE.value : CertStatusEnum.REVOKE.value;
            } else {
                OutdateManageCertDO outdateCert = (OutdateManageCertDO)manageCert;
                certId = outdateCert.getId();
                subject = outdateCert.getSubject();
                status = CertStatusEnum.EXPIRE.value;
            }
            String cert = this.managerCertDataDao.queryManagerCertDataById(Long.valueOf(certId)).getData();
            certInfo = new CertInfoDTO();
            certInfo.setSn(sn);
            certInfo.setKeyAlg(keyAlg);
            certInfo.setSubject(subject);
            certInfo.setStatus(status);
            certInfo.setData(cert);
            certInfo.setPublicKey(CertUtil.getCertFromStr((String)cert).getPublicKey());
            return certInfo;
        }
        catch (Exception e) {
            throw new ServiceException("\u6839\u636e\u8bc1\u4e66\u5e8f\u5217\u53f7\u83b7\u53d6\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public int getOffsetTime() {
        return this.offsetTime;
    }

    public boolean verifySign(int keyAlg, int degistAlg, PublicKey publicKey, byte[] sourceData, byte[] signData) {
        try {
            return this.hsmManager.verifySign(keyAlg, degistAlg, publicKey, sourceData, signData);
        }
        catch (Exception e) {
            throw new ServiceException("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25", (Throwable)e);
        }
    }

    public byte[] getDigest(byte[] data) {
        try {
            return this.hsmManager.digest(data);
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u6458\u8981\u5931\u8d25", (Throwable)e);
        }
    }

    public Object getIllegalParamError(HttpServletResponse response) {
        return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(response);
    }

    public Object getVerifyTimeError(HttpServletResponse response) {
        return ErrorEnum.CLIENT_TIME_AND_SERVER_DISACCORD.resp(response);
    }

    public Object getContentDisaccordError(HttpServletResponse response) {
        return ErrorEnum.REQUEST_BODY_AND_SIGN_BODY_DISACCORD.resp(response);
    }

    public Object getIllegalSignAlgError(HttpServletResponse response) {
        return ErrorEnum.NOT_SUPPORTED_SIGN_ALG.resp(response);
    }

    public Object getCertNotExistError(HttpServletResponse response) {
        return ErrorEnum.DOWNLOAD_CERT_NOT_EXIST.resp(response);
    }

    public Object getCertStatusError(int certStatus, HttpServletResponse response) {
        if (certStatus == CertStatusEnum.FROZEN.value) {
            return ErrorEnum.CERT_ISSUE_STATUE_FREEZE.resp(response);
        }
        if (certStatus == CertStatusEnum.REVOKE.value) {
            return ErrorEnum.CERT_ISSUE_STATUE_REVOKED.resp(response);
        }
        return ErrorEnum.CERT_ISSUE_STATUE_EXPIRED.resp(response);
    }

    public Object getVerifySignFailError(HttpServletResponse response) {
        return ErrorEnum.VERIFY_ADMIN_OPERATOR_SIGN_FAIL.resp(response);
    }

    public Object getServerInternalError(HttpServletResponse response) {
        return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(response);
    }

    private Object getManagerCert(String sn, int keyAlg) {
        ManageCertDO manageCert = this.managerCertDao.getManagerCertsBySn(sn, keyAlg);
        if (null != manageCert) {
            return manageCert;
        }
        RevokedManageCertDO revokedManageCert = this.revokeManagerCertDao.getRevokManagerCertsBySn(sn, Integer.valueOf(keyAlg));
        if (null != revokedManageCert) {
            return revokedManageCert;
        }
        OutdateManageCertDO outdateManageCert = this.outDateManagerCertDao.getOutDateManagerCertsBySn(sn, Integer.valueOf(keyAlg));
        if (null != outdateManageCert) {
            return outdateManageCert;
        }
        return null;
    }
}

