/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.service.cache;

import com.xdja.pki.ca.certmanager.service.camanagecert.ICaManageCertService;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.common.Config;
import com.xdja.pki.ca.core.common.ConfigUtil;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.configBasic.bean.ArchiveConfigBean;
import com.xdja.pki.ca.core.configBasic.bean.CaPwdBean;
import com.xdja.pki.ca.core.configBasic.bean.CaSoftServerPwdBean;
import com.xdja.pki.ca.core.configBasic.bean.DirServerConfigBean;
import com.xdja.pki.ca.core.configBasic.bean.HsmCertNameBean;
import com.xdja.pki.ca.core.configBasic.bean.OcspConfigBean;
import com.xdja.pki.ca.core.enums.HsmInfoEnum;
import com.xdja.pki.ca.securitymanager.dao.CaCertDao;
import com.xdja.pki.ca.securitymanager.dao.CaDao;
import com.xdja.pki.ca.securitymanager.dao.model.CaCertDo;
import com.xdja.pki.ca.securitymanager.dao.model.CaDO;
import com.xdja.pki.ca.securitymanager.service.configfile.ConfigFileService;
import com.xdja.pki.ca.securitymanager.service.init.LicenseService;
import com.xdja.pki.ca.securitymanager.service.vo.AlgTypeEnum;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.dynamic.task.CronTaskRegistrar;
import com.xdja.pki.dynamic.task.SchedulingRunnable;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Configuration
@Order(value=1)
public class InitCaInfo
implements CommandLineRunner {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private CaDao caDao;
    @Resource
    private CaCertDao caCertDao;
    @Autowired
    private Environment environment;
    @Resource
    private ICaManageCertService iCaManageCertService;
    @Resource
    private CronTaskRegistrar cronTaskRegistrar;
    @Resource
    private LicenseService licenseService;
    @Resource
    private ConfigFileService configFileService;

    public void run(String ... args) throws Exception {
        HsmCertNameBean hsmConfig = this.configFileService.getHsmConfig();
        if (null == hsmConfig) {
            Constants.CRYPT_DEVICE_TYPE = Constants.CRYPT_DEVICE_BC;
            GMSSLPkiCryptoInit.getBCInstance();
            this.logger.info("\u672c\u7cfb\u7edf\u91c7\u7528\u7684\u5bc6\u7801\u8bbe\u5907\u7c7b\u578b\uff1aBC");
        } else if (hsmConfig.getHsmType() == null || HsmInfoEnum.XDJA_HSM.hsmType == hsmConfig.getHsmType()) {
            Constants.CRYPT_DEVICE_TYPE = Constants.CRYPT_DEVICE_XDJA_HSM;
            GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            this.logger.info("\u672c\u7cfb\u7edf\u91c7\u7528\u7684\u5bc6\u7801\u8bbe\u5907\u7c7b\u578b\uff1aXDJA_HSM");
        } else {
            Constants.CRYPT_DEVICE_TYPE = Constants.CRYPT_DEVICE_SWXA_HSM;
            GMSSLPkiCryptoInit.getSancHsmInstance();
            this.logger.info("\u672c\u7cfb\u7edf\u91c7\u7528\u7684\u5bc6\u7801\u8bbe\u5907\u7c7b\u578b\uff1aSWXA_HSM");
        }
        Constants.SIGN_ALG_FORMAT_FLAG = ConfigUtil.getSignAlgFormatFlag((Environment)this.environment);
        Constants.KM_NOT_SUPPORT_DN = ConfigUtil.getKmNotSupportDn((Environment)this.environment);
        Constants.IS_KM = ConfigUtil.getEncIsKm((Environment)this.environment);
        List caDOList = this.caDao.getCaInfoList();
        if (null == caDOList && caDOList.size() == 0) {
            this.logger.info("CA\u672a\u8fdb\u884c\u521d\u59cb\u5316\u57fa\u672c\u914d\u7f6e\uff0c\u52a0\u8f7dCA\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
        } else {
            for (int i = 0; i < caDOList.size(); ++i) {
                CaCertDo caCertDo;
                KeyPair keyPair;
                CaInfoVO caInfoVO = new CaInfoVO();
                CaDO caDO = (CaDO)caDOList.get(i);
                BeanUtils.copyProperties((Object)caDO, (Object)caInfoVO);
                caInfoVO.setCaId(caDO.getId());
                this.logger.info("\u52a0\u8f7dbaseDN\u4fe1\u606f\u5230\u7cfb\u7edf\uff0cbaseDN\u4e3a\uff1a" + caDO.getBaseDn());
                Constants.BASE_ALG_TYPE = (int)caDO.getKeyAlg();
                if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue()) {
                    caInfoVO.setRootPrivateKey(CertUtil.getPrivateKey((String)(Constants.CA_ROOT_PRIVATE_PATH + "private.key")));
                    PublicKey publicKey = CertUtil.getPublicKey((String)(Constants.XDJA_CONF_CERT_DIRECTORY + "km.public"));
                    PrivateKey privateKey = CertUtil.getPrivateKey((String)(Constants.XDJA_CONF_CERT_DIRECTORY + "km.private"));
                    keyPair = new KeyPair(publicKey, privateKey);
                    caInfoVO.setKmsoftKeyPair(keyPair);
                }
                if (null != (caCertDo = this.caCertDao.getCACertObject(caInfoVO.getCaId()))) {
                    X509Certificate rootCert;
                    BeanUtils.copyProperties((Object)caCertDo, (Object)caInfoVO);
                    caInfoVO.setCertId(caCertDo.getId());
                    X509Certificate x509Certificate = rootCert = null == caCertDo ? null : CertUtil.getCertFromStr((String)caCertDo.getCert());
                    if (null != rootCert) {
                        caInfoVO.setRootCert(rootCert);
                        keyPair = new KeyPair(rootCert.getPublicKey(), caInfoVO.getRootPrivateKey());
                        caInfoVO.setKeyPair(keyPair);
                        caInfoVO.setSignAlg(caCertDo.getSignAlg());
                        this.logger.info("\u672c\u7cfb\u7edf\u7684\u7b7e\u540d\u7b97\u6cd5\u7c7b\u578b:" + caInfoVO.getSignAlg());
                        Config config = this.configFileService.getConfigInfo();
                        CaPwdBean caPwdBean = config.getCaPwdConfig();
                        caInfoVO.setCaPwdBean(caPwdBean);
                        DirServerConfigBean dirServerConfigBean = config.getDirServerConfig();
                        caInfoVO.setDirServerConfigBean(dirServerConfigBean);
                        if (null != dirServerConfigBean && StringUtils.isNotBlank((CharSequence)dirServerConfigBean.getMasterURL()) && StringUtils.isNotBlank((CharSequence)dirServerConfigBean.getSlaveURL())) {
                            caInfoVO.setLadp(true);
                        } else {
                            caInfoVO.setLadp(false);
                        }
                        OcspConfigBean ocspConfigBean = config.getOcspConfig();
                        if (null != ocspConfigBean && StringUtils.isNotBlank((CharSequence)ocspConfigBean.getNetworkURL()) && StringUtils.isNotBlank((CharSequence)ocspConfigBean.getInterURL())) {
                            caInfoVO.setOcspConfig(ocspConfigBean);
                            caInfoVO.setOcsp(true);
                        } else {
                            caInfoVO.setOcsp(false);
                        }
                        if (AlgTypeEnum.SM2.value == Constants.BASE_ALG_TYPE && Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_XDJA_HSM)) {
                            CaPwdBean serverPwdBean = config.getCaServerPwdConfig();
                            caInfoVO.setCaServerPwdConfig(serverPwdBean);
                        } else {
                            CaSoftServerPwdBean caSoftServerPwdBean = this.iCaManageCertService.getCaCurrServerCert();
                            caInfoVO.setCaSoftServerPwdBean(caSoftServerPwdBean);
                            caInfoVO.setCaServerPwdConfig(null);
                        }
                        caInfoVO.setCertPolicy(ConfigUtil.getCertPolicy((Environment)this.environment));
                        if (config.getKmSystemType() == 1) {
                            caInfoVO.setKmConfigBean(config.getKmConfigBean());
                        } else if (config.getKmSystemType() == 2) {
                            caInfoVO.setXdjaKmConfigBean(config.getXdjaKmConfigBean());
                        }
                        ArchiveConfigBean archiveConfigBean = config.getArchiveConfig();
                        if (null != archiveConfigBean) {
                            caInfoVO.setArchiveConfigBean(archiveConfigBean);
                            if (null != archiveConfigBean.getAutoArchiveFlag()) {
                                if (archiveConfigBean.getAutoArchiveFlag() == 1) {
                                    this.cronTaskRegistrar.addCronTask((Runnable)new SchedulingRunnable("auditLogServiceImpl", "doAutoArchiveOperateLog"), archiveConfigBean.getAutoArchiveCron());
                                }
                                if (archiveConfigBean.getAutoArchiveFlag() == 0) {
                                    SchedulingRunnable runnable = new SchedulingRunnable("auditLogServiceImpl", "doAutoArchiveOperateLog");
                                    this.cronTaskRegistrar.removeCronTask((Runnable)runnable);
                                }
                            }
                        }
                    }
                }
                Constants.CA_INFO.put(Integer.valueOf(caDO.getKeyAlg()), caInfoVO);
            }
        }
        Result result = this.licenseService.getCurrentLicenseInfoByFile();
        if (!result.isSuccess()) {
            this.logger.error("license\u52a0\u8f7d\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a" + result.getError().desc);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

