/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.service.configfile;

import com.xdja.pki.ca.core.common.Config;
import com.xdja.pki.ca.core.configBasic.bean.ArchiveConfigBean;
import com.xdja.pki.ca.core.configBasic.bean.CaPwdBean;
import com.xdja.pki.ca.core.configBasic.bean.CaSoftServerPwdBean;
import com.xdja.pki.ca.core.configBasic.bean.DirServerConfigBean;
import com.xdja.pki.ca.core.configBasic.bean.HsmCertNameBean;
import com.xdja.pki.ca.core.configBasic.bean.KmConfigBean;
import com.xdja.pki.ca.core.configBasic.bean.OcspConfigBean;
import com.xdja.pki.ca.core.configBasic.bean.XdjaKmConfigBean;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.json.JsonMapper;
import com.xdja.pki.ca.securitymanager.dao.ConfigFileDao;
import com.xdja.pki.ca.securitymanager.dao.model.ConfigFileDO;
import com.xdja.pki.ca.securitymanager.service.configfile.ConfigFileService;
import com.xdja.pki.ca.securitymanager.service.vo.ConfigFileVO;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigFileServiceImpl
implements ConfigFileService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigFileServiceImpl.class);
    @Autowired
    ConfigFileDao configFileDao;

    public void updateConfigFile(ConfigFileVO configFile) {
        try {
            ConfigFileDO configFileDO = new ConfigFileDO();
            BeanUtils.copyProperties((Object)configFile, (Object)configFileDO);
            configFileDO.setGmtModified(new Date());
            this.configFileDao.update(configFileDO);
        }
        catch (Exception e) {
            throw new ServiceException("\u66f4\u65b0\u914d\u7f6e\u6587\u4ef6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public ConfigFileVO queryConfigFileByName(String fileName) {
        try {
            ConfigFileDO configFileDO = this.configFileDao.getConfigFileByName(fileName);
            if (configFileDO == null) {
                return null;
            }
            ConfigFileVO vo = new ConfigFileVO();
            BeanUtils.copyProperties((Object)configFileDO, (Object)vo);
            return vo;
        }
        catch (Exception e) {
            throw new ServiceException("\u6839\u636e\u6587\u4ef6\u540d\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public Config getConfigInfo() {
        try {
            ConfigFileVO configFileVO = this.getConfigFile();
            Config config = (Config)JsonMapper.alwaysMapper().fromJson(configFileVO.getFileValue(), Config.class);
            return config;
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u6587\u4ef6\u540d\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u6839\u636e\u6587\u4ef6\u540d\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public int getCurrInitStep() {
        try {
            Config config = this.getConfigInfo();
            return config.getInitStep();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5f53\u524d\u521d\u59cb\u5316\u6b65\u9aa4\u6570\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u83b7\u53d6\u5f53\u524d\u521d\u59cb\u5316\u6b65\u9aa4\u6570\u5931\u8d25", (Throwable)e);
        }
    }

    public boolean verifyCurInitStep(int step) {
        try {
            Config config = this.getConfigInfo();
            return step == config.getInitStep();
        }
        catch (Exception e) {
            logger.error("\u5224\u65ad\u64cd\u4f5c\u6b65\u9aa4\u662f\u5426\u6b63\u786e\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u5224\u65ad\u64cd\u4f5c\u6b65\u9aa4\u662f\u5426\u6b63\u786e\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveConfigInfo(Config config) {
        try {
            ConfigFileVO configFileVO = this.queryConfigFileByName(ConfigFileDO.ConfigFileEnum.CONFIG_JSON.fileName);
            if (configFileVO == null) {
                logger.error("\u914d\u7f6e\u6587\u4ef6{}\u4e0d\u6b63\u786e", (Object)ConfigFileDO.ConfigFileEnum.CONFIG_JSON.fileName);
                throw new ServiceException("\u914d\u7f6e\u6587\u4ef6\u4e0d\u6b63\u786e");
            }
            String fileValue = JsonMapper.alwaysMapper().toJson((Object)config);
            configFileVO.setFileValue(fileValue);
            this.updateConfigFile(configFileVO);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveCaPwdConfig(CaPwdBean caPwdBean) {
        try {
            ConfigFileVO configFileVO = this.getConfigFile();
            Config config = (Config)JsonMapper.alwaysMapper().fromJson(configFileVO.getFileValue(), Config.class);
            config.setCaPwdConfig(caPwdBean);
            configFileVO.setFileValue(JsonMapper.alwaysMapper().toJson((Object)config));
            this.updateConfigFile(configFileVO);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58CA\u5bc6\u94a5\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u4fdd\u5b58CA\u5bc6\u94a5\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveOldCaPwdConfig(CaPwdBean caPwdBean) {
        try {
            ConfigFileVO configFileVO = this.getConfigFile();
            Config config = (Config)JsonMapper.alwaysMapper().fromJson(configFileVO.getFileValue(), Config.class);
            config.setOldCaPwdBean(caPwdBean);
            configFileVO.setFileValue(JsonMapper.alwaysMapper().toJson((Object)config));
            this.updateConfigFile(configFileVO);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u65e7CA\u5bc6\u94a5\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u4fdd\u5b58\u65e7CA\u5bc6\u94a5\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveKeyAlg(Integer keyAlg) {
        try {
            ConfigFileVO configFileVO = this.getConfigFile();
            Config config = (Config)JsonMapper.alwaysMapper().fromJson(configFileVO.getFileValue(), Config.class);
            config.setKeyAlg(keyAlg);
            configFileVO.setFileValue(JsonMapper.alwaysMapper().toJson((Object)config));
            this.updateConfigFile(configFileVO);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u672c\u7cfb\u7edf\u4f7f\u7528\u7684\u5bc6\u94a5\u7b97\u6cd5\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u4fdd\u5b58\u672c\u7cfb\u7edf\u4f7f\u7528\u7684\u5bc6\u94a5\u7b97\u6cd5\u5931\u8d25", (Throwable)e);
        }
    }

    public Integer getKeyAlg() {
        try {
            Config config = this.getConfigInfo();
            return config.getKeyAlg();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u672c\u7cfb\u7edf\u4f7f\u7528\u7684\u5bc6\u94a5\u7b97\u6cd5\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u83b7\u53d6\u672c\u7cfb\u7edf\u4f7f\u7528\u7684\u5bc6\u94a5\u7b97\u6cd5\u5931\u8d25", (Throwable)e);
        }
    }

    public CaPwdBean getCaPwdBean() {
        try {
            Config config = this.getConfigInfo();
            return config.getCaPwdConfig();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6CA\u5bc6\u94a5hsm\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u83b7\u53d6CA\u5bc6\u94a5hsm\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public CaPwdBean getOldCaPwdBean() {
        try {
            Config config = this.getConfigInfo();
            return config.getOldCaPwdBean();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u65e7\u5bc6\u94a5\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u83b7\u53d6\u65e7\u5bc6\u94a5\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public CaPwdBean getCaServerPwdConfig() {
        try {
            Config config = this.getConfigInfo();
            return config.getCaServerPwdConfig();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6CA\u5f53\u524d\u670d\u52a1\u5668\u8bc1\u4e66\u5bc6\u94a5\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u83b7\u53d6CA\u5f53\u524d\u670d\u52a1\u5668\u8bc1\u4e66\u5bc6\u94a5\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveCaServerPwdConfig(CaPwdBean caPwdBean) {
        try {
            ConfigFileVO configFileVO = this.getConfigFile();
            Config config = (Config)JsonMapper.alwaysMapper().fromJson(configFileVO.getFileValue(), Config.class);
            config.setCaServerPwdConfig(caPwdBean);
            configFileVO.setFileValue(JsonMapper.alwaysMapper().toJson((Object)config));
            this.updateConfigFile(configFileVO);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58CA\u5f53\u524d\u670d\u52a1\u5668\u8bc1\u4e66\u5bc6\u94a5\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u4fdd\u5b58CA\u5f53\u524d\u670d\u52a1\u5668\u8bc1\u4e66\u5bc6\u94a5\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveCaRSAServerPwdConfig(CaSoftServerPwdBean caSoftServerPwdBean) {
        try {
            ConfigFileVO configFileVO = this.getConfigFile();
            Config config = (Config)JsonMapper.alwaysMapper().fromJson(configFileVO.getFileValue(), Config.class);
            config.setCaSoftServerPwdBean(caSoftServerPwdBean);
            configFileVO.setFileValue(JsonMapper.alwaysMapper().toJson((Object)config));
            this.updateConfigFile(configFileVO);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58CA\u5f53\u524dRSA\u670d\u52a1\u5668\u8bc1\u4e66\u5bc6\u94a5\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u4fdd\u5b58CA\u5f53\u524dRSA\u670d\u52a1\u5668\u8bc1\u4e66\u5bc6\u94a5\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public CaSoftServerPwdBean getCaRSAServerPwdConfig() {
        try {
            Config config = this.getConfigInfo();
            return config.getCaSoftServerPwdBean();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6CA\u5f53\u524dRSA\u670d\u52a1\u5668\u8bc1\u4e66\u5bc6\u94a5\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u83b7\u53d6CA\u5f53\u524dRSA\u670d\u52a1\u5668\u8bc1\u4e66\u5bc6\u94a5\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveDirServerConfig(DirServerConfigBean dirServerConfigBean) {
        try {
            ConfigFileVO configFileVO = this.getConfigFile();
            Config config = (Config)JsonMapper.alwaysMapper().fromJson(configFileVO.getFileValue(), Config.class);
            if (null != config.getDirServerConfig()) {
                if (StringUtils.isNotBlank((CharSequence)config.getDirServerConfig().getSlaveURL())) {
                    dirServerConfigBean.setSlaveURL(config.getDirServerConfig().getSlaveURL());
                }
                if (StringUtils.isNotBlank((CharSequence)config.getDirServerConfig().getExtranetHttpURL())) {
                    dirServerConfigBean.setExtranetHttpURL(config.getDirServerConfig().getExtranetHttpURL());
                }
            }
            config.setDirServerConfig(dirServerConfigBean);
            configFileVO.setFileValue(JsonMapper.alwaysMapper().toJson((Object)config));
            this.updateConfigFile(configFileVO);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58LDAP\u670d\u52a1\u5668\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u4fdd\u5b58LDAP\u670d\u52a1\u5668\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
    }

    public DirServerConfigBean getDirServerConfig() {
        try {
            Config config = this.getConfigInfo();
            return config.getDirServerConfig();
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6ldap\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u8bfb\u53d6ldap\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveOcspConfig(OcspConfigBean ocspConfigBean) {
        try {
            ConfigFileVO configFileVO = this.getConfigFile();
            Config config = (Config)JsonMapper.alwaysMapper().fromJson(configFileVO.getFileValue(), Config.class);
            if (null != config.getOcspConfig() && StringUtils.isNotBlank((CharSequence)config.getOcspConfig().getNetworkURL())) {
                ocspConfigBean.setNetworkURL(config.getOcspConfig().getNetworkURL());
            }
            config.setOcspConfig(ocspConfigBean);
            configFileVO.setFileValue(JsonMapper.alwaysMapper().toJson((Object)config));
            this.updateConfigFile(configFileVO);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58OCSP\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u4fdd\u5b58OCSP\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public OcspConfigBean getOcspConfig() {
        try {
            Config config = this.getConfigInfo();
            return config.getOcspConfig();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6OCSP\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u83b7\u53d6OCSP\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public void resetConfig() {
        try {
            Config config = new Config();
            config.setInitStep(0);
            ConfigFileVO configFileVO = this.getConfigFile();
            configFileVO.setFileValue(JsonMapper.alwaysMapper().toJson((Object)config));
            this.updateConfigFile(configFileVO);
        }
        catch (Exception e) {
            logger.error("\u5c06config\u6062\u590d\u51fa\u5382\u8bbe\u7f6e\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u5c06config\u6062\u590d\u51fa\u5382\u8bbe\u7f6e\u5931\u8d25", (Throwable)e);
        }
    }

    public boolean verifySystemInitIsOK() {
        try {
            int step = this.getCurrInitStep();
            return 11 < step;
        }
        catch (Exception e) {
            logger.error("\u5224\u65ad\u7cfb\u7edf\u662f\u5426\u521d\u59cb\u5316\u5b8c\u6210\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u5224\u65ad\u7cfb\u7edf\u662f\u5426\u521d\u59cb\u5316\u5b8c\u6210\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveKmConfig(KmConfigBean kmConfigBean) {
        try {
            ConfigFileVO configFileVO = this.getConfigFile();
            Config config = (Config)JsonMapper.alwaysMapper().fromJson(configFileVO.getFileValue(), Config.class);
            config.setKmConfigBean(kmConfigBean);
            configFileVO.setFileValue(JsonMapper.alwaysMapper().toJson((Object)config));
            this.updateConfigFile(configFileVO);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58Km\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u4fdd\u5b58Km\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public KmConfigBean getKmConfig() {
        try {
            Config config = this.getConfigInfo();
            return config.getKmConfigBean();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6Km\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u83b7\u53d6Km\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveTmpKmConfig(KmConfigBean kmConfigBean) {
        try {
            ConfigFileVO configFileVO = this.getConfigFile();
            Config config = (Config)JsonMapper.alwaysMapper().fromJson(configFileVO.getFileValue(), Config.class);
            config.setKmTmpConfigBean(kmConfigBean);
            configFileVO.setFileValue(JsonMapper.alwaysMapper().toJson((Object)config));
            this.updateConfigFile(configFileVO);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u4e34\u65f6Km\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u4fdd\u5b58\u4e34\u65f6Km\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public KmConfigBean getTmpKmConfig() {
        try {
            Config config = this.getConfigInfo();
            return config.getKmTmpConfigBean();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e34\u65f6Km\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u83b7\u53d6\u4e34\u65f6Km\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public HsmCertNameBean getHsmConfig() {
        try {
            Config config = this.getConfigInfo();
            return config.getHsmCertNameBean();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6hsm\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u83b7\u53d6hsm\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveHsmConfig(HsmCertNameBean hsmCertNameBean) {
        try {
            ConfigFileVO configFileVO = this.getConfigFile();
            Config config = (Config)JsonMapper.alwaysMapper().fromJson(configFileVO.getFileValue(), Config.class);
            config.setHsmCertNameBean(hsmCertNameBean);
            configFileVO.setFileValue(JsonMapper.alwaysMapper().toJson((Object)config));
            this.updateConfigFile(configFileVO);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58hsm\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u4fdd\u5b58hsm\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public XdjaKmConfigBean getXdjaKmConfigBean() {
        try {
            Config config = this.getConfigInfo();
            return config.getXdjaKmConfigBean();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u83b7\u53d6\u4fe1\u5927\u6377\u5b89KM\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u83b7\u53d6\u83b7\u53d6\u4fe1\u5927\u6377\u5b89KM\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveXdjaKmConfigBean(XdjaKmConfigBean xdjaKmConfigBean) {
        try {
            ConfigFileVO configFileVO = this.getConfigFile();
            Config config = (Config)JsonMapper.alwaysMapper().fromJson(configFileVO.getFileValue(), Config.class);
            config.setXdjaKmConfigBean(xdjaKmConfigBean);
            configFileVO.setFileValue(JsonMapper.alwaysMapper().toJson((Object)config));
            this.updateConfigFile(configFileVO);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u4fe1\u5927\u6377\u5b89KM\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u4fdd\u5b58\u4fe1\u5927\u6377\u5b89KM\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveArchiveConfig(ArchiveConfigBean archiveConfigBean) {
        try {
            ConfigFileVO configFileVO = this.getConfigFile();
            Config config = (Config)JsonMapper.alwaysMapper().fromJson(configFileVO.getFileValue(), Config.class);
            config.setArchiveConfig(archiveConfigBean);
            configFileVO.setFileValue(JsonMapper.alwaysMapper().toJson((Object)config));
            this.updateConfigFile(configFileVO);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u5ba1\u8ba1\u53c2\u6570\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u4fdd\u5b58\u5ba1\u8ba1\u53c2\u6570\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
    }

    public ArchiveConfigBean getArchiveConfig() {
        try {
            Config config = this.getConfigInfo();
            return config.getArchiveConfig();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5ba1\u8ba1\u53c2\u6570\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u83b7\u53d6\u5ba1\u8ba1\u53c2\u6570\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
    }

    public void saveKmSystemType(int kmSystemType) {
        try {
            ConfigFileVO configFileVO = this.getConfigFile();
            Config config = (Config)JsonMapper.alwaysMapper().fromJson(configFileVO.getFileValue(), Config.class);
            config.setKmSystemType(kmSystemType);
            configFileVO.setFileValue(JsonMapper.alwaysMapper().toJson((Object)config));
            this.updateConfigFile(configFileVO);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58km\u7cfb\u7edf\u7c7b\u578b\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u4fdd\u5b58km\u7cfb\u7edf\u7c7b\u578b\u5931\u8d25", (Throwable)e);
        }
    }

    public Integer getKmSystemType() {
        try {
            Config config = this.getConfigInfo();
            return config.getKmSystemType();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6km\u7cfb\u7edf\u7c7b\u578b\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u83b7\u53d6km\u7cfb\u7edf\u7c7b\u578b\u5931\u8d25", (Throwable)e);
        }
    }

    private ConfigFileVO getConfigFile() {
        ConfigFileVO configFileVO = this.queryConfigFileByName(ConfigFileDO.ConfigFileEnum.CONFIG_JSON.fileName);
        if (configFileVO == null) {
            logger.error("\u914d\u7f6e\u6587\u4ef6{}\u4e0d\u6b63\u786e", (Object)ConfigFileDO.ConfigFileEnum.CONFIG_JSON.fileName);
            throw new ServiceException("\u914d\u7f6e\u6587\u4ef6\u4e0d\u6b63\u786e");
        }
        return configFileVO;
    }
}

