/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.service.init;

import com.xdja.pki.ca.certmanager.dao.ManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDataDao;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDataDO;
import com.xdja.pki.ca.certmanager.service.crltemplate.CrlTemplateService;
import com.xdja.pki.ca.certmanager.service.racert.bean.PwdUsedEnum;
import com.xdja.pki.ca.certmanager.service.task.TaskDataService;
import com.xdja.pki.ca.certmanager.service.template.TemplateService;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateInfoVO;
import com.xdja.pki.ca.certmanager.service.util.ExtensionUtil;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.ca.util.gm.cert.RsaAlgUtils;
import com.xdja.pki.ca.core.common.Config;
import com.xdja.pki.ca.core.common.ConfigUtil;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.configBasic.bean.CaPwdBean;
import com.xdja.pki.ca.core.configBasic.bean.DirServerConfigBean;
import com.xdja.pki.ca.core.configBasic.bean.OcspConfigBean;
import com.xdja.pki.ca.core.enums.KeyLengthEnum;
import com.xdja.pki.ca.core.enums.P10typeEnum;
import com.xdja.pki.ca.core.enums.TemplateStatusEnum;
import com.xdja.pki.ca.core.enums.TemplateTypeEnum;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.pkcs7.P7bUtils;
import com.xdja.pki.ca.core.util.CertUtils;
import com.xdja.pki.ca.core.util.DnUtil;
import com.xdja.pki.ca.core.util.TomcatUtil;
import com.xdja.pki.ca.core.util.time.DateTimeUtil;
import com.xdja.pki.ca.core.util.time.IssueTimeUtil;
import com.xdja.pki.ca.hsm.manager.HsmManager;
import com.xdja.pki.ca.ldap.service.vo.LdapOcspUrlVO;
import com.xdja.pki.ca.securitymanager.dao.AdminRoleDao;
import com.xdja.pki.ca.securitymanager.dao.CaCertDao;
import com.xdja.pki.ca.securitymanager.dao.CaDao;
import com.xdja.pki.ca.securitymanager.dao.CaServerCertDao;
import com.xdja.pki.ca.securitymanager.dao.CertSnDao;
import com.xdja.pki.ca.securitymanager.dao.DicDao;
import com.xdja.pki.ca.securitymanager.dao.ManagerCertIdDao;
import com.xdja.pki.ca.securitymanager.dao.RoleDao;
import com.xdja.pki.ca.securitymanager.dao.model.AdminRoleDO;
import com.xdja.pki.ca.securitymanager.dao.model.CaCertDo;
import com.xdja.pki.ca.securitymanager.dao.model.CaDO;
import com.xdja.pki.ca.securitymanager.dao.model.CaInfoDO;
import com.xdja.pki.ca.securitymanager.dao.model.CaServerCertDo;
import com.xdja.pki.ca.securitymanager.dao.model.RoleDO;
import com.xdja.pki.ca.securitymanager.service.configfile.ConfigFileService;
import com.xdja.pki.ca.securitymanager.service.init.InitService;
import com.xdja.pki.ca.securitymanager.service.init.LicenseService;
import com.xdja.pki.ca.securitymanager.service.util.CaServerPwdUtil;
import com.xdja.pki.ca.securitymanager.service.util.TomcatHttpsUtil;
import com.xdja.pki.ca.securitymanager.service.vo.AlgTypeEnum;
import com.xdja.pki.ca.securitymanager.service.vo.BasicConfigVO;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.CaManagerCertVO;
import com.xdja.pki.ca.securitymanager.service.vo.CaManagerRoleEnum;
import com.xdja.pki.ca.securitymanager.service.vo.CertIssueInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.CreateP10VO;
import com.xdja.pki.ca.securitymanager.service.vo.InitAlgInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.ServerCertIsCurrentEnum;
import com.xdja.pki.ca.securitymanager.service.vo.SignAlgTypeEnum;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLSancHsmUtils;
import com.xdja.pki.gmssl.tomcat.utils.GMSSLTomcatUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmExceptionEnum;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.math.BigInteger;
import java.net.URL;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.catalina.util.ParameterMap;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.ResourceUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class InitServiceImpl
implements InitService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CaDao caDao;
    @Autowired
    private CaCertDao caCertDao;
    @Autowired
    private CertSnDao certSnDao;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private DicDao dicDao;
    @Autowired
    private ManagerCertDao managereCertDao;
    @Autowired
    private ManagerCertDataDao managerCertDataDao;
    @Autowired
    private CaServerCertDao caServerCertDao;
    @Autowired
    private AdminRoleDao adminRoleDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private HsmManager hsmService;
    @Autowired
    private Environment environment;
    @Autowired
    CrlTemplateService crlTemplateService;
    @Autowired
    private TaskDataService taskDataService;
    @Autowired
    private ManagerCertIdDao managerCertIdDao;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private ConfigFileService configFileService;
    @Value(value="${config.path}")
    private String configPath;
    @Value(value="${http.port}")
    private String httpPort;

    public Result getInitAlgInfo(Integer type, int initStep) {
        TemplateInfoVO templateInfoVO = new TemplateInfoVO();
        templateInfoVO.setKeySize(Integer.valueOf(256));
        templateInfoVO.setKeyAlg(Integer.valueOf(2));
        templateInfoVO.setSignAlg("1");
        templateInfoVO.setMaxValidity(Integer.valueOf(111111));
        if (null == templateInfoVO) {
            this.logger.info("\u83b7\u53d6\u6a21\u677f\u57fa\u672c\u7b97\u6cd5\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6a21\u677f\u4e0d\u5b58\u5728");
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
        }
        InitAlgInfoVO initAlgInfoVO = new InitAlgInfoVO();
        BeanUtils.copyProperties((Object)templateInfoVO, (Object)initAlgInfoVO);
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(templateInfoVO.getKeyAlg());
        initAlgInfoVO.setBaseDn(caInfoVO.getBaseDn());
        Map signDics = this.dicDao.getDicsByParentCode("signAlg");
        initAlgInfoVO.setSignAlgStr((String)signDics.get(templateInfoVO.getSignAlg()));
        return Result.success((Object)initAlgInfoVO);
    }

    public Result doIssueSelfRootCert(CertIssueInfoVO certIssueInfoVO) {
        TemplateInfoVO templateInfoVO = this.templateService.getInnerTemplateByType(TemplateTypeEnum.ROOT_CA.value);
        if (AlgTypeEnum.NISTP256.value == templateInfoVO.getKeyAlg() && GMSSLCryptoType.SANC_HSM == GMSSLPkiCryptoInit.getCryptoType()) {
            this.logger.info("\u7cfb\u7edf\u521d\u59cb\u5316-\u7b7e\u53d1CA\u6839\u8bc1\u4e66\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6839\u8bc1\u4e66\u5df2\u7ecf\u7b7e\u53d1\u8fc7");
            return Result.failure((ErrorEnum)ErrorEnum.UNSUPPORTED_ALGORITHM_EXCEPTION);
        }
        PublicKey publicKey = this.hsmService.getSignPublicKeyByCryptyDevice(certIssueInfoVO.getKeyIndex(), Integer.valueOf(PwdUsedEnum.ROOT_CERT_TYPE.value), templateInfoVO.getKeyAlg(), templateInfoVO.getKeySize());
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(templateInfoVO.getKeyAlg());
        Result result = this.checkIssueCertParams(certIssueInfoVO.getDn(), templateInfoVO, caInfoVO, 3, TemplateTypeEnum.ROOT_CA.value, publicKey, certIssueInfoVO.getKeyIndex(), certIssueInfoVO.getPrivateKeyPin());
        if (!result.isSuccess()) {
            this.logger.debug("\u4e0d\u7b26\u5408\u81ea\u7b7e\u53d1\u6839\u8bc1\u4e66\u6761\u4ef6,\u81ea\u7b7e\u53d1\u6839\u8bc1\u4e66\u5931\u8d25");
            return result;
        }
        if (null != caInfoVO.getRootCert()) {
            this.logger.info("\u7cfb\u7edf\u521d\u59cb\u5316-\u7b7e\u53d1CA\u6839\u8bc1\u4e66\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6839\u8bc1\u4e66\u5df2\u7ecf\u7b7e\u53d1\u8fc7");
            return Result.failure((ErrorEnum)ErrorEnum.INIT_ROOT_SELFCERT_HAS_ISSUED);
        }
        try {
            Date nowTime = new Date();
            Date endTime = IssueTimeUtil.getCorrectTime((Long)certIssueInfoVO.getValidity(), (Integer)templateInfoVO.getMaxValidity(), (Date)nowTime);
            BigInteger certSn = this.certSnDao.getMaxSn(nowTime);
            LdapOcspUrlVO ldapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(certSn, certIssueInfoVO.getDn(), caInfoVO, true, null, null);
            List extensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), null, (PublicKey)publicKey, (String)certIssueInfoVO.getDn(), (LdapOcspUrlVO)ldapOcspUrlVO, (boolean)true);
            CaPwdBean caPwdBean = new CaPwdBean(certIssueInfoVO.getKeyIndex(), certIssueInfoVO.getPrivateKeyPin());
            caInfoVO.setCaPwdBean(caPwdBean);
            caInfoVO.setSubject(certIssueInfoVO.getDn());
            X509Certificate rootCert = this.hsmService.genRootX509Certificate(certIssueInfoVO.getDn(), certSn, nowTime, endTime, publicKey, caInfoVO, extensions, templateInfoVO.getSignAlg());
            ArrayList<X509Certificate> x509List = new ArrayList<X509Certificate>();
            x509List.add(rootCert);
            CaCertDo caCertDo = this.buildRootCert(rootCert, x509List, caInfoVO.getCaId());
            caCertDo.setCaId(caInfoVO.getCaId());
            caCertDo = this.caCertDao.save(caCertDo);
            this.saveCaInfoCache(templateInfoVO.getKeyAlg(), caCertDo, caInfoVO, rootCert);
            this.configFileService.saveCaPwdConfig(caPwdBean);
            this.taskDataService.savePublishCert(caCertDo.getId(), null, Integer.valueOf(3));
            return this.reportInitStep(3);
        }
        catch (Exception e) {
            throw new ServiceException("\u7b7e\u53d1CA\u6839\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    private void saveCaInfoCache(Integer keyAlg, CaCertDo caCertDo, CaInfoVO caInfoVO, X509Certificate rootCert) {
        caInfoVO.setRootCert(rootCert);
        BeanUtils.copyProperties((Object)caCertDo, (Object)caInfoVO);
        caInfoVO.setCertId(caCertDo.getId());
        Constants.CA_INFO.put(keyAlg, caInfoVO);
    }

    public Result checkIssueCertParams(String dn, TemplateInfoVO templateInfoVO, CaInfoVO caInfoVO, Integer initStep, Integer innerTemplateType, PublicKey publicKey, Integer keyIndex, String privateKeyPin) {
        Result result;
        boolean flag;
        if (null == templateInfoVO) {
            this.logger.debug("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u7ed3\u679c\uff1a\u6a21\u677f\u4e0d\u5b58\u5728[{}]", (Object)innerTemplateType);
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
        }
        if (TemplateStatusEnum.NORMAL.value != templateInfoVO.getStatus()) {
            this.logger.info("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u7ed3\u679c\uff1a\u6a21\u677f\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u6a21\u677f\u72b6\u6001\u4e3a[{}]", (Object)templateInfoVO.getStatus());
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_STATUS_IS_STOP);
        }
        if (null == caInfoVO || StringUtils.isBlank((CharSequence)caInfoVO.getBaseDn())) {
            this.logger.debug("\u7b7e\u53d1\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u5230CA\u57fa\u672c\u4fe1\u606f[{}]", (Object)dn);
            return Result.failure((ErrorEnum)ErrorEnum.CA_BASEINFO_GET_FAIL);
        }
        if (null != initStep && !this.configFileService.verifyCurInitStep(initStep.intValue())) {
            this.logger.debug("\u521d\u59cb\u5316\u6b65\u9aa4\u9519\u8bef,\u5f53\u524d\u521d\u59cb\u5316\u6b65\u9aa4\u4e3a\uff1a" + this.configFileService.getCurrInitStep());
            return Result.failure((ErrorEnum)ErrorEnum.INIT_STEP_ERROR);
        }
        if ((null == initStep || 5 <= initStep) && null == caInfoVO.getRootCert()) {
            this.logger.debug("\u7b7e\u53d1\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u5230CA\u6839\u8bc1\u4e66\u4fe1\u606f");
            return Result.failure((ErrorEnum)ErrorEnum.CA_BASEINFO_GET_FAIL);
        }
        if (!dn.toLowerCase().endsWith(caInfoVO.getBaseDn().toLowerCase())) {
            this.logger.debug("\u7b7e\u53d1\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e2d\u7684baseDn\u4e0d\u6b63\u786edn=[{}],baseDn=[{}]", (Object)dn, (Object)caInfoVO.getBaseDn());
            return Result.failure((ErrorEnum)ErrorEnum.BASEDN_ERROR);
        }
        if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_XDJA_HSM.intValue() && null != keyIndex && !(flag = GMSSLSM2KeyUtils.getPrivateKeyAccessRightFromYunHsm((int)keyIndex, (String)privateKeyPin))) {
            this.logger.debug("\u4fe1\u5927\u6377\u5b89\u5bc6\u7801\u673a\u4e24\u7801\u6ca1\u6709\u8bbf\u95ee\u6743\u9650keyIndex=[{}],privateKeyPin=[{}]", (Object)keyIndex, (Object)privateKeyPin);
            return Result.failure((ErrorEnum)ErrorEnum.HSM_KEY_PIN_ERROR);
        }
        if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_SWXA_HSM.intValue() && null != keyIndex) {
            try {
                YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLSancHsmUtils.testConnect();
                if (yunHsmExceptionEnum.id != YunHsmExceptionEnum.NORMAL.id) {
                    this.logger.debug("\u8fde\u63a5\u4e09\u672a\u4fe1\u5b89\u5bc6\u7801\u673a\u5f02\u5e38keyIndex=[{}]", (Object)keyIndex);
                    return Result.failure((ErrorEnum)ErrorEnum.HSM_KEY_PIN_ERROR);
                }
            }
            catch (Exception e) {
                this.logger.debug("\u83b7\u53d6\u4e09\u672a\u4fe1\u5b89\u5bc6\u7801\u673a\u5f02\u5e38keyIndex=[{}]", (Object)keyIndex);
                return Result.failure((ErrorEnum)ErrorEnum.HSM_KEY_PIN_ERROR);
            }
        }
        if (!(result = RsaAlgUtils.checkPublicParams((PublicKey)publicKey, (Integer)templateInfoVO.getKeyAlg(), (Integer)templateInfoVO.getKeySize())).isSuccess()) {
            return result;
        }
        try {
            X500Name x500Name = DnUtil.getRFC4519X500Name((String)dn);
        }
        catch (Exception e) {
            this.logger.debug("DN\u4e0d\u7b26\u5408X500\u89c4\u8303dn=[{}]", (Object)dn);
            return Result.failure((ErrorEnum)ErrorEnum.DN_FORMAT_FAIL);
        }
        return Result.success();
    }

    public CaCertDo buildRootCert(X509Certificate rootCert, List<X509Certificate> x509List, Long caId) throws Exception {
        CaCertDo caCertDo = new CaCertDo();
        caCertDo.setCaId(caId);
        caCertDo.setAfterTime(rootCert.getNotAfter());
        caCertDo.setBeforeTime(rootCert.getNotBefore());
        caCertDo.setCert(CertUtil.writeObject((Object)rootCert));
        caCertDo.setGmtCreate(new Date());
        caCertDo.setIsCurrent(Integer.valueOf(CaDO.CaMasterEnum.YES.value));
        caCertDo.setCertChain(P7bUtils.createCertChainByCerts(x509List));
        caCertDo.setIssue(CertUtil.getIssuerByX509Cert((X509Certificate)rootCert));
        caCertDo.setPublicKeyAlg(Constants.BASE_ALG_TYPE);
        if (AlgTypeEnum.SM2.value == Constants.BASE_ALG_TYPE) {
            caCertDo.setPrivateKeySize(Integer.valueOf(KeyLengthEnum.SM2.length));
            caCertDo.setSignAlg(String.valueOf(SignAlgTypeEnum.SM3_WITH_SM2.value));
        } else if (AlgTypeEnum.RSA.value == Constants.BASE_ALG_TYPE) {
            caCertDo.setPrivateKeySize(RsaAlgUtils.getRsaAlgLength((PublicKey)rootCert.getPublicKey()));
            caCertDo.setSignAlg(String.valueOf(SignAlgTypeEnum.getAlgValue((String)rootCert.getSigAlgName())));
        } else {
            caCertDo.setPrivateKeySize(Integer.valueOf(KeyLengthEnum.NIST.length));
            caCertDo.setSignAlg(String.valueOf(SignAlgTypeEnum.SHA256_WITH_ECDSA.value));
        }
        caCertDo.setSn(rootCert.getSerialNumber().toString(16));
        caCertDo.setSubject(CertUtil.getSubjectByX509Cert((X509Certificate)rootCert));
        caCertDo.setStatus(Integer.valueOf(1));
        return caCertDo;
    }

    public Result doIssueCaServerCert(CertIssueInfoVO certIssueInfoVO) {
        CaServerCertDo caServerCertDo = this.caServerCertDao.getCurrentCaServerCert();
        if (null != caServerCertDo) {
            this.logger.debug("\u521d\u59cb\u5316CA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25\uff1a\u670d\u52a1\u5668\u8bc1\u4e66\u5df2\u7ecf\u7b7e\u53d1\u8fc7");
            return Result.failure((ErrorEnum)ErrorEnum.CA_INIT_SERVER_CERT_HAS_ISSUED);
        }
        TemplateInfoVO templateInfoVO = this.templateService.getInnerTemplateByType(TemplateTypeEnum.SERVER.value);
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(templateInfoVO.getKeyAlg());
        PublicKey encPublicKey = null;
        PublicKey signPublicKey = null;
        try {
            signPublicKey = this.hsmService.getCaSignServerPwd(templateInfoVO.getKeyAlg(), templateInfoVO.getKeySize(), certIssueInfoVO.getKeyIndex());
            encPublicKey = this.hsmService.getCaEncServerPwd(templateInfoVO.getKeyAlg(), templateInfoVO.getKeySize(), certIssueInfoVO.getKeyIndex());
            Result result = this.checkIssueCertParams(certIssueInfoVO.getDn(), templateInfoVO, caInfoVO, 5, TemplateTypeEnum.SERVER.value, signPublicKey, certIssueInfoVO.getKeyIndex(), certIssueInfoVO.getPrivateKeyPin());
            if (!result.isSuccess()) {
                return result;
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u7b7e\u53d1CA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25:\u751f\u6210\u6216\u6821\u9a8c\u5bc6\u94a5\u5931\u8d25", (Throwable)e);
        }
        ParameterMap params = new ParameterMap();
        if (null != certIssueInfoVO.getSubjectAlternativeName()) {
            params.put(Extension.subjectAlternativeName.getId(), certIssueInfoVO.getSubjectAlternativeName());
        }
        try {
            Date nowTime = new Date();
            BigInteger encSn = this.certSnDao.getMaxSn(nowTime);
            X509Certificate rootCert = caInfoVO.getRootCert();
            Date endTime = IssueTimeUtil.getCorrectTime((Long)certIssueInfoVO.getValidity(), (Integer)templateInfoVO.getMaxValidity(), (Date)rootCert.getNotAfter(), (Date)nowTime);
            LdapOcspUrlVO encLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(encSn, certIssueInfoVO.getDn(), caInfoVO, false, null, null);
            List encExtensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), (Map)params, (PublicKey)encPublicKey, (String)certIssueInfoVO.getDn(), (LdapOcspUrlVO)encLdapOcspUrlVO, (boolean)false);
            X509Certificate encCert = this.hsmService.genX509Certificate(certIssueInfoVO.getDn(), encSn, nowTime, endTime, caInfoVO, encPublicKey, encExtensions, templateInfoVO.getSignAlg());
            BigInteger signSn = this.certSnDao.getMaxSn(nowTime);
            LdapOcspUrlVO signLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(signSn, certIssueInfoVO.getDn(), caInfoVO, false, null, null);
            List signExtensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), (Map)params, (PublicKey)signPublicKey, (String)certIssueInfoVO.getDn(), (LdapOcspUrlVO)signLdapOcspUrlVO, (boolean)true);
            X509Certificate signCert = this.hsmService.genX509Certificate(certIssueInfoVO.getDn(), signSn, nowTime, endTime, caInfoVO, signPublicKey, signExtensions, templateInfoVO.getSignAlg());
            this.saveCAServerCert(caInfoVO.getCertId(), encCert, signCert, templateInfoVO);
            TomcatHttpsUtil.setTomcatHttpsPort((Integer)templateInfoVO.getKeyAlg(), (String)caInfoVO.getCertChain(), (X509Certificate)signCert, (X509Certificate)encCert, (Integer)certIssueInfoVO.getKeyIndex(), (String)certIssueInfoVO.getPrivateKeyPin(), (Integer)ConfigUtil.getTomcatHttpsPort((Environment)this.environment));
            CaServerPwdUtil.saveCaServerPwdCache((ConfigFileService)this.configFileService, (Integer)templateInfoVO.getKeyAlg(), (Integer)certIssueInfoVO.getKeyIndex(), (String)certIssueInfoVO.getPrivateKeyPin());
            Config config = this.configFileService.getConfigInfo();
            config.setInitStep(9);
            this.configFileService.saveConfigInfo(config);
            return Result.success();
        }
        catch (Exception e) {
            throw new ServiceException("\u7b7e\u53d1CA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public Result doIssueCaAdminCert(CaManagerCertVO caManagerCertVO, boolean isInitFinish) {
        Result result;
        if (!isInitFinish && !(result = this.checkInitAdminStepParams(caManagerCertVO.getType())).isSuccess()) {
            return result;
        }
        TemplateInfoVO templateInfoVO = this.templateService.getInnerTemplateByType(TemplateTypeEnum.MANAGER.value);
        CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(templateInfoVO.getKeyAlg());
        PublicKey signPublicKey = CertUtil.getPublicKeyFromP10((String)caManagerCertVO.getP10());
        if (null == signPublicKey) {
            this.logger.debug("\u7b7e\u53d1CA\u7ba1\u7406\u8bc1\u4e66\u5931\u8d25\uff1ap10\u683c\u5f0f\u4e0d\u6b63\u786e[{}]", (Object)caManagerCertVO);
            return Result.failure((ErrorEnum)ErrorEnum.P10_FORMAT_ERROR);
        }
        PublicKey encPublicKey = null;
        try {
            encPublicKey = CertUtil.convertPublicKey((PublicKey)signPublicKey, (String)caManagerCertVO.getSubjectPublicKeyInfo());
        }
        catch (Exception e) {
            this.logger.debug(String.format("\u7b7e\u53d1CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1a\u52a0\u5bc6\u516c\u94a5\u683c\u5f0f\u9519\u8bef:%s", caManagerCertVO.getSubjectPublicKeyInfo()), (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.PEM_FORMAT_ERROR);
        }
        Result result2 = this.checkIssueCertParams(caManagerCertVO.getDn(), templateInfoVO, caInfoVO, null, TemplateTypeEnum.MANAGER.value, signPublicKey, null, "");
        if (!result2.isSuccess()) {
            return result2;
        }
        Long roleId = null;
        try {
            RoleDO roleDO = this.roleDao.getRoleByType(caManagerCertVO.getType().intValue());
            roleId = roleDO.getId();
        }
        catch (Exception e) {
            this.logger.error("\u6ca1\u6709\u627e\u5230\u8be5\u7ba1\u7406\u5458\u89d2\u8272\u5bf9\u5e94\u6743\u9650id\uff0ctype=" + caManagerCertVO.getType());
            throw new ServiceException("\u7b7e\u53d1CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
        try {
            Date nowTime = new Date();
            BigInteger encSn = this.certSnDao.getMaxSn(nowTime);
            X509Certificate rootCert = caInfoVO.getRootCert();
            Date endTime = IssueTimeUtil.getCorrectTime((Long)caManagerCertVO.getValidity(), (Integer)templateInfoVO.getMaxValidity(), (Date)rootCert.getNotAfter(), (Date)nowTime);
            LdapOcspUrlVO encLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(encSn, caManagerCertVO.getDn(), caInfoVO, false, null, null);
            List encExtensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), null, (PublicKey)encPublicKey, (String)caManagerCertVO.getDn(), (LdapOcspUrlVO)encLdapOcspUrlVO, (boolean)false);
            X509Certificate encCert = this.hsmService.genX509Certificate(caManagerCertVO.getDn(), encSn, nowTime, endTime, caInfoVO, encPublicKey, encExtensions, templateInfoVO.getSignAlg());
            BigInteger signSn = this.certSnDao.getMaxSn(nowTime);
            LdapOcspUrlVO signLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(signSn, caManagerCertVO.getDn(), caInfoVO, false, null, null);
            List sincExtensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), null, (PublicKey)signPublicKey, (String)caManagerCertVO.getDn(), (LdapOcspUrlVO)signLdapOcspUrlVO, (boolean)true);
            X509Certificate signCert = this.hsmService.genX509Certificate(caManagerCertVO.getDn(), signSn, nowTime, endTime, caInfoVO, signPublicKey, sincExtensions, templateInfoVO.getSignAlg());
            this.saveCaAdminCert(caInfoVO.getCertId(), signCert, encCert, caManagerCertVO, templateInfoVO, roleId);
            this.logger.info("\u7b7e\u53d1CA\u7ba1\u7406\u5458\u8bc1\u4e66\u6210\u529f\uff1adn= " + caManagerCertVO.getDn() + ",signCert=" + CertUtil.writeObject((Object)signCert) + ",encCert=" + CertUtil.writeObject((Object)encCert));
            return Result.success((Object)CertUtil.enPEncCert((X509Certificate)signCert, (X509Certificate)encCert, (Integer)templateInfoVO.getKeyAlg()), (String)signSn.toString(16));
        }
        catch (Exception e) {
            throw new ServiceException("\u7b7e\u53d1CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    private Result checkInitAdminStepParams(Integer type) {
        boolean typeFlag;
        boolean bl = typeFlag = type == CaManagerRoleEnum.SUPER_ADMIN.key || type == CaManagerRoleEnum.AUDIT_ADMIN.key;
        if (typeFlag && !this.configFileService.verifyCurInitStep(9)) {
            this.logger.info("\u7cfb\u7edf\u521d\u59cb\u5316-\u7b7e\u53d1\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6b65\u9aa4\u9519\u8bef\uff0c\u5f53\u524d\u670d\u52a1\u5668\u4e0a\u521d\u59cb\u5316\u6b65\u9aa4=[{}]", (Object)this.configFileService.getCurrInitStep());
            return Result.failure((ErrorEnum)ErrorEnum.INIT_STEP_ERROR);
        }
        boolean bl2 = typeFlag = type == CaManagerRoleEnum.BUSINESS_ADMIN.key || type == CaManagerRoleEnum.AUDIT_OPERATOR.key || type == CaManagerRoleEnum.BUSINESS_OPERATOR.key;
        if (typeFlag && !this.configFileService.verifyCurInitStep(10)) {
            this.logger.info("\u7cfb\u7edf\u521d\u59cb\u5316-\u7b7e\u53d1\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6b65\u9aa4\u9519\u8bef\uff0c\u5f53\u524d\u670d\u52a1\u5668\u4e0a\u521d\u59cb\u5316\u6b65\u9aa4=[{}]", (Object)this.configFileService.getCurrInitStep());
            return Result.failure((ErrorEnum)ErrorEnum.INIT_STEP_ERROR);
        }
        int n = this.adminRoleDao.getRoleCountsByType(type);
        if (0 != n) {
            this.logger.info("\u7cfb\u7edf\u521d\u59cb\u5316-\u7b7e\u53d1\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25\uff1a\u539f\u56e0\uff1a\u7ba1\u7406\u5458\u8bc1\u4e66\u5df2\u7ecf\u7b7e\u53d1\u8fc7");
            return Result.failure((ErrorEnum)ErrorEnum.MANAGER_HAS_ISSUED);
        }
        return Result.success();
    }

    public Result queryAdminIsUnique(Integer type) {
        int n = this.adminRoleDao.getRoleCountsByType(type);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("count", n);
        return Result.success(map);
    }

    public Result queryAdminIssueCounts() {
        Map map = this.adminRoleDao.queryAdminIssueCounts();
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("superAdminCounts", this.adminRoleDao.getRoleCountsByType(Integer.valueOf(1)));
        result.put("businessAdminCounts", this.adminRoleDao.getRoleCountsByType(Integer.valueOf(2)));
        result.put("businessOperateCounts", this.adminRoleDao.getRoleCountsByType(Integer.valueOf(3)));
        result.put("auditAdminCounts", this.adminRoleDao.getRoleCountsByType(Integer.valueOf(4)));
        result.put("auditOperateCounts", this.adminRoleDao.getRoleCountsByType(Integer.valueOf(5)));
        return Result.success(result);
    }

    public Result saveBasicConfig(BasicConfigVO basicConfigVO) {
        try {
            CaDO caDO = this.caDao.getCaInfo();
            if (null != caDO) {
                this.logger.debug("\u57fa\u672c\u4fe1\u606f\u5df2\u7ecf\u586b\u5199\u8fc7\uff0c\u4e0d\u80fd\u91cd\u590d\u586b\u5199");
                return Result.failure((ErrorEnum)ErrorEnum.INIT_STEP_ERROR);
            }
            CaDO newCaDo = this.buildCaInfo(basicConfigVO);
            newCaDo = this.caDao.saveCaInfo(newCaDo);
            this.reportInitStep(1);
            CaInfoVO caInfoVO = new CaInfoVO();
            BeanUtils.copyProperties((Object)newCaDo, (Object)caInfoVO);
            caInfoVO.setCaId(newCaDo.getId());
            Constants.CA_INFO.put(basicConfigVO.getKeyAlg(), caInfoVO);
            Constants.BASE_ALG_TYPE = basicConfigVO.getKeyAlg();
            return Result.success();
        }
        catch (Exception e) {
            throw new ServiceException("\u4fdd\u5b58CA\u57fa\u672c\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result createP10(CreateP10VO createP10VO) {
        boolean flag;
        if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_XDJA_HSM.intValue() && null != createP10VO.getKeyIndex() && !(flag = GMSSLSM2KeyUtils.getPrivateKeyAccessRightFromYunHsm((int)createP10VO.getKeyIndex(), (String)createP10VO.getPrivateKeyPin()))) {
            this.logger.debug("\u521b\u5efa\u5b50CA\u8bc1\u4e66p10\u5931\u8d25\uff1a\u5bc6\u7801\u673a\u4e24\u7801\u6ca1\u6709\u8bbf\u95ee\u6743\u9650[{}]", (Object)createP10VO);
            return Result.failure((ErrorEnum)ErrorEnum.HSM_KEY_PIN_ERROR);
        }
        if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_SWXA_HSM.intValue() && null != createP10VO.getKeyIndex()) {
            try {
                YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLSancHsmUtils.testConnect();
                if (yunHsmExceptionEnum.id != YunHsmExceptionEnum.NORMAL.id) {
                    this.logger.debug("\u521b\u5efa\u5b50CA\u8bc1\u4e66p10\u5931\u8d25\uff1a\u8fde\u63a5\u4e09\u672a\u4fe1\u5b89\u5bc6\u7801\u673a\u5f02\u5e38[{}]", (Object)createP10VO);
                    return Result.failure((ErrorEnum)ErrorEnum.HSM_KEY_PIN_ERROR);
                }
            }
            catch (Exception e) {
                this.logger.debug("\u521b\u5efa\u5b50CA\u8bc1\u4e66p10\u5931\u8d25\uff1a\u83b7\u53d6\u4e09\u672a\u4fe1\u5b89\u5bc6\u7801\u673a\u5f02\u5e38[{}]", (Object)createP10VO);
                return Result.failure((ErrorEnum)ErrorEnum.HSM_KEY_PIN_ERROR);
            }
        }
        try {
            X500Name e = DnUtil.getRFC4519X500Name((String)createP10VO.getDn());
        }
        catch (Exception e) {
            this.logger.debug("\u521d\u59cb\u5316CA\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e0d\u7b26\u5408X500\u89c4\u8303[{}]", (Object)createP10VO.getDn());
            return Result.failure((ErrorEnum)ErrorEnum.DN_FORMAT_FAIL);
        }
        try {
            PKCS10CertificationRequest p10 = this.hsmService.genP10(createP10VO, Integer.valueOf(P10typeEnum.SubCa.value));
            String p10Name = "CertReq_" + DateTimeUtil.dateToZipStr((Date)new Date()) + ".p10";
            File directory = new File(this.configPath + "p10/");
            if (!directory.exists()) {
                directory.mkdir();
            }
            CertUtil.writeObjToFile((Object)p10, (String)(this.configPath + "p10/" + p10Name));
            CaPwdBean caPwdBean = new CaPwdBean();
            BeanUtils.copyProperties((Object)createP10VO, (Object)caPwdBean);
            this.configFileService.saveCaPwdConfig(caPwdBean);
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(createP10VO.getAlg());
            BeanUtils.copyProperties((Object)createP10VO, (Object)caInfoVO);
            caInfoVO.setCaPwdBean(caPwdBean);
            Constants.CA_INFO.put(createP10VO.getAlg(), caInfoVO);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("p10Name", p10Name);
            return Result.success(map);
        }
        catch (Exception e) {
            throw new ServiceException("\u751f\u6210P10\u5931\u8d25", (Throwable)e);
        }
    }

    public Result reportInitStep(Integer step) {
        try {
            Config config = this.configFileService.getConfigInfo();
            if (step.intValue() != config.getInitStep()) {
                this.logger.debug("\u4e0a\u62a5\u521d\u59cb\u5316\u6b65\u9aa4\u51fa\u9519\uff0c\u670d\u52a1\u5668\u8bb0\u5f55\u65e5\u5fd7\u6b65\u9aa4\uff1a" + config.getInitStep());
                return Result.failure((ErrorEnum)ErrorEnum.INIT_STEP_ERROR);
            }
            if (this.configFileService.verifySystemInitIsOK()) {
                this.logger.debug("\u4e0a\u62a5\u521d\u59cb\u5316\u6b65\u9aa4\u51fa\u9519\uff0c\u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6210");
                return Result.failure((ErrorEnum)ErrorEnum.INIT_STEP_ERROR);
            }
            if (3 == step || 4 == step) {
                config.setInitStep(5);
            } else if (2 == step) {
                CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
                if (caInfoVO.getType() == 1) {
                    config.setInitStep(3);
                } else {
                    config.setInitStep(4);
                }
            } else {
                config.setInitStep(config.getInitStep() + 1);
            }
            this.configFileService.saveConfigInfo(config);
            return Result.success();
        }
        catch (Exception e) {
            throw new ServiceException("\u4e0a\u62a5\u521d\u59cb\u5316\u6b65\u9aa4\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result getHsmList() {
        try {
            HashMap<String, Map> map = new HashMap<String, Map>();
            Map hsmInfo = this.dicDao.getDicsByParentCode("hsmType");
            map.put("hsmInfo", hsmInfo);
            return Result.success(map);
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u5bc6\u7801\u673a\u4fe1\u606f\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result getInitStep() {
        try {
            int step = this.configFileService.getCurrInitStep();
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("step", step);
            if (11 < step) {
                map.put("status", 1);
            } else {
                map.put("status", 2);
            }
            map.put("port", ConfigUtil.getTomcatHttpsPort((Environment)this.environment));
            if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_XDJA_HSM.intValue()) {
                map.put("useHsm", 1);
            } else if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_SWXA_HSM.intValue()) {
                map.put("useHsm", 2);
            } else {
                map.put("useHsm", 0);
            }
            map.put("alg", Constants.BASE_ALG_TYPE);
            return Result.success(map);
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u521d\u59cb\u5316\u6b65\u9aa4\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result doRecoverSystem() {
        try {
            if (this.configFileService.verifySystemInitIsOK()) {
                this.logger.debug("\u4e0a\u62a5\u521d\u59cb\u5316\u6b65\u9aa4\u51fa\u9519\uff0c\u5df2\u7ecf\u521d\u59cb\u5316\u5b8c\u6210");
                return Result.failure((ErrorEnum)ErrorEnum.INIT_STEP_ERROR);
            }
            URL dbUrl = ResourceUtils.getURL((String)"classpath:recoverInitDb.sql");
            this.caDao.recoverSystemDb(dbUrl.getPath().toString());
            this.configFileService.resetConfig();
            Constants.CA_INFO.clear();
            Constants.LICENSE = null;
            this.hsmService.recoverHsm();
            return Result.success();
        }
        catch (Exception e) {
            throw new ServiceException("\u6062\u590d\u51fa\u5382\u8bbe\u7f6e\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result resetSystem() {
        try {
            if (!TomcatUtil.restart()) {
                return Result.failure((ErrorEnum)ErrorEnum.REBOOT_SERVICE_FAIL);
            }
            try {
                String temp = System.getProperty("catalina.home");
                GMSSLTomcatUtils.closeTomcatPort((String)temp, (int)Integer.valueOf(this.httpPort));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return Result.success();
        }
        catch (Exception e) {
            throw new ServiceException("\u7cfb\u7edf\u91cd\u542f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    public CaInfoVO getCaInfo(Integer alg) {
        CaInfoDO caInfoDO = this.caCertDao.getCaInfo(alg);
        Constants.SIGN_ALG_FORMAT_FLAG = ConfigUtil.getSignAlgFormatFlag((Environment)this.environment);
        Constants.KM_NOT_SUPPORT_DN = ConfigUtil.getKmNotSupportDn((Environment)this.environment);
        CaInfoVO caInfoVO = new CaInfoVO();
        if (null != caInfoDO) {
            X509Certificate rootCert;
            BeanUtils.copyProperties((Object)caInfoDO, (Object)caInfoVO);
            X509Certificate x509Certificate = rootCert = StringUtils.isBlank((CharSequence)caInfoDO.getCert()) ? null : CertUtil.getCertFromStr((String)caInfoDO.getCert());
            if (null != rootCert) {
                if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue()) {
                    caInfoVO.setRootPrivateKey(CertUtil.getPrivateKey((String)(Constants.CA_ROOT_PRIVATE_PATH + "private.key")));
                    PublicKey publicKey = CertUtil.getPublicKey((String)(Constants.XDJA_CONF_CERT_DIRECTORY + "km.public"));
                    PrivateKey privateKey = CertUtil.getPrivateKey((String)(Constants.XDJA_CONF_CERT_DIRECTORY + "km.private"));
                    KeyPair keyPair = new KeyPair(publicKey, privateKey);
                    caInfoVO.setKmsoftKeyPair(keyPair);
                }
                caInfoVO.setRootCert(rootCert);
                Config config = this.configFileService.getConfigInfo();
                CaPwdBean caPwdBean = config.getCaPwdConfig();
                caInfoVO.setCaPwdBean(caPwdBean);
                DirServerConfigBean dirServerConfigBean = config.getDirServerConfig();
                if (null != dirServerConfigBean && (StringUtils.isNotBlank((CharSequence)dirServerConfigBean.getMasterURL()) && StringUtils.isNotBlank((CharSequence)dirServerConfigBean.getSlaveURL()) || StringUtils.isNotBlank((CharSequence)dirServerConfigBean.getExtranetHttpURL()) && StringUtils.isNotBlank((CharSequence)dirServerConfigBean.getLocalURL()))) {
                    caInfoVO.setLadp(true);
                    caInfoVO.setDirServerConfigBean(dirServerConfigBean);
                } else {
                    caInfoVO.setLadp(false);
                }
                OcspConfigBean ocspConfigBean = config.getOcspConfig();
                if (null != ocspConfigBean && StringUtils.isNotBlank((CharSequence)ocspConfigBean.getNetworkURL()) && StringUtils.isNotBlank((CharSequence)ocspConfigBean.getInterURL())) {
                    caInfoVO.setOcspConfig(ocspConfigBean);
                    caInfoVO.setOcsp(true);
                } else {
                    caInfoVO.setOcsp(false);
                }
                CaPwdBean serverPwdBean = config.getCaServerPwdConfig();
                caInfoVO.setCaServerPwdConfig(serverPwdBean);
                caInfoVO.setCertPolicy(ConfigUtil.getCertPolicy((Environment)this.environment));
                if (config.getKmSystemType() == 1) {
                    caInfoVO.setKmConfigBean(config.getKmConfigBean());
                } else if (config.getKmSystemType() == 2) {
                    caInfoVO.setXdjaKmConfigBean(config.getXdjaKmConfigBean());
                }
            }
            return caInfoVO;
        }
        return null;
    }

    public Result uploadLicenseFile(MultipartFile licenseFile) {
        try {
            Result result = this.licenseService.uploadLicenseFile(licenseFile);
            if (!result.isSuccess()) {
                return result;
            }
            return this.reportInitStep(0);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u521d\u59cb\u5316\u4e0a\u4f20\u8bb8\u53ef\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u4e0a\u4f20\u8bb8\u53ef\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result doImportSubCaChain(String pemStr) {
        try {
            List certList = P7bUtils.resolveCertChain((String)pemStr);
            X509Certificate[] certArray = CertUtil.sortCertChain((List)certList);
            boolean flag = CertUtil.verifyCertChainSign((X509Certificate[])certArray);
            if (!flag) {
                this.logger.debug("\u5b50CA\u8bc1\u4e66\u9a8c\u7b7e\u5931\u8d25");
                return Result.failure((ErrorEnum)ErrorEnum.CA_CHAIN_VERIFY_FAIL);
            }
            X509Certificate userCert = certArray[certArray.length - 1];
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
            String subject = CertUtil.getSubjectByX509Cert((X509Certificate)userCert);
            if (!subject.toLowerCase().endsWith(caInfoVO.getBaseDn().toLowerCase())) {
                this.logger.debug("\u5bfc\u5165\u5b50CA\u8bc1\u4e66\u94fe\u5931\u8d25\uff1aDN\u4e2d\u7684baseDn\u4e0d\u6b63\u786e[{}]", (Object)subject);
                return Result.failure((ErrorEnum)ErrorEnum.BASEDN_ERROR);
            }
            if (Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_XDJA_HSM) && (null == caInfoVO.getCaPwdBean() || StringUtils.isBlank((CharSequence)caInfoVO.getCaPwdBean().getPrivateKeyPin()))) {
                this.logger.debug("\u6ca1\u6709\u627e\u5230\u5bc6\u94a5\u4fe1\u606f\uff0c\u9700\u8981\u5148\u7533\u8bf7p10");
                return Result.failure((ErrorEnum)ErrorEnum.PUBLIC_KEY_IS_NOT_MATCH_ERROR);
            }
            if (Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC) && null == caInfoVO.getRootPrivateKey()) {
                PrivateKey privateKey = CertUtils.readPrivateKeyByPath((String)(Constants.CA_ROOT_PRIVATE_PATH + "tmpPrivate.key"));
                if (null == privateKey) {
                    this.logger.debug("\u6ca1\u6709\u627e\u5230\u5bc6\u94a5\u4fe1\u606f\uff0c\u9700\u8981\u5148\u7533\u8bf7p10");
                    return Result.failure((ErrorEnum)ErrorEnum.PUBLIC_KEY_IS_NOT_MATCH_ERROR);
                }
                caInfoVO.setRootPrivateKey(privateKey);
            }
            String random = "sushi";
            String sign = this.hsmService.signDataByDefaultHash(Constants.BASE_ALG_TYPE, caInfoVO, Base64.toBase64String((byte[])random.getBytes()));
            flag = this.hsmService.verifySignByDefaultHash(Constants.BASE_ALG_TYPE, caInfoVO, userCert.getPublicKey(), Base64.toBase64String((byte[])random.getBytes()), sign);
            if (!flag) {
                this.logger.debug("\u5b50CA\u8bc1\u4e66\u516c\u79c1\u94a5\u4e0d\u5339\u914d");
                return Result.failure((ErrorEnum)ErrorEnum.PUBLIC_KEY_IS_NOT_MATCH_ERROR);
            }
            CaCertDo caCertDo = this.buildRootCert(userCert, certList, caInfoVO.getCaId());
            caCertDo = this.caCertDao.save(caCertDo);
            if (Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC)) {
                PrivateKey privateKey = CertUtils.readPrivateKeyByPath((String)(Constants.CA_ROOT_PRIVATE_PATH + "tmpPrivate.key"));
                CertUtil.writeObjToFile((Object)privateKey, (String)(Constants.CA_ROOT_PRIVATE_PATH + "private.key"));
                caInfoVO.setRootPrivateKey(privateKey);
            }
            caInfoVO.setRootCert(userCert);
            BeanUtils.copyProperties((Object)caCertDo, (Object)caInfoVO);
            caInfoVO.setCertId(caCertDo.getId());
            Constants.CA_INFO.put(Constants.BASE_ALG_TYPE, caInfoVO);
            this.caCertDao.hideCrossFunction();
            return this.reportInitStep(4);
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u5165CA\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u5bfc\u5165CA\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
        }
    }

    private CaDO buildCaInfo(BasicConfigVO basicConfigVO) {
        CaDO caDO = new CaDO();
        BeanUtils.copyProperties((Object)basicConfigVO, (Object)caDO);
        caDO.setGmtCreate(new Date());
        caDO.setIsMaster(Integer.valueOf(CaDO.CaMasterEnum.YES.value));
        if (CaDO.CaTypeEnum.ROOT_CA.value == basicConfigVO.getType()) {
            caDO.setName("\u6839CA");
        } else {
            caDO.setName("CA");
        }
        return caDO;
    }

    public PrivateKey getRootPrivateKey(String path) {
        try {
            File file = new File(path);
            if (!file.exists()) {
                return null;
            }
            PEMParser pemParser = new PEMParser((Reader)new FileReader(file));
            Object object = pemParser.readObject();
            pemParser.close();
            PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(null);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            KeyPair kp = null;
            kp = object instanceof PEMEncryptedKeyPair ? converter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair(decProv)) : converter.getKeyPair((PEMKeyPair)object);
            return kp.getPrivate();
        }
        catch (Exception e) {
            throw new ServiceException("\u8bfb\u53d6\u516c\u94a5\u79c1\u670d\u65f6\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private void saveCaAdminCert(Long caCertId, X509Certificate signCert, X509Certificate encCert, CaManagerCertVO caManagerCertVO, TemplateInfoVO templateInfoVO, Long roleId) throws Exception {
        ArrayList<ManageCertDataDO> manageCertDataDOList = new ArrayList<ManageCertDataDO>();
        ManageCertDataDO signManageCertDataDO = new ManageCertDataDO();
        ManageCertDataDO encManageCertDataDO = new ManageCertDataDO();
        encManageCertDataDO.setData(CertUtil.writeObject((Object)encCert));
        encManageCertDataDO.setGmtCreate(encCert.getNotBefore());
        signManageCertDataDO.setData(CertUtil.writeObject((Object)signCert));
        signManageCertDataDO.setGmtCreate(encCert.getNotBefore());
        Date date = new Date();
        ManageCertDO manageCertDO = new ManageCertDO();
        manageCertDO.setId(Long.valueOf(this.managerCertIdDao.getMaxId(date)));
        manageCertDO.setCaCertId(caCertId);
        manageCertDO.setSn(encCert.getSerialNumber().toString(16));
        manageCertDO.setIssuer(CertUtil.getIssuerByX509Cert((X509Certificate)encCert));
        manageCertDO.setSubject(CertUtil.getSubjectByX509Cert((X509Certificate)encCert));
        manageCertDO.setPublicKeyAlg(templateInfoVO.getKeyAlg());
        manageCertDO.setPrivateKeySize(templateInfoVO.getKeySize());
        manageCertDO.setBeforeTime(encCert.getNotBefore());
        manageCertDO.setAfterTime(encCert.getNotAfter());
        manageCertDO.setSignAlg(templateInfoVO.getSignAlg());
        manageCertDO.setType(Constants.ENC_CERT);
        manageCertDO.setStatus(Integer.valueOf(1));
        manageCertDO.setTemplateId(templateInfoVO.getId());
        manageCertDO.setPairCertSn(signCert.getSerialNumber().toString(16));
        manageCertDO.setConfirmationStatus(Constants.ISSUE_CERT_NO_ACK);
        manageCertDO.setGmtCreate(encCert.getNotBefore());
        manageCertDO = this.managereCertDao.save(manageCertDO);
        encManageCertDataDO.setId(manageCertDO.getId());
        manageCertDataDOList.add(encManageCertDataDO);
        manageCertDO.setSn(signCert.getSerialNumber().toString(16));
        manageCertDO.setPairCertSn(encCert.getSerialNumber().toString(16));
        manageCertDO.setPairCertId(manageCertDO.getId());
        manageCertDO.setType(Constants.SIGN_CERT);
        manageCertDO.setId(Long.valueOf(this.managerCertIdDao.getMaxId(date)));
        manageCertDO = this.managereCertDao.save(manageCertDO);
        signManageCertDataDO.setId(manageCertDO.getId());
        manageCertDataDOList.add(signManageCertDataDO);
        AdminRoleDO adminRoleDO = new AdminRoleDO();
        adminRoleDO.setRoleId(roleId);
        adminRoleDO.setGmtCreate(encCert.getNotBefore());
        adminRoleDO.setManageCertId(manageCertDO.getId());
        this.adminRoleDao.save(adminRoleDO);
        this.managereCertDao.updatePairCertId(manageCertDO.getPairCertId(), manageCertDO.getId());
        this.managerCertDataDao.batchSave(manageCertDataDOList);
        this.taskDataService.saveCertConfirmStatus(null, signManageCertDataDO.getId());
    }

    public void saveCAServerCert(Long caCertId, X509Certificate encCert, X509Certificate signCert, TemplateInfoVO templateInfoVO) throws Exception {
        ArrayList<ManageCertDataDO> manageCertDataDOList = new ArrayList<ManageCertDataDO>();
        ManageCertDataDO signManageCertDataDO = new ManageCertDataDO();
        ManageCertDataDO encManageCertDataDO = new ManageCertDataDO();
        encManageCertDataDO.setData(CertUtil.writeObject((Object)encCert));
        encManageCertDataDO.setGmtCreate(encCert.getNotBefore());
        signManageCertDataDO.setData(CertUtil.writeObject((Object)signCert));
        signManageCertDataDO.setGmtCreate(encCert.getNotBefore());
        Date date = new Date();
        ManageCertDO manageCertDO = new ManageCertDO();
        manageCertDO.setId(Long.valueOf(this.managerCertIdDao.getMaxId(date)));
        manageCertDO.setCaCertId(caCertId);
        manageCertDO.setSn(encCert.getSerialNumber().toString(16));
        manageCertDO.setIssuer(CertUtil.getIssuerByX509Cert((X509Certificate)encCert));
        manageCertDO.setSubject(CertUtil.getSubjectByX509Cert((X509Certificate)encCert));
        manageCertDO.setPublicKeyAlg(templateInfoVO.getKeyAlg());
        manageCertDO.setPrivateKeySize(templateInfoVO.getKeySize());
        manageCertDO.setBeforeTime(encCert.getNotBefore());
        manageCertDO.setAfterTime(encCert.getNotAfter());
        manageCertDO.setSignAlg(templateInfoVO.getSignAlg());
        manageCertDO.setType(Constants.ENC_CERT);
        manageCertDO.setStatus(Integer.valueOf(1));
        manageCertDO.setTemplateId(templateInfoVO.getId());
        manageCertDO.setPairCertSn(signCert.getSerialNumber().toString(16));
        manageCertDO.setConfirmationStatus(Constants.ISSUE_CERT_OK_ACK);
        manageCertDO.setGmtCreate(encCert.getNotBefore());
        manageCertDO = this.managereCertDao.save(manageCertDO);
        encManageCertDataDO.setId(manageCertDO.getId());
        manageCertDataDOList.add(encManageCertDataDO);
        manageCertDO.setSn(signCert.getSerialNumber().toString(16));
        manageCertDO.setPairCertSn(encCert.getSerialNumber().toString(16));
        manageCertDO.setPairCertId(manageCertDO.getId());
        manageCertDO.setType(Constants.SIGN_CERT);
        manageCertDO.setId(Long.valueOf(this.managerCertIdDao.getMaxId(date)));
        manageCertDO = this.managereCertDao.save(manageCertDO);
        signManageCertDataDO.setId(manageCertDO.getId());
        manageCertDataDOList.add(signManageCertDataDO);
        CaServerCertDo caServerCertDo = new CaServerCertDo();
        caServerCertDo.setGmtCreate(encCert.getNotBefore());
        caServerCertDo.setIsCurrent(Integer.valueOf(ServerCertIsCurrentEnum.IS_CURRENT.value));
        caServerCertDo.setManageCertId(manageCertDO.getId());
        this.caServerCertDao.save(caServerCertDo);
        this.managereCertDao.updatePairCertId(manageCertDO.getPairCertId(), manageCertDO.getId());
        this.managerCertDataDao.batchSave(manageCertDataDOList);
        this.taskDataService.savePublishCert(manageCertDO.getId(), manageCertDO.getPairCertId(), Integer.valueOf(2));
    }
}

