/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.service.init;

import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.common.Config;
import com.xdja.pki.ca.core.common.ConfigUtil;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.time.DateTimeUtil;
import com.xdja.pki.ca.securitymanager.dao.LicenseDao;
import com.xdja.pki.ca.securitymanager.dao.model.LicenseDO;
import com.xdja.pki.ca.securitymanager.service.configfile.ConfigFileService;
import com.xdja.pki.ca.securitymanager.service.init.InitService;
import com.xdja.pki.ca.securitymanager.service.init.LicenseService;
import com.xdja.pki.ca.securitymanager.service.vo.LicenseVO;
import com.xdja.pki.core.utils.DateUtils;
import com.xdja.pki.core.utils.HashUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class LicenseServiceImpl
implements LicenseService {
    @Autowired
    private LicenseDao licenseDao;
    @Autowired
    private InitService initService;
    @Autowired
    private ConfigFileService configFileService;
    private static final String LICENSE_READ_SN_SHELL = "readsn.sh";
    private static final String LICENSE_READ_LICENSE_SHELL = "readlicense.sh";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Environment environment;

    public Result getLicenseInfoByFile(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        fileName = this.getFileName(fileName);
        String licensePath = ConfigUtil.getLicensePath((Environment)this.environment);
        FilterOutputStream out = null;
        File tempFile = null;
        try {
            tempFile = new File(licensePath + File.separator + fileName);
            out = new BufferedOutputStream(new FileOutputStream(tempFile));
            out.write(file.getBytes());
            ((BufferedOutputStream)out).flush();
            String cmd = "sh " + licensePath + File.separator + LICENSE_READ_LICENSE_SHELL + " " + fileName;
            String shellResult = this.execShell(cmd);
            Result result = this.resolveShellResult(shellResult);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6license\u6587\u4ef6\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u83b7\u53d6license\u6587\u4ef6\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        finally {
            try {
                out.close();
                if (tempFile != null && tempFile.exists()) {
                    tempFile.delete();
                }
            }
            catch (IOException e) {
                this.logger.error("\u5173\u95edlicese\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public Result uploadLicenseFile(MultipartFile file) {
        StringBuffer auditLog = new StringBuffer("");
        String fileName = file.getOriginalFilename();
        fileName = this.getFileName(fileName);
        String licensePath = ConfigUtil.getLicensePath((Environment)this.environment);
        FilterOutputStream out = null;
        File tempFile = null;
        try {
            tempFile = new File(licensePath + File.separator + fileName);
            out = new BufferedOutputStream(new FileOutputStream(tempFile));
            out.write(file.getBytes());
            ((BufferedOutputStream)out).flush();
            String cmd = "sh " + licensePath + File.separator + LICENSE_READ_LICENSE_SHELL + " " + fileName;
            String shellResult = this.execShell(cmd);
            Result result = this.resolveShellResult(shellResult);
            if (!result.isSuccess()) {
                auditLog.append("\u4e0a\u4f20license\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a").append(result.getError().desc);
                Result result2 = result;
                return result2;
            }
            LicenseVO licenseVO = (LicenseVO)result.getInfo();
            String fileHash = HashUtils.md5((File)tempFile);
            LicenseDO lic = this.licenseDao.queryByFileHash(fileHash);
            if (lic != null) {
                auditLog.append("\u4e0a\u4f20license\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5df2\u5b58\u5728\u76f8\u540c\u7684\u6587\u4ef6\uff0c\u6587\u4ef6\u540d=").append(lic.getFileName());
                Result result3 = Result.failure((ErrorEnum)ErrorEnum.LICENSE_FILE_EXIST);
                return result3;
            }
            licenseVO.setFileHash(fileHash);
            licenseVO.setFileName(fileName);
            licenseVO.setGmtCreate(new Date());
            licenseVO.setIsCurrent(Integer.valueOf(LicenseDO.IsCurrentEnum.YES.value));
            LicenseDO licenseDO = new LicenseDO();
            BeanUtils.copyProperties((Object)licenseVO, (Object)licenseDO);
            this.licenseDao.save(licenseDO);
            licenseVO.setCurrentCertCount(new AtomicInteger(this.licenseDao.queryCountCert()));
            licenseVO.setSurplusCertCount(Integer.valueOf(licenseVO.getMaxCertCount() - licenseVO.getCurrentCertCount().get()));
            if (licenseVO.getSurplusCertCount() < 0) {
                licenseVO.setSurplusCertCount(Integer.valueOf(0));
            }
            licenseVO.setNeedLicense(Integer.valueOf(LicenseVO.IsNeedLicense.YES.value));
            Config config = this.configFileService.getConfigInfo();
            config.setNeedLicense(Integer.valueOf(LicenseVO.IsNeedLicense.YES.value));
            this.configFileService.saveConfigInfo(config);
            Constants.LICENSE = licenseVO;
            auditLog.append("\u4e0a\u4f20license\u6587\u4ef6\u6210\u529f\uff0c\u6587\u4ef6\u540d=").append(fileName);
            result.setAuditContent(auditLog.toString());
            Result result4 = result;
            return result4;
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20license\u6587\u4ef6\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new ServiceException("\u4e0a\u4f20license\u6587\u4ef6\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                this.logger.error("\u5173\u95edlicese\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public Result getCurrentLicenseInfoByFile() {
        try {
            Config config = this.configFileService.getConfigInfo();
            LicenseVO licenseVO = new LicenseVO();
            if (config.getNeedLicense() == null || config.getNeedLicense() == LicenseVO.IsNeedLicense.NO.value) {
                this.logger.info("\u521d\u59cb\u5316CA\uff0c\u65e0\u9700license\uff01");
                licenseVO.setNeedLicense(Integer.valueOf(LicenseVO.IsNeedLicense.NO.value));
                Constants.LICENSE = licenseVO;
                return Result.success((Object)licenseVO);
            }
            LicenseDO licenseDO = this.licenseDao.queryCurrent();
            if (licenseDO == null) {
                this.logger.error("license\u6570\u636e\u5e93\u6570\u636e\u7f3a\u5931");
                return Result.failure((ErrorEnum)ErrorEnum.LICENSE_DATA_BASE_ERROR);
            }
            String licensePath = ConfigUtil.getLicensePath((Environment)this.environment);
            String cmd = "sh " + licensePath + File.separator + LICENSE_READ_LICENSE_SHELL + " " + licenseDO.getFileName();
            String shellResult = this.execShell(cmd);
            Result result = this.resolveShellResult(shellResult);
            if (!result.isSuccess()) {
                return result;
            }
            licenseVO = (LicenseVO)result.getInfo();
            licenseVO.setNeedLicense(Integer.valueOf(LicenseVO.IsNeedLicense.YES.value));
            licenseVO.setCurrentCertCount(new AtomicInteger(this.licenseDao.queryCountCert()));
            licenseVO.setSurplusCertCount(Integer.valueOf(licenseVO.getMaxCertCount() - licenseVO.getCurrentCertCount().get()));
            licenseVO.setSurplusValidityDays(this.computeSurplusValidityDays(licenseVO));
            if (licenseVO.getSurplusCertCount() < 0) {
                licenseVO.setSurplusCertCount(Integer.valueOf(0));
            }
            licenseVO.setGmtCreate(licenseDO.getGmtCreate());
            Constants.LICENSE = licenseVO;
            return Result.success((Object)licenseVO);
        }
        catch (Exception e) {
            throw new ServiceException("\u6839\u636e\u6587\u4ef6\u83b7\u53d6\u5f53\u524dlicense\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    public void increamCurrentCertCount() {
        LicenseVO l = (LicenseVO)Constants.LICENSE;
        if (l == null) {
            this.logger.error("\u8bb8\u53ef\u65e0\u6548");
            return;
        }
        if (LicenseVO.IsNeedLicense.NO.value == l.getNeedLicense()) {
            this.logger.debug("\u65e0\u9700\u6821\u9a8c");
            return;
        }
        if (l.getCurrentCertCount() != null) {
            l.getCurrentCertCount().incrementAndGet();
        }
    }

    public Result verifyLicense() {
        LicenseVO l = (LicenseVO)Constants.LICENSE;
        if (l == null) {
            return Result.failure((ErrorEnum)ErrorEnum.LICENSE_ANALYSIS_ERROR);
        }
        if (LicenseVO.IsNeedLicense.NO.value == l.getNeedLicense()) {
            return Result.success();
        }
        if (l.getBeginTime() == null || l.getEndTime() == null || l.getMaxCertCount() == null) {
            return Result.failure((ErrorEnum)ErrorEnum.LICENSE_ANALYSIS_ERROR);
        }
        Long currentTime = System.currentTimeMillis();
        if (currentTime < l.getBeginTime().getTime()) {
            return Result.failure((ErrorEnum)ErrorEnum.LICENSE_BEFORE_EFFECTIVE_DATE);
        }
        if (currentTime > l.getEndTime().getTime()) {
            return Result.failure((ErrorEnum)ErrorEnum.LICENSE_BE_OVERDUE);
        }
        if (l.getCurrentCertCount().get() >= l.getMaxCertCount()) {
            return Result.failure((ErrorEnum)ErrorEnum.LICENSE_MORE_THAN_PERMITTED_QUANTITY);
        }
        return Result.success();
    }

    private String getFileName(String fileName) {
        int index = fileName.lastIndexOf(".");
        SimpleDateFormat sDateFormate = new SimpleDateFormat("yyyymmddHHmmss");
        String nowTimeStr = sDateFormate.format(new Date());
        fileName = fileName.substring(0, index) + "_" + nowTimeStr + fileName.substring(index);
        return fileName;
    }

    private String execShell(String cmd) throws IOException, InterruptedException {
        String line;
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(cmd);
        int status = process.waitFor();
        if (status != 0) {
            String errLine;
            this.logger.error("\u6267\u884c\u5931\u8d25:{}", (Object)cmd);
            BufferedReader errBr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            StringBuffer errSb = new StringBuffer("");
            while ((errLine = errBr.readLine()) != null) {
                errSb.append(errLine).append("\n");
            }
            this.logger.error("\u811a\u672c\u57f7\u884c\u5f02\u5e38\u7d50\u679c:{}", (Object)errSb.toString());
            return errSb.toString();
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuffer sb = new StringBuffer("");
        while ((line = br.readLine()) != null) {
            sb.append(line).append("\n");
        }
        this.logger.debug("\u811a\u672c\u6267\u884c\u7ed3\u679c:{}", (Object)sb.toString());
        return sb.toString();
    }

    private Result resolveShellResult(String shellResult) {
        String[] resultArr = shellResult.split("\n");
        String formatStr = "yyyyMMddHHmmss";
        if (resultArr == null || resultArr.length == 0) {
            return Result.failure((ErrorEnum)ErrorEnum.LICENSE_ANALYSIS_ERROR);
        }
        LicenseVO licenseVO = new LicenseVO();
        for (String temp : resultArr) {
            if (StringUtils.isBlank((CharSequence)temp)) continue;
            if (temp.startsWith("error")) {
                if (temp.contains("disk SN not matching")) {
                    return Result.failure((ErrorEnum)ErrorEnum.LICENSE_DISK_SN_NOT_MATCHING);
                }
                if (temp.contains("greater than expiry date")) {
                    return Result.failure((ErrorEnum)ErrorEnum.LICENSE_BE_OVERDUE);
                }
                if (temp.contains("less than start date")) {
                    return Result.failure((ErrorEnum)ErrorEnum.LICENSE_BEFORE_EFFECTIVE_DATE);
                }
                this.logger.error("\u89e3\u6790\u6587\u4ef6\u672a\u77e5\u9519\u8bef:{}" + temp);
                return Result.failure((ErrorEnum)ErrorEnum.LICENSE_ANALYSIS_ERROR);
            }
            if (temp.startsWith("sda sn")) {
                licenseVO.setDeviceSn(temp.split("=")[1]);
                licenseVO.setCurrentDeviceSn(licenseVO.getDeviceSn());
                continue;
            }
            if (temp.startsWith("Period of validity")) {
                String validity = temp.split(":")[1].trim();
                String begin = validity.split("-")[0];
                String end = validity.split("-")[1];
                licenseVO.setBeginTime(DateTimeUtil.strToDate((String)(begin + "000000"), (String)formatStr));
                licenseVO.setEndTime(DateTimeUtil.strToDate((String)(end + "235959"), (String)formatStr));
                continue;
            }
            if (!temp.startsWith("MAX Users count") && !temp.startsWith("MAX Online Users count")) continue;
            String maxCertCount = temp.split(":")[1].trim();
            licenseVO.setMaxCertCount(Integer.valueOf(Integer.parseInt(maxCertCount)));
        }
        if (StringUtils.isBlank((CharSequence)licenseVO.getDeviceSn()) || licenseVO.getMaxCertCount() == null || licenseVO.getBeginTime() == null || licenseVO.getEndTime() == null) {
            return Result.failure((ErrorEnum)ErrorEnum.LICENSE_ANALYSIS_ERROR);
        }
        return Result.success((Object)licenseVO);
    }

    private Long computeSurplusValidityDays(LicenseVO licenseVO) {
        Date currentDate = new Date();
        if (currentDate.compareTo(licenseVO.getEndTime()) > 0) {
            return -1L;
        }
        if (currentDate.compareTo(licenseVO.getBeginTime()) > 0) {
            return DateUtils.getDays((Date)currentDate, (Date)licenseVO.getEndTime());
        }
        return DateUtils.getDays((Date)licenseVO.getBeginTime(), (Date)licenseVO.getEndTime());
    }
}

