/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.service.init;

import com.xdja.pki.auth.annotation.AuditLogSign;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ca.certmanager.service.kms.KmsService;
import com.xdja.pki.ca.certmanager.service.kms.bean.ResponseBean;
import com.xdja.pki.ca.certmanager.service.template.TemplateService;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateInfoVO;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.common.Config;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.configBasic.bean.ArchiveConfigBean;
import com.xdja.pki.ca.core.configBasic.bean.DirServerConfigBean;
import com.xdja.pki.ca.core.configBasic.bean.KmConfigBean;
import com.xdja.pki.ca.core.configBasic.bean.OcspConfigBean;
import com.xdja.pki.ca.core.configBasic.bean.XdjaKmConfigBean;
import com.xdja.pki.ca.core.enums.KeyAlgEnum;
import com.xdja.pki.ca.core.enums.P10typeEnum;
import com.xdja.pki.ca.core.enums.TemplateStatusEnum;
import com.xdja.pki.ca.core.enums.TemplateTypeEnum;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.pkcs7.P7bUtils;
import com.xdja.pki.ca.core.util.CertUtils;
import com.xdja.pki.ca.core.util.DnUtil;
import com.xdja.pki.ca.core.util.FileUtils;
import com.xdja.pki.ca.core.util.UrlUtil;
import com.xdja.pki.ca.core.util.json.JsonUtils;
import com.xdja.pki.ca.core.util.time.DateTimeUtil;
import com.xdja.pki.ca.core.util.verify.VerifyCert;
import com.xdja.pki.ca.hsm.manager.HsmManager;
import com.xdja.pki.ca.hsm.manager.SoftAlgManager;
import com.xdja.pki.ca.securitymanager.dao.CaCertDao;
import com.xdja.pki.ca.securitymanager.dao.CertSnDao;
import com.xdja.pki.ca.securitymanager.service.configfile.ConfigFileService;
import com.xdja.pki.ca.securitymanager.service.init.LicenseService;
import com.xdja.pki.ca.securitymanager.service.init.SystemConfigService;
import com.xdja.pki.ca.securitymanager.service.vo.AlgTypeEnum;
import com.xdja.pki.ca.securitymanager.service.vo.ArchiveConfigVO;
import com.xdja.pki.ca.securitymanager.service.vo.BaseConfigDTO;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.CreateP10VO;
import com.xdja.pki.ca.securitymanager.service.vo.DirServerConfigVO;
import com.xdja.pki.ca.securitymanager.service.vo.LicenseErrorVO;
import com.xdja.pki.ca.securitymanager.service.vo.LicenseVO;
import com.xdja.pki.ca.securitymanager.service.vo.OcspConfigVO;
import com.xdja.pki.ca.securitymanager.service.vo.SignAlgTypeEnum;
import com.xdja.pki.ca.securitymanager.service.vo.SubServerStatus;
import com.xdja.pki.core.bean.CoreResult;
import com.xdja.pki.core.utils.SpringBeanUtils;
import com.xdja.pki.dynamic.task.CronTaskRegistrar;
import com.xdja.pki.dynamic.task.SchedulingRunnable;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSAKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLSancHsmUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLYunHsmUtils;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmExceptionEnum;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SystemConfigServiceImpl
implements SystemConfigService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CaCertDao caCertDao;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private HsmManager hsmService;
    @Value(value="${config.path}")
    private String configPath;
    @Autowired
    private SoftAlgManager softAlgManager;
    @Autowired
    private CertSnDao certSnDao;
    @Autowired
    private CronTaskRegistrar cronTaskRegistrar;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private ConfigFileService configFileService;

    public Result getBaseConfig() {
        BaseConfigDTO baseConfigDTO = new BaseConfigDTO();
        baseConfigDTO.setCaType(String.valueOf(this.caCertDao.currentIsRootCa() != false ? 1 : 2));
        baseConfigDTO.setKeyAlg(KeyAlgEnum.convert((int)Constants.BASE_ALG_TYPE.intValue()).desc);
        TemplateInfoVO templateInfoVO = this.templateService.getInnerTemplateByType(TemplateTypeEnum.ROOT_CA.value);
        if (null == templateInfoVO) {
            this.logger.info("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u7ed3\u679c\uff1a\u6a21\u677f\u4e0d\u5b58\u5728[{}]", (Object)TemplateTypeEnum.ROOT_CA.value);
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
        }
        if (TemplateStatusEnum.NORMAL.value != templateInfoVO.getStatus()) {
            this.logger.info("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u7ed3\u679c\uff1a\u6a21\u677f\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u6a21\u677f\u72b6\u6001\u4e3a[{}]", (Object)templateInfoVO.getStatus());
            return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_STATUS_IS_STOP);
        }
        try {
            LicenseVO licenseVO;
            String[] ipPort;
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(templateInfoVO.getKeyAlg());
            baseConfigDTO.setBaseDn(caInfoVO.getBaseDn());
            SubServerStatus subServerStatus = new SubServerStatus();
            if (null != caInfoVO.getDirServerConfigBean() && null != caInfoVO.getDirServerConfigBean().getMasterURL()) {
                ipPort = UrlUtil.parseUrl((String)caInfoVO.getDirServerConfigBean().getMasterURL()).split(":");
                subServerStatus.setLdap(Boolean.valueOf(this.isHostConnectivity(ipPort[0], Integer.valueOf(ipPort[1]))));
            } else {
                subServerStatus.setLdap(Boolean.valueOf(false));
            }
            if (null != caInfoVO.getOcspConfig()) {
                ipPort = UrlUtil.parseUrl((String)caInfoVO.getOcspConfig().getInterURL()).split(":");
                subServerStatus.setOcsp(Boolean.valueOf(this.isHostConnectivity(ipPort[0], Integer.valueOf(ipPort[1]))));
            } else {
                subServerStatus.setOcsp(Boolean.valueOf(false));
            }
            if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_XDJA_HSM.intValue()) {
                subServerStatus.setHsm(Boolean.valueOf(GMSSLYunHsmUtils.testConnect()));
            } else if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_SWXA_HSM.intValue()) {
                YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLSancHsmUtils.testConnect();
                subServerStatus.setHsm(Boolean.valueOf(YunHsmExceptionEnum.NORMAL.id == yunHsmExceptionEnum.id));
            } else {
                subServerStatus.setHsm(Boolean.valueOf(false));
            }
            Config config = this.configFileService.getConfigInfo();
            int kmSystemType = config.getKmSystemType();
            if (1 == kmSystemType) {
                if (null != caInfoVO.getKmConfigBean()) {
                    subServerStatus.setKms(Boolean.valueOf(this.isHostConnectivity(caInfoVO.getKmConfigBean().getIp(), caInfoVO.getKmConfigBean().getPort())));
                } else {
                    subServerStatus.setKms(Boolean.valueOf(false));
                }
            } else if (2 == kmSystemType) {
                if (null != caInfoVO.getXdjaKmConfigBean()) {
                    subServerStatus.setKms(Boolean.valueOf(this.isHostConnectivity(caInfoVO.getXdjaKmConfigBean().getKmIp(), caInfoVO.getXdjaKmConfigBean().getKmPort())));
                } else {
                    subServerStatus.setKms(Boolean.valueOf(false));
                }
            } else {
                subServerStatus.setKms(Boolean.valueOf(false));
            }
            baseConfigDTO.setSubServerStatus(subServerStatus);
            Result licenseResult = this.licenseService.getCurrentLicenseInfoByFile();
            if (!licenseResult.isSuccess()) {
                ErrorEnum errorEnum = licenseResult.getError();
                licenseVO = new LicenseVO();
                licenseVO.setNeedLicense(Integer.valueOf(LicenseVO.IsNeedLicense.YES.value));
                licenseVO.setError(new LicenseErrorVO(errorEnum.desc, errorEnum.code));
            } else {
                licenseVO = (LicenseVO)licenseResult.getInfo();
            }
            baseConfigDTO.setLicenseInfo(licenseVO);
            return Result.success((Object)baseConfigDTO);
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u57fa\u672c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    public Result saveDirServerConfig(DirServerConfigVO dirServerConfigVo) {
        try {
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
            DirServerConfigBean dirServerConfig = caInfoVO.getDirServerConfigBean();
            this.logger.info("=======================dirServerConfig================" + JsonUtils.object2Json((Object)dirServerConfig));
            DirServerConfigBean dirServerConfigBean = new DirServerConfigBean();
            if (StringUtils.isNotBlank((CharSequence)dirServerConfigVo.getSlaveURL()) && StringUtils.isNotBlank((CharSequence)dirServerConfigVo.getMasterURL())) {
                if (dirServerConfig != null) {
                    if (StringUtils.isBlank((CharSequence)dirServerConfig.getSlaveURL())) {
                        dirServerConfigBean.setMasterURL(dirServerConfigVo.getMasterURL());
                        dirServerConfigBean.setSlaveURL(dirServerConfigVo.getSlaveURL());
                    } else {
                        dirServerConfigBean.setMasterURL(dirServerConfigVo.getMasterURL());
                        dirServerConfigBean.setSlaveURL(dirServerConfig.getSlaveURL());
                    }
                    dirServerConfigBean.setLocalURL(dirServerConfig.getLocalURL());
                    dirServerConfigBean.setExtranetHttpURL(dirServerConfig.getExtranetHttpURL());
                } else {
                    BeanUtils.copyProperties((Object)dirServerConfigVo, (Object)dirServerConfigBean);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dirServerConfigVo.getLocalURL()) && StringUtils.isNotBlank((CharSequence)dirServerConfigVo.getExtranetHttpURL())) {
                BeanUtils.copyProperties((Object)dirServerConfigVo, (Object)dirServerConfigBean);
                if (dirServerConfig != null) {
                    if (StringUtils.isBlank((CharSequence)dirServerConfig.getExtranetHttpURL())) {
                        dirServerConfigBean.setLocalURL(dirServerConfigVo.getLocalURL());
                        dirServerConfigBean.setExtranetHttpURL(dirServerConfigVo.getExtranetHttpURL());
                    } else {
                        dirServerConfigBean.setLocalURL(dirServerConfigVo.getLocalURL());
                        dirServerConfigBean.setExtranetHttpURL(dirServerConfig.getExtranetHttpURL());
                    }
                    dirServerConfigBean.setMasterURL(dirServerConfig.getMasterURL());
                    dirServerConfigBean.setSlaveURL(dirServerConfig.getSlaveURL());
                } else {
                    BeanUtils.copyProperties((Object)dirServerConfigVo, (Object)dirServerConfigBean);
                }
            }
            Config config = this.configFileService.getConfigInfo();
            config.setDirServerConfig(dirServerConfigBean);
            this.configFileService.saveConfigInfo(config);
            if (StringUtils.isNotBlank((CharSequence)dirServerConfigVo.getLocalURL())) {
                FileUtils.createFileDir((String)dirServerConfigVo.getLocalURL());
            }
            caInfoVO.setLadp(true);
            caInfoVO.setDirServerConfigBean(dirServerConfigBean);
            this.logger.info("=======================dirServerConfigBean================" + JsonUtils.object2Json((Object)caInfoVO.getDirServerConfigBean()));
            Constants.CA_INFO.put(Constants.BASE_ALG_TYPE, caInfoVO);
            return Result.success();
        }
        catch (Exception e) {
            throw new ServiceException("\u4fdd\u5b58\u76ee\u5f55\u670d\u52a1\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result saveOcspConfig(OcspConfigVO ocspConfigVO) {
        try {
            if (StringUtils.isNotBlank((CharSequence)ocspConfigVO.getInterURL()) && StringUtils.isNotBlank((CharSequence)ocspConfigVO.getNetworkURL())) {
                OcspConfigBean ocspConfigBean = new OcspConfigBean();
                BeanUtils.copyProperties((Object)ocspConfigVO, (Object)ocspConfigBean);
                this.configFileService.saveOcspConfig(ocspConfigBean);
            }
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
            caInfoVO.setOcsp(true);
            caInfoVO.setOcspConfig(this.configFileService.getOcspConfig());
            Constants.CA_INFO.put(Constants.BASE_ALG_TYPE, caInfoVO);
            return Result.success();
        }
        catch (Exception e) {
            throw new ServiceException("\u4fdd\u5b58ldap\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    @AuditLogSign
    public void saveAuditLog(HttpServletResponse resp, @RequestBody OcspConfigVO ocspConfigVO, AuditSignBean bean, CoreResult coreResult) {
        System.out.println("test");
    }

    public Result saveArchiveConfig(ArchiveConfigVO archiveConfigVO) {
        try {
            ArchiveConfigBean archiveConfigBean = new ArchiveConfigBean();
            BeanUtils.copyProperties((Object)archiveConfigVO, (Object)archiveConfigBean);
            this.configFileService.saveArchiveConfig(archiveConfigBean);
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
            caInfoVO.setArchiveConfigBean(this.configFileService.getArchiveConfig());
            Constants.CA_INFO.put(Constants.BASE_ALG_TYPE, caInfoVO);
            if (archiveConfigBean.getAutoArchiveFlag() == 1) {
                this.cronTaskRegistrar.addCronTask((Runnable)new SchedulingRunnable("auditLogServiceImpl", "doAutoArchiveOperateLog"), archiveConfigBean.getAutoArchiveCron());
            }
            if (archiveConfigBean.getAutoArchiveFlag() == 0) {
                SchedulingRunnable runnable = new SchedulingRunnable("auditLogServiceImpl", "doAutoArchiveOperateLog");
                this.cronTaskRegistrar.removeCronTask((Runnable)runnable);
            }
            return Result.success();
        }
        catch (Exception e) {
            throw new ServiceException("\u4fdd\u5b58\u5ba1\u8ba1\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result getArchiveConfig() {
        try {
            ArchiveConfigBean archiveConfigBean = this.configFileService.getArchiveConfig();
            if (null == archiveConfigBean) {
                return Result.success((Object)new ArchiveConfigBean());
            }
            return Result.success((Object)archiveConfigBean);
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u5ba1\u8ba1\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result getDirServerConfig() {
        try {
            DirServerConfigBean dirServerConfigBean = this.configFileService.getDirServerConfig();
            if (null == dirServerConfigBean) {
                return Result.success((Object)new DirServerConfigBean());
            }
            return Result.success((Object)dirServerConfigBean);
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u76ee\u5f55\u670d\u52a1\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result getOcspConfig() {
        try {
            OcspConfigBean ocspConfigBean = this.configFileService.getOcspConfig();
            if (null == ocspConfigBean) {
                return Result.success((Object)new OcspConfigBean());
            }
            return Result.success((Object)ocspConfigBean);
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6ocsp\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean isHostConnectivity(String host, int port) {
        block10: {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(host, port));
            try {
                socket.close();
            }
            catch (Exception e) {
                this.logger.debug("isHostConnectivity socket close {}:{} error", new Object[]{host, port, e});
            }
            break block10;
            catch (Exception e) {
                boolean bl;
                try {
                    this.logger.debug("isHostConnectivity socket connect {}:{} error", new Object[]{host, port, e});
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        socket.close();
                    }
                    catch (Exception e2) {
                        this.logger.debug("isHostConnectivity socket close {}:{} error", new Object[]{host, port, e2});
                    }
                    throw throwable;
                }
                try {
                    socket.close();
                }
                catch (Exception e3) {
                    this.logger.debug("isHostConnectivity socket close {}:{} error", new Object[]{host, port, e3});
                }
                return bl;
            }
        }
        return true;
    }

    public Result genKmP10(CreateP10VO createP10VO) {
        try {
            File directory;
            X500Name x500Name = null;
            try {
                x500Name = DnUtil.getRFC4519X500Name((String)createP10VO.getDn());
            }
            catch (Exception e) {
                this.logger.debug("\u751f\u6210km\u901a\u4fe1\u8bc1\u4e66\u7533\u8bf7\u6587\u4ef6p10\u5931\u8d25\uff1aDN\u4e0d\u7b26\u5408X500\u89c4\u8303[{}]", (Object)createP10VO.getDn());
                return Result.failure((ErrorEnum)ErrorEnum.DN_FORMAT_FAIL);
            }
            KeyPair keyPair = null;
            PKCS10CertificationRequest p10 = null;
            String p10Name = "";
            String sslP10Name = "";
            if (StringUtils.isNotBlank((CharSequence)createP10VO.getSslDn())) {
                directory = new File(this.configPath + "p10/");
                if (!directory.exists()) {
                    directory.mkdir();
                }
                keyPair = this.getP10KeyPair(createP10VO);
                this.logger.debug("KM\u5e94\u7528\u7b7e\u540d\u516c\u79c1\u94a5\u957f\u5ea6:" + createP10VO.getAlgLength());
                createP10VO.setPrivateKey(keyPair.getPrivate());
                createP10VO.setPublicKey(keyPair.getPublic());
                p10 = this.hsmService.genP10(createP10VO, Integer.valueOf(P10typeEnum.KM.value));
                p10Name = "KMCertReq_qm_" + DateTimeUtil.dateToZipStr((Date)new Date()) + "ZIP.zip";
                byte[] zip = FileUtils.buildZip((byte[])p10.getEncoded(), (byte[])keyPair.getPublic().getEncoded());
                FileUtils.saveFile((byte[])zip, (String)(this.configPath + "p10/" + p10Name));
                String priKeyPin = Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_XDJA_HSM.intValue() ? createP10VO.getPrivateKeyPin() : null;
                KmConfigBean kmConfigBean = new KmConfigBean(createP10VO.getKeyIndex(), priKeyPin);
                this.configFileService.saveTmpKmConfig(kmConfigBean);
            } else {
                if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_XDJA_HSM.intValue()) {
                    boolean flag = GMSSLSM2KeyUtils.getPrivateKeyAccessRightFromYunHsm((int)createP10VO.getKeyIndex(), (String)createP10VO.getPrivateKeyPin());
                    if (!flag) {
                        this.logger.debug("\u751f\u6210KM\u901a\u4fe1\u8bc1\u4e66p10\u5931\u8d25\uff1a\u4fe1\u5927\u6377\u5b89\u5bc6\u7801\u673a\u4e24\u7801\u6ca1\u6709\u8bbf\u95ee\u6743\u9650[{}]", (Object)createP10VO);
                        return Result.failure((ErrorEnum)ErrorEnum.HSM_KEY_PIN_ERROR);
                    }
                } else if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_SWXA_HSM.intValue()) {
                    YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLSancHsmUtils.testConnect();
                    if (yunHsmExceptionEnum.id != YunHsmExceptionEnum.NORMAL.id) {
                        this.logger.debug("\u751f\u6210KM\u901a\u4fe1\u8bc1\u4e66p10\u5931\u8d25\uff1a\u8fde\u63a5\u4e09\u672a\u4fe1\u5b89\u5bc6\u7801\u673a\u5f02\u5e38[{}]", (Object)createP10VO);
                        return Result.failure((ErrorEnum)ErrorEnum.HSM_KEY_PIN_ERROR);
                    }
                } else {
                    keyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
                    CertUtil.writeObjToFile((Object)keyPair.getPrivate(), (String)(this.configPath + "km/tmp/appSignPrivate.key"));
                    CertUtil.writeObjToFile((Object)keyPair.getPublic(), (String)(this.configPath + "km/tmp/appSignPublickey.pem"));
                    createP10VO.setPrivateKey(keyPair.getPrivate());
                    createP10VO.setPublicKey(keyPair.getPublic());
                }
                createP10VO.setAlgName(SignAlgTypeEnum.SM3_WITH_SM2.algName);
                createP10VO.setAlg(Integer.valueOf(AlgTypeEnum.SM2.value));
                p10 = this.hsmService.genP10(createP10VO, Integer.valueOf(P10typeEnum.KM.value));
                p10Name = "KMCertReq_" + DateTimeUtil.dateToZipStr((Date)new Date()) + ".p10";
                directory = new File(this.configPath + "p10/");
                if (!directory.exists()) {
                    directory.mkdir();
                }
                CertUtil.writeObjToFile((Object)p10, (String)(this.configPath + "p10/" + p10Name));
                String priKeyPin = Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_XDJA_HSM.intValue() ? createP10VO.getPrivateKeyPin() : null;
                KmConfigBean kmConfigBean = new KmConfigBean(createP10VO.getKeyIndex(), priKeyPin);
                this.configFileService.saveTmpKmConfig(kmConfigBean);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("p10Name", p10Name);
            map.put("sslP10Name", sslP10Name);
            return Result.success(map);
        }
        catch (Exception e) {
            throw new ServiceException("\u751f\u6210P10\u5931\u8d25", (Throwable)e);
        }
    }

    private KeyPair getP10KeyPair(CreateP10VO createP10VO) {
        KeyPair keyPair = this.softAlgManager.generateKeyPair(createP10VO.getAlgLength());
        CertUtil.writeObjToFile((Object)keyPair.getPrivate(), (String)(this.configPath + "km/tmp/appSignPrivate.key"));
        CertUtil.writeObjToFile((Object)keyPair.getPublic(), (String)(this.configPath + "km/tmp/appSignPublickey.pem"));
        return keyPair;
    }

    private KeyPair getSSLP10KeyPair(CreateP10VO createP10VO) {
        KeyPair keyPair = this.softAlgManager.generateKeyPair(createP10VO.getAlgLength());
        CertUtil.writeObjToFile((Object)keyPair.getPrivate(), (String)(this.configPath + "km/tmp/sslPrivate.key"));
        CertUtil.writeObjToFile((Object)keyPair.getPublic(), (String)(this.configPath + "km/tmp/sslPublickey.pem"));
        return keyPair;
    }

    public Result importKmConfig(FileInputStream kmCaCert, FileInputStream kmCommCert, KmConfigBean tmpKmConfigBean) {
        try {
            KmConfigBean kmConfigBean = this.configFileService.getKmConfig();
            if (null != kmCommCert) {
                X509Certificate commCert = CertUtils.getCertFromFile((FileInputStream)kmCommCert);
                if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_XDJA_HSM.intValue()) {
                    String random = "sushi";
                    String sign = GMSSLSM2SignUtils.signByYunhsm((int)tmpKmConfigBean.getKeyIndex(), (String)tmpKmConfigBean.getPrivateKeyPin(), (String)Base64.toBase64String((byte[])random.getBytes()));
                    PublicKey publicKey = commCert.getPublicKey();
                    Boolean flag = GMSSLSM2SignUtils.verifyByYunhsm((PublicKey)publicKey, (String)Base64.toBase64String((byte[])random.getBytes()), (String)sign);
                    if (!flag.booleanValue()) {
                        this.logger.info("\u901a\u4fe1\u8bc1\u4e66\u516c\u79c1\u94a5\u9a8c\u8bc1\u5931\u8d25");
                        return Result.failure((ErrorEnum)ErrorEnum.PUBLIC_KEY_IS_NOT_MATCH_ERROR);
                    }
                } else {
                    FileUtils.copy((String)(this.configPath + "km/tmp/appSignPrivate.key"), (String)(this.configPath + "km/appSignPrivate.key"));
                    FileUtils.copy((String)(this.configPath + "km/tmp/appSignPublickey.pem"), (String)(this.configPath + "km/appSignPublickey.pem"));
                }
                String commDirectoryPath = this.configPath + "swxa/certs/ck/" + "swxaComm.cer";
                CertUtil.writeObjToPem((Object)commCert, (String)commDirectoryPath);
            } else if (null != kmConfigBean && StringUtils.isNotBlank((CharSequence)kmConfigBean.getKmCommCertName())) {
                tmpKmConfigBean.setKmCommCertName(kmConfigBean.getKmCommCertName());
            }
            if (null != kmCaCert) {
                X509Certificate caCert = CertUtils.getCertFromFile((FileInputStream)kmCaCert);
                String caDirectoryPath = this.configPath + "swxa/certs/ck/" + "swxaCa.cer";
                CertUtil.writeObjToPem((Object)caCert, (String)caDirectoryPath);
            } else if (null != kmConfigBean && StringUtils.isNotBlank((CharSequence)kmConfigBean.getKmCaCertName())) {
                tmpKmConfigBean.setKmCaCertName(kmConfigBean.getKmCaCertName());
            }
            this.configFileService.saveKmConfig(tmpKmConfigBean);
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
            caInfoVO.setKmConfigBean(this.configFileService.getKmConfig());
            Constants.CA_INFO.put(Constants.BASE_ALG_TYPE, caInfoVO);
            return Result.success();
        }
        catch (Exception e) {
            throw new ServiceException("\u4fdd\u5b58Km\u914d\u7f6e\u4fe1\u606f\u65f6\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result getKmConfig() {
        try {
            KmConfigBean kmConfigBean = this.configFileService.getKmConfig();
            if (null == kmConfigBean) {
                return Result.success((Object)new KmConfigBean());
            }
            return Result.success((Object)kmConfigBean);
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6km\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result testKmConfig(String ip, Integer port) {
        try {
            boolean flag = this.isHostConnectivity(ip, port);
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("result", flag);
            return Result.success(map);
        }
        catch (Exception e) {
            throw new ServiceException("\u6d4b\u8bd5Km\u8fde\u901a\u6027\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result testConfigKmInit() {
        try {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
            if (null != caInfoVO) {
                KmConfigBean kmConfigBean = caInfoVO.getKmConfigBean();
                if (null != kmConfigBean) {
                    if (StringUtils.isNotBlank((CharSequence)kmConfigBean.getIp())) {
                        map.put("result", true);
                        return Result.success(map);
                    }
                } else {
                    XdjaKmConfigBean xdjaKmConfigBean = caInfoVO.getXdjaKmConfigBean();
                    if (null != xdjaKmConfigBean && StringUtils.isNotBlank((CharSequence)xdjaKmConfigBean.getKmIp())) {
                        map.put("result", true);
                        return Result.success(map);
                    }
                }
            }
            map.put("result", false);
            return Result.success(map);
        }
        catch (Exception e) {
            throw new ServiceException("\u67e5\u8be2KM\u662f\u5426\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
        }
    }

    public String getNameByPath(String path) {
        String[] ss = path.split("\\\\");
        return ss[ss.length - 1];
    }

    public Result saveXdjaKmConfig(Integer keyIndex, String priKeyPwd, String kmIp, int kmPort, MultipartFile localSignCert, MultipartFile localEncCert, MultipartFile kmServerSignCert, MultipartFile kmServerEncCert, MultipartFile kmTrustCert, MultipartFile sslSignCert, MultipartFile sslEncCert) throws Exception {
        try {
            Result testResult;
            Result result = new Result();
            Object resultInfo = null;
            XdjaKmConfigBean xdjaKmConfigBean = this.configFileService.getXdjaKmConfigBean();
            if (null == xdjaKmConfigBean) {
                if (localEncCert.getBytes() == null || localSignCert.getBytes() == null || kmServerSignCert.getBytes() == null || kmServerEncCert.getBytes() == null) {
                    result.setError(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
                    return result;
                }
                xdjaKmConfigBean = new XdjaKmConfigBean();
            }
            if (!(testResult = this.testXdjaKmConfigConnection(keyIndex, priKeyPwd, kmIp, kmPort, localSignCert, localEncCert, kmServerSignCert, kmServerEncCert, kmTrustCert, sslSignCert, sslEncCert)).isSuccess()) {
                return testResult;
            }
            boolean resultFlag = (Boolean)testResult.getInfo();
            if (!resultFlag) {
                return Result.failure((ErrorEnum)ErrorEnum.XDJA_KM_CONNECTION_FAIL);
            }
            xdjaKmConfigBean = this.saveNewXdjaKmCert(xdjaKmConfigBean, keyIndex, priKeyPwd, kmIp, kmPort, localSignCert, localEncCert, kmServerSignCert, kmServerEncCert, kmTrustCert, sslSignCert, sslEncCert);
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
            caInfoVO.setXdjaKmConfigBean(xdjaKmConfigBean);
            this.configFileService.saveXdjaKmConfigBean(xdjaKmConfigBean);
            Constants.CA_INFO.put(Constants.BASE_ALG_TYPE, caInfoVO);
            return Result.success();
        }
        catch (Exception e) {
            throw new ServiceException("\u4fdd\u5b58KM\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
    }

    private XdjaKmConfigBean saveNewXdjaKmCert(XdjaKmConfigBean xdjaKmConfigBean, Integer keyIndex, String priKeyPwd, String kmIp, int kmPort, MultipartFile localSignCert, MultipartFile localEncCert, MultipartFile kmServerSignCert, MultipartFile kmServerEncCert, MultipartFile kmTrustCert, MultipartFile sslSignCert, MultipartFile sslEncCert) throws Exception {
        if (null != keyIndex) {
            xdjaKmConfigBean.setKeyIndex(keyIndex);
        }
        if (StringUtils.isNotBlank((CharSequence)priKeyPwd)) {
            xdjaKmConfigBean.setPriKeyPwd(priKeyPwd);
        }
        if (StringUtils.isNotBlank((CharSequence)kmIp)) {
            xdjaKmConfigBean.setKmIp(kmIp);
        }
        if (0 != kmPort) {
            xdjaKmConfigBean.setKmPort(kmPort);
        }
        if (null != localEncCert && null != localEncCert.getBytes()) {
            xdjaKmConfigBean.setAppEncCert(localEncCert.getOriginalFilename());
            P7bUtils.saveP7bByteToFile((byte[])localEncCert.getBytes(), (String)(this.configPath + "km/appEncCert.p7b"));
            if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue()) {
                FileUtils.copy((String)(this.configPath + "km/tmp/appSignPrivate.key"), (String)(this.configPath + "km/appSignPrivate.key"));
                FileUtils.copy((String)(this.configPath + "km/tmp/appSignPublickey.pem"), (String)(this.configPath + "km/appSignPublickey.pem"));
            }
        }
        if (null != localSignCert && null != localSignCert.getBytes()) {
            xdjaKmConfigBean.setAppSignCert(localSignCert.getOriginalFilename());
            P7bUtils.saveP7bByteToFile((byte[])localSignCert.getBytes(), (String)(this.configPath + "km/appSignCert.p7b"));
            if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue()) {
                FileUtils.copy((String)(this.configPath + "km/tmp/appSignPrivate.key"), (String)(this.configPath + "km/appSignPrivate.key"));
                FileUtils.copy((String)(this.configPath + "km/tmp/appSignPublickey.pem"), (String)(this.configPath + "km/appSignPublickey.pem"));
            }
        }
        if (null != kmServerSignCert && null != kmServerSignCert.getBytes()) {
            xdjaKmConfigBean.setKmServerSignCert(kmServerSignCert.getOriginalFilename());
            P7bUtils.saveP7bByteToFile((byte[])kmServerSignCert.getBytes(), (String)(this.configPath + "km/kmServerSignCert.p7b"));
        }
        if (null != kmServerEncCert && null != kmServerEncCert.getBytes()) {
            xdjaKmConfigBean.setKmServerEncCert(kmServerEncCert.getOriginalFilename());
            P7bUtils.saveP7bByteToFile((byte[])kmServerEncCert.getBytes(), (String)(this.configPath + "km/kmServerEncCert.p7b"));
        }
        this.configFileService.saveXdjaKmConfigBean(xdjaKmConfigBean);
        return xdjaKmConfigBean;
    }

    public Result getXdjaKmConfig() throws Exception {
        try {
            XdjaKmConfigBean xdjaKmConfigBean = this.configFileService.getXdjaKmConfigBean();
            return Result.success(this.buildXdjaKmConfig(xdjaKmConfigBean));
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u4fe1\u5927\u6377\u5b89KM\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
    }

    private Map<String, Object> buildXdjaKmConfig(XdjaKmConfigBean xdjaKmConfigBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null == xdjaKmConfigBean) {
            xdjaKmConfigBean = new XdjaKmConfigBean();
        }
        map.put("kmIp", xdjaKmConfigBean.getKmIp());
        map.put("kmPort", xdjaKmConfigBean.getKmPort());
        map.put("keyIndex", xdjaKmConfigBean.getKeyIndex());
        map.put("priKeyPwd", xdjaKmConfigBean.getPriKeyPwd());
        map.put("localSignCert", xdjaKmConfigBean.getAppSignCert());
        map.put("localEncCert", xdjaKmConfigBean.getAppEncCert());
        map.put("kmServerSignCert", xdjaKmConfigBean.getKmServerSignCert());
        map.put("kmServerEncCert", xdjaKmConfigBean.getKmServerEncCert());
        map.put("kmTrustCert", xdjaKmConfigBean.getSslCaCertChain());
        map.put("sslSignCert", xdjaKmConfigBean.getSslSignCert());
        map.put("sslEncCert", xdjaKmConfigBean.getSslEncCert());
        return map;
    }

    /*
     * Unable to fully structure code
     */
    private Result verifyPublicKeyWithIndex(int certType, int keyIndex, X509Certificate certificate) {
        result = new Result();
        stringPublicKey = Base64.toBase64String((byte[])certificate.getPublicKey().getEncoded());
        publicKey = null;
        if (Constants.BASE_ALG_TYPE.equals(Constants.RSA_ALG)) {
            try {
                if (certType == 2) {
                    publicKey = GMSSLRSAKeyUtils.getSignPublicKeyByYunhsm((int)keyIndex);
                }
                if (certType != 3) ** GOTO lbl27
                publicKey = GMSSLRSAKeyUtils.getEncryptPublicKeyByYunhsm((int)keyIndex);
            }
            catch (Exception e) {
                this.logger.error("\u5bc6\u94a5\u7d22\u5f15\u9519\u8bef", (Throwable)e);
                result.setError(ErrorEnum.KM_INDEX_CONFIG_IS_ERROR);
                return result;
            }
        } else {
            try {
                if (certType == 2) {
                    publicKey = GMSSLSM2KeyUtils.getSignPublicKeyByYunhsm((int)keyIndex);
                } else if (certType == 3) {
                    publicKey = GMSSLSM2KeyUtils.getEncryptPublicKeyByYunhsm((int)keyIndex);
                }
            }
            catch (Exception e) {
                this.logger.error("\u5bc6\u94a5\u7d22\u5f15\u9519\u8bef", (Throwable)e);
                result.setError(ErrorEnum.KM_INDEX_CONFIG_IS_ERROR);
                return result;
            }
        }
lbl27:
        // 5 sources

        stringSignPublicKey = Base64.toBase64String((byte[])publicKey.getEncoded());
        if (!stringPublicKey.equals(stringSignPublicKey)) {
            this.logger.info("\u8bc1\u4e66\u4e2d\u7684\u516c\u94a5\u548c\u7d22\u5f15\u516c\u94a5\u4e0d\u4e00\u81f4");
            result.setError(ErrorEnum.CERT_PUB_KEY_NOT_SAME_INDEX_KEY);
            return result;
        }
        return result;
    }

    public Result chooseKmSystem(int kmSystemType) throws Exception {
        Result result = new Result();
        this.configFileService.saveKmSystemType(kmSystemType);
        return result;
    }

    public Result getKmSystemType() {
        Result result = new Result();
        result.setInfo((Object)this.configFileService.getKmSystemType());
        return result;
    }

    public Result testXdjaKmConfigConnection(Integer keyIndex, String priKeyPwd, String kmIp, int kmPort, MultipartFile localSignCert, MultipartFile localEncCert, MultipartFile kmServerSignCert, MultipartFile kmServerEncCert, MultipartFile kmTrustCert, MultipartFile sslSignCert, MultipartFile sslEncCert) {
        HashMap map = new HashMap();
        Result result = Result.success();
        HashMap<String, Object> tempMap = new HashMap<String, Object>();
        String random = "sushi";
        boolean flag = false;
        boolean resultFlag = false;
        try {
            Result verifyKmServerEncCert;
            File file;
            X509Certificate appSignCert = null;
            X509Certificate kmServerSignTmpCert = null;
            PrivateKey appSignPrivate = null;
            if (localSignCert != null && localSignCert.getBytes() != null) {
                Result verifyLocalSignCert = VerifyCert.verifyP7bCertList((byte[])localSignCert.getBytes(), (int)2);
                if (!verifyLocalSignCert.isSuccess()) {
                    this.logger.info("\u5bfc\u5165\u7684KM\u5e94\u7528\u7b7e\u540d\u8bc1\u4e66\u683c\u5f0f\u9519\u8bef");
                    result.setError(verifyLocalSignCert.getError());
                    return result;
                }
                appSignCert = CertUtil.getUserCertByCertChain((InputStream)localSignCert.getInputStream());
                if (Constants.CRYPT_DEVICE_TYPE.intValue() != Constants.CRYPT_DEVICE_BC.intValue()) {
                    Result signPublicVerify = this.verifyPublicKeyWithIndex(2, keyIndex, appSignCert);
                    if (!signPublicVerify.isSuccess()) {
                        this.logger.info("\u9a8c\u8bc1KM\u5e94\u7528\u7b7e\u540d\u8bc1\u4e66\u4e2d\u7684\u516c\u94a5\u548c\u5bc6\u94a5\u7d22\u5f15\u4e0d\u4e00\u81f4");
                        result.setError(signPublicVerify.getError());
                        return result;
                    }
                } else {
                    appSignCert = CertUtil.getUserCertByCertChain((InputStream)localSignCert.getInputStream());
                    appSignPrivate = CertUtil.getPrivateKey((String)(this.configPath + "km/tmp/appSignPrivate.key"));
                    if (null == appSignPrivate) {
                        this.logger.debug("\u5e94\u7528\u7b7e\u540d\u8bc1\u4e66\u548c\u5e94\u7528\u7b7e\u540d\u79c1\u94a5\u4e0d\u5339\u914d");
                        return Result.failure((ErrorEnum)ErrorEnum.PUBLIC_KEY_IS_NOT_MATCH_ERROR);
                    }
                    String sign = this.hsmService.signDataByBC(Constants.BASE_ALG_TYPE, appSignPrivate, Base64.toBase64String((byte[])random.getBytes()));
                    flag = this.hsmService.verifySignByBcDefaultAlg(Constants.BASE_ALG_TYPE, appSignCert.getPublicKey(), Base64.toBase64String((byte[])random.getBytes()), sign);
                    if (!flag) {
                        this.logger.debug("\u5e94\u7528\u7b7e\u540d\u8bc1\u4e66\u548c\u5e94\u7528\u7b7e\u540d\u79c1\u94a5\u4e0d\u5339\u914d");
                        return Result.failure((ErrorEnum)ErrorEnum.PUBLIC_KEY_IS_NOT_MATCH_ERROR);
                    }
                }
            } else {
                file = new File(this.configPath + "km/appSignCert.p7b");
                if (!file.exists()) {
                    result.setError(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
                    return result;
                }
                appSignCert = CertUtil.getUserCertByCertChain((File)file);
                appSignPrivate = CertUtil.getPrivateKey((String)(this.configPath + "km/appSignPrivate.key"));
            }
            if (localEncCert != null && localEncCert.getBytes() != null) {
                Result verifyLocalEncCert = VerifyCert.verifyP7bCertList((byte[])localEncCert.getBytes(), (int)3);
                if (!verifyLocalEncCert.isSuccess()) {
                    this.logger.info("\u5bfc\u5165\u7684KM\u5e94\u7528\u52a0\u5bc6\u8bc1\u4e66\u683c\u5f0f\u9519\u8bef");
                    result.setError(verifyLocalEncCert.getError());
                    return result;
                }
            } else {
                file = new File(this.configPath + "km/appEncCert.p7b");
                if (!file.exists()) {
                    result.setError(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
                    return result;
                }
            }
            if (kmServerSignCert != null && kmServerSignCert.getBytes() != null) {
                Result verifyServerSignCert = VerifyCert.verifyP7bCertList((byte[])kmServerSignCert.getBytes(), (int)2);
                if (!verifyServerSignCert.isSuccess()) {
                    this.logger.info("\u5bfc\u5165\u7684KM\u670d\u52a1\u5668\u7b7e\u540d\u8bc1\u4e66\u683c\u5f0f\u9519\u8bef\uff1a" + JsonUtils.object2Json((Object)verifyServerSignCert));
                    result.setError(verifyServerSignCert.getError());
                    return result;
                }
                kmServerSignTmpCert = CertUtil.getUserCertByCertChain((byte[])kmServerSignCert.getBytes());
            } else {
                file = new File(this.configPath + "km/kmServerSignCert.p7b");
                if (!file.exists()) {
                    result.setError(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
                    return result;
                }
                kmServerSignTmpCert = CertUtil.getUserCertByCertChain((File)file);
            }
            if (kmServerEncCert != null && kmServerEncCert.getBytes() != null) {
                Result verifyServerEncCert = VerifyCert.verifyP7bCertList((byte[])kmServerEncCert.getBytes(), (int)3);
                if (!verifyServerEncCert.isSuccess()) {
                    this.logger.info("\u5bfc\u5165\u7684KM\u670d\u52a1\u5668\u7b7e\u540d\u8bc1\u4e66\u683c\u5f0f\u9519\u8bef\uff1a" + JsonUtils.object2Json((Object)verifyServerEncCert));
                    result.setError(verifyServerEncCert.getError());
                    return result;
                }
            } else {
                file = new File(this.configPath + "km/kmServerEncCert.p7b");
                if (!file.exists()) {
                    result.setError(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
                    return result;
                }
            }
            tempMap.put("ip", kmIp);
            tempMap.put("port", kmPort);
            tempMap.put("appSignCert", appSignCert);
            tempMap.put("appSignPrivate", appSignPrivate);
            tempMap.put("kmServerSignCert", kmServerSignTmpCert);
            tempMap.put("keyIndex", keyIndex);
            tempMap.put("priKeyPwd", priKeyPwd);
            if (kmServerEncCert != null && kmServerEncCert.getBytes() != null && !(verifyKmServerEncCert = VerifyCert.verifyP7bCertList((byte[])kmServerEncCert.getBytes(), (int)3)).isSuccess()) {
                this.logger.info("\u5bfc\u5165\u7684KM\u670d\u52a1\u5668\u52a0\u5bc6\u8bc1\u4e66\u683c\u5f0f\u9519\u8bef\uff1a" + JsonUtils.object2Json((Object)verifyKmServerEncCert));
                result.setError(verifyKmServerEncCert.getError());
                return result;
            }
            KmsService kmsService = (KmsService)SpringBeanUtils.getBean((String)"kmsXdjaHttpService");
            KeyPair keyPair = this.softAlgManager.generateKeyPair(Integer.valueOf(1024));
            Date notBefore = new Date();
            Date notAfter = DateTimeUtil.longToDate((long)(notBefore.getTime() + 100000000L));
            BigInteger signSn = this.certSnDao.getMaxSn(notBefore);
            String dn = "CN=kmConnectionTest,O=xdja,C=CN";
            int length = Constants.BASE_ALG_TYPE == AlgTypeEnum.RSA.value ? 1024 : 256;
            ResponseBean responseBean = kmsService.testApplyEncKey(tempMap, signSn, keyPair.getPublic(), notBefore, notAfter, dn, null, null, length, "", "");
            resultFlag = true;
        }
        catch (Exception e) {
            this.logger.error("\u6d4b\u8bd5\u4fe1\u5927\u6377\u5b89KM\u8fde\u901a\u6027\u5931\u8d25", (Throwable)e);
            resultFlag = false;
        }
        return Result.success((Object)resultFlag);
    }
}

