/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.service.localca;

import com.xdja.pki.ca.certmanager.service.crltemplate.CrlTemplateService;
import com.xdja.pki.ca.certmanager.service.racert.RaManagerCertService;
import com.xdja.pki.ca.certmanager.service.racert.bean.CertTypeEnum;
import com.xdja.pki.ca.certmanager.service.racert.bean.PwdUsedEnum;
import com.xdja.pki.ca.certmanager.service.task.TaskDataService;
import com.xdja.pki.ca.certmanager.service.template.TemplateService;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateInfoVO;
import com.xdja.pki.ca.certmanager.service.util.ExtensionUtil;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.PageInfo;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.configBasic.bean.CaPwdBean;
import com.xdja.pki.ca.core.configBasic.bean.KeyInfoBean;
import com.xdja.pki.ca.core.enums.CertStatusEnum;
import com.xdja.pki.ca.core.enums.P10typeEnum;
import com.xdja.pki.ca.core.enums.TemplateStatusEnum;
import com.xdja.pki.ca.core.enums.TemplateTypeEnum;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.pkcs7.P7bUtils;
import com.xdja.pki.ca.core.util.CertUtils;
import com.xdja.pki.ca.core.util.DnUtil;
import com.xdja.pki.ca.core.util.time.DateTimeUtil;
import com.xdja.pki.ca.core.util.time.IssueTimeUtil;
import com.xdja.pki.ca.hsm.manager.HsmManager;
import com.xdja.pki.ca.ldap.service.vo.LdapOcspUrlVO;
import com.xdja.pki.ca.securitymanager.dao.CaCertDao;
import com.xdja.pki.ca.securitymanager.dao.CertSnDao;
import com.xdja.pki.ca.securitymanager.dao.model.CaCertDTO;
import com.xdja.pki.ca.securitymanager.dao.model.CaCertDo;
import com.xdja.pki.ca.securitymanager.dao.model.CaDO;
import com.xdja.pki.ca.securitymanager.dao.model.RootCertDO;
import com.xdja.pki.ca.securitymanager.service.configfile.ConfigFileService;
import com.xdja.pki.ca.securitymanager.service.localca.LocalCaService;
import com.xdja.pki.ca.securitymanager.service.vo.AlgTypeEnum;
import com.xdja.pki.ca.securitymanager.service.vo.BasicContrainsEnum;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.CreateP10VO;
import com.xdja.pki.ca.securitymanager.service.vo.OldAndNewDTO;
import com.xdja.pki.ca.securitymanager.service.vo.RootCaDetailDTO;
import com.xdja.pki.ca.securitymanager.service.vo.SignAlgTypeEnum;
import com.xdja.pki.ca.securitymanager.service.vo.UpdateRootCertVO;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.sdf.yunhsm.utils.GMSSLSancHsmUtils;
import com.xdja.pki.gmssl.x509.utils.bean.YunHsmExceptionEnum;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LocalCaServiceImpl
implements LocalCaService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CaCertDao caCertDao;
    @Autowired
    private HsmManager hsmService;
    @Autowired
    private Environment environment;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private CertSnDao certSnDao;
    @Autowired
    CrlTemplateService crlTemplateService;
    @Autowired
    private TaskDataService taskDataService;
    @Autowired
    private RaManagerCertService raManagerCertService;
    @Autowired
    private ConfigFileService configFileService;
    @Value(value="${config.path}")
    private String configPath;

    public Result getLocalCaHistoryList(Integer pageNo, Integer pageSize) {
        try {
            PageInfo pageInfo = this.caCertDao.getCaCertHistoryList(pageNo.intValue(), pageSize.intValue());
            List caCertDTOList = (List)pageInfo.getDatas();
            for (CaCertDTO caCertDTO : caCertDTOList) {
                caCertDTO.setSignAlgStr(SignAlgTypeEnum.getViewAlgName((int)Integer.parseInt(caCertDTO.getSignAlg())));
            }
            pageInfo.setDatas((Collection)caCertDTOList);
            return Result.success((Object)pageInfo);
        }
        catch (Exception e) {
            throw new ServiceException("\u67e5\u8be2\u672c\u673aCA\u5386\u53f2\u8bc1\u4e66\u5217\u8868\u5931\u8d25", (Throwable)e);
        }
    }

    public Result createP10(CreateP10VO createP10VO) {
        X500Name x500Name = null;
        try {
            x500Name = DnUtil.getRFC4519X500Name((String)createP10VO.getDn());
        }
        catch (Exception e) {
            this.logger.debug("\u751f\u6210P10\u5931\u8d25: DN\u4e0d\u7b26\u5408X500\u89c4\u8303[{}]", (Object)createP10VO.getDn());
            return Result.failure((ErrorEnum)ErrorEnum.DN_FORMAT_FAIL);
        }
        if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_XDJA_HSM.intValue()) {
            boolean flag;
            if (null == createP10VO.getKeyIndex() && StringUtils.isEmpty((CharSequence)createP10VO.getPrivateKeyPin())) {
                CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
                createP10VO.setKeyIndex(caInfoVO.getCaPwdBean().getKeyIndex());
                createP10VO.setPrivateKeyPin(caInfoVO.getCaPwdBean().getPrivateKeyPin());
            }
            if (!(flag = GMSSLSM2KeyUtils.getPrivateKeyAccessRightFromYunHsm((int)createP10VO.getKeyIndex(), (String)createP10VO.getPrivateKeyPin()))) {
                this.logger.debug("\u751f\u6210P10\u5931\u8d25\uff1a\u4fe1\u5927\u6377\u5b89\u5bc6\u7801\u673a\u4e24\u7801\u6ca1\u6709\u8bbf\u95ee\u6743\u9650[{}]", (Object)createP10VO);
                return Result.failure((ErrorEnum)ErrorEnum.HSM_KEY_PIN_ERROR);
            }
        }
        if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_SWXA_HSM.intValue()) {
            if (null == createP10VO.getKeyIndex()) {
                CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
                createP10VO.setKeyIndex(caInfoVO.getCaPwdBean().getKeyIndex());
            }
            YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLSancHsmUtils.testConnect();
            if (yunHsmExceptionEnum.id != YunHsmExceptionEnum.NORMAL.id) {
                this.logger.debug("\u751f\u6210P10\u5931\u8d25\uff1a\u8fde\u63a5\u4e09\u672a\u4fe1\u5b89\u5bc6\u7801\u673a\u5f02\u5e38[{}]", (Object)createP10VO);
                return Result.failure((ErrorEnum)ErrorEnum.HSM_KEY_PIN_ERROR);
            }
        }
        try {
            PKCS10CertificationRequest p10 = this.hsmService.genP10(createP10VO, Integer.valueOf(P10typeEnum.SubCa.value));
            String p10Name = "CertReq_" + DateTimeUtil.dateToZipStr((Date)new Date()) + ".p10";
            CertUtil.writeObjToFile((Object)p10, (String)(this.configPath + "p10/" + p10Name));
            KeyInfoBean keyInfoBean = new KeyInfoBean();
            CaPwdBean temporaryCaPwdBean = new CaPwdBean();
            BeanUtils.copyProperties((Object)createP10VO, (Object)temporaryCaPwdBean);
            keyInfoBean.setCaPwdBean(temporaryCaPwdBean);
            keyInfoBean.setKeyAlg(createP10VO.getAlg());
            keyInfoBean.setKeySize(createP10VO.getAlgLength());
            if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue()) {
                keyInfoBean.setPublicKey(CertUtil.getPublicKeyFromP10((String)CertUtil.writeObject((Object)p10)));
            }
            this.writeObjToFile(keyInfoBean, Constants.TEMPORARY_LOCAL_CAPWD_PATH);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("p10Name", p10Name);
            return Result.success(map);
        }
        catch (Exception e) {
            throw new ServiceException("\u751f\u6210p10\u7533\u8bf7\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public Result getRootCertDetail() {
        try {
            if (!this.caCertDao.currentIsRootCa().booleanValue()) {
                this.logger.info("\u672c\u673aCA\u4e0d\u662f\u6839CA,\u65e0\u6cd5\u83b7\u53d6\u6839CA\u4fe1\u606f");
                return Result.failure((ErrorEnum)ErrorEnum.PERMISSION_ACCESS_ERROR);
            }
            RootCertDO rootCertDO = this.caCertDao.getCurrentRootCert();
            CaCertDo caCertDo = this.caCertDao.getCurrentCert();
            RootCaDetailDTO rootCaDetailDTO = new RootCaDetailDTO();
            BeanUtils.copyProperties((Object)rootCertDO, (Object)rootCaDetailDTO);
            TemplateInfoVO templateInfoVO = this.templateService.getInnerTemplateByType(TemplateTypeEnum.ROOT_CA.value);
            if (null == templateInfoVO) {
                this.logger.info("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u7ed3\u679c\uff1a\u6a21\u677f\u4e0d\u5b58\u5728[{}]", (Object)TemplateTypeEnum.ROOT_CA.value);
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
            }
            if (TemplateStatusEnum.NORMAL.value != templateInfoVO.getStatus()) {
                this.logger.info("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u7ed3\u679c\uff1a\u6a21\u677f\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u6a21\u677f\u72b6\u6001\u4e3a[{}]", (Object)templateInfoVO.getStatus());
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
            }
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(caCertDo.getPublicKeyAlg());
            rootCaDetailDTO.setBaseDn(caInfoVO.getBaseDn());
            rootCaDetailDTO.setRemainingTime(Integer.valueOf(IssueTimeUtil.getCertRemainTime((Date)caInfoVO.getRootCert().getNotAfter(), (Date)new Date()).intValue()));
            rootCaDetailDTO.setMaxValidity(templateInfoVO.getMaxValidity());
            rootCaDetailDTO.setKeyAlgLength(templateInfoVO.getKeySize());
            return Result.success((Object)rootCaDetailDTO);
        }
        catch (BeansException e) {
            throw new ServiceException("\u83b7\u53d6\u6839CA\u8be6\u60c5\u5931\u8d25", (Throwable)e);
        }
    }

    public Result updateRootCert(UpdateRootCertVO updateRootCertVO) {
        try {
            if (!this.caCertDao.isCurrent(updateRootCertVO.getSn()).booleanValue() || !this.caCertDao.isRootCa(updateRootCertVO.getSn()).booleanValue()) {
                this.logger.info("\u672c\u673aCA\u4e0d\u662f\u6839CA,\u65e0\u6cd5\u83b7\u53d6\u6839CA\u4fe1\u606f");
                return Result.failure((ErrorEnum)ErrorEnum.PERMISSION_ACCESS_ERROR);
            }
            TemplateInfoVO templateInfoVO = this.templateService.getInnerTemplateByType(TemplateTypeEnum.ROOT_CA.value);
            OldAndNewDTO oldAndNewDTO = new OldAndNewDTO();
            if (null == templateInfoVO) {
                this.logger.info("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u7ed3\u679c\uff1a\u6a21\u677f\u4e0d\u5b58\u5728[{}]", (Object)TemplateTypeEnum.CA.value);
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_NOT_EXIST);
            }
            if (TemplateStatusEnum.NORMAL.value != templateInfoVO.getStatus()) {
                this.logger.info("\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u7ed3\u679c\uff1a\u6a21\u677f\u72b6\u6001\u4e0d\u6b63\u5e38\uff0c\u6a21\u677f\u72b6\u6001\u4e3a[{}]", (Object)templateInfoVO.getStatus());
                return Result.failure((ErrorEnum)ErrorEnum.TEMPLATE_STATUS_IS_STOP);
            }
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(templateInfoVO.getKeyAlg());
            if (null == caInfoVO || StringUtils.isBlank((CharSequence)caInfoVO.getBaseDn())) {
                this.logger.debug("\u66f4\u65b0CA\u6839\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u5230CA\u57fa\u672c\u4fe1\u606f[{}]", (Object)updateRootCertVO);
                return Result.failure((ErrorEnum)ErrorEnum.CA_BASEINFO_GET_FAIL);
            }
            CaInfoVO oldCaInfoVO = new CaInfoVO();
            BeanUtils.copyProperties((Object)caInfoVO, (Object)oldCaInfoVO);
            this.configFileService.saveOldCaPwdConfig(oldCaInfoVO.getCaPwdBean());
            Integer oldKeyIndex = oldCaInfoVO.getCaPwdBean().getKeyIndex();
            PublicKey oldPublicKey = Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue() ? oldCaInfoVO.getKeyPair().getPublic() : this.hsmService.getSignPublicKeyByCryptyDevice(oldCaInfoVO.getCaPwdBean().getKeyIndex(), Integer.valueOf(PwdUsedEnum.ROOT_CERT_TYPE.value), templateInfoVO.getKeyAlg(), templateInfoVO.getKeySize());
            oldAndNewDTO.setOldSubject(oldCaInfoVO.getSubject());
            oldAndNewDTO.setOldPrivateKey(oldCaInfoVO.getRootPrivateKey());
            oldAndNewDTO.setOldPublicKey(oldPublicKey);
            oldAndNewDTO.setOldCaPwdBean(oldCaInfoVO.getCaPwdBean());
            oldAndNewDTO.setOldCertBeforeTime(oldCaInfoVO.getRootCert().getNotBefore());
            oldAndNewDTO.setOldCertAfterTime(oldCaInfoVO.getRootCert().getNotBefore());
            oldAndNewDTO.setNewSubject(oldCaInfoVO.getSubject());
            oldAndNewDTO.setNewPrivateKey(oldCaInfoVO.getRootPrivateKey());
            oldAndNewDTO.setNewCaPwdBean(oldCaInfoVO.getCaPwdBean());
            oldAndNewDTO.setNewPublicKey(oldPublicKey);
            if (null == caInfoVO || StringUtils.isBlank((CharSequence)caInfoVO.getBaseDn())) {
                this.logger.debug("\u66f4\u65b0CA\u6839\u8bc1\u4e66\u5931\u8d25\uff1a\u672a\u67e5\u5230CA\u57fa\u672c\u4fe1\u606f[{}]", (Object)updateRootCertVO);
                return Result.failure((ErrorEnum)ErrorEnum.CA_BASEINFO_GET_FAIL);
            }
            if (updateRootCertVO.getDnUpdate().booleanValue()) {
                if (!updateRootCertVO.getCertDn().toLowerCase().endsWith(caInfoVO.getBaseDn().toLowerCase())) {
                    this.logger.debug("\u66f4\u65b0CA\u6839\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e2d\u7684baseDn\u4e0d\u6b63\u786e[{}]", (Object)updateRootCertVO);
                    return Result.failure((ErrorEnum)ErrorEnum.BASEDN_ERROR);
                }
                try {
                    X500Name x500Name = DnUtil.getRFC4519X500Name((String)updateRootCertVO.getCertDn());
                    oldAndNewDTO.setNewSubject(updateRootCertVO.getCertDn());
                }
                catch (Exception e) {
                    this.logger.debug("\u521d\u59cb\u5316CA\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e0d\u7b26\u5408X500\u89c4\u8303[{}]", (Object)updateRootCertVO.getCertDn());
                    return Result.failure((ErrorEnum)ErrorEnum.DN_FORMAT_FAIL);
                }
            }
            Date beforeTime = new Date();
            Date afterTime = caInfoVO.getRootCert().getNotAfter();
            if (updateRootCertVO.getValidityUpdate().booleanValue()) {
                if (updateRootCertVO.getValidity() > templateInfoVO.getMaxValidity()) {
                    this.logger.debug("\u5ef6\u671f\u5929\u6570\u8d85\u8fc7\u6a21\u677f\u6700\u5927\u6709\u6548\u671f");
                    return Result.failure((ErrorEnum)ErrorEnum.TIME_BEYOND_VALIDITY_ERROR);
                }
                afterTime = new Date(beforeTime.getTime() + (long)updateRootCertVO.getValidity().intValue() * 24L * 60L * 60L * 1000L);
            }
            oldAndNewDTO.setNewCertBeforeTime(beforeTime);
            oldAndNewDTO.setNewCertAfterTime(afterTime);
            BigInteger certSn = this.certSnDao.getMaxSn(beforeTime);
            CaPwdBean caPwdBean = caInfoVO.getCaPwdBean();
            Integer newKeyIndex = updateRootCertVO.getKeyIndex();
            if (newKeyIndex != null && newKeyIndex != oldKeyIndex || updateRootCertVO.isKeyUpdate()) {
                if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_XDJA_HSM.intValue()) {
                    boolean flag = GMSSLSM2KeyUtils.getPrivateKeyAccessRightFromYunHsm((int)updateRootCertVO.getKeyIndex(), (String)updateRootCertVO.getPrivateKeyPin());
                    if (!flag) {
                        this.logger.debug("\u66f4\u65b0\u6839\u8bc1\u4e66\u5931\u8d25\uff1a\u4fe1\u5927\u6377\u5b89\u5bc6\u7801\u673a\u4e24\u7801\u6ca1\u6709\u8bbf\u95ee\u6743\u9650[{}]", (Object)updateRootCertVO);
                        return Result.failure((ErrorEnum)ErrorEnum.HSM_KEY_PIN_ERROR);
                    }
                    caPwdBean = new CaPwdBean(updateRootCertVO.getKeyIndex(), updateRootCertVO.getPrivateKeyPin());
                }
                if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_SWXA_HSM.intValue()) {
                    YunHsmExceptionEnum yunHsmExceptionEnum = GMSSLSancHsmUtils.testConnect();
                    if (YunHsmExceptionEnum.NORMAL.id != yunHsmExceptionEnum.id) {
                        this.logger.debug("\u66f4\u65b0\u6839\u8bc1\u4e66\u5931\u8d25\uff1a\u83b7\u53d6\u4e09\u672a\u4fe1\u5b89\u5bc6\u7801\u673a\u5f02\u5e38[{}]", (Object)updateRootCertVO);
                        return Result.failure((ErrorEnum)ErrorEnum.HSM_KEY_PIN_ERROR);
                    }
                    caPwdBean = new CaPwdBean(updateRootCertVO.getKeyIndex(), updateRootCertVO.getPrivateKeyPin());
                }
                oldAndNewDTO.setNewPublicKey(this.hsmService.getSignPublicKeyByCryptyDevice(updateRootCertVO.getKeyIndex(), Integer.valueOf(PwdUsedEnum.ROOT_CERT_TYPE.value), templateInfoVO.getKeyAlg(), templateInfoVO.getKeySize()));
            }
            oldAndNewDTO.setNewCaPwdBean(caPwdBean);
            LdapOcspUrlVO ldapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(certSn, updateRootCertVO.getCertDn(), caInfoVO, true, null, null);
            List extensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), null, (PublicKey)oldAndNewDTO.getNewPublicKey(), (String)updateRootCertVO.getCertDn(), (LdapOcspUrlVO)ldapOcspUrlVO, (boolean)true);
            caInfoVO.setCaPwdBean(caPwdBean);
            caInfoVO.setSubject(updateRootCertVO.getCertDn());
            X509Certificate rootCert = this.hsmService.genRootX509Certificate(updateRootCertVO.getCertDn(), certSn, beforeTime, afterTime, oldAndNewDTO.getNewPublicKey(), caInfoVO, extensions, templateInfoVO.getSignAlg());
            templateInfoVO = this.templateService.getInnerTemplateByType(TemplateTypeEnum.CA.value);
            CaCertDo caCertDo = this.completeRootCert(rootCert, templateInfoVO, oldAndNewDTO, caInfoVO);
            caCertDo.setCaId(caInfoVO.getCaId());
            CaCertDo oldCaCertDo = this.caCertDao.getCurrentCaCert();
            caCertDo.setOldCertId(oldCaCertDo.getId());
            this.caCertDao.setIsCurrent(updateRootCertVO.getSn(), CaDO.CaMasterEnum.NO.value);
            caCertDo = this.caCertDao.save(caCertDo);
            caInfoVO.setRootCert(rootCert);
            BeanUtils.copyProperties((Object)caCertDo, (Object)caInfoVO);
            caInfoVO.setCertId(caCertDo.getId());
            Constants.CA_INFO.put(templateInfoVO.getKeyAlg(), caInfoVO);
            this.configFileService.saveCaPwdConfig(caPwdBean);
            this.taskDataService.savePublishCert(caCertDo.getId(), null, Integer.valueOf(3));
            this.taskDataService.saveSyncStatusCert(caCertDo.getId(), null, Integer.valueOf(5), Integer.valueOf(CertStatusEnum.NORMAL.value), null, new Date());
            return Result.success(null, (String)oldAndNewDTO.getOldSubject());
        }
        catch (Exception e) {
            throw new ServiceException("\u66f4\u65b0\u6839CA\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public Result doImportCertChain(byte[] bytes) {
        try {
            Result result = this.vertifyCertChain(bytes);
            if (!result.isSuccess()) {
                return result;
            }
            X509Certificate cert = (X509Certificate)((List)result.getInfo()).get(0);
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE);
            if (!CertUtil.getSubjectByX509Cert((X509Certificate)cert).toLowerCase().endsWith(caInfoVO.getBaseDn().toLowerCase())) {
                this.logger.error("\u5bfc\u5165\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e2d\u7684baseDn\u4e0d\u6b63\u786e[{}]", (Object)CertUtil.getSubjectByX509Cert((X509Certificate)cert));
                return Result.failure((ErrorEnum)ErrorEnum.BASEDN_ERROR);
            }
            KeyInfoBean keyInfoBean = null;
            try {
                keyInfoBean = this.readObjFromFile(Constants.TEMPORARY_LOCAL_CAPWD_PATH);
            }
            catch (Exception e) {
                return Result.failure((ErrorEnum)ErrorEnum.IMPORT_SUB_CA_CERT_CHAIN_NEED_CREATE_SUB_CA_APPLY);
            }
            PublicKey publicKey = Constants.CRYPT_DEVICE_TYPE.intValue() != Constants.CRYPT_DEVICE_BC.intValue() ? this.hsmService.getSignPublicKeyByCryptyDevice(keyInfoBean.getCaPwdBean().getKeyIndex(), Integer.valueOf(PwdUsedEnum.ROOT_CERT_TYPE.value), keyInfoBean.getKeyAlg(), keyInfoBean.getKeySize()) : keyInfoBean.getPublicKey();
            if (!new String(publicKey.getEncoded()).equals(new String(cert.getPublicKey().getEncoded()))) {
                this.logger.info("\u5bfc\u5165\u8bc1\u4e66\u94fe\u5931\u8d25:\u8bc1\u4e66\u4e2d\u7684\u516c\u94a5\u548cP10\u7533\u8bf7\u4e66\u4e2d\u7684\u516c\u94a5\u4e0d\u4e00\u81f4");
                return Result.failure((ErrorEnum)ErrorEnum.PUBLIC_KEY_IS_NOT_MATCH_ERROR);
            }
            X509Certificate oldCert = CertUtil.getCertFromStr((String)this.caCertDao.getCurrentCaCert().getCert());
            if (cert.getBasicConstraints() == BasicContrainsEnum.NOT_IS_CA.key) {
                this.logger.info("\u5bfc\u5165\u8bc1\u4e66\u94fe\u5931\u8d25\uff1a\u8bc1\u4e66\u4e0d\u662fCA\u8bc1\u4e66");
                return Result.failure((ErrorEnum)ErrorEnum.IS_NOT_CA_CERT);
            }
            if (oldCert.getBasicConstraints() != cert.getBasicConstraints()) {
                this.logger.info("\u5bfc\u5165\u8bc1\u4e66\u94fe\u5931\u8d25\uff1a\u5bfc\u5165\u8bc1\u4e66\u4e0e\u65e7\u8bc1\u4e66\u7684path_length\u4e0d\u4e00\u81f4");
                return Result.failure((ErrorEnum)ErrorEnum.PATH_LENGTH_IS_NOT_MATCH);
            }
            CaCertDo caCertDo = this.assemblingByCaCert(cert, keyInfoBean, null);
            caCertDo.setCertChain(new String(bytes));
            this.caCertDao.setIsCurrent(caInfoVO.getRootCert().getSerialNumber().toString(16), CaDO.CaMasterEnum.NO.value);
            caCertDo = this.caCertDao.save(caCertDo);
            if (Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC)) {
                PrivateKey privateKey = CertUtils.readPrivateKeyByPath((String)(Constants.CA_ROOT_PRIVATE_PATH + "tmpPrivate.key"));
                CertUtils.writeObjToFile((Object)privateKey, (String)(Constants.CA_ROOT_PRIVATE_PATH + "private.key"));
                caInfoVO.setRootPrivateKey(privateKey);
            }
            caInfoVO.setRootCert(cert);
            this.deleteFile(Constants.TEMPORARY_LOCAL_CAPWD_PATH);
            caInfoVO.setCaPwdBean(keyInfoBean.getCaPwdBean());
            this.configFileService.saveCaPwdConfig(keyInfoBean.getCaPwdBean());
            BeanUtils.copyProperties((Object)caCertDo, (Object)caInfoVO);
            caInfoVO.setCertId(caCertDo.getId());
            Constants.CA_INFO.put(keyInfoBean.getKeyAlg(), caInfoVO);
            return Result.success();
        }
        catch (Exception e) {
            throw new ServiceException("\u5bfc\u5165\u8bc1\u4e66\u94fe\u5931\u8d25", (Throwable)e);
        }
    }

    public Result viewCertDetail() {
        try {
            CaCertDo caCertDo = this.caCertDao.getCurrentCert();
            return this.raManagerCertService.getCertDetail(caCertDo.getSn(), Integer.valueOf(CertTypeEnum.CA_CERT.value));
        }
        catch (Exception e) {
            throw new ServiceException("\u67e5\u770b\u8bc1\u4e66\u8be6\u60c5\u5931\u8d25", (Throwable)e);
        }
    }

    public CaCertDo assemblingByCaCert(X509Certificate cert, KeyInfoBean keyInfoBean, TemplateInfoVO templateInfoVO) throws Exception {
        CaCertDo caCertDo = new CaCertDo();
        caCertDo.setBeforeTime(cert.getNotBefore());
        caCertDo.setAfterTime(cert.getNotAfter());
        caCertDo.setCert(CertUtil.writeObject((Object)cert));
        caCertDo.setGmtModified(new Date());
        caCertDo.setGmtCreate(new Date());
        caCertDo.setIsCurrent(Integer.valueOf(CaDO.CaMasterEnum.YES.value));
        caCertDo.setIssue(CertUtil.getIssuerByX509Cert((X509Certificate)cert));
        caCertDo.setSn(cert.getSerialNumber().toString(16));
        caCertDo.setSubject(CertUtil.getSubjectByX509Cert((X509Certificate)cert));
        caCertDo.setStatus(Integer.valueOf(1));
        if (null == templateInfoVO) {
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(keyInfoBean.getKeyAlg());
            caCertDo.setCaId(caInfoVO.getCaId());
            caCertDo.setPublicKeyAlg(keyInfoBean.getKeyAlg());
            caCertDo.setPrivateKeySize(keyInfoBean.getKeySize());
            if (AlgTypeEnum.SM2.value == Constants.BASE_ALG_TYPE) {
                caCertDo.setSignAlg(String.valueOf(SignAlgTypeEnum.SM3_WITH_SM2.value));
            } else if (AlgTypeEnum.RSA.value == Constants.BASE_ALG_TYPE) {
                caCertDo.setSignAlg(String.valueOf(SignAlgTypeEnum.getAlgValue((String)cert.getSigAlgName())));
            } else {
                caCertDo.setSignAlg(String.valueOf(SignAlgTypeEnum.SHA256_WITH_ECDSA.value));
            }
        } else {
            CaInfoVO caInfoVO = (CaInfoVO)Constants.CA_INFO.get(templateInfoVO.getKeyAlg());
            caCertDo.setCaId(caInfoVO.getCaId());
            caCertDo.setPublicKeyAlg(templateInfoVO.getKeyAlg());
            caCertDo.setPrivateKeySize(templateInfoVO.getKeySize());
            if (AlgTypeEnum.SM2.value == Constants.BASE_ALG_TYPE) {
                caCertDo.setSignAlg(String.valueOf(SignAlgTypeEnum.SM3_WITH_SM2.value));
            } else if (AlgTypeEnum.RSA.value == Constants.BASE_ALG_TYPE) {
                caCertDo.setSignAlg(String.valueOf(SignAlgTypeEnum.getAlgValue((String)cert.getSigAlgName())));
            } else {
                caCertDo.setSignAlg(String.valueOf(SignAlgTypeEnum.SHA256_WITH_ECDSA.value));
            }
        }
        return caCertDo;
    }

    public Result vertifyCertChain(byte[] bytes) {
        try {
            List certList = CertUtils.getCertListFromB64((byte[])bytes);
            if (CollectionUtils.isEmpty((Collection)certList)) {
                this.logger.debug("\u5bfc\u5165\u8bc1\u4e66\u94fe\u6a21\u5757>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u8bc1\u4e66\u94fe\u683c\u5f0f\u9519\u8bef");
                return Result.failure((ErrorEnum)ErrorEnum.HSM_CA_CHAIN_FORMAT_ERROR);
            }
            if (certList.size() >= 2) {
                X509Certificate rootCert = (X509Certificate)certList.get(certList.size() - 1);
                rootCert.verify(rootCert.getPublicKey());
                rootCert.checkValidity(new Date());
                for (int i = certList.size() - 1; i > 0; --i) {
                    X509Certificate parentCert = (X509Certificate)certList.get(i);
                    X509Certificate subCert = (X509Certificate)certList.get(i - 1);
                    subCert.verify(parentCert.getPublicKey());
                    subCert.checkValidity(new Date());
                }
            }
            return Result.success((Object)certList);
        }
        catch (Exception e) {
            this.logger.debug("\u5bfc\u5165\u8bc1\u4e66\u94fe\u6a21\u5757>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.HSM_CA_CHAIN_VERIFY_ERROR);
        }
    }

    private CaCertDo completeRootCert(X509Certificate rootCert, TemplateInfoVO templateInfoVO, OldAndNewDTO oldAndNewDTO, CaInfoVO caInfoVO) throws Exception {
        CaCertDo caCertDo = this.assemblingByCaCert(rootCert, null, templateInfoVO);
        ArrayList<X509Certificate> x509CertificateList = new ArrayList<X509Certificate>();
        x509CertificateList.add(rootCert);
        caCertDo.setCertChain(P7bUtils.createCertChainByCerts(x509CertificateList));
        Date nowTime = new Date();
        CaInfoVO caInfo = new CaInfoVO();
        BigInteger oldWithNewSn = this.certSnDao.getMaxSn(nowTime);
        LdapOcspUrlVO oldWithNewLdapOcspUrlVO = this.crlTemplateService.getLdapOcspUrl(oldWithNewSn, oldAndNewDTO.getOldSubject(), caInfoVO, true, null, null);
        List oldWithNewExtensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), null, (PublicKey)oldAndNewDTO.getOldPublicKey(), (String)oldAndNewDTO.getOldSubject(), (LdapOcspUrlVO)oldWithNewLdapOcspUrlVO, (boolean)true);
        caInfo.setRootPrivateKey(oldAndNewDTO.getNewPrivateKey());
        caInfo.setCaPwdBean(oldAndNewDTO.getNewCaPwdBean());
        caInfo.setSubject(oldAndNewDTO.getNewSubject());
        X509Certificate oldWithNewCert = this.hsmService.genX509Certificate(oldAndNewDTO.getOldSubject(), oldWithNewSn, oldAndNewDTO.getOldCertBeforeTime(), oldAndNewDTO.getOldCertAfterTime(), caInfo, oldAndNewDTO.getOldPublicKey(), oldWithNewExtensions, templateInfoVO.getSignAlg());
        caCertDo.setOldWithNewCert(CertUtil.writeObject((Object)oldWithNewCert));
        BigInteger newWithOldSn = this.certSnDao.getMaxSn(nowTime);
        LdapOcspUrlVO newWithOldLdapOcspUrlVo = this.crlTemplateService.getLdapOcspUrl(newWithOldSn, oldAndNewDTO.getNewSubject(), caInfoVO, true, null, null);
        List newWithOldExtensions = ExtensionUtil.changeExtensionFormat((List)templateInfoVO.getExtensions(), null, (PublicKey)oldAndNewDTO.getNewPublicKey(), (String)oldAndNewDTO.getNewSubject(), (LdapOcspUrlVO)newWithOldLdapOcspUrlVo, (boolean)true);
        caInfo.setRootPrivateKey(oldAndNewDTO.getOldPrivateKey());
        caInfo.setCaPwdBean(oldAndNewDTO.getOldCaPwdBean());
        caInfo.setSubject(oldAndNewDTO.getOldSubject());
        X509Certificate newWithOldCert = this.hsmService.genX509Certificate(oldAndNewDTO.getNewSubject(), newWithOldSn, oldAndNewDTO.getNewCertBeforeTime(), oldAndNewDTO.getNewCertAfterTime().getTime() < oldAndNewDTO.getOldCertAfterTime().getTime() ? oldAndNewDTO.getNewCertAfterTime() : oldAndNewDTO.getOldCertAfterTime(), caInfo, oldAndNewDTO.getNewPublicKey(), newWithOldExtensions, templateInfoVO.getSignAlg());
        caCertDo.setNewWithOldCert(CertUtil.writeObject((Object)newWithOldCert));
        return caCertDo;
    }

    private Result writeObjToFile(KeyInfoBean object, String path) {
        FileOutputStream out = null;
        try {
            File file = new File(path);
            if (file.exists()) {
                file.delete();
            }
            file.getParentFile().mkdirs();
            file.createNewFile();
            out = new FileOutputStream(file);
            ObjectOutputStream objOut = new ObjectOutputStream(out);
            objOut.writeObject(object);
            objOut.flush();
            objOut.close();
            return Result.success();
        }
        catch (IOException e) {
            this.logger.error("\u4fdd\u5b58\u4e34\u65f6\u5bc6\u94a5\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.WRITE_TO_FILE_ERRO);
        }
    }

    private KeyInfoBean readObjFromFile(String path) throws Exception {
        KeyInfoBean keyInfoBean = null;
        keyInfoBean = null;
        File file = new File(path);
        FileInputStream in = null;
        in = new FileInputStream(file);
        ObjectInputStream objIn = new ObjectInputStream(in);
        keyInfoBean = (KeyInfoBean)objIn.readObject();
        objIn.close();
        return keyInfoBean;
    }

    private void deleteFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }

    private int getValidity(String after) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        int day = 0;
        try {
            Date date1 = new Date();
            Date date2 = format.parse(after);
            day = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return day;
    }
}

