/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.service.login;

import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.security.bean.Function;
import com.xdja.pki.ca.securitymanager.dao.model.FunctionDO;
import com.xdja.pki.ca.securitymanager.service.vo.AlgTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class LoginBase {
    protected void filterFunction(Collection<Function> functions) {
        Iterator<Function> iterator = functions.iterator();
        Function item = null;
        while (iterator.hasNext()) {
            item = iterator.next();
            if (!item.isShow()) {
                iterator.remove();
                continue;
            }
            if (item.getObjName().equals("caPwdServerSet") && Constants.CRYPT_DEVICE_TYPE.equals(Constants.CRYPT_DEVICE_BC)) {
                iterator.remove();
                continue;
            }
            if (item.getObjName().equals("caKMServerSet") && Constants.BASE_ALG_TYPE == AlgTypeEnum.NISTP256.value) {
                iterator.remove();
            }
            if (!CollectionUtils.isNotEmpty((Collection)item.getChildren())) continue;
            this.filterFunction(item.getChildren());
        }
    }

    protected Collection<Function> convertFunction(List<FunctionDO> functionList) {
        LinkedHashMap<Long, Function> functions = new LinkedHashMap<Long, Function>();
        LinkedHashMap<Long, Function> tmpFunctions = new LinkedHashMap<Long, Function>();
        ArrayList<FunctionDO> list = new ArrayList<FunctionDO>();
        Function item = null;
        Function parentFunction = null;
        for (FunctionDO function : functionList) {
            item = this.functionDoToFunction(function);
            if (function.getParentId() == 0L) {
                functions.put(function.getId(), item);
                tmpFunctions.put(function.getId(), item);
                continue;
            }
            parentFunction = (Function)tmpFunctions.get(function.getParentId());
            if (null != parentFunction) {
                parentFunction.addChildren(item);
            } else {
                list.add(function);
            }
            tmpFunctions.put(function.getId(), item);
        }
        for (FunctionDO function : list) {
            item = this.functionDoToFunction(function);
            parentFunction = (Function)tmpFunctions.get(function.getParentId());
            if (null == parentFunction) continue;
            parentFunction.addChildren(item);
        }
        tmpFunctions = null;
        return functions.values();
    }

    protected Function functionDoToFunction(FunctionDO function) {
        Function item = new Function();
        item.setId(function.getId().longValue());
        item.setName(function.getName());
        item.setObjName(function.getObjName());
        item.setIcon(function.getIcon());
        item.setLink(function.getLink());
        item.setOrder(function.getOrderNum().intValue());
        item.setKey(function.getPermissionKey());
        item.setPermission(function.getPermission());
        item.setShow(function.getIsShow() == FunctionDO.FunctionShowEnum.YES.value);
        return item;
    }
}

