/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.service.login;

import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ca.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.auth.service.bean.DigestAlgEnum;
import com.xdja.pki.auth.service.bean.KeyAlgEnum;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDao;
import com.xdja.pki.ca.certmanager.dao.ManagerCertDataDao;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDO;
import com.xdja.pki.ca.certmanager.dao.models.ManageCertDataDO;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.RFC4519StyleUpperCase;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.enums.CertStatusEnum;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.pkcs7.SignedDataInfo;
import com.xdja.pki.ca.core.pkcs7.SignedDataUtil;
import com.xdja.pki.ca.core.util.DnUtil;
import com.xdja.pki.ca.hsm.manager.HsmManager;
import com.xdja.pki.ca.security.bean.Function;
import com.xdja.pki.ca.security.bean.Operator;
import com.xdja.pki.ca.security.util.OperatorUtil;
import com.xdja.pki.ca.securitymanager.dao.AdminRoleDao;
import com.xdja.pki.ca.securitymanager.dao.FunctionDao;
import com.xdja.pki.ca.securitymanager.dao.model.RoleDO;
import com.xdja.pki.ca.securitymanager.service.login.CustomToken;
import com.xdja.pki.ca.securitymanager.service.login.LoginBase;
import com.xdja.pki.ca.securitymanager.service.login.LoginService;
import com.xdja.pki.ca.securitymanager.service.vo.AdminInfoDTO;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.RoleTypeEnum;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.naming.NamingException;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
extends LoginBase
implements LoginService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SESSION_CHALLENGE_KEY = "challenge";
    private static final String KEY_CHALLENGE = "challenge";
    private static final String KEY_EXPIRES = "expires";
    private static final String KEY_FAILURE_TIME = "failureTime";
    @Value(value="${challenge.expires}")
    private long challengeExpires;
    @Value(value="${session.expires}")
    private int sessionTimeout;
    @Value(value="${login.challenge.length}")
    private int challengeLength;
    @Resource
    private ManagerCertDao managerCertDao;
    @Resource
    private ManagerCertDataDao managerCertDataDao;
    @Resource
    private FunctionDao functionDao;
    @Resource
    private AdminRoleDao adminRoleDao;
    @Resource
    private HsmManager hsmManager;
    @Resource
    private AuditLogService auditLogService;
    @Resource
    private Environment env;

    public Map<String, Object> getChallenge() {
        try {
            HashMap<String, String> challengeInfo = (HashMap<String, String>)OperatorUtil.getAttribute((String)"challenge");
            if (null == challengeInfo) {
                challengeInfo = new HashMap<String, String>();
                OperatorUtil.setAttribute((String)"challenge", challengeInfo);
            }
            challengeInfo.put("challenge", this.hsmManager.generateRandom(this.challengeLength));
            challengeInfo.put(KEY_EXPIRES, (String)((Object)Long.valueOf(this.challengeExpires)));
            challengeInfo.put(KEY_FAILURE_TIME, (String)((Object)Long.valueOf(System.currentTimeMillis() + this.challengeExpires * 1000L)));
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("challenge", challengeInfo.get("challenge"));
            result.put(KEY_EXPIRES, challengeInfo.get(KEY_EXPIRES));
            return result;
        }
        catch (Exception e) {
            throw new ServiceException("\u83b7\u53d6\u767b\u5f55\u6311\u6218\u503c\u5931\u8d25", (Throwable)e);
        }
    }

    public Result login(String sign, AuditSignBean bean) {
        try {
            Result result = this.executeLogin(sign, bean);
            if (result.isSuccess()) {
                try {
                    boolean flag = this.auditLogService.saveAuditLog(AuditLogOperatorTypeEnum.SYSTEM_LOGIN.type, result.getAuditContent(), AuditLogResultEnum.SUCCESS.id, bean.getSign());
                    if (!flag) {
                        this.logger.error("\u4fdd\u5b58\u7ba1\u7406\u5458\u767b\u5f55\u7cfb\u7edf\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u4fdd\u5b58\u7ba1\u7406\u5458\u767b\u5f55\u7cfb\u7edf\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new ServiceException("\u7ba1\u7406\u5458\u767b\u5f55\u7cfb\u7edf\u5931\u8d25", (Throwable)e);
        }
    }

    public void logout() {
        try {
            SecurityUtils.getSubject().logout();
        }
        catch (Exception e) {
            throw new ServiceException("\u7ba1\u7406\u5458\u9000\u51fa\u7cfb\u7edf\u5931\u8d25", (Throwable)e);
        }
    }

    private Result executeLogin(String sign, AuditSignBean bean) {
        int degistAlg;
        String sourceContent;
        StringBuilder auditLog = new StringBuilder();
        ManageCertDO manageCert = this.managerCertDao.getManagerCertsBySn(bean.getSn(), bean.getKeyAlg());
        if (null == manageCert) {
            auditLog.append("\u7ba1\u7406\u5458\u767b\u5f55\u7cfb\u7edf\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bc1\u4e66\u4e0d\u5b58\u5728\uff0c\u8bc1\u4e66SN=").append(bean.getSn());
            this.logger.info(auditLog.toString());
            return Result.failure((ErrorEnum)ErrorEnum.DOWNLOAD_CERT_NOT_EXIST).setAuditContent(auditLog.toString());
        }
        if (manageCert.getStatus() != CertStatusEnum.NORMAL.value) {
            auditLog.append("\u7ba1\u7406\u5458\u767b\u5f55\u7cfb\u7edf\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bc1\u4e66\u88ab\u51bb\u7ed3\uff0c\u8bc1\u4e66SN=").append(bean.getSn());
            this.logger.info(auditLog.toString());
            return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_FREEZE).setAuditContent(auditLog.toString());
        }
        if (manageCert.getAfterTime().getTime() < System.currentTimeMillis()) {
            auditLog.append("\u7ba1\u7406\u5458\u767b\u5f55\u7cfb\u7edf\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bc1\u4e66\u5df2\u8fc7\u671f\uff0c\u8bc1\u4e66SN=").append(bean.getSn());
            this.logger.info(auditLog.toString());
            return Result.failure((ErrorEnum)ErrorEnum.CERT_ISSUE_STATUE_EXPIRED).setAuditContent(auditLog.toString());
        }
        RoleDO role = this.adminRoleDao.getRoleByManageCertId(manageCert.getId().longValue());
        if (null == role) {
            auditLog.append("\u7ba1\u7406\u5458\u767b\u5f55\u7cfb\u7edf\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8bc1\u4e66\u65e0\u5bf9\u5e94\u7ba1\u7406\u5458\u89d2\u8272\uff0c\u8bc1\u4e66DN=").append(manageCert.getSubject()).append("\uff0c\u8bc1\u4e66SN=").append(bean.getSn());
            this.logger.info(auditLog.toString());
            return Result.failure((ErrorEnum)ErrorEnum.INVALID_CERT).setAuditContent(auditLog.toString());
        }
        boolean allowLogin = this.auditLogService.isAllowLogin();
        if (!allowLogin && role.getType() != RoleTypeEnum.AUDITOR.value) {
            auditLog.append("\u7ba1\u7406\u5458\u767b\u5f55\u7cfb\u7edf\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5ba1\u8ba1\u65e5\u5fd7\u8d85\u51fa\u6700\u5927\u5b58\u50a8\u6761\u6570\uff0c\u4e0d\u5141\u8bb8\u975e\u5ba1\u8ba1\u5458\u7684\u7ba1\u7406\u5458\u767b\u5f55\uff0c\u8bc1\u4e66DN=").append(manageCert.getSubject()).append("\uff0c\u8bc1\u4e66SN=").append(bean.getSn());
            this.logger.info(auditLog.toString());
            return Result.failure((ErrorEnum)ErrorEnum.MAX_AUDIT_LOG_STORAGE).setAuditContent(auditLog.toString());
        }
        Map result = (Map)OperatorUtil.getAttribute((String)"challenge");
        if (null == result || Long.valueOf(String.valueOf(result.get(KEY_FAILURE_TIME))) < System.currentTimeMillis()) {
            auditLog.append("\u7ba1\u7406\u5458\u767b\u5f55\u7cfb\u7edf\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6311\u6218\u503c\u65e0\u6548\uff0c\u8bc1\u4e66DN=").append(manageCert.getSubject()).append("\uff0c\u8bc1\u4e66SN=").append(bean.getSn()).append("\uff0c\u7ba1\u7406\u5458\u89d2\u8272=").append(role.getName());
            this.logger.info(auditLog.toString());
            return Result.failure((ErrorEnum)ErrorEnum.INVALID_CHALLENGE).setAuditContent(auditLog.toString());
        }
        SignedDataInfo signedData = SignedDataUtil.resolve((String)sign);
        String signContent = new String(signedData.getContent());
        if (!signContent.equals(sourceContent = (String)result.get("challenge"))) {
            auditLog.append("\u7ba1\u7406\u5458\u767b\u5f55\u7cfb\u7edf\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u7b7e\u540d\u539f\u6587\u4e0d\u4e00\u81f4\uff0c\u8bc1\u4e66DN=").append(manageCert.getSubject()).append("\uff0c\u8bc1\u4e66SN=").append(bean.getSn()).append("\uff0c\u7ba1\u7406\u5458\u89d2\u8272=").append(role.getName());
            this.logger.info("\u7ba1\u7406\u5458\u7cfb\u7edf\u767b\u5f55\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u7b7e\u540d\u539f\u6587\u4e0d\u4e00\u81f4  [sn={},keyAlg={},sign={}]", new Object[]{bean.getSn(), bean.getKeyAlg(), sign});
            return Result.failure((ErrorEnum)ErrorEnum.INVALID_CHALLENGE).setAuditContent(auditLog.toString());
        }
        auditLog.append("\u7ba1\u7406\u5458\u767b\u5f55\u7cfb\u7edf\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5\uff0c\u8bc1\u4e66DN=").append(manageCert.getSubject()).append("\uff0c\u8bc1\u4e66SN=").append(bean.getSn()).append("\uff0c\u7ba1\u7406\u5458\u89d2\u8272=").append(role.getName()).append("\uff0cP7\u7b7e\u540d\u7b97\u6cd5=").append(signedData.getSignAlgOId()).append("\uff0cP7\u6458\u8981\u7b97\u6cd5=").append(signedData.getDigestAlgOId()).append("\uff0c\u7cfb\u7edf\u7b7e\u540d\u7b97\u6cd5=").append(KeyAlgEnum.convert((int)Constants.BASE_ALG_TYPE.intValue()).desc);
        if (signedData.getSignAlgOId().equals(GMObjectIdentifiers.sm2sign.getId()) && Constants.BASE_ALG_TYPE == KeyAlgEnum.SM2.value) {
            if (!signedData.getDigestAlgOId().equals(GMObjectIdentifiers.sm3.getId())) {
                this.logger.info(auditLog.toString());
                return Result.failure((ErrorEnum)ErrorEnum.NOT_SUPPORTED_SIGN_ALG).setAuditContent(auditLog.toString());
            }
            degistAlg = DigestAlgEnum.SM3.value;
        } else if (signedData.getSignAlgOId().equals(PKCSObjectIdentifiers.rsaEncryption.getId()) && Constants.BASE_ALG_TYPE == KeyAlgEnum.RSA.value) {
            if (!signedData.getDigestAlgOId().equals(NISTObjectIdentifiers.id_sha256.getId())) {
                this.logger.info(auditLog.toString());
                return Result.failure((ErrorEnum)ErrorEnum.NOT_SUPPORTED_SIGN_ALG).setAuditContent(auditLog.toString());
            }
            degistAlg = DigestAlgEnum.SHA256.value;
        } else if (signedData.getSignAlgOId().equals(X9ObjectIdentifiers.prime256v1.getId()) && Constants.BASE_ALG_TYPE == KeyAlgEnum.NIST.value) {
            if (!signedData.getDigestAlgOId().equals(NISTObjectIdentifiers.id_sha256.getId())) {
                this.logger.info(auditLog.toString());
                return Result.failure((ErrorEnum)ErrorEnum.NOT_SUPPORTED_SIGN_ALG).setAuditContent(auditLog.toString());
            }
            degistAlg = DigestAlgEnum.SHA256.value;
        } else {
            this.logger.info(auditLog.toString());
            return Result.failure((ErrorEnum)ErrorEnum.NOT_SUPPORTED_SIGN_ALG).setAuditContent(auditLog.toString());
        }
        auditLog = new StringBuilder();
        ManageCertDataDO manageCertData = this.managerCertDataDao.queryManagerCertDataById(manageCert.getId());
        PublicKey publicKey = CertUtil.getCertFromStr((String)manageCertData.getData()).getPublicKey();
        if (!this.hsmManager.verifySign(Constants.BASE_ALG_TYPE.intValue(), degistAlg, publicKey, signedData.getContent(), signedData.getSignData())) {
            auditLog.append("\u7ba1\u7406\u5458\u767b\u5f55\u7cfb\u7edf\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6311\u6218\u503c\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bc1\u4e66DN=").append(manageCert.getSubject()).append("\uff0c\u8bc1\u4e66SN=").append(bean.getSn()).append("\uff0c\u7ba1\u7406\u5458\u89d2\u8272=").append(role.getName());
            this.logger.info("\u7ba1\u7406\u5458\u7cfb\u7edf\u767b\u5f55\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6311\u6218\u503c\u9a8c\u7b7e\u5931\u8d25  [sn={},keyAlg={},sign={}]", new Object[]{bean.getSn(), bean.getKeyAlg(), sign});
            return Result.failure((ErrorEnum)ErrorEnum.INVALID_CHALLENGE).setAuditContent(auditLog.toString());
        }
        try {
            Subject subject = SecurityUtils.getSubject();
            subject.login((AuthenticationToken)new CustomToken(bean.getSn(), "111111", bean.getSn()));
            subject.getSession().setTimeout((long)(this.sessionTimeout * 60 * 1000));
        }
        catch (Exception e) {
            auditLog.append("\u7ba1\u7406\u5458\u767b\u5f55\u7cfb\u7edf\u5931\u8d25\uff0c\u539f\u56e0\uff1ashiro\u767b\u5f55\u6821\u9a8c\u5f02\u5e38\uff0c\u8bc1\u4e66DN=").append(manageCert.getSubject()).append("\uff0c\u8bc1\u4e66SN=").append(bean.getSn()).append("\uff0c\u7ba1\u7406\u5458\u89d2\u8272=").append(role.getName());
            this.logger.info("\u7cfb\u7edf\u767b\u5f55\u5931\u8d25\uff0c\u539f\u56e0\uff1ashiro\u767b\u5f55\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
            return Result.failure((ErrorEnum)ErrorEnum.INVALID_CERT).setAuditContent(auditLog.toString());
        }
        AdminInfoDTO adminInfo = new AdminInfoDTO();
        BeanUtils.copyProperties((Object)bean, (Object)adminInfo);
        adminInfo.setSignCertId(manageCert.getId().longValue());
        adminInfo.setDn(manageCert.getSubject());
        adminInfo.setRoleType(role.getType().intValue());
        adminInfo.setRoleName(role.getName());
        adminInfo.setSignCertData(manageCertData.getData());
        Collection<Function> functions = this.convertFunction(this.functionDao.queryAdminFunctions(manageCert.getId().longValue()));
        OperatorUtil.setOperator((Operator)new Operator(adminInfo.getDn(), functions, (Object)adminInfo));
        ArrayList<Function> tempFunctions = new ArrayList<Function>(functions);
        this.filterFunction(tempFunctions);
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("name", role.getName());
        userInfo.put("role", role.getType());
        userInfo.put("sn", manageCert.getSn());
        userInfo.put("caType", ((CaInfoVO)Constants.CA_INFO.get(Constants.BASE_ALG_TYPE)).getType());
        userInfo.put("keyAlg", Constants.BASE_ALG_TYPE);
        HashMap<String, Cloneable> resultInfo = new HashMap<String, Cloneable>();
        resultInfo.put("userInfo", userInfo);
        resultInfo.put("menus", tempFunctions);
        auditLog.append("\u7ba1\u7406\u5458\u767b\u5f55\u7cfb\u7edf\u6210\u529f\uff0c\u8bc1\u4e66DN=").append(manageCert.getSubject()).append("\uff0c\u8bc1\u4e66SN=").append(bean.getSn()).append("\uff0c\u7ba1\u7406\u5458\u89d2\u8272=").append(role.getName());
        this.logger.info(auditLog.toString());
        return Result.success(resultInfo).setAuditContent(auditLog.toString());
    }

    private String getCnByDn(String dn) throws NamingException {
        X500Name x500Name = DnUtil.getRFC4519X500Name((String)dn);
        RDN[] rdns = x500Name.getRDNs(RFC4519StyleUpperCase.cn);
        if (rdns.length > 0) {
            return rdns[rdns.length - 1].getFirst().getValue().toString();
        }
        return "";
    }
}

