/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.service.login;

import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.util.json.JSONException;
import com.xdja.pki.ca.core.util.json.JsonMapper;
import com.xdja.pki.ca.security.bean.AuthenticationInfo;
import com.xdja.pki.ca.security.bean.Function;
import com.xdja.pki.ca.security.service.SecurityService;
import com.xdja.pki.ca.securitymanager.dao.FunctionDao;
import com.xdja.pki.ca.securitymanager.service.login.CustomToken;
import com.xdja.pki.ca.securitymanager.service.login.LoginBase;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.shiro.authc.AuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SecurityServiceImpl
extends LoginBase
implements SecurityService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private FunctionDao functionDao;

    public AuthenticationInfo doAuthen(AuthenticationToken authToken) {
        CustomToken token = (CustomToken)authToken;
        AuthenticationInfo info = new AuthenticationInfo();
        info.setUserName(token.getUsername());
        info.setPassword("111111");
        info.setLocked(false);
        return info;
    }

    public Collection<Function> getFunctions() {
        return this.convertFunction(this.functionDao.queryAllFunctions());
    }

    public Collection<String> getWhiteLink() {
        ArrayList<String> whiteLinks = new ArrayList<String>();
        whiteLinks.add("/v1/login/challenge");
        whiteLinks.add("/v1/login");
        whiteLinks.add("/v1/ra/cert/status/ack");
        whiteLinks.add("/v1/ra/cert/fail/status/ack");
        whiteLinks.add("/v1/init/cert/status/ack");
        whiteLinks.add("/v1/init/cert/fail/status/ack");
        whiteLinks.add("/v1/cert/update/algInfo/**");
        whiteLinks.add("/v1/cert/download");
        whiteLinks.add("/v1/cert/detail");
        whiteLinks.add("/v1/cert/revoke");
        whiteLinks.add("/v1/cert/p10");
        whiteLinks.add("/v1/cert/pem");
        whiteLinks.add("/v1/cert/issue/algInfo/**");
        whiteLinks.add("/v1/init/rootCa/Cert");
        whiteLinks.add("/v1/init/caserver/cert");
        whiteLinks.add("/v1/init/admin/cert");
        whiteLinks.add("/v1/init/admin/cert/unique/**");
        whiteLinks.add("/v1/init/admin/cert/count");
        whiteLinks.add("/v1/init/baseConfig");
        whiteLinks.add("/v1/init/step/**");
        whiteLinks.add("/v1/init/license/**");
        whiteLinks.add("/v1/init/subCa/p10");
        whiteLinks.add("/v1/cert/p10/download/**");
        whiteLinks.add("/v1/init/subCa/certChain");
        whiteLinks.add("/v1/init/step");
        whiteLinks.add("/v1/init/system/recover");
        whiteLinks.add("/v1/init/server/restart");
        whiteLinks.add("/v1/ra/verifyRaBaseDn");
        whiteLinks.add("/v1/init/config/ldap");
        whiteLinks.add("/v1/init/config/crl");
        whiteLinks.add("/v1/init/config/ocsp");
        whiteLinks.add("/v1/init/hsm");
        whiteLinks.add("/v1/init/hsm/status");
        whiteLinks.add("/v1/init/getHsmList");
        whiteLinks.add("/v1/init/p10/download/**");
        whiteLinks.add("/v1/api/**");
        whiteLinks.add("/v1/cmp/**");
        whiteLinks.add("/v1/init/system/recovery");
        whiteLinks.add("/v1/init/system/isRecoveryOver");
        return whiteLinks;
    }

    public String unAuthenticationContent() {
        try {
            return JsonMapper.alwaysMapper().toJson((Object)ErrorEnum.UNAUTHENTICATED.resp(null));
        }
        catch (JSONException e) {
            this.logger.error("\u81ea\u5b9a\u6743\u9650\u6821\u9a8c\u65f6\uff0c\u672a\u767b\u5f55\u6821\u9a8c\u8fd4\u56de\u7ed3\u679c\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return "{\"errCode\":10005,\"errMsg\":\"unauthenticated\"}";
        }
    }

    public String unAuthorizationContent() {
        try {
            return JsonMapper.alwaysMapper().toJson((Object)ErrorEnum.UNAUTHORIZED_REQUEST.resp(null));
        }
        catch (JSONException e) {
            this.logger.error("\u81ea\u5b9a\u6743\u9650\u6821\u9a8c\u65f6\uff0c\u672a\u6388\u6743\u8fd4\u56de\u7ed3\u679c\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return "{\"errCode\":10004,\"errMsg\":\"unauthorized_request\"}";
        }
    }
}

