/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.web.caserver;

import com.xdja.pki.ca.auth.annotation.AuditSign;
import com.xdja.pki.ca.auth.service.bean.AuditSignBean;
import com.xdja.pki.ca.certmanager.service.camanagecert.ICaManageCertService;
import com.xdja.pki.ca.certmanager.service.racert.bean.IssueRaCertVO;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogOperatorTypeEnum;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogResultEnum;
import com.xdja.pki.ca.securityaudit.service.log.AuditLogService;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CaServerContorller {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICaManageCertService caManageCertService;
    @Autowired
    private AuditLogService auditLogService;

    @RequestMapping(value={"/v1/ca/currentServer/cert/detail"}, method={RequestMethod.GET})
    public Object getCurrentCaServer(HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u83b7\u53d6\u5f53\u524dCA\u670d\u52a1\u5668\u7b7e\u540d\u8bc1\u4e66\u8be6\u60c5\u8bf7\u6c42");
        try {
            Result result = this.caManageCertService.getCurrentCaServer();
            this.logger.debug("\u83b7\u53d6\u5f53\u524dCA\u670d\u52a1\u5668\u7b7e\u540d\u8bc1\u4e66\u8be6\u60c5\u8bf7\u6c42\u5b8c\u6210[{}]", (Object)result);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5f53\u524dCA\u670d\u52a1\u5668\u8bc1\u4e66\u7684\u8be6\u60c5\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/ca/currentServer/cert/enc/detail"}, method={RequestMethod.GET})
    public Object getCurrentCaServerEnc(HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u83b7\u53d6\u5f53\u524dCA\u670d\u52a1\u5668\u52a0\u5bc6\u8bc1\u4e66\u8be6\u60c5\u8bf7\u6c42");
        try {
            Result result = this.caManageCertService.getCurrentCaServerEncCert();
            this.logger.debug("\u83b7\u53d6\u5f53\u524dCA\u670d\u52a1\u5668\u52a0\u5bc6\u8bc1\u4e66\u8be6\u60c5\u8bf7\u6c42\u5b8c\u6210[{}]", (Object)result);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5f53\u524dCA\u670d\u52a1\u5668\u8bc1\u4e66\u7684\u8be6\u60c5\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/ca/server/list"}, method={RequestMethod.GET})
    public Object getCaServerCertList(HttpServletResponse resp, Integer pageNo, Integer pageSize) {
        if (null == pageNo || null == pageSize) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            return this.caManageCertService.getCaServerCertList(pageNo, pageSize);
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2CA\u670d\u52a1\u5668\u8bc1\u4e66\u5386\u53f2\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/ca/server"}, method={RequestMethod.PUT})
    public Object updateCaServerCert(HttpServletResponse resp, @RequestBody IssueRaCertVO issueRaCertVO, AuditSignBean bean) {
        this.logger.info("\u6536\u5230CA\u670d\u52a1\u5668\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42[{}]", (Object)issueRaCertVO);
        if (StringUtils.isBlank((CharSequence)issueRaCertVO.getSn()) || issueRaCertVO.isDnUpdate() && StringUtils.isBlank((CharSequence)issueRaCertVO.getCertDn())) {
            this.logger.debug("CA\u670d\u52a1\u5668\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42\u51fa\u73b0\u7a7a\u53c2\u6570[{}]", (Object)issueRaCertVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            int execResult;
            Result result = this.caManageCertService.doUpdateCaServerCert(issueRaCertVO);
            this.logger.info("CA\u670d\u52a1\u5668\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42\u5904\u7406\u7ed3\u675f\uff0cResult[{}]", (Object)result);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("CA\u670d\u52a1\u5668\u8bc1\u4e66\u66f4\u65b0\u6210\u529f,\u65e7\u8bc1\u4e66DN=").append(result.getAuditContent()).append(",\u65e7\u8bc1\u4e66SN=").append(issueRaCertVO.getSn());
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("CA\u670d\u52a1\u5668\u8bc1\u4e66\u66f4\u65b0\u5931\u8d25,\u65e7\u8bc1\u4e66DN=").append(result.getAuditContent()).append(",\u65e7\u8bc1\u4e66SN=").append(issueRaCertVO.getSn());
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_UPDATE.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55CA\u670d\u52a1\u5668\u8bc1\u4e66\u66f4\u65b0\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55CA\u670d\u52a1\u5668\u8bc1\u4e66\u66f4\u65b0\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (result.isSuccess()) {
                return result.getInfo();
            }
            return result.getError().resp(resp);
        }
        catch (Exception e) {
            this.logger.error("\u7b7e\u53d1CA\u670d\u52a1\u5668\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }
}

