/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.web.crosscert;

import com.xdja.pki.ca.auth.annotation.AuditSign;
import com.xdja.pki.ca.auth.service.bean.AuditSignBean;
import com.xdja.pki.ca.certmanager.service.crosscert.ICrossCertManageService;
import com.xdja.pki.ca.certmanager.service.crosscert.bean.CrossCertApplyVO;
import com.xdja.pki.ca.certmanager.service.crosscert.bean.CrossCertQueryVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.CertTypeEnum;
import com.xdja.pki.ca.certmanager.service.subca.ISubCaManageService;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogOperatorTypeEnum;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogResultEnum;
import com.xdja.pki.ca.securityaudit.service.log.AuditLogService;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class CrossCertController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICrossCertManageService crossCertManageService;
    @Autowired
    private ISubCaManageService subCaManageService;
    @Autowired
    private AuditLogService auditLogService;

    @AuditSign
    @RequestMapping(value={"/v1/crossCA/apply/p10"}, method={RequestMethod.GET})
    public Object createCrossCertApplyP10(HttpServletResponse resp, AuditSignBean bean) {
        Result result = null;
        try {
            result = this.crossCertManageService.createCrossCertApplyP10();
            StringBuffer content = new StringBuffer();
            int execResult = result.isSuccess() ? AuditLogResultEnum.SUCCESS.id : AuditLogResultEnum.FAIL.id;
            content.append("\u751f\u6210\u4ea4\u53c9\u8bc1\u4e66\u7533\u8bf7\u4e66" + AuditLogResultEnum.getValueFromId((int)execResult) + ",\u6210\u529f,\u8bc1\u4e66\u89d2\u8272=").append(CertTypeEnum.OUT_CROSS_CERT.desc);
            if (execResult == AuditLogResultEnum.SUCCESS.id) {
                content.append(",\u7533\u8bf7\u4e66\u6587\u4ef6\u540d=").append(result.getAuditContent());
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.P10_GENERATE.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55\u4ea4\u53c9\u8bc1\u4e66\u7b7e\u53d1\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u4ea4\u53c9\u8bc1\u4e66\u7b7e\u53d1\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u4ea4\u53c9\u8bc1\u4e66\u7533\u8bf7\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/crossCA/template/{code}"}, method={RequestMethod.GET})
    public Object getSubCaTemplate(@PathVariable String code, HttpServletResponse resp) {
        Result subCaTemplateInfo = null;
        try {
            subCaTemplateInfo = this.subCaManageService.getTemplateInfo(code);
        }
        catch (ServiceException e) {
            this.logger.error("\u67e5\u8be2\u4ea4\u53c9\u8bc1\u4e66\u6a21\u677f\u4fe1\u606f\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!subCaTemplateInfo.isSuccess()) {
            return subCaTemplateInfo.getError().resp(resp);
        }
        return subCaTemplateInfo.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/crossCA/cert"}, method={RequestMethod.POST})
    public Object issueSubCaCert(@RequestBody CrossCertApplyVO crossCertApplyVO, HttpServletResponse resp, AuditSignBean bean) {
        this.logger.info("\u6536\u5230\u4ea4\u53c9\u8bc1\u4e66\u7b7e\u53d1\u8bf7\u6c42[{}]", (Object)crossCertApplyVO);
        if (null == crossCertApplyVO || StringUtils.isBlank((CharSequence)crossCertApplyVO.getCertDn()) || StringUtils.isBlank((CharSequence)crossCertApplyVO.getP10()) || null == crossCertApplyVO.getValidity() || StringUtils.isBlank((CharSequence)crossCertApplyVO.getTempCode())) {
            this.logger.debug("\u7b7e\u53d1\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25,\u51fa\u73b0\u7a7a\u53c2\u6570[{}]", (Object)crossCertApplyVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        Result result = null;
        try {
            result = this.crossCertManageService.doIssueCrossCert(crossCertApplyVO);
            this.logger.info("\u4ea4\u53c9\u8bc1\u4e66\u7b7e\u53d1\u8bf7\u6c42\u5904\u7406\u5b8c\u6210[{}]", (Object)result);
            StringBuffer content = new StringBuffer();
            int execResult = result.isSuccess() ? AuditLogResultEnum.SUCCESS.id : AuditLogResultEnum.FAIL.id;
            content.append("\u4ea4\u53c9\u8bc1\u4e66\u7b7e\u53d1\u8bc1\u4e66" + AuditLogResultEnum.getValueFromId((int)execResult) + ",\u8bc1\u4e66DN=").append(crossCertApplyVO.getCertDn());
            if (execResult == AuditLogResultEnum.SUCCESS.id) {
                content.append(",\u8bc1\u4e66SN=").append(result.getAuditContent());
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_SIGN.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55\u4ea4\u53c9\u8bc1\u4e66\u7b7e\u53d1\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u4ea4\u53c9\u8bc1\u4e66\u7b7e\u53d1\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (result.isSuccess()) {
                return result.getInfo();
            }
            return result.getError().resp(resp);
        }
        catch (Exception e) {
            this.logger.error("\u7b7e\u53d1\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/crossCA/list"}, method={RequestMethod.GET})
    public Object getCrossCertList(CrossCertQueryVO crossCertQueryVO, HttpServletResponse resp) {
        Result crossCertList = null;
        try {
            crossCertList = this.crossCertManageService.getCrossCertList(crossCertQueryVO);
        }
        catch (ServiceException e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u4ea4\u53c9\u8bc1\u4e66\u5217\u8868\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!crossCertList.isSuccess()) {
            return crossCertList.getError().resp(resp);
        }
        return crossCertList.getInfo();
    }

    @RequestMapping(value={"/v1/outCrossCA/list"}, method={RequestMethod.GET})
    public Object getOutCrossCertList(CrossCertQueryVO crossCertQueryVO, HttpServletResponse resp) {
        Result crossCertList = null;
        try {
            crossCertList = this.crossCertManageService.getOutCrossCertList(crossCertQueryVO);
        }
        catch (ServiceException e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5916\u90e8\u4ea4\u53c9\u8bc1\u4e66\u5217\u8868\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!crossCertList.isSuccess()) {
            return crossCertList.getError().resp(resp);
        }
        return crossCertList.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/outCrossCA/load"}, method={RequestMethod.POST})
    public Object uploadOutCrossCertChain(@RequestParam MultipartFile certChain, HttpServletResponse resp, AuditSignBean bean) {
        this.logger.info("===\u5bfc\u5165\u4ea4\u53c9\u8bc1\u4e66");
        if (null == certChain || certChain.isEmpty() || !certChain.getOriginalFilename().endsWith(".p7b")) {
            this.logger.debug("\u5bfc\u5165\u8bc1\u4e66\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5{}", (Object)certChain);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        Result result = null;
        try {
            byte[] bytes = certChain.getBytes();
            result = this.crossCertManageService.uploadOutCrossCertChain(bytes);
            StringBuffer content = new StringBuffer();
            int execResult = result.isSuccess() ? AuditLogResultEnum.SUCCESS.id : AuditLogResultEnum.FAIL.id;
            content.append("\u5bfc\u5165\u5916\u90e8\u4ea4\u53c9\u8bc1\u4e66" + AuditLogResultEnum.getValueFromId((int)execResult) + ",\u64cd\u4f5c\u8005IP=").append(bean.getIp() + ",\u8bc1\u4e66SN=").append(bean.getSn()).append(",\u5bc6\u94a5\u7b97\u6cd5=").append(bean.getKeyAlg());
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_IMPORT.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55\u5bfc\u5165\u4ea4\u53c9\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u5bfc\u5165\u4ea4\u53c9\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u5165\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25\uff0c", (Throwable)e);
            return ErrorEnum.CROSS_CA_CHAIN_IMPORT_ERROR.resp(resp);
        }
    }
}

