/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.web.operatercert;

import com.xdja.pki.ca.auth.annotation.AuditSign;
import com.xdja.pki.ca.auth.service.bean.AuditSignBean;
import com.xdja.pki.ca.certmanager.service.camanagecert.ICaManageCertService;
import com.xdja.pki.ca.certmanager.service.camanagecert.bean.CaManageCertQueryVO;
import com.xdja.pki.ca.certmanager.service.camanagecert.bean.IssueCaCertReqVO;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogOperatorTypeEnum;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogResultEnum;
import com.xdja.pki.ca.securityaudit.service.log.AuditLogService;
import com.xdja.pki.ca.securitymanager.service.vo.CaManagerRoleEnum;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CaOperaterCertController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICaManageCertService caManageCertService;
    @Autowired
    private AuditLogService auditLogService;

    @RequestMapping(value={"/v1/operaterManager/list"}, method={RequestMethod.GET})
    public Object list(CaManageCertQueryVO caCertquery, HttpServletResponse resp) {
        Result raCertResult = null;
        try {
            caCertquery.setRoleType(Integer.valueOf(CaManagerRoleEnum.BUSINESS_OPERATOR.key));
            raCertResult = this.caManageCertService.getCaManageCertList(caCertquery);
        }
        catch (ServiceException e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2CA\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u5217\u8868\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!raCertResult.isSuccess()) {
            return raCertResult.getError().resp(resp);
        }
        return raCertResult.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/operaterManager"}, method={RequestMethod.POST})
    public Object issueRaAdminCert(HttpServletResponse resp, @RequestBody IssueCaCertReqVO issueCaCertVO, AuditSignBean bean) {
        this.logger.info("\u6536\u5230CA\u4e1a\u52a1\u64cd\u4f5c\u5458\u7b7e\u53d1\u8bf7\u6c42[{}]", (Object)issueCaCertVO);
        if (StringUtils.isBlank((CharSequence)issueCaCertVO.getCertDn()) || StringUtils.isBlank((CharSequence)issueCaCertVO.getSubjectPublicKeyInfo()) || StringUtils.isBlank((CharSequence)issueCaCertVO.getP10()) || null == issueCaCertVO.getValidity() || null == issueCaCertVO) {
            this.logger.debug("\u7b7e\u53d1CA\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u5931\u8d25,\u51fa\u73b0\u7a7a\u53c2\u6570[{}]", (Object)issueCaCertVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            issueCaCertVO.setRoleType(Integer.valueOf(CaManagerRoleEnum.BUSINESS_OPERATOR.key));
            Result result = this.caManageCertService.doIssueCaManagerCert(issueCaCertVO);
            this.logger.info("CA\u4e1a\u52a1\u64cd\u4f5c\u5458\u7b7e\u53d1\u8bf7\u6c42\u5904\u7406\u5b8c\u6210[{}]", (Object)result);
            StringBuffer content = new StringBuffer();
            int execResult = result.isSuccess() ? AuditLogResultEnum.SUCCESS.id : AuditLogResultEnum.FAIL.id;
            content.append("CA\u4e1a\u52a1\u64cd\u4f5c\u5458\u7b7e\u53d1\u8bc1\u4e66" + AuditLogResultEnum.getValueFromId((int)execResult) + ",\u8bc1\u4e66DN=").append(issueCaCertVO.getCertDn());
            if (execResult == AuditLogResultEnum.SUCCESS.id) {
                content.append(",\u8bc1\u4e66SN=").append(result.getAuditContent());
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_SIGN.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55CA\u4e1a\u52a1\u64cd\u4f5c\u5458\u7b7e\u53d1\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55CA\u4e1a\u52a1\u64cd\u4f5c\u5458\u7b7e\u53d1\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (result.isSuccess()) {
                return result.getInfo();
            }
            return result.getError().resp(resp);
        }
        catch (Exception e) {
            this.logger.error("\u7b7e\u53d1CA\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/operaterManager"}, method={RequestMethod.PUT})
    public Object updateRaAdminCert(HttpServletResponse resp, @RequestBody IssueCaCertReqVO issueCaCertVO, AuditSignBean bean) {
        this.logger.info("\u6536\u5230CA\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42[{}]", (Object)issueCaCertVO);
        if (StringUtils.isBlank((CharSequence)issueCaCertVO.getSn()) || issueCaCertVO.isDnUpdate() && StringUtils.isBlank((CharSequence)issueCaCertVO.getCertDn())) {
            this.logger.debug("CA\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42\u51fa\u73b0\u7a7a\u53c2\u6570[{}]", (Object)issueCaCertVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            issueCaCertVO.setRoleType(Integer.valueOf(CaManagerRoleEnum.BUSINESS_OPERATOR.key));
            Result result = this.caManageCertService.doUpdateCaManagerCert(issueCaCertVO);
            this.logger.info("CA\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42\u5904\u7406\u5b8c\u6210\uff0cResult[{}]", (Object)result);
            StringBuffer content = new StringBuffer();
            int execResult = result.isSuccess() ? AuditLogResultEnum.SUCCESS.id : AuditLogResultEnum.FAIL.id;
            content.append("CA\u4e1a\u52a1\u64cd\u4f5c\u5458\u66f4\u65b0\u8bc1\u4e66" + AuditLogResultEnum.getValueFromId((int)execResult) + ",\u65e7\u8bc1\u4e66DN=").append(result.getAuditContent()).append(",\u65e7\u8bc1\u4e66SN=").append(issueCaCertVO.getSn());
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_UPDATE.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55CA\u4e1a\u52a1\u64cd\u4f5c\u5458\u66f4\u65b0\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55CA\u4e1a\u52a1\u64cd\u4f5c\u5458\u66f4\u65b0\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (result.isSuccess()) {
                return result.getInfo();
            }
            return result.getError().resp(resp);
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0CA\u4e1a\u52a1\u64cd\u4f5c\u5458\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }
}

