/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.web.ra;

import com.xdja.pki.ca.auth.annotation.AuditSign;
import com.xdja.pki.ca.auth.service.bean.AuditSignBean;
import com.xdja.pki.ca.certmanager.service.ra.IRAmanagerService;
import com.xdja.pki.ca.certmanager.service.ra.bean.RAListsReqBean;
import com.xdja.pki.ca.certmanager.service.ra.bean.RATemplateSaveReq;
import com.xdja.pki.ca.certmanager.service.ra.bean.RAinfoSaveReq;
import com.xdja.pki.ca.certmanager.service.ra.bean.RAinfoUpdateReq;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogOperatorTypeEnum;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogResultEnum;
import com.xdja.pki.ca.securityaudit.service.log.AuditLogService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RAmanagerController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRAmanagerService RAmanagerService;
    @Autowired
    private AuditLogService auditLogService;

    @RequestMapping(value={"/v1/ra/list"}, method={RequestMethod.GET})
    public Object getRAlistsByName(@RequestParam Integer pageNo, @RequestParam Integer pageSize, @RequestParam String name, HttpServletResponse resp) {
        Result rAlists = null;
        RAListsReqBean raListsReqBean = new RAListsReqBean();
        raListsReqBean.setPageNo(pageNo.intValue());
        raListsReqBean.setPageSize(pageSize.intValue());
        raListsReqBean.setName(name);
        try {
            rAlists = this.RAmanagerService.getRAlistsByName(raListsReqBean);
        }
        catch (ServiceException e) {
            this.logger.error("\u67e5\u8be2RA\u5217\u8868\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        return rAlists.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/ra/info"}, method={RequestMethod.POST})
    public Object savaRAinfoReq(@RequestBody RAinfoSaveReq raInfoReq, HttpServletRequest request, HttpServletResponse resp, AuditSignBean bean) {
        Result result = null;
        try {
            result = this.RAmanagerService.saveRAinfo(raInfoReq);
        }
        catch (ServiceException e) {
            this.logger.error("\u65b0\u589eRA\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuffer content = new StringBuffer();
        int execResult = result.isSuccess() ? AuditLogResultEnum.SUCCESS.id : AuditLogResultEnum.FAIL.id;
        content.append("\u65b0\u589eRA" + AuditLogResultEnum.getValueFromId((int)execResult) + ",RA\u540d\u79f0=").append(raInfoReq.getName()).append(",BaseDN=").append(raInfoReq.getRaBaseDn());
        this.logger.info(content.toString());
        try {
            boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.RA_MANAGER.type, content.toString(), execResult, bean.getSign());
            if (!falg) {
                this.logger.error("\u8bb0\u5f55RA\u7ba1\u7406-\u65b0\u589eRA\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
            }
        }
        catch (Exception e) {
            this.logger.error("\u8bb0\u5f55RA\u7ba1\u7406-\u65b0\u589eRA\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
        if (!result.isSuccess()) {
            return result.getError().resp(resp);
        }
        return null;
    }

    @RequestMapping(value={"/v1/ca/baseDn"}, method={RequestMethod.GET})
    public Object getCAbaseDN(HttpServletResponse resp) {
        Result cAbaseDNResult = null;
        try {
            cAbaseDNResult = this.RAmanagerService.getCAbaseDN();
        }
        catch (ServiceException e) {
            this.logger.error("\u67e5\u8be2CA\u7684BaseDn\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!cAbaseDNResult.isSuccess()) {
            return cAbaseDNResult.getError().resp(resp);
        }
        return cAbaseDNResult.getInfo();
    }

    @RequestMapping(value={"/v1/ra/info/{id}"}, method={RequestMethod.GET})
    public Object getRAinfoById(@PathVariable Long id, HttpServletResponse resp) {
        Result result = null;
        try {
            result = this.RAmanagerService.getRAinfo(id.longValue());
        }
        catch (ServiceException e) {
            this.logger.error("\u67e5\u770bRA\u8be6\u60c5\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.getError().resp(resp);
        }
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/ra/info"}, method={RequestMethod.PUT})
    public Object updateRAinfo(@RequestBody RAinfoUpdateReq rainfoUpdateReq, HttpServletResponse resp, AuditSignBean bean) {
        Result result = null;
        try {
            result = this.RAmanagerService.updateRAinfo(rainfoUpdateReq);
        }
        catch (ServiceException e) {
            this.logger.error("\u66f4\u65b0RA\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuffer content = new StringBuffer();
        int execResult = result.isSuccess() ? AuditLogResultEnum.SUCCESS.id : AuditLogResultEnum.FAIL.id;
        content.append("\u66f4\u65b0RA" + AuditLogResultEnum.getValueFromId((int)execResult) + ",RA\u540d\u79f0=").append(rainfoUpdateReq.getName()).append(",BaseDN=").append(rainfoUpdateReq.getRaBaseDn());
        this.logger.info(content.toString());
        try {
            boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.RA_MANAGER.type, content.toString(), execResult, bean.getSign());
            if (!falg) {
                this.logger.error("\u8bb0\u5f55RA\u7ba1\u7406-\u66f4\u65b0RA\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
            }
        }
        catch (Exception e) {
            this.logger.error("\u8bb0\u5f55RA\u7ba1\u7406-\u66f4\u65b0RA\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
        if (!result.isSuccess()) {
            return result.getError().resp(resp);
        }
        return null;
    }

    @RequestMapping(value={"/v1/ra/template/{id}"}, method={RequestMethod.GET})
    public Object getRATemplateById(@PathVariable Long id, HttpServletResponse resp) {
        Result result = null;
        try {
            result = this.RAmanagerService.getRATemplateById(id.longValue());
        }
        catch (ServiceException e) {
            this.logger.error("\u67e5\u8be2RA\u6388\u6743\u6a21\u677f\u4fe1\u606f\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/ra/template"}, method={RequestMethod.POST})
    public Object saveRATemplates(@RequestBody RATemplateSaveReq raTemplateSaveReq, HttpServletResponse resp, AuditSignBean bean) {
        Result result = null;
        try {
            result = this.RAmanagerService.saveRATemplates(raTemplateSaveReq);
        }
        catch (ServiceException e) {
            this.logger.error("\u4fdd\u5b58RA\u6388\u6743\u6a21\u677f\u4fe1\u606f\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuffer content = new StringBuffer();
        int execResult = result.isSuccess() ? AuditLogResultEnum.SUCCESS.id : AuditLogResultEnum.FAIL.id;
        content.append("\u4fdd\u5b58Ra\u6388\u6743\u6a21\u677f\u4fe1\u606f" + AuditLogResultEnum.getValueFromId((int)execResult) + ",raID=").append(raTemplateSaveReq.getId()).append(",\u6a21\u677fIDs=").append(raTemplateSaveReq.getTemplateIds());
        this.logger.info(content.toString());
        try {
            boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.RA_MANAGER.type, content.toString(), execResult, bean.getSign());
            if (!falg) {
                this.logger.error("\u8bb0\u5f55\u4fdd\u5b58RA\u6388\u6743\u6a21\u677f\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
            }
        }
        catch (Exception e) {
            this.logger.error("\u8bb0\u5f55\u4fdd\u5b58RA\u6388\u6743\u6a21\u677f\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
        if (!result.isSuccess()) {
            return result.getError().resp(resp);
        }
        return null;
    }

    @RequestMapping(value={"/v1/ra/verifyRaBaseDn"}, method={RequestMethod.GET})
    public Object verifyRaBaseDn(@RequestParam String raBaseDn, HttpServletResponse resp) {
        Result result = null;
        try {
            result = this.RAmanagerService.verifyRaBaseDn(raBaseDn);
        }
        catch (ServiceException e) {
            this.logger.error("\u6821\u9a8craBaseDn\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.getError().resp(resp);
        }
        return null;
    }

    @RequestMapping(value={"/v1/ra/baseDn/unique"}, method={RequestMethod.GET})
    public Object verifyRaBaseDn(@RequestParam String baseDn, @RequestParam(value="id", required=false) Integer id, HttpServletResponse resp) {
        Result result = null;
        try {
            result = this.RAmanagerService.verifyRaBaseDn(baseDn, id);
        }
        catch (ServiceException e) {
            this.logger.error("\u6821\u9a8craBaseDn\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.getError().resp(resp);
        }
        return result;
    }

    @RequestMapping(value={"/v1/ra/name/unique"}, method={RequestMethod.GET})
    public Object verifyRaName(@RequestParam String name, @RequestParam(value="id", required=false) Integer id, HttpServletResponse resp) {
        Result result = null;
        try {
            result = this.RAmanagerService.verifyRaName(name, id);
        }
        catch (ServiceException e) {
            this.logger.error("\u6821\u9a8craName\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        return result;
    }

    @RequestMapping(value={"/v1/ra/ip/unique"}, method={RequestMethod.GET})
    public Object verifyRaIp(@RequestParam String ip, @RequestParam(value="id", required=false) Integer id, HttpServletResponse resp) {
        Result result = null;
        try {
            result = this.RAmanagerService.verifyRaIp(ip, id);
        }
        catch (ServiceException e) {
            this.logger.error("\u6821\u9a8craName\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.getError().resp(resp);
        }
        return result;
    }
}

