/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.web.racert;

import com.xdja.pki.ca.auth.annotation.AuditSign;
import com.xdja.pki.ca.auth.service.bean.AuditSignBean;
import com.xdja.pki.ca.certcrl.service.impl.CrlService;
import com.xdja.pki.ca.certmanager.service.kms.KmsService;
import com.xdja.pki.ca.certmanager.service.racert.OpenApiCMPManagerService;
import com.xdja.pki.ca.certmanager.service.racert.OpenApiCMPService;
import com.xdja.pki.ca.certmanager.service.racert.RaManagerCertService;
import com.xdja.pki.ca.certmanager.service.racert.bean.CertDetailQueryVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.CertFileInfo;
import com.xdja.pki.ca.certmanager.service.racert.bean.DownloadCertVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.FreezeCertVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.IssueRaCertVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.RACertQueryVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.RevokeCertVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.UsbKeyAckVO;
import com.xdja.pki.ca.certmanager.service.task.TaskDataService;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.common.Config;
import com.xdja.pki.ca.core.common.ConfigUtil;
import com.xdja.pki.ca.core.common.ErrorBean;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.enums.CertStatusEnum;
import com.xdja.pki.ca.core.enums.KeyAlgEnum;
import com.xdja.pki.ca.core.exception.KMCException;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.SpringUtils;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogOperatorTypeEnum;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogResultEnum;
import com.xdja.pki.ca.securityaudit.service.log.AuditLogService;
import com.xdja.pki.ca.securitymanager.service.init.InitService;
import com.xdja.pki.ca.securitymanager.service.vo.AlgTypeEnum;
import com.xdja.pki.ca.securitymanager.service.vo.CaInfoVO;
import com.xdja.pki.gmssl.core.utils.GMSSLRSAUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSAKeyUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2KeyUtils;
import com.xdja.pki.gmssl.utils.bc.X509CertUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.crmf.CertTemplateBuilder;
import org.bouncycastle.asn1.crmf.OptionalValidity;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RaCertController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RaManagerCertService raManagerCertService;
    @Autowired
    private OpenApiCMPService openApiCMPService;
    @Autowired
    private OpenApiCMPManagerService openApiCMPManagerService;
    @Autowired
    private CrlService crlService;
    @Autowired
    private TaskDataService taskDataService;
    @Autowired
    private AuditLogService auditLogService;
    @Autowired
    private InitService initService;
    @Autowired
    private Environment env;

    @AuditSign
    @RequestMapping(value={"/v1/ra/cert/manager"}, method={RequestMethod.POST})
    public Object issueRaAdminCert(HttpServletResponse resp, @RequestBody IssueRaCertVO issueRaCertVO, AuditSignBean bean) {
        this.logger.info("\u6536\u5230RA\u7ba1\u7406\u5458\u7b7e\u53d1\u8bf7\u6c42[{}]", (Object)issueRaCertVO);
        if (null == issueRaCertVO.getId() || StringUtils.isBlank((CharSequence)issueRaCertVO.getCertDn()) || StringUtils.isBlank((CharSequence)issueRaCertVO.getSubjectPublicKeyInfo()) || null == issueRaCertVO.getCertType() || StringUtils.isBlank((CharSequence)issueRaCertVO.getP10()) || null == issueRaCertVO.getValidity() || null == issueRaCertVO) {
            this.logger.debug("\u7b7e\u53d1RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25,\u51fa\u73b0\u7a7a\u53c2\u6570[{}]", (Object)issueRaCertVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            int execResult;
            Result result = this.raManagerCertService.doIssueRaManagerCert(issueRaCertVO);
            this.logger.info("RA\u7ba1\u7406\u5458\u7b7e\u53d1\u8bf7\u6c42\u5904\u7406\u5b8c\u6210[{}]", (Object)result);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("RA\u7ba1\u7406\u5458\u7b7e\u53d1\u8bc1\u4e66\u6210\u529f,\u8bc1\u4e66DN=").append(issueRaCertVO.getCertDn()).append(",\u8bc1\u4e66SN=").append(result.getAuditContent());
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("RA\u7ba1\u7406\u5458\u7b7e\u53d1\u8bc1\u4e66\u5931\u8d25,\u8bc1\u4e66DN=").append(issueRaCertVO.getCertDn()).append(",\u8bc1\u4e66SN=").append(result.getAuditContent());
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_SIGN.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55RA\u7ba1\u7406\u5458\u7b7e\u53d1\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55RA\u7ba1\u7406\u5458\u7b7e\u53d1\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (result.isSuccess()) {
                return result.getInfo();
            }
            return result.getError().resp(resp);
        }
        catch (Exception e) {
            this.logger.error("\u7b7e\u53d1RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/ra/cert/manager"}, method={RequestMethod.PUT})
    public Object updateRaAdminCert(HttpServletResponse resp, @RequestBody IssueRaCertVO issueRaCertVO, AuditSignBean bean) {
        this.logger.info("\u6536\u5230RA\u7ba1\u7406\u5458\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42[{}]", (Object)issueRaCertVO);
        if (StringUtils.isBlank((CharSequence)issueRaCertVO.getSn()) || issueRaCertVO.isDnUpdate() && StringUtils.isBlank((CharSequence)issueRaCertVO.getCertDn())) {
            this.logger.debug("RA\u7ba1\u7406\u5458\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42\u51fa\u73b0\u7a7a\u53c2\u6570[{}]", (Object)issueRaCertVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            int execResult;
            Result result = this.raManagerCertService.doUpdateRaManagerCert(issueRaCertVO, null, null);
            this.logger.info("RA\u7ba1\u7406\u5458\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42\u5904\u7406\u5b8c\u6210\uff0cResult[{}]", (Object)result);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("RA\u7ba1\u7406\u5458\u66f4\u65b0\u8bc1\u4e66\u6210\u529f,\u65e7\u8bc1\u4e66DN=").append(result.getAuditContent()).append(",\u65e7\u8bc1\u4e66SN=").append(issueRaCertVO.getSn());
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("RA\u7ba1\u7406\u5458\u66f4\u65b0\u8bc1\u4e66\u5931\u8d25,\u65e7\u8bc1\u4e66DN=").append(result.getAuditContent()).append(",\u65e7\u8bc1\u4e66SN=").append(issueRaCertVO.getSn());
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_UPDATE.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55RA\u7ba1\u7406\u5458\u66f4\u65b0\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55RA\u7ba1\u7406\u5458\u66f4\u65b0\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (result.isSuccess()) {
                return result.getInfo();
            }
            return result.getError().resp(resp);
        }
        catch (Exception e) {
            this.logger.error("\u7b7e\u53d1RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/ra/cert/manager"}, method={RequestMethod.DELETE})
    public Object deleteRaAdminCert(HttpServletResponse resp, @RequestBody RevokeCertVO revokeCertVO, AuditSignBean bean) {
        this.logger.info("\u6536\u5230\u7ba1\u7406\u7c7b\u8bc1\u4e66\u64a4\u9500\u8bf7\u6c42[{}]", (Object)revokeCertVO);
        if (StringUtils.isBlank((CharSequence)revokeCertVO.getSn()) || null == revokeCertVO.getRevokeReason()) {
            this.logger.debug("\u64a4\u9500\u8bc1\u4e66\u51fa\u73b0\u975e\u6cd5\u53c2\u6570[{}]", (Object)revokeCertVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        int alg = null == revokeCertVO.getAlg() ? AlgTypeEnum.SM2.value : revokeCertVO.getAlg();
        revokeCertVO.setAlg(Integer.valueOf(alg));
        try {
            int execResult;
            Result result = this.raManagerCertService.deleteRaManagerCert(revokeCertVO);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u64a4\u9500RA\u7ba1\u7406\u5458\u8bc1\u4e66\u6210\u529f,\u8bc1\u4e66DN=").append(result.getAuditContent()).append(",\u8bc1\u4e66SN=").append(revokeCertVO.getSn());
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("\u64a4\u9500\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25,\u8bc1\u4e66DN=").append(result.getAuditContent()).append(",\u8bc1\u4e66SN=").append(revokeCertVO.getSn());
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_REVOKED.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55\u64a4\u9500RA\u7ba1\u7406\u5458\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u64a4\u9500RA\u7ba1\u7406\u5458\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            this.logger.info("\u7ba1\u7406\u7c7b\u8bc1\u4e66\u64a4\u9500\u5904\u7406\u5b8c\u6210[{}]", (Object)revokeCertVO);
            if (result.isSuccess()) {
                return result.getInfo();
            }
            return result.getError().resp(resp);
        }
        catch (Exception e) {
            this.logger.error("\u64a4\u9500\u7ba1\u7406\u7c7b\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/ra/cert/server"}, method={RequestMethod.POST})
    public Object issueRaServerCert(HttpServletResponse resp, @RequestBody IssueRaCertVO issueRaCertVO, AuditSignBean bean) {
        this.logger.info("\u6536\u5230RA\u670d\u52a1\u5668\u8bc1\u4e66\u7b7e\u53d1\u8bf7\u6c42[{}]", (Object)issueRaCertVO);
        if (null == issueRaCertVO.getId() || StringUtils.isBlank((CharSequence)issueRaCertVO.getCertDn()) || StringUtils.isBlank((CharSequence)issueRaCertVO.getSubjectPublicKeyInfo()) || StringUtils.isBlank((CharSequence)issueRaCertVO.getP10()) || null == issueRaCertVO.getValidity() || null == issueRaCertVO || null == issueRaCertVO.getSubjectAlternativeName()) {
            this.logger.debug("\u7b7e\u53d1RA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25[{}]", (Object)issueRaCertVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            int execResult;
            Result result = this.raManagerCertService.doIssueRaServerCert(issueRaCertVO);
            this.logger.info("RA\u670d\u52a1\u5668\u8bc1\u4e66\u7b7e\u53d1\u8bf7\u6c42\u5904\u7406\u5b8c\u6210[{}]", (Object)result);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u7b7e\u53d1RA\u670d\u52a1\u5668\u8bc1\u4e66\u6210\u529f,\u8bc1\u4e66DN=").append(issueRaCertVO.getCertDn()).append(",\u8bc1\u4e66SN=").append(result.getAuditContent());
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("\u7b7e\u53d1RA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25,\u8bc1\u4e66DN=").append(issueRaCertVO.getCertDn()).append(",\u8bc1\u4e66SN=").append(result.getAuditContent());
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_SIGN.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55\u7b7e\u53d1RA\u670d\u52a1\u5668\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u7b7e\u53d1RA\u670d\u52a1\u5668\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (result.isSuccess()) {
                return result.getInfo();
            }
            return result.getError().resp(resp);
        }
        catch (Exception e) {
            this.logger.error("\u7b7e\u53d1RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/ra/cert/status/ack"}, method={RequestMethod.POST})
    public Object verifyPriCertStatus(HttpServletResponse resp, @RequestBody UsbKeyAckVO usbKeyAckVO, AuditSignBean bean, @RequestParam(value="flag", required=false) String flag) {
        this.logger.debug("\u6536\u5230\u7ba1\u7406\u5458\u8bc1\u4e66\u7b7e\u53d1\u5199\u5361\u786e\u8ba4\u6d88\u606f[{}]", (Object)usbKeyAckVO);
        if (StringUtils.isBlank((CharSequence)usbKeyAckVO.getEncCert()) || StringUtils.isBlank((CharSequence)usbKeyAckVO.getSignSn())) {
            this.logger.debug("\u7ba1\u7406\u5458\u8bc1\u4e66\u786e\u8ba4\u51fa\u73b0\u7a7a\u53c2\u6570[{}]", (Object)usbKeyAckVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        String encSn = "";
        try {
            encSn = CertUtil.getSNByCertStr((String)usbKeyAckVO.getEncCert());
        }
        catch (Exception e) {
            this.logger.debug("\u7ba1\u7406\u5458\u52a0\u5bc6\u8bc1\u4e66\u683c\u5f0f\u9519\u8bef[{}]", (Object)usbKeyAckVO);
            return ErrorEnum.CERT_FORMAT_ERROE.resp(resp);
        }
        try {
            int execResult;
            Result result = this.raManagerCertService.doVerifyPriCertStatus(usbKeyAckVO.getSignSn(), encSn);
            this.logger.debug("\u7ba1\u7406\u5458\u8bc1\u4e66\u7b7e\u53d1\u5199\u5361\u786e\u8ba4\u6d88\u606f\u5904\u7406\u5b8c\u6210[{}]", (Object)result);
            StringBuffer content = new StringBuffer();
            String subject = CertUtil.getSubjectByCertStr((String)usbKeyAckVO.getEncCert());
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u7ba1\u7406\u5458\u8bc1\u4e66\u5199\u5361\u6210\u529f\u72b6\u6001\u4e0a\u62a5\u6210\u529f,\u8bc1\u4e66DN=").append(subject).append(",\u8bc1\u4e66SN=").append(usbKeyAckVO.getSignSn());
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("\u7ba1\u7406\u5458\u8bc1\u4e66\u5199\u5361\u6210\u529f\u72b6\u6001\u4e0a\u62a5\u5931\u8d25,\u8bc1\u4e66DN=").append(subject).append(",\u8bc1\u4e66SN=").append(usbKeyAckVO.getSignSn());
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_SIGN.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55\u7ba1\u7406\u5458\u8bc1\u4e66\u5199\u5361\u6210\u529f\u72b6\u6001\u4e0a\u62a5\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u7ba1\u7406\u5458\u8bc1\u4e66\u5199\u5361\u6210\u529f\u72b6\u6001\u4e0a\u62a5\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            if (flag != null) {
                SecurityUtils.getSubject().logout();
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u7ba1\u7406\u5458\u8bc1\u4e66\u7b7e\u53d1\u72b6\u6001\u786e\u8ba4\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/cert/status/ack"}, method={RequestMethod.POST})
    public Object verifyInitPriCertStatus(HttpServletResponse resp, @RequestBody UsbKeyAckVO usbKeyAckVO) {
        this.logger.debug("\u6536\u5230\u7ba1\u7406\u5458\u8bc1\u4e66\u7b7e\u53d1\u5199\u5361\u786e\u8ba4\u6d88\u606f[{}]", (Object)usbKeyAckVO);
        if (StringUtils.isBlank((CharSequence)usbKeyAckVO.getEncCert()) || StringUtils.isBlank((CharSequence)usbKeyAckVO.getSignSn())) {
            this.logger.debug("\u7ba1\u7406\u5458\u8bc1\u4e66\u786e\u8ba4\u51fa\u73b0\u7a7a\u53c2\u6570[{}]", (Object)usbKeyAckVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        String encSn = "";
        try {
            encSn = CertUtil.getSNByCertStr((String)usbKeyAckVO.getEncCert());
        }
        catch (Exception e) {
            this.logger.error("\u7ba1\u7406\u5458\u52a0\u5bc6\u8bc1\u4e66\u683c\u5f0f\u9519\u8bef[{}]", (Object)usbKeyAckVO);
            return ErrorEnum.CERT_FORMAT_ERROE.resp(resp);
        }
        try {
            Result result = this.raManagerCertService.doVerifyPriCertStatus(usbKeyAckVO.getSignSn(), encSn);
            this.logger.debug("\u7ba1\u7406\u5458\u8bc1\u4e66\u7b7e\u53d1\u5199\u5361\u786e\u8ba4\u6d88\u606f\u5904\u7406\u5b8c\u6210[{}]", (Object)result);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u7ba1\u7406\u5458\u8bc1\u4e66\u7b7e\u53d1\u72b6\u6001\u786e\u8ba4\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/ra/cert/fail/status/ack"}, method={RequestMethod.POST})
    public Object verifyPriCertFailStatus(HttpServletResponse resp, @RequestBody UsbKeyAckVO usbKeyAckVO, AuditSignBean bean) {
        this.logger.info("\u6536\u5230\u7ba1\u7406\u5458\u8bc1\u4e66\u5199\u5361\u5931\u8d25\u786e\u8ba4\u6d88\u606f[{}]", (Object)usbKeyAckVO);
        if (StringUtils.isBlank((CharSequence)usbKeyAckVO.getSignSn())) {
            this.logger.debug("\u7ba1\u7406\u5458\u8bc1\u4e66\u5199\u5361\u5931\u8d25\u786e\u8ba4\u6d88\u606f[{}]", (Object)usbKeyAckVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        int alg = null == usbKeyAckVO.getAlg() ? AlgTypeEnum.SM2.value : usbKeyAckVO.getAlg();
        RevokeCertVO revokeCertVO = new RevokeCertVO(usbKeyAckVO.getSignSn(), Integer.valueOf(alg), Integer.valueOf(0));
        revokeCertVO.setRevokeNote("\u8bc1\u4e66\u5199\u5361\u5931\u8d25");
        try {
            int execResult;
            Result result = this.raManagerCertService.deleteNotAckManagerCert(revokeCertVO);
            this.logger.info("\u7ba1\u7406\u5458\u8bc1\u4e66\u5199\u5361\u5931\u8d25\u786e\u8ba4\u6d88\u606f\u5904\u7406\u5b8c\u6210[{}]", (Object)revokeCertVO);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u7ba1\u7406\u5458\u8bc1\u4e66\u5199\u5361\u5931\u8d25\u72b6\u6001\u4e0a\u62a5\u6210\u529f,\u8bc1\u4e66DN=").append(result.getAuditContent()).append(",\u8bc1\u4e66SN=").append(usbKeyAckVO.getSignSn());
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("\u7ba1\u7406\u5458\u8bc1\u4e66\u5199\u5361\u5931\u8d25\u72b6\u6001\u4e0a\u62a5\u5931\u8d25,\u8bc1\u4e66DN=").append(result.getAuditContent()).append(",\u8bc1\u4e66SN=").append(usbKeyAckVO.getSignSn());
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_SIGN.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55\u7ba1\u7406\u5458\u8bc1\u4e66\u5199\u5361\u5931\u8d25\u72b6\u6001\u4e0a\u62a5\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u7ba1\u7406\u5458\u8bc1\u4e66\u5199\u5361\u5931\u8d25\u72b6\u6001\u4e0a\u62a5\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (result.isSuccess()) {
                return result.getInfo();
            }
            return result.getError().resp(resp);
        }
        catch (Exception e) {
            this.logger.error("\u7ba1\u7406\u5458\u8bc1\u4e66\u5199\u5361\u5931\u8d25\u786e\u8ba4\u6d88\u606f\u5904\u7406\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/cert/fail/status/ack"}, method={RequestMethod.POST})
    public Object verifyInitPriCertFailStatus(HttpServletResponse resp, @RequestBody UsbKeyAckVO usbKeyAckVO) {
        this.logger.info("\u6536\u5230\u7ba1\u7406\u5458\u8bc1\u4e66\u5199\u5361\u5931\u8d25\u786e\u8ba4\u6d88\u606f[{}]", (Object)usbKeyAckVO);
        if (StringUtils.isBlank((CharSequence)usbKeyAckVO.getSignSn())) {
            this.logger.debug("\u7ba1\u7406\u5458\u8bc1\u4e66\u5199\u5361\u5931\u8d25\u786e\u8ba4\u6d88\u606f[{}]", (Object)usbKeyAckVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        int alg = null == usbKeyAckVO.getAlg() ? AlgTypeEnum.SM2.value : usbKeyAckVO.getAlg();
        RevokeCertVO revokeCertVO = new RevokeCertVO(usbKeyAckVO.getSignSn(), Integer.valueOf(alg), Integer.valueOf(0));
        try {
            Result result = this.raManagerCertService.deleteNotAckManagerCert(revokeCertVO);
            this.logger.info("\u7ba1\u7406\u5458\u8bc1\u4e66\u5199\u5361\u5931\u8d25\u786e\u8ba4\u6d88\u606f\u5904\u7406\u5b8c\u6210[{}]", (Object)revokeCertVO);
            if (result.isSuccess()) {
                return result.getInfo();
            }
            return result.getError().resp(resp);
        }
        catch (Exception e) {
            this.logger.error("\u7ba1\u7406\u5458\u8bc1\u4e66\u5199\u5361\u5931\u8d25\u786e\u8ba4\u6d88\u606f\u5904\u7406\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/cert/update/algInfo/{signSn}/{alg}"}, method={RequestMethod.GET})
    public Object getCertUpdateBaseInfo(HttpServletResponse resp, @PathVariable String signSn, @PathVariable String alg) {
        try {
            Result result = this.raManagerCertService.getCertUpdateBaseInfo(signSn, alg);
            if (result.isSuccess()) {
                return result.getInfo();
            }
            return result.getError().resp(resp);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u66f4\u65b0\u65f6\u57fa\u672c\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/ra/cert/cmp/test"}, method={RequestMethod.POST})
    public Object cmpTestIssu(HttpServletResponse resp) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        KeyPair keyPair = GMSSLRSAUtils.generateRSAKeyPair((int)2048);
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X500Name x500Name = new X500Name("CN=sushi,O=xdja,C=cn");
        ASN1ObjectIdentifier smAlgorithm = new ASN1ObjectIdentifier("1.2.156.10197.1");
        ASN1ObjectIdentifier SM3withSM2 = smAlgorithm.branch("501");
        CertTemplateBuilder myCertTemplate = new CertTemplateBuilder();
        myCertTemplate.setVersion(1);
        OptionalValidity myOptionalValidity = null;
        Date notBefore = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(notBefore);
        calendar.add(5, 1111);
        Date notAfter = calendar.getTime();
        ASN1EncodableVector optionalValidityV = new ASN1EncodableVector();
        optionalValidityV.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new Time(notBefore)));
        optionalValidityV.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)new Time(notAfter)));
        myOptionalValidity = OptionalValidity.getInstance((Object)new DERSequence(optionalValidityV));
        myCertTemplate.setSigningAlg(new AlgorithmIdentifier(SM3withSM2));
        myCertTemplate.setValidity(myOptionalValidity);
        myCertTemplate.setSubject(new X500Name("CN=syg111,CN=xdja,C=cn"));
        SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        myCertTemplate.setPublicKey(keyInfo);
        Result result = this.openApiCMPService.issueUserCert(publicKey, x500Name, "0001", null, myCertTemplate.build(), Long.valueOf(3L), "1111");
        if (result.isSuccess()) {
            return result.getInfo();
        }
        return result.getError().resp(resp);
    }

    @RequestMapping(value={"/v1/km/pwd/revoke/{encSn}/{alg}"}, method={RequestMethod.GET})
    public Object testKmRevoke(HttpServletResponse resp, @PathVariable String encSn, @PathVariable Integer alg) {
        try {
            CaInfoVO caInfoVO = this.initService.getCaInfo(alg);
            KmsService kmsService = (KmsService)SpringUtils.getBean((String)"kmsXdjaHttpService");
            kmsService.revokeEncKey(caInfoVO, new BigInteger(encSn, 16));
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u66f4\u65b0\u65f6\u57fa\u672c\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/km/pwd/resore/{encSn}/{alg}"}, method={RequestMethod.GET})
    public Object testKmRestore(HttpServletResponse resp, @PathVariable String encSn, @PathVariable Integer alg) {
        try {
            CaInfoVO caInfoVO = this.initService.getCaInfo(alg);
            KmsService kmsService = (KmsService)SpringUtils.getBean((String)"kmsXdjaHttpService");
            KeyPair keyPair = GMSSLRSAKeyUtils.generateKeyPairByBC((int)2048);
            kmsService.restoreEncKey(caInfoVO, new BigInteger(encSn, 16), keyPair.getPublic());
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u66f4\u65b0\u65f6\u57fa\u672c\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/ra/cert/manager/cmp/test"}, method={RequestMethod.POST})
    public Object cmpTestIssuManager(HttpServletResponse resp) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        X500Name x500Name;
        KeyPair keyPair = GMSSLRSAKeyUtils.generateKeyPairByBC((int)2048);
        PublicKey publicKey = keyPair.getPublic();
        Result result = this.openApiCMPManagerService.doIssueManagerCert(publicKey, publicKey, x500Name = new X500Name("CN=sushi,O=xdja,C=CN"), "", "", null, Long.valueOf(1L), "111");
        if (result.isSuccess()) {
            return result.getInfo();
        }
        return result.getError().resp(resp);
    }

    @RequestMapping(value={"/v1/ra/manager/cert/cmp/test/ack"}, method={RequestMethod.POST})
    public Object cmpTesManagertAck(HttpServletResponse resp) {
        this.openApiCMPManagerService.doAckManagerCertStatus("1111");
        return null;
    }

    @RequestMapping(value={"/v1/ra/cert/manager/cmp/test/revoke"}, method={RequestMethod.POST})
    public Object cmpTestManagerRevoke(HttpServletResponse resp, @RequestParam(value="signSn") String signSn) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair keyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        this.openApiCMPManagerService.doRevokeManagerCert(signSn, Integer.valueOf(2), 1, "\u4e0d\u60f3\u73a9\u4e86");
        return null;
    }

    @RequestMapping(value={"/v1/ra/cert/cmp/test/revoke"}, method={RequestMethod.POST})
    public Object cmpTestRevoke(HttpServletResponse resp, @RequestParam(value="signSn") String signSn) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair keyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        return null;
    }

    @RequestMapping(value={"/v1/ra/cert/cmp/test/update"}, method={RequestMethod.POST})
    public Object cmpTestUpdate(HttpServletResponse resp, @RequestParam(value="signSn") String signSn) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        KeyPair keyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X500Name dn = new X500Name("CN=sushi,O=\u516c\u5b89\u90e8,C=CN");
        Date date = new Date();
        return null;
    }

    @RequestMapping(value={"/v1/ra/cert/manager/cmp/test/update"}, method={RequestMethod.POST})
    public Object cmpTestManagerUpdate(HttpServletResponse resp, @RequestParam(value="signSn") String signSn) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        KeyPair keyPair = GMSSLRSAKeyUtils.generateKeyPairByBC((int)2048);
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X500Name dn = new X500Name("CN=sushi,OU=xdja,C=CN");
        Date date = new Date();
        Result result = this.openApiCMPManagerService.doUpdateManagerCert(signSn, Integer.valueOf(2), null, publicKey, publicKey, dn, Long.valueOf(1L), "111");
        if (result.isSuccess()) {
            return result.getInfo();
        }
        return result.getError().resp(resp);
    }

    @RequestMapping(value={"/v1/ra/cert/cmp/test/server"}, method={RequestMethod.POST})
    public Object cmpTestServer(HttpServletResponse resp, @RequestParam(value="signSn") String signSn) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        KeyPair keyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X500Name dn = new X500Name("CN=sushi,O=\u516c\u5b89\u90e8,C=CN");
        this.openApiCMPService.getServerCertInfoBySignSn(signSn, null);
        return null;
    }

    @RequestMapping(value={"/v1/ra/cert/cmp/test/ack"}, method={RequestMethod.POST})
    public Object cmpTestAck(HttpServletResponse resp, @RequestParam(value="signSn") String signSn, @RequestParam(value="encSn") String encSn) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        KeyPair keyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X500Name dn = new X500Name("CN=sushi,O=\u516c\u5b89\u90e8,C=CN");
        this.openApiCMPService.doAckCertIssueStatus("1111");
        return null;
    }

    @RequestMapping(value={"/ca/crl"}, method={RequestMethod.POST})
    public Object caCrlTest(HttpServletResponse resp) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        KeyPair keyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X500Name dn = new X500Name("CN=sushi,O=\u516c\u5b89\u90e8,C=CN");
        this.crlService.doIssueCrl(new Date(), Integer.valueOf(2), false);
        return null;
    }

    @RequestMapping(value={"/ca/drl"}, method={RequestMethod.POST})
    public Object caDrlTest(HttpServletResponse resp) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, KMCException {
        KeyPair keyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X500Name dn = new X500Name("CN=sushi,O=\u516c\u5b89\u90e8,C=CN");
        this.crlService.doIssueCrl(new Date(), Integer.valueOf(2), true);
        return null;
    }

    @RequestMapping(value={"/ca/kms/apply"}, method={RequestMethod.POST})
    public Object caKmsApply(HttpServletResponse resp) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, KMCException {
        Date notbefore;
        KeyPair keyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X500Name dn = new X500Name("CN=sushi,O=\u516c\u5b89\u90e8,C=CN");
        Date notAfter = notbefore = new Date();
        BigInteger encSn = BigInteger.valueOf(10L);
        KmsService kmsService = null;
        Config config = ConfigUtil.getConfigInfo((Environment)this.env);
        int kmSystemType = config.getKmSystemType();
        if (kmSystemType == 1) {
            kmsService = (KmsService)SpringUtils.getBean((String)"kmsSansecService");
        } else if (kmSystemType == 2) {
            kmsService = (KmsService)SpringUtils.getBean((String)"kmsXdjaHttpService");
        }
        kmsService.applyEncKey(null, encSn, publicKey, notbefore, notAfter, dn.toString(), "", "", 256, "", "");
        return null;
    }

    @RequestMapping(value={"/cmp/ra"}, method={RequestMethod.POST})
    public Object cmpRa(HttpServletResponse resp, @RequestParam(value="signSn") String signSn) {
        this.openApiCMPService.getServerCertInfoBySignSn(signSn, Integer.valueOf(2));
        return null;
    }

    @RequestMapping(value={"/v1/ra/cert/publish"}, method={RequestMethod.POST})
    public Object cmpCertpublish(HttpServletResponse resp, @RequestParam(value="signId") Long signId, @RequestParam(value="encId") Long encId, @RequestParam(value="type") Integer type) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        this.taskDataService.savePublishCert(signId, encId, type);
        this.taskDataService.saveSyncStatusCert(signId, encId, type, Integer.valueOf(CertStatusEnum.REVOKE.value), Integer.valueOf(1), new Date());
        return null;
    }

    @RequestMapping(value={"/ca/kms/revoke"}, method={RequestMethod.POST})
    public Object caKmsRevoke(HttpServletResponse resp) throws Exception {
        Date notbefore;
        KeyPair keyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X500Name dn = new X500Name("CN=sushi,O=\u516c\u5b89\u90e8,C=CN");
        Date notAfter = notbefore = new Date();
        CaInfoVO caInfoVO = this.initService.getCaInfo(Integer.valueOf(2));
        BigInteger encSn = BigInteger.valueOf(1L);
        KmsService kmsService = null;
        Config config = ConfigUtil.getConfigInfo((Environment)this.env);
        int kmSystemType = config.getKmSystemType();
        if (kmSystemType == 1) {
            kmsService = (KmsService)SpringUtils.getBean((String)"kmsSansecService");
        } else if (kmSystemType == 2) {
            kmsService = (KmsService)SpringUtils.getBean((String)"kmsXdjaHttpService");
        }
        kmsService.revokeEncKey(caInfoVO, encSn);
        return null;
    }

    @RequestMapping(value={"/ca/kms/restore"}, method={RequestMethod.POST})
    public Object caKmsRestore(HttpServletResponse resp) throws Exception {
        Date notbefore;
        KeyPair keyPair = GMSSLSM2KeyUtils.generateSM2KeyPairByBC();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X500Name dn = new X500Name("CN=sushi,O=\u516c\u5b89\u90e8,C=CN");
        Date notAfter = notbefore = new Date();
        BigInteger encSn = BigInteger.valueOf(1L);
        CaInfoVO caInfoVO = this.initService.getCaInfo(Integer.valueOf(2));
        KmsService kmsService = null;
        Config config = ConfigUtil.getConfigInfo((Environment)this.env);
        int kmSystemType = config.getKmSystemType();
        if (kmSystemType == 1) {
            kmsService = (KmsService)SpringUtils.getBean((String)"kmsSansecService");
        } else if (kmSystemType == 2) {
            kmsService = (KmsService)SpringUtils.getBean((String)"kmsXdjaHttpService");
        }
        kmsService.restoreEncKey(caInfoVO, encSn, publicKey);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditSign
    @RequestMapping(value={"/v1/cert/download"}, method={RequestMethod.GET})
    public Object downloadCert(HttpServletResponse resp, AuditSignBean bean, @Valid DownloadCertVO req, BindingResult bindResult) {
        if (bindResult.hasErrors()) {
            if (this.logger.isDebugEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u4e0b\u8f7d\u8bc1\u4e66\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
                }
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        OutputStream out = null;
        try {
            Result result = this.raManagerCertService.downloadCert(req);
            if (!result.isSuccess()) {
                this.saveDownloadCertAuditLog(result.getAuditContent(), bean.getSign(), false);
                ErrorBean item = result.getError().resp(resp);
                return item;
            }
            CertFileInfo file = (CertFileInfo)result.getInfo();
            resp.setHeader("Content-Disposition", "attachment; filename=" + file.getFileName());
            resp.addHeader("Content-Length", String.valueOf(file.getData().length));
            resp.setContentType("application/octet-stream;charset=UTF-8");
            out = resp.getOutputStream();
            out.write(file.getData());
            out.flush();
            this.logger.info(result.getAuditContent());
            this.saveDownloadCertAuditLog(result.getAuditContent(), bean.getSign(), true);
            Object e = null;
            return e;
        }
        catch (Exception e) {
            this.logger.error("\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            ErrorBean errorBean = ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
            return errorBean;
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.logger.error("\u4e0b\u8f7d\u6587\u4ef6\u65f6\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    @RequestMapping(value={"/v1/cert/root/sn"}, method={RequestMethod.GET})
    public Object getRootCaCert(@RequestParam int keyAlg, HttpServletResponse resp) {
        if (!KeyAlgEnum.contain((int)keyAlg)) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        Result result = null;
        try {
            result = this.raManagerCertService.getRootCaCertSn(keyAlg);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6839\u8bc1\u4e66SN\u5931\u8d25", (Throwable)e);
        }
        return result;
    }

    private void saveDownloadCertAuditLog(String auditContent, String sign, boolean result) {
        int operatorResult = result ? AuditLogResultEnum.SUCCESS.id : AuditLogResultEnum.FAIL.id;
        int operatorType = AuditLogOperatorTypeEnum.CERT_DOWNLOAD.type;
        try {
            boolean flag = this.auditLogService.save(operatorType, auditContent, operatorResult, sign);
            if (!flag) {
                this.logger.error("\u4fdd\u5b58\u4e0b\u8f7d\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
            }
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u4e0b\u8f7d\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
    }

    @RequestMapping(value={"/v1/cert/detail"}, method={RequestMethod.GET})
    public Object getCertDetail(CertDetailQueryVO certDetailQueryVO, HttpServletResponse resp) {
        if (StringUtils.isBlank((CharSequence)certDetailQueryVO.getSn()) || null == certDetailQueryVO.getType()) {
            this.logger.debug("\u67e5\u8be2\u8bc1\u4e66\u8be6\u60c5\u53c2\u6570\u4e3a\u7a7a[{}]", (Object)certDetailQueryVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        Result result = null;
        try {
            result = this.raManagerCertService.getCertDetail(certDetailQueryVO.getSn(), certDetailQueryVO.getType());
        }
        catch (ServiceException e) {
            this.logger.error("\u67e5\u8be2\u8bc1\u4e66\u8be6\u60c5\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.getError().resp(resp);
        }
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/ra/cert/list"}, method={RequestMethod.GET})
    public Object list(RACertQueryVO raCertquery, HttpServletResponse resp) {
        Result raCertResult = null;
        try {
            raCertResult = this.raManagerCertService.getRACertList(raCertquery);
        }
        catch (ServiceException e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2RA\u8bc1\u4e66\u5217\u8868\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!raCertResult.isSuccess()) {
            return raCertResult.getError().resp(resp);
        }
        return raCertResult.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/cert/revoke"}, method={RequestMethod.DELETE})
    public Object revokeCert(HttpServletResponse resp, @RequestBody RevokeCertVO revokeCertVO, AuditSignBean bean) {
        this.logger.info("\u6536\u5230\u8bc1\u4e66\u64a4\u9500\u8bf7\u6c42[{}]", (Object)revokeCertVO);
        if (StringUtils.isBlank((CharSequence)revokeCertVO.getSn()) || null == revokeCertVO.getRevokeReason() || null == revokeCertVO.getType()) {
            this.logger.debug("\u64a4\u9500\u8bc1\u4e66\u51fa\u73b0\u975e\u6cd5\u53c2\u6570[{}]", (Object)revokeCertVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            int execResult;
            Result result = this.raManagerCertService.doRevokeCert(revokeCertVO);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u8bc1\u4e66\u64a4\u9500\u6210\u529f,\u8bc1\u4e66DN=").append(result.getAuditContent()).append(",\u8bc1\u4e66SN=").append(revokeCertVO.getSn()).append(",\u64a4\u9500\u539f\u56e0=").append(revokeCertVO.getRevokeReason()).append(",\u64a4\u9500\u7406\u7531=").append(revokeCertVO.getRevokeNote()).append(",\u64a4\u9500\u8bc1\u4e66\u7c7b\u578b=").append(revokeCertVO.getType());
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("\u8bc1\u4e66\u64a4\u9500\u5931\u8d25,\u8bc1\u4e66DN=").append(result.getAuditContent()).append(",\u8bc1\u4e66SN=").append(revokeCertVO.getSn()).append(revokeCertVO.getRevokeReason()).append(",\u64a4\u9500\u7406\u7531=").append(revokeCertVO.getRevokeNote()).append(",\u64a4\u9500\u8bc1\u4e66\u7c7b\u578b=").append(revokeCertVO.getType());
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_REVOKED.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55\u8bc1\u4e66\u64a4\u9500\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u8bc1\u4e66\u64a4\u9500\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u64a4\u9500\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/cert/freeze"}, method={RequestMethod.DELETE})
    public Object freezeCert(HttpServletResponse resp, @RequestBody @Valid FreezeCertVO freezeCertVO, AuditSignBean bean, BindingResult bindingResult) {
        this.logger.info("\u6536\u5230\u8bc1\u4e66\u51bb\u7ed3\u8bf7\u6c42\u8bf7\u6c42[{}]", (Object)freezeCertVO);
        if (bindingResult.hasErrors()) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            int execResult;
            Result result = this.raManagerCertService.doFreezeCert(freezeCertVO);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u8bc1\u4e66\u51bb\u7ed3\u6210\u529f,\u8bc1\u4e66DN=").append(result.getAuditContent()).append(",\u8bc1\u4e66SN=").append(freezeCertVO.getSn()).append(",\u51bb\u7ed3\u539f\u56e0=").append(freezeCertVO.getFreezeNote());
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("\u8bc1\u4e66\u51bb\u7ed3\u5931\u8d25,\u8bc1\u4e66DN=").append(result.getAuditContent()).append(",\u8bc1\u4e66SN=").append(freezeCertVO.getSn()).append(freezeCertVO.getFreezeNote());
            }
            this.logger.info(content.toString());
            try {
                boolean flag = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_REEZE.type, content.toString(), execResult, bean.getSign());
                if (!flag) {
                    this.logger.error("\u8bb0\u5f55\u8bc1\u4e66\u51bb\u7ed3\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u8bc1\u4e66\u51bb\u7ed3\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u51bb\u7ed3\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/cert/unfreeze"}, method={RequestMethod.DELETE})
    public Object unFreezeCert(HttpServletResponse resp, @RequestBody @Valid FreezeCertVO freezeCertVO, AuditSignBean bean, BindingResult bindingResult) {
        this.logger.info("\u6536\u5230\u8bc1\u4e66\u89e3\u51bb\u8bf7\u6c42\u8bf7\u6c42[{}]", (Object)freezeCertVO);
        if (bindingResult.hasErrors()) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            int execResult;
            Result result = this.raManagerCertService.doUnFreezeCert(freezeCertVO);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u8bc1\u4e66\u89e3\u51bb\u6210\u529f,\u8bc1\u4e66DN=").append(result.getAuditContent()).append(",\u8bc1\u4e66SN=").append(freezeCertVO.getSn()).append(",\u89e3\u51bb\u539f\u56e0=").append(freezeCertVO.getFreezeNote()).append(",\u89e3\u51bb\u7406\u7531=").append(freezeCertVO.getFreezeNote()).append(",\u89e3\u51bb\u8bc1\u4e66\u7c7b\u578b=").append(freezeCertVO.getType());
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("\u8bc1\u4e66\u89e3\u51bb\u5931\u8d25,\u8bc1\u4e66DN=").append(result.getAuditContent()).append(",\u8bc1\u4e66SN=").append(freezeCertVO.getSn()).append(freezeCertVO.getFreezeNote()).append(",\u89e3\u51bb\u7406\u7531=").append(freezeCertVO.getFreezeNote()).append(",\u89e3\u51bb\u8bc1\u4e66\u7c7b\u578b=").append(freezeCertVO.getType());
            }
            this.logger.info(content.toString());
            try {
                boolean flag = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_UNFREEZE.type, content.toString(), execResult, bean.getSign());
                if (!flag) {
                    this.logger.error("\u8bb0\u5f55\u8bc1\u4e66\u89e3\u51bb\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u8bc1\u4e66\u89e3\u51bb\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u51bb\u7ed3\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/ra/cert/cmp/test/recovery"}, method={RequestMethod.POST})
    public Object cmpTestRecovery(HttpServletResponse resp, @RequestParam(value="signSn") String signSn) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        KeyPair keyPair = X509CertUtils.generateSM2KeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X500Name dn = new X500Name("CN=syg,CN=AA,C=cn");
        Date date = new Date();
        ASN1ObjectIdentifier smAlgorithm = new ASN1ObjectIdentifier("1.2.156.10197.1");
        ASN1ObjectIdentifier SM3withSM2 = smAlgorithm.branch("501");
        CertTemplateBuilder myCertTemplate = new CertTemplateBuilder();
        myCertTemplate.setVersion(1);
        OptionalValidity myOptionalValidity = null;
        Date notBefore = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(notBefore);
        calendar.add(5, 1111);
        Date notAfter = calendar.getTime();
        ASN1EncodableVector optionalValidityV = new ASN1EncodableVector();
        optionalValidityV.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new Time(notBefore)));
        optionalValidityV.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)new Time(notAfter)));
        myOptionalValidity = OptionalValidity.getInstance((Object)new DERSequence(optionalValidityV));
        myCertTemplate.setSigningAlg(new AlgorithmIdentifier(SM3withSM2));
        myCertTemplate.setValidity(myOptionalValidity);
        myCertTemplate.setSubject(new X500Name("CN=syg111,CN=AA,C=cn"));
        SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        myCertTemplate.setPublicKey(keyInfo);
        Result result = this.openApiCMPService.doRecoveryUserDoubleCert(signSn, Integer.valueOf(2), publicKey, dn, Long.valueOf(3L), "1111");
        if (result.isSuccess()) {
            return result.getInfo();
        }
        return result.getError().resp(resp);
    }
}

