/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.web.subSystem;

import com.xdja.pki.ca.auth.annotation.AuditSign;
import com.xdja.pki.ca.auth.service.bean.AuditSignBean;
import com.xdja.pki.ca.certmanager.service.racert.RaManagerCertService;
import com.xdja.pki.ca.certmanager.service.racert.bean.RevokeCertVO;
import com.xdja.pki.ca.certmanager.service.subsystem.SubSystemService;
import com.xdja.pki.ca.certmanager.service.subsystem.bean.SubSystemCertVO;
import com.xdja.pki.ca.certmanager.service.subsystem.bean.SubSystemVO;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.ca.util.gm.cert.CertUtil;
import com.xdja.pki.ca.core.common.ErrorBean;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.enums.CertStatusEnum;
import com.xdja.pki.ca.core.enums.DeviceTypeEnum;
import com.xdja.pki.ca.core.util.CertUtils;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogOperatorTypeEnum;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogResultEnum;
import com.xdja.pki.ca.securityaudit.service.log.AuditLogService;
import com.xdja.pki.ca.securitymanager.service.vo.InitAlgInfoVO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class SubSystemController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SubSystemService subSystemService;
    @Autowired
    private RaManagerCertService raManagerCertService;
    @Autowired
    private AuditLogService auditLogService;

    @RequestMapping(value={"/v1/subSystem/cert/list"}, method={RequestMethod.GET})
    public Object getSubSystemList(SubSystemVO subSystemVO, HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u83b7\u53d6CA\u5b50\u7cfb\u7edf\u5217\u8868\u8bf7\u6c42[{}]", (Object)subSystemVO);
        if (null == subSystemVO || null != subSystemVO.getStatus() && StringUtils.isBlank((CharSequence)CertStatusEnum.getCertStatus((int)subSystemVO.getStatus())) || null != subSystemVO.getDeviceType() && StringUtils.isBlank((CharSequence)DeviceTypeEnum.getDeviceType((int)subSystemVO.getDeviceType()))) {
            this.logger.debug("\u5206\u9875\u67e5\u8be2CA\u5b50\u7cfb\u7edf\u5217\u8868\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}]", (Object)subSystemVO);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            return this.subSystemService.getSubSystemList(subSystemVO);
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2CA\u5b50\u7cfb\u7edf\u6570\u636e\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/ca/subSystem/cert"}, method={RequestMethod.POST})
    public Object issueSubSystemCert(@RequestBody @Valid SubSystemCertVO subSystemCertVO, HttpServletResponse resp, AuditSignBean bean, BindingResult bindingResult) {
        this.logger.info("\u6536\u5230CA\u5b50\u7cfb\u7edf\u8bc1\u4e66\u7b7e\u53d1\u8bf7\u6c42[{}]", (Object)subSystemCertVO);
        if (bindingResult.hasErrors()) {
            this.logger.debug("\u7b7e\u53d1CA\u5b50\u7cfb\u7edf\u8bc1\u4e66\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}]", (Object)subSystemCertVO);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            int execResult;
            Result result = (Result)this.subSystemService.doIssueSubSystemCert(subSystemCertVO);
            this.logger.info("CA\u5b50\u7cfb\u7edf\u8bc1\u4e66\u7b7e\u53d1\u8bf7\u6c42\u5904\u7406\u5b8c\u6210[{}]", (Object)result);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("CA\u5b50\u7cfb\u7edf\u8bc1\u4e66\u7b7e\u53d1\u6210\u529f,\u8bc1\u4e66DN=").append(subSystemCertVO.getDn()).append(",\u8bc1\u4e66SN=").append(result.getAuditContent()).append(",\u8bc1\u4e66\u7c7b\u578b=").append(DeviceTypeEnum.getDeviceType((int)subSystemCertVO.getDeviceType()));
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("CA\u5b50\u7cfb\u7edf\u8bc1\u4e66\u7b7e\u53d1\u5931\u8d25,\u8bc1\u4e66DN=").append(subSystemCertVO.getDn()).append(",\u8bc1\u4e66SN=").append(result.getAuditContent()).append(",\u8bc1\u4e66\u7c7b\u578b=").append(DeviceTypeEnum.getDeviceType((int)subSystemCertVO.getDeviceType()));
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_SIGN.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55CA\u5b50\u7cfb\u7edf\u8bc1\u4e66\u7b7e\u53d1\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55CA\u5b50\u7cfb\u7edf\u8bc1\u4e66\u7b7e\u53d1\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (result.isSuccess()) {
                return result.getInfo();
            }
            return result.getError().resp(resp);
        }
        catch (Exception e) {
            this.logger.error("\u7b7e\u53d1CA\u5b50\u7cfb\u7edf\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @RequestMapping(value={"/v1/cert/p10"}, method={RequestMethod.POST})
    public Object uploadP10(HttpServletResponse resp, @RequestParam(value="p10") MultipartFile p10) {
        if (0L == p10.getSize()) {
            this.logger.debug("p10\u6587\u4ef6\u4e3a\u7a7a");
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        BufferedReader br = null;
        InputStream in = null;
        try {
            in = p10.getInputStream();
            br = new BufferedReader(new InputStreamReader(in));
            try {
                CertUtil.getPublicKeyFromP10((String)new String(p10.getBytes()));
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("p10", new String(p10.getBytes()));
                resultMap.put("dn", CertUtil.getDnFromP10((String)new String(p10.getBytes())));
                HashMap<String, Object> hashMap = resultMap;
                return hashMap;
            }
            catch (Exception e) {
                ErrorBean errorBean;
                block28: {
                    this.logger.error("p10\u683c\u5f0f\u9519\u8bef\uff0c\u89e3\u6790\u516c\u94a5\u5931\u8d25", (Throwable)e);
                    errorBean = ErrorEnum.P10_FORMAT_ERROR.resp(resp);
                    if (null == in) break block28;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (null != br) {
                    try {
                        br.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
                return errorBean;
                catch (Exception e4) {
                    this.logger.error("\u89e3\u6790P10\u5931\u8d25", (Throwable)e4);
                    ErrorBean errorBean2 = ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
                    return errorBean2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/v1/cert/pem"}, method={RequestMethod.POST})
    public Object uploadPem(HttpServletResponse resp, @RequestParam(value="pem") MultipartFile pem) {
        if (0L == pem.getSize()) {
            this.logger.debug("pem\u6587\u4ef6\u4e3a\u7a7a");
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        BufferedReader br = null;
        InputStream in = null;
        StringBuffer stringBuffer = new StringBuffer();
        String str = null;
        try {
            in = pem.getInputStream();
            br = new BufferedReader(new InputStreamReader(in));
            while ((str = br.readLine()) != null) {
                stringBuffer.append(str);
            }
            CertUtil.getPublicKeyBySubjectKeyInfo((Integer)Constants.BASE_ALG_TYPE, (String)stringBuffer.toString());
            str = CertUtils.removePemTag((String)stringBuffer.toString());
            this.logger.debug("pem\u89e3\u6790\u7ed3\u679c\uff1a" + str);
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("subjectPublicKeyInfo", str);
            HashMap<String, String> hashMap = resultMap;
            return hashMap;
        }
        catch (Exception e) {
            this.logger.error(String.format("\u52a0\u5bc6\u516c\u94a5\u683c\u5f0f\u9519\u8bef\uff0c\u89e3\u6790\u516c\u94a5\u5931\u8d25%s", stringBuffer.toString()), (Throwable)e);
            ErrorBean errorBean = ErrorEnum.PEM_FORMAT_ERROR.resp(resp);
            return errorBean;
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @RequestMapping(value={"/v1/cert/issue/algInfo/{type}"}, method={RequestMethod.GET})
    public Object getCertIssueAlgInfo(HttpServletResponse resp, @PathVariable Integer type) {
        this.logger.info("\u6536\u5230\u83b7\u53d6\u8bc1\u4e66\u7b7e\u53d1\u65f6\u7b97\u6cd5\u57fa\u672c\u4fe1\u606f\u8bf7\u6c42[{}]", (Object)type);
        try {
            InitAlgInfoVO initAlgInfoVO = this.subSystemService.getCertIssueAlgInfo(type);
            this.logger.info("\u83b7\u53d6\u8bc1\u4e66\u7b7e\u53d1\u65f6\u7b97\u6cd5\u57fa\u672c\u4fe1\u606f\u8bf7\u6c42\u5904\u7406\u6210\u529f[{}]", (Object)initAlgInfoVO);
            return initAlgInfoVO;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u7b7e\u53d1\u65f6\u7b97\u6cd5\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/ca/subSystem/cert"}, method={RequestMethod.DELETE})
    public Object deleteRaAdminCert(HttpServletResponse resp, @RequestBody RevokeCertVO revokeCertVO, AuditSignBean bean) {
        this.logger.info("\u6536\u5230CA\u5b50\u7cfb\u7edf\u8bc1\u4e66\u64a4\u9500\u8bf7\u6c42[{}]", (Object)revokeCertVO);
        if (StringUtils.isBlank((CharSequence)revokeCertVO.getSn()) || null == revokeCertVO.getAlg() || null == revokeCertVO.getRevokeReason()) {
            this.logger.debug("\u64a4\u9500\u8bc1\u4e66\u51fa\u73b0\u975e\u6cd5\u53c2\u6570[{}]", (Object)revokeCertVO);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            int execResult;
            Result result = this.raManagerCertService.deleteRaManagerCert(revokeCertVO);
            this.logger.info("CA\u5b50\u7cfb\u7edf\u8bc1\u4e66\u64a4\u9500\u8bf7\u6c42\u5904\u7406\u5b8c\u6210[{}]", (Object)result);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u64a4\u9500CA\u5b50\u7cfb\u7edf\u8bc1\u4e66\u6210\u529f,\u8bc1\u4e66DN=").append(result.getAuditContent()).append(",\u8bc1\u4e66SN=").append(revokeCertVO.getSn()).append(",\u64a4\u9500\u539f\u56e0=").append(revokeCertVO.getRevokeReason()).append(",\u64a4\u9500\u7406\u7531=").append(revokeCertVO.getRevokeNote());
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("\u64a4\u9500CA\u5b50\u7cfb\u7edf\u8bc1\u4e66\u5931\u8d25,\u8bc1\u4e66DN=").append(result.getAuditContent()).append(",\u8bc1\u4e66SN=").append(revokeCertVO.getSn()).append(",\u64a4\u9500\u539f\u56e0=").append(revokeCertVO.getRevokeReason()).append(",\u64a4\u9500\u7406\u7531=").append(revokeCertVO.getRevokeNote());
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_REVOKED.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55\u64a4\u9500CA\u5b50\u7cfb\u7edf\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u64a4\u9500CA\u5b50\u7cfb\u7edf\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (result.isSuccess()) {
                return result.getInfo();
            }
            return result.getError().resp(resp);
        }
        catch (Exception e) {
            this.logger.error("\u7b7e\u53d1RA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }
}

