/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.web.subca;

import com.xdja.pki.ca.auth.annotation.AuditSign;
import com.xdja.pki.ca.auth.service.bean.AuditSignBean;
import com.xdja.pki.ca.certmanager.service.subca.ISubCaManageService;
import com.xdja.pki.ca.certmanager.service.subca.bean.IssueSubCaCertVO;
import com.xdja.pki.ca.certmanager.service.subca.bean.SubCaCertQueryVO;
import com.xdja.pki.ca.certmanager.service.subca.bean.SubCaInfoVO;
import com.xdja.pki.ca.certmanager.service.subca.bean.SubCaManageQueryVO;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogOperatorTypeEnum;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogResultEnum;
import com.xdja.pki.ca.securityaudit.service.log.AuditLogService;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SubCaManagerController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubCaManageService subCaManageService;
    @Autowired
    private AuditLogService auditLogService;

    @RequestMapping(value={"/v1/subCa/list"}, method={RequestMethod.GET})
    public Object getRAlistsByName(SubCaManageQueryVO subCaManageQueryVO, HttpServletResponse resp) {
        Result result = null;
        try {
            result = this.subCaManageService.getSubCaManageList(subCaManageQueryVO);
        }
        catch (ServiceException e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u4e0b\u7ea7CA\u673a\u6784\u5217\u8868\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.getError().resp(resp);
        }
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/subCa/info/{id}"}, method={RequestMethod.GET})
    public Object getsubCaInfoById(@PathVariable Long id, HttpServletResponse resp) {
        Result result = null;
        try {
            result = this.subCaManageService.getSubCaInfo(id);
        }
        catch (ServiceException e) {
            this.logger.error("\u67e5\u770bRA\u8be6\u60c5\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.getError().resp(resp);
        }
        return result.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/subCa/info"}, method={RequestMethod.POST})
    public Object saveSubCaInfo(@RequestBody SubCaInfoVO subCaInfoVO, HttpServletResponse resp, AuditSignBean bean) {
        if (StringUtils.isBlank((CharSequence)subCaInfoVO.getName()) || StringUtils.isBlank((CharSequence)subCaInfoVO.getOrgName()) || StringUtils.isBlank((CharSequence)subCaInfoVO.getContacts()) || StringUtils.isBlank((CharSequence)subCaInfoVO.getMobile()) || StringUtils.isBlank((CharSequence)subCaInfoVO.getEmail())) {
            this.logger.debug("\u65b0\u589e\u4e0b\u7ea7CA\u673a\u6784\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}]", (Object)subCaInfoVO);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        Result result = null;
        try {
            result = this.subCaManageService.saveSubCaInfo(subCaInfoVO);
            StringBuffer content = new StringBuffer();
            int execResult = result.isSuccess() ? AuditLogResultEnum.SUCCESS.id : AuditLogResultEnum.FAIL.id;
            content.append("\u65b0\u589e\u4e0b\u7ea7CA" + AuditLogResultEnum.getValueFromId((int)execResult) + ",\u4e0b\u7ea7CA\u540d\u79f0=").append(subCaInfoVO.getName());
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.SUB_CA_MANAGER.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55\u4e0b\u7ea7CA\u7ba1\u7406-\u65b0\u589e\u4e0b\u7ea7CA\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u4e0b\u7ea7CA\u7ba1\u7406-\u65b0\u589e\u4e0b\u7ea7CA\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return null;
        }
        catch (ServiceException e) {
            this.logger.error("\u65b0\u589e\u4e0b\u7ea7CA\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/subCa/info"}, method={RequestMethod.PUT})
    public Object updateSubCaInfo(@RequestBody SubCaInfoVO subCaInfoVO, HttpServletResponse resp, AuditSignBean bean) {
        if (StringUtils.isBlank((CharSequence)subCaInfoVO.getName()) || StringUtils.isBlank((CharSequence)subCaInfoVO.getOrgName()) || StringUtils.isBlank((CharSequence)subCaInfoVO.getContacts()) || StringUtils.isBlank((CharSequence)subCaInfoVO.getMobile()) || StringUtils.isBlank((CharSequence)subCaInfoVO.getEmail())) {
            this.logger.debug("\u66f4\u65b0\u4e0b\u7ea7CA\u673a\u6784\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}]", (Object)subCaInfoVO);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        Result result = null;
        try {
            result = this.subCaManageService.updateSubCaInfo(subCaInfoVO);
            StringBuffer content = new StringBuffer();
            int execResult = result.isSuccess() ? AuditLogResultEnum.SUCCESS.id : AuditLogResultEnum.FAIL.id;
            content.append("\u66f4\u65b0\u4e0b\u7ea7CA" + AuditLogResultEnum.getValueFromId((int)execResult) + ",\u4e0b\u7ea7CA\u540d\u79f0=").append(subCaInfoVO.getName());
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.SUB_CA_MANAGER.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55\u4e0b\u7ea7CA\u7ba1\u7406-\u66f4\u65b0\u4e0b\u7ea7CA\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u4e0b\u7ea7CA\u7ba1\u7406-\u66f4\u65b0\u4e0b\u7ea7CA\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return null;
        }
        catch (ServiceException e) {
            this.logger.error("\u66f4\u65b0\u4e0b\u7ea7CA\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/subCa/template/{code}"}, method={RequestMethod.GET})
    public Object getSubCaTemplate(@PathVariable String code, HttpServletResponse resp) {
        Result subCaTemplateInfo = null;
        try {
            subCaTemplateInfo = this.subCaManageService.getTemplateInfo(code);
        }
        catch (ServiceException e) {
            this.logger.error("\u67e5\u8be2\u4e0b\u7ea7CA\u8bc1\u4e66\u6a21\u677f\u4fe1\u606f\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!subCaTemplateInfo.isSuccess()) {
            return subCaTemplateInfo.getError().resp(resp);
        }
        return subCaTemplateInfo.getInfo();
    }

    @AuditSign
    @RequestMapping(value={"/v1/subCa/cert"}, method={RequestMethod.POST})
    public Object issueSubCaCert(@RequestBody IssueSubCaCertVO issueSubCaCertVO, HttpServletResponse resp, AuditSignBean bean) {
        this.logger.info("\u6536\u5230\u4e0b\u7ea7CA\u8bc1\u4e66\u7b7e\u53d1\u8bf7\u6c42[{}]", (Object)issueSubCaCertVO);
        if (null == issueSubCaCertVO.getId() || StringUtils.isBlank((CharSequence)issueSubCaCertVO.getCertDn()) || StringUtils.isBlank((CharSequence)issueSubCaCertVO.getP10()) || null == issueSubCaCertVO.getValidity() || StringUtils.isBlank((CharSequence)issueSubCaCertVO.getTempCode()) || null == issueSubCaCertVO) {
            this.logger.debug("\u7b7e\u53d1\u4e0b\u7ea7CA\u8bc1\u4e66\u5931\u8d25,\u51fa\u73b0\u7a7a\u53c2\u6570[{}]", (Object)issueSubCaCertVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        Result result = null;
        try {
            result = this.subCaManageService.doIssueSubCaCert(issueSubCaCertVO);
            this.logger.info("\u4e0b\u7ea7CA\u8bc1\u4e66\u7b7e\u53d1\u8bf7\u6c42\u5904\u7406\u5b8c\u6210[{}]", (Object)result);
            StringBuffer content = new StringBuffer();
            int execResult = result.isSuccess() ? AuditLogResultEnum.SUCCESS.id : AuditLogResultEnum.FAIL.id;
            content.append("\u4e0b\u7ea7CA\u8bc1\u4e66\u7b7e\u53d1\u8bc1\u4e66" + AuditLogResultEnum.getValueFromId((int)execResult) + ",\u8bc1\u4e66DN=").append(issueSubCaCertVO.getCertDn());
            if (execResult == AuditLogResultEnum.SUCCESS.id) {
                content.append(",\u8bc1\u4e66SN=").append(result.getAuditContent());
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.SUB_CA_MANAGER.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55\u4e0b\u7ea7CA\u7ba1\u7406-\u4e0b\u7ea7CA\u8bc1\u4e66\u7b7e\u53d1\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u4e0b\u7ea7CA\u7ba1\u7406-\u4e0b\u7ea7CA\u8bc1\u4e66\u7b7e\u53d1\u8bc1\u4e66\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (result.isSuccess()) {
                return result.getInfo();
            }
            return result.getError().resp(resp);
        }
        catch (Exception e) {
            this.logger.error("\u7b7e\u53d1\u4e0b\u7ea7CA\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/subCaCert/list"}, method={RequestMethod.GET})
    public Object getSubCaCertList(SubCaCertQueryVO subCaCertQueryVO, HttpServletResponse resp) {
        Result raCertResult = null;
        try {
            raCertResult = this.subCaManageService.getSubCaCertList(subCaCertQueryVO);
        }
        catch (ServiceException e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u4e0b\u7ea7CA\u8bc1\u4e66\u5217\u8868\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!raCertResult.isSuccess()) {
            return raCertResult.getError().resp(resp);
        }
        return raCertResult.getInfo();
    }

    @RequestMapping(value={"/v1/subCa/name/unique"}, method={RequestMethod.GET})
    public Object verifyCaName(@RequestParam String name, @RequestParam(value="id", required=false) Integer id, HttpServletResponse resp) {
        Result result = null;
        try {
            result = this.subCaManageService.verifyCaName(name, id);
        }
        catch (ServiceException e) {
            this.logger.error("\u6821\u9a8ccaName\u5f02\u5e38\uff0c", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        return result;
    }
}

