/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.certmanager.web.template;

import com.xdja.pki.ca.auth.annotation.AuditSign;
import com.xdja.pki.ca.auth.service.bean.AuditSignBean;
import com.xdja.pki.ca.certmanager.service.template.TemplateService;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateInfoVO;
import com.xdja.pki.ca.certmanager.service.template.bean.TemplateQueryVO;
import com.xdja.pki.ca.certmanager.service.template.bean.groups.SaveTemplate;
import com.xdja.pki.ca.certmanager.service.template.bean.groups.UpdateTemplate;
import com.xdja.pki.ca.certmanager.service.template.bean.groups.UpdateTemplateStatus;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.enums.TemplateStatusEnum;
import com.xdja.pki.ca.core.enums.TemplateTypeEnum;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogOperatorTypeEnum;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogResultEnum;
import com.xdja.pki.ca.securityaudit.service.log.AuditLogService;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TemplateController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private TemplateService templateService;
    @Autowired
    private AuditLogService auditLogService;

    @RequestMapping(value={"/v1/template/list"}, method={RequestMethod.GET})
    public Object list(TemplateQueryVO query, HttpServletResponse resp) {
        if (null != query.getType() && query.getType() != TemplateTypeEnum.USER.value && query.getType() != TemplateTypeEnum.CA.value && query.getType() != TemplateTypeEnum.CROSS.value || null != query.getStatus() && query.getStatus() != TemplateStatusEnum.NOT_ENABLED.value && query.getStatus() != TemplateStatusEnum.NORMAL.value && query.getStatus() != TemplateStatusEnum.DISABLED.value) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u5206\u9875\u67e5\u8be2\u6a21\u677f\u5217\u8868\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}]", (Object)query);
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            return this.templateService.queryTemplates(query);
        }
        catch (ServiceException e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u6a21\u677f\u5217\u8868\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/template/{type}/list"}, method={RequestMethod.GET})
    public Object getTemplatesByType(@PathVariable int type, HttpServletResponse resp) {
        if (type != TemplateTypeEnum.USER.value && type != TemplateTypeEnum.CA.value && type != TemplateTypeEnum.CROSS.value) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u6839\u636e\u6a21\u677f\u7c7b\u578b\u83b7\u53d6\u6a21\u677f\u540d\u79f0\u5217\u8868\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[type={}]", (Object)type);
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            return this.templateService.getTemplatesByType(type);
        }
        catch (ServiceException e) {
            this.logger.error("\u6839\u636e\u6a21\u677f\u7c7b\u578b\u83b7\u53d6\u6a21\u677f\u540d\u79f0\u5217\u8868\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/template/{code}/detail"}, method={RequestMethod.GET})
    public Object getTemplateByCode(@PathVariable String code, HttpServletResponse resp) {
        if (StringUtils.isBlank((CharSequence)code)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u83b7\u53d6\u8bc1\u4e66\u6a21\u677f\u4fe1\u606f\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[code={}]", (Object)code);
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            Result result = this.templateService.getTemplateByCode(code);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (ServiceException e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u6a21\u677f\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/template/status"}, method={RequestMethod.PUT})
    public Object updateTemplateStatus(HttpServletResponse resp, AuditSignBean bean, @Validated(value={UpdateTemplateStatus.class}) @RequestBody TemplateInfoVO req, BindingResult bindResult) {
        if (bindResult.hasErrors()) {
            if (this.logger.isDebugEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.debug("\u66f4\u65b0\u6a21\u677f\u72b6\u6001\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1).toString());
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            Result result = this.templateService.updateTemplateStatus(req.getCode(), req.getStatus().intValue());
            if (!result.isSuccess()) {
                this.saveAuditLog(result.getAuditContent(), bean.getSign(), false);
                return result.getError().resp(resp);
            }
            this.saveAuditLog(result.getAuditContent(), bean.getSign(), true);
            return null;
        }
        catch (ServiceException e) {
            this.logger.error("\u66f4\u65b0\u6a21\u677f\u72b6\u6001\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/template/{code}"}, method={RequestMethod.DELETE})
    public Object deleteTemplate(@PathVariable String code, AuditSignBean bean, HttpServletResponse resp) {
        if (StringUtils.isBlank((CharSequence)code)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u5220\u9664\u8bc1\u4e66\u6a21\u677f\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[code={}]", (Object)code);
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            Result result = this.templateService.deleteTemplate(code);
            if (!result.isSuccess()) {
                this.saveAuditLog(result.getAuditContent(), bean.getSign(), false);
                return result.getError().resp(resp);
            }
            this.saveAuditLog(result.getAuditContent(), bean.getSign(), true);
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u8bc1\u4e66\u6a21\u677f\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/template/code"}, method={RequestMethod.GET})
    public Object getTemplateCode(HttpServletResponse resp) {
        try {
            return this.templateService.generateTemplateCode();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6a21\u677f\u7f16\u53f7\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/template/info"}, method={RequestMethod.POST})
    public Object saveTemplate(HttpServletResponse resp, AuditSignBean bean, @Validated(value={SaveTemplate.class}) @RequestBody TemplateInfoVO req, BindingResult bindResult) {
        if (bindResult.hasErrors()) {
            if (this.logger.isDebugEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u4fdd\u5b58\u8bc1\u4e66\u6a21\u677f\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1).toString());
                }
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            Result result = this.templateService.saveTemplate(req);
            if (!result.isSuccess()) {
                this.saveAuditLog(result.getAuditContent(), bean.getSign(), false);
                return result.getError().resp(resp);
            }
            this.saveAuditLog(result.getAuditContent(), bean.getSign(), true);
            return null;
        }
        catch (ServiceException e) {
            this.logger.error("\u4fdd\u5b58\u8bc1\u4e66\u6a21\u677f\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/template/info"}, method={RequestMethod.PUT})
    public Object updateTemplate(HttpServletResponse resp, AuditSignBean bean, @Validated(value={UpdateTemplate.class}) @RequestBody TemplateInfoVO req, BindingResult bindResult) {
        if (bindResult.hasErrors()) {
            if (this.logger.isDebugEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.debug("\u66f4\u65b0\u8bc1\u4e66\u6a21\u677f\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1).toString());
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            Result result = this.templateService.updateTemplate(req);
            if (!result.isSuccess()) {
                this.saveAuditLog(result.getAuditContent(), bean.getSign(), false);
                return result.getError().resp(resp);
            }
            this.saveAuditLog(result.getAuditContent(), bean.getSign(), true);
            return null;
        }
        catch (ServiceException e) {
            this.logger.error("\u66f4\u65b0\u8bc1\u4e66\u6a21\u677f\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    private void saveAuditLog(String auditContent, String sign, boolean result) {
        int operatorResult = result ? AuditLogResultEnum.SUCCESS.id : AuditLogResultEnum.FAIL.id;
        int operatorType = AuditLogOperatorTypeEnum.TEMPLATE_MANAGER.type;
        try {
            boolean flag = this.auditLogService.save(operatorType, auditContent, operatorResult, sign);
            if (!flag) {
                this.logger.error("\u4fdd\u5b58\u6a21\u677f\u7ba1\u7406\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
            }
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u6a21\u677f\u7ba1\u7406\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
    }
}

