/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securityaudit.web.auditorcertmanager;

import com.xdja.pki.auditlog.service.bean.AuditLogResultEnum;
import com.xdja.pki.auditlog.service.bean.ca.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ca.certmanager.service.camanagecert.ICaManageCertService;
import com.xdja.pki.ca.certmanager.service.camanagecert.bean.IssueCaCertReqVO;
import com.xdja.pki.ca.certmanager.service.racert.bean.CertTypeEnum;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.securityaudit.dao.models.RoleTypeEnum;
import com.xdja.pki.ca.securityaudit.service.auditorcertmanager.AuditorCertManageService;
import com.xdja.pki.ca.securityaudit.service.bean.IssueCertVO;
import com.xdja.pki.ca.securityaudit.service.bean.UpdateAuditCertDTO;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AuditorCertManagerController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AuditorCertManageService auditorCertManageService;
    @Autowired
    private ICaManageCertService iCaManageCertService;
    @Autowired
    private AuditLogService auditLogService;

    @RequestMapping(value={"/v1/auditor/list"}, method={RequestMethod.GET})
    public Object getAuditorCertList(String certDn, String sn, @RequestParam(value="status") Integer status, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize, HttpServletResponse resp) {
        this.logger.debug("\u5ba1\u8ba1\u5458\u8bc1\u4e66\u7ba1\u7406\u6a21\u5757>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u5f00\u59cb\u83b7\u53d6\u5ba1\u8ba1\u5458\u8bc1\u4e66");
        try {
            Result result = this.auditorCertManageService.getAuditorCertList(certDn, sn, status, pageNo, pageSize);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5ba1\u8ba1\u5458\u8bc1\u4e66\u5217\u8868\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/auditor"}, method={RequestMethod.POST})
    public Object issueAuditor(@RequestBody IssueCertVO issueCertVO, AuditSignBean bean, HttpServletResponse resp) {
        this.logger.debug("\u5ba1\u8ba1\u5458\u8bc1\u4e66\u7ba1\u7406\u6a21\u5757>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u5f00\u59cb\u65b0\u589e\u5ba1\u8ba1\u5458\u8bc1\u4e66");
        if (null == issueCertVO.getCertDn() || null == issueCertVO.getP10() || null == issueCertVO.getSubjectPublicKeyInfo() || null == issueCertVO.getValidity()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u65b0\u589e\u5ba1\u8ba1\u5458\u8bc1\u4e66\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}]", (Object)issueCertVO);
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            int loginResult;
            IssueCaCertReqVO issueCaCertReqVO = new IssueCaCertReqVO();
            issueCaCertReqVO.setRoleType(Integer.valueOf(RoleTypeEnum.AUDITOR.value));
            BeanUtils.copyProperties((Object)issueCertVO, (Object)issueCaCertReqVO);
            Result result = this.iCaManageCertService.doIssueCaManagerCert(issueCaCertReqVO);
            StringBuilder content = new StringBuilder();
            if (!result.isSuccess()) {
                loginResult = AuditLogResultEnum.FAIL.id;
                content.append("\u65b0\u589e\u5ba1\u8ba1\u5458\u5931\u8d25,\u8bc1\u4e66\u89d2\u8272=").append(CertTypeEnum.ADMIN_CERT.desc);
            } else {
                loginResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u65b0\u589e\u5ba1\u8ba1\u5458\u6210\u529f,\u8bc1\u4e66\u89d2\u8272=").append(CertTypeEnum.ADMIN_CERT.desc).append(",\u8bc1\u4e66DN=").append(issueCertVO.getCertDn()).append(",\u8bc1\u4e66SN").append(result.getAuditContent());
            }
            this.logger.info(content.toString());
            try {
                boolean flag = this.auditLogService.saveAuditLog(AuditLogOperatorTypeEnum.CERT_SIGN.type, content.toString(), loginResult, bean.getSign());
                if (!flag) {
                    this.logger.error("\u8bb0\u5f55-\u65b0\u589e\u5ba1\u8ba1\u5458-\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55-\u65b0\u589e\u5ba1\u8ba1\u5458-\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u65b0\u589e\u5ba1\u8ba1\u5458\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/auditor"}, method={RequestMethod.PUT})
    public Object updateAuditorCert(@RequestBody UpdateAuditCertDTO updateAuditCertDTO, AuditSignBean bean, HttpServletResponse resp) {
        this.logger.debug("\u5ba1\u8ba1\u5458\u8bc1\u4e66\u7ba1\u7406\u6a21\u5757>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u5f00\u59cb\u66f4\u65b0\u5ba1\u8ba1\u5458\u8bc1\u4e66");
        this.logger.debug("\u5ba1\u8ba1\u5458\u8bc1\u4e66\u7ba1\u7406\u6a21\u5757>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u66f4\u65b0\u5ba1\u8ba1\u5458\u8bc1\u4e66\u8bf7\u6c42\u53c2\u6570\u4e3a:[{}]", (Object)updateAuditCertDTO);
        if (null == updateAuditCertDTO.getDnUpdate() || null == updateAuditCertDTO.getKeyUpdate() || null == updateAuditCertDTO.getValidityUpdate()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u66f4\u65b0\u5ba1\u8ba1\u5458\u8bc1\u4e66\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5,\u662f\u5426\u66f4\u65b0\u9009\u9879\u4e0d\u80fd\u4e3a\u7a7a[{}]", new Object[]{updateAuditCertDTO.getDnUpdate(), updateAuditCertDTO.getKeyUpdate(), updateAuditCertDTO.getValidityUpdate()});
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (updateAuditCertDTO.getDnUpdate().booleanValue() && null == updateAuditCertDTO.getCertDn()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u66f4\u65b0\u5ba1\u8ba1\u5458\u8bc1\u4e66\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u6c42\u6267\u884c\u66f4\u65b0\u8bc1\u4e66\u4e3b\u4f53\u64cd\u4f5c\u65f6\uff0c\u53c2\u6570dn\u4e3a\u7a7a");
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (updateAuditCertDTO.getKeyUpdate().booleanValue() && (null == updateAuditCertDTO.getSubjectPublicKeyInfo() || null == updateAuditCertDTO.getP10())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u66f4\u65b0\u5ba1\u8ba1\u5458\u8bc1\u4e66\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u6c42\u6267\u884c\u66f4\u65b0\u8bc1\u4e66\u5bc6\u94a5\u5bf9\u64cd\u4f5c\u65f6\uff0c\u53c2\u6570signPublicKey\u6216encPublicKey\u4e3a\u7a7a");
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (updateAuditCertDTO.getValidityUpdate().booleanValue() && null == updateAuditCertDTO.getValidity()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u66f4\u65b0\u5ba1\u8ba1\u5458\u8bc1\u4e66\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u8bf7\u6c42\u6267\u884c\u66f4\u65b0\u8bc1\u4e66\u6709\u6548\u671f\u64cd\u4f5c\u65f6\uff0c\u53c2\u6570validity\u4e3a\u7a7a");
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            int loginResult;
            IssueCaCertReqVO issueCaCertReqVO = new IssueCaCertReqVO();
            issueCaCertReqVO.setRoleType(Integer.valueOf(RoleTypeEnum.AUDITOR.value));
            BeanUtils.copyProperties((Object)updateAuditCertDTO, (Object)issueCaCertReqVO);
            Result result = this.iCaManageCertService.doUpdateCaManagerCert(issueCaCertReqVO);
            StringBuilder content = new StringBuilder();
            if (!result.isSuccess()) {
                loginResult = AuditLogResultEnum.FAIL.id;
                content.append("\u66f4\u65b0\u5ba1\u8ba1\u5458\u8bc1\u4e66\u5931\u8d25,\u8bc1\u4e66\u89d2\u8272=").append(CertTypeEnum.ADMIN_CERT.desc).append(",\u8bc1\u4e66SN=").append(bean.getSn());
            } else {
                loginResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u66f4\u65b0\u5ba1\u8ba1\u5458\u8bc1\u4e66\u6210\u529f,\u8bc1\u4e66\u89d2\u8272=").append(CertTypeEnum.ADMIN_CERT.desc).append(",\u8bc1\u4e66SN=").append(bean.getSn()).append(",\u8bc1\u4e66DN=").append(result.getAuditContent());
            }
            this.logger.info(content.toString());
            try {
                boolean flag = this.auditLogService.saveAuditLog(AuditLogOperatorTypeEnum.CERT_UPDATE.type, content.toString(), loginResult, bean.getSign());
                if (!flag) {
                    this.logger.error("\u8bb0\u5f55-\u66f4\u65b0\u589e\u5ba1\u8ba1\u5458\u8bc1\u4e66-\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55-\u66f4\u65b0\u589e\u5ba1\u8ba1\u5458\u8bc1\u4e66-\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5ba1\u8ba1\u5458\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }
}

