/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securityaudit.web.log;

import com.xdja.pki.auditlog.service.ArchiveLogService;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.util.ExcelUtil;
import com.xdja.pki.core.bean.CoreResult;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ArchiveLogController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ArchiveLogService archiveLogService;

    @RequestMapping(value={"/v1/archivelog/list"}, method={RequestMethod.GET})
    public Object getArchiveLogList(@RequestParam(value="pageNo", required=false) Integer pageNo, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="operatorType", required=false) Integer operatorType, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, HttpServletResponse resp) {
        if (null != pageNo && null == pageSize || null == pageNo && null != pageSize) {
            this.logger.debug("\u5206\u9875\u67e5\u8be2 \u83b7\u53d6\u5f52\u6863\u65e5\u5fd7\u5217\u8868 \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)pageNo, (Object)pageSize);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (null != startTime && null == endTime || null == startTime && null != endTime) {
            this.logger.debug("\u5206\u9875\u67e5\u8be2 \u83b7\u53d6\u5f52\u6863\u65e5\u5fd7\u5217\u8868 \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)startTime, (Object)endTime);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            if (pageNo == null) {
                pageNo = 1;
                pageSize = 10;
            }
            return this.archiveLogService.listArchiveLogs(pageNo, pageSize, operatorType, startTime, endTime, false);
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u5f52\u6863\u65e5\u5fd7\u5217\u8868\u6570\u636e\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/archivelog/export"}, method={RequestMethod.GET})
    public Object exportArchiveLogList(@RequestParam(value="pageNo", required=false) Integer pageNo, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="operatorType", required=false) Integer operatorType, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, HttpServletResponse resp) {
        if (null != pageNo && null == pageSize || null == pageNo && null != pageSize) {
            this.logger.debug("\u5bfc\u51fa \u5f52\u6863\u65e5\u5fd7\u5217\u8868 \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)pageNo, (Object)pageSize);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (null != startTime && null == endTime || null == startTime && null != endTime) {
            this.logger.debug("\u5bfc\u51fa  \u5f52\u6863\u65e5\u5fd7\u5217\u8868 \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)startTime, (Object)endTime);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            List datas = (List)this.archiveLogService.listArchiveLogs(pageNo, pageSize, operatorType, startTime, endTime, true);
            if (datas.size() == 0) {
                return ErrorEnum.NO_ARCHIVE_LOG_TO_EXPORT.resp(resp);
            }
            resp.setContentType("application/force-download");
            resp.setHeader("Content-Disposition", "attachment; filename=audit_log_list.xls");
            ExcelUtil.getExcel((OutputStream)resp.getOutputStream(), (String)"\u64cd\u4f5c\u65e5\u5fd7\u5217\u8868", (List)datas, (boolean)true);
            return CoreResult.success();
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u5f52\u6863\u65e5\u5fd7\u5217\u8868\u6570\u636e\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/archivelog/detail"}, method={RequestMethod.GET})
    public Object getArchiveLogInfo(@RequestParam(value="id") int id, @RequestParam(value="verify", required=false) Integer verify, HttpServletResponse resp) {
        try {
            this.logger.info("get archive log info id = {} verify = {}", (Object)id, (Object)verify);
            return this.archiveLogService.getArchiveLogbyId(id, verify);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5f52\u6863\u65e5\u5fd7\u8be6\u60c5\u6570\u636e\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/archivelog/verify"}, method={RequestMethod.GET})
    public Object verifyArchiveLog(@RequestParam int id, HttpServletResponse resp) {
        try {
            this.logger.info("archive log verify id = {}", (Object)id);
            CoreResult result = this.archiveLogService.verifyArchiveLog(id);
            if (!result.isSuccess() && null != result.getErrorBean()) {
                return result.resp(resp, result);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u5f52\u6863\u65e5\u5fd7\u9a8c\u7b7e\u5931\u8d25\uff01", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }
}

