/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitystatistics.web;

import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.util.ExcelUtil;
import com.xdja.pki.ca.securitystatistics.service.StatisticsService;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class StatisticsController {
    private Logger logger = LoggerFactory.getLogger(StatisticsController.class);
    @Autowired
    private StatisticsService statisticsService;

    @GetMapping(value={"/v1/statistics/cert"})
    public Object statisticsCert(@RequestParam(value="certTemplateId", required=false) Integer certTemplateId, @RequestParam(value="raId", required=false) Integer raId, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, HttpServletResponse resp) {
        if (null != startTime && null == endTime || null == startTime && null != endTime) {
            this.logger.debug("\u7edf\u8ba1\u8bc1\u4e66\u6570\u91cf \u5217\u8868 \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)startTime, (Object)endTime);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            return this.statisticsService.getCertStatistics(certTemplateId, raId, startTime, endTime);
        }
        catch (Exception e) {
            this.logger.error("\u7edf\u8ba1\u8bc1\u4e66\u6570\u91cf \u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @GetMapping(value={"/v1/statistics/cert/export"})
    public Object statisticsCertExport(@RequestParam(value="certTemplateId", required=false) Integer certTemplateId, @RequestParam(value="raId", required=false) Integer raId, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, HttpServletResponse resp) {
        if (null != startTime && null == endTime || null == startTime && null != endTime) {
            this.logger.debug("\u7edf\u8ba1\u8bc1\u4e66\u6570\u91cf  \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)startTime, (Object)endTime);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            List certStatistics = this.statisticsService.getCertStatistics(certTemplateId, raId, startTime, endTime);
            if (certStatistics.size() == 0) {
                return ErrorEnum.NO_AUDIT_LOG_TO_EXPORT.resp(resp);
            }
            resp.setContentType("application/force-download");
            resp.setHeader("Content-Disposition", "attachment; filename=cert_statistics.xls");
            ExcelUtil.getExcel((OutputStream)resp.getOutputStream(), (String)"\u8bc1\u4e66\u6570\u91cf\u7edf\u8ba1\u5217\u8868", (List)certStatistics, (boolean)true);
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u7edf\u8ba1\u8bc1\u4e66\u6570\u91cf \u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @GetMapping(value={"/v1/statistics/ra"})
    public Object statisticsRa(@RequestParam(value="raId", required=false) Integer raId, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, HttpServletResponse resp) {
        if (null != startTime && null == endTime || null == startTime && null != endTime) {
            this.logger.debug("\u7edf\u8ba1RA\u4e1a\u52a1 \u5217\u8868 \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)startTime, (Object)endTime);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            return this.statisticsService.getRaStatistics(raId, startTime, endTime);
        }
        catch (Exception e) {
            this.logger.error("\u7edf\u8ba1RA\u4e1a\u52a1 \u5217\u8868 \u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @GetMapping(value={"/v1/statistics/ra/export"})
    public Object statisticsRaExport(@RequestParam(value="raId", required=false) Integer raId, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, HttpServletResponse resp) {
        if (null != startTime && null == endTime || null == startTime && null != endTime) {
            this.logger.debug("\u7edf\u8ba1RA\u4e1a\u52a1  \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)startTime, (Object)endTime);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            List raStatistics = this.statisticsService.getRaStatistics(raId, startTime, endTime);
            if (raStatistics.size() == 0) {
                return ErrorEnum.NO_AUDIT_LOG_TO_EXPORT.resp(resp);
            }
            resp.setContentType("application/force-download");
            resp.setHeader("Content-Disposition", "attachment; filename=ra_statistics.xls");
            ExcelUtil.getExcel((OutputStream)resp.getOutputStream(), (String)"RA\u4e1a\u52a1\u7edf\u8ba1\u5217\u8868", (List)raStatistics, (boolean)true);
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u7edf\u8ba1RA\u4e1a\u52a1 \u5217\u8868 \u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @GetMapping(value={"/v1/statistics/raName"})
    public Object getRaName(HttpServletResponse resp) {
        try {
            return this.statisticsService.getRaName();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6RA\u540d\u79f0\u5217\u8868 \u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @GetMapping(value={"/v1/statistics/templateName"})
    public Object getCertTemplate(HttpServletResponse resp) {
        try {
            return this.statisticsService.getCertTemplate();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6a21\u677f\u540d\u79f0\u5217\u8868 \u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }
}

