/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securityaudit.web.log;

import com.xdja.pki.auditlog.dao.model.AuditLogDO;
import com.xdja.pki.auditlog.service.AuditorOperateLogService;
import com.xdja.pki.auditlog.service.bean.AuditorOperateLogResultEnum;
import com.xdja.pki.auditlog.service.bean.AuditorOperateTypeEnum;
import com.xdja.pki.auth.annotation.AuditSign;
import com.xdja.pki.auth.service.AuditLogService;
import com.xdja.pki.auth.service.bean.AuditLogAuditReq;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.core.bean.CoreResult;
import com.xdja.pki.core.utils.file.ExcelUtil;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AuditLogController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AuditLogService auditLogService;
    @Autowired
    private AuditorOperateLogService auditorOperateLogService;

    @RequestMapping(value={"/v1/auditlog/info"}, method={RequestMethod.GET})
    public Object getAuditLogInfo(@RequestParam(value="id") int id, @RequestParam(value="verify", required=false) Integer verify, HttpServletResponse resp) {
        try {
            this.logger.info("get audit log info id = {} verify = {}", (Object)id, (Object)verify);
            CoreResult result = this.auditLogService.get(id, verify);
            if (!result.isSuccess() || null != result.getErrorBean()) {
                return result.resp(resp, result);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u65e5\u5fd7\u5ba1\u8ba1\u8be6\u60c5\u6570\u636e\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/auditlog/list"}, method={RequestMethod.GET})
    public Object getAuditLogList(@RequestParam(value="pageNo", required=false) Integer pageNo, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="operatorSubject", required=false) String operatorSubject, @RequestParam(value="operatorType", required=false) Integer operatorType, @RequestParam(value="isAudit", required=false) Integer isAudit, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, HttpServletResponse resp) {
        if (null != pageNo && null == pageSize || null == pageNo && null != pageSize) {
            this.logger.debug("\u5206\u9875\u67e5\u8be2 \u83b7\u53d6 \u5ba1\u8ba1\u65e5\u5fd7 \u5217\u8868 \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)pageNo, (Object)pageSize);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (null != startTime && null == endTime || null == startTime && null != endTime) {
            this.logger.debug("\u5206\u9875\u67e5\u8be2 \u83b7\u53d6 \u5ba1\u8ba1\u65e5\u5fd7 \u5217\u8868 \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)startTime, (Object)endTime);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            CoreResult result;
            if (pageNo == null) {
                pageNo = 1;
                pageSize = 10;
            }
            if (!(result = this.auditLogService.getAuditLogList(pageNo, pageSize, operatorSubject, operatorType, isAudit, startTime, endTime)).isSuccess() || null != result.getErrorBean()) {
                return result.resp(resp, result);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u65e5\u5fd7\u5ba1\u8ba1\u5217\u8868\u6570\u636e\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/auditlog/export"}, method={RequestMethod.GET})
    public Object exportAuditLogList(@RequestParam(value="pageNo", required=false) Integer pageNo, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="operatorSubject", required=false) String operatorSubject, @RequestParam(value="operatorType", required=false) Integer operatorType, @RequestParam(value="isAudit", required=false) Integer isAudit, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, HttpServletResponse resp) {
        if (null != pageNo && null == pageSize || null == pageNo && null != pageSize) {
            this.logger.debug("\u5bfc\u51fa \u5ba1\u8ba1\u65e5\u5fd7 \u5217\u8868 \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)pageNo, (Object)pageSize);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (null != startTime && null == endTime || null == startTime && null != endTime) {
            this.logger.debug("\u5bfc\u51fa  \u83b7\u53d6 \u5ba1\u8ba1\u65e5\u5fd7 \u5217\u8868 \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)startTime, (Object)endTime);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        StringBuffer auditContext = new StringBuffer();
        try {
            pageNo = 0;
            pageSize = 0;
            CoreResult result = this.auditLogService.getAuditLogList(pageNo, pageSize, operatorSubject, operatorType, isAudit, startTime, endTime);
            List datas = (List)result.getInfo();
            if (datas.size() == 0) {
                return ErrorEnum.NO_AUDIT_LOG_TO_EXPORT.resp(resp);
            }
            resp.setContentType("application/force-download");
            resp.setHeader("Content-Disposition", "attachment; filename=audit_log_list.xls");
            ExcelUtil.getExcel((OutputStream)resp.getOutputStream(), (String)"\u64cd\u4f5c\u65e5\u5fd7\u5217\u8868", (List)datas, (boolean)true);
            int auditResult = AuditorOperateLogResultEnum.SUCCESS.id;
            auditContext.append("\u5bfc\u51fa\u65e5\u5fd7\u6210\u529f\uff0c\u5bfc\u51fa\u65e5\u5fd7\u6761\u6570\uff1a").append(datas.size());
            try {
                boolean flag = this.auditorOperateLogService.saveAuditorOperateLog(AuditorOperateTypeEnum.EXPORT_LOG.type, auditContext.toString(), auditResult);
                if (!flag) {
                    this.logger.error("\u8bb0\u5f55\u5ba1\u8ba1\u5458\u5bfc\u51fa\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u5ba1\u8ba1\u5458\u5bfc\u51fa\u65e5\u5fd7\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u65e5\u5fd7\u5ba1\u8ba1\u5217\u8868\u6570\u636e\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/auditlog/audit"}, method={RequestMethod.PUT})
    public Object auditAuditLog(@RequestBody AuditLogAuditReq req, AuditSignBean bean, HttpServletResponse resp) {
        StringBuffer auditContext = new StringBuffer();
        try {
            int auditResult;
            this.logger.info("audit log audit req = {}", (Object)req);
            CoreResult result = this.auditLogService.doAuditLog(req, bean);
            CoreResult result1 = (CoreResult)this.auditLogService.getOperateLogById(req.getId());
            if (!result1.isSuccess()) {
                return result1.resp(resp, result);
            }
            AuditLogDO auditLogDO = (AuditLogDO)result1.getInfo();
            if (result.isSuccess()) {
                auditResult = AuditorOperateLogResultEnum.SUCCESS.id;
                auditContext.append("\u5ba1\u6838\u65e5\u5fd7\u6210\u529f\uff0c\u5ba1\u8ba1\u4fe1\u606f\uff1a").append(auditLogDO.getAuditNote()).append("\uff0c\u5ba1\u8ba1\u64cd\u4f5c\u5185\u5bb9\uff1a").append(auditLogDO.getOperateContent());
            } else {
                auditResult = AuditorOperateLogResultEnum.FAIL.id;
                auditContext.append("\u5ba1\u6838\u65e5\u5fd7\u5931\u8d25\uff0c\u5ba1\u8ba1\u4fe1\u606f\uff1a").append(auditLogDO.getAuditNote()).append("\uff0c\u5ba1\u8ba1\u64cd\u4f5c\u5185\u5bb9\uff1a").append(auditLogDO.getOperateContent());
            }
            try {
                boolean flag = this.auditorOperateLogService.saveAuditorOperateLog(AuditorOperateTypeEnum.AUDIT_LOG.type, auditContext.toString(), auditResult);
                if (!flag) {
                    this.logger.error("\u8bb0\u5f55\u5ba1\u8ba1\u5458\u5ba1\u6838\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u5ba1\u8ba1\u5458\u5ba1\u6838\u65e5\u5fd7\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.resp(resp, result);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u5ba1\u6838\u65e5\u5fd7\u5931\u8d25\uff01", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/auditlog/verify"}, method={RequestMethod.GET})
    public Object verifyAuditLog(@RequestParam int id, HttpServletResponse resp) {
        StringBuffer auditContext = new StringBuffer();
        try {
            int auditResult;
            this.logger.info("audit log verify id = {}", (Object)id);
            CoreResult result = this.auditLogService.verify(id);
            CoreResult result1 = (CoreResult)this.auditLogService.getOperateLogById(id);
            if (!result1.isSuccess()) {
                return result1.resp(resp, result);
            }
            AuditLogDO auditLogDO = (AuditLogDO)result1.getInfo();
            if (result.isSuccess()) {
                auditResult = AuditorOperateLogResultEnum.SUCCESS.id;
                auditContext.append("\u9a8c\u7b7e\u65e5\u5fd7\u6210\u529f\uff0c\u9a8c\u7b7e\u5ba1\u8ba1\u64cd\u4f5c\u5185\u5bb9\uff1a").append(auditLogDO.getAuditNote()).append("\uff0c\u9a8c\u7b7e\u64cd\u4f5c\u5185\u5bb9\uff1a").append(auditLogDO.getOperateContent());
            } else {
                auditResult = AuditorOperateLogResultEnum.FAIL.id;
                auditContext.append("\u9a8c\u7b7e\u65e5\u5fd7\u5931\u8d25\uff0c\u9a8c\u7b7e\u5ba1\u8ba1\u64cd\u4f5c\u5185\u5bb9\uff1a").append(auditLogDO.getAuditNote()).append("\uff0c\u9a8c\u7b7e\u64cd\u4f5c\u5185\u5bb9\uff1a").append(auditLogDO.getOperateContent());
            }
            try {
                boolean flag = this.auditorOperateLogService.saveAuditorOperateLog(AuditorOperateTypeEnum.VERIFY_LOG.type, auditContext.toString(), auditResult);
                if (!flag) {
                    this.logger.error("\u8bb0\u5f55\u5ba1\u8ba1\u5458\u9a8c\u7b7e\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u5ba1\u8ba1\u5458\u9a8c\u7b7e\u65e5\u5fd7\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.resp(resp, result);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u5ba1\u8ba1\u65e5\u5fd7\u9a8c\u7b7e\u5931\u8d25\uff01", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/auditlog/archive"}, method={RequestMethod.GET})
    public Object archiveAuditLog(@RequestParam(value="pageNo", required=false) Integer pageNo, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="operatorSubject", required=false) String operatorSubject, @RequestParam(value="operatorType", required=false) Integer operatorType, @RequestParam(value="isAudit", required=false) Integer isAudit, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, HttpServletResponse resp) {
        StringBuffer auditContext = new StringBuffer();
        try {
            int auditResult;
            if (null != startTime && null == endTime || null == startTime && null != endTime) {
                this.logger.debug("\u5bfc\u51fa  \u83b7\u53d6 \u5ba1\u8ba1\u65e5\u5fd7 \u5217\u8868 \u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5[{}, {}]", (Object)startTime, (Object)endTime);
                return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
            }
            CoreResult result = this.auditLogService.doArchiveOperateLog(operatorSubject, operatorType, isAudit, startTime, endTime);
            HashMap archiveMap = (HashMap)result.getInfo();
            if (result.isSuccess()) {
                auditResult = AuditorOperateLogResultEnum.SUCCESS.id;
                auditContext.append("\u5f52\u6863\u65e5\u5fd7\u6210\u529f\uff0c\u5f52\u6863\u6807\u5fd7flag\uff1a").append(archiveMap.get("archiveResult")).append("\uff0c\u5f52\u6863\u65e5\u5fd7\u6761\u6570\uff1a").append(archiveMap.get("archiveNum"));
            } else {
                auditResult = AuditorOperateLogResultEnum.FAIL.id;
                auditContext.append("\u5f52\u6863\u65e5\u5fd7\u5931\u8d25\uff0c\u5f52\u6863\u6807\u5fd7flag\uff1a").append(archiveMap.get("archiveResult")).append("\uff0c\u5f52\u6863\u65e5\u5fd7\u6761\u6570\uff1a").append(archiveMap.get("archiveNum"));
            }
            try {
                boolean flag = this.auditorOperateLogService.saveAuditorOperateLog(AuditorOperateTypeEnum.ARCHIVE_LOG.type, auditContext.toString(), auditResult);
                if (!flag) {
                    this.logger.error("\u8bb0\u5f55\u5ba1\u8ba1\u5458\u5f52\u6863\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55\u5ba1\u8ba1\u5458\u5f52\u6863\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
            }
            if (!result.isSuccess() || null != result.getErrorBean()) {
                return result.resp(resp, result);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u5f52\u6863\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25\uff01", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }
}

