/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.web;

import com.xdja.pki.ca.auth.annotation.AuditSign;
import com.xdja.pki.ca.auth.service.bean.AuditSignBean;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.common.ConfigUtil;
import com.xdja.pki.ca.core.common.ErrorBean;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.util.DnUtil;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogOperatorTypeEnum;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogResultEnum;
import com.xdja.pki.ca.securityaudit.service.log.AuditLogService;
import com.xdja.pki.ca.securitymanager.service.init.InitService;
import com.xdja.pki.ca.securitymanager.service.vo.AlgTypeEnum;
import com.xdja.pki.ca.securitymanager.service.vo.BasicConfigVO;
import com.xdja.pki.ca.securitymanager.service.vo.CaManagerCertVO;
import com.xdja.pki.ca.securitymanager.service.vo.CaManagerRoleEnum;
import com.xdja.pki.ca.securitymanager.service.vo.CertIssueInfoVO;
import com.xdja.pki.ca.securitymanager.service.vo.CreateP10VO;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class InitSystemController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private InitService initService;
    @Autowired
    private Environment environment;
    @Value(value="${config.path}")
    private String configPath;
    @Autowired
    private AuditLogService auditLogService;

    @RequestMapping(value={"/v1/init/rootCa/Cert"}, method={RequestMethod.POST})
    public Object issueSelfRootCert(@RequestBody CertIssueInfoVO certIssueInfoVO, HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u6839CA\u8bc1\u4e66\u7b7e\u53d1\u8bf7\u6c42[{}]", (Object)certIssueInfoVO);
        if (StringUtils.isBlank((CharSequence)certIssueInfoVO.getDn()) || null == certIssueInfoVO.getValidity() || Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_HSM.intValue() && (StringUtils.isBlank((CharSequence)certIssueInfoVO.getPrivateKeyPin()) || null == certIssueInfoVO.getKeyIndex())) {
            this.logger.debug("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            Result result = this.initService.doIssueSelfRootCert(certIssueInfoVO);
            this.logger.debug("\u6839CA\u8bc1\u4e66\u7b7e\u53d1\u8bf7\u6c42\u5904\u7406\u5b8c\u6210[{}]", (Object)result);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return Result.success();
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\u7b7e\u53d1\u6839CA\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/caserver/cert"}, method={RequestMethod.POST})
    public Object issueCaServerCert(HttpServletResponse resp, @RequestBody CertIssueInfoVO certIssueInfoVO) {
        this.logger.debug("\u6536\u5230CA\u670d\u52a1\u5668\u8bc1\u4e66\u7b7e\u53d1\u8bf7\u6c42[{}]", (Object)certIssueInfoVO);
        if (StringUtils.isBlank((CharSequence)certIssueInfoVO.getDn()) || null == certIssueInfoVO.getValidity() || null == certIssueInfoVO.getSubjectAlternativeName()) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        if (AlgTypeEnum.SM2.value == Constants.BASE_ALG_TYPE && Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_HSM.intValue() && (null == certIssueInfoVO.getKeyIndex() || StringUtils.isBlank((CharSequence)certIssueInfoVO.getPrivateKeyPin()))) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            Result result = this.initService.doIssueCaServerCert(certIssueInfoVO);
            this.logger.debug("CA\u670d\u52a1\u5668\u8bc1\u4e66\u7b7e\u53d1\u8bf7\u6c42\u5904\u7406\u5b8c\u6210[{}]", (Object)result);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\u7b7e\u53d1CA\u670d\u52a1\u5668\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/admin/cert"}, method={RequestMethod.POST})
    public Object issueCaAdminCert(HttpServletResponse resp, @RequestBody CaManagerCertVO caManagerCertVO) {
        this.logger.debug("\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\u6536\u5230\u7b7e\u53d1\u7ba1\u7406\u5458\u8bc1\u4e66\u8bf7\u6c42[{}]", (Object)caManagerCertVO);
        if (StringUtils.isBlank((CharSequence)caManagerCertVO.getDn()) || StringUtils.isBlank((CharSequence)caManagerCertVO.getSubjectPublicKeyInfo()) || StringUtils.isBlank((CharSequence)caManagerCertVO.getP10()) || null == caManagerCertVO.getValidity() || null == caManagerCertVO.getType()) {
            this.logger.debug("\u7b7e\u53d1CA\u7ba1\u7406\u5458\u8bc1\u4e66\u51fa\u73b0\u7a7a\u53c2\u6570[{}]", (Object)caManagerCertVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        if (StringUtils.isBlank((CharSequence)CaManagerRoleEnum.getCaManagerRoleNameById((int)caManagerCertVO.getType()))) {
            this.logger.debug("\u7b7e\u53d1CA\u7ba1\u7406\u5458\u89d2\u8272\u9519\u8beftype[{}]", (Object)caManagerCertVO.getType());
            return ErrorEnum.MANAGER_TYPE_ERROR.resp(resp);
        }
        try {
            Result result = this.initService.doIssueCaAdminCert(caManagerCertVO, false);
            this.logger.debug("\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\u7b7e\u53d1\u7ba1\u7406\u5458\u8bc1\u4e66\u8bf7\u6c42\u5904\u7406\u7ed3\u675f\uff0c\u8fd4\u56de\u7ed3\u679c[{}]", (Object)result);
            if (result.isSuccess()) {
                return result.getInfo();
            }
            return result.getError().resp(resp);
        }
        catch (Exception e) {
            this.logger.error("\u7b7e\u53d1CA\u7ba1\u7406\u5458\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/admin/cert/unique/{type}"}, method={RequestMethod.GET})
    public Object queryAdminIsUnique(HttpServletResponse resp, @PathVariable Integer type) {
        this.logger.debug("\u6536\u5230\u67e5\u8be2\u7ba1\u7406\u5458\u8bc1\u4e66\u662f\u5426\u7b7e\u53d1\u8fc7\u8bf7\u6c42[{}]", (Object)type);
        if (StringUtils.isBlank((CharSequence)CaManagerRoleEnum.getCaManagerRoleNameById((int)type))) {
            this.logger.debug("CA\u7ba1\u7406\u5458\u89d2\u8272\u9519\u8beftype[{}]", (Object)type);
            return ErrorEnum.MANAGER_TYPE_ERROR.resp(resp);
        }
        try {
            Result result = this.initService.queryAdminIsUnique(type);
            this.logger.debug("\u67e5\u8be2\u7ba1\u7406\u5458\u8bc1\u4e66\u662f\u5426\u7b7e\u53d1\u8fc7\u8bf7\u6c42\u5904\u7406\u7ed3\u675f\uff0c\u8fd4\u56de\u7ed3\u679c[{}]", (Object)result);
            if (result.isSuccess()) {
                return result.getInfo();
            }
            return result.getError().resp(resp);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u7ba1\u7406\u5458\u8bc1\u4e66\u662f\u5426\u7b7e\u53d1\u8fc7\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/admin/cert/count"}, method={RequestMethod.GET})
    public Object queryAdminIssueCounts(HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u67e5\u8be2\u7ba1\u7406\u5458\u8bc1\u4e66\u7b7e\u53d1\u6570\u91cf\u8bf7\u6c42[{}]");
        try {
            Result result = this.initService.queryAdminIssueCounts();
            this.logger.debug("\u67e5\u8be2\u7ba1\u7406\u5458\u8bc1\u4e66\u7b7e\u53d1\u6570\u91cf\u8bf7\u6c42\u5904\u7406\u7ed3\u675f\uff0c\u8fd4\u56de\u7ed3\u679c[{}]", (Object)result);
            if (result.isSuccess()) {
                return result.getInfo();
            }
            return result.getError().resp(resp);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u7ba1\u7406\u5458\u8bc1\u4e66\u662f\u5426\u7b7e\u53d1\u8fc7\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/baseConfig"}, method={RequestMethod.POST})
    public Object InitBasicConfig(HttpServletResponse resp, @RequestBody BasicConfigVO basicConfigVO) {
        this.logger.debug("\u6536\u5230\u521d\u59cb\u5316\u57fa\u672c\u914d\u7f6e\u4fdd\u5b58\u8bf7\u6c42[{}]", (Object)basicConfigVO);
        if (StringUtils.isBlank((CharSequence)basicConfigVO.getBaseDn()) || null == basicConfigVO.getType() || null == basicConfigVO.getKeyAlg()) {
            this.logger.debug("\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\uff0c\u4fdd\u5b58CA\u57fa\u672c\u914d\u7f6e\u51fa\u73b0\u7a7a\u53c2\u6570:" + basicConfigVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        if (basicConfigVO.getKeyAlg() != AlgTypeEnum.SM2.value && basicConfigVO.getKeyAlg() != AlgTypeEnum.RSA.value && basicConfigVO.getKeyAlg() != AlgTypeEnum.NISTP256.value) {
            this.logger.debug("\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\uff0c\u57fa\u672c\u914d\u7f6e\u5bc6\u94a5\u7b97\u6cd5\u9519\u8bef\uff0c\u7b97\u6cd5=" + basicConfigVO.getKeyAlg());
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (!ConfigUtil.verifyCurInitStep((Environment)this.environment, (int)1)) {
            this.logger.debug("\u4fdd\u5b58\u521d\u59cb\u5316\u57fa\u672c\u914d\u7f6e\u5931\u8d25\uff0c\u5f53\u524d\u521d\u59cb\u5316\u6b65\u9aa4\u4e3a\uff1a1");
            return ErrorEnum.INIT_STEP_ERROR.resp(resp);
        }
        try {
            X500Name x500Name = DnUtil.getRFC4519X500Name((String)basicConfigVO.getBaseDn());
            basicConfigVO.setBaseDn(x500Name.toString());
        }
        catch (Exception e) {
            this.logger.debug("\u521d\u59cb\u5316CA\u8bc1\u4e66\u5931\u8d25\uff1aDN\u4e0d\u7b26\u5408X500\u89c4\u8303[{}]", (Object)basicConfigVO.getBaseDn());
            return ErrorEnum.DN_FORMAT_FAIL.resp(resp);
        }
        try {
            Result result = this.initService.saveBasicConfig(basicConfigVO);
            this.logger.debug("\u521d\u59cb\u5316\u57fa\u672c\u914d\u7f6e\u4fdd\u5b58\u8bf7\u6c42\u5904\u7406\u5b8c\u6210[{}]", (Object)result);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return Result.success();
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\uff0c\u4fdd\u5b58CA\u57fa\u672c\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/step/{step}"}, method={RequestMethod.PUT})
    public Object reportInitStep(HttpServletResponse resp, @PathVariable Integer step) {
        this.logger.debug("\u6536\u5230\u4e0a\u62a5\u521d\u59cb\u5316\u6b65\u9aa4\u8bf7\u6c42[{}]", (Object)step);
        try {
            Result result = this.initService.reportInitStep(step);
            this.logger.debug("\u4e0a\u62a5\u521d\u59cb\u5316\u6b65\u9aa4\u8bf7\u6c42\u5904\u7406\u5b8c\u6210[{}]", (Object)step);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return Result.success();
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\u4e0a\u62a5\u521d\u59cb\u5316\u6b65\u9aa4\u9519\u8bef");
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/subCa/p10"}, method={RequestMethod.POST})
    public Object createSubCaP10(HttpServletResponse resp, @RequestBody CreateP10VO createP10VO) {
        this.logger.debug("\u6536\u5230\u521d\u59cb\u5316\u5b50CA\u65f6\u751f\u6210\u5b50CA\u8bc1\u4e66\u7533\u8bf7\u4e66\u8bf7\u6c42[{}]");
        if (StringUtils.isBlank((CharSequence)createP10VO.getDn()) || Constants.CRYPT_DEVICE_TYPE == Constants.CRYPT_DEVICE_HSM && (StringUtils.isBlank((CharSequence)createP10VO.getPrivateKeyPin()) || null == createP10VO.getKeyIndex()) || null == createP10VO.getAlgLength()) {
            this.logger.debug("\u751f\u6210\u5b50\u8bc1\u4e66p10\u51fa\u73b0\u7a7a\u53c2\u6570\uff1a" + createP10VO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        createP10VO.setAlg(Constants.BASE_ALG_TYPE);
        try {
            if (!ConfigUtil.verifyCurInitStep((Environment)this.environment, (int)4)) {
                this.logger.debug("\u5f53\u524d\u6b65\u9aa4\u9519\u8bef\uff0c\u670d\u52a1\u5668\u5f53\u524d\u521d\u59cb\u5316\u6b65\u9aa4\u4e3a\uff1a" + ConfigUtil.getCurrInitStep((Environment)this.environment));
                return ErrorEnum.INIT_STEP_ERROR.resp(resp);
            }
            Result result = this.initService.createP10(createP10VO);
            this.logger.debug("\u521d\u59cb\u5316\u5b50CA\u65f6\u751f\u6210\u5b50CA\u8bc1\u4e66\u7533\u8bf7\u4e66\u8bf7\u6c42\u5904\u7406\u7ed3\u675f[{}]", (Object)result);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u5b50\u8bc1\u4e66p10\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditSign
    @RequestMapping(value={"/v1/cert/p10/download/{p10Name}"}, method={RequestMethod.GET})
    public Object downloadSubCaP10(HttpServletResponse resp, @PathVariable String p10Name, AuditSignBean bean) {
        this.logger.debug("\u6536\u5230p10\u4e0b\u8f7d\u8bf7\u6c42\uff0cp10Name=[{}]", (Object)p10Name);
        OutputStream out = null;
        FilterInputStream in = null;
        try {
            p10Name = URLEncoder.encode(p10Name, "UTF-8");
            String suffix = p10Name.contains("ZIP") && Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue() ? ".zip" : ".p10";
            String p10Path = this.configPath + "p10/" + p10Name + suffix;
            File file = new File(p10Path);
            if (!file.exists()) {
                this.logger.debug("\u4e0b\u8f7dP10\u6587\u4ef6\u5931\u8d25\uff0cp10\u6587\u4ef6\u4e0d\u5b58\u5728\uff0cp10\u6587\u4ef6\u8def\u5f84\u4e3a[{}]", (Object)p10Path);
                this.AuditLog(bean, false);
                ErrorBean errorBean = ErrorEnum.P10_NOT_EXIST.resp(resp);
                return errorBean;
            }
            resp.reset();
            resp.setHeader("Content-Disposition", "attachment; filename=" + p10Name + suffix);
            resp.setContentType("application/octet-stream;charset=UTF-8");
            in = new DataInputStream(new FileInputStream(file));
            out = resp.getOutputStream();
            int bytes = 0;
            byte[] bufferOut = new byte[in.available()];
            while ((bytes = ((DataInputStream)in).read(bufferOut)) != -1) {
                out.write(bufferOut, 0, bytes);
            }
            this.logger.debug("p10\u4e0b\u8f7d\u8bf7\u6c42\u5904\u7406\u6210\u529f\uff0cp10Name=[{}]", (Object)p10Name);
            this.AuditLog(bean, true);
            Object var11_15 = null;
            return var11_15;
        }
        catch (Exception e) {
            this.logger.error("\u4e0b\u8f7d\u5b50\u8bc1\u4e66p10\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            this.AuditLog(bean, false);
            ErrorBean errorBean = ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
            return errorBean;
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void AuditLog(AuditSignBean bean, boolean result) {
        StringBuilder content = new StringBuilder();
        if (result) {
            content.append("\u4e0b\u8f7dp10\u6587\u4ef6\u6210\u529f,\u64cd\u4f5c\u8005IP=").append(bean.getIp() + ",\u8bc1\u4e66SN=").append(bean.getSn()).append(",\u5bc6\u94a5\u7b97\u6cd5=").append(bean.getKeyAlg());
            int n = AuditLogResultEnum.SUCCESS.id;
        }
        content.append("\u4e0b\u8f7dp10\u5931\u8d25,\u64cd\u4f5c\u8005IP=").append(bean.getIp() + ",\u8bc1\u4e66SN=").append(bean.getSn()).append(",\u5bc6\u94a5\u7b97\u6cd5=").append(bean.getKeyAlg());
        int loginResult = AuditLogResultEnum.FAIL.id;
        this.logger.info(content.toString());
        try {
            boolean flag = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_IMPORT.type, content.toString(), loginResult, bean.getSign());
            if (!flag) {
                this.logger.error("\u8bb0\u5f55-\u4e0b\u8f7dp10-\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
            }
        }
        catch (Exception e) {
            this.logger.error("\u8bb0\u5f55-\u4e0b\u8f7dp10-\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/v1/init/p10/download/{p10Name}"}, method={RequestMethod.GET})
    public Object downloadInitSubCaP10(HttpServletResponse resp, @PathVariable String p10Name) {
        this.logger.debug("\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\uff0c\u6536\u5230p10\u4e0b\u8f7d\u8bf7\u6c42\uff0cp10Name=[{}]", (Object)p10Name);
        OutputStream out = null;
        FilterInputStream in = null;
        try {
            p10Name = URLEncoder.encode(p10Name, "UTF-8");
            String p10Path = this.configPath + "p10/" + p10Name + ".p10";
            File file = new File(p10Path);
            if (!file.exists()) {
                this.logger.debug("\u4e0b\u8f7dP10\u6587\u4ef6\u5931\u8d25\uff0cp10\u6587\u4ef6\u4e0d\u5b58\u5728\uff0cp10\u6587\u4ef6\u8def\u5f84\u4e3a[{}]", (Object)p10Path);
                ErrorBean errorBean = ErrorEnum.P10_NOT_EXIST.resp(resp);
                return errorBean;
            }
            resp.reset();
            resp.setHeader("Content-Disposition", "attachment; filename=" + p10Name + ".p10");
            resp.setContentType("application/octet-stream;charset=UTF-8");
            in = new DataInputStream(new FileInputStream(file));
            out = resp.getOutputStream();
            int bytes = 0;
            byte[] bufferOut = new byte[in.available()];
            while ((bytes = ((DataInputStream)in).read(bufferOut)) != -1) {
                out.write(bufferOut, 0, bytes);
            }
            this.logger.debug("p10\u4e0b\u8f7d\u8bf7\u6c42\u5904\u7406\u6210\u529f\uff0cp10Name=[{}]", (Object)p10Name);
            Object var9_13 = null;
            return var9_13;
        }
        catch (Exception e) {
            this.logger.error("\u4e0b\u8f7d\u5b50\u8bc1\u4e66p10\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            ErrorBean errorBean = ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
            return errorBean;
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @RequestMapping(value={"/v1/init/subCa/certChain"}, method={RequestMethod.POST})
    public Object importSubCaCert(HttpServletResponse resp, @RequestParam(value="caCertChain") MultipartFile caCertChain) {
        this.logger.debug("\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\uff0c\u6536\u5230\u5b50CA\u8bc1\u4e66\u94fe\u5bfc\u5165\u8bf7\u6c42");
        if (null == caCertChain || 0L == caCertChain.getSize()) {
            this.logger.debug("\u8bc1\u4e66\u94fe\u4e3a\u7a7a");
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            BufferedReader br = null;
            InputStream in = null;
            String pemStr = "";
            in = caCertChain.getInputStream();
            br = new BufferedReader(new InputStreamReader(in));
            while ((pemStr = br.readLine()) != null) {
                stringBuffer.append(pemStr);
            }
            Result result = this.initService.importSubCaChain(stringBuffer.toString());
            this.logger.debug("\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\uff0c\u5b50CA\u8bc1\u4e66\u94fe\u5bfc\u5165\u8bf7\u6c42\u5904\u7406\u7ed3\u675f,result=[{}]", (Object)result);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return Result.success();
        }
        catch (Exception e) {
            this.logger.error("\u5b50CA\u8bc1\u4e66\u94fe\u5bfc\u5165\u5f02\u5e38");
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/step"}, method={RequestMethod.GET})
    public Object getInitStep(HttpServletResponse resp) {
        this.logger.debug("\u6536\u5230\u83b7\u53d6\u521d\u59cb\u5316\u6b65\u9aa4\u8bf7\u6c42");
        try {
            Result result = this.initService.getInitStep();
            this.logger.debug("\u83b7\u53d6\u521d\u59cb\u5316\u6b65\u9aa4\u8bf7\u6c42\u5904\u7406\u7ed3\u675f[{}]", (Object)result);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u521d\u59cb\u5316\u6b65\u9aa4\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/system/recover"}, method={RequestMethod.DELETE})
    public Object systemRecover(HttpServletRequest request, HttpServletResponse resp) {
        try {
            this.logger.info("\u6536\u5230\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\u6062\u590d\u51fa\u5382\u8bbe\u7f6e\u8bf7\u6c42");
            Result result = this.initService.doRecoverSystem();
            this.logger.info("\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\u6062\u590d\u51fa\u5382\u8bbe\u7f6e\u8bf7\u6c42\u5904\u7406\u5b8c\u6210[{}]", (Object)result);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return Result.success();
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u6062\u590d\u51fa\u5382\u8bbe\u7f6e\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/server/restart"}, method={RequestMethod.GET})
    public Object systemRest(HttpServletRequest request, HttpServletResponse resp) {
        this.logger.debug("\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\u6536\u5230\u7cfb\u7edf\u91cd\u542f\u8bf7\u6c42");
        try {
            Result result = this.initService.reportInitStep(Integer.valueOf(11));
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            result = this.initService.resetSystem();
            this.logger.debug("\u521d\u59cb\u5316\u8fc7\u7a0b\u4e2d\u7cfb\u7edf\u91cd\u542f\u8bf7\u6c42\u5904\u7406\u5b8c\u6210[{}]", (Object)result);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u91cd\u542f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }
}

