/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.web;

import com.xdja.pki.ca.auth.annotation.AuditSign;
import com.xdja.pki.ca.auth.service.bean.AuditSignBean;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.common.ConfigUtil;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.configBasic.bean.HsmCertNameBean;
import com.xdja.pki.ca.core.configBasic.bean.KmConfigBean;
import com.xdja.pki.ca.core.enums.CrlPublishEnum;
import com.xdja.pki.ca.core.exception.ServiceException;
import com.xdja.pki.ca.core.util.CertUtils;
import com.xdja.pki.ca.crl.util.CrlThreadUtil;
import com.xdja.pki.ca.hsm.manager.HsmManager;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogOperatorTypeEnum;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogResultEnum;
import com.xdja.pki.ca.securityaudit.service.log.AuditLogService;
import com.xdja.pki.ca.securitymanager.service.init.InitService;
import com.xdja.pki.ca.securitymanager.service.init.SystemConfigService;
import com.xdja.pki.ca.securitymanager.service.vo.CreateP10VO;
import com.xdja.pki.ca.securitymanager.service.vo.CrlConfigVO;
import com.xdja.pki.ca.securitymanager.service.vo.LdapConfigVO;
import com.xdja.pki.ca.securitymanager.service.vo.OcspConfigVO;
import java.io.FileInputStream;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class SystemConfigController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private Environment environment;
    @Autowired
    private HsmManager hsmService;
    @Autowired
    private InitService initService;
    @Autowired
    private AuditLogService auditLogService;
    @Autowired
    private CrlThreadUtil crlThreadUtil;

    @RequestMapping(value={"/v1/config/base"}, method={RequestMethod.GET})
    public Object getBaseConfig(HttpServletResponse resp) {
        try {
            Result result = this.systemConfigService.getBaseConfig();
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u57fa\u672c\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/config/ldap"}, method={RequestMethod.POST})
    public Object saveLdapConfig(HttpServletResponse resp, @RequestBody LdapConfigVO ldapConfigVo) {
        try {
            if (!ConfigUtil.verifyCurInitStep((Environment)this.environment, (int)6)) {
                this.logger.debug("\u5f53\u524d\u6b65\u9aa4\u9519\u8bef\uff0c\u670d\u52a1\u5668\u5f53\u524d\u521d\u59cb\u5316\u6b65\u9aa4\u4e3a\uff1a" + ConfigUtil.getCurrInitStep((Environment)this.environment));
                return Result.failure((ErrorEnum)ErrorEnum.INIT_STEP_ERROR);
            }
            Result result = this.systemConfigService.saveLdapConfig(ldapConfigVo);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return Result.success();
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58ldap\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/config/ldap"}, method={RequestMethod.POST})
    public Object saveConfigLdap(HttpServletResponse resp, @RequestBody LdapConfigVO ldapConfigVo, AuditSignBean bean) {
        if (StringUtils.isBlank((CharSequence)ldapConfigVo.getMasterURL()) || StringUtils.isBlank((CharSequence)ldapConfigVo.getSlaveURL())) {
            this.logger.debug("\u4fdd\u5b58ldap\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u7a7a\u53c2\u6570\uff1a" + ldapConfigVo);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        StringBuffer content = new StringBuffer();
        try {
            int execResult;
            Result result = this.systemConfigService.saveLdapConfig(ldapConfigVo);
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("LDAP\u670d\u52a1\u5668\u914d\u7f6e\u6210\u529f,\u4e3b\u76ee\u5f55\u670d\u52a1\u5668URL=").append(ldapConfigVo.getMasterURL()).append(",\u4ece\u76ee\u5f55\u670d\u52a1\u5668URL=").append(ldapConfigVo.getSlaveURL());
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("LDAP\u670d\u52a1\u5668\u914d\u7f6e\u5931\u8d25,\u4e3b\u76ee\u5f55\u670d\u52a1\u5668URL=").append(ldapConfigVo.getMasterURL()).append(",\u4ece\u76ee\u5f55\u670d\u52a1\u5668URL=").append(ldapConfigVo.getSlaveURL());
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.SYSTEM_CONFIG_UPDATE.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55LDAP\u670d\u52a1\u5668\u914d\u7f6e\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55LDAP\u670d\u52a1\u5668\u914d\u7f6e\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return Result.success();
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58ldap\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/config/ldap"}, method={RequestMethod.GET})
    public Object getLdapConfig(HttpServletResponse resp) {
        try {
            Result result = this.systemConfigService.getLdapConfig();
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6ldap\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/config/crl"}, method={RequestMethod.GET})
    public Object getCrlConfig(HttpServletResponse resp) {
        try {
            Result result = this.systemConfigService.getCrlConfig();
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58ldap\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/config/crl"}, method={RequestMethod.POST})
    public Object saveCrlConfig(HttpServletResponse resp, @RequestBody CrlConfigVO crlConfigVO) {
        if (null == crlConfigVO.getCertCounts() || null == crlConfigVO.getReleaseCycle() || crlConfigVO.isDelta() && null == crlConfigVO.getDeltaCrlCycle()) {
            this.logger.debug("\u4fdd\u5b58crl\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u7a7a\u53c2\u6570\uff1a" + crlConfigVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            if (!ConfigUtil.verifyCurInitStep((Environment)this.environment, (int)8)) {
                this.logger.debug("\u5f53\u524d\u6b65\u9aa4\u9519\u8bef\uff0c\u670d\u52a1\u5668\u5f53\u524d\u521d\u59cb\u5316\u6b65\u9aa4\u4e3a\uff1a" + ConfigUtil.getCurrInitStep((Environment)this.environment));
                return ErrorEnum.INIT_STEP_ERROR.resp(resp);
            }
            Result result = this.systemConfigService.saveCrlConfig(crlConfigVO);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return Result.success();
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58crl\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/config/crl"}, method={RequestMethod.PUT})
    public Object updateConfigCrl(HttpServletResponse resp, @RequestBody CrlConfigVO crlConfigVO, AuditSignBean bean) {
        if (null == crlConfigVO.getCertCounts() || null == crlConfigVO.getReleaseCycle() || crlConfigVO.isDelta() && null == crlConfigVO.getDeltaCrlCycle()) {
            this.logger.debug("\u4fdd\u5b58crl\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u7a7a\u53c2\u6570\uff1a" + crlConfigVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        if (null != crlConfigVO.getCrlPublish() && CrlPublishEnum.isHttpCRL((Integer)crlConfigVO.getCrlPublish()) && (StringUtils.isBlank((CharSequence)crlConfigVO.getCrlLocalDirectory()) || StringUtils.isBlank((CharSequence)crlConfigVO.getCrlRemoteURL()))) {
            this.logger.debug("crl\u53d1\u5e03\u914d\u7f6e\u4e3ahttp\u65b9\u5f0f\u51fa\u73b0\u7a7a\u53c2\u6570\uff1a" + crlConfigVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            int execResult;
            Result result = this.systemConfigService.updateCrlConfig(crlConfigVO);
            Constants.IS_CRL_AGAIN_FIRST = true;
            if (crlConfigVO.isDelta()) {
                Constants.IS_DRL_AGAIN_FIRST = true;
            }
            this.crlThreadUtil.run(new String[0]);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("CRL\u53d1\u5e03\u4fe1\u606f\u914d\u7f6e\u66f4\u65b0\u6210\u529f,CRL\u53d1\u5e03\u5468\u671f:").append(crlConfigVO.getReleaseCycle()).append(",\u662f\u5426\u53d1\u5e03\u589e\u91cfCRL:").append(crlConfigVO.isDelta()).append(",\u589e\u91cfCRL\u53d1\u5e03\u5468\u671f:").append(crlConfigVO.getDeltaCrlCycle());
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("CRL\u53d1\u5e03\u4fe1\u606f\u914d\u7f6e\u66f4\u65b0\u5931\u8d25,CRL\u53d1\u5e03\u5468\u671f:").append(crlConfigVO.getReleaseCycle()).append(",\u662f\u5426\u53d1\u5e03\u589e\u91cfCRL:").append(crlConfigVO.isDelta()).append(",\u589e\u91cfCRL\u53d1\u5e03\u5468\u671f:").append(crlConfigVO.getDeltaCrlCycle());
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.SYSTEM_CONFIG_UPDATE.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55CRL\u53d1\u5e03\u4fe1\u606f\u914d\u7f6e\u66f4\u65b0\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55CRL\u53d1\u5e03\u4fe1\u606f\u914d\u7f6e\u66f4\u65b0\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return Result.success();
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58crl\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/config/ocsp"}, method={RequestMethod.POST})
    public Object saveOcspConfig(HttpServletResponse resp, @RequestBody OcspConfigVO ocspConfigVO) {
        try {
            if (!ConfigUtil.verifyCurInitStep((Environment)this.environment, (int)7)) {
                this.logger.debug("\u5f53\u524d\u6b65\u9aa4\u9519\u8bef\uff0c\u670d\u52a1\u5668\u5f53\u524d\u521d\u59cb\u5316\u6b65\u9aa4\u4e3a\uff1a" + ConfigUtil.getCurrInitStep((Environment)this.environment));
                return ErrorEnum.INIT_STEP_ERROR.resp(resp);
            }
            Result result = this.systemConfigService.saveOcspConfig(ocspConfigVO);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return Result.success();
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58ldap\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/config/ocsp"}, method={RequestMethod.POST})
    public Object saveConfigOcsp(HttpServletResponse resp, @RequestBody OcspConfigVO ocspConfigVO, AuditSignBean bean) {
        if (StringUtils.isBlank((CharSequence)ocspConfigVO.getInterURL()) || StringUtils.isBlank((CharSequence)ocspConfigVO.getNetworkURL())) {
            this.logger.debug("\u4fdd\u5b58ocsp\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u7a7a\u53c2\u6570\uff1a" + ocspConfigVO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            int execResult;
            Result result = this.systemConfigService.saveOcspConfig(ocspConfigVO);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("OCSP\u670d\u52a1\u5668\u914d\u7f6e\u6210\u529f,\u5185\u7f51\u8bbf\u95eeURL=").append(ocspConfigVO.getInterURL()).append(",\u5916\u7f51\u8bbf\u95eeURL=").append(ocspConfigVO.getNetworkURL());
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("OCSP\u670d\u52a1\u5668\u914d\u7f6e\u5931\u8d25,\u5185\u7f51\u8bbf\u95eeURL=").append(ocspConfigVO.getInterURL()).append(",\u5916\u7f51\u8bbf\u95eeURL=").append(ocspConfigVO.getNetworkURL());
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.SYSTEM_CONFIG_UPDATE.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u8bb0\u5f55OCSP\u670d\u52a1\u5668\u914d\u7f6e\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55OCSP\u670d\u52a1\u5668\u914d\u7f6e\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return Result.success();
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58ocsp\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/config/ocsp"}, method={RequestMethod.GET})
    public Object getOcspConfig(HttpServletResponse resp) {
        try {
            Result result = this.systemConfigService.getOcspConfig();
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58ldap\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/hsm"}, method={RequestMethod.POST})
    public Object saveHsmConfig(HttpServletResponse resp, @RequestParam(value="ip") String ip, @RequestParam(value="port") Integer port, @RequestParam(value="signCert") MultipartFile signCert, @RequestParam(value="signCertPwd") String signCertPwd, @RequestParam(value="encCert") MultipartFile encCert, @RequestParam(value="encCertPwd") String encCertPwd, @RequestParam(value="hsmCaChain") MultipartFile hsmCaChain) {
        if (StringUtils.isBlank((CharSequence)ip) || null == port || 0L == signCert.getSize() || 0L == encCert.getSize() || StringUtils.isBlank((CharSequence)signCertPwd) || StringUtils.isBlank((CharSequence)encCertPwd) || 0L == hsmCaChain.getSize()) {
            this.logger.debug("\u914d\u7f6e\u5bc6\u7801\u673a\u51fa\u73b0\u7a7a\u53c2\u6570");
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        if (!ConfigUtil.verifyCurInitStep((Environment)this.environment, (int)2)) {
            this.logger.debug("\u4fdd\u5b58\u5bc6\u7801\u673a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff0c\u5f53\u524d\u521d\u59cb\u5316\u6b65\u9aa4\u4e3a\uff1a1");
            return ErrorEnum.INIT_STEP_ERROR.resp(resp);
        }
        try {
            HsmCertNameBean hsmCertNameBean = new HsmCertNameBean(ip, port, signCertPwd, encCertPwd);
            hsmCertNameBean.setSignCert(CertUtils.getNameByPath((String)signCert.getOriginalFilename()));
            hsmCertNameBean.setEncCert(CertUtils.getNameByPath((String)encCert.getOriginalFilename()));
            hsmCertNameBean.setHsmCaChain(CertUtils.getNameByPath((String)hsmCaChain.getOriginalFilename()));
            FileInputStream inputSign = (FileInputStream)signCert.getInputStream();
            FileInputStream inputEnc = (FileInputStream)encCert.getInputStream();
            FileInputStream inputCertChain = (FileInputStream)hsmCaChain.getInputStream();
            Result result = this.hsmService.testAndSaveHsmConfig(hsmCertNameBean, inputSign, inputEnc, inputCertChain);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            Constants.CRYPT_DEVICE_TYPE = Constants.CRYPT_DEVICE_HSM;
            return this.initService.reportInitStep(Integer.valueOf(2));
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u5bc6\u7801\u673a\u914d\u7f6e\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/init/hsm"}, method={RequestMethod.DELETE})
    public Object deleteHsm(HttpServletResponse resp) {
        if (!ConfigUtil.verifyCurInitStep((Environment)this.environment, (int)2)) {
            this.logger.debug("\u4fdd\u5b58\u5bc6\u7801\u673a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff0c\u5f53\u524d\u521d\u59cb\u5316\u6b65\u9aa4\u4e3a\uff1a1");
            return ErrorEnum.INIT_STEP_ERROR.resp(resp);
        }
        Constants.CRYPT_DEVICE_TYPE = Constants.CRYPT_DEVICE_BC;
        return this.initService.reportInitStep(Integer.valueOf(2));
    }

    @RequestMapping(value={"/v1/init/hsm/status"}, method={RequestMethod.POST})
    public Object testHsmConnect(HttpServletResponse resp, @RequestParam(value="ip") String ip, @RequestParam(value="port") Integer port, @RequestParam(value="signCert") MultipartFile signCert, @RequestParam(value="signCertPwd") String signCertPwd, @RequestParam(value="encCert") MultipartFile encCert, @RequestParam(value="encCertPwd") String encCertPwd, @RequestParam(value="hsmCaChain") MultipartFile hsmCaChain) {
        if (StringUtils.isBlank((CharSequence)ip) || null == port || 0L == signCert.getSize() || 0L == encCert.getSize() || StringUtils.isBlank((CharSequence)signCertPwd) || StringUtils.isBlank((CharSequence)encCertPwd) || 0L == hsmCaChain.getSize()) {
            this.logger.debug("\u914d\u7f6e\u5bc6\u7801\u673a\u51fa\u73b0\u7a7a\u53c2\u6570");
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        if (!ConfigUtil.verifyCurInitStep((Environment)this.environment, (int)2)) {
            this.logger.debug("\u6d4b\u8bd5\u5bc6\u7801\u673a\u8fde\u901a\u6027\u5931\u8d25\uff0c\u5f53\u524d\u521d\u59cb\u5316\u6b65\u9aa4\u4e3a\uff1a1");
            return ErrorEnum.INIT_STEP_ERROR.resp(resp);
        }
        try {
            HsmCertNameBean hsmCertNameBean = new HsmCertNameBean(ip, port, signCertPwd, encCertPwd);
            hsmCertNameBean.setSignCert(CertUtils.getNameByPath((String)signCert.getOriginalFilename()));
            hsmCertNameBean.setEncCert(CertUtils.getNameByPath((String)encCert.getOriginalFilename()));
            hsmCertNameBean.setHsmCaChain(CertUtils.getNameByPath((String)hsmCaChain.getOriginalFilename()));
            FileInputStream inputSign = (FileInputStream)signCert.getInputStream();
            FileInputStream inputEnc = (FileInputStream)encCert.getInputStream();
            FileInputStream inputCertChain = (FileInputStream)hsmCaChain.getInputStream();
            Result result = this.hsmService.testAndSaveHsmConfig(hsmCertNameBean, inputSign, inputEnc, inputCertChain);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return Result.success();
        }
        catch (Exception e) {
            this.logger.error("\u6d4b\u8bd5\u5bc6\u7801\u673a\u8fde\u901a\u6027\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/config/hsm/status"}, method={RequestMethod.POST})
    public Object testConfigHsmConnect(HttpServletResponse resp, @RequestParam(value="ip") String ip, @RequestParam(value="port") Integer port, @RequestParam(value="signCert", required=false) MultipartFile signCert, @RequestParam(value="signCertPwd") String signCertPwd, @RequestParam(value="encCert", required=false) MultipartFile encCert, @RequestParam(value="encCertPwd") String encCertPwd, @RequestParam(value="hsmCaChain", required=false) MultipartFile hsmCaChain) {
        if (StringUtils.isBlank((CharSequence)ip) || null == port || StringUtils.isBlank((CharSequence)encCertPwd) || StringUtils.isBlank((CharSequence)signCertPwd)) {
            this.logger.debug("\u914d\u7f6e\u5bc6\u7801\u673a\u51fa\u73b0\u7a7a\u53c2\u6570");
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            HsmCertNameBean hsmCertNameBean = new HsmCertNameBean(ip, port, signCertPwd, encCertPwd);
            FileInputStream inputSign = null;
            FileInputStream inputEnc = null;
            FileInputStream inputCertChain = null;
            try {
                if (null != signCert && 0L != signCert.getSize()) {
                    hsmCertNameBean.setSignCert(CertUtils.getNameByPath((String)signCert.getOriginalFilename()));
                    inputSign = (FileInputStream)signCert.getInputStream();
                }
                if (null != encCert && 0L != encCert.getSize()) {
                    hsmCertNameBean.setEncCert(CertUtils.getNameByPath((String)encCert.getOriginalFilename()));
                    inputEnc = (FileInputStream)encCert.getInputStream();
                }
                if (null != hsmCaChain && 0L != hsmCaChain.getSize()) {
                    hsmCertNameBean.setHsmCaChain(CertUtils.getNameByPath((String)hsmCaChain.getOriginalFilename()));
                    inputCertChain = (FileInputStream)hsmCaChain.getInputStream();
                }
            }
            catch (Exception e) {
                throw new ServiceException("\u8bc1\u4e66\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            }
            Result result = this.hsmService.testHsmConfig(hsmCertNameBean, inputSign, inputEnc, inputCertChain);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return Result.success();
        }
        catch (Exception e) {
            this.logger.error("\u6d4b\u8bd5\u5bc6\u7801\u673a\u8fde\u901a\u6027\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/config/hsm"}, method={RequestMethod.POST})
    public Object updateConfigHsm(HttpServletResponse resp, @RequestParam(value="ip") String ip, @RequestParam(value="port") Integer port, @RequestParam(value="signCert", required=false) MultipartFile signCert, @RequestParam(value="signCertPwd") String signCertPwd, @RequestParam(value="encCert", required=false) MultipartFile encCert, @RequestParam(value="encCertPwd") String encCertPwd, @RequestParam(value="hsmCaChain", required=false) MultipartFile hsmCaChain, AuditSignBean bean) {
        if (StringUtils.isBlank((CharSequence)ip) || null == port || StringUtils.isBlank((CharSequence)encCertPwd) || StringUtils.isBlank((CharSequence)signCertPwd)) {
            this.logger.debug("\u914d\u7f6e\u5bc6\u7801\u673a\u51fa\u73b0\u7a7a\u53c2\u6570");
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        FileInputStream inputSign = null;
        FileInputStream inputEnc = null;
        FileInputStream inputCertChain = null;
        try {
            int execResult;
            HsmCertNameBean hsmCertNameBean = new HsmCertNameBean(ip, port, signCertPwd, encCertPwd);
            if (null != signCert && 0L != signCert.getSize()) {
                inputSign = (FileInputStream)signCert.getInputStream();
                hsmCertNameBean.setSignCert(CertUtils.getNameByPath((String)signCert.getOriginalFilename()));
            }
            if (null != encCert && 0L != encCert.getSize()) {
                inputEnc = (FileInputStream)encCert.getInputStream();
                hsmCertNameBean.setEncCert(CertUtils.getNameByPath((String)encCert.getOriginalFilename()));
            }
            if (null != hsmCaChain && 0L != hsmCaChain.getSize()) {
                inputCertChain = (FileInputStream)hsmCaChain.getInputStream();
                hsmCertNameBean.setHsmCaChain(CertUtils.getNameByPath((String)hsmCaChain.getOriginalFilename()));
            }
            Result result = this.hsmService.testAndSaveHsmConfig(hsmCertNameBean, inputSign, inputEnc, inputCertChain);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u66f4\u65b0\u5bc6\u7801\u673a\u914d\u7f6e\u6210\u529f,ip:").append(ip).append(",port:").append(port).append(",signCertPwd:").append(signCertPwd).append(",encCertPwd").append(encCertPwd);
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("\u66f4\u65b0\u5bc6\u7801\u673a\u914d\u7f6e\u5931\u8d25,ip:").append(ip).append(",port:").append(port).append(",signCertPwd:").append(signCertPwd).append(",encCertPwd").append(encCertPwd);
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.SYSTEM_CONFIG_UPDATE.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u66f4\u65b0\u5bc6\u7801\u673a\u914d\u7f6e\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u66f4\u65b0\u5bc6\u7801\u673a\u914d\u7f6e\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u5bc6\u7801\u673a\u914d\u7f6e\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/config/hsm"}, method={RequestMethod.GET})
    public Object getConfigHsm(HttpServletResponse resp) {
        try {
            Result result = this.hsmService.getHsmConfig();
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5bc6\u7801\u673a\u914d\u7f6e\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/config/km"}, method={RequestMethod.POST})
    public Object saveConfigKm(HttpServletResponse resp, @RequestParam(value="kmCaCert") MultipartFile kmCaCert, @RequestParam(value="kmCommCert") MultipartFile kmCommCert, @RequestParam(value="ip") String ip, @RequestParam(value="port") Integer port) {
        if (StringUtils.isBlank((CharSequence)ip) || null == port) {
            this.logger.debug("\u4fdd\u5b58KM\u914d\u7f6e\u51fa\u73b0\u7a7a\u53c2\u6570");
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            KmConfigBean tmpKmConfigBean = ConfigUtil.getTmpKmConfig((Environment)this.environment);
            if (null == tmpKmConfigBean || StringUtils.isBlank((CharSequence)tmpKmConfigBean.getPrivateKeyPin())) {
                this.logger.error("\u8bc1\u4e66\u5bf9\u5e94\u5bc6\u94a5\u4e0d\u5b58\u5728");
                return Result.failure((ErrorEnum)ErrorEnum.PUBLIC_KEY_IS_NOT_MATCH_ERROR);
            }
            tmpKmConfigBean.setKmCommCertName(CertUtils.getNameByPath((String)kmCommCert.getOriginalFilename()));
            tmpKmConfigBean.setKmCaCertName(CertUtils.getNameByPath((String)kmCaCert.getOriginalFilename()));
            tmpKmConfigBean.setIp(ip);
            tmpKmConfigBean.setPort(port);
            FileInputStream kmCa = (FileInputStream)kmCaCert.getInputStream();
            FileInputStream kmComm = (FileInputStream)kmCommCert.getInputStream();
            Result result = this.systemConfigService.importKmConfig(kmCa, kmComm, tmpKmConfigBean);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5bc6\u7801\u673a\u914d\u7f6e\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/config/km/update"}, method={RequestMethod.POST})
    public Object updateConfigKm(HttpServletResponse resp, @RequestParam(value="kmCaCert", required=false) MultipartFile kmCaCert, @RequestParam(value="kmCommCert", required=false) MultipartFile kmCommCert, @RequestParam(value="ip") String ip, @RequestParam(value="port") Integer port, AuditSignBean bean) {
        if (StringUtils.isBlank((CharSequence)ip) || null == port) {
            this.logger.debug("\u4fdd\u5b58KM\u914d\u7f6e\u51fa\u73b0\u7a7a\u53c2\u6570");
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            int execResult;
            FileInputStream kmCa = null;
            FileInputStream kmComm = null;
            KmConfigBean tmpKmConfigBean = ConfigUtil.getTmpKmConfig((Environment)this.environment);
            if (null == tmpKmConfigBean || StringUtils.isBlank((CharSequence)tmpKmConfigBean.getPrivateKeyPin())) {
                this.logger.error("\u8bc1\u4e66\u5bf9\u5e94\u5bc6\u94a5\u4e0d\u5b58\u5728");
                return Result.failure((ErrorEnum)ErrorEnum.PUBLIC_KEY_IS_NOT_MATCH_ERROR);
            }
            if (null != kmCaCert && 0L != kmCaCert.getSize()) {
                tmpKmConfigBean.setKmCaCertName(CertUtils.getNameByPath((String)kmCaCert.getOriginalFilename()));
                kmCa = (FileInputStream)kmCaCert.getInputStream();
            }
            if (null != kmCommCert && 0L != kmCommCert.getSize()) {
                kmComm = (FileInputStream)kmCommCert.getInputStream();
                tmpKmConfigBean.setKmCommCertName(CertUtils.getNameByPath((String)kmCommCert.getOriginalFilename()));
            }
            tmpKmConfigBean.setIp(ip);
            tmpKmConfigBean.setPort(port);
            Result result = this.systemConfigService.importKmConfig(kmCa, kmComm, tmpKmConfigBean);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u66f4\u65b0\u5bc6\u7ba1\u7cfb\u7edf\u914d\u7f6e\u6210\u529f,ip:").append(ip).append(",port:").append(port);
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("\u66f4\u65b0\u5bc6\u7ba1\u7cfb\u7edf\u914d\u7f6e\u5931\u8d25,ip:").append(ip).append(",port:").append(port);
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.SYSTEM_CONFIG_UPDATE.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u66f4\u65b0\u5bc6\u7ba1\u7cfb\u7edf\u914d\u7f6e\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u66f4\u65b0\u5bc6\u7ba1\u7cfb\u7edf\u914d\u7f6e\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5bc6\u7ba1\u7cfb\u7edf\u914d\u7f6e\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/config/km"}, method={RequestMethod.GET})
    public Object getConfigKm(HttpServletResponse resp) {
        try {
            Result result = this.systemConfigService.getKmConfig();
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6KM\u914d\u7f6e\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/config/km/test"}, method={RequestMethod.POST})
    public Object testConfigKm(HttpServletResponse resp, @RequestBody Map<String, Object> map) {
        if (null == map || null == map.get("ip") || null == map.get("port")) {
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        String ip = map.get("ip").toString();
        Integer port = Integer.valueOf(map.get("port").toString());
        try {
            Result result = this.systemConfigService.testKmConfig(ip, port);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6KM\u914d\u7f6e\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/config/km/p10"}, method={RequestMethod.POST})
    public Object getConfigKmP10(HttpServletResponse resp, @RequestBody CreateP10VO createP10VO, AuditSignBean bean) {
        createP10VO.setDn(createP10VO.getSslDn());
        if (StringUtils.isBlank((CharSequence)createP10VO.getDn())) {
            this.logger.debug("\u751f\u6210KM\u8bc1\u4e66\u7533\u8bf7\u4e66\u65f6\u51fa\u73b0\u7a7a\u53c2\u6570\uff1a" + createP10VO);
            return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
        }
        try {
            int execResult;
            Result result = this.systemConfigService.genKmP10(createP10VO);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue()) {
                    content.append("\u5bc6\u7ba1\u7cfb\u7edfp10\u751f\u6210\u6210\u529f,dn:").append(createP10VO.getDn());
                } else {
                    content.append("\u5bc6\u7ba1\u7cfb\u7edfp10\u751f\u6210\u6210\u529f,dn:").append(createP10VO.getDn()).append(",keyIndex:").append(createP10VO.getKeyIndex()).append(",privateKeyPin:").append(createP10VO.getPrivateKeyPin());
                }
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_BC.intValue()) {
                    content.append("\u5bc6\u7ba1\u7cfb\u7edfp10\u751f\u6210\u5931\u8d25,dn:");
                } else {
                    content.append("\u5bc6\u7ba1\u7cfb\u7edfp10\u751f\u6210\u5931\u8d25,dn:").append(createP10VO.getDn()).append(",keyIndex:").append(createP10VO.getKeyIndex()).append(",privateKeyPin:").append(createP10VO.getPrivateKeyPin());
                }
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.SYSTEM_CONFIG_UPDATE.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u5bc6\u7ba1\u7cfb\u7edfp10\u751f\u6210\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u5bc6\u7ba1\u7cfb\u7edfp10\u751f\u6210\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5bc6\u7801\u673a\u914d\u7f6e\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/config/km/init"}, method={RequestMethod.POST})
    public Object testConfigKmInit(HttpServletResponse resp) {
        try {
            Result result = this.systemConfigService.testConfigKmInit();
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u5bc6\u7801\u673a\u914d\u7f6e\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/system/ca/config/xdjakm"}, method={RequestMethod.POST})
    public Object saveConfigXdjaKm(@RequestParam(value="sslSignCert", required=false) MultipartFile sslSignCert, @RequestParam(value="sslEncCert", required=false) MultipartFile sslEncCert, @RequestParam(value="localSignCert", required=false) MultipartFile localSignCert, @RequestParam(value="localEncCert", required=false) MultipartFile localEncCert, @RequestParam(value="kmServerSignCert", required=false) MultipartFile kmServerSignCert, @RequestParam(value="kmServerEncCert", required=false) MultipartFile kmServerEncCert, @RequestParam(value="kmIp") String kmIp, @RequestParam(value="kmPort") int kmPort, @RequestParam(value="kmTrustCert", required=false) MultipartFile kmTrustCert, @RequestParam(value="keyIndex", required=false) Integer keyIndex, @RequestParam(value="priKeyPwd", required=false) String priKeyPwd, AuditSignBean bean, HttpServletResponse resp) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{kmIp}) || kmPort < 1) {
            this.logger.info("\u914d\u7f6ekm\u5bfc\u5165\u53c2\u6570\u6709\u8bef\u6216\u4e3a\u7a7a");
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_HSM.intValue() && (StringUtils.isBlank((CharSequence)priKeyPwd) || keyIndex < 1 || keyIndex > 30)) {
            this.logger.info("\u914d\u7f6ekm\u5bfc\u5165\u53c2\u6570\u6709\u8bef\u6216\u4e3a\u7a7a");
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            int execResult;
            Result result = this.systemConfigService.saveXdjaKmConfig(keyIndex, priKeyPwd, kmIp, kmPort, localSignCert, localEncCert, kmServerSignCert, kmServerEncCert, kmTrustCert, sslSignCert, sslEncCert);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u914d\u7f6exdja\u5bc6\u7ba1\u7cfb\u7edf\u914d\u7f6e\u6210\u529f,ip:").append(kmIp).append(",port:").append(kmPort);
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("\u914d\u7f6exdja\u5bc6\u7ba1\u7cfb\u7edf\u914d\u7f6e\u5931\u8d25,ip:").append(kmIp).append(",port:").append(kmPort);
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.SYSTEM_CONFIG_UPDATE.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u914d\u7f6exdja\u5bc6\u7ba1\u7cfb\u7edf\u914d\u7f6e\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u914d\u7f6exdja\u5bc6\u7ba1\u7cfb\u7edf\u914d\u7f6e\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u914d\u7f6e\u4fe1\u5927\u6377\u5b89km\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/system/ca/config/xdjakm"}, method={RequestMethod.GET})
    public Object getConfigXdjaKm(HttpServletResponse resp) {
        try {
            Result result = this.systemConfigService.getXdjaKmConfig();
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4fe1\u5927\u6377\u5b89km\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/system/ca/config/km/{kmType}"}, method={RequestMethod.POST})
    public Object chooseKmSystem(@PathVariable int kmType, AuditSignBean bean, HttpServletResponse resp) {
        if (kmType != 1 && kmType != 2) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            int execResult;
            Result result = this.systemConfigService.chooseKmSystem(kmType);
            StringBuffer content = new StringBuffer();
            if (result.isSuccess()) {
                execResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u9009\u62e9\u5bc6\u7ba1\u7cfb\u7edf\u6210\u529f,kmType:").append(kmType);
            } else {
                execResult = AuditLogResultEnum.FAIL.id;
                content.append("\u9009\u62e9\u5bc6\u7ba1\u7cfb\u7edf\u5931\u8d25,kmType:").append(kmType);
            }
            this.logger.info(content.toString());
            try {
                boolean falg = this.auditLogService.save(AuditLogOperatorTypeEnum.SYSTEM_CONFIG_UPDATE.type, content.toString(), execResult, bean.getSign());
                if (!falg) {
                    this.logger.error("\u9009\u62e9\u5bc6\u7ba1\u7cfb\u7edf\u914d\u7f6e\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u9009\u62e9\u5bc6\u7ba1\u7cfb\u7edf\u914d\u7f6e\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u9009\u62e9km\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/system/ca/config/km"}, method={RequestMethod.GET})
    public Object getKmSystemType(HttpServletResponse resp) {
        try {
            Result result = this.systemConfigService.getKmSystemType();
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7cfb\u7edf\u6240\u9009\u62e9\u7684km\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/system/ca/config/xdjakm/connection"}, method={RequestMethod.POST})
    public Object testConfigXdjaKmConnection(@RequestParam(value="sslSignCert", required=false) MultipartFile sslSignCert, @RequestParam(value="sslEncCert", required=false) MultipartFile sslEncCert, @RequestParam(value="localSignCert", required=false) MultipartFile localSignCert, @RequestParam(value="localEncCert", required=false) MultipartFile localEncCert, @RequestParam(value="kmServerSignCert", required=false) MultipartFile kmServerSignCert, @RequestParam(value="kmServerEncCert", required=false) MultipartFile kmServerEncCert, @RequestParam(value="kmIp") String kmIp, @RequestParam(value="kmPort") int kmPort, @RequestParam(value="kmTrustCert", required=false) MultipartFile kmTrustCert, @RequestParam(value="keyIndex", required=false) Integer keyIndex, @RequestParam(value="priKeyPwd", required=false) String priKeyPwd, AuditSignBean bean, HttpServletResponse resp) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{kmIp}) || kmPort < 1) {
            this.logger.info("\u914d\u7f6ekm\u5bfc\u5165\u53c2\u6570\u6709\u8bef\u6216\u4e3a\u7a7a");
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        if (Constants.CRYPT_DEVICE_TYPE.intValue() == Constants.CRYPT_DEVICE_HSM.intValue() && (StringUtils.isBlank((CharSequence)priKeyPwd) || keyIndex < 1 || keyIndex > 30)) {
            this.logger.info("\u914d\u7f6ekm\u5bfc\u5165\u53c2\u6570\u6709\u8bef\u6216\u4e3a\u7a7a");
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            Result result = this.systemConfigService.testXdjaKmConfigConnection(keyIndex, priKeyPwd, kmIp, kmPort, localSignCert, localEncCert, kmServerSignCert, kmServerEncCert, kmTrustCert, sslSignCert, sslEncCert);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            this.logger.debug("\u6d4b\u8bd5KM\u8fde\u901a\u6027\u8fd4\u56de\uff1a" + result.getInfo());
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u6d4b\u8bd5\u4fe1\u5927\u6377\u5b89km\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }
}

