/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ca.securitymanager.web.localca;

import com.xdja.pki.ca.auth.annotation.AuditSign;
import com.xdja.pki.ca.auth.service.bean.AuditSignBean;
import com.xdja.pki.ca.certmanager.service.racert.bean.CertTypeEnum;
import com.xdja.pki.ca.core.Constants;
import com.xdja.pki.ca.core.common.ErrorEnum;
import com.xdja.pki.ca.core.common.Result;
import com.xdja.pki.ca.core.util.TomcatUtil;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogOperatorTypeEnum;
import com.xdja.pki.ca.securityaudit.service.bean.AuditLogResultEnum;
import com.xdja.pki.ca.securityaudit.service.log.AuditLogService;
import com.xdja.pki.ca.securitymanager.service.localca.LocalCaService;
import com.xdja.pki.ca.securitymanager.service.vo.CreateP10VO;
import com.xdja.pki.ca.securitymanager.service.vo.UpdateRootCertVO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class LocalCaController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private LocalCaService localCaService;
    @Autowired
    private AuditLogService auditLogService;

    @RequestMapping(value={"/v1/cert/ca/history"}, method={RequestMethod.GET})
    public Object getLocalCaHistoryList(Integer pageNo, Integer pageSize, HttpServletResponse resp) {
        this.logger.info("\u672c\u673aCA\u8bc1\u4e66\u7ba1\u7406\u6a21\u5757>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u5f00\u59cb\u83b7\u53d6\u672c\u673aCA\u5386\u53f2\u8bc1\u4e66");
        try {
            Result result = this.localCaService.getLocalCaHistoryList(pageNo, pageSize);
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u67e5\u8be2\u672c\u673aCA\u5386\u53f2\u8bc1\u4e66\u5217\u8868\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/cert/rootca"}, method={RequestMethod.GET})
    public Object getRootCertDetail(HttpServletRequest request, HttpServletResponse resp) {
        this.logger.info("\u672c\u673aCA\u8bc1\u4e66\u7ba1\u7406\u6a21\u5757>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u5f00\u59cb\u83b7\u53d6\u6839CA\u8be6\u60c5");
        try {
            Result result = this.localCaService.getRootCertDetail();
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6839CA\u8be6\u60c5\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/cert/subca/p10"}, method={RequestMethod.POST})
    public Object createP10(@Valid @RequestBody CreateP10VO createP10VO, AuditSignBean bean, BindingResult bindingResult, HttpServletResponse resp) {
        this.logger.info("\u672c\u673aCA\u8bc1\u4e66\u7ba1\u7406\u6a21\u5757>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u751f\u6210\u5b50CA\u7533\u8bf7\u4e66");
        if (null == createP10VO || bindingResult.hasErrors()) {
            this.logger.debug("\u751f\u6210\u5b50CA\u8bc1\u4e66\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5{}", (Object)bindingResult.getAllErrors().toString());
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            int loginResult;
            createP10VO.setAlg(Constants.BASE_ALG_TYPE);
            Result result = this.localCaService.createP10(createP10VO);
            StringBuilder content = new StringBuilder();
            if (!result.isSuccess()) {
                loginResult = AuditLogResultEnum.FAIL.id;
                content.append("\u751f\u6210\u5b50CA\u7533\u8bf7\u4e66\u5931\u8d25,\u8bc1\u4e66\u89d2\u8272=").append(CertTypeEnum.SUB_CA_CERT.desc);
            } else {
                loginResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u751f\u6210\u5b50CA\u7533\u8bf7\u4e66\u6210\u529f,\u8bc1\u4e66\u89d2\u8272=").append(CertTypeEnum.SUB_CA_CERT.desc).append(",\u8bc1\u4e66DN=").append(createP10VO.getDn());
            }
            this.logger.info(content.toString());
            try {
                boolean flag = this.auditLogService.save(AuditLogOperatorTypeEnum.P10_GENERATE.type, content.toString(), loginResult, bean.getSign());
                if (!flag) {
                    this.logger.error("\u8bb0\u5f55-\u751f\u6210\u5b50CA\u7533\u8bf7\u4e66-\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55-\u751f\u6210\u5b50CA\u7533\u8bf7\u4e66-\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210\u5b50CA\u7533\u8bf7\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/cert/rootca"}, method={RequestMethod.PUT})
    public Object updateRootCert(@Valid @RequestBody UpdateRootCertVO updateRootCertVO, AuditSignBean bean, BindingResult bindingResult, HttpServletRequest request, HttpServletResponse resp) {
        this.logger.info("\u672c\u673aCA\u8bc1\u4e66\u7ba1\u7406\u6a21\u5757>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u66f4\u65b0\u6839\u8bc1\u4e66");
        if (null == updateRootCertVO || bindingResult.hasErrors()) {
            this.logger.debug("\u66f4\u65b0\u6839CA\u8bc1\u4e66\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5{}", (Object)bindingResult.getAllErrors().toString());
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            int loginResult;
            Result result = this.localCaService.updateRootCert(updateRootCertVO);
            StringBuilder content = new StringBuilder();
            if (!result.isSuccess()) {
                loginResult = AuditLogResultEnum.FAIL.id;
                content.append("\u66f4\u65b0\u6839CA\u8bc1\u4e66\u5931\u8d25,\u8bc1\u4e66\u89d2\u8272=").append(CertTypeEnum.CA_CERT.desc).append(",\u8bc1\u4e66SN=").append(updateRootCertVO.getSn());
            } else {
                loginResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u66f4\u65b0\u6839CA\u8bc1\u4e66\u6210\u529f,\u8bc1\u4e66\u89d2\u8272=").append(CertTypeEnum.CA_CERT.desc).append(",\u8bc1\u4e66SN=").append(updateRootCertVO.getSn()).append(",\u8bc1\u4e66DN=").append(result.getAuditContent());
            }
            this.logger.info(content.toString());
            try {
                boolean flag = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_UPDATE.type, content.toString(), loginResult, bean.getSign());
                if (!flag) {
                    this.logger.error("\u8bb0\u5f55-\u66f4\u65b0\u6839CA\u8bc1\u4e66-\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55-\u66f4\u65b0\u6839CA\u8bc1\u4e66-\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            try {
                TomcatUtil.restart();
            }
            catch (Exception e) {
                this.logger.error("\u91cd\u542ftomcat\u5931\u8d25", (Throwable)e);
                return Result.failure((ErrorEnum)ErrorEnum.REBOOT_SERVICE_FAIL);
            }
            return Result.success().isSuccess();
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u8ddfCA\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @RequestMapping(value={"/v1/cert/ca"}, method={RequestMethod.GET})
    public Object viewCertDetail(HttpServletResponse resp) {
        this.logger.info("\u672c\u673aCA\u8bc1\u4e66\u7ba1\u7406\u6a21\u5757>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u67e5\u770b\u8bc1\u4e66\u8be6\u60c5");
        try {
            Result result = this.localCaService.viewCertDetail();
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            return result.getInfo();
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u770b\u8bc1\u4e66\u8be6\u60c5\u5931\u8d25");
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }

    @AuditSign
    @RequestMapping(value={"/v1/cert/subca"}, method={RequestMethod.POST})
    public Object importCertChain(@RequestParam MultipartFile certChain, AuditSignBean bean, HttpServletRequest request, HttpServletResponse resp) {
        this.logger.info("\u672c\u673aCA\u8bc1\u4e66\u7ba1\u7406\u6a21\u5757>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u5bfc\u5165CA\u8bc1\u4e66");
        if (null == certChain || certChain.isEmpty() || !certChain.getOriginalFilename().endsWith(".p7b")) {
            this.logger.debug("\u5bfc\u5165\u8bc1\u4e66\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5{}", (Object)certChain);
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            int loginResult;
            Result result = this.localCaService.importCertChain(certChain.getBytes());
            StringBuilder content = new StringBuilder();
            if (!result.isSuccess()) {
                loginResult = AuditLogResultEnum.FAIL.id;
                content.append("\u5bfc\u5165\u8bc1\u4e66\u94fe\u5931\u8d25,\u64cd\u4f5c\u8005IP=").append(bean.getIp() + ",\u8bc1\u4e66SN=").append(bean.getSn()).append(",\u5bc6\u94a5\u7b97\u6cd5=").append(bean.getKeyAlg());
            } else {
                loginResult = AuditLogResultEnum.SUCCESS.id;
                content.append("\u5bfc\u5165\u8bc1\u4e66\u94fe\u5931\u8d25,\u64cd\u4f5c\u8005IP=").append(bean.getIp() + ",\u8bc1\u4e66SN=").append(bean.getSn()).append(",\u5bc6\u94a5\u7b97\u6cd5=").append(bean.getKeyAlg());
            }
            this.logger.info(content.toString());
            try {
                boolean flag = this.auditLogService.save(AuditLogOperatorTypeEnum.CERT_IMPORT.type, content.toString(), loginResult, bean.getSign());
                if (!flag) {
                    this.logger.error("\u8bb0\u5f55-\u5bfc\u5165\u8bc1\u4e66\u94fe-\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25");
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bb0\u5f55-\u5bfc\u5165\u8bc1\u4e66\u94fe-\u5ba1\u8ba1\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            }
            if (!result.isSuccess()) {
                return result.getError().resp(resp);
            }
            try {
                TomcatUtil.restart();
            }
            catch (Exception e) {
                this.logger.error("\u91cd\u542ftomcat\u5931\u8d25", (Throwable)e);
                return Result.failure((ErrorEnum)ErrorEnum.REBOOT_SERVICE_FAIL);
            }
            return Result.success().isSuccess();
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u5165\u8bc1\u4e66\u94fe\u5931\u8d25", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
    }
}

